/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.SubscriptionManager;
import android.telephony.cdma.CdmaSmsCbProgramData;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.WakeLockStateMachine;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.cdma.sms.BearerData;
import com.android.internal.telephony.cdma.sms.CdmaSmsAddress;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public final class CdmaServiceCategoryProgramHandler
extends WakeLockStateMachine {
    final CommandsInterface mCi;
    private final BroadcastReceiver mScpResultsReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            this.sendScpResults();
            CdmaServiceCategoryProgramHandler.this.log("mScpResultsReceiver finished");
            if (CdmaServiceCategoryProgramHandler.this.mReceiverCount.decrementAndGet() == 0) {
                CdmaServiceCategoryProgramHandler.this.sendMessage(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendScpResults() {
            int resultCode = this.getResultCode();
            if (resultCode != -1 && resultCode != 1) {
                CdmaServiceCategoryProgramHandler.this.loge("SCP results error: result code = " + resultCode);
                return;
            }
            Bundle extras = this.getResultExtras(false);
            if (extras == null) {
                CdmaServiceCategoryProgramHandler.this.loge("SCP results error: missing extras");
                return;
            }
            String sender = extras.getString("sender");
            if (sender == null) {
                CdmaServiceCategoryProgramHandler.this.loge("SCP results error: missing sender extra.");
                return;
            }
            ArrayList results = extras.getParcelableArrayList("results");
            if (results == null) {
                CdmaServiceCategoryProgramHandler.this.loge("SCP results error: missing results extra.");
                return;
            }
            BearerData bData = new BearerData();
            bData.messageType = 2;
            bData.messageId = SmsMessage.getNextMessageId();
            bData.serviceCategoryProgramResults = results;
            byte[] encodedBearerData = BearerData.encode(bData);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                dos.writeInt(4102);
                dos.writeInt(0);
                dos.writeInt(0);
                CdmaSmsAddress destAddr = CdmaSmsAddress.parse(PhoneNumberUtils.cdmaCheckAndProcessPlusCodeForSms(sender));
                dos.write(destAddr.digitMode);
                dos.write(destAddr.numberMode);
                dos.write(destAddr.ton);
                dos.write(destAddr.numberPlan);
                dos.write(destAddr.numberOfDigits);
                dos.write(destAddr.origBytes, 0, destAddr.origBytes.length);
                dos.write(0);
                dos.write(0);
                dos.write(0);
                dos.write(encodedBearerData.length);
                dos.write(encodedBearerData, 0, encodedBearerData.length);
                CdmaServiceCategoryProgramHandler.this.mCi.sendCdmaSms(baos.toByteArray(), null);
            }
            catch (IOException e) {
                CdmaServiceCategoryProgramHandler.this.loge("exception creating SCP results PDU", e);
            }
            finally {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }
    };

    CdmaServiceCategoryProgramHandler(Context context, CommandsInterface commandsInterface) {
        super("CdmaServiceCategoryProgramHandler", context, null);
        this.mContext = context;
        this.mCi = commandsInterface;
    }

    static CdmaServiceCategoryProgramHandler makeScpHandler(Context context, CommandsInterface commandsInterface) {
        CdmaServiceCategoryProgramHandler handler = new CdmaServiceCategoryProgramHandler(context, commandsInterface);
        handler.start();
        return handler;
    }

    @Override
    protected boolean handleSmsMessage(Message message) {
        if (message.obj instanceof SmsMessage) {
            return this.handleServiceCategoryProgramData((SmsMessage)message.obj);
        }
        this.loge("handleMessage got object of type: " + message.obj.getClass().getName());
        return false;
    }

    private boolean handleServiceCategoryProgramData(SmsMessage sms) {
        ArrayList<CdmaSmsCbProgramData> programDataList = sms.getSmsCbProgramData();
        if (programDataList == null) {
            this.loge("handleServiceCategoryProgramData: program data list is null!");
            return false;
        }
        Intent intent = new Intent("android.provider.Telephony.SMS_SERVICE_CATEGORY_PROGRAM_DATA_RECEIVED");
        intent.putExtra("sender", sms.getOriginatingAddress());
        intent.putParcelableArrayListExtra("program_data", programDataList);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
        String[] pkgs = this.mContext.getResources().getStringArray(17236002);
        this.mReceiverCount.addAndGet(pkgs.length);
        for (String pkg : pkgs) {
            intent.setPackage(pkg);
            this.mContext.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS", 16, this.mScpResultsReceiver, this.getHandler(), -1, null, null);
        }
        return true;
    }
}

