/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.provider.Settings;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import java.util.concurrent.atomic.AtomicInteger;

public class CdmaSubscriptionSourceManager
extends Handler {
    static final String LOG_TAG = "CdmaSSM";
    private static final int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 1;
    private static final int EVENT_GET_CDMA_SUBSCRIPTION_SOURCE = 2;
    private static final int EVENT_RADIO_ON = 3;
    private static final int EVENT_SUBSCRIPTION_STATUS_CHANGED = 4;
    private static final int SUBSCRIPTION_ACTIVATED = 1;
    public static final int SUBSCRIPTION_SOURCE_UNKNOWN = -1;
    public static final int SUBSCRIPTION_FROM_RUIM = 0;
    public static final int SUBSCRIPTION_FROM_NV = 1;
    private static CdmaSubscriptionSourceManager sInstance;
    private static final Object sReferenceCountMonitor;
    private static int sReferenceCount;
    private CommandsInterface mCi;
    private RegistrantList mCdmaSubscriptionSourceChangedRegistrants = new RegistrantList();
    private AtomicInteger mCdmaSubscriptionSource = new AtomicInteger(0);

    private CdmaSubscriptionSourceManager(Context context, CommandsInterface ci) {
        this.mCi = ci;
        this.mCi.registerForCdmaSubscriptionChanged(this, 1, null);
        this.mCi.registerForOn(this, 3, null);
        int subscriptionSource = CdmaSubscriptionSourceManager.getDefault(context);
        this.log("cdmaSSM constructor: " + subscriptionSource);
        this.mCdmaSubscriptionSource.set(subscriptionSource);
        this.mCi.registerForSubscriptionStatusChanged(this, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static CdmaSubscriptionSourceManager getInstance(Context context, CommandsInterface ci, Handler h, int what, Object obj) {
        Object object = sReferenceCountMonitor;
        synchronized (object) {
            if (null == sInstance) {
                sInstance = new CdmaSubscriptionSourceManager(context, ci);
            }
            ++sReferenceCount;
        }
        sInstance.registerForCdmaSubscriptionSourceChanged(h, what, obj);
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Handler h) {
        this.mCdmaSubscriptionSourceChangedRegistrants.remove(h);
        Object object = sReferenceCountMonitor;
        synchronized (object) {
            if (--sReferenceCount <= 0) {
                this.mCi.unregisterForCdmaSubscriptionChanged(this);
                this.mCi.unregisterForOn(this);
                this.mCi.unregisterForSubscriptionStatusChanged(this);
                sInstance = null;
            }
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: 
            case 2: {
                this.log("CDMA_SUBSCRIPTION_SOURCE event = " + msg.what);
                AsyncResult ar = (AsyncResult)msg.obj;
                this.handleGetCdmaSubscriptionSource(ar);
                break;
            }
            case 3: {
                this.mCi.getCdmaSubscriptionSource(this.obtainMessage(2));
                break;
            }
            case 4: {
                this.log("EVENT_SUBSCRIPTION_STATUS_CHANGED");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    int actStatus = ((int[])ar.result)[0];
                    this.log("actStatus = " + actStatus);
                    if (actStatus != 1) break;
                    Rlog.v(LOG_TAG, "get Cdma Subscription Source");
                    this.mCi.getCdmaSubscriptionSource(this.obtainMessage(2));
                    break;
                }
                this.logw("EVENT_SUBSCRIPTION_STATUS_CHANGED, Exception:" + ar.exception);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    @UnsupportedAppUsage
    public int getCdmaSubscriptionSource() {
        this.log("getcdmasubscriptionSource: " + this.mCdmaSubscriptionSource.get());
        return this.mCdmaSubscriptionSource.get();
    }

    public static int getDefault(Context context) {
        int subscriptionSource = Settings.Global.getInt(context.getContentResolver(), "subscription_mode", 0);
        Rlog.d(LOG_TAG, "subscriptionSource from settings: " + subscriptionSource);
        return subscriptionSource;
    }

    private void registerForCdmaSubscriptionSourceChanged(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mCdmaSubscriptionSourceChangedRegistrants.add(r);
    }

    private void handleGetCdmaSubscriptionSource(AsyncResult ar) {
        if (ar.exception == null && ar.result != null) {
            int newSubscriptionSource = ((int[])ar.result)[0];
            if (newSubscriptionSource != this.mCdmaSubscriptionSource.get()) {
                this.log("Subscription Source Changed : " + this.mCdmaSubscriptionSource + " >> " + newSubscriptionSource);
                this.mCdmaSubscriptionSource.set(newSubscriptionSource);
                this.mCdmaSubscriptionSourceChangedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
            }
        } else {
            this.logw("Unable to get CDMA Subscription Source, Exception: " + ar.exception + ", result: " + ar.result);
        }
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, s);
    }

    private void logw(String s) {
        Rlog.w(LOG_TAG, s);
    }

    static {
        sReferenceCountMonitor = new Object();
        sReferenceCount = 0;
    }
}

