/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdnr;

import android.os.PersistableBundle;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.cdnr.EfData;
import com.android.internal.telephony.uicc.IccRecords;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CarrierConfigEfData
implements EfData {
    private static final String TAG = "CarrierConfigEfData";
    private final PersistableBundle mConfig;

    public CarrierConfigEfData(PersistableBundle config) {
        this.mConfig = config;
    }

    @Override
    public String getServiceProviderName() {
        String spn = this.mConfig.getString("carrier_name_string");
        if (TextUtils.isEmpty(spn)) {
            return null;
        }
        return spn;
    }

    @Override
    public int getServiceProviderNameDisplayCondition() {
        int condition = this.mConfig.getInt("spn_display_condition_override_int", -1);
        return condition;
    }

    @Override
    public List<String> getServiceProviderDisplayInformation() {
        String[] spdi = this.mConfig.getStringArray("spdi_override_string_array");
        return spdi != null ? Arrays.asList(spdi) : null;
    }

    @Override
    public List<String> getEhplmnList() {
        String[] ehplmn = this.mConfig.getStringArray("ehplmn_override_string_array");
        return ehplmn != null ? Arrays.asList(ehplmn) : null;
    }

    @Override
    public List<IccRecords.PlmnNetworkName> getPlmnNetworkNameList() {
        String[] pnn = this.mConfig.getStringArray("pnn_override_string_array");
        ArrayList<IccRecords.PlmnNetworkName> pnnList = null;
        if (pnn != null) {
            pnnList = new ArrayList<IccRecords.PlmnNetworkName>(pnn.length);
            for (String pnnStr : pnn) {
                try {
                    String[] names = pnnStr.split("\\s*,\\s*");
                    String alphal = names[0];
                    String alphas = names.length > 1 ? names[1] : "";
                    pnnList.add(new IccRecords.PlmnNetworkName(alphal, alphas));
                }
                catch (Exception ex) {
                    Rlog.e(TAG, "CarrierConfig wrong pnn format, pnnStr = " + pnnStr);
                }
            }
        }
        return pnnList;
    }

    @Override
    public List<IccRecords.OperatorPlmnInfo> getOperatorPlmnList() {
        String[] opl = this.mConfig.getStringArray("opl_override_opl_string_array");
        ArrayList<IccRecords.OperatorPlmnInfo> oplList = null;
        if (opl != null) {
            oplList = new ArrayList<IccRecords.OperatorPlmnInfo>(opl.length);
            for (String oplStr : opl) {
                try {
                    String[] info = oplStr.split("\\s*,\\s*");
                    oplList.add(new IccRecords.OperatorPlmnInfo(info[0], Integer.parseInt(info[1]), Integer.parseInt(info[2]), Integer.parseInt(info[3])));
                }
                catch (Exception ex) {
                    Rlog.e(TAG, "CarrierConfig wrong opl format, oplStr = " + oplStr);
                }
            }
        }
        return oplList;
    }
}

