/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdnr;

import android.content.Context;
import android.content.res.Resources;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.SparseArray;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.cdnr.BrandOverrideEfData;
import com.android.internal.telephony.cdnr.CarrierConfigEfData;
import com.android.internal.telephony.cdnr.CarrierDisplayNameData;
import com.android.internal.telephony.cdnr.EfData;
import com.android.internal.telephony.cdnr.EriEfData;
import com.android.internal.telephony.cdnr.RuimEfData;
import com.android.internal.telephony.cdnr.UsimEfData;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.RuimRecords;
import com.android.internal.telephony.uicc.SIMRecords;
import com.android.internal.util.IndentingPrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class CarrierDisplayNameResolver {
    private static final boolean DBG = true;
    private static final String TAG = "CDNR";
    private static final int DEFAULT_CARRIER_NAME_DISPLAY_CONDITION_BITMASK = 0;
    private static final CarrierDisplayNameConditionRule DEFAULT_CARRIER_DISPLAY_NAME_RULE = new CarrierDisplayNameConditionRule(0);
    private final SparseArray<EfData> mEf = new SparseArray();
    private final LocalLog mLocalLog = new LocalLog(32);
    private final Context mContext;
    private final GsmCdmaPhone mPhone;
    private final CarrierConfigManager mCCManager;
    private CarrierDisplayNameData mCarrierDisplayNameData;
    private static final List<Integer> EF_SOURCE_PRIORITY = Arrays.asList(2, 1, 10, 3, 4, 5, 6, 7, 8, 9);

    public CarrierDisplayNameResolver(GsmCdmaPhone phone) {
        this.mContext = phone.getContext();
        this.mPhone = phone;
        this.mCCManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
    }

    public void updateEfFromRuim(RuimRecords ruim) {
        int key = CarrierDisplayNameResolver.getSourcePriority(6);
        if (ruim == null) {
            this.mEf.remove(key);
        } else {
            this.mEf.put(key, new RuimEfData(ruim));
        }
    }

    public void updateEfFromUsim(SIMRecords usim) {
        int key = CarrierDisplayNameResolver.getSourcePriority(3);
        if (usim == null) {
            this.mEf.remove(key);
        } else {
            this.mEf.put(key, new UsimEfData(usim));
        }
    }

    public void updateEfFromCarrierConfig(PersistableBundle config) {
        int key = CarrierDisplayNameResolver.getSourcePriority(1);
        if (config == null) {
            this.mEf.remove(key);
        } else {
            this.mEf.put(key, new CarrierConfigEfData(config));
        }
    }

    public void updateEfForEri(String eriText) {
        PersistableBundle config = this.getCarrierConfig();
        int key = CarrierDisplayNameResolver.getSourcePriority(10);
        if (!TextUtils.isEmpty(eriText) && (this.mPhone.isPhoneTypeCdma() || this.mPhone.isPhoneTypeCdmaLte()) && config.getBoolean("allow_cdma_eri_bool")) {
            this.mEf.put(key, new EriEfData(eriText));
        } else {
            this.mEf.remove(key);
        }
    }

    public void updateEfForBrandOverride(String operatorName) {
        int key = CarrierDisplayNameResolver.getSourcePriority(2);
        if (TextUtils.isEmpty(operatorName)) {
            this.mEf.remove(key);
        } else {
            this.mEf.put(key, new BrandOverrideEfData(operatorName, this.getServiceState().getOperatorNumeric()));
        }
    }

    public CarrierDisplayNameData getCarrierDisplayNameData() {
        this.resolveCarrierDisplayName();
        return this.mCarrierDisplayNameData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mEf.size(); ++i) {
            EfData p = this.mEf.valueAt(i);
            sb.append("{spnDisplayCondition = " + p.getServiceProviderNameDisplayCondition() + ", spn = " + p.getServiceProviderName() + ", spdiList = " + p.getServiceProviderDisplayInformation() + ", pnnList = " + p.getPlmnNetworkNameList() + ", oplList = " + p.getOperatorPlmnList() + ", ehplmn = " + p.getEhplmnList() + "}, ");
        }
        sb.append(", roamingFromSS = " + this.getServiceState().getRoaming());
        sb.append(", registeredPLMN = " + this.getServiceState().getOperatorNumeric());
        return sb.toString();
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("CDNR:");
        pw.increaseIndent();
        pw.println("fields = " + this.toString());
        pw.println("carrierDisplayNameData = " + this.mCarrierDisplayNameData);
        pw.decreaseIndent();
        pw.println("CDNR local log:");
        pw.increaseIndent();
        this.mLocalLog.dump(pw);
        pw.decreaseIndent();
    }

    private PersistableBundle getCarrierConfig() {
        PersistableBundle config = this.mCCManager.getConfigForSubId(this.mPhone.getSubId());
        if (config == null) {
            config = CarrierConfigManager.getDefaultConfig();
        }
        return config;
    }

    private CarrierDisplayNameConditionRule getDisplayRule() {
        for (int i = 0; i < this.mEf.size(); ++i) {
            if (this.mEf.valueAt(i).getServiceProviderNameDisplayCondition() == -1) continue;
            return new CarrierDisplayNameConditionRule(this.mEf.valueAt(i).getServiceProviderNameDisplayCondition());
        }
        return DEFAULT_CARRIER_DISPLAY_NAME_RULE;
    }

    private List<String> getEfSpdi() {
        for (int i = 0; i < this.mEf.size(); ++i) {
            if (this.mEf.valueAt(i).getServiceProviderDisplayInformation() == null) continue;
            return this.mEf.valueAt(i).getServiceProviderDisplayInformation();
        }
        return Collections.EMPTY_LIST;
    }

    private String getEfSpn() {
        for (int i = 0; i < this.mEf.size(); ++i) {
            if (TextUtils.isEmpty(this.mEf.valueAt(i).getServiceProviderName())) continue;
            return this.mEf.valueAt(i).getServiceProviderName();
        }
        return "";
    }

    private List<IccRecords.OperatorPlmnInfo> getEfOpl() {
        for (int i = 0; i < this.mEf.size(); ++i) {
            if (this.mEf.valueAt(i).getOperatorPlmnList() == null) continue;
            return this.mEf.valueAt(i).getOperatorPlmnList();
        }
        return Collections.EMPTY_LIST;
    }

    private List<IccRecords.PlmnNetworkName> getEfPnn() {
        for (int i = 0; i < this.mEf.size(); ++i) {
            if (this.mEf.valueAt(i).getPlmnNetworkNameList() == null) continue;
            return this.mEf.valueAt(i).getPlmnNetworkNameList();
        }
        return Collections.EMPTY_LIST;
    }

    private CarrierDisplayNameData getCarrierDisplayNameFromEf() {
        CarrierDisplayNameConditionRule displayRule = this.getDisplayRule();
        String registeredPlmnNumeric = this.getServiceState().getOperatorNumeric();
        List<String> efSpdi = this.getEfSpdi();
        boolean isRoaming = this.getServiceState().getRoaming() && !efSpdi.contains(registeredPlmnNumeric);
        boolean showSpn = displayRule.shouldShowSpn(isRoaming);
        boolean showPlmn = displayRule.shouldShowPnn(isRoaming);
        String spn = this.getEfSpn();
        List<IccRecords.OperatorPlmnInfo> efOpl = this.getEfOpl();
        List<IccRecords.PlmnNetworkName> efPnn = this.getEfPnn();
        String plmn = null;
        if (efOpl.isEmpty()) {
            String string2 = plmn = efPnn.isEmpty() ? "" : CarrierDisplayNameResolver.getPlmnNetworkName(efPnn.get(0));
        }
        if (TextUtils.isEmpty(plmn)) {
            plmn = registeredPlmnNumeric;
        }
        return new CarrierDisplayNameData.Builder().setSpn(spn).setShowSpn(showSpn).setPlmn(plmn).setShowPlmn(showPlmn).build();
    }

    private CarrierDisplayNameData getCarrierDisplayNameFromWifiCallingOverride(CarrierDisplayNameData rawCarrierDisplayNameData) {
        PersistableBundle config = this.getCarrierConfig();
        boolean useRootLocale = config.getBoolean("wfc_spn_use_root_locale");
        Resources r = this.mContext.getResources();
        if (useRootLocale) {
            r.getConfiguration().setLocale(Locale.ROOT);
        }
        String[] wfcSpnFormats = r.getStringArray(17236116);
        WfcCarrierNameFormatter wfcFormatter = new WfcCarrierNameFormatter(config, wfcSpnFormats, this.getServiceState().getVoiceRegState() == 3);
        String wfcSpn = wfcFormatter.formatVoiceName(rawCarrierDisplayNameData.getSpn());
        String wfcDataSpn = wfcFormatter.formatDataName(rawCarrierDisplayNameData.getSpn());
        String wfcPlmn = wfcFormatter.formatVoiceName(rawCarrierDisplayNameData.getPlmn());
        CarrierDisplayNameData result = rawCarrierDisplayNameData;
        if (!TextUtils.isEmpty(wfcSpn) && !TextUtils.isEmpty(wfcDataSpn)) {
            result = new CarrierDisplayNameData.Builder().setSpn(wfcSpn).setDataSpn(wfcDataSpn).setShowSpn(true).build();
        } else if (!TextUtils.isEmpty(wfcPlmn)) {
            result = new CarrierDisplayNameData.Builder().setPlmn(wfcPlmn).setShowPlmn(true).build();
        }
        return result;
    }

    private CarrierDisplayNameData getOutOfServiceDisplayName(CarrierDisplayNameData data) {
        String plmn = null;
        boolean isSimReady = this.mPhone.getUiccCardApplication() != null && this.mPhone.getUiccCardApplication().getState() == IccCardApplicationStatus.AppState.APPSTATE_READY;
        boolean forceDisplayNoService = this.mContext.getResources().getBoolean(17891414) && !isSimReady;
        ServiceState ss = this.getServiceState();
        plmn = ss.getVoiceRegState() == 3 || !ss.isEmergencyOnly() || forceDisplayNoService ? this.mContext.getResources().getString(17040246) : this.mContext.getResources().getString(17039896);
        return new CarrierDisplayNameData.Builder().setSpn(data.getSpn()).setDataSpn(data.getDataSpn()).setShowSpn(data.shouldShowSpn()).setPlmn(plmn).setShowPlmn(true).build();
    }

    private void resolveCarrierDisplayName() {
        CarrierDisplayNameData data = this.getCarrierDisplayNameFromEf();
        Rlog.d(TAG, "CarrierName from EF: " + data);
        if (CarrierDisplayNameResolver.getCombinedRegState(this.getServiceState()) == 0) {
            if (this.mPhone.isWifiCallingEnabled()) {
                data = this.getCarrierDisplayNameFromWifiCallingOverride(data);
                Rlog.d(TAG, "CarrierName override by wifi-calling " + data);
            }
        } else {
            data = this.getOutOfServiceDisplayName(data);
            Rlog.d(TAG, "Out of service carrierName " + data);
        }
        if (!Objects.equals(this.mCarrierDisplayNameData, data)) {
            this.mLocalLog.log(String.format("ResolveCarrierDisplayName: %s", data.toString()));
        }
        this.mCarrierDisplayNameData = data;
    }

    private static String getPlmnNetworkName(IccRecords.PlmnNetworkName name) {
        if (name == null) {
            return "";
        }
        if (!TextUtils.isEmpty(name.fullName)) {
            return name.fullName;
        }
        if (!TextUtils.isEmpty(name.shortName)) {
            return name.shortName;
        }
        return "";
    }

    private static int getSourcePriority(int source) {
        int priority = EF_SOURCE_PRIORITY.indexOf(source);
        if (priority == -1) {
            priority = Integer.MAX_VALUE;
        }
        return priority;
    }

    private ServiceState getServiceState() {
        return this.mPhone.getServiceStateTracker().getServiceState();
    }

    private static int getCombinedRegState(ServiceState ss) {
        if (ss.getVoiceRegState() != 0) {
            return ss.getDataRegState();
        }
        return ss.getVoiceRegState();
    }

    private static final class WfcCarrierNameFormatter {
        final String mVoiceFormat;
        final String mDataFormat;

        WfcCarrierNameFormatter(PersistableBundle config, String[] wfcFormats, boolean inFlightMode) {
            int voiceIdx = config.getInt("wfc_spn_format_idx_int");
            int dataIdx = config.getInt("wfc_data_spn_format_idx_int");
            int flightModeIdx = config.getInt("wfc_flight_mode_spn_format_idx_int");
            if (voiceIdx < 0 || voiceIdx >= wfcFormats.length) {
                Rlog.e(CarrierDisplayNameResolver.TAG, "updateSpnDisplay: KEY_WFC_SPN_FORMAT_IDX_INT out of bounds: " + voiceIdx);
                voiceIdx = 0;
            }
            if (dataIdx < 0 || dataIdx >= wfcFormats.length) {
                Rlog.e(CarrierDisplayNameResolver.TAG, "updateSpnDisplay: KEY_WFC_DATA_SPN_FORMAT_IDX_INT out of bounds: " + dataIdx);
                dataIdx = 0;
            }
            if (flightModeIdx < 0 || flightModeIdx >= wfcFormats.length) {
                flightModeIdx = voiceIdx;
            }
            if (inFlightMode) {
                voiceIdx = flightModeIdx;
            }
            this.mVoiceFormat = voiceIdx != -1 ? wfcFormats[voiceIdx] : "";
            this.mDataFormat = dataIdx != -1 ? wfcFormats[dataIdx] : "";
        }

        public String formatVoiceName(String name) {
            if (TextUtils.isEmpty(name)) {
                return name;
            }
            return String.format(this.mVoiceFormat, name.trim());
        }

        public String formatDataName(String name) {
            if (TextUtils.isEmpty(name)) {
                return name;
            }
            return String.format(this.mDataFormat, name.trim());
        }
    }

    private static final class CarrierDisplayNameConditionRule {
        private int mDisplayConditionBitmask;

        CarrierDisplayNameConditionRule(int carrierDisplayConditionBitmask) {
            this.mDisplayConditionBitmask = carrierDisplayConditionBitmask;
        }

        boolean shouldShowSpn(boolean isRoaming) {
            return !isRoaming || (this.mDisplayConditionBitmask & 2) == 2;
        }

        boolean shouldShowPnn(boolean isRoaming) {
            return isRoaming || (this.mDisplayConditionBitmask & 1) == 1;
        }

        public String toString() {
            return String.format("{ SPN_bit = %d, PLMN_bit = %d }", this.mDisplayConditionBitmask & 2, this.mDisplayConditionBitmask & 1);
        }
    }
}

