/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdnr;

import android.text.TextUtils;
import com.android.internal.telephony.cdnr.EfData;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.SIMRecords;
import java.util.Arrays;
import java.util.List;

public final class UsimEfData
implements EfData {
    private final SIMRecords mUsim;

    public UsimEfData(SIMRecords usim) {
        this.mUsim = usim;
    }

    @Override
    public String getServiceProviderName() {
        String spn = this.mUsim.getServiceProviderName();
        if (TextUtils.isEmpty(spn)) {
            spn = null;
        }
        return spn;
    }

    @Override
    public int getServiceProviderNameDisplayCondition() {
        return this.mUsim.getCarrierNameDisplayCondition();
    }

    @Override
    public List<String> getServiceProviderDisplayInformation() {
        String[] spdi = this.mUsim.getServiceProviderDisplayInformation();
        return spdi != null ? Arrays.asList(spdi) : null;
    }

    @Override
    public List<String> getEhplmnList() {
        String[] ehplmns = this.mUsim.getEhplmns();
        return ehplmns != null ? Arrays.asList(ehplmns) : null;
    }

    @Override
    public List<IccRecords.PlmnNetworkName> getPlmnNetworkNameList() {
        String pnnHomeName = this.mUsim.getPnnHomeName();
        if (!TextUtils.isEmpty(pnnHomeName)) {
            return Arrays.asList(new IccRecords.PlmnNetworkName(pnnHomeName, ""));
        }
        return null;
    }

    @Override
    public List<IccRecords.OperatorPlmnInfo> getOperatorPlmnList() {
        return null;
    }
}

