/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.os.UserHandle;
import android.telephony.AccessNetworkConstants;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.data.ApnSetting;
import android.telephony.data.IQualifiedNetworksService;
import android.telephony.data.IQualifiedNetworksServiceCallback;
import android.text.TextUtils;
import android.util.SparseArray;
import com.android.internal.telephony.Phone;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AccessNetworksManager
extends Handler {
    private static final String TAG = AccessNetworksManager.class.getSimpleName();
    private static final boolean DBG = false;
    private static final int[] SUPPORTED_APN_TYPES = new int[]{17, 2, 32, 64, 128, 4, 512};
    private static final int EVENT_BIND_QUALIFIED_NETWORKS_SERVICE = 1;
    private final Phone mPhone;
    private final CarrierConfigManager mCarrierConfigManager;
    private IQualifiedNetworksService mIQualifiedNetworksService;
    private AccessNetworksManagerDeathRecipient mDeathRecipient;
    private String mTargetBindingPackageName;
    private QualifiedNetworksServiceConnection mServiceConnection;
    private final SparseArray<int[]> mAvailableNetworks = new SparseArray();
    private final RegistrantList mQualifiedNetworksChangedRegistrants = new RegistrantList();
    private final BroadcastReceiver mConfigChangedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.telephony.action.CARRIER_CONFIG_CHANGED".equals(action) && AccessNetworksManager.this.mPhone.getPhoneId() == intent.getIntExtra("android.telephony.extra.SLOT_INDEX", 0)) {
                AccessNetworksManager.this.sendEmptyMessage(1);
            }
        }
    };

    public AccessNetworksManager(Phone phone) {
        this.mPhone = phone;
        this.mCarrierConfigManager = (CarrierConfigManager)phone.getContext().getSystemService("carrier_config");
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        phone.getContext().registerReceiverAsUser(this.mConfigChangedReceiver, UserHandle.ALL, intentFilter, null, null);
        this.sendEmptyMessage(1);
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.bindQualifiedNetworksService();
                break;
            }
            default: {
                this.loge("Unhandled event " + msg.what);
            }
        }
    }

    private void bindQualifiedNetworksService() {
        String packageName = this.getQualifiedNetworksServicePackageName();
        if (TextUtils.isEmpty(packageName)) {
            this.loge("Can't find the binding package");
            return;
        }
        if (TextUtils.equals(packageName, this.mTargetBindingPackageName)) {
            return;
        }
        if (this.mIQualifiedNetworksService != null && this.mIQualifiedNetworksService.asBinder().isBinderAlive()) {
            try {
                this.mIQualifiedNetworksService.removeNetworkAvailabilityProvider(this.mPhone.getPhoneId());
            }
            catch (RemoteException e) {
                this.loge("Cannot remove network availability updater. " + e);
            }
            this.mPhone.getContext().unbindService(this.mServiceConnection);
        }
        try {
            this.mServiceConnection = new QualifiedNetworksServiceConnection();
            this.log("bind to " + packageName);
            if (!this.mPhone.getContext().bindService(new Intent("android.telephony.data.QualifiedNetworksService").setPackage(packageName), this.mServiceConnection, 1)) {
                this.loge("Cannot bind to the qualified networks service.");
                return;
            }
            this.mTargetBindingPackageName = packageName;
        }
        catch (Exception e) {
            this.loge("Cannot bind to the qualified networks service. Exception: " + e);
        }
    }

    private String getQualifiedNetworksServicePackageName() {
        String carrierConfigPackageName;
        String packageName = this.mPhone.getContext().getResources().getString(17039765);
        PersistableBundle b = this.mCarrierConfigManager.getConfigForSubId(this.mPhone.getSubId());
        if (b != null && !TextUtils.isEmpty(carrierConfigPackageName = b.getString("carrier_qualified_networks_service_package_override_string"))) {
            packageName = carrierConfigPackageName;
        }
        return packageName;
    }

    private List<QualifiedNetworks> getQualifiedNetworksList() {
        ArrayList<QualifiedNetworks> qualifiedNetworksList = new ArrayList<QualifiedNetworks>();
        for (int i = 0; i < this.mAvailableNetworks.size(); ++i) {
            qualifiedNetworksList.add(new QualifiedNetworks(this.mAvailableNetworks.keyAt(i), this.mAvailableNetworks.valueAt(i)));
        }
        return qualifiedNetworksList;
    }

    public void registerForQualifiedNetworksChanged(Handler h, int what) {
        if (h != null) {
            Registrant r = new Registrant(h, what, null);
            this.mQualifiedNetworksChangedRegistrants.add(r);
            if (this.mAvailableNetworks.size() != 0) {
                r.notifyResult(this.getQualifiedNetworksList());
            }
        }
    }

    public void unregisterForQualifiedNetworksChanged(Handler h) {
        if (h != null) {
            this.mQualifiedNetworksChangedRegistrants.remove(h);
        }
    }

    public void dump(FileDescriptor fd, IndentingPrintWriter pw, String[] args) {
        pw.println("AccessNetworksManager:");
        pw.increaseIndent();
        pw.println("Available networks:");
        pw.increaseIndent();
        for (int i = 0; i < this.mAvailableNetworks.size(); ++i) {
            pw.println("APN type " + ApnSetting.getApnTypeString(this.mAvailableNetworks.keyAt(i)) + ": [" + Arrays.stream(this.mAvailableNetworks.valueAt(i)).mapToObj(type -> AccessNetworkConstants.AccessNetworkType.toString(type)).collect(Collectors.joining(",")) + "]");
        }
        pw.decreaseIndent();
        pw.decreaseIndent();
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    private void loge(String s) {
        Rlog.e(TAG, s);
    }

    private final class QualifiedNetworksServiceCallback
    extends IQualifiedNetworksServiceCallback.Stub {
        private QualifiedNetworksServiceCallback() {
        }

        @Override
        public void onQualifiedNetworkTypesChanged(int apnTypes, int[] qualifiedNetworkTypes) {
            AccessNetworksManager.this.log("onQualifiedNetworkTypesChanged. apnTypes = [" + ApnSetting.getApnTypesStringFromBitmask(apnTypes) + "], networks = [" + Arrays.stream(qualifiedNetworkTypes).mapToObj(i -> AccessNetworkConstants.AccessNetworkType.toString(i)).collect(Collectors.joining(",")) + "]");
            ArrayList<QualifiedNetworks> qualifiedNetworksList = new ArrayList<QualifiedNetworks>();
            for (int supportedApnType : SUPPORTED_APN_TYPES) {
                if ((apnTypes & supportedApnType) != supportedApnType) continue;
                if (AccessNetworksManager.this.mAvailableNetworks.get(supportedApnType) != null && Arrays.equals((int[])AccessNetworksManager.this.mAvailableNetworks.get(supportedApnType), qualifiedNetworkTypes)) {
                    AccessNetworksManager.this.log("Available networks for " + ApnSetting.getApnTypesStringFromBitmask(supportedApnType) + " not changed.");
                    continue;
                }
                AccessNetworksManager.this.mAvailableNetworks.put(supportedApnType, qualifiedNetworkTypes);
                qualifiedNetworksList.add(new QualifiedNetworks(supportedApnType, qualifiedNetworkTypes));
            }
            if (!qualifiedNetworksList.isEmpty()) {
                AccessNetworksManager.this.mQualifiedNetworksChangedRegistrants.notifyResult(qualifiedNetworksList);
            }
        }
    }

    private final class QualifiedNetworksServiceConnection
    implements ServiceConnection {
        private QualifiedNetworksServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            AccessNetworksManager.this.mIQualifiedNetworksService = IQualifiedNetworksService.Stub.asInterface(service);
            AccessNetworksManager.this.mDeathRecipient = new AccessNetworksManagerDeathRecipient();
            try {
                service.linkToDeath(AccessNetworksManager.this.mDeathRecipient, 0);
                AccessNetworksManager.this.mIQualifiedNetworksService.createNetworkAvailabilityProvider(AccessNetworksManager.this.mPhone.getPhoneId(), new QualifiedNetworksServiceCallback());
            }
            catch (RemoteException e) {
                AccessNetworksManager.this.mDeathRecipient.binderDied();
                AccessNetworksManager.this.loge("Remote exception. " + e);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            AccessNetworksManager.this.mIQualifiedNetworksService.asBinder().unlinkToDeath(AccessNetworksManager.this.mDeathRecipient, 0);
            AccessNetworksManager.this.mTargetBindingPackageName = null;
        }
    }

    private class AccessNetworksManagerDeathRecipient
    implements IBinder.DeathRecipient {
        private AccessNetworksManagerDeathRecipient() {
        }

        @Override
        public void binderDied() {
            AccessNetworksManager.this.loge("QualifiedNetworksService(" + AccessNetworksManager.this.mTargetBindingPackageName + ") died.");
        }
    }

    public static class QualifiedNetworks {
        public final int apnType;
        public final int[] qualifiedNetworks;

        public QualifiedNetworks(int apnType, int[] qualifiedNetworks) {
            this.apnType = apnType;
            this.qualifiedNetworks = qualifiedNetworks;
        }

        public String toString() {
            ArrayList<String> accessNetworkStrings = new ArrayList<String>();
            for (int network : this.qualifiedNetworks) {
                accessNetworkStrings.add(AccessNetworkConstants.AccessNetworkType.toString(network));
            }
            return "[QualifiedNetworks: apnType=" + ApnSetting.getApnTypeString(this.apnType) + ", networks=" + Arrays.stream(this.qualifiedNetworks).mapToObj(type -> AccessNetworkConstants.AccessNetworkType.toString(type)).collect(Collectors.joining(",")) + "]";
        }
    }
}

