/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.PendingIntent;
import android.net.NetworkCapabilities;
import android.net.NetworkConfig;
import android.net.NetworkRequest;
import android.os.Message;
import android.telephony.Rlog;
import android.telephony.data.ApnSetting;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.SparseIntArray;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.dataconnection.DataConnection;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ApnContext {
    public final String LOG_TAG;
    private static final String SLOG_TAG = "ApnContext";
    protected static final boolean DBG = false;
    private final Phone mPhone;
    private final String mApnType;
    private DctConstants.State mState;
    public final int priority;
    private ApnSetting mApnSetting;
    private DataConnection mDataConnection;
    String mReason;
    PendingIntent mReconnectAlarmIntent;
    AtomicBoolean mDataEnabled;
    private final Object mRefCountLock = new Object();
    private int mRefCount = 0;
    AtomicBoolean mDependencyMet;
    private final DcTracker mDcTracker;
    private boolean mConcurrentVoiceAndDataAllowed;
    private final AtomicInteger mConnectionGeneration = new AtomicInteger(0);
    private final RetryManager mRetryManager;
    private final LocalLog mLocalLog = new LocalLog(150);
    private final ArrayList<NetworkRequest> mNetworkRequests = new ArrayList();
    private final LocalLog mStateLocalLog = new LocalLog(50);
    private final SparseIntArray mRetriesLeftPerErrorCode = new SparseIntArray();

    public ApnContext(Phone phone, String apnType, String logTag, NetworkConfig config, DcTracker tracker) {
        this.mPhone = phone;
        this.mApnType = apnType;
        this.mState = DctConstants.State.IDLE;
        this.setReason("dataEnabled");
        this.mDataEnabled = new AtomicBoolean(false);
        this.mDependencyMet = new AtomicBoolean(config.dependencyMet);
        this.priority = config.priority;
        this.LOG_TAG = logTag;
        this.mDcTracker = tracker;
        this.mRetryManager = new RetryManager(phone, apnType);
    }

    public String getApnType() {
        return this.mApnType;
    }

    public int getApnTypeBitmask() {
        return ApnSetting.getApnTypesBitmaskFromString(this.mApnType);
    }

    public synchronized DataConnection getDataConnection() {
        return this.mDataConnection;
    }

    public synchronized void setDataConnection(DataConnection dc) {
        this.log("setDataConnectionAc: old=" + this.mDataConnection + ",new=" + dc + " this=" + this);
        this.mDataConnection = dc;
    }

    public synchronized void releaseDataConnection(String reason) {
        if (this.mDataConnection != null) {
            this.mDataConnection.tearDown(this, reason, null);
            this.mDataConnection = null;
        }
        this.setState(DctConstants.State.IDLE);
    }

    public synchronized PendingIntent getReconnectIntent() {
        return this.mReconnectAlarmIntent;
    }

    public synchronized void setReconnectIntent(PendingIntent intent) {
        this.mReconnectAlarmIntent = intent;
    }

    public synchronized ApnSetting getApnSetting() {
        this.log("getApnSetting: apnSetting=" + this.mApnSetting);
        return this.mApnSetting;
    }

    public synchronized void setApnSetting(ApnSetting apnSetting) {
        this.log("setApnSetting: apnSetting=" + apnSetting);
        this.mApnSetting = apnSetting;
    }

    public synchronized void setWaitingApns(ArrayList<ApnSetting> waitingApns) {
        this.mRetryManager.setWaitingApns(waitingApns);
    }

    public ApnSetting getNextApnSetting() {
        return this.mRetryManager.getNextApnSetting();
    }

    public void setModemSuggestedDelay(long delay) {
        this.mRetryManager.setModemSuggestedDelay(delay);
    }

    public long getDelayForNextApn(boolean failFastEnabled) {
        return this.mRetryManager.getDelayForNextApn(failFastEnabled || this.isFastRetryReason());
    }

    public void markApnPermanentFailed(ApnSetting apn) {
        this.mRetryManager.markApnPermanentFailed(apn);
    }

    public ArrayList<ApnSetting> getWaitingApns() {
        return this.mRetryManager.getWaitingApns();
    }

    public synchronized void setConcurrentVoiceAndDataAllowed(boolean allowed) {
        this.mConcurrentVoiceAndDataAllowed = allowed;
    }

    public synchronized boolean isConcurrentVoiceAndDataAllowed() {
        return this.mConcurrentVoiceAndDataAllowed;
    }

    public synchronized void setState(DctConstants.State s) {
        this.log("setState: " + (Object)((Object)s) + ", previous state:" + (Object)((Object)this.mState));
        if (this.mState != s) {
            this.mStateLocalLog.log("State changed from " + (Object)((Object)this.mState) + " to " + (Object)((Object)s));
            this.mState = s;
        }
        if (this.mState == DctConstants.State.FAILED && this.mRetryManager.getWaitingApns() != null) {
            this.mRetryManager.getWaitingApns().clear();
        }
    }

    public synchronized DctConstants.State getState() {
        return this.mState;
    }

    public boolean isDisconnected() {
        DctConstants.State currentState = this.getState();
        return currentState == DctConstants.State.IDLE || currentState == DctConstants.State.FAILED;
    }

    public synchronized void setReason(String reason) {
        this.log("set reason as " + reason + ",current state " + (Object)((Object)this.mState));
        this.mReason = reason;
    }

    public synchronized String getReason() {
        return this.mReason;
    }

    public boolean isReady() {
        return this.mDataEnabled.get() && this.mDependencyMet.get();
    }

    public boolean isConnectable() {
        return this.isReady() && (this.mState == DctConstants.State.IDLE || this.mState == DctConstants.State.RETRYING || this.mState == DctConstants.State.FAILED);
    }

    private boolean isFastRetryReason() {
        return "nwTypeChanged".equals(this.mReason) || "apnChanged".equals(this.mReason);
    }

    public boolean isConnectedOrConnecting() {
        return this.isReady() && (this.mState == DctConstants.State.CONNECTED || this.mState == DctConstants.State.CONNECTING || this.mState == DctConstants.State.RETRYING);
    }

    public void setEnabled(boolean enabled) {
        this.log("set enabled as " + enabled + ", current state is " + this.mDataEnabled.get());
        this.mDataEnabled.set(enabled);
    }

    public boolean isEnabled() {
        return this.mDataEnabled.get();
    }

    public boolean isDependencyMet() {
        return this.mDependencyMet.get();
    }

    public boolean isProvisioningApn() {
        String provisioningApn = this.mPhone.getContext().getResources().getString(17040447);
        if (!TextUtils.isEmpty(provisioningApn) && this.mApnSetting != null && this.mApnSetting.getApnName() != null) {
            return this.mApnSetting.getApnName().equals(provisioningApn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLog(String str) {
        LocalLog localLog = this.mLocalLog;
        synchronized (localLog) {
            this.mLocalLog.log(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestNetwork(NetworkRequest networkRequest, int type, Message onCompleteMsg) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            this.mNetworkRequests.add(networkRequest);
            this.logl("requestNetwork for " + networkRequest + ", type=" + DcTracker.requestTypeToString(type));
            this.mDcTracker.enableApn(ApnSetting.getApnTypesBitmaskFromString(this.mApnType), type, onCompleteMsg);
            if (this.mDataConnection != null) {
                this.mDataConnection.reevaluateDataConnectionProperties();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseNetwork(NetworkRequest networkRequest, int type) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            if (!this.mNetworkRequests.contains(networkRequest)) {
                this.logl("releaseNetwork can't find this request (" + networkRequest + ")");
            } else {
                this.mNetworkRequests.remove(networkRequest);
                if (this.mDataConnection != null) {
                    this.mDataConnection.reevaluateDataConnectionProperties();
                }
                this.logl("releaseNetwork left with " + this.mNetworkRequests.size() + " requests.");
                if (this.mNetworkRequests.size() == 0 || type == 2 || type == 3) {
                    this.mDcTracker.disableApn(ApnSetting.getApnTypesBitmaskFromString(this.mApnType), type);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRestrictedRequests(boolean excludeDun) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            for (NetworkRequest nr : this.mNetworkRequests) {
                if (excludeDun && nr.networkCapabilities.hasCapability(2) || nr.networkCapabilities.hasCapability(13)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetErrorCodeRetries() {
        this.logl("ApnContext.resetErrorCodeRetries");
        String[] config = this.mPhone.getContext().getResources().getStringArray(17235999);
        SparseIntArray sparseIntArray = this.mRetriesLeftPerErrorCode;
        synchronized (sparseIntArray) {
            this.mRetriesLeftPerErrorCode.clear();
            for (String c : config) {
                String[] errorValue = c.split(",");
                if (errorValue != null && errorValue.length == 2) {
                    int count = 0;
                    int errorCode = 0;
                    try {
                        errorCode = Integer.parseInt(errorValue[0]);
                        count = Integer.parseInt(errorValue[1]);
                    }
                    catch (NumberFormatException e) {
                        this.log("Exception parsing config_retries_per_error_code: " + e);
                        continue;
                    }
                    if (count <= 0 || errorCode <= 0) continue;
                    this.mRetriesLeftPerErrorCode.put(errorCode, count);
                    continue;
                }
                this.log("Exception parsing config_retries_per_error_code: " + c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartOnError(int errorCode) {
        boolean result = false;
        int retriesLeft = 0;
        SparseIntArray sparseIntArray = this.mRetriesLeftPerErrorCode;
        synchronized (sparseIntArray) {
            retriesLeft = this.mRetriesLeftPerErrorCode.get(errorCode);
            switch (retriesLeft) {
                case 0: {
                    break;
                }
                case 1: {
                    this.resetErrorCodeRetries();
                    result = true;
                    break;
                }
                default: {
                    this.mRetriesLeftPerErrorCode.put(errorCode, retriesLeft - 1);
                    result = false;
                }
            }
        }
        this.logl("ApnContext.restartOnError(" + errorCode + ") found " + retriesLeft + " and returned " + result);
        return result;
    }

    public int incAndGetConnectionGeneration() {
        return this.mConnectionGeneration.incrementAndGet();
    }

    public int getConnectionGeneration() {
        return this.mConnectionGeneration.get();
    }

    long getRetryAfterDisconnectDelay() {
        return this.mRetryManager.getRetryAfterDisconnectDelay();
    }

    public static int getApnTypeFromNetworkType(int networkType) {
        switch (networkType) {
            case 0: {
                return 17;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 10: {
                return 32;
            }
            case 11: {
                return 64;
            }
            case 12: {
                return 128;
            }
            case 14: {
                return 256;
            }
            case 15: {
                return 512;
            }
        }
        return 0;
    }

    static int getApnTypeFromNetworkRequest(NetworkRequest nr) {
        NetworkCapabilities nc = nr.networkCapabilities;
        if (nc.getTransportTypes().length > 0 && !nc.hasTransport(0)) {
            return 0;
        }
        int apnType = 0;
        boolean error = false;
        if (nc.hasCapability(12)) {
            apnType = 17;
        }
        if (nc.hasCapability(0)) {
            if (apnType != 0) {
                error = true;
            }
            apnType = 2;
        }
        if (nc.hasCapability(1)) {
            if (apnType != 0) {
                error = true;
            }
            apnType = 4;
        }
        if (nc.hasCapability(2)) {
            if (apnType != 0) {
                error = true;
            }
            apnType = 8;
        }
        if (nc.hasCapability(3)) {
            if (apnType != 0) {
                error = true;
            }
            apnType = 32;
        }
        if (nc.hasCapability(4)) {
            if (apnType != 0) {
                error = true;
            }
            apnType = 64;
        }
        if (nc.hasCapability(5)) {
            if (apnType != 0) {
                error = true;
            }
            apnType = 128;
        }
        if (nc.hasCapability(7)) {
            if (apnType != 0) {
                error = true;
            }
            apnType = 256;
        }
        if (nc.hasCapability(10)) {
            if (apnType != 0) {
                error = true;
            }
            apnType = 512;
        }
        if (nc.hasCapability(23)) {
            if (apnType != 0) {
                error = true;
            }
            apnType = 1024;
        }
        if (error) {
            Rlog.d(SLOG_TAG, "Multiple apn types specified in request - result is unspecified!");
        }
        if (apnType == 0) {
            Rlog.d(SLOG_TAG, "Unsupported NetworkRequest in Telephony: nr=" + nr);
        }
        return apnType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NetworkRequest> getNetworkRequests() {
        Object object = this.mRefCountLock;
        synchronized (object) {
            return new ArrayList<NetworkRequest>(this.mNetworkRequests);
        }
    }

    public synchronized String toString() {
        return "{mApnType=" + this.mApnType + " mState=" + (Object)((Object)this.getState()) + " mWaitingApns={" + this.mRetryManager.getWaitingApns() + "} mApnSetting={" + this.mApnSetting + "} mReason=" + this.mReason + " mDataEnabled=" + this.mDataEnabled + " mDependencyMet=" + this.mDependencyMet + "}";
    }

    private void log(String s) {
    }

    private void logl(String s) {
        this.log(s);
        this.mLocalLog.log(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter printWriter, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printWriter, "  ");
        Object object = this.mRefCountLock;
        synchronized (object) {
            pw.println(this.toString());
            if (this.mNetworkRequests.size() > 0) {
                pw.println("NetworkRequests:");
                pw.increaseIndent();
                for (NetworkRequest nr : this.mNetworkRequests) {
                    pw.println(nr);
                }
                pw.decreaseIndent();
            }
            pw.increaseIndent();
            pw.println("-----");
            pw.println("Local log:");
            this.mLocalLog.dump(fd, pw, args);
            pw.println("-----");
            pw.decreaseIndent();
            pw.println("Historical APN state:");
            pw.increaseIndent();
            this.mStateLocalLog.dump(fd, pw, args);
            pw.decreaseIndent();
            pw.println(this.mRetryManager);
            pw.println("--------------------------");
        }
    }
}

