/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.data.ApnSetting;
import android.util.Log;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.uicc.IccRecords;
import java.util.Arrays;
import java.util.HashSet;

public class ApnSettingUtils {
    static final String LOG_TAG = "ApnSetting";
    private static final boolean DBG = false;

    private static boolean iccidMatches(String mvnoData, String iccId) {
        String[] mvnoIccidList;
        for (String mvnoIccid : mvnoIccidList = mvnoData.split(",")) {
            if (!iccId.startsWith(mvnoIccid)) continue;
            Log.d(LOG_TAG, "mvno icc id match found");
            return true;
        }
        return false;
    }

    private static boolean imsiMatches(String imsiDB, String imsiSIM) {
        int len = imsiDB.length();
        if (len <= 0) {
            return false;
        }
        if (len > imsiSIM.length()) {
            return false;
        }
        for (int idx = 0; idx < len; ++idx) {
            char c = imsiDB.charAt(idx);
            if (c == 'x' || c == 'X' || c == imsiSIM.charAt(idx)) continue;
            return false;
        }
        return true;
    }

    public static boolean mvnoMatches(IccRecords r, int mvnoType, String mvnoMatchData) {
        String iccId;
        if (mvnoType == 0) {
            if (r.getServiceProviderName() != null && r.getServiceProviderName().equalsIgnoreCase(mvnoMatchData)) {
                return true;
            }
        } else if (mvnoType == 1) {
            String imsiSIM = r.getIMSI();
            if (imsiSIM != null && ApnSettingUtils.imsiMatches(mvnoMatchData, imsiSIM)) {
                return true;
            }
        } else if (mvnoType == 2) {
            String gid1 = r.getGid1();
            int mvno_match_data_length = mvnoMatchData.length();
            if (gid1 != null && gid1.length() >= mvno_match_data_length && gid1.substring(0, mvno_match_data_length).equalsIgnoreCase(mvnoMatchData)) {
                return true;
            }
        } else if (mvnoType == 3 && (iccId = r.getIccId()) != null && ApnSettingUtils.iccidMatches(mvnoMatchData, iccId)) {
            return true;
        }
        return false;
    }

    public static boolean isMeteredApnType(int apnType, Phone phone) {
        if (phone == null) {
            return true;
        }
        boolean isRoaming = phone.getServiceState().getDataRoaming();
        int subId = phone.getSubId();
        String carrierConfig = isRoaming ? "carrier_metered_roaming_apn_types_strings" : "carrier_metered_apn_types_strings";
        CarrierConfigManager configManager = (CarrierConfigManager)phone.getContext().getSystemService("carrier_config");
        if (configManager == null) {
            Rlog.e(LOG_TAG, "Carrier config service is not available");
            return true;
        }
        PersistableBundle b = configManager.getConfigForSubId(subId);
        if (b == null) {
            Rlog.e(LOG_TAG, "Can't get the config. subId = " + subId);
            return true;
        }
        String[] meteredApnTypes = b.getStringArray(carrierConfig);
        if (meteredApnTypes == null) {
            Rlog.e(LOG_TAG, carrierConfig + " is not available. subId = " + subId);
            return true;
        }
        HashSet<String> meteredApnSet = new HashSet<String>(Arrays.asList(meteredApnTypes));
        if (meteredApnSet.contains(ApnSetting.getApnTypeString(apnType))) {
            return true;
        }
        return apnType == 255 && meteredApnSet.size() > 0;
    }

    public static boolean isMetered(ApnSetting apn, Phone phone) {
        if (phone == null || apn == null) {
            return true;
        }
        for (int apnType : apn.getApnTypes()) {
            if (!ApnSettingUtils.isMeteredApnType(apnType, phone)) continue;
            return true;
        }
        return false;
    }
}

