/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.net.LinkProperties;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.data.DataCallResponse;
import android.telephony.data.DataProfile;
import android.telephony.data.DataService;
import android.telephony.data.DataServiceCallback;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CellularDataService
extends DataService {
    private static final String TAG = CellularDataService.class.getSimpleName();
    private static final boolean DBG = false;
    private static final int SETUP_DATA_CALL_COMPLETE = 1;
    private static final int DEACTIVATE_DATA_ALL_COMPLETE = 2;
    private static final int SET_INITIAL_ATTACH_APN_COMPLETE = 3;
    private static final int SET_DATA_PROFILE_COMPLETE = 4;
    private static final int REQUEST_DATA_CALL_LIST_COMPLETE = 5;
    private static final int DATA_CALL_LIST_CHANGED = 6;

    @Override
    public DataService.DataServiceProvider onCreateDataServiceProvider(int slotIndex) {
        this.log("Cellular data service created for slot " + slotIndex);
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            this.loge("Tried to cellular data service with invalid slotId " + slotIndex);
            return null;
        }
        return new CellularDataServiceProvider(slotIndex);
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    private void loge(String s) {
        Rlog.e(TAG, s);
    }

    private class CellularDataServiceProvider
    extends DataService.DataServiceProvider {
        private final Map<Message, DataServiceCallback> mCallbackMap;
        private final Looper mLooper;
        private final Handler mHandler;
        private final HandlerThread mHandlerThread;
        private final Phone mPhone;

        private CellularDataServiceProvider(int slotId) {
            super(CellularDataService.this, slotId);
            this.mCallbackMap = new HashMap<Message, DataServiceCallback>();
            this.mPhone = PhoneFactory.getPhone(this.getSlotIndex());
            this.mHandlerThread = new HandlerThread(CellularDataService.class.getSimpleName());
            this.mHandlerThread.start();
            this.mLooper = this.mHandlerThread.getLooper();
            this.mHandler = new Handler(this.mLooper){

                @Override
                public void handleMessage(Message message) {
                    DataServiceCallback callback = (DataServiceCallback)CellularDataServiceProvider.this.mCallbackMap.remove(message);
                    AsyncResult ar = (AsyncResult)message.obj;
                    switch (message.what) {
                        case 1: {
                            DataCallResponse response = (DataCallResponse)ar.result;
                            callback.onSetupDataCallComplete(ar.exception != null ? 4 : 0, response);
                            break;
                        }
                        case 2: {
                            callback.onDeactivateDataCallComplete(ar.exception != null ? 4 : 0);
                            break;
                        }
                        case 3: {
                            callback.onSetInitialAttachApnComplete(ar.exception != null ? 4 : 0);
                            break;
                        }
                        case 4: {
                            callback.onSetDataProfileComplete(ar.exception != null ? 4 : 0);
                            break;
                        }
                        case 5: {
                            callback.onRequestDataCallListComplete(ar.exception != null ? 4 : 0, ar.exception != null ? null : (List)ar.result);
                            break;
                        }
                        case 6: {
                            CellularDataServiceProvider.this.notifyDataCallListChanged((List)ar.result);
                            break;
                        }
                        default: {
                            CellularDataService.this.loge("Unexpected event: " + message.what);
                            return;
                        }
                    }
                }
            };
            this.mPhone.mCi.registerForDataCallListChanged(this.mHandler, 6, null);
        }

        @Override
        public void setupDataCall(int accessNetworkType, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 1);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.setupDataCall(accessNetworkType, dataProfile, isRoaming, allowRoaming, reason, linkProperties, message);
        }

        @Override
        public void deactivateDataCall(int cid, int reason, DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 2);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.deactivateDataCall(cid, reason, message);
        }

        @Override
        public void setInitialAttachApn(DataProfile dataProfile, boolean isRoaming, DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 3);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.setInitialAttachApn(dataProfile, isRoaming, message);
        }

        @Override
        public void setDataProfile(List<DataProfile> dps, boolean isRoaming, DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 4);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.setDataProfile(dps.toArray(new DataProfile[dps.size()]), isRoaming, message);
        }

        @Override
        public void requestDataCallList(DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 5);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.getDataCallList(message);
        }

        @Override
        public void close() {
            this.mPhone.mCi.unregisterForDataCallListChanged(this.mHandler);
            this.mHandlerThread.quit();
        }
    }
}

