/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.PendingIntent;
import android.net.KeepalivePacketData;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkRequest;
import android.net.NetworkUtils;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.net.StringNetworkSpecifier;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.telephony.AccessNetworkConstants;
import android.telephony.DataFailCause;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.telephony.data.ApnSetting;
import android.telephony.data.DataCallResponse;
import android.telephony.data.DataProfile;
import android.text.TextUtils;
import android.util.Pair;
import android.util.StatsLog;
import android.util.TimeUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CarrierSignalAgent;
import com.android.internal.telephony.LinkCapacityEstimate;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.dataconnection.ApnContext;
import com.android.internal.telephony.dataconnection.ApnSettingUtils;
import com.android.internal.telephony.dataconnection.DataServiceManager;
import com.android.internal.telephony.dataconnection.DcController;
import com.android.internal.telephony.dataconnection.DcNetworkAgent;
import com.android.internal.telephony.dataconnection.DcTesterFailBringUpAll;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.dataconnection.KeepaliveStatus;
import com.android.internal.telephony.dataconnection.TelephonyNetworkFactory;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DataConnection
extends StateMachine {
    private static final boolean DBG = true;
    private static final boolean VDBG = true;
    private static final String NETWORK_TYPE = "MOBILE";
    private static final String RAT_NAME_5G = "nr";
    private static final String RAT_NAME_EVDO = "evdo";
    private static final int HANDOVER_STATE_IDLE = 1;
    private static final int HANDOVER_STATE_BEING_TRANSFERRED = 2;
    private static final int HANDOVER_STATE_COMPLETED = 3;
    private static final int DEFAULT_INTERNET_CONNECTION_SCORE = 50;
    private static final int OTHER_CONNECTION_SCORE = 45;
    private int mScore;
    private int mSubId;
    private DcController mDcController;
    private DcTesterFailBringUpAll mDcTesterFailBringUpAll;
    private static AtomicInteger mInstanceNumber = new AtomicInteger(0);
    private AsyncChannel mAc;
    private DcTracker mDct = null;
    private String[] mPcscfAddr;
    private final String mTagSuffix;
    private ApnSetting mApnSetting;
    private ConnectionParams mConnectionParams;
    private DisconnectParams mDisconnectParams;
    private int mDcFailCause;
    private Phone mPhone;
    private DataServiceManager mDataServiceManager;
    private final int mTransportType;
    private LinkProperties mLinkProperties = new LinkProperties();
    private long mCreateTime;
    private long mLastFailTime;
    private int mLastFailCause;
    private static final String NULL_IP = "0.0.0.0";
    private Object mUserData;
    private int mSubscriptionOverride;
    private int mRilRat = Integer.MAX_VALUE;
    private int mDataRegState = Integer.MAX_VALUE;
    private NetworkInfo mNetworkInfo;
    private DcNetworkAgent mNetworkAgent;
    private DcNetworkAgent mHandoverSourceNetworkAgent;
    private int mDisabledApnTypeBitMask = 0;
    int mTag;
    public int mCid;
    private int mHandoverState;
    private final Map<ApnContext, ConnectionParams> mApnContexts = new ConcurrentHashMap<ApnContext, ConnectionParams>();
    PendingIntent mReconnectIntent = null;
    static final int BASE = 262144;
    static final int EVENT_CONNECT = 262144;
    static final int EVENT_SETUP_DATA_CONNECTION_DONE = 262145;
    static final int EVENT_DEACTIVATE_DONE = 262147;
    static final int EVENT_DISCONNECT = 262148;
    static final int EVENT_RIL_CONNECTED = 262149;
    static final int EVENT_DISCONNECT_ALL = 262150;
    static final int EVENT_DATA_STATE_CHANGED = 262151;
    static final int EVENT_TEAR_DOWN_NOW = 262152;
    static final int EVENT_LOST_CONNECTION = 262153;
    static final int EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED = 262155;
    static final int EVENT_DATA_CONNECTION_ROAM_ON = 262156;
    static final int EVENT_DATA_CONNECTION_ROAM_OFF = 262157;
    static final int EVENT_BW_REFRESH_RESPONSE = 262158;
    static final int EVENT_DATA_CONNECTION_VOICE_CALL_STARTED = 262159;
    static final int EVENT_DATA_CONNECTION_VOICE_CALL_ENDED = 262160;
    static final int EVENT_DATA_CONNECTION_OVERRIDE_CHANGED = 262161;
    static final int EVENT_KEEPALIVE_STATUS = 262162;
    static final int EVENT_KEEPALIVE_STARTED = 262163;
    static final int EVENT_KEEPALIVE_STOPPED = 262164;
    static final int EVENT_KEEPALIVE_START_REQUEST = 262165;
    static final int EVENT_KEEPALIVE_STOP_REQUEST = 262166;
    static final int EVENT_LINK_CAPACITY_CHANGED = 262167;
    static final int EVENT_RESET = 262168;
    static final int EVENT_REEVALUATE_RESTRICTED_STATE = 262169;
    static final int EVENT_REEVALUATE_DATA_CONNECTION_PROPERTIES = 262170;
    private static final int CMD_TO_STRING_COUNT = 27;
    private static String[] sCmdToString = new String[27];
    private int mId;
    private static final String TCP_BUFFER_SIZES_GPRS = "4092,8760,48000,4096,8760,48000";
    private static final String TCP_BUFFER_SIZES_EDGE = "4093,26280,70800,4096,16384,70800";
    private static final String TCP_BUFFER_SIZES_UMTS = "58254,349525,1048576,58254,349525,1048576";
    private static final String TCP_BUFFER_SIZES_1XRTT = "16384,32768,131072,4096,16384,102400";
    private static final String TCP_BUFFER_SIZES_EVDO = "4094,87380,262144,4096,16384,262144";
    private static final String TCP_BUFFER_SIZES_EHRPD = "131072,262144,1048576,4096,16384,524288";
    private static final String TCP_BUFFER_SIZES_HSDPA = "61167,367002,1101005,8738,52429,262114";
    private static final String TCP_BUFFER_SIZES_HSPA = "40778,244668,734003,16777,100663,301990";
    private static final String TCP_BUFFER_SIZES_LTE = "524288,1048576,2097152,262144,524288,1048576";
    private static final String TCP_BUFFER_SIZES_HSPAP = "122334,734003,2202010,32040,192239,576717";
    private static final String TCP_BUFFER_SIZES_NR = "2097152,6291456,16777216,512000,2097152,8388608";
    private boolean mUnmeteredUseOnly = false;
    private boolean mRestrictedNetworkOverride = false;
    private DcDefaultState mDefaultState = new DcDefaultState();
    private DcInactiveState mInactiveState = new DcInactiveState();
    private DcActivatingState mActivatingState = new DcActivatingState();
    private DcActiveState mActiveState = new DcActiveState();
    private DcDisconnectingState mDisconnectingState = new DcDisconnectingState();
    private DcDisconnectionErrorCreatingConnection mDisconnectingErrorCreatingConnection = new DcDisconnectionErrorCreatingConnection();

    static String cmdToString(int cmd) {
        String value = null;
        if ((cmd -= 262144) >= 0 && cmd < sCmdToString.length) {
            value = sCmdToString[cmd];
        }
        if (value == null) {
            value = "0x" + Integer.toHexString(cmd + 262144);
        }
        return value;
    }

    public static DataConnection makeDataConnection(Phone phone, int id2, DcTracker dct, DataServiceManager dataServiceManager, DcTesterFailBringUpAll failBringUpAll, DcController dcc) {
        String transportType = dataServiceManager.getTransportType() == 1 ? "C" : "I";
        DataConnection dc = new DataConnection(phone, transportType + "-" + mInstanceNumber.incrementAndGet(), id2, dct, dataServiceManager, failBringUpAll, dcc);
        dc.start();
        dc.log("Made " + dc.getName());
        return dc;
    }

    void dispose() {
        this.log("dispose: call quiteNow()");
        this.quitNow();
    }

    LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    boolean isInactive() {
        return this.getCurrentState() == this.mInactiveState;
    }

    boolean isDisconnecting() {
        return this.getCurrentState() == this.mDisconnectingState;
    }

    boolean isActive() {
        return this.getCurrentState() == this.mActiveState;
    }

    boolean isActivating() {
        return this.getCurrentState() == this.mActivatingState;
    }

    boolean hasBeenTransferred() {
        return this.mHandoverState == 3;
    }

    int getCid() {
        return this.mCid;
    }

    ApnSetting getApnSetting() {
        return this.mApnSetting;
    }

    void setLinkPropertiesHttpProxy(ProxyInfo proxy) {
        this.mLinkProperties.setHttpProxy(proxy);
    }

    public boolean isIpv4Connected() {
        boolean ret = false;
        List<InetAddress> addresses = this.mLinkProperties.getAddresses();
        for (InetAddress addr : addresses) {
            Inet4Address i4addr;
            if (!(addr instanceof Inet4Address) || (i4addr = (Inet4Address)addr).isAnyLocalAddress() || i4addr.isLinkLocalAddress() || i4addr.isLoopbackAddress() || i4addr.isMulticastAddress()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean isIpv6Connected() {
        boolean ret = false;
        List<InetAddress> addresses = this.mLinkProperties.getAddresses();
        for (InetAddress addr : addresses) {
            Inet6Address i6addr;
            if (!(addr instanceof Inet6Address) || (i6addr = (Inet6Address)addr).isAnyLocalAddress() || i6addr.isLinkLocalAddress() || i6addr.isLoopbackAddress() || i6addr.isMulticastAddress()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    @VisibleForTesting
    public UpdateLinkPropertyResult updateLinkProperty(DataCallResponse newState) {
        UpdateLinkPropertyResult result = new UpdateLinkPropertyResult(this.mLinkProperties);
        if (newState == null) {
            return result;
        }
        result.newLp = new LinkProperties();
        result.setupResult = this.setLinkProperties(newState, result.newLp);
        if (result.setupResult != SetupResult.SUCCESS) {
            this.log("updateLinkProperty failed : " + (Object)((Object)result.setupResult));
            return result;
        }
        result.newLp.setHttpProxy(this.mLinkProperties.getHttpProxy());
        this.checkSetMtu(this.mApnSetting, result.newLp);
        this.mLinkProperties = result.newLp;
        this.updateTcpBufferSizes(this.mRilRat);
        if (!result.oldLp.equals(result.newLp)) {
            this.log("updateLinkProperty old LP=" + result.oldLp);
            this.log("updateLinkProperty new LP=" + result.newLp);
        }
        if (!result.newLp.equals(result.oldLp) && this.mNetworkAgent != null) {
            this.mNetworkAgent.sendLinkProperties(this.mLinkProperties, this);
        }
        return result;
    }

    private void checkSetMtu(ApnSetting apn, LinkProperties lp) {
        if (lp == null) {
            return;
        }
        if (apn == null || lp == null) {
            return;
        }
        if (lp.getMtu() != 0) {
            this.log("MTU set by call response to: " + lp.getMtu());
            return;
        }
        if (apn != null && apn.getMtu() != 0) {
            lp.setMtu(apn.getMtu());
            this.log("MTU set by APN to: " + apn.getMtu());
            return;
        }
        int mtu = this.mPhone.getContext().getResources().getInteger(17694844);
        if (mtu != 0) {
            lp.setMtu(mtu);
            this.log("MTU set by config resource to: " + mtu);
        }
    }

    private DataConnection(Phone phone, String tagSuffix, int id2, DcTracker dct, DataServiceManager dataServiceManager, DcTesterFailBringUpAll failBringUpAll, DcController dcc) {
        super("DC-" + tagSuffix, dcc.getHandler());
        this.mTagSuffix = tagSuffix;
        this.setLogRecSize(300);
        this.setLogOnlyTransitions(true);
        this.log("DataConnection created");
        this.mPhone = phone;
        this.mDct = dct;
        this.mDataServiceManager = dataServiceManager;
        this.mTransportType = dataServiceManager.getTransportType();
        this.mDcTesterFailBringUpAll = failBringUpAll;
        this.mDcController = dcc;
        this.mId = id2;
        this.mCid = -1;
        ServiceState ss = this.mPhone.getServiceState();
        this.mRilRat = ss.getRilDataRadioTechnology();
        this.mDataRegState = this.mPhone.getServiceState().getDataRegState();
        int networkType = ss.getDataNetworkType();
        this.mNetworkInfo = new NetworkInfo(0, networkType, NETWORK_TYPE, TelephonyManager.getNetworkTypeName(networkType));
        this.mNetworkInfo.setRoaming(ss.getDataRoaming());
        this.mNetworkInfo.setIsAvailable(true);
        this.addState(this.mDefaultState);
        this.addState(this.mInactiveState, this.mDefaultState);
        this.addState(this.mActivatingState, this.mDefaultState);
        this.addState(this.mActiveState, this.mDefaultState);
        this.addState(this.mDisconnectingState, this.mDefaultState);
        this.addState(this.mDisconnectingErrorCreatingConnection, this.mDefaultState);
        this.setInitialState(this.mInactiveState);
    }

    private int getHandoverSourceTransport() {
        return this.mTransportType == 1 ? 2 : 1;
    }

    private int connect(ConnectionParams cp) {
        this.log("connect: carrier='" + this.mApnSetting.getEntryName() + "' APN='" + this.mApnSetting.getApnName() + "' proxy='" + this.mApnSetting.getProxyAddressAsString() + "' port='" + this.mApnSetting.getProxyPort() + "'");
        if (cp.mApnContext != null) {
            cp.mApnContext.requestLog("DataConnection.connect");
        }
        if (this.mDcTesterFailBringUpAll.getDcFailBringUp().mCounter > 0) {
            DataCallResponse response = new DataCallResponse(this.mDcTesterFailBringUpAll.getDcFailBringUp().mFailCause, this.mDcTesterFailBringUpAll.getDcFailBringUp().mSuggestedRetryTime, 0, 0, 0, "", null, null, null, null, 0);
            Message msg = this.obtainMessage(262145, cp);
            AsyncResult.forMessage(msg, response, null);
            this.sendMessage(msg);
            this.log("connect: FailBringUpAll=" + this.mDcTesterFailBringUpAll.getDcFailBringUp() + " send error response=" + response);
            --this.mDcTesterFailBringUpAll.getDcFailBringUp().mCounter;
            return 0;
        }
        this.mCreateTime = -1L;
        this.mLastFailTime = -1L;
        this.mLastFailCause = 0;
        Message msg = this.obtainMessage(262145, cp);
        msg.obj = cp;
        DataProfile dp = DcTracker.createDataProfile(this.mApnSetting, cp.mProfileId, this.mApnSetting.equals(this.mDct.getPreferredApn()));
        boolean isModemRoaming = this.mPhone.getServiceState().getDataRoamingFromRegistration();
        boolean allowRoaming = this.mPhone.getDataRoamingEnabled() || isModemRoaming && !this.mPhone.getServiceState().getDataRoaming();
        LinkProperties linkProperties = null;
        int reason = 1;
        if (cp.mRequestType == 2) {
            DcTracker dcTracker = this.mPhone.getDcTracker(this.getHandoverSourceTransport());
            if (dcTracker == null || cp.mApnContext == null) {
                this.loge("connect: Handover failed. dcTracker=" + dcTracker + ", apnContext=" + cp.mApnContext);
                return 65542;
            }
            DataConnection dc = dcTracker.getDataConnectionByApnType(cp.mApnContext.getApnType());
            if (dc == null) {
                this.loge("connect: Can't find data connection for handover.");
                return 65542;
            }
            linkProperties = dc.getLinkProperties();
            this.mHandoverSourceNetworkAgent = dc.getNetworkAgent();
            this.log("Get the handover source network agent: " + this.mHandoverSourceNetworkAgent);
            dc.setHandoverState(2);
            if (linkProperties == null) {
                this.loge("connect: Can't find link properties of handover data connection. dc=" + dc);
                return 65542;
            }
            reason = 3;
        }
        this.mDataServiceManager.setupDataCall(ServiceState.rilRadioTechnologyToAccessNetworkType(cp.mRilRat), dp, isModemRoaming, allowRoaming, reason, linkProperties, msg);
        TelephonyMetrics.getInstance().writeSetupDataCall(this.mPhone.getPhoneId(), cp.mRilRat, dp.getProfileId(), dp.getApn(), dp.getProtocolType());
        return 0;
    }

    public void onSubscriptionOverride(int overrideMask, int overrideValue) {
        this.mSubscriptionOverride = this.mSubscriptionOverride & ~overrideMask | overrideValue & overrideMask;
        this.sendMessage(this.obtainMessage(262161));
    }

    private void tearDownData(Object o) {
        int discReason = 1;
        ApnContext apnContext = null;
        if (o != null && o instanceof DisconnectParams) {
            DisconnectParams dp = (DisconnectParams)o;
            apnContext = dp.mApnContext;
            if (TextUtils.equals(dp.mReason, "radioTurnedOff") || TextUtils.equals(dp.mReason, "pdpReset")) {
                discReason = 2;
            } else if (dp.mReleaseType == 3) {
                discReason = 3;
            }
        }
        String str = "tearDownData. mCid=" + this.mCid + ", reason=" + discReason;
        this.log(str);
        if (apnContext != null) {
            apnContext.requestLog(str);
        }
        this.mDataServiceManager.deactivateDataCall(this.mCid, discReason, this.obtainMessage(262147, this.mTag, 0, o));
    }

    private void notifyAllWithEvent(ApnContext alreadySent, int event, String reason) {
        this.mNetworkInfo.setDetailedState(this.mNetworkInfo.getDetailedState(), reason, this.mNetworkInfo.getExtraInfo());
        for (ConnectionParams cp : this.mApnContexts.values()) {
            ApnContext apnContext = cp.mApnContext;
            if (apnContext == alreadySent) continue;
            if (reason != null) {
                apnContext.setReason(reason);
            }
            Pair<ApnContext, Integer> pair = new Pair<ApnContext, Integer>(apnContext, cp.mConnectionGeneration);
            Message msg = this.mDct.obtainMessage(event, this.mCid, cp.mRequestType, pair);
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
    }

    private void notifyConnectCompleted(ConnectionParams cp, int cause, boolean sendAll) {
        ApnContext alreadySent = null;
        if (cp != null && cp.mOnCompletedMsg != null) {
            Message connectionCompletedMsg = cp.mOnCompletedMsg;
            cp.mOnCompletedMsg = null;
            alreadySent = cp.mApnContext;
            long timeStamp = System.currentTimeMillis();
            connectionCompletedMsg.arg1 = this.mCid;
            connectionCompletedMsg.arg2 = cp.mRequestType;
            if (cause == 0) {
                this.mCreateTime = timeStamp;
                AsyncResult.forMessage(connectionCompletedMsg);
            } else {
                this.mLastFailCause = cause;
                this.mLastFailTime = timeStamp;
                if (cause == 0) {
                    cause = 65536;
                }
                AsyncResult.forMessage(connectionCompletedMsg, cause, new Throwable(DataFailCause.toString(cause)));
            }
            this.log("notifyConnectCompleted at " + timeStamp + " cause=" + cause + " connectionCompletedMsg=" + DataConnection.msgToString(connectionCompletedMsg));
            connectionCompletedMsg.sendToTarget();
        }
        if (sendAll) {
            this.log("Send to all. " + alreadySent + " " + DataFailCause.toString(cause));
            this.notifyAllWithEvent(alreadySent, 270371, DataFailCause.toString(cause));
        }
    }

    private void notifyDisconnectCompleted(DisconnectParams dp, boolean sendAll) {
        this.log("NotifyDisconnectCompleted");
        ApnContext alreadySent = null;
        String reason = null;
        if (dp != null && dp.mOnCompletedMsg != null) {
            Message msg = dp.mOnCompletedMsg;
            dp.mOnCompletedMsg = null;
            if (msg.obj instanceof ApnContext) {
                alreadySent = (ApnContext)msg.obj;
            }
            reason = dp.mReason;
            this.log(String.format("msg=%s msg.obj=%s", msg.toString(), msg.obj instanceof String ? (String)msg.obj : "<no-reason>"));
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
        if (sendAll) {
            if (reason == null) {
                reason = DataFailCause.toString(65536);
            }
            this.notifyAllWithEvent(alreadySent, 270351, reason);
        }
        this.log("NotifyDisconnectCompleted DisconnectParams=" + dp);
    }

    public int getDataConnectionId() {
        return this.mId;
    }

    private void clearSettings() {
        this.log("clearSettings");
        this.mCreateTime = -1L;
        this.mLastFailTime = -1L;
        this.mLastFailCause = 0;
        this.mCid = -1;
        this.mPcscfAddr = new String[5];
        this.mLinkProperties = new LinkProperties();
        this.mApnContexts.clear();
        this.mApnSetting = null;
        this.mUnmeteredUseOnly = false;
        this.mRestrictedNetworkOverride = false;
        this.mDcFailCause = 0;
        this.mDisabledApnTypeBitMask = 0;
        this.mSubId = -1;
    }

    private SetupResult onSetupConnectionCompleted(int resultCode, DataCallResponse response, ConnectionParams cp) {
        SetupResult result;
        this.log("onSetupConnectionCompleted: resultCode=" + resultCode + ", response=" + response);
        if (cp.mTag != this.mTag) {
            this.log("onSetupConnectionCompleted stale cp.tag=" + cp.mTag + ", mtag=" + this.mTag);
            result = SetupResult.ERROR_STALE;
        } else if (resultCode == 4) {
            result = SetupResult.ERROR_RADIO_NOT_AVAILABLE;
            result.mFailCause = 65537;
        } else if (response.getCause() != 0) {
            if (response.getCause() == 65537) {
                result = SetupResult.ERROR_RADIO_NOT_AVAILABLE;
                result.mFailCause = 65537;
            } else {
                result = SetupResult.ERROR_DATA_SERVICE_SPECIFIC_ERROR;
                result.mFailCause = DataFailCause.getFailCause(response.getCause());
            }
        } else {
            this.log("onSetupConnectionCompleted received successful DataCallResponse");
            this.mCid = response.getId();
            this.mPcscfAddr = (String[])response.getPcscfAddresses().stream().map(InetAddress::getHostAddress).toArray(String[]::new);
            result = this.updateLinkProperty((DataCallResponse)response).setupResult;
        }
        return result;
    }

    private boolean isDnsOk(String[] domainNameServers) {
        if (NULL_IP.equals(domainNameServers[0]) && NULL_IP.equals(domainNameServers[1]) && !this.mPhone.isDnsCheckDisabled() && !DataConnection.isIpAddress(this.mApnSetting.getMmsProxyAddressAsString())) {
            this.log(String.format("isDnsOk: return false apn.types=%d APN_TYPE_MMS=%s isIpAddress(%s)=%s", this.mApnSetting.getApnTypeBitmask(), "mms", this.mApnSetting.getMmsProxyAddressAsString(), DataConnection.isIpAddress(this.mApnSetting.getMmsProxyAddressAsString())));
            return false;
        }
        return true;
    }

    private void updateTcpBufferSizes(int rilRat) {
        String sizes = null;
        if (rilRat == 19) {
            rilRat = 14;
        }
        String ratName = ServiceState.rilRadioTechnologyToString(rilRat).toLowerCase(Locale.ROOT);
        if (rilRat == 7 || rilRat == 8 || rilRat == 12) {
            ratName = RAT_NAME_EVDO;
        }
        if (rilRat == 14 && this.isNRConnected()) {
            ratName = RAT_NAME_5G;
        }
        String[] configOverride = this.mPhone.getContext().getResources().getStringArray(17236039);
        for (int i = 0; i < configOverride.length; ++i) {
            String[] split = configOverride[i].split(":");
            if (!ratName.equals(split[0]) || split.length != 2) continue;
            sizes = split[1];
            break;
        }
        if (sizes == null) {
            switch (rilRat) {
                case 1: {
                    sizes = TCP_BUFFER_SIZES_GPRS;
                    break;
                }
                case 2: {
                    sizes = TCP_BUFFER_SIZES_EDGE;
                    break;
                }
                case 3: {
                    sizes = TCP_BUFFER_SIZES_UMTS;
                    break;
                }
                case 6: {
                    sizes = TCP_BUFFER_SIZES_1XRTT;
                    break;
                }
                case 7: 
                case 8: 
                case 12: {
                    sizes = TCP_BUFFER_SIZES_EVDO;
                    break;
                }
                case 13: {
                    sizes = TCP_BUFFER_SIZES_EHRPD;
                    break;
                }
                case 9: {
                    sizes = TCP_BUFFER_SIZES_HSDPA;
                    break;
                }
                case 10: 
                case 11: {
                    sizes = TCP_BUFFER_SIZES_HSPA;
                    break;
                }
                case 14: 
                case 19: {
                    if (this.isNRConnected()) {
                        sizes = TCP_BUFFER_SIZES_NR;
                        break;
                    }
                    sizes = TCP_BUFFER_SIZES_LTE;
                    break;
                }
                case 15: {
                    sizes = TCP_BUFFER_SIZES_HSPAP;
                    break;
                }
            }
        }
        this.mLinkProperties.setTcpBufferSizes(sizes);
    }

    private boolean shouldRestrictNetwork() {
        boolean isAnyRestrictedRequest = false;
        for (ApnContext apnContext : this.mApnContexts.keySet()) {
            if (!apnContext.hasRestrictedRequests(true)) continue;
            isAnyRestrictedRequest = true;
            break;
        }
        if (!isAnyRestrictedRequest) {
            return false;
        }
        if (!ApnSettingUtils.isMetered(this.mApnSetting, this.mPhone)) {
            return false;
        }
        if (!this.mPhone.getDataEnabledSettings().isDataEnabled()) {
            return true;
        }
        return !this.mDct.getDataRoamingEnabled() && this.mPhone.getServiceState().getDataRoaming();
    }

    private boolean isUnmeteredUseOnly() {
        if (this.mTransportType == 2) {
            return false;
        }
        if (this.mPhone.getDataEnabledSettings().isDataEnabled()) {
            return false;
        }
        if (this.mDct.getDataRoamingEnabled() && this.mPhone.getServiceState().getDataRoaming()) {
            return false;
        }
        for (ApnContext apnContext : this.mApnContexts.keySet()) {
            if (!ApnSettingUtils.isMeteredApnType(apnContext.getApnTypeBitmask(), this.mPhone)) continue;
            return false;
        }
        return true;
    }

    public NetworkCapabilities getNetworkCapabilities() {
        NetworkCapabilities result = new NetworkCapabilities();
        result.addTransportType(0);
        if (this.mApnSetting != null) {
            String[] types;
            block43: for (String type : types = ApnSetting.getApnTypesStringFromBitmask(this.mApnSetting.getApnTypeBitmask() & ~this.mDisabledApnTypeBitMask).split(",")) {
                if (!this.mRestrictedNetworkOverride && this.mUnmeteredUseOnly && ApnSettingUtils.isMeteredApnType(ApnSetting.getApnTypesBitmaskFromString(type), this.mPhone)) {
                    this.log("Dropped the metered " + type + " for the unmetered data call.");
                    continue;
                }
                switch (type) {
                    case "*": {
                        result.addCapability(12);
                        result.addCapability(0);
                        result.addCapability(1);
                        result.addCapability(3);
                        result.addCapability(4);
                        result.addCapability(5);
                        result.addCapability(7);
                        result.addCapability(2);
                        continue block43;
                    }
                    case "default": {
                        result.addCapability(12);
                        continue block43;
                    }
                    case "mms": {
                        result.addCapability(0);
                        continue block43;
                    }
                    case "supl": {
                        result.addCapability(1);
                        continue block43;
                    }
                    case "dun": {
                        result.addCapability(2);
                        continue block43;
                    }
                    case "fota": {
                        result.addCapability(3);
                        continue block43;
                    }
                    case "ims": {
                        result.addCapability(4);
                        continue block43;
                    }
                    case "cbs": {
                        result.addCapability(5);
                        continue block43;
                    }
                    case "ia": {
                        result.addCapability(7);
                        continue block43;
                    }
                    case "emergency": {
                        result.addCapability(10);
                        continue block43;
                    }
                    case "mcx": {
                        result.addCapability(23);
                        continue block43;
                    }
                }
            }
            if (this.mUnmeteredUseOnly && !this.mRestrictedNetworkOverride || !ApnSettingUtils.isMetered(this.mApnSetting, this.mPhone)) {
                result.addCapability(11);
            } else {
                result.removeCapability(11);
            }
            result.maybeMarkCapabilitiesRestricted();
        }
        if (this.mRestrictedNetworkOverride) {
            result.removeCapability(13);
            result.removeCapability(2);
        }
        int up = 14;
        int down = 14;
        switch (this.mRilRat) {
            case 1: {
                up = 80;
                down = 80;
                break;
            }
            case 2: {
                up = 59;
                down = 236;
                break;
            }
            case 3: {
                up = 384;
                down = 384;
                break;
            }
            case 4: 
            case 5: {
                up = 14;
                down = 14;
                break;
            }
            case 7: {
                up = 153;
                down = 2457;
                break;
            }
            case 8: {
                up = 1843;
                down = 3174;
                break;
            }
            case 6: {
                up = 100;
                down = 100;
                break;
            }
            case 9: {
                up = 2048;
                down = 14336;
                break;
            }
            case 10: {
                up = 5898;
                down = 14336;
                break;
            }
            case 11: {
                up = 5898;
                down = 14336;
                break;
            }
            case 12: {
                up = 1843;
                down = 5017;
                break;
            }
            case 14: {
                up = 51200;
                down = 102400;
                break;
            }
            case 19: {
                up = 51200;
                down = 102400;
                break;
            }
            case 13: {
                up = 153;
                down = 2516;
                break;
            }
            case 15: {
                up = 11264;
                down = 43008;
                break;
            }
        }
        result.setLinkUpstreamBandwidthKbps(up);
        result.setLinkDownstreamBandwidthKbps(down);
        result.setNetworkSpecifier(new StringNetworkSpecifier(Integer.toString(this.mSubId)));
        result.setCapability(18, !this.mPhone.getServiceState().getDataRoaming());
        result.addCapability(20);
        if ((this.mSubscriptionOverride & 1) != 0) {
            result.addCapability(11);
        }
        if ((this.mSubscriptionOverride & 2) != 0) {
            result.removeCapability(20);
        }
        return result;
    }

    @VisibleForTesting
    public boolean shouldSkip464Xlat() {
        switch (this.mApnSetting.getSkip464Xlat()) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        NetworkCapabilities nc = this.getNetworkCapabilities();
        return nc.hasCapability(4) && !nc.hasCapability(12);
    }

    @VisibleForTesting
    public static boolean isIpAddress(String address) {
        if (address == null) {
            return false;
        }
        return InetAddress.isNumeric((String)address);
    }

    private SetupResult setLinkProperties(DataCallResponse response, LinkProperties linkProperties) {
        SetupResult result;
        String propertyPrefix = "net." + response.getInterfaceName() + ".";
        String[] dnsServers = new String[]{SystemProperties.get(propertyPrefix + "dns1"), SystemProperties.get(propertyPrefix + "dns2")};
        boolean okToUseSystemPropertyDns = this.isDnsOk(dnsServers);
        linkProperties.clear();
        if (response.getCause() == 0) {
            try {
                linkProperties.setInterfaceName(response.getInterfaceName());
                if (response.getAddresses().size() > 0) {
                    for (LinkAddress la : response.getAddresses()) {
                        if (la.getAddress().isAnyLocalAddress()) continue;
                        this.log("addr/pl=" + la.getAddress() + "/" + la.getNetworkPrefixLength());
                        linkProperties.addLinkAddress(la);
                    }
                } else {
                    throw new UnknownHostException("no address for ifname=" + response.getInterfaceName());
                }
                if (response.getDnsAddresses().size() > 0) {
                    for (InetAddress dns : response.getDnsAddresses()) {
                        if (dns.isAnyLocalAddress()) continue;
                        linkProperties.addDnsServer(dns);
                    }
                } else if (okToUseSystemPropertyDns) {
                    for (String dnsAddr : dnsServers) {
                        InetAddress ia;
                        if ((dnsAddr = dnsAddr.trim()).isEmpty()) continue;
                        try {
                            ia = NetworkUtils.numericToInetAddress(dnsAddr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new UnknownHostException("Non-numeric dns addr=" + dnsAddr);
                        }
                        if (ia.isAnyLocalAddress()) continue;
                        linkProperties.addDnsServer(ia);
                    }
                } else {
                    throw new UnknownHostException("Empty dns response and no system default dns");
                }
                if (response.getPcscfAddresses().size() > 0) {
                    for (InetAddress pcscf : response.getPcscfAddresses()) {
                        linkProperties.addPcscfServer(pcscf);
                    }
                }
                for (InetAddress gateway : response.getGatewayAddresses()) {
                    linkProperties.addRoute(new RouteInfo(gateway));
                }
                linkProperties.setMtu(response.getMtu());
                result = SetupResult.SUCCESS;
            }
            catch (UnknownHostException e) {
                this.log("setLinkProperties: UnknownHostException " + e);
                result = SetupResult.ERROR_INVALID_ARG;
            }
        } else {
            result = SetupResult.ERROR_DATA_SERVICE_SPECIFIC_ERROR;
        }
        if (result != SetupResult.SUCCESS) {
            this.log("setLinkProperties: error clearing LinkProperties status=" + response.getCause() + " result=" + (Object)((Object)result));
            linkProperties.clear();
        }
        return result;
    }

    private boolean initConnection(ConnectionParams cp) {
        ApnContext apnContext = cp.mApnContext;
        if (this.mApnSetting == null) {
            this.mApnSetting = apnContext.getApnSetting();
        }
        if (this.mApnSetting == null || !this.mApnSetting.canHandleType(apnContext.getApnTypeBitmask())) {
            this.log("initConnection: incompatible apnSetting in ConnectionParams cp=" + cp + " dc=" + this);
            return false;
        }
        ++this.mTag;
        this.mConnectionParams = cp;
        this.mConnectionParams.mTag = this.mTag;
        this.mApnContexts.put(apnContext, cp);
        this.log("initConnection:  RefCount=" + this.mApnContexts.size() + " mApnList=" + this.mApnContexts + " mConnectionParams=" + this.mConnectionParams);
        return true;
    }

    private void updateNetworkInfo() {
        ServiceState state = this.mPhone.getServiceState();
        int subtype = state.getDataNetworkType();
        this.mNetworkInfo.setSubtype(subtype, TelephonyManager.getNetworkTypeName(subtype));
        this.mNetworkInfo.setRoaming(state.getDataRoaming());
    }

    private void updateNetworkInfoSuspendState() {
        ServiceStateTracker sst;
        if (this.mNetworkAgent == null) {
            Rlog.e(this.getName(), "Setting suspend state without a NetworkAgent");
        }
        if ((sst = this.mPhone.getServiceStateTracker()).getCurrentDataConnectionState() != 0) {
            this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, null, this.mNetworkInfo.getExtraInfo());
        } else {
            CallTracker ct;
            if (!sst.isConcurrentVoiceAndDataAllowed() && (ct = this.mPhone.getCallTracker()).getState() != PhoneConstants.State.IDLE) {
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, null, this.mNetworkInfo.getExtraInfo());
                return;
            }
            this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, this.mNetworkInfo.getExtraInfo());
        }
    }

    public void bringUp(ApnContext apnContext, int profileId, int rilRadioTechnology, Message onCompletedMsg, int connectionGeneration, int requestType, int subId) {
        this.log("bringUp: apnContext=" + apnContext + " onCompletedMsg=" + onCompletedMsg);
        this.sendMessage(262144, new ConnectionParams(apnContext, profileId, rilRadioTechnology, onCompletedMsg, connectionGeneration, requestType, subId));
    }

    public void tearDown(ApnContext apnContext, String reason, Message onCompletedMsg) {
        this.log("tearDown: apnContext=" + apnContext + " reason=" + reason + " onCompletedMsg=" + onCompletedMsg);
        this.sendMessage(262148, new DisconnectParams(apnContext, reason, 2, onCompletedMsg));
    }

    void tearDownNow() {
        this.log("tearDownNow()");
        this.sendMessage(this.obtainMessage(262152));
    }

    public void tearDownAll(String reason, int releaseType, Message onCompletedMsg) {
        this.log("tearDownAll: reason=" + reason + ", releaseType=" + releaseType);
        this.sendMessage(262150, new DisconnectParams(null, reason, releaseType, onCompletedMsg));
    }

    public void reset() {
        this.sendMessage(262168);
        this.log("reset");
    }

    void reevaluateRestrictedState() {
        this.sendMessage(262169);
        this.log("reevaluate restricted state");
    }

    void reevaluateDataConnectionProperties() {
        this.sendMessage(262170);
        this.log("reevaluate data connection properties");
    }

    public ConnectionParams getConnectionParams() {
        return this.mConnectionParams;
    }

    public String[] getPcscfAddresses() {
        return this.mPcscfAddr;
    }

    private long getSuggestedRetryDelay(DataCallResponse response) {
        if (response.getSuggestedRetryTime() < 0) {
            this.log("No suggested retry delay.");
            return -2L;
        }
        if (response.getSuggestedRetryTime() == Integer.MAX_VALUE) {
            this.log("Modem suggested not retrying.");
            return -1L;
        }
        return response.getSuggestedRetryTime();
    }

    public List<ApnContext> getApnContexts() {
        return new ArrayList<ApnContext>(this.mApnContexts.keySet());
    }

    DcNetworkAgent getNetworkAgent() {
        return this.mNetworkAgent;
    }

    void setHandoverState(int state) {
        this.mHandoverState = state;
    }

    @Override
    protected String getWhatToString(int what) {
        return DataConnection.cmdToString(what);
    }

    private static String msgToString(Message msg) {
        String retVal;
        if (msg == null) {
            retVal = "null";
        } else {
            StringBuilder b = new StringBuilder();
            b.append("{what=");
            b.append(DataConnection.cmdToString(msg.what));
            b.append(" when=");
            TimeUtils.formatDuration(msg.getWhen() - SystemClock.uptimeMillis(), b);
            if (msg.arg1 != 0) {
                b.append(" arg1=");
                b.append(msg.arg1);
            }
            if (msg.arg2 != 0) {
                b.append(" arg2=");
                b.append(msg.arg2);
            }
            if (msg.obj != null) {
                b.append(" obj=");
                b.append(msg.obj);
            }
            b.append(" target=");
            b.append(msg.getTarget());
            b.append(" replyTo=");
            b.append(msg.replyTo);
            b.append("}");
            retVal = b.toString();
        }
        return retVal;
    }

    static void slog(String s) {
        Rlog.d("DC", s);
    }

    @Override
    protected void log(String s) {
        Rlog.d(this.getName(), s);
    }

    @Override
    protected void logd(String s) {
        Rlog.d(this.getName(), s);
    }

    @Override
    protected void logv(String s) {
        Rlog.v(this.getName(), s);
    }

    @Override
    protected void logi(String s) {
        Rlog.i(this.getName(), s);
    }

    @Override
    protected void logw(String s) {
        Rlog.w(this.getName(), s);
    }

    @Override
    protected void loge(String s) {
        Rlog.e(this.getName(), s);
    }

    @Override
    protected void loge(String s, Throwable e) {
        Rlog.e(this.getName(), s, e);
    }

    public String toStringSimple() {
        return this.getName() + ": State=" + this.getCurrentState().getName() + " mApnSetting=" + this.mApnSetting + " RefCount=" + this.mApnContexts.size() + " mCid=" + this.mCid + " mCreateTime=" + this.mCreateTime + " mLastastFailTime=" + this.mLastFailTime + " mLastFailCause=" + this.mLastFailCause + " mTag=" + this.mTag + " mLinkProperties=" + this.mLinkProperties + " linkCapabilities=" + this.getNetworkCapabilities() + " mRestrictedNetworkOverride=" + this.mRestrictedNetworkOverride;
    }

    @Override
    public String toString() {
        return "{" + this.toStringSimple() + " mApnContexts=" + this.mApnContexts + "}";
    }

    private boolean isNRConnected() {
        return this.mPhone.getServiceState().getNrState() == 3;
    }

    private void dumpToLog() {
        this.dump(null, new PrintWriter(new StringWriter(0)){

            @Override
            public void println(String s) {
                DataConnection.this.logd(s);
            }

            @Override
            public void flush() {
            }
        }, null);
    }

    private void updateScore() {
        int oldScore = this.mScore;
        this.mScore = this.calculateScore();
        if (oldScore != this.mScore && this.mNetworkAgent != null) {
            this.log("Updating score from " + oldScore + " to " + this.mScore);
            this.mNetworkAgent.sendNetworkScore(this.mScore, this);
        }
    }

    private int calculateScore() {
        int score = 45;
        block0: for (ApnContext apnContext : this.mApnContexts.keySet()) {
            for (NetworkRequest networkRequest : apnContext.getNetworkRequests()) {
                if (!networkRequest.hasCapability(12) || networkRequest.networkCapabilities.getNetworkSpecifier() != null) continue;
                score = 50;
                continue block0;
            }
        }
        return score;
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter printWriter, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printWriter, " ");
        pw.print("DataConnection ");
        super.dump(fd, pw, args);
        pw.flush();
        pw.increaseIndent();
        pw.println("transport type=" + AccessNetworkConstants.transportTypeToString(this.mTransportType));
        pw.println("mApnContexts.size=" + this.mApnContexts.size());
        pw.println("mApnContexts=" + this.mApnContexts);
        pw.println("mApnSetting=" + this.mApnSetting);
        pw.println("mTag=" + this.mTag);
        pw.println("mCid=" + this.mCid);
        pw.println("mConnectionParams=" + this.mConnectionParams);
        pw.println("mDisconnectParams=" + this.mDisconnectParams);
        pw.println("mDcFailCause=" + this.mDcFailCause);
        pw.println("mPhone=" + this.mPhone);
        pw.println("mSubId=" + this.mSubId);
        pw.println("mLinkProperties=" + this.mLinkProperties);
        pw.flush();
        pw.println("mDataRegState=" + this.mDataRegState);
        pw.println("mHandoverState=" + this.mHandoverState);
        pw.println("mRilRat=" + this.mRilRat);
        pw.println("mNetworkCapabilities=" + this.getNetworkCapabilities());
        pw.println("mCreateTime=" + TimeUtils.logTimeOfDay(this.mCreateTime));
        pw.println("mLastFailTime=" + TimeUtils.logTimeOfDay(this.mLastFailTime));
        pw.println("mLastFailCause=" + this.mLastFailCause);
        pw.println("mUserData=" + this.mUserData);
        pw.println("mSubscriptionOverride=" + Integer.toHexString(this.mSubscriptionOverride));
        pw.println("mRestrictedNetworkOverride=" + this.mRestrictedNetworkOverride);
        pw.println("mUnmeteredUseOnly=" + this.mUnmeteredUseOnly);
        pw.println("mInstanceNumber=" + mInstanceNumber);
        pw.println("mAc=" + this.mAc);
        pw.println("mScore=" + this.mScore);
        if (this.mNetworkAgent != null) {
            this.mNetworkAgent.dump(fd, pw, args);
        }
        pw.decreaseIndent();
        pw.println();
        pw.flush();
    }

    static {
        DataConnection.sCmdToString[0] = "EVENT_CONNECT";
        DataConnection.sCmdToString[1] = "EVENT_SETUP_DATA_CONNECTION_DONE";
        DataConnection.sCmdToString[3] = "EVENT_DEACTIVATE_DONE";
        DataConnection.sCmdToString[4] = "EVENT_DISCONNECT";
        DataConnection.sCmdToString[5] = "EVENT_RIL_CONNECTED";
        DataConnection.sCmdToString[6] = "EVENT_DISCONNECT_ALL";
        DataConnection.sCmdToString[7] = "EVENT_DATA_STATE_CHANGED";
        DataConnection.sCmdToString[8] = "EVENT_TEAR_DOWN_NOW";
        DataConnection.sCmdToString[9] = "EVENT_LOST_CONNECTION";
        DataConnection.sCmdToString[11] = "EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED";
        DataConnection.sCmdToString[12] = "EVENT_DATA_CONNECTION_ROAM_ON";
        DataConnection.sCmdToString[13] = "EVENT_DATA_CONNECTION_ROAM_OFF";
        DataConnection.sCmdToString[14] = "EVENT_BW_REFRESH_RESPONSE";
        DataConnection.sCmdToString[15] = "EVENT_DATA_CONNECTION_VOICE_CALL_STARTED";
        DataConnection.sCmdToString[16] = "EVENT_DATA_CONNECTION_VOICE_CALL_ENDED";
        DataConnection.sCmdToString[17] = "EVENT_DATA_CONNECTION_OVERRIDE_CHANGED";
        DataConnection.sCmdToString[18] = "EVENT_KEEPALIVE_STATUS";
        DataConnection.sCmdToString[19] = "EVENT_KEEPALIVE_STARTED";
        DataConnection.sCmdToString[20] = "EVENT_KEEPALIVE_STOPPED";
        DataConnection.sCmdToString[21] = "EVENT_KEEPALIVE_START_REQUEST";
        DataConnection.sCmdToString[22] = "EVENT_KEEPALIVE_STOP_REQUEST";
        DataConnection.sCmdToString[23] = "EVENT_LINK_CAPACITY_CHANGED";
        DataConnection.sCmdToString[24] = "EVENT_RESET";
        DataConnection.sCmdToString[25] = "EVENT_REEVALUATE_RESTRICTED_STATE";
        DataConnection.sCmdToString[26] = "EVENT_REEVALUATE_DATA_CONNECTION_PROPERTIES";
    }

    private class DcDisconnectionErrorCreatingConnection
    extends State {
        private DcDisconnectionErrorCreatingConnection() {
        }

        @Override
        public void enter() {
            StatsLog.write(75, 5, DataConnection.this.mPhone.getPhoneId(), DataConnection.this.mId, DataConnection.this.mApnSetting != null ? (long)DataConnection.this.mApnSetting.getApnTypeBitmask() : 0L, DataConnection.this.mApnSetting != null ? DataConnection.this.mApnSetting.canHandleType(17) : false);
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262147: {
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    if (cp.mTag == DataConnection.this.mTag) {
                        String str = "DcDisconnectionErrorCreatingConnection msg.what=EVENT_DEACTIVATE_DONE";
                        DataConnection.this.log(str);
                        if (cp.mApnContext != null) {
                            cp.mApnContext.requestLog(str);
                        }
                        DataConnection.this.mInactiveState.setEnterNotificationParams(cp, 65538);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcDisconnectionErrorCreatingConnection stale EVENT_DEACTIVATE_DONE dp.tag=" + cp.mTag + ", mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcDisconnectionErrorCreatingConnection not handled msg.what=" + DataConnection.this.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcDisconnectingState
    extends State {
        private DcDisconnectingState() {
        }

        @Override
        public void enter() {
            StatsLog.write(75, 4, DataConnection.this.mPhone.getPhoneId(), DataConnection.this.mId, DataConnection.this.mApnSetting != null ? (long)DataConnection.this.mApnSetting.getApnTypeBitmask() : 0L, DataConnection.this.mApnSetting != null ? DataConnection.this.mApnSetting.canHandleType(17) : false);
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262144: {
                    DataConnection.this.log("DcDisconnectingState msg.what=EVENT_CONNECT. Defer. RefCount = " + DataConnection.this.mApnContexts.size());
                    DataConnection.this.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 262147: {
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    String str = "DcDisconnectingState msg.what=EVENT_DEACTIVATE_DONE RefCount=" + DataConnection.this.mApnContexts.size();
                    DataConnection.this.log(str);
                    if (dp.mApnContext != null) {
                        dp.mApnContext.requestLog(str);
                    }
                    if (dp.mTag == DataConnection.this.mTag) {
                        DataConnection.this.mInactiveState.setEnterNotificationParams(dp);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcDisconnectState stale EVENT_DEACTIVATE_DONE dp.tag=" + dp.mTag + " mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcDisconnectingState not handled msg.what=" + DataConnection.this.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcActiveState
    extends State {
        private DcActiveState() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void enter() {
            DataConnection.this.log("DcActiveState: enter dc=" + DataConnection.this);
            StatsLog.write(75, 3, DataConnection.this.mPhone.getPhoneId(), DataConnection.this.mId, DataConnection.this.mApnSetting != null ? (long)DataConnection.this.mApnSetting.getApnTypeBitmask() : 0L, DataConnection.this.mApnSetting != null ? DataConnection.this.mApnSetting.canHandleType(17) : false);
            DataConnection.this.updateNetworkInfo();
            DataConnection.this.notifyAllWithEvent(null, 270336, "connected");
            DataConnection.this.mPhone.getCallTracker().registerForVoiceCallStarted(DataConnection.this.getHandler(), 262159, null);
            DataConnection.this.mPhone.getCallTracker().registerForVoiceCallEnded(DataConnection.this.getHandler(), 262160, null);
            DataConnection.this.mDcController.addActiveDcByCid(DataConnection.this);
            DataConnection.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, DataConnection.this.mNetworkInfo.getReason(), null);
            DataConnection.this.mNetworkInfo.setExtraInfo(DataConnection.this.mApnSetting.getApnName());
            DataConnection.this.updateTcpBufferSizes(DataConnection.this.mRilRat);
            NetworkMisc misc = new NetworkMisc();
            CarrierSignalAgent carrierSignalAgent = DataConnection.this.mPhone.getCarrierSignalAgent();
            if (carrierSignalAgent.hasRegisteredReceivers("com.android.internal.telephony.CARRIER_SIGNAL_REDIRECTED")) {
                misc.provisioningNotificationDisabled = true;
            }
            misc.subscriberId = DataConnection.this.mPhone.getSubscriberId();
            misc.skip464xlat = DataConnection.this.shouldSkip464Xlat();
            DataConnection.this.mRestrictedNetworkOverride = DataConnection.this.shouldRestrictNetwork();
            DataConnection.this.mUnmeteredUseOnly = DataConnection.this.isUnmeteredUseOnly();
            DataConnection.this.log("mRestrictedNetworkOverride = " + DataConnection.this.mRestrictedNetworkOverride + ", mUnmeteredUseOnly = " + DataConnection.this.mUnmeteredUseOnly);
            if (DataConnection.this.mConnectionParams != null && ((DataConnection)DataConnection.this).mConnectionParams.mRequestType == 2) {
                DcTracker dcTracker = DataConnection.this.mPhone.getDcTracker(DataConnection.this.getHandoverSourceTransport());
                DataConnection dc = dcTracker.getDataConnectionByApnType(((DataConnection)DataConnection.this).mConnectionParams.mApnContext.getApnType());
                if (dc != null) {
                    dc.setHandoverState(3);
                }
                if (DataConnection.this.mHandoverSourceNetworkAgent == null) {
                    DataConnection.this.loge("Failed to get network agent from original data connection");
                    return;
                }
                DataConnection.this.log("Transfer network agent successfully.");
                DataConnection.this.mNetworkAgent = DataConnection.this.mHandoverSourceNetworkAgent;
                DataConnection.this.mNetworkAgent.acquireOwnership(DataConnection.this, DataConnection.this.mTransportType);
                DataConnection.this.mNetworkAgent.sendNetworkCapabilities(DataConnection.this.getNetworkCapabilities(), DataConnection.this);
                DataConnection.this.mNetworkAgent.sendLinkProperties(DataConnection.this.mLinkProperties, DataConnection.this);
                DataConnection.this.mHandoverSourceNetworkAgent = null;
            } else {
                DataConnection.this.mScore = DataConnection.this.calculateScore();
                TelephonyNetworkFactory factory = PhoneFactory.getNetworkFactory(DataConnection.this.mPhone.getPhoneId());
                int factorySerialNumber = null == factory ? -1 : factory.getSerialNumber();
                DataConnection.this.mNetworkAgent = DcNetworkAgent.createDcNetworkAgent(DataConnection.this, DataConnection.this.mPhone, DataConnection.this.mNetworkInfo, DataConnection.this.mScore, misc, factorySerialNumber, DataConnection.this.mTransportType);
            }
            if (DataConnection.this.mTransportType == 1) {
                ((DataConnection)DataConnection.this).mPhone.mCi.registerForNattKeepaliveStatus(DataConnection.this.getHandler(), 262162, null);
                ((DataConnection)DataConnection.this).mPhone.mCi.registerForLceInfo(DataConnection.this.getHandler(), 262167, null);
            }
            TelephonyMetrics.getInstance().writeRilDataCallEvent(DataConnection.this.mPhone.getPhoneId(), DataConnection.this.mCid, DataConnection.this.mApnSetting.getApnTypeBitmask(), 1);
        }

        @Override
        public void exit() {
            DataConnection.this.log("DcActiveState: exit dc=" + this);
            String reason = DataConnection.this.mNetworkInfo.getReason();
            reason = DataConnection.this.mDcController.isExecutingCarrierChange() ? "carrierChange" : (DataConnection.this.mDisconnectParams != null && ((DataConnection)DataConnection.this).mDisconnectParams.mReason != null ? ((DataConnection)DataConnection.this).mDisconnectParams.mReason : DataFailCause.toString(DataConnection.this.mDcFailCause));
            DataConnection.this.mPhone.getCallTracker().unregisterForVoiceCallStarted(DataConnection.this.getHandler());
            DataConnection.this.mPhone.getCallTracker().unregisterForVoiceCallEnded(DataConnection.this.getHandler());
            if (DataConnection.this.mHandoverState != 2) {
                DataConnection.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, reason, DataConnection.this.mNetworkInfo.getExtraInfo());
            }
            if (DataConnection.this.mTransportType == 1) {
                ((DataConnection)DataConnection.this).mPhone.mCi.unregisterForNattKeepaliveStatus(DataConnection.this.getHandler());
                ((DataConnection)DataConnection.this).mPhone.mCi.unregisterForLceInfo(DataConnection.this.getHandler());
            }
            if (DataConnection.this.mNetworkAgent != null) {
                DataConnection.this.mNetworkAgent.sendNetworkInfo(DataConnection.this.mNetworkInfo, DataConnection.this);
                DataConnection.this.mNetworkAgent.releaseOwnership(DataConnection.this);
            }
            DataConnection.this.mNetworkAgent = null;
            TelephonyMetrics.getInstance().writeRilDataCallEvent(DataConnection.this.mPhone.getPhoneId(), DataConnection.this.mCid, DataConnection.this.mApnSetting.getApnTypeBitmask(), 2);
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262144: {
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    DataConnection.this.mApnContexts.put(cp.mApnContext, cp);
                    DataConnection.this.mDisabledApnTypeBitMask &= ~cp.mApnContext.getApnTypeBitmask();
                    DataConnection.this.mNetworkAgent.sendNetworkCapabilities(DataConnection.this.getNetworkCapabilities(), DataConnection.this);
                    DataConnection.this.log("DcActiveState: EVENT_CONNECT cp=" + cp + " dc=" + DataConnection.this);
                    DataConnection.this.notifyConnectCompleted(cp, 0, false);
                    retVal = true;
                    break;
                }
                case 262148: {
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    DataConnection.this.log("DcActiveState: EVENT_DISCONNECT dp=" + dp + " dc=" + DataConnection.this);
                    if (DataConnection.this.mApnContexts.containsKey(dp.mApnContext)) {
                        DataConnection.this.log("DcActiveState msg.what=EVENT_DISCONNECT RefCount=" + DataConnection.this.mApnContexts.size());
                        if (DataConnection.this.mApnContexts.size() == 1) {
                            DataConnection.this.mApnContexts.clear();
                            DataConnection.this.mDisconnectParams = dp;
                            DataConnection.this.mConnectionParams = null;
                            dp.mTag = DataConnection.this.mTag;
                            DataConnection.this.tearDownData(dp);
                            DataConnection.this.transitionTo(DataConnection.this.mDisconnectingState);
                        } else {
                            DataConnection.this.mApnContexts.remove(dp.mApnContext);
                            DataConnection.this.mDisabledApnTypeBitMask |= dp.mApnContext.getApnTypeBitmask();
                            DataConnection.this.mNetworkAgent.sendNetworkCapabilities(DataConnection.this.getNetworkCapabilities(), DataConnection.this);
                            DataConnection.this.notifyDisconnectCompleted(dp, false);
                        }
                    } else {
                        DataConnection.this.log("DcActiveState ERROR no such apnContext=" + dp.mApnContext + " in this dc=" + DataConnection.this);
                        DataConnection.this.notifyDisconnectCompleted(dp, false);
                    }
                    retVal = true;
                    break;
                }
                case 262150: {
                    DataConnection.this.log("DcActiveState EVENT_DISCONNECT clearing apn contexts, dc=" + DataConnection.this);
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    DataConnection.this.mDisconnectParams = dp;
                    DataConnection.this.mConnectionParams = null;
                    dp.mTag = DataConnection.this.mTag;
                    DataConnection.this.tearDownData(dp);
                    DataConnection.this.transitionTo(DataConnection.this.mDisconnectingState);
                    retVal = true;
                    break;
                }
                case 262153: {
                    DataConnection.this.log("DcActiveState EVENT_LOST_CONNECTION dc=" + DataConnection.this);
                    DataConnection.this.mInactiveState.setEnterNotificationParams(65540);
                    DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    retVal = true;
                    break;
                }
                case 262156: 
                case 262157: 
                case 262161: {
                    DataConnection.this.updateNetworkInfo();
                    if (DataConnection.this.mNetworkAgent != null) {
                        DataConnection.this.mNetworkAgent.sendNetworkCapabilities(DataConnection.this.getNetworkCapabilities(), DataConnection.this);
                        DataConnection.this.mNetworkAgent.sendNetworkInfo(DataConnection.this.mNetworkInfo, DataConnection.this);
                    }
                    retVal = true;
                    break;
                }
                case 262158: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        DataConnection.this.log("EVENT_BW_REFRESH_RESPONSE: error ignoring, e=" + ar.exception);
                    } else {
                        LinkCapacityEstimate lce = (LinkCapacityEstimate)ar.result;
                        NetworkCapabilities nc = DataConnection.this.getNetworkCapabilities();
                        if (DataConnection.this.mPhone.getLceStatus() == 1) {
                            nc.setLinkDownstreamBandwidthKbps(lce.downlinkCapacityKbps);
                            if (DataConnection.this.mNetworkAgent != null) {
                                DataConnection.this.mNetworkAgent.sendNetworkCapabilities(nc, DataConnection.this);
                            }
                        }
                    }
                    retVal = true;
                    break;
                }
                case 262159: 
                case 262160: {
                    DataConnection.this.updateNetworkInfo();
                    DataConnection.this.updateNetworkInfoSuspendState();
                    if (DataConnection.this.mNetworkAgent != null) {
                        DataConnection.this.mNetworkAgent.sendNetworkCapabilities(DataConnection.this.getNetworkCapabilities(), DataConnection.this);
                        DataConnection.this.mNetworkAgent.sendNetworkInfo(DataConnection.this.mNetworkInfo, DataConnection.this);
                    }
                    retVal = true;
                    break;
                }
                case 262165: {
                    KeepalivePacketData pkt = (KeepalivePacketData)msg.obj;
                    int slotId = msg.arg1;
                    int intervalMillis = msg.arg2 * 1000;
                    if (DataConnection.this.mTransportType == 1) {
                        ((DataConnection)DataConnection.this).mPhone.mCi.startNattKeepalive(DataConnection.this.mCid, pkt, intervalMillis, DataConnection.this.obtainMessage(262163, slotId, 0, null));
                    } else if (DataConnection.this.mNetworkAgent != null) {
                        DataConnection.this.mNetworkAgent.onSocketKeepaliveEvent(msg.arg1, -20);
                    }
                    retVal = true;
                    break;
                }
                case 262166: {
                    int slotId = msg.arg1;
                    int handle = ((DataConnection)DataConnection.this).mNetworkAgent.keepaliveTracker.getHandleForSlot(slotId);
                    if (handle < 0) {
                        DataConnection.this.loge("No slot found for stopSocketKeepalive! " + slotId);
                        retVal = true;
                        break;
                    }
                    DataConnection.this.logd("Stopping keepalive with handle: " + handle);
                    ((DataConnection)DataConnection.this).mPhone.mCi.stopNattKeepalive(handle, DataConnection.this.obtainMessage(262164, handle, slotId, null));
                    retVal = true;
                    break;
                }
                case 262163: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    int slot = msg.arg1;
                    if (ar.exception != null || ar.result == null) {
                        DataConnection.this.loge("EVENT_KEEPALIVE_STARTED: error starting keepalive, e=" + ar.exception);
                        DataConnection.this.mNetworkAgent.onSocketKeepaliveEvent(slot, -31);
                    } else {
                        KeepaliveStatus ks = (KeepaliveStatus)ar.result;
                        if (ks == null) {
                            DataConnection.this.loge("Null KeepaliveStatus received!");
                        } else {
                            ((DataConnection)DataConnection.this).mNetworkAgent.keepaliveTracker.handleKeepaliveStarted(slot, ks);
                        }
                    }
                    retVal = true;
                    break;
                }
                case 262162: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        DataConnection.this.loge("EVENT_KEEPALIVE_STATUS: error in keepalive, e=" + ar.exception);
                    }
                    if (ar.result != null) {
                        KeepaliveStatus ks = (KeepaliveStatus)ar.result;
                        ((DataConnection)DataConnection.this).mNetworkAgent.keepaliveTracker.handleKeepaliveStatus(ks);
                    }
                    retVal = true;
                    break;
                }
                case 262164: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    int handle = msg.arg1;
                    int slotId = msg.arg2;
                    if (ar.exception != null) {
                        DataConnection.this.loge("EVENT_KEEPALIVE_STOPPED: error stopping keepalive for handle=" + handle + " e=" + ar.exception);
                        ((DataConnection)DataConnection.this).mNetworkAgent.keepaliveTracker.handleKeepaliveStatus(new KeepaliveStatus(3));
                    } else {
                        DataConnection.this.log("Keepalive Stop Requested for handle=" + handle);
                        ((DataConnection)DataConnection.this).mNetworkAgent.keepaliveTracker.handleKeepaliveStatus(new KeepaliveStatus(handle, 1));
                    }
                    retVal = true;
                    break;
                }
                case 262167: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        DataConnection.this.loge("EVENT_LINK_CAPACITY_CHANGED e=" + ar.exception);
                    } else {
                        LinkCapacityEstimate lce = (LinkCapacityEstimate)ar.result;
                        NetworkCapabilities nc = DataConnection.this.getNetworkCapabilities();
                        if (lce.downlinkCapacityKbps != -1) {
                            nc.setLinkDownstreamBandwidthKbps(lce.downlinkCapacityKbps);
                        }
                        if (lce.uplinkCapacityKbps != -1) {
                            nc.setLinkUpstreamBandwidthKbps(lce.uplinkCapacityKbps);
                        }
                        if (DataConnection.this.mNetworkAgent != null) {
                            DataConnection.this.mNetworkAgent.sendNetworkCapabilities(nc, DataConnection.this);
                        }
                    }
                    retVal = true;
                    break;
                }
                case 262169: {
                    if (DataConnection.this.mRestrictedNetworkOverride && !DataConnection.this.shouldRestrictNetwork()) {
                        DataConnection.this.log("Data connection becomes not-restricted. dc=" + this);
                        DataConnection.this.mRestrictedNetworkOverride = false;
                        DataConnection.this.mNetworkAgent.sendNetworkCapabilities(DataConnection.this.getNetworkCapabilities(), DataConnection.this);
                    }
                    if (DataConnection.this.mUnmeteredUseOnly && !DataConnection.this.isUnmeteredUseOnly()) {
                        DataConnection.this.mUnmeteredUseOnly = false;
                        DataConnection.this.mNetworkAgent.sendNetworkCapabilities(DataConnection.this.getNetworkCapabilities(), DataConnection.this);
                    }
                    retVal = true;
                    break;
                }
                case 262170: {
                    DataConnection.this.updateScore();
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcActiveState not handled msg.what=" + DataConnection.this.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcActivatingState
    extends State {
        private DcActivatingState() {
        }

        @Override
        public void enter() {
            StatsLog.write(75, 2, DataConnection.this.mPhone.getPhoneId(), DataConnection.this.mId, DataConnection.this.mApnSetting != null ? (long)DataConnection.this.mApnSetting.getApnTypeBitmask() : 0L, DataConnection.this.mApnSetting != null ? DataConnection.this.mApnSetting.canHandleType(17) : false);
            DataConnection.this.setHandoverState(1);
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            DataConnection.this.log("DcActivatingState: msg=" + DataConnection.msgToString(msg));
            switch (msg.what) {
                case 262144: 
                case 262155: {
                    DataConnection.this.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 262145: {
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    DataCallResponse dataCallResponse = (DataCallResponse)msg.getData().getParcelable("data_call_response");
                    SetupResult result = DataConnection.this.onSetupConnectionCompleted(msg.arg1, dataCallResponse, cp);
                    if (result != SetupResult.ERROR_STALE && DataConnection.this.mConnectionParams != cp) {
                        DataConnection.this.loge("DcActivatingState: WEIRD mConnectionsParams:" + DataConnection.this.mConnectionParams + " != cp:" + cp);
                    }
                    DataConnection.this.log("DcActivatingState onSetupConnectionCompleted result=" + (Object)((Object)result) + " dc=" + DataConnection.this);
                    if (cp.mApnContext != null) {
                        cp.mApnContext.requestLog("onSetupConnectionCompleted result=" + (Object)((Object)result));
                    }
                    switch (result) {
                        case SUCCESS: {
                            DataConnection.this.mDcFailCause = 0;
                            DataConnection.this.transitionTo(DataConnection.this.mActiveState);
                            break;
                        }
                        case ERROR_RADIO_NOT_AVAILABLE: {
                            DataConnection.this.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                            DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                            break;
                        }
                        case ERROR_INVALID_ARG: {
                            DataConnection.this.tearDownData(cp);
                            DataConnection.this.transitionTo(DataConnection.this.mDisconnectingErrorCreatingConnection);
                            break;
                        }
                        case ERROR_DATA_SERVICE_SPECIFIC_ERROR: {
                            long delay = DataConnection.this.getSuggestedRetryDelay(dataCallResponse);
                            cp.mApnContext.setModemSuggestedDelay(delay);
                            String str = "DcActivatingState: ERROR_DATA_SERVICE_SPECIFIC_ERROR  delay=" + delay + " result=" + (Object)((Object)result) + " result.isRadioRestartFailure=" + DataFailCause.isRadioRestartFailure(DataConnection.this.mPhone.getContext(), result.mFailCause, DataConnection.this.mPhone.getSubId()) + " isPermanentFailure=" + DataConnection.this.mDct.isPermanentFailure(result.mFailCause);
                            DataConnection.this.log(str);
                            if (cp.mApnContext != null) {
                                cp.mApnContext.requestLog(str);
                            }
                            DataConnection.this.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                            DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                            break;
                        }
                        case ERROR_STALE: {
                            DataConnection.this.loge("DcActivatingState: stale EVENT_SETUP_DATA_CONNECTION_DONE tag:" + cp.mTag + " != mTag:" + DataConnection.this.mTag);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown SetupResult, should not happen");
                        }
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcActivatingState not handled msg.what=" + DataConnection.this.getWhatToString(msg.what) + " RefCount=" + DataConnection.this.mApnContexts.size());
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcInactiveState
    extends State {
        private DcInactiveState() {
        }

        public void setEnterNotificationParams(ConnectionParams cp, int cause) {
            DataConnection.this.log("DcInactiveState: setEnterNotificationParams cp,cause");
            DataConnection.this.mConnectionParams = cp;
            DataConnection.this.mDisconnectParams = null;
            DataConnection.this.mDcFailCause = cause;
        }

        public void setEnterNotificationParams(DisconnectParams dp) {
            DataConnection.this.log("DcInactiveState: setEnterNotificationParams dp");
            DataConnection.this.mConnectionParams = null;
            DataConnection.this.mDisconnectParams = dp;
            DataConnection.this.mDcFailCause = 0;
        }

        public void setEnterNotificationParams(int cause) {
            DataConnection.this.mConnectionParams = null;
            DataConnection.this.mDisconnectParams = null;
            DataConnection.this.mDcFailCause = cause;
        }

        @Override
        public void enter() {
            ++DataConnection.this.mTag;
            DataConnection.this.log("DcInactiveState: enter() mTag=" + DataConnection.this.mTag);
            StatsLog.write(75, 1, DataConnection.this.mPhone.getPhoneId(), DataConnection.this.mId, DataConnection.this.mApnSetting != null ? (long)DataConnection.this.mApnSetting.getApnTypeBitmask() : 0L, DataConnection.this.mApnSetting != null ? DataConnection.this.mApnSetting.canHandleType(17) : false);
            if (DataConnection.this.mHandoverState == 2) {
                DataConnection.this.mHandoverState = 3;
            }
            if (DataConnection.this.mConnectionParams != null) {
                DataConnection.this.log("DcInactiveState: enter notifyConnectCompleted +ALL failCause=" + DataConnection.this.mDcFailCause);
                DataConnection.this.notifyConnectCompleted(DataConnection.this.mConnectionParams, DataConnection.this.mDcFailCause, true);
            }
            if (DataConnection.this.mDisconnectParams != null) {
                DataConnection.this.log("DcInactiveState: enter notifyDisconnectCompleted +ALL failCause=" + DataConnection.this.mDcFailCause);
                DataConnection.this.notifyDisconnectCompleted(DataConnection.this.mDisconnectParams, true);
            }
            if (DataConnection.this.mDisconnectParams == null && DataConnection.this.mConnectionParams == null && DataConnection.this.mDcFailCause != 0) {
                DataConnection.this.log("DcInactiveState: enter notifyAllDisconnectCompleted failCause=" + DataConnection.this.mDcFailCause);
                DataConnection.this.notifyAllWithEvent(null, 270351, DataFailCause.toString(DataConnection.this.mDcFailCause));
            }
            DataConnection.this.mDcController.removeActiveDcByCid(DataConnection.this);
            DataConnection.this.clearSettings();
        }

        @Override
        public void exit() {
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 262168: 
                case 262169: {
                    DataConnection.this.log("DcInactiveState: msg.what=" + DataConnection.this.getWhatToString(msg.what) + ", ignore we're already done");
                    return true;
                }
                case 262144: {
                    DataConnection.this.log("DcInactiveState: mag.what=EVENT_CONNECT");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    if (!DataConnection.this.initConnection(cp)) {
                        DataConnection.this.log("DcInactiveState: msg.what=EVENT_CONNECT initConnection failed");
                        DataConnection.this.notifyConnectCompleted(cp, 65538, false);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                        return true;
                    }
                    int cause = DataConnection.this.connect(cp);
                    if (cause != 0) {
                        DataConnection.this.log("DcInactiveState: msg.what=EVENT_CONNECT connect failed");
                        DataConnection.this.notifyConnectCompleted(cp, cause, false);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                        return true;
                    }
                    if (DataConnection.this.mSubId == -1) {
                        DataConnection.this.mSubId = cp.mSubId;
                    }
                    DataConnection.this.transitionTo(DataConnection.this.mActivatingState);
                    return true;
                }
                case 262148: {
                    DataConnection.this.log("DcInactiveState: msg.what=EVENT_DISCONNECT");
                    DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj, false);
                    return true;
                }
                case 262150: {
                    DataConnection.this.log("DcInactiveState: msg.what=EVENT_DISCONNECT_ALL");
                    DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj, false);
                    return true;
                }
            }
            DataConnection.this.log("DcInactiveState not handled msg.what=" + DataConnection.this.getWhatToString(msg.what));
            return false;
        }
    }

    private class DcDefaultState
    extends State {
        private DcDefaultState() {
        }

        @Override
        public void enter() {
            DataConnection.this.log("DcDefaultState: enter");
            DataConnection.this.mPhone.getServiceStateTracker().registerForDataRegStateOrRatChanged(DataConnection.this.mTransportType, DataConnection.this.getHandler(), 262155, null);
            DataConnection.this.mPhone.getServiceStateTracker().registerForDataRoamingOn(DataConnection.this.getHandler(), 262156, null);
            DataConnection.this.mPhone.getServiceStateTracker().registerForDataRoamingOff(DataConnection.this.getHandler(), 262157, null, true);
            DataConnection.this.mDcController.addDc(DataConnection.this);
        }

        @Override
        public void exit() {
            DataConnection.this.log("DcDefaultState: exit");
            DataConnection.this.mPhone.getServiceStateTracker().unregisterForDataRegStateOrRatChanged(DataConnection.this.mTransportType, DataConnection.this.getHandler());
            DataConnection.this.mPhone.getServiceStateTracker().unregisterForDataRoamingOn(DataConnection.this.getHandler());
            DataConnection.this.mPhone.getServiceStateTracker().unregisterForDataRoamingOff(DataConnection.this.getHandler());
            DataConnection.this.mDcController.removeDc(DataConnection.this);
            if (DataConnection.this.mAc != null) {
                DataConnection.this.mAc.disconnected();
                DataConnection.this.mAc = null;
            }
            DataConnection.this.mApnContexts.clear();
            DataConnection.this.mReconnectIntent = null;
            DataConnection.this.mDct = null;
            DataConnection.this.mApnSetting = null;
            DataConnection.this.mPhone = null;
            DataConnection.this.mDataServiceManager = null;
            DataConnection.this.mLinkProperties = null;
            DataConnection.this.mLastFailCause = 0;
            DataConnection.this.mUserData = null;
            DataConnection.this.mDcController = null;
            DataConnection.this.mDcTesterFailBringUpAll = null;
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal = true;
            DataConnection.this.log("DcDefault msg=" + DataConnection.this.getWhatToString(msg.what) + " RefCount=" + DataConnection.this.mApnContexts.size());
            switch (msg.what) {
                case 262168: {
                    DataConnection.this.log("DcDefaultState: msg.what=REQ_RESET");
                    DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    break;
                }
                case 262144: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_CONNECT, fail not expected");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    DataConnection.this.notifyConnectCompleted(cp, 65536, false);
                    break;
                }
                case 262148: 
                case 262150: 
                case 262169: {
                    DataConnection.this.log("DcDefaultState deferring msg.what=" + DataConnection.this.getWhatToString(msg.what) + " RefCount=" + DataConnection.this.mApnContexts.size());
                    DataConnection.this.deferMessage(msg);
                    break;
                }
                case 262152: {
                    DataConnection.this.log("DcDefaultState EVENT_TEAR_DOWN_NOW");
                    DataConnection.this.mDataServiceManager.deactivateDataCall(DataConnection.this.mCid, 1, null);
                    break;
                }
                case 262153: {
                    String s = "DcDefaultState ignore EVENT_LOST_CONNECTION tag=" + msg.arg1 + ":mTag=" + DataConnection.this.mTag;
                    DataConnection.this.logAndAddLogRec(s);
                    break;
                }
                case 262155: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Pair drsRatPair = (Pair)ar.result;
                    DataConnection.this.mDataRegState = (Integer)drsRatPair.first;
                    if (DataConnection.this.mRilRat != (Integer)drsRatPair.second) {
                        DataConnection.this.updateTcpBufferSizes((Integer)drsRatPair.second);
                    }
                    DataConnection.this.mRilRat = (Integer)drsRatPair.second;
                    DataConnection.this.log("DcDefaultState: EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED drs=" + DataConnection.this.mDataRegState + " mRilRat=" + DataConnection.this.mRilRat);
                    DataConnection.this.updateNetworkInfo();
                    DataConnection.this.updateNetworkInfoSuspendState();
                    if (DataConnection.this.mNetworkAgent == null) break;
                    DataConnection.this.mNetworkAgent.sendNetworkCapabilities(DataConnection.this.getNetworkCapabilities(), DataConnection.this);
                    DataConnection.this.mNetworkAgent.sendNetworkInfo(DataConnection.this.mNetworkInfo, DataConnection.this);
                    DataConnection.this.mNetworkAgent.sendLinkProperties(DataConnection.this.mLinkProperties, DataConnection.this);
                    break;
                }
                case 262156: 
                case 262157: 
                case 262161: {
                    DataConnection.this.updateNetworkInfo();
                    if (DataConnection.this.mNetworkAgent == null) break;
                    DataConnection.this.mNetworkAgent.sendNetworkCapabilities(DataConnection.this.getNetworkCapabilities(), DataConnection.this);
                    DataConnection.this.mNetworkAgent.sendNetworkInfo(DataConnection.this.mNetworkInfo, DataConnection.this);
                    break;
                }
                case 262165: 
                case 262166: {
                    if (DataConnection.this.mNetworkAgent == null) break;
                    DataConnection.this.mNetworkAgent.onSocketKeepaliveEvent(msg.arg1, -20);
                    break;
                }
                default: {
                    DataConnection.this.log("DcDefaultState: shouldn't happen but ignore msg.what=" + DataConnection.this.getWhatToString(msg.what));
                }
            }
            return retVal;
        }
    }

    public static enum SetupResult {
        SUCCESS,
        ERROR_RADIO_NOT_AVAILABLE,
        ERROR_INVALID_ARG,
        ERROR_STALE,
        ERROR_DATA_SERVICE_SPECIFIC_ERROR;

        public int mFailCause = DataFailCause.getFailCause(0);

        public String toString() {
            return this.name() + "  SetupResult.mFailCause=" + this.mFailCause;
        }
    }

    public static class UpdateLinkPropertyResult {
        public SetupResult setupResult = SetupResult.SUCCESS;
        public LinkProperties oldLp;
        public LinkProperties newLp;

        public UpdateLinkPropertyResult(LinkProperties curLp) {
            this.oldLp = curLp;
            this.newLp = curLp;
        }
    }

    public static class DisconnectParams {
        int mTag;
        public ApnContext mApnContext;
        String mReason;
        final int mReleaseType;
        Message mOnCompletedMsg;

        DisconnectParams(ApnContext apnContext, String reason, int releaseType, Message onCompletedMsg) {
            this.mApnContext = apnContext;
            this.mReason = reason;
            this.mReleaseType = releaseType;
            this.mOnCompletedMsg = onCompletedMsg;
        }

        public String toString() {
            return "{mTag=" + this.mTag + " mApnContext=" + this.mApnContext + " mReason=" + this.mReason + " mReleaseType=" + DcTracker.releaseTypeToString(this.mReleaseType) + " mOnCompletedMsg=" + DataConnection.msgToString(this.mOnCompletedMsg) + "}";
        }
    }

    public static class ConnectionParams {
        int mTag;
        ApnContext mApnContext;
        int mProfileId;
        int mRilRat;
        Message mOnCompletedMsg;
        final int mConnectionGeneration;
        final int mRequestType;
        final int mSubId;

        ConnectionParams(ApnContext apnContext, int profileId, int rilRadioTechnology, Message onCompletedMsg, int connectionGeneration, int requestType, int subId) {
            this.mApnContext = apnContext;
            this.mProfileId = profileId;
            this.mRilRat = rilRadioTechnology;
            this.mOnCompletedMsg = onCompletedMsg;
            this.mConnectionGeneration = connectionGeneration;
            this.mRequestType = requestType;
            this.mSubId = subId;
        }

        public String toString() {
            return "{mTag=" + this.mTag + " mApnContext=" + this.mApnContext + " mProfileId=" + this.mProfileId + " mRat=" + this.mRilRat + " mOnCompletedMsg=" + DataConnection.msgToString(this.mOnCompletedMsg) + " mRequestType=" + DcTracker.requestTypeToString(this.mRequestType) + " mSubId=" + this.mSubId + "}";
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HandoverState {
    }
}

