/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.telephony.data.ApnSetting;
import android.text.TextUtils;
import android.util.ArrayMap;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.SubscriptionController;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DataEnabledOverride {
    private final Set<OverrideRule> mRules = new HashSet<OverrideRule>();
    private static final OverrideRule OVERRIDE_RULE_ALLOW_DATA_DURING_VOICE_CALL = new OverrideRule(255, 3);
    private static final OverrideRule OVERRIDE_RULE_ALWAYS_ALLOW_MMS = new OverrideRule(2, 0);

    public DataEnabledOverride(String rules) {
        this.updateRules(rules);
    }

    @VisibleForTesting
    public void updateRules(String newRules) {
        String[] rulesString;
        this.mRules.clear();
        for (String rule : rulesString = newRules.trim().split("\\s*,\\s*")) {
            if (TextUtils.isEmpty(rule)) continue;
            this.mRules.add(new OverrideRule(rule));
        }
    }

    public void setAlwaysAllowMms(boolean allow) {
        if (allow) {
            this.mRules.add(OVERRIDE_RULE_ALWAYS_ALLOW_MMS);
        } else {
            this.mRules.remove(OVERRIDE_RULE_ALWAYS_ALLOW_MMS);
        }
    }

    public void setDataAllowedInVoiceCall(boolean allow) {
        if (allow) {
            this.mRules.add(OVERRIDE_RULE_ALLOW_DATA_DURING_VOICE_CALL);
        } else {
            this.mRules.remove(OVERRIDE_RULE_ALLOW_DATA_DURING_VOICE_CALL);
        }
    }

    public boolean isDataAllowedInVoiceCall() {
        return this.mRules.contains(OVERRIDE_RULE_ALLOW_DATA_DURING_VOICE_CALL);
    }

    private boolean canSatisfyAnyRule(int apnType, int providedConditions) {
        for (OverrideRule rule : this.mRules) {
            if (!rule.isSatisfiedByConditions(apnType, providedConditions)) continue;
            return true;
        }
        return false;
    }

    private int getCurrentConditions(Phone phone) {
        int conditions = 0;
        if (phone != null) {
            if (phone.getState() != PhoneConstants.State.IDLE) {
                conditions |= 2;
            }
            if (phone.getSubId() != SubscriptionController.getInstance().getDefaultDataSubId()) {
                conditions |= 1;
            }
        }
        return conditions;
    }

    public boolean shouldOverrideDataEnabledSettings(Phone phone, int apnType) {
        return this.canSatisfyAnyRule(apnType, this.getCurrentConditions(phone));
    }

    public String getRules() {
        ArrayList<String> ruleStrings = new ArrayList<String>();
        for (OverrideRule rule : this.mRules) {
            ruleStrings.add(rule.toString());
        }
        return TextUtils.join((CharSequence)",", ruleStrings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataEnabledOverride that = (DataEnabledOverride)o;
        return this.mRules.equals(that.mRules);
    }

    public int hashCode() {
        return Objects.hash(this.mRules);
    }

    public String toString() {
        return "DataEnabledOverride: [rules=\"" + this.getRules() + "\"]";
    }

    static class OverrideConditions {
        static final int CONDITION_UNCONDITIONALLY = 0;
        static final int CONDITION_NON_DEFAULT = 1;
        static final int CONDITION_IN_VOICE_CALL = 2;
        static final String CONDITION_UNCONDITIONALLY_STRING = "unconditionally";
        static final String CONDITION_NON_DEFAULT_STRING = "nonDefault";
        static final String CONDITION_VOICE_CALL_STRING = "inVoiceCall";
        private static final Map<Integer, String> OVERRIDE_CONDITION_INT_MAP = new ArrayMap<Integer, String>();
        private static final Map<String, Integer> OVERRIDE_CONDITION_STRING_MAP = new ArrayMap<String, Integer>();
        private final int mConditions;

        OverrideConditions(String conditions) {
            this.mConditions = OverrideConditions.getBitmaskFromString(conditions);
        }

        OverrideConditions(int conditions) {
            this.mConditions = conditions;
        }

        private static String getStringFromBitmask(int conditions) {
            if (conditions == 0) {
                return CONDITION_UNCONDITIONALLY_STRING;
            }
            ArrayList<String> conditionsStrings = new ArrayList<String>();
            for (Integer condition : OVERRIDE_CONDITION_INT_MAP.keySet()) {
                if ((conditions & condition) != condition) continue;
                conditionsStrings.add(OVERRIDE_CONDITION_INT_MAP.get(condition));
            }
            return TextUtils.join((CharSequence)"&", conditionsStrings);
        }

        private static int getBitmaskFromString(String str) {
            if (TextUtils.isEmpty(str)) {
                throw new IllegalArgumentException("Empty rule string");
            }
            String[] conditionStrings = str.trim().split("\\s*&\\s*");
            int bitmask = 0;
            for (String conditionStr : conditionStrings) {
                if (TextUtils.isEmpty(conditionStr)) continue;
                if (!OVERRIDE_CONDITION_STRING_MAP.containsKey(conditionStr)) {
                    throw new IllegalArgumentException("Invalid conditions: " + str);
                }
                bitmask |= OVERRIDE_CONDITION_STRING_MAP.get(conditionStr).intValue();
            }
            return bitmask;
        }

        boolean allMet(int providedConditions) {
            return (providedConditions & this.mConditions) == this.mConditions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OverrideConditions that = (OverrideConditions)o;
            return this.mConditions == that.mConditions;
        }

        public int hashCode() {
            return Objects.hash(this.mConditions);
        }

        public String toString() {
            return OverrideConditions.getStringFromBitmask(this.mConditions);
        }

        static {
            OVERRIDE_CONDITION_INT_MAP.put(1, CONDITION_NON_DEFAULT_STRING);
            OVERRIDE_CONDITION_INT_MAP.put(2, CONDITION_VOICE_CALL_STRING);
            OVERRIDE_CONDITION_STRING_MAP.put(CONDITION_UNCONDITIONALLY_STRING, 0);
            OVERRIDE_CONDITION_STRING_MAP.put(CONDITION_NON_DEFAULT_STRING, 1);
            OVERRIDE_CONDITION_STRING_MAP.put(CONDITION_VOICE_CALL_STRING, 2);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Condition {
        }
    }

    private static class OverrideRule {
        private final int mApnType;
        private final OverrideConditions mRequiredConditions;

        OverrideRule(String rule) {
            String[] tokens = rule.trim().split("\\s*=\\s*");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Invalid data enabled override rule format: " + rule);
            }
            if (TextUtils.isEmpty(tokens[0])) {
                throw new IllegalArgumentException("APN type can't be empty");
            }
            this.mApnType = ApnSetting.getApnTypesBitmaskFromString(tokens[0]);
            if (this.mApnType == 0) {
                throw new IllegalArgumentException("Invalid APN type. Rule=" + rule);
            }
            this.mRequiredConditions = new OverrideConditions(tokens[1]);
        }

        private OverrideRule(int apnType, int requiredConditions) {
            this.mApnType = apnType;
            this.mRequiredConditions = new OverrideConditions(requiredConditions);
        }

        boolean isSatisfiedByConditions(int apnType, int providedConditions) {
            return (this.mApnType == apnType || this.mApnType == 255) && this.mRequiredConditions.allMet(providedConditions);
        }

        public String toString() {
            return ApnSetting.getApnTypeString(this.mApnType) + "=" + this.mRequiredConditions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OverrideRule that = (OverrideRule)o;
            return this.mApnType == that.mApnType && Objects.equals(this.mRequiredConditions, that.mRequiredConditions);
        }

        public int hashCode() {
            return Objects.hash(this.mApnType, this.mRequiredConditions);
        }
    }
}

