/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Handler;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneStateListener;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.LocalLog;
import android.util.Pair;
import com.android.internal.telephony.GlobalSettingsHelper;
import com.android.internal.telephony.MultiSimSettingController;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.dataconnection.DataEnabledOverride;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class DataEnabledSettings {
    private static final String LOG_TAG = "DataEnabledSettings";
    public static final int REASON_REGISTERED = 0;
    public static final int REASON_INTERNAL_DATA_ENABLED = 1;
    public static final int REASON_USER_DATA_ENABLED = 2;
    public static final int REASON_POLICY_DATA_ENABLED = 3;
    public static final int REASON_DATA_ENABLED_BY_CARRIER = 4;
    public static final int REASON_PROVISIONED_CHANGED = 5;
    public static final int REASON_PROVISIONING_DATA_ENABLED_CHANGED = 6;
    public static final int REASON_OVERRIDE_RULE_CHANGED = 7;
    public static final int REASON_OVERRIDE_CONDITION_CHANGED = 8;
    private boolean mInternalDataEnabled = true;
    private boolean mPolicyDataEnabled = true;
    private boolean mCarrierDataEnabled = true;
    private boolean mIsDataEnabled = false;
    private final Phone mPhone;
    private int mSubId = -1;
    private ContentResolver mResolver = null;
    private final RegistrantList mOverallDataEnabledChangedRegistrants = new RegistrantList();
    private final RegistrantList mOverallDataEnabledOverrideChangedRegistrants = new RegistrantList();
    private final LocalLog mSettingChangeLocalLog = new LocalLog(50);
    private DataEnabledOverride mDataEnabledOverride;
    private TelephonyManager mTelephonyManager;
    private final SubscriptionManager.OnSubscriptionsChangedListener mOnSubscriptionsChangeListener = new SubscriptionManager.OnSubscriptionsChangedListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscriptionsChanged() {
            1 var1_1 = this;
            synchronized (var1_1) {
                if (DataEnabledSettings.this.mSubId != DataEnabledSettings.this.mPhone.getSubId()) {
                    DataEnabledSettings.this.log("onSubscriptionsChanged subId: " + DataEnabledSettings.this.mSubId + " to: " + DataEnabledSettings.this.mPhone.getSubId());
                    DataEnabledSettings.this.mSubId = DataEnabledSettings.this.mPhone.getSubId();
                    DataEnabledSettings.this.mDataEnabledOverride = DataEnabledSettings.this.getDataEnabledOverride();
                    DataEnabledSettings.this.updatePhoneStateListener();
                    DataEnabledSettings.this.updateDataEnabledAndNotify(2);
                    DataEnabledSettings.this.mPhone.notifyUserMobileDataStateChanged(DataEnabledSettings.this.isUserDataEnabled());
                }
            }
        }
    };
    private final PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        @Override
        public void onCallStateChanged(int state, String phoneNumber) {
            DataEnabledSettings.this.updateDataEnabledAndNotify(8);
        }
    };

    private void updatePhoneStateListener() {
        this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
        if (SubscriptionManager.isUsableSubscriptionId(this.mSubId)) {
            this.mTelephonyManager = this.mTelephonyManager.createForSubscriptionId(this.mSubId);
        }
        this.mTelephonyManager.listen(this.mPhoneStateListener, 32);
    }

    public String toString() {
        return "[mInternalDataEnabled=" + this.mInternalDataEnabled + ", isUserDataEnabled=" + this.isUserDataEnabled() + ", isProvisioningDataEnabled=" + this.isProvisioningDataEnabled() + ", mPolicyDataEnabled=" + this.mPolicyDataEnabled + ", mCarrierDataEnabled=" + this.mCarrierDataEnabled + ", mIsDataEnabled=" + this.mIsDataEnabled + ", " + this.mDataEnabledOverride + "]";
    }

    public DataEnabledSettings(Phone phone) {
        this.mPhone = phone;
        this.mResolver = this.mPhone.getContext().getContentResolver();
        SubscriptionManager subscriptionManager = (SubscriptionManager)this.mPhone.getContext().getSystemService("telephony_subscription_service");
        subscriptionManager.addOnSubscriptionsChangedListener(this.mOnSubscriptionsChangeListener);
        this.mTelephonyManager = (TelephonyManager)this.mPhone.getContext().getSystemService("phone");
        this.mDataEnabledOverride = this.getDataEnabledOverride();
        this.updateDataEnabled();
    }

    private DataEnabledOverride getDataEnabledOverride() {
        return new DataEnabledOverride(SubscriptionController.getInstance().getDataEnabledOverrideRules(this.mPhone.getSubId()));
    }

    public synchronized void setInternalDataEnabled(boolean enabled) {
        this.localLog("InternalDataEnabled", enabled);
        if (this.mInternalDataEnabled != enabled) {
            this.mInternalDataEnabled = enabled;
            this.updateDataEnabledAndNotify(1);
        }
    }

    public synchronized boolean isInternalDataEnabled() {
        return this.mInternalDataEnabled;
    }

    public synchronized void setUserDataEnabled(boolean enabled) {
        if (DataEnabledSettings.isStandAloneOpportunistic(this.mPhone.getSubId(), this.mPhone.getContext()) && !enabled) {
            return;
        }
        this.localLog("UserDataEnabled", enabled);
        boolean changed = GlobalSettingsHelper.setInt(this.mPhone.getContext(), "mobile_data", this.mPhone.getSubId(), enabled ? 1 : 0);
        if (changed) {
            this.mPhone.notifyUserMobileDataStateChanged(enabled);
            this.updateDataEnabledAndNotify(2);
            MultiSimSettingController.getInstance().notifyUserDataEnabled(this.mPhone.getSubId(), enabled);
        }
    }

    public synchronized boolean isUserDataEnabled() {
        if (DataEnabledSettings.isStandAloneOpportunistic(this.mPhone.getSubId(), this.mPhone.getContext())) {
            return true;
        }
        boolean defaultVal = "true".equalsIgnoreCase(SystemProperties.get("ro.com.android.mobiledata", "true"));
        return GlobalSettingsHelper.getBoolean(this.mPhone.getContext(), "mobile_data", this.mPhone.getSubId(), defaultVal);
    }

    public synchronized boolean setAlwaysAllowMmsData(boolean alwaysAllow) {
        this.localLog("setAlwaysAllowMmsData", alwaysAllow);
        this.mDataEnabledOverride.setAlwaysAllowMms(alwaysAllow);
        boolean changed = SubscriptionController.getInstance().setDataEnabledOverrideRules(this.mPhone.getSubId(), this.mDataEnabledOverride.getRules());
        if (changed) {
            this.updateDataEnabledAndNotify(7);
            this.notifyDataEnabledOverrideChanged();
        }
        return changed;
    }

    public synchronized boolean setAllowDataDuringVoiceCall(boolean allow) {
        this.localLog("setAllowDataDuringVoiceCall", allow);
        this.mDataEnabledOverride.setDataAllowedInVoiceCall(allow);
        boolean changed = SubscriptionController.getInstance().setDataEnabledOverrideRules(this.mPhone.getSubId(), this.mDataEnabledOverride.getRules());
        if (changed) {
            this.updateDataEnabledAndNotify(7);
            this.notifyDataEnabledOverrideChanged();
        }
        return changed;
    }

    public synchronized boolean isDataAllowedInVoiceCall() {
        return this.mDataEnabledOverride.isDataAllowedInVoiceCall();
    }

    public synchronized void setPolicyDataEnabled(boolean enabled) {
        this.localLog("PolicyDataEnabled", enabled);
        if (this.mPolicyDataEnabled != enabled) {
            this.mPolicyDataEnabled = enabled;
            this.updateDataEnabledAndNotify(3);
        }
    }

    public synchronized boolean isPolicyDataEnabled() {
        return this.mPolicyDataEnabled;
    }

    public synchronized void setCarrierDataEnabled(boolean enabled) {
        this.localLog("CarrierDataEnabled", enabled);
        if (this.mCarrierDataEnabled != enabled) {
            this.mCarrierDataEnabled = enabled;
            this.updateDataEnabledAndNotify(4);
        }
    }

    public synchronized boolean isCarrierDataEnabled() {
        return this.mCarrierDataEnabled;
    }

    public synchronized void updateProvisionedChanged() {
        this.updateDataEnabledAndNotify(5);
    }

    public synchronized void updateProvisioningDataEnabled() {
        this.updateDataEnabledAndNotify(6);
    }

    public synchronized boolean isDataEnabled() {
        return this.mIsDataEnabled;
    }

    private synchronized void updateDataEnabledAndNotify(int reason) {
        boolean prevDataEnabled = this.mIsDataEnabled;
        this.updateDataEnabled();
        if (prevDataEnabled != this.mIsDataEnabled) {
            this.notifyDataEnabledChanged(!prevDataEnabled, reason);
        }
    }

    private synchronized void updateDataEnabled() {
        this.mIsDataEnabled = this.isProvisioning() ? this.isProvisioningDataEnabled() : this.mInternalDataEnabled && (this.isUserDataEnabled() || this.mDataEnabledOverride.shouldOverrideDataEnabledSettings(this.mPhone, 255)) && this.mPolicyDataEnabled && this.mCarrierDataEnabled;
    }

    public boolean isProvisioning() {
        return Settings.Global.getInt(this.mResolver, "device_provisioned", 0) == 0;
    }

    public boolean isProvisioningDataEnabled() {
        String prov_property = SystemProperties.get("ro.com.android.prov_mobiledata", "false");
        boolean retVal = "true".equalsIgnoreCase(prov_property);
        int prov_mobile_data = Settings.Global.getInt(this.mResolver, "device_provisioning_mobile_data", retVal ? 1 : 0);
        retVal = prov_mobile_data != 0;
        this.log("getDataEnabled during provisioning retVal=" + retVal + " - (" + prov_property + ", " + prov_mobile_data + ")");
        return retVal;
    }

    public synchronized void setDataRoamingEnabled(boolean enabled) {
        this.localLog("setDataRoamingEnabled", enabled);
        boolean changed = GlobalSettingsHelper.setBoolean(this.mPhone.getContext(), "data_roaming", this.mPhone.getSubId(), enabled);
        if (changed) {
            MultiSimSettingController.getInstance().notifyRoamingDataEnabled(this.mPhone.getSubId(), enabled);
        }
    }

    public synchronized boolean getDataRoamingEnabled() {
        return GlobalSettingsHelper.getBoolean(this.mPhone.getContext(), "data_roaming", this.mPhone.getSubId(), this.getDefaultDataRoamingEnabled());
    }

    public synchronized boolean getDefaultDataRoamingEnabled() {
        CarrierConfigManager configMgr = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        boolean isDataRoamingEnabled = "true".equalsIgnoreCase(SystemProperties.get("ro.com.android.dataroaming", "false"));
        return isDataRoamingEnabled |= configMgr.getConfigForSubId(this.mPhone.getSubId()).getBoolean("carrier_default_data_roaming_enabled_bool");
    }

    private void notifyDataEnabledChanged(boolean enabled, int reason) {
        this.mOverallDataEnabledChangedRegistrants.notifyResult(new Pair<Boolean, Integer>(enabled, reason));
    }

    public void registerForDataEnabledChanged(Handler h, int what, Object obj) {
        this.mOverallDataEnabledChangedRegistrants.addUnique(h, what, obj);
        this.notifyDataEnabledChanged(this.isDataEnabled(), 0);
    }

    public void unregisterForDataEnabledChanged(Handler h) {
        this.mOverallDataEnabledChangedRegistrants.remove(h);
    }

    private void notifyDataEnabledOverrideChanged() {
        this.mOverallDataEnabledOverrideChangedRegistrants.notifyRegistrants();
    }

    public void registerForDataEnabledOverrideChanged(Handler h, int what) {
        this.mOverallDataEnabledOverrideChangedRegistrants.addUnique(h, what, null);
        this.notifyDataEnabledOverrideChanged();
    }

    public void unregisterForDataEnabledOverrideChanged(Handler h) {
        this.mOverallDataEnabledOverrideChangedRegistrants.remove(h);
    }

    private static boolean isStandAloneOpportunistic(int subId, Context context) {
        SubscriptionInfo info = SubscriptionController.getInstance().getActiveSubscriptionInfo(subId, context.getOpPackageName());
        return info != null && info.isOpportunistic() && info.getGroupUuid() == null;
    }

    public synchronized boolean isDataEnabled(int apnType) {
        if (this.isProvisioning()) {
            return this.isProvisioningDataEnabled();
        }
        boolean userDataEnabled = this.isUserDataEnabled();
        boolean isDataEnabledOverridden = this.mDataEnabledOverride.shouldOverrideDataEnabledSettings(this.mPhone, apnType);
        return this.mInternalDataEnabled && this.mPolicyDataEnabled && this.mCarrierDataEnabled && (userDataEnabled || isDataEnabledOverridden);
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private void localLog(String name, boolean value) {
        this.mSettingChangeLocalLog.log(name + " change to " + value);
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println(" DataEnabledSettings=");
        this.mSettingChangeLocalLog.dump(fd, pw, args);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataEnabledChangedReason {
    }
}

