/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.IPackageManager;
import android.content.pm.ResolveInfo;
import android.net.LinkProperties;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.telephony.AccessNetworkConstants;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.data.DataCallResponse;
import android.telephony.data.DataProfile;
import android.telephony.data.IDataService;
import android.telephony.data.IDataServiceCallback;
import android.text.TextUtils;
import com.android.internal.telephony.Phone;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DataServiceManager
extends Handler {
    private static final boolean DBG = true;
    static final String DATA_CALL_RESPONSE = "data_call_response";
    private static final int EVENT_BIND_DATA_SERVICE = 1;
    private final Phone mPhone;
    private final String mTag;
    private final CarrierConfigManager mCarrierConfigManager;
    private final AppOpsManager mAppOps;
    private final IPackageManager mPackageManager;
    private final int mTransportType;
    private boolean mBound;
    private IDataService mIDataService;
    private DataServiceManagerDeathRecipient mDeathRecipient;
    private final RegistrantList mServiceBindingChangedRegistrants = new RegistrantList();
    private final Map<IBinder, Message> mMessageMap = new ConcurrentHashMap<IBinder, Message>();
    private final RegistrantList mDataCallListChangedRegistrants = new RegistrantList();
    private String mTargetBindingPackageName;
    private CellularDataServiceConnection mServiceConnection;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.telephony.action.CARRIER_CONFIG_CHANGED".equals(action) && DataServiceManager.this.mPhone.getPhoneId() == intent.getIntExtra("android.telephony.extra.SLOT_INDEX", 0)) {
                DataServiceManager.this.log("Carrier config changed. Try to bind data service.");
                DataServiceManager.this.sendEmptyMessage(1);
            }
        }
    };

    private void grantPermissionsToService(String packageName) {
        String[] pkgToGrant = new String[]{packageName};
        try {
            this.mPackageManager.grantDefaultPermissionsToEnabledTelephonyDataServices(pkgToGrant, this.mPhone.getContext().getUserId());
            this.mAppOps.setMode(75, this.mPhone.getContext().getUserId(), pkgToGrant[0], 0);
        }
        catch (RemoteException e) {
            this.loge("Binder to package manager died, permission grant for DataService failed.");
            throw e.rethrowAsRuntimeException();
        }
    }

    private void revokePermissionsFromUnusedDataServices() {
        Set<String> dataServices = this.getAllDataServicePackageNames();
        for (int transportType : this.mPhone.getTransportManager().getAvailableTransports()) {
            dataServices.remove(this.getDataServicePackageName(transportType));
        }
        try {
            String[] dataServicesArray = new String[dataServices.size()];
            dataServices.toArray(dataServicesArray);
            this.mPackageManager.revokeDefaultPermissionsFromDisabledTelephonyDataServices(dataServicesArray, this.mPhone.getContext().getUserId());
            for (String pkg : dataServices) {
                this.mAppOps.setMode(75, this.mPhone.getContext().getUserId(), pkg, 2);
            }
        }
        catch (RemoteException e) {
            this.loge("Binder to package manager died; failed to revoke DataService permissions.");
            throw e.rethrowAsRuntimeException();
        }
    }

    public DataServiceManager(Phone phone, int transportType, String tagSuffix) {
        this.mPhone = phone;
        this.mTag = "DSM" + tagSuffix;
        this.mTransportType = transportType;
        this.mBound = false;
        this.mCarrierConfigManager = (CarrierConfigManager)phone.getContext().getSystemService("carrier_config");
        this.mPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        this.mAppOps = (AppOpsManager)phone.getContext().getSystemService("appops");
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        phone.getContext().registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, intentFilter, null, null);
        this.sendEmptyMessage(1);
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.bindDataService();
                break;
            }
            default: {
                this.loge("Unhandled event " + msg.what);
            }
        }
    }

    private void bindDataService() {
        String packageName = this.getDataServicePackageName();
        if (TextUtils.isEmpty(packageName)) {
            this.loge("Can't find the binding package");
            return;
        }
        if (TextUtils.equals(packageName, this.mTargetBindingPackageName)) {
            this.log("Service " + packageName + " already bound or being bound.");
            return;
        }
        this.revokePermissionsFromUnusedDataServices();
        if (this.mIDataService != null && this.mIDataService.asBinder().isBinderAlive()) {
            try {
                this.mIDataService.removeDataServiceProvider(this.mPhone.getPhoneId());
            }
            catch (RemoteException e) {
                this.loge("Cannot remove data service provider. " + e);
            }
            this.mPhone.getContext().unbindService(this.mServiceConnection);
        }
        this.grantPermissionsToService(packageName);
        try {
            this.mServiceConnection = new CellularDataServiceConnection();
            if (!this.mPhone.getContext().bindService(new Intent("android.telephony.data.DataService").setPackage(packageName), this.mServiceConnection, 1)) {
                this.loge("Cannot bind to the data service.");
                return;
            }
            this.mTargetBindingPackageName = packageName;
        }
        catch (Exception e) {
            this.loge("Cannot bind to the data service. Exception: " + e);
        }
    }

    private Set<String> getAllDataServicePackageNames() {
        List<ResolveInfo> dataPackages = this.mPhone.getContext().getPackageManager().queryIntentServices(new Intent("android.telephony.data.DataService"), 0x100000);
        HashSet<String> packageNames = new HashSet<String>();
        for (ResolveInfo info : dataPackages) {
            if (info.serviceInfo == null) continue;
            packageNames.add(info.serviceInfo.packageName);
        }
        return packageNames;
    }

    private String getDataServicePackageName() {
        return this.getDataServicePackageName(this.mTransportType);
    }

    private String getDataServicePackageName(int transportType) {
        String carrierConfig;
        int resourceId;
        switch (transportType) {
            case 1: {
                resourceId = 17039789;
                carrierConfig = "carrier_data_service_wwan_package_override_string";
                break;
            }
            case 2: {
                resourceId = 17039787;
                carrierConfig = "carrier_data_service_wlan_package_override_string";
                break;
            }
            default: {
                throw new IllegalStateException("Transport type not WWAN or WLAN. type=" + AccessNetworkConstants.transportTypeToString(this.mTransportType));
            }
        }
        String packageName = this.mPhone.getContext().getResources().getString(resourceId);
        PersistableBundle b = this.mCarrierConfigManager.getConfigForSubId(this.mPhone.getSubId());
        if (b != null && !TextUtils.isEmpty(b.getString(carrierConfig))) {
            packageName = b.getString(carrierConfig, packageName);
        }
        return packageName;
    }

    private void sendCompleteMessage(Message msg, int code) {
        if (msg != null) {
            msg.arg1 = code;
            msg.sendToTarget();
        }
    }

    public void setupDataCall(int accessNetworkType, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, Message onCompleteMessage) {
        this.log("setupDataCall");
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = new CellularDataServiceCallback();
        if (onCompleteMessage != null) {
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.setupDataCall(this.mPhone.getPhoneId(), accessNetworkType, dataProfile, isRoaming, allowRoaming, reason, linkProperties, callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke setupDataCall on data service.");
            this.mMessageMap.remove(callback.asBinder());
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    public void deactivateDataCall(int cid, int reason, Message onCompleteMessage) {
        this.log("deactivateDataCall");
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = new CellularDataServiceCallback();
        if (onCompleteMessage != null) {
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.deactivateDataCall(this.mPhone.getPhoneId(), cid, reason, callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke deactivateDataCall on data service.");
            this.mMessageMap.remove(callback.asBinder());
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    public void setInitialAttachApn(DataProfile dataProfile, boolean isRoaming, Message onCompleteMessage) {
        this.log("setInitialAttachApn");
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = new CellularDataServiceCallback();
        if (onCompleteMessage != null) {
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.setInitialAttachApn(this.mPhone.getPhoneId(), dataProfile, isRoaming, callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke setInitialAttachApn on data service.");
            this.mMessageMap.remove(callback.asBinder());
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    public void setDataProfile(List<DataProfile> dps, boolean isRoaming, Message onCompleteMessage) {
        this.log("setDataProfile");
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = new CellularDataServiceCallback();
        if (onCompleteMessage != null) {
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.setDataProfile(this.mPhone.getPhoneId(), dps, isRoaming, callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke setDataProfile on data service.");
            this.mMessageMap.remove(callback.asBinder());
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    public void requestDataCallList(Message onCompleteMessage) {
        this.log("requestDataCallList");
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = new CellularDataServiceCallback();
        if (onCompleteMessage != null) {
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.requestDataCallList(this.mPhone.getPhoneId(), callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke requestDataCallList on data service.");
            if (callback != null) {
                this.mMessageMap.remove(callback.asBinder());
            }
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    public void registerForDataCallListChanged(Handler h, int what) {
        if (h != null) {
            this.mDataCallListChangedRegistrants.addUnique(h, what, null);
        }
    }

    public void unregisterForDataCallListChanged(Handler h) {
        if (h != null) {
            this.mDataCallListChangedRegistrants.remove(h);
        }
    }

    public void registerForServiceBindingChanged(Handler h, int what, Object obj) {
        if (h != null) {
            this.mServiceBindingChangedRegistrants.addUnique(h, what, obj);
        }
    }

    public void unregisterForServiceBindingChanged(Handler h) {
        if (h != null) {
            this.mServiceBindingChangedRegistrants.remove(h);
        }
    }

    public int getTransportType() {
        return this.mTransportType;
    }

    private void log(String s) {
        Rlog.d(this.mTag, s);
    }

    private void loge(String s) {
        Rlog.e(this.mTag, s);
    }

    private final class CellularDataServiceCallback
    extends IDataServiceCallback.Stub {
        private CellularDataServiceCallback() {
        }

        @Override
        public void onSetupDataCallComplete(int resultCode, DataCallResponse response) {
            DataServiceManager.this.log("onSetupDataCallComplete. resultCode = " + resultCode + ", response = " + response);
            Message msg = (Message)DataServiceManager.this.mMessageMap.remove(this.asBinder());
            if (msg != null) {
                msg.getData().putParcelable(DataServiceManager.DATA_CALL_RESPONSE, response);
                DataServiceManager.this.sendCompleteMessage(msg, resultCode);
            } else {
                DataServiceManager.this.loge("Unable to find the message for setup call response.");
            }
        }

        @Override
        public void onDeactivateDataCallComplete(int resultCode) {
            DataServiceManager.this.log("onDeactivateDataCallComplete. resultCode = " + resultCode);
            Message msg = (Message)DataServiceManager.this.mMessageMap.remove(this.asBinder());
            DataServiceManager.this.sendCompleteMessage(msg, resultCode);
        }

        @Override
        public void onSetInitialAttachApnComplete(int resultCode) {
            DataServiceManager.this.log("onSetInitialAttachApnComplete. resultCode = " + resultCode);
            Message msg = (Message)DataServiceManager.this.mMessageMap.remove(this.asBinder());
            DataServiceManager.this.sendCompleteMessage(msg, resultCode);
        }

        @Override
        public void onSetDataProfileComplete(int resultCode) {
            DataServiceManager.this.log("onSetDataProfileComplete. resultCode = " + resultCode);
            Message msg = (Message)DataServiceManager.this.mMessageMap.remove(this.asBinder());
            DataServiceManager.this.sendCompleteMessage(msg, resultCode);
        }

        @Override
        public void onRequestDataCallListComplete(int resultCode, List<DataCallResponse> dataCallList) {
            DataServiceManager.this.log("onRequestDataCallListComplete. resultCode = " + resultCode);
            Message msg = (Message)DataServiceManager.this.mMessageMap.remove(this.asBinder());
            DataServiceManager.this.sendCompleteMessage(msg, resultCode);
        }

        @Override
        public void onDataCallListChanged(List<DataCallResponse> dataCallList) {
            DataServiceManager.this.mDataCallListChangedRegistrants.notifyRegistrants(new AsyncResult(null, dataCallList, null));
        }
    }

    private final class CellularDataServiceConnection
    implements ServiceConnection {
        private CellularDataServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            DataServiceManager.this.log("onServiceConnected");
            DataServiceManager.this.mIDataService = IDataService.Stub.asInterface(service);
            DataServiceManager.this.mDeathRecipient = new DataServiceManagerDeathRecipient();
            DataServiceManager.this.mBound = true;
            try {
                service.linkToDeath(DataServiceManager.this.mDeathRecipient, 0);
                DataServiceManager.this.mIDataService.createDataServiceProvider(DataServiceManager.this.mPhone.getPhoneId());
                DataServiceManager.this.mIDataService.registerForDataCallListChanged(DataServiceManager.this.mPhone.getPhoneId(), new CellularDataServiceCallback());
            }
            catch (RemoteException e) {
                DataServiceManager.this.mDeathRecipient.binderDied();
                DataServiceManager.this.loge("Remote exception. " + e);
                return;
            }
            DataServiceManager.this.mServiceBindingChangedRegistrants.notifyResult(true);
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            DataServiceManager.this.log("onServiceDisconnected");
            DataServiceManager.this.mIDataService.asBinder().unlinkToDeath(DataServiceManager.this.mDeathRecipient, 0);
            DataServiceManager.this.mIDataService = null;
            DataServiceManager.this.mBound = false;
            DataServiceManager.this.mServiceBindingChangedRegistrants.notifyResult(false);
            DataServiceManager.this.mTargetBindingPackageName = null;
        }
    }

    private class DataServiceManagerDeathRecipient
    implements IBinder.DeathRecipient {
        private DataServiceManagerDeathRecipient() {
        }

        @Override
        public void binderDied() {
            DataServiceManager.this.loge("DataService " + DataServiceManager.this.mTargetBindingPackageName + ", transport type " + DataServiceManager.this.mTransportType + " died.");
        }
    }
}

