/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.net.INetworkPolicyListener;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkPolicyManager;
import android.net.NetworkUtils;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.telephony.DataFailCause;
import android.telephony.PhoneStateListener;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.telephony.data.DataCallResponse;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.dataconnection.ApnContext;
import com.android.internal.telephony.dataconnection.DataConnection;
import com.android.internal.telephony.dataconnection.DataServiceManager;
import com.android.internal.telephony.dataconnection.DcTesterDeactivateAll;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DcController
extends StateMachine {
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final Phone mPhone;
    private final DcTracker mDct;
    private final DataServiceManager mDataServiceManager;
    private final DcTesterDeactivateAll mDcTesterDeactivateAll;
    final ArrayList<DataConnection> mDcListAll = new ArrayList();
    private final HashMap<Integer, DataConnection> mDcListActiveByCid = new HashMap();
    private DccDefaultState mDccDefaultState = new DccDefaultState();
    final TelephonyManager mTelephonyManager;
    final NetworkPolicyManager mNetworkPolicyManager;
    private PhoneStateListener mPhoneStateListener;
    private volatile boolean mExecutingCarrierChange;
    private final INetworkPolicyListener mListener = new NetworkPolicyManager.Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscriptionOverride(int subId, int overrideMask, int overrideValue) {
            HashMap dcListActiveByCid;
            if (DcController.this.mPhone == null || DcController.this.mPhone.getSubId() != subId) {
                return;
            }
            ArrayList<DataConnection> arrayList = DcController.this.mDcListAll;
            synchronized (arrayList) {
                dcListActiveByCid = new HashMap(DcController.this.mDcListActiveByCid);
            }
            for (DataConnection dc : dcListActiveByCid.values()) {
                dc.onSubscriptionOverride(overrideMask, overrideValue);
            }
        }
    };

    private DcController(String name, Phone phone, DcTracker dct, DataServiceManager dataServiceManager, Handler handler) {
        super(name, handler);
        this.setLogRecSize(300);
        this.log("E ctor");
        this.mPhone = phone;
        this.mDct = dct;
        this.mDataServiceManager = dataServiceManager;
        this.addState(this.mDccDefaultState);
        this.setInitialState(this.mDccDefaultState);
        this.log("X ctor");
        this.mPhoneStateListener = new PhoneStateListener(handler.getLooper()){

            @Override
            public void onCarrierNetworkChange(boolean active) {
                DcController.this.mExecutingCarrierChange = active;
            }
        };
        this.mTelephonyManager = (TelephonyManager)phone.getContext().getSystemService("phone");
        this.mNetworkPolicyManager = (NetworkPolicyManager)phone.getContext().getSystemService("netpolicy");
        DcTesterDeactivateAll dcTesterDeactivateAll = this.mDcTesterDeactivateAll = Build.IS_DEBUGGABLE ? new DcTesterDeactivateAll(this.mPhone, this, this.getHandler()) : null;
        if (this.mTelephonyManager != null) {
            this.mTelephonyManager.listen(this.mPhoneStateListener, 65536);
        }
    }

    public static DcController makeDcc(Phone phone, DcTracker dct, DataServiceManager dataServiceManager, Handler handler, String tagSuffix) {
        return new DcController("Dcc" + tagSuffix, phone, dct, dataServiceManager, handler);
    }

    void dispose() {
        this.log("dispose: call quiteNow()");
        if (this.mTelephonyManager != null) {
            this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
        }
        this.quitNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDc(DataConnection dc) {
        ArrayList<DataConnection> arrayList = this.mDcListAll;
        synchronized (arrayList) {
            this.mDcListAll.add(dc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDc(DataConnection dc) {
        ArrayList<DataConnection> arrayList = this.mDcListAll;
        synchronized (arrayList) {
            this.mDcListActiveByCid.remove(dc.mCid);
            this.mDcListAll.remove(dc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveDcByCid(DataConnection dc) {
        if (dc.mCid < 0) {
            this.log("addActiveDcByCid dc.mCid < 0 dc=" + dc);
        }
        ArrayList<DataConnection> arrayList = this.mDcListAll;
        synchronized (arrayList) {
            this.mDcListActiveByCid.put(dc.mCid, dc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataConnection getActiveDcByCid(int cid) {
        ArrayList<DataConnection> arrayList = this.mDcListAll;
        synchronized (arrayList) {
            return this.mDcListActiveByCid.get(cid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeActiveDcByCid(DataConnection dc) {
        ArrayList<DataConnection> arrayList = this.mDcListAll;
        synchronized (arrayList) {
            DataConnection removedDc = this.mDcListActiveByCid.remove(dc.mCid);
            if (removedDc == null) {
                this.log("removeActiveDcByCid removedDc=null dc=" + dc);
            }
        }
    }

    boolean isExecutingCarrierChange() {
        return this.mExecutingCarrierChange;
    }

    private void lr(String s) {
        this.logAndAddLogRec(s);
    }

    @Override
    protected void log(String s) {
        Rlog.d(this.getName(), s);
    }

    @Override
    protected void loge(String s) {
        Rlog.e(this.getName(), s);
    }

    @Override
    protected String getWhatToString(int what) {
        String info = null;
        info = DataConnection.cmdToString(what);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ArrayList<DataConnection> arrayList = this.mDcListAll;
        synchronized (arrayList) {
            return "mDcListAll=" + this.mDcListAll + " mDcListActiveByCid=" + this.mDcListActiveByCid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        super.dump(fd, pw, args);
        pw.println(" mPhone=" + this.mPhone);
        ArrayList<DataConnection> arrayList = this.mDcListAll;
        synchronized (arrayList) {
            pw.println(" mDcListAll=" + this.mDcListAll);
            pw.println(" mDcListActiveByCid=" + this.mDcListActiveByCid);
        }
    }

    private class DccDefaultState
    extends State {
        private DccDefaultState() {
        }

        @Override
        public void enter() {
            if (DcController.this.mPhone != null && DcController.this.mDataServiceManager.getTransportType() == 1) {
                ((DcController)DcController.this).mPhone.mCi.registerForRilConnected(DcController.this.getHandler(), 262149, null);
            }
            DcController.this.mDataServiceManager.registerForDataCallListChanged(DcController.this.getHandler(), 262151);
            if (DcController.this.mNetworkPolicyManager != null) {
                DcController.this.mNetworkPolicyManager.registerListener(DcController.this.mListener);
            }
        }

        @Override
        public void exit() {
            if (DcController.this.mPhone != null & DcController.this.mDataServiceManager.getTransportType() == 1) {
                ((DcController)DcController.this).mPhone.mCi.unregisterForRilConnected(DcController.this.getHandler());
            }
            DcController.this.mDataServiceManager.unregisterForDataCallListChanged(DcController.this.getHandler());
            if (DcController.this.mDcTesterDeactivateAll != null) {
                DcController.this.mDcTesterDeactivateAll.dispose();
            }
            if (DcController.this.mNetworkPolicyManager != null) {
                DcController.this.mNetworkPolicyManager.unregisterListener(DcController.this.mListener);
            }
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 262149: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        DcController.this.log("DccDefaultState: msg.what=EVENT_RIL_CONNECTED mRilVersion=" + ar.result);
                        break;
                    }
                    DcController.this.log("DccDefaultState: Unexpected exception on EVENT_RIL_CONNECTED");
                    break;
                }
                case 262151: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        this.onDataStateChanged((ArrayList)ar.result);
                        break;
                    }
                    DcController.this.log("DccDefaultState: EVENT_DATA_STATE_CHANGED: exception; likely radio not available, ignore");
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onDataStateChanged(ArrayList<DataCallResponse> dcsList) {
            HashMap dcListActiveByCid;
            ArrayList<DataConnection> arrayList = DcController.this.mDcListAll;
            synchronized (arrayList) {
                ArrayList<DataConnection> dcListAll = new ArrayList<DataConnection>(DcController.this.mDcListAll);
                dcListActiveByCid = new HashMap(DcController.this.mDcListActiveByCid);
            }
            DcController.this.lr("onDataStateChanged: dcsList=" + dcsList + " dcListActiveByCid=" + dcListActiveByCid);
            HashMap<Integer, DataCallResponse> dataCallResponseListByCid = new HashMap<Integer, DataCallResponse>();
            for (DataCallResponse dataCallResponse : dcsList) {
                dataCallResponseListByCid.put(dataCallResponse.getId(), dataCallResponse);
            }
            ArrayList<DataConnection> dcsToRetry = new ArrayList<DataConnection>();
            for (DataConnection dc : dcListActiveByCid.values()) {
                if (dataCallResponseListByCid.get(dc.mCid) != null) continue;
                DcController.this.log("onDataStateChanged: add to retry dc=" + dc);
                dcsToRetry.add(dc);
            }
            DcController.this.log("onDataStateChanged: dcsToRetry=" + dcsToRetry);
            ArrayList<ApnContext> arrayList2 = new ArrayList<ApnContext>();
            boolean isAnyDataCallDormant = false;
            boolean isAnyDataCallActive = false;
            for (DataCallResponse newState : dcsList) {
                DataConnection dc = (DataConnection)dcListActiveByCid.get(newState.getId());
                if (dc == null) {
                    DcController.this.loge("onDataStateChanged: no associated DC yet, ignore");
                    continue;
                }
                List<ApnContext> apnContexts = dc.getApnContexts();
                if (apnContexts.size() == 0) {
                    DcController.this.loge("onDataStateChanged: no connected apns, ignore");
                } else {
                    DcController.this.log("onDataStateChanged: Found ConnId=" + newState.getId() + " newState=" + newState.toString());
                    if (newState.getLinkStatus() == 0) {
                        if (((DcController)DcController.this).mDct.isCleanupRequired.get()) {
                            arrayList2.addAll(apnContexts);
                            ((DcController)DcController.this).mDct.isCleanupRequired.set(false);
                        } else {
                            int failCause = DataFailCause.getFailCause(newState.getCause());
                            if (DataFailCause.isRadioRestartFailure(DcController.this.mPhone.getContext(), failCause, DcController.this.mPhone.getSubId())) {
                                DcController.this.log("onDataStateChanged: X restart radio, failCause=" + failCause);
                                DcController.this.mDct.sendRestartRadio();
                            } else if (DcController.this.mDct.isPermanentFailure(failCause)) {
                                DcController.this.log("onDataStateChanged: inactive, add to cleanup list. failCause=" + failCause);
                                arrayList2.addAll(apnContexts);
                            } else {
                                DcController.this.log("onDataStateChanged: inactive, add to retry list. failCause=" + failCause);
                                dcsToRetry.add(dc);
                            }
                        }
                    } else {
                        DataConnection.UpdateLinkPropertyResult result = dc.updateLinkProperty(newState);
                        if (result.oldLp.equals(result.newLp)) {
                            DcController.this.log("onDataStateChanged: no change");
                        } else if (result.oldLp.isIdenticalInterfaceName(result.newLp)) {
                            if (!(result.oldLp.isIdenticalDnses(result.newLp) && result.oldLp.isIdenticalRoutes(result.newLp) && result.oldLp.isIdenticalHttpProxy(result.newLp) && result.oldLp.isIdenticalAddresses(result.newLp))) {
                                LinkProperties.CompareResult<LinkAddress> car = result.oldLp.compareAddresses(result.newLp);
                                DcController.this.log("onDataStateChanged: oldLp=" + result.oldLp + " newLp=" + result.newLp + " car=" + car);
                                boolean needToClean = false;
                                block6: for (LinkAddress added : car.added) {
                                    for (LinkAddress removed : car.removed) {
                                        if (!NetworkUtils.addressTypeMatches(removed.getAddress(), added.getAddress())) continue;
                                        needToClean = true;
                                        continue block6;
                                    }
                                }
                                if (needToClean) {
                                    DcController.this.log("onDataStateChanged: addr change, cleanup apns=" + apnContexts + " oldLp=" + result.oldLp + " newLp=" + result.newLp);
                                    arrayList2.addAll(apnContexts);
                                } else {
                                    DcController.this.log("onDataStateChanged: simple change");
                                    for (ApnContext apnContext : apnContexts) {
                                        DcController.this.mPhone.notifyDataConnection(apnContext.getApnType());
                                    }
                                }
                            } else {
                                DcController.this.log("onDataStateChanged: no changes");
                            }
                        } else {
                            arrayList2.addAll(apnContexts);
                            DcController.this.log("onDataStateChanged: interface change, cleanup apns=" + apnContexts);
                        }
                    }
                }
                if (newState.getLinkStatus() == 2) {
                    isAnyDataCallActive = true;
                }
                if (newState.getLinkStatus() != 1) continue;
                isAnyDataCallDormant = true;
            }
            if (isAnyDataCallDormant && !isAnyDataCallActive) {
                DcController.this.log("onDataStateChanged: Data Activity updated to DORMANT. stopNetStatePoll");
                DcController.this.mDct.sendStopNetStatPoll(DctConstants.Activity.DORMANT);
            } else {
                DcController.this.log("onDataStateChanged: Data Activity updated to NONE. isAnyDataCallActive = " + isAnyDataCallActive + " isAnyDataCallDormant = " + isAnyDataCallDormant);
                if (isAnyDataCallActive) {
                    DcController.this.mDct.sendStartNetStatPoll(DctConstants.Activity.NONE);
                }
            }
            DcController.this.lr("onDataStateChanged: dcsToRetry=" + dcsToRetry + " apnsToCleanup=" + arrayList2);
            for (ApnContext apnContext : arrayList2) {
                DcController.this.mDct.cleanUpConnection(apnContext);
            }
            for (DataConnection dc : dcsToRetry) {
                DcController.this.log("onDataStateChanged: send EVENT_LOST_CONNECTION dc.mTag=" + dc.mTag);
                dc.sendMessage(262153, dc.mTag);
            }
        }
    }
}

