/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.net.LinkProperties;
import android.net.NattKeepalivePacketData;
import android.net.NetworkAgent;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.os.Message;
import android.telephony.AccessNetworkConstants;
import android.telephony.Rlog;
import android.util.LocalLog;
import android.util.SparseArray;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.dataconnection.DataConnection;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.dataconnection.KeepaliveStatus;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicInteger;

public class DcNetworkAgent
extends NetworkAgent {
    private String mTag;
    private Phone mPhone;
    private int mTransportType;
    private NetworkCapabilities mNetworkCapabilities;
    public final DcKeepaliveTracker keepaliveTracker = new DcKeepaliveTracker();
    private DataConnection mDataConnection;
    private final LocalLog mNetCapsLocalLog = new LocalLog(50);
    private static AtomicInteger sSerialNumber = new AtomicInteger(0);

    private DcNetworkAgent(DataConnection dc, String tag, Phone phone, NetworkInfo ni, int score, NetworkMisc misc, int factorySerialNumber, int transportType) {
        super(dc.getHandler().getLooper(), phone.getContext(), tag, ni, dc.getNetworkCapabilities(), dc.getLinkProperties(), score, misc, factorySerialNumber);
        this.mTag = tag;
        this.mPhone = phone;
        this.mNetworkCapabilities = dc.getNetworkCapabilities();
        this.mTransportType = transportType;
        this.mDataConnection = dc;
        this.logd(tag + " created for data connection " + dc.getName());
    }

    public static DcNetworkAgent createDcNetworkAgent(DataConnection dc, Phone phone, NetworkInfo ni, int score, NetworkMisc misc, int factorySerialNumber, int transportType) {
        String tag = "DcNetworkAgent-" + sSerialNumber.incrementAndGet();
        return new DcNetworkAgent(dc, tag, phone, ni, score, misc, factorySerialNumber, transportType);
    }

    public synchronized void acquireOwnership(DataConnection dc, int transportType) {
        this.mDataConnection = dc;
        this.mTransportType = transportType;
        this.logd(dc.getName() + " acquired the ownership of this agent.");
    }

    public synchronized void releaseOwnership(DataConnection dc) {
        if (this.mDataConnection == null) {
            this.loge("releaseOwnership called on no-owner DcNetworkAgent!");
            return;
        }
        if (this.mDataConnection != dc) {
            this.log("releaseOwnership: This agent belongs to " + this.mDataConnection.getName() + ", ignored the request from " + dc.getName());
            return;
        }
        this.logd("Data connection " + this.mDataConnection.getName() + " released the ownership.");
        this.mDataConnection = null;
    }

    @Override
    protected synchronized void unwanted() {
        if (this.mDataConnection == null) {
            this.loge("Unwanted found called on no-owner DcNetworkAgent!");
            return;
        }
        this.logd("unwanted called. Now tear down the data connection " + this.mDataConnection.getName());
        this.mDataConnection.tearDownAll("releasedByConnectivityService", 2, null);
    }

    @Override
    protected synchronized void pollLceData() {
        if (this.mDataConnection == null) {
            this.loge("pollLceData called on no-owner DcNetworkAgent!");
            return;
        }
        if (this.mPhone.getLceStatus() == 1 && this.mTransportType == 1) {
            this.mPhone.mCi.pullLceData(this.mDataConnection.obtainMessage(262158));
        }
    }

    @Override
    protected synchronized void networkStatus(int status, String redirectUrl) {
        if (this.mDataConnection == null) {
            this.loge("networkStatus called on no-owner DcNetworkAgent!");
            return;
        }
        this.logd("validation status: " + status + " with redirection URL: " + redirectUrl);
        DcTracker dct = this.mPhone.getDcTracker(this.mTransportType);
        if (dct != null) {
            Message msg = dct.obtainMessage(270380, status, 0, redirectUrl);
            msg.sendToTarget();
        }
    }

    public synchronized void sendNetworkCapabilities(NetworkCapabilities networkCapabilities, DataConnection dc) {
        if (this.mDataConnection == null) {
            this.loge("sendNetworkCapabilities called on no-owner DcNetworkAgent!");
            return;
        }
        if (this.mDataConnection != dc) {
            this.loge("sendNetworkCapabilities: This agent belongs to " + this.mDataConnection.getName() + ", ignored the request from " + dc.getName());
            return;
        }
        if (!networkCapabilities.equals(this.mNetworkCapabilities)) {
            String logStr = "Changed from " + this.mNetworkCapabilities + " to " + networkCapabilities + ", Data RAT=" + this.mPhone.getServiceState().getRilDataRadioTechnology() + ", dc=" + this.mDataConnection.getName();
            this.logd(logStr);
            this.mNetCapsLocalLog.log(logStr);
            this.mNetworkCapabilities = networkCapabilities;
        }
        this.sendNetworkCapabilities(networkCapabilities);
    }

    public synchronized void sendLinkProperties(LinkProperties linkProperties, DataConnection dc) {
        if (this.mDataConnection == null) {
            this.loge("sendLinkProperties called on no-owner DcNetworkAgent!");
            return;
        }
        if (this.mDataConnection != dc) {
            this.loge("sendLinkProperties: This agent belongs to " + this.mDataConnection.getName() + ", ignored the request from " + dc.getName());
            return;
        }
        this.sendLinkProperties(linkProperties);
    }

    public synchronized void sendNetworkScore(int score, DataConnection dc) {
        if (this.mDataConnection == null) {
            this.loge("sendNetworkScore called on no-owner DcNetworkAgent!");
            return;
        }
        if (this.mDataConnection != dc) {
            this.loge("sendNetworkScore: This agent belongs to " + this.mDataConnection.getName() + ", ignored the request from " + dc.getName());
            return;
        }
        this.sendNetworkScore(score);
    }

    public synchronized void sendNetworkInfo(NetworkInfo networkInfo, DataConnection dc) {
        if (this.mDataConnection == null) {
            this.loge("sendNetworkInfo called on no-owner DcNetworkAgent!");
            return;
        }
        if (this.mDataConnection != dc) {
            this.loge("sendNetworkInfo: This agent belongs to " + this.mDataConnection.getName() + ", ignored the request from " + dc.getName());
            return;
        }
        this.sendNetworkInfo(networkInfo);
    }

    @Override
    protected synchronized void startSocketKeepalive(Message msg) {
        if (this.mDataConnection == null) {
            this.loge("startSocketKeepalive called on no-owner DcNetworkAgent!");
            return;
        }
        if (msg.obj instanceof NattKeepalivePacketData) {
            this.mDataConnection.obtainMessage(262165, msg.arg1, msg.arg2, msg.obj).sendToTarget();
        } else {
            this.onSocketKeepaliveEvent(msg.arg1, -30);
        }
    }

    @Override
    protected synchronized void stopSocketKeepalive(Message msg) {
        if (this.mDataConnection == null) {
            this.loge("stopSocketKeepalive called on no-owner DcNetworkAgent!");
            return;
        }
        this.mDataConnection.obtainMessage(262166, msg.arg1, msg.arg2, msg.obj).sendToTarget();
    }

    @Override
    public String toString() {
        return "DcNetworkAgent: mDataConnection=" + (this.mDataConnection != null ? this.mDataConnection.getName() : null) + " mTransportType=" + AccessNetworkConstants.transportTypeToString(this.mTransportType) + " mNetworkCapabilities=" + this.mNetworkCapabilities;
    }

    public void dump(FileDescriptor fd, PrintWriter printWriter, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printWriter, "  ");
        pw.println(this.toString());
        pw.increaseIndent();
        pw.println("Net caps logs:");
        this.mNetCapsLocalLog.dump(fd, pw, args);
        pw.decreaseIndent();
    }

    private void logd(String s) {
        Rlog.d(this.mTag, s);
    }

    private void loge(String s) {
        Rlog.e(this.mTag, s);
    }

    class DcKeepaliveTracker {
        private final SparseArray<KeepaliveRecord> mKeepalives = new SparseArray();

        DcKeepaliveTracker() {
        }

        int getHandleForSlot(int slotId) {
            for (int i = 0; i < this.mKeepalives.size(); ++i) {
                KeepaliveRecord kr = this.mKeepalives.valueAt(i);
                if (kr.slotId != slotId) continue;
                return this.mKeepalives.keyAt(i);
            }
            return -1;
        }

        int keepaliveStatusErrorToPacketKeepaliveError(int error) {
            switch (error) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return -30;
                }
                case 2: {
                    return -32;
                }
            }
            return -31;
        }

        void handleKeepaliveStarted(int slot, KeepaliveStatus ks) {
            switch (ks.statusCode) {
                case 1: {
                    DcNetworkAgent.this.onSocketKeepaliveEvent(slot, this.keepaliveStatusErrorToPacketKeepaliveError(ks.errorCode));
                    break;
                }
                case 0: {
                    DcNetworkAgent.this.onSocketKeepaliveEvent(slot, 0);
                }
                case 2: {
                    DcNetworkAgent.this.logd("Adding keepalive handle=" + ks.sessionHandle + " slot = " + slot);
                    this.mKeepalives.put(ks.sessionHandle, new KeepaliveRecord(slot, ks.statusCode));
                    break;
                }
                default: {
                    DcNetworkAgent.this.logd("Invalid KeepaliveStatus Code: " + ks.statusCode);
                }
            }
        }

        void handleKeepaliveStatus(KeepaliveStatus ks) {
            KeepaliveRecord kr = this.mKeepalives.get(ks.sessionHandle);
            if (kr == null) {
                DcNetworkAgent.this.loge("Discarding keepalive event for different data connection:" + ks);
                return;
            }
            block0 : switch (kr.currentStatus) {
                case 1: {
                    DcNetworkAgent.this.logd("Inactive Keepalive received status!");
                    DcNetworkAgent.this.onSocketKeepaliveEvent(kr.slotId, -31);
                    break;
                }
                case 2: {
                    switch (ks.statusCode) {
                        case 1: {
                            DcNetworkAgent.this.onSocketKeepaliveEvent(kr.slotId, this.keepaliveStatusErrorToPacketKeepaliveError(ks.errorCode));
                            kr.currentStatus = 1;
                            this.mKeepalives.remove(ks.sessionHandle);
                            break block0;
                        }
                        case 0: {
                            DcNetworkAgent.this.logd("Pending Keepalive received active status!");
                            kr.currentStatus = 0;
                            DcNetworkAgent.this.onSocketKeepaliveEvent(kr.slotId, 0);
                            break block0;
                        }
                        case 2: {
                            DcNetworkAgent.this.loge("Invalid unsolicied Keepalive Pending Status!");
                            break block0;
                        }
                    }
                    DcNetworkAgent.this.loge("Invalid Keepalive Status received, " + ks.statusCode);
                    break;
                }
                case 0: {
                    switch (ks.statusCode) {
                        case 1: {
                            DcNetworkAgent.this.logd("Keepalive received stopped status!");
                            DcNetworkAgent.this.onSocketKeepaliveEvent(kr.slotId, 0);
                            kr.currentStatus = 1;
                            this.mKeepalives.remove(ks.sessionHandle);
                            break block0;
                        }
                        case 0: 
                        case 2: {
                            DcNetworkAgent.this.loge("Active Keepalive received invalid status!");
                            break block0;
                        }
                    }
                    DcNetworkAgent.this.loge("Invalid Keepalive Status received, " + ks.statusCode);
                    break;
                }
                default: {
                    DcNetworkAgent.this.loge("Invalid Keepalive Status received, " + kr.currentStatus);
                }
            }
        }

        private class KeepaliveRecord {
            public int slotId;
            public int currentStatus;

            KeepaliveRecord(int slotId, int status) {
                this.slotId = slotId;
                this.currentStatus = status;
            }
        }
    }
}

