/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.Context;
import android.net.NetworkConfig;
import android.net.NetworkRequest;
import com.android.internal.telephony.dataconnection.ApnContext;
import java.util.HashMap;

public class DcRequest
implements Comparable<DcRequest> {
    private static final String LOG_TAG = "DcRequest";
    public final NetworkRequest networkRequest;
    public final int priority;
    public final int apnType;
    private static final HashMap<Integer, Integer> sApnPriorityMap = new HashMap();

    public DcRequest(NetworkRequest nr, Context context) {
        this.initApnPriorities(context);
        this.networkRequest = nr;
        this.apnType = ApnContext.getApnTypeFromNetworkRequest(this.networkRequest);
        this.priority = this.priorityForApnType(this.apnType);
    }

    public String toString() {
        return this.networkRequest.toString() + ", priority=" + this.priority + ", apnType=" + this.apnType;
    }

    public int hashCode() {
        return this.networkRequest.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DcRequest) {
            return this.networkRequest.equals(((DcRequest)o).networkRequest);
        }
        return false;
    }

    @Override
    public int compareTo(DcRequest o) {
        return o.priority - this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initApnPriorities(Context context) {
        HashMap<Integer, Integer> hashMap = sApnPriorityMap;
        synchronized (hashMap) {
            if (sApnPriorityMap.isEmpty()) {
                String[] networkConfigStrings;
                for (String networkConfigString : networkConfigStrings = context.getResources().getStringArray(17236090)) {
                    NetworkConfig networkConfig = new NetworkConfig(networkConfigString);
                    int apnType = ApnContext.getApnTypeFromNetworkType(networkConfig.type);
                    sApnPriorityMap.put(apnType, networkConfig.priority);
                }
            }
        }
    }

    private int priorityForApnType(int apnType) {
        Integer priority = sApnPriorityMap.get(apnType);
        return priority != null ? priority : 0;
    }
}

