/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkConfig;
import android.net.NetworkRequest;
import android.net.ProxyInfo;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RegistrantList;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.CarrierConfigManager;
import android.telephony.CellLocation;
import android.telephony.DataFailCause;
import android.telephony.NetworkRegistrationInfo;
import android.telephony.PcoData;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.data.ApnSetting;
import android.telephony.data.DataProfile;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.LocalLog;
import android.util.Pair;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneSwitcher;
import com.android.internal.telephony.SettingsObserver;
import com.android.internal.telephony.dataconnection.ApnContext;
import com.android.internal.telephony.dataconnection.ApnSettingUtils;
import com.android.internal.telephony.dataconnection.DataConnection;
import com.android.internal.telephony.dataconnection.DataConnectionReasons;
import com.android.internal.telephony.dataconnection.DataEnabledSettings;
import com.android.internal.telephony.dataconnection.DataServiceManager;
import com.android.internal.telephony.dataconnection.DcController;
import com.android.internal.telephony.dataconnection.DcTesterFailBringUpAll;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.AsyncChannel;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DcTracker
extends Handler {
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final boolean VDBG_STALL = false;
    private static final boolean RADIO_TESTS = false;
    private static final int NETWORK_TYPE_DEFAULT = 0;
    private static final int NETWORK_TYPE_MMS = 2;
    private static final int NETWORK_TYPE_SUPL = 3;
    private static final int NETWORK_TYPE_DUN = 4;
    private static final int NETWORK_TYPE_HIPRI = 5;
    private static final int NETWORK_TYPE_FOTA = 10;
    private static final int NETWORK_TYPE_IMS = 11;
    private static final int NETWORK_TYPE_CBS = 12;
    private static final int NETWORK_TYPE_IA = 14;
    private static final int NETWORK_TYPE_EMERGENCY = 15;
    private static final int NETWORK_TYPE_MCX = 1001;
    public static final int REQUEST_TYPE_NORMAL = 1;
    public static final int REQUEST_TYPE_HANDOVER = 2;
    public static final int RELEASE_TYPE_NORMAL = 1;
    public static final int RELEASE_TYPE_DETACH = 2;
    public static final int RELEASE_TYPE_HANDOVER = 3;
    static final String DATA_COMPLETE_MSG_EXTRA_NETWORK_REQUEST = "extra_network_request";
    static final String DATA_COMPLETE_MSG_EXTRA_TRANSPORT_TYPE = "extra_transport_type";
    static final String DATA_COMPLETE_MSG_EXTRA_REQUEST_TYPE = "extra_request_type";
    static final String DATA_COMPLETE_MSG_EXTRA_SUCCESS = "extra_success";
    private final String mLogTag;
    public AtomicBoolean isCleanupRequired = new AtomicBoolean(false);
    private final TelephonyManager mTelephonyManager;
    private final AlarmManager mAlarmManager;
    private int mRequestedApnType = 17;
    private final DataEnabledSettings mDataEnabledSettings;
    private static final int POLL_NETSTAT_MILLIS = 1000;
    private static final int POLL_NETSTAT_SCREEN_OFF_MILLIS = 600000;
    private static final int NUMBER_SENT_PACKETS_OF_HANG = 10;
    private static final int DATA_STALL_ALARM_NON_AGGRESSIVE_DELAY_IN_MS_DEFAULT = 360000;
    private static final int DATA_STALL_ALARM_AGGRESSIVE_DELAY_IN_MS_DEFAULT = 60000;
    private static final boolean DATA_STALL_SUSPECTED = true;
    private static final boolean DATA_STALL_NOT_SUSPECTED = false;
    private static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.data-reconnect";
    private static final String INTENT_RECONNECT_ALARM_EXTRA_TYPE = "reconnect_alarm_extra_type";
    private static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reconnect_alarm_extra_reason";
    private static final String INTENT_RECONNECT_ALARM_EXTRA_TRANSPORT_TYPE = "reconnect_alarm_extra_transport_type";
    private static final String INTENT_DATA_STALL_ALARM = "com.android.internal.telephony.data-stall";
    private static final String INTENT_DATA_STALL_ALARM_EXTRA_TAG = "data_stall_alarm_extra_tag";
    private static final String INTENT_DATA_STALL_ALARM_EXTRA_TRANSPORT_TYPE = "data_stall_alarm_extra_transport_type";
    private DcTesterFailBringUpAll mDcTesterFailBringUpAll;
    private DcController mDcc;
    private final PriorityQueue<ApnContext> mPrioritySortedApnContexts = new PriorityQueue<ApnContext>(5, new Comparator<ApnContext>(){

        @Override
        public int compare(ApnContext c1, ApnContext c2) {
            return c2.priority - c1.priority;
        }
    });
    private ArrayList<ApnSetting> mAllApnSettings = new ArrayList();
    private ApnSetting mPreferredApn = null;
    private boolean mIsPsRestricted = false;
    private ApnSetting mEmergencyApn = null;
    private boolean mIsDisposed = false;
    private ContentResolver mResolver;
    private boolean mIsProvisioning = false;
    private String mProvisioningUrl = null;
    private boolean mDataServiceBound = false;
    private static final String INTENT_PROVISIONING_APN_ALARM = "com.android.internal.telephony.provisioning_apn_alarm";
    private static final String PROVISIONING_APN_ALARM_TAG_EXTRA = "provisioning.apn.alarm.tag";
    private static final String DEBUG_PROV_APN_ALARM = "persist.debug.prov_apn_alarm";
    private static final int PROVISIONING_APN_ALARM_DELAY_IN_MS_DEFAULT = 900000;
    private PendingIntent mProvisioningApnAlarmIntent = null;
    private int mProvisioningApnAlarmTag = (int)SystemClock.elapsedRealtime();
    private AsyncChannel mReplyAc = new AsyncChannel();
    private final LocalLog mDataRoamingLeakageLog = new LocalLog(50);
    private final LocalLog mApnSettingsInitializationLog = new LocalLog(50);
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                DcTracker.this.log("screen on");
                DcTracker.this.mIsScreenOn = true;
                DcTracker.this.stopNetStatPoll();
                DcTracker.this.startNetStatPoll();
                DcTracker.this.restartDataStallAlarm();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                DcTracker.this.log("screen off");
                DcTracker.this.mIsScreenOn = false;
                DcTracker.this.stopNetStatPoll();
                DcTracker.this.startNetStatPoll();
                DcTracker.this.restartDataStallAlarm();
            } else if (action.startsWith(DcTracker.INTENT_RECONNECT_ALARM)) {
                DcTracker.this.onActionIntentReconnectAlarm(intent);
            } else if (action.equals(DcTracker.INTENT_DATA_STALL_ALARM)) {
                DcTracker.this.onActionIntentDataStallAlarm(intent);
            } else if (action.equals(DcTracker.INTENT_PROVISIONING_APN_ALARM)) {
                DcTracker.this.log("Provisioning apn alarm");
                DcTracker.this.onActionIntentProvisioningApnAlarm(intent);
            } else if (action.equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                DcTracker.this.log("received carrier config change");
                if (DcTracker.this.mIccRecords.get() != null && ((IccRecords)DcTracker.this.mIccRecords.get()).getRecordsLoaded()) {
                    DcTracker.this.setDefaultDataRoamingEnabled();
                }
            } else {
                DcTracker.this.log("onReceive: Unknown action=" + action);
            }
        }
    };
    private final Runnable mPollNetStat = new Runnable(){

        @Override
        public void run() {
            DcTracker.this.updateDataActivity();
            if (DcTracker.this.mIsScreenOn) {
                DcTracker.this.mNetStatPollPeriod = Settings.Global.getInt(DcTracker.this.mResolver, "pdp_watchdog_poll_interval_ms", 1000);
            } else {
                DcTracker.this.mNetStatPollPeriod = Settings.Global.getInt(DcTracker.this.mResolver, "pdp_watchdog_long_poll_interval_ms", 600000);
            }
            if (DcTracker.this.mNetStatPollEnabled) {
                DcTracker.this.mDataConnectionTracker.postDelayed(this, DcTracker.this.mNetStatPollPeriod);
            }
        }
    };
    private SubscriptionManager mSubscriptionManager;
    private final DctOnSubscriptionsChangedListener mOnSubscriptionsChangedListener = new DctOnSubscriptionsChangedListener();
    private final SettingsObserver mSettingsObserver;
    private RegistrantList mAllDataDisconnectedRegistrants = new RegistrantList();
    private final Phone mPhone;
    private final UiccController mUiccController;
    private final AtomicReference<IccRecords> mIccRecords = new AtomicReference();
    private DctConstants.Activity mActivity = DctConstants.Activity.NONE;
    private DctConstants.State mState = DctConstants.State.IDLE;
    private final Handler mDataConnectionTracker;
    private long mTxPkts;
    private long mRxPkts;
    private int mNetStatPollPeriod;
    private boolean mNetStatPollEnabled = false;
    private TxRxSum mDataStallTxRxSum = new TxRxSum(0L, 0L);
    private int mDataStallAlarmTag = (int)SystemClock.elapsedRealtime();
    private PendingIntent mDataStallAlarmIntent = null;
    private long mSentSinceLastRecv;
    private int mNoRecvPollCount = 0;
    private static int sEnableFailFastRefCounter = 0;
    private volatile boolean mDataStallNoRxEnabled = true;
    private volatile boolean mFailFast = false;
    private boolean mInVoiceCall = false;
    private PendingIntent mReconnectIntent = null;
    private boolean mAutoAttachOnCreationConfig = false;
    private AtomicBoolean mAutoAttachEnabled = new AtomicBoolean(false);
    private boolean mIsScreenOn = true;
    private AtomicInteger mUniqueIdGenerator = new AtomicInteger(0);
    private HashMap<Integer, DataConnection> mDataConnections = new HashMap();
    private HashMap<String, Integer> mApnToDataConnectionId = new HashMap();
    private final ConcurrentHashMap<String, ApnContext> mApnContexts = new ConcurrentHashMap();
    private final SparseArray<ApnContext> mApnContextsByType = new SparseArray();
    private int mDisconnectPendingCount = 0;
    private ArrayList<DataProfile> mLastDataProfileList = new ArrayList();
    private boolean mReregisterOnReconnectFailure = false;
    private static final String PUPPET_MASTER_RADIO_STRESS_TEST = "gsm.defaultpdpcontext.active";
    private static final int POLL_PDP_MILLIS = 5000;
    private static final int PROVISIONING_SPINNER_TIMEOUT_MILLIS = 120000;
    static final Uri PREFERAPN_NO_UPDATE_URI_USING_SUBID = Uri.parse("content://telephony/carriers/preferapn_no_update/subId/");
    static final String APN_ID = "apn_id";
    private boolean mCanSetPreferApn = false;
    private AtomicBoolean mAttached = new AtomicBoolean(false);
    private ApnChangeObserver mApnObserver;
    private final String mProvisionActionName;
    private BroadcastReceiver mProvisionBroadcastReceiver;
    private ProgressDialog mProvisioningSpinner;
    private final DataServiceManager mDataServiceManager;
    private final int mTransportType;
    private DataStallRecoveryHandler mDsRecoveryHandler;
    private final Map<Integer, List<Message>> mRequestNetworkCompletionMsgs = new HashMap<Integer, List<Message>>();
    private static final int RECOVERY_ACTION_GET_DATA_CALL_LIST = 0;
    private static final int RECOVERY_ACTION_CLEANUP = 1;
    private static final int RECOVERY_ACTION_REREGISTER = 2;
    private static final int RECOVERY_ACTION_RADIO_RESTART = 3;

    private void registerSettingsObserver() {
        this.mSettingsObserver.unobserve();
        String simSuffix = "";
        if (TelephonyManager.getDefault().getSimCount() > 1) {
            simSuffix = Integer.toString(this.mPhone.getSubId());
        }
        this.mSettingsObserver.observe(Settings.Global.getUriFor("data_roaming" + simSuffix), 270384);
        this.mSettingsObserver.observe(Settings.Global.getUriFor("device_provisioned"), 270386);
    }

    private void onActionIntentReconnectAlarm(Intent intent) {
        Message msg = this.obtainMessage(270383);
        msg.setData(intent.getExtras());
        this.sendMessage(msg);
    }

    private void onDataReconnect(Bundle bundle) {
        String reason = bundle.getString(INTENT_RECONNECT_ALARM_EXTRA_REASON);
        String apnType = bundle.getString(INTENT_RECONNECT_ALARM_EXTRA_TYPE);
        int phoneSubId = this.mPhone.getSubId();
        int currSubId = bundle.getInt("subscription", -1);
        if (!SubscriptionManager.isValidSubscriptionId(currSubId) || currSubId != phoneSubId) {
            return;
        }
        int transportType = bundle.getInt(INTENT_RECONNECT_ALARM_EXTRA_TRANSPORT_TYPE, 0);
        if (transportType != this.mTransportType) {
            return;
        }
        ApnContext apnContext = this.mApnContexts.get(apnType);
        this.log("onDataReconnect: mState=" + (Object)((Object)this.mState) + " reason=" + reason + " apnType=" + apnType + " apnContext=" + apnContext);
        if (apnContext != null && apnContext.isEnabled()) {
            apnContext.setReason(reason);
            DctConstants.State apnContextState = apnContext.getState();
            this.log("onDataReconnect: apnContext state=" + (Object)((Object)apnContextState));
            if (apnContextState == DctConstants.State.FAILED || apnContextState == DctConstants.State.IDLE) {
                this.log("onDataReconnect: state is FAILED|IDLE, disassociate");
                apnContext.releaseDataConnection("");
            } else {
                this.log("onDataReconnect: keep associated");
            }
            this.sendMessage(this.obtainMessage(270339, apnContext));
            apnContext.setReconnectIntent(null);
        }
    }

    private void onActionIntentDataStallAlarm(Intent intent) {
        int subId = intent.getIntExtra("subscription", -1);
        if (!SubscriptionManager.isValidSubscriptionId(subId) || subId != this.mPhone.getSubId()) {
            return;
        }
        int transportType = intent.getIntExtra(INTENT_DATA_STALL_ALARM_EXTRA_TRANSPORT_TYPE, 0);
        if (transportType != this.mTransportType) {
            return;
        }
        Message msg = this.obtainMessage(270353, intent.getAction());
        msg.arg1 = intent.getIntExtra(INTENT_DATA_STALL_ALARM_EXTRA_TAG, 0);
        this.sendMessage(msg);
    }

    public DcTracker(Phone phone, int transportType) {
        this.mPhone = phone;
        this.log("DCT.constructor");
        this.mTelephonyManager = TelephonyManager.from(phone.getContext()).createForSubscriptionId(phone.getSubId());
        String tagSuffix = "-" + (transportType == 1 ? "C" : "I");
        if (this.mTelephonyManager.getPhoneCount() > 1) {
            tagSuffix = tagSuffix + "-" + this.mPhone.getPhoneId();
        }
        this.mLogTag = "DCT" + tagSuffix;
        this.mTransportType = transportType;
        this.mDataServiceManager = new DataServiceManager(phone, transportType, tagSuffix);
        this.mResolver = this.mPhone.getContext().getContentResolver();
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 270369, null);
        this.mAlarmManager = (AlarmManager)this.mPhone.getContext().getSystemService("alarm");
        this.mDsRecoveryHandler = new DataStallRecoveryHandler();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction(INTENT_DATA_STALL_ALARM);
        filter.addAction(INTENT_PROVISIONING_APN_ALARM);
        filter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        this.mDataEnabledSettings = this.mPhone.getDataEnabledSettings();
        this.mDataEnabledSettings.registerForDataEnabledChanged(this, 270382, null);
        this.mDataEnabledSettings.registerForDataEnabledOverrideChanged(this, 270387);
        this.mPhone.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mPhone);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
        this.mAutoAttachEnabled.set(sp.getBoolean("disabled_on_boot_key", false));
        this.mSubscriptionManager = SubscriptionManager.from(this.mPhone.getContext());
        this.mSubscriptionManager.addOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        HandlerThread dcHandlerThread = new HandlerThread("DcHandlerThread");
        dcHandlerThread.start();
        Handler dcHandler = new Handler(dcHandlerThread.getLooper());
        this.mDcc = DcController.makeDcc(this.mPhone, this, this.mDataServiceManager, dcHandler, tagSuffix);
        this.mDcTesterFailBringUpAll = new DcTesterFailBringUpAll(this.mPhone, dcHandler);
        this.mDataConnectionTracker = this;
        this.registerForAllEvents();
        this.update();
        this.mApnObserver = new ApnChangeObserver();
        phone.getContext().getContentResolver().registerContentObserver(Telephony.Carriers.CONTENT_URI, true, this.mApnObserver);
        this.initApnContexts();
        for (ApnContext apnContext : this.mApnContexts.values()) {
            filter = new IntentFilter();
            filter.addAction("com.android.internal.telephony.data-reconnect." + apnContext.getApnType());
            this.mPhone.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mPhone);
        }
        this.initEmergencyApnSetting();
        this.addEmergencyApnSetting();
        this.mProvisionActionName = "com.android.internal.telephony.PROVISION" + phone.getPhoneId();
        this.mSettingsObserver = new SettingsObserver(this.mPhone.getContext(), this);
        this.registerSettingsObserver();
    }

    @VisibleForTesting
    public DcTracker() {
        this.mLogTag = "DCT";
        this.mTelephonyManager = null;
        this.mAlarmManager = null;
        this.mPhone = null;
        this.mUiccController = null;
        this.mDataConnectionTracker = null;
        this.mProvisionActionName = null;
        this.mSettingsObserver = new SettingsObserver(null, this);
        this.mDataEnabledSettings = null;
        this.mTransportType = 0;
        this.mDataServiceManager = null;
    }

    public void registerServiceStateTrackerEvents() {
        this.mPhone.getServiceStateTracker().registerForDataConnectionAttached(this.mTransportType, this, 270352, null);
        this.mPhone.getServiceStateTracker().registerForDataConnectionDetached(this.mTransportType, this, 270345, null);
        this.mPhone.getServiceStateTracker().registerForDataRoamingOn(this, 270347, null);
        this.mPhone.getServiceStateTracker().registerForDataRoamingOff(this, 270348, null, true);
        this.mPhone.getServiceStateTracker().registerForPsRestrictedEnabled(this, 270358, null);
        this.mPhone.getServiceStateTracker().registerForPsRestrictedDisabled(this, 270359, null);
        this.mPhone.getServiceStateTracker().registerForDataRegStateOrRatChanged(this.mTransportType, this, 270377, null);
    }

    public void unregisterServiceStateTrackerEvents() {
        this.mPhone.getServiceStateTracker().unregisterForDataConnectionAttached(this.mTransportType, this);
        this.mPhone.getServiceStateTracker().unregisterForDataConnectionDetached(this.mTransportType, this);
        this.mPhone.getServiceStateTracker().unregisterForDataRoamingOn(this);
        this.mPhone.getServiceStateTracker().unregisterForDataRoamingOff(this);
        this.mPhone.getServiceStateTracker().unregisterForPsRestrictedEnabled(this);
        this.mPhone.getServiceStateTracker().unregisterForPsRestrictedDisabled(this);
        this.mPhone.getServiceStateTracker().unregisterForDataRegStateOrRatChanged(this.mTransportType, this);
    }

    private void registerForAllEvents() {
        if (this.mTransportType == 1) {
            this.mPhone.mCi.registerForAvailable(this, 270337, null);
            this.mPhone.mCi.registerForOffOrNotAvailable(this, 270342, null);
            this.mPhone.mCi.registerForPcoData(this, 270381, null);
        }
        this.mPhone.getCallTracker().registerForVoiceCallEnded(this, 270344, null);
        this.mPhone.getCallTracker().registerForVoiceCallStarted(this, 270343, null);
        this.registerServiceStateTrackerEvents();
        this.mDataServiceManager.registerForServiceBindingChanged(this, 270385, null);
    }

    public void dispose() {
        this.log("DCT.dispose");
        if (this.mProvisionBroadcastReceiver != null) {
            this.mPhone.getContext().unregisterReceiver(this.mProvisionBroadcastReceiver);
            this.mProvisionBroadcastReceiver = null;
        }
        if (this.mProvisioningSpinner != null) {
            this.mProvisioningSpinner.dismiss();
            this.mProvisioningSpinner = null;
        }
        this.cleanUpAllConnectionsInternal(true, null);
        this.mIsDisposed = true;
        this.mPhone.getContext().unregisterReceiver(this.mIntentReceiver);
        this.mUiccController.unregisterForIccChanged(this);
        this.mSettingsObserver.unobserve();
        this.mSubscriptionManager.removeOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        this.mDcc.dispose();
        this.mDcTesterFailBringUpAll.dispose();
        this.mPhone.getContext().getContentResolver().unregisterContentObserver(this.mApnObserver);
        this.mApnContexts.clear();
        this.mApnContextsByType.clear();
        this.mPrioritySortedApnContexts.clear();
        this.unregisterForAllEvents();
        this.destroyDataConnections();
    }

    private void unregisterForAllEvents() {
        IccRecords r;
        if (this.mTransportType == 1) {
            this.mPhone.mCi.unregisterForAvailable(this);
            this.mPhone.mCi.unregisterForOffOrNotAvailable(this);
            this.mPhone.mCi.unregisterForPcoData(this);
        }
        if ((r = this.mIccRecords.get()) != null) {
            r.unregisterForRecordsLoaded(this);
            this.mIccRecords.set(null);
        }
        this.mPhone.getCallTracker().unregisterForVoiceCallEnded(this);
        this.mPhone.getCallTracker().unregisterForVoiceCallStarted(this);
        this.unregisterServiceStateTrackerEvents();
        this.mDataServiceManager.unregisterForServiceBindingChanged(this);
        this.mDataEnabledSettings.unregisterForDataEnabledChanged(this);
        this.mDataEnabledSettings.unregisterForDataEnabledOverrideChanged(this);
    }

    private void reevaluateDataConnections() {
        for (DataConnection dataConnection : this.mDataConnections.values()) {
            dataConnection.reevaluateRestrictedState();
        }
    }

    public long getSubId() {
        return this.mPhone.getSubId();
    }

    public DctConstants.Activity getActivity() {
        return this.mActivity;
    }

    private void setActivity(DctConstants.Activity activity) {
        this.log("setActivity = " + (Object)((Object)activity));
        this.mActivity = activity;
        this.mPhone.notifyDataActivity();
    }

    public void requestNetwork(NetworkRequest networkRequest, int type, Message onCompleteMsg) {
        int apnType = ApnContext.getApnTypeFromNetworkRequest(networkRequest);
        ApnContext apnContext = this.mApnContextsByType.get(apnType);
        if (apnContext != null) {
            apnContext.requestNetwork(networkRequest, type, onCompleteMsg);
        }
    }

    public void releaseNetwork(NetworkRequest networkRequest, int type) {
        int apnType = ApnContext.getApnTypeFromNetworkRequest(networkRequest);
        ApnContext apnContext = this.mApnContextsByType.get(apnType);
        if (apnContext != null) {
            apnContext.releaseNetwork(networkRequest, type);
        }
    }

    private void setRadio(boolean on) {
        ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
        try {
            phone.setRadio(on);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() {
        if (this.mPhone != null) {
            this.log("finalize");
        }
    }

    private ApnContext addApnContext(String type, NetworkConfig networkConfig) {
        ApnContext apnContext = new ApnContext(this.mPhone, type, this.mLogTag, networkConfig, this);
        this.mApnContexts.put(type, apnContext);
        this.mApnContextsByType.put(ApnSetting.getApnTypesBitmaskFromString(type), apnContext);
        this.mPrioritySortedApnContexts.add(apnContext);
        return apnContext;
    }

    private void initApnContexts() {
        String[] networkConfigStrings;
        this.log("initApnContexts: E");
        block13: for (String networkConfigString : networkConfigStrings = this.mPhone.getContext().getResources().getStringArray(17236090)) {
            ApnContext apnContext;
            NetworkConfig networkConfig = new NetworkConfig(networkConfigString);
            switch (networkConfig.type) {
                case 0: {
                    apnContext = this.addApnContext("default", networkConfig);
                    break;
                }
                case 2: {
                    apnContext = this.addApnContext("mms", networkConfig);
                    break;
                }
                case 3: {
                    apnContext = this.addApnContext("supl", networkConfig);
                    break;
                }
                case 4: {
                    apnContext = this.addApnContext("dun", networkConfig);
                    break;
                }
                case 5: {
                    apnContext = this.addApnContext("hipri", networkConfig);
                    break;
                }
                case 10: {
                    apnContext = this.addApnContext("fota", networkConfig);
                    break;
                }
                case 11: {
                    apnContext = this.addApnContext("ims", networkConfig);
                    break;
                }
                case 12: {
                    apnContext = this.addApnContext("cbs", networkConfig);
                    break;
                }
                case 14: {
                    apnContext = this.addApnContext("ia", networkConfig);
                    break;
                }
                case 15: {
                    apnContext = this.addApnContext("emergency", networkConfig);
                    break;
                }
                case 1001: {
                    apnContext = this.addApnContext("mcx", networkConfig);
                    break;
                }
                default: {
                    this.log("initApnContexts: skipping unknown type=" + networkConfig.type);
                    continue block13;
                }
            }
            this.log("initApnContexts: apnContext=" + apnContext);
        }
    }

    public LinkProperties getLinkProperties(String apnType) {
        DataConnection dataConnection;
        ApnContext apnContext = this.mApnContexts.get(apnType);
        if (apnContext != null && (dataConnection = apnContext.getDataConnection()) != null) {
            this.log("return link properties for " + apnType);
            return dataConnection.getLinkProperties();
        }
        this.log("return new LinkProperties");
        return new LinkProperties();
    }

    public NetworkCapabilities getNetworkCapabilities(String apnType) {
        DataConnection dataConnection;
        ApnContext apnContext = this.mApnContexts.get(apnType);
        if (apnContext != null && (dataConnection = apnContext.getDataConnection()) != null) {
            this.log("get active pdp is not null, return NetworkCapabilities for " + apnType);
            return dataConnection.getNetworkCapabilities();
        }
        this.log("return new NetworkCapabilities");
        return new NetworkCapabilities();
    }

    public String[] getActiveApnTypes() {
        this.log("get all active apn types");
        ArrayList<String> result = new ArrayList<String>();
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (!this.mAttached.get() || !apnContext.isReady()) continue;
            result.add(apnContext.getApnType());
        }
        return result.toArray(new String[0]);
    }

    public String getActiveApnString(String apnType) {
        ApnSetting apnSetting;
        ApnContext apnContext = this.mApnContexts.get(apnType);
        if (apnContext != null && (apnSetting = apnContext.getApnSetting()) != null) {
            return apnSetting.getApnName();
        }
        return null;
    }

    public DctConstants.State getState(String apnType) {
        int apnTypeBitmask = ApnSetting.getApnTypesBitmaskFromString(apnType);
        for (DataConnection dc : this.mDataConnections.values()) {
            ApnSetting apnSetting = dc.getApnSetting();
            if (apnSetting == null || !apnSetting.canHandleType(apnTypeBitmask)) continue;
            if (dc.isActive()) {
                return DctConstants.State.CONNECTED;
            }
            if (dc.isActivating()) {
                return DctConstants.State.CONNECTING;
            }
            if (dc.isInactive()) {
                return DctConstants.State.IDLE;
            }
            if (!dc.isDisconnecting()) continue;
            return DctConstants.State.DISCONNECTING;
        }
        return DctConstants.State.IDLE;
    }

    private boolean isProvisioningApn(String apnType) {
        ApnContext apnContext = this.mApnContexts.get(apnType);
        if (apnContext != null) {
            return apnContext.isProvisioningApn();
        }
        return false;
    }

    public DctConstants.State getOverallState() {
        boolean isConnecting = false;
        boolean isFailed = true;
        boolean isAnyEnabled = false;
        block5: for (ApnContext apnContext : this.mApnContexts.values()) {
            if (!apnContext.isEnabled()) continue;
            isAnyEnabled = true;
            switch (apnContext.getState()) {
                case CONNECTED: 
                case DISCONNECTING: {
                    return DctConstants.State.CONNECTED;
                }
                case CONNECTING: {
                    isConnecting = true;
                    isFailed = false;
                    continue block5;
                }
                case IDLE: 
                case RETRYING: {
                    isFailed = false;
                    continue block5;
                }
            }
            isAnyEnabled = true;
        }
        if (!isAnyEnabled) {
            return DctConstants.State.IDLE;
        }
        if (isConnecting) {
            return DctConstants.State.CONNECTING;
        }
        if (!isFailed) {
            return DctConstants.State.IDLE;
        }
        return DctConstants.State.FAILED;
    }

    private void onDataConnectionDetached() {
        this.log("onDataConnectionDetached: stop polling and notify detached");
        this.stopNetStatPoll();
        this.stopDataStallAlarm();
        this.mPhone.notifyDataConnection();
        this.mAttached.set(false);
    }

    private void onDataConnectionAttached() {
        this.log("onDataConnectionAttached");
        this.mAttached.set(true);
        if (this.getOverallState() == DctConstants.State.CONNECTED) {
            this.log("onDataConnectionAttached: start polling notify attached");
            this.startNetStatPoll();
            this.startDataStallAlarm(false);
            this.mPhone.notifyDataConnection();
        }
        if (this.mAutoAttachOnCreationConfig) {
            this.mAutoAttachEnabled.set(true);
        }
        this.setupDataOnAllConnectableApns("dataAttached", RetryFailures.ALWAYS);
    }

    public boolean isDataAllowed(DataConnectionReasons dataConnectionReasons) {
        return this.isDataAllowed(null, 1, dataConnectionReasons);
    }

    public boolean isDataAllowed(ApnContext apnContext, int requestType, DataConnectionReasons dataConnectionReasons) {
        boolean isDataEnabled;
        DataConnectionReasons reasons = new DataConnectionReasons();
        boolean internalDataEnabled = this.mDataEnabledSettings.isInternalDataEnabled();
        boolean attachedState = this.mAttached.get();
        boolean desiredPowerState = this.mPhone.getServiceStateTracker().getDesiredPowerState();
        boolean radioStateFromCarrier = this.mPhone.getServiceStateTracker().getPowerStateFromCarrier();
        int dataRat = this.getDataRat();
        if (dataRat == 18) {
            desiredPowerState = true;
            radioStateFromCarrier = true;
        }
        boolean recordsLoaded = this.mIccRecords.get() != null && this.mIccRecords.get().getRecordsLoaded();
        boolean defaultDataSelected = SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultDataSubscriptionId());
        boolean isMeteredApnType = apnContext == null || ApnSettingUtils.isMeteredApnType(ApnSetting.getApnTypesBitmaskFromString(apnContext.getApnType()), this.mPhone);
        PhoneConstants.State phoneState = PhoneConstants.State.IDLE;
        if (this.mPhone.getCallTracker() != null) {
            phoneState = this.mPhone.getCallTracker().getState();
        }
        if (apnContext != null && apnContext.getApnType().equals("emergency") && apnContext.isConnectable()) {
            if (dataConnectionReasons != null) {
                dataConnectionReasons.add(DataConnectionReasons.DataAllowedReasonType.EMERGENCY_APN);
            }
            return true;
        }
        if (apnContext != null && !apnContext.isConnectable()) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.APN_NOT_CONNECTABLE);
        }
        if (apnContext != null && (apnContext.getApnType().equals("default") || apnContext.getApnType().equals("ia")) && this.mPhone.getTransportManager().isInLegacyMode() && dataRat == 18) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.ON_IWLAN);
        }
        if (this.isEmergency()) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.IN_ECBM);
        }
        if (!attachedState && !this.shouldAutoAttach() && requestType != 2) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.NOT_ATTACHED);
        }
        if (!recordsLoaded) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.RECORD_NOT_LOADED);
        }
        if (phoneState != PhoneConstants.State.IDLE && !this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.INVALID_PHONE_STATE);
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.CONCURRENT_VOICE_DATA_NOT_ALLOWED);
        }
        if (!internalDataEnabled) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.INTERNAL_DATA_DISABLED);
        }
        if (!defaultDataSelected) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.DEFAULT_DATA_UNSELECTED);
        }
        if (this.mPhone.getServiceState().getDataRoaming() && !this.getDataRoamingEnabled()) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.ROAMING_DISABLED);
        }
        if (this.mIsPsRestricted) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.PS_RESTRICTED);
        }
        if (!desiredPowerState) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.UNDESIRED_POWER_STATE);
        }
        if (!radioStateFromCarrier) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.RADIO_DISABLED_BY_CARRIER);
        }
        boolean bl = isDataEnabled = apnContext == null ? this.mDataEnabledSettings.isDataEnabled() : this.mDataEnabledSettings.isDataEnabled(apnContext.getApnTypeBitmask());
        if (!isDataEnabled) {
            reasons.add(DataConnectionReasons.DataDisallowedReasonType.DATA_DISABLED);
        }
        if (reasons.containsHardDisallowedReasons()) {
            if (dataConnectionReasons != null) {
                dataConnectionReasons.copyFrom(reasons);
            }
            return false;
        }
        if (!reasons.allowed()) {
            if (this.mTransportType == 2 || this.mPhone.getTransportManager().isInLegacyMode() && dataRat == 18) {
                reasons.add(DataConnectionReasons.DataAllowedReasonType.UNMETERED_APN);
            } else if (this.mTransportType == 1 && !isMeteredApnType) {
                reasons.add(DataConnectionReasons.DataAllowedReasonType.UNMETERED_APN);
            }
            if (apnContext != null && apnContext.hasRestrictedRequests(true) && !reasons.allowed()) {
                reasons.add(DataConnectionReasons.DataAllowedReasonType.RESTRICTED_REQUEST);
            }
        } else {
            reasons.add(DataConnectionReasons.DataAllowedReasonType.NORMAL);
        }
        if (dataConnectionReasons != null) {
            dataConnectionReasons.copyFrom(reasons);
        }
        return reasons.allowed();
    }

    private void setupDataOnAllConnectableApns(String reason, RetryFailures retryFailures) {
        StringBuilder sb = new StringBuilder(120);
        for (ApnContext apnContext : this.mPrioritySortedApnContexts) {
            sb.append(apnContext.getApnType());
            sb.append(":[state=");
            sb.append((Object)apnContext.getState());
            sb.append(",enabled=");
            sb.append(apnContext.isEnabled());
            sb.append("] ");
        }
        this.log("setupDataOnAllConnectableApns: " + reason + " " + sb);
        for (ApnContext apnContext : this.mPrioritySortedApnContexts) {
            this.setupDataOnConnectableApn(apnContext, reason, retryFailures);
        }
    }

    private void setupDataOnConnectableApn(ApnContext apnContext, String reason, RetryFailures retryFailures) {
        if (apnContext.getState() == DctConstants.State.FAILED || apnContext.getState() == DctConstants.State.RETRYING) {
            if (retryFailures == RetryFailures.ALWAYS) {
                apnContext.releaseDataConnection(reason);
            } else if (!apnContext.isConcurrentVoiceAndDataAllowed() && this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) {
                apnContext.releaseDataConnection(reason);
            }
        }
        if (apnContext.isConnectable()) {
            this.log("isConnectable() call trySetupData");
            apnContext.setReason(reason);
            this.trySetupData(apnContext, 1);
        }
    }

    boolean isEmergency() {
        boolean result = this.mPhone.isInEcm() || this.mPhone.isInEmergencyCall();
        this.log("isEmergency: result=" + result);
        return result;
    }

    private boolean trySetupData(ApnContext apnContext, int requestType) {
        if (this.mPhone.getSimulatedRadioControl() != null) {
            apnContext.setState(DctConstants.State.CONNECTED);
            this.mPhone.notifyDataConnection(apnContext.getApnType());
            this.log("trySetupData: X We're on the simulator; assuming connected retValue=true");
            return true;
        }
        DataConnectionReasons dataConnectionReasons = new DataConnectionReasons();
        boolean isDataAllowed = this.isDataAllowed(apnContext, requestType, dataConnectionReasons);
        String logStr = "trySetupData for APN type " + apnContext.getApnType() + ", reason: " + apnContext.getReason() + ", requestType=" + DcTracker.requestTypeToString(requestType) + ". " + dataConnectionReasons.toString();
        this.log(logStr);
        apnContext.requestLog(logStr);
        if (isDataAllowed) {
            int radioTech;
            if (apnContext.getState() == DctConstants.State.FAILED) {
                String str = "trySetupData: make a FAILED ApnContext IDLE so its reusable";
                this.log(str);
                apnContext.requestLog(str);
                apnContext.setState(DctConstants.State.IDLE);
            }
            if ((radioTech = this.getDataRat()) == 0) {
                radioTech = this.getVoiceRat();
            }
            this.log("service state=" + this.mPhone.getServiceState());
            apnContext.setConcurrentVoiceAndDataAllowed(this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed());
            if (apnContext.getState() == DctConstants.State.IDLE) {
                ArrayList<ApnSetting> waitingApns = this.buildWaitingApns(apnContext.getApnType(), radioTech);
                if (waitingApns.isEmpty()) {
                    this.notifyNoData(27, apnContext);
                    String str = "trySetupData: X No APN found retValue=false";
                    this.log(str);
                    apnContext.requestLog(str);
                    return false;
                }
                apnContext.setWaitingApns(waitingApns);
                this.log("trySetupData: Create from mAllApnSettings : " + this.apnListToString(this.mAllApnSettings));
            }
            boolean retValue = this.setupData(apnContext, radioTech, requestType);
            this.log("trySetupData: X retValue=" + retValue);
            return retValue;
        }
        StringBuilder str = new StringBuilder();
        str.append("trySetupData failed. apnContext = [type=" + apnContext.getApnType() + ", mState=" + (Object)((Object)apnContext.getState()) + ", apnEnabled=" + apnContext.isEnabled() + ", mDependencyMet=" + apnContext.isDependencyMet() + "] ");
        if (!this.mDataEnabledSettings.isDataEnabled()) {
            str.append("isDataEnabled() = false. " + this.mDataEnabledSettings);
        }
        if (apnContext.getState() == DctConstants.State.RETRYING) {
            apnContext.setState(DctConstants.State.FAILED);
            str.append(" Stop retrying.");
        }
        this.log(str.toString());
        apnContext.requestLog(str.toString());
        return false;
    }

    public void cleanUpAllConnections(String reason) {
        this.log("cleanUpAllConnections");
        Message msg = this.obtainMessage(270365);
        msg.obj = reason;
        this.sendMessage(msg);
    }

    private boolean cleanUpAllConnectionsInternal(boolean detach, String reason) {
        this.log("cleanUpAllConnectionsInternal: detach=" + detach + " reason=" + reason);
        boolean didDisconnect = false;
        boolean disableMeteredOnly = false;
        if (!TextUtils.isEmpty(reason)) {
            disableMeteredOnly = reason.equals("specificDisabled") || reason.equals("roamingOn") || reason.equals("carrierActionDisableMeteredApn");
        }
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (reason.equals("SinglePdnArbitration") && apnContext.getApnType().equals("ims")) continue;
            if (this.shouldCleanUpConnection(apnContext, disableMeteredOnly)) {
                if (!apnContext.isDisconnected()) {
                    didDisconnect = true;
                }
                apnContext.setReason(reason);
                this.cleanUpConnectionInternal(detach, 2, apnContext);
                continue;
            }
            this.log("cleanUpAllConnectionsInternal: APN type " + apnContext.getApnType() + " shouldn't be cleaned up.");
        }
        this.stopNetStatPoll();
        this.stopDataStallAlarm();
        this.mRequestedApnType = 17;
        this.log("cleanUpAllConnectionsInternal: mDisconnectPendingCount = " + this.mDisconnectPendingCount);
        if (detach && this.mDisconnectPendingCount == 0) {
            this.notifyAllDataDisconnected();
        }
        return didDisconnect;
    }

    boolean shouldCleanUpConnection(ApnContext apnContext, boolean disableMeteredOnly) {
        if (apnContext == null) {
            return false;
        }
        if (!disableMeteredOnly) {
            return true;
        }
        ApnSetting apnSetting = apnContext.getApnSetting();
        if (apnSetting == null || !ApnSettingUtils.isMetered(apnSetting, this.mPhone)) {
            return false;
        }
        boolean isRoaming = this.mPhone.getServiceState().getDataRoaming();
        boolean isDataRoamingDisabled = !this.getDataRoamingEnabled();
        boolean isDataDisabled = !this.mDataEnabledSettings.isDataEnabled(apnSetting.getApnTypeBitmask());
        return isDataDisabled || isRoaming && isDataRoamingDisabled;
    }

    void cleanUpConnection(ApnContext apnContext) {
        this.log("cleanUpConnection: apnContext=" + apnContext);
        Message msg = this.obtainMessage(270360);
        msg.arg2 = 0;
        msg.obj = apnContext;
        this.sendMessage(msg);
    }

    private void cleanUpConnectionInternal(boolean detach, int releaseType, ApnContext apnContext) {
        if (apnContext == null) {
            this.log("cleanUpConnectionInternal: apn context is null");
            return;
        }
        DataConnection dataConnection = apnContext.getDataConnection();
        String str = "cleanUpConnectionInternal: detach=" + detach + " reason=" + apnContext.getReason();
        apnContext.requestLog(str);
        if (detach) {
            if (apnContext.isDisconnected()) {
                apnContext.releaseDataConnection("");
            } else if (dataConnection != null) {
                if (apnContext.getState() != DctConstants.State.DISCONNECTING) {
                    boolean disconnectAll = false;
                    if ("dun".equals(apnContext.getApnType()) && ServiceState.isCdma(this.getDataRat())) {
                        this.log("cleanUpConnectionInternal: disconnectAll DUN connection");
                        disconnectAll = true;
                    }
                    int generation = apnContext.getConnectionGeneration();
                    str = "cleanUpConnectionInternal: tearing down" + (disconnectAll ? " all" : "") + " using gen#" + generation;
                    this.log(str + "apnContext=" + apnContext);
                    apnContext.requestLog(str);
                    Pair<ApnContext, Integer> pair = new Pair<ApnContext, Integer>(apnContext, generation);
                    Message msg = this.obtainMessage(270351, pair);
                    if (disconnectAll || releaseType == 3) {
                        dataConnection.tearDownAll(apnContext.getReason(), releaseType, msg);
                    } else {
                        dataConnection.tearDown(apnContext, apnContext.getReason(), msg);
                    }
                    apnContext.setState(DctConstants.State.DISCONNECTING);
                    ++this.mDisconnectPendingCount;
                }
            } else {
                apnContext.setState(DctConstants.State.IDLE);
                apnContext.requestLog("cleanUpConnectionInternal: connected, bug no dc");
                this.mPhone.notifyDataConnection(apnContext.getApnType());
            }
        } else {
            if (dataConnection != null) {
                dataConnection.reset();
            }
            apnContext.setState(DctConstants.State.IDLE);
            this.mPhone.notifyDataConnection(apnContext.getApnType());
            apnContext.setDataConnection(null);
        }
        if (dataConnection != null) {
            this.cancelReconnectAlarm(apnContext);
        }
        str = "cleanUpConnectionInternal: X detach=" + detach + " reason=" + apnContext.getReason();
        this.log(str + " apnContext=" + apnContext + " dc=" + apnContext.getDataConnection());
    }

    @VisibleForTesting
    public ArrayList<ApnSetting> fetchDunApns() {
        if (SystemProperties.getBoolean("net.tethering.noprovisioning", false)) {
            this.log("fetchDunApns: net.tethering.noprovisioning=true ret: empty list");
            return new ArrayList<ApnSetting>(0);
        }
        int bearer = this.getDataRat();
        ArrayList<ApnSetting> dunCandidates = new ArrayList<ApnSetting>();
        ArrayList<ApnSetting> retDunSettings = new ArrayList<ApnSetting>();
        String apnData = Settings.Global.getString(this.mResolver, "tether_dun_apn");
        if (!TextUtils.isEmpty(apnData)) {
            dunCandidates.addAll(ApnSetting.arrayFromString(apnData));
        }
        if (dunCandidates.isEmpty() && !ArrayUtils.isEmpty(this.mAllApnSettings)) {
            for (ApnSetting apn : this.mAllApnSettings) {
                if (!apn.canHandleType(8)) continue;
                dunCandidates.add(apn);
            }
        }
        for (ApnSetting dunSetting : dunCandidates) {
            if (!dunSetting.canSupportNetworkType(ServiceState.rilRadioTechnologyToNetworkType(bearer))) continue;
            retDunSettings.add(dunSetting);
        }
        return retDunSettings;
    }

    private int getPreferredApnSetId() {
        int setId;
        Cursor c = this.mPhone.getContext().getContentResolver().query(Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "preferapnset/subId/" + this.mPhone.getSubId()), new String[]{"apn_set_id"}, null, null, null);
        if (c == null) {
            this.loge("getPreferredApnSetId: cursor is null");
            return 0;
        }
        if (c.getCount() < 1) {
            this.loge("getPreferredApnSetId: no APNs found");
            setId = 0;
        } else {
            c.moveToFirst();
            setId = c.getInt(0);
        }
        if (!c.isClosed()) {
            c.close();
        }
        return setId;
    }

    public boolean hasMatchedTetherApnSetting() {
        ArrayList<ApnSetting> matches = this.fetchDunApns();
        this.log("hasMatchedTetherApnSetting: APNs=" + matches);
        return matches.size() > 0;
    }

    public DataConnection getDataConnectionByContextId(int cid) {
        return this.mDcc.getActiveDcByCid(cid);
    }

    public DataConnection getDataConnectionByApnType(String apnType) {
        ApnContext apnContext = this.mApnContexts.get(apnType);
        if (apnContext != null) {
            return apnContext.getDataConnection();
        }
        return null;
    }

    private void cancelReconnectAlarm(ApnContext apnContext) {
        if (apnContext == null) {
            return;
        }
        PendingIntent intent = apnContext.getReconnectIntent();
        if (intent != null) {
            AlarmManager am = (AlarmManager)this.mPhone.getContext().getSystemService("alarm");
            am.cancel(intent);
            apnContext.setReconnectIntent(null);
        }
    }

    boolean isPermanentFailure(int dcFailCause) {
        return DataFailCause.isPermanentFailure(this.mPhone.getContext(), dcFailCause, this.mPhone.getSubId()) && (!this.mAttached.get() || dcFailCause != -3);
    }

    private DataConnection findFreeDataConnection() {
        for (DataConnection dataConnection : this.mDataConnections.values()) {
            boolean inUse = false;
            for (ApnContext apnContext : this.mApnContexts.values()) {
                if (apnContext.getDataConnection() != dataConnection) continue;
                inUse = true;
                break;
            }
            if (inUse) continue;
            this.log("findFreeDataConnection: found free DataConnection=" + dataConnection);
            return dataConnection;
        }
        this.log("findFreeDataConnection: NO free DataConnection");
        return null;
    }

    private boolean setupData(ApnContext apnContext, int radioTech, int requestType) {
        ApnSetting dataConnectionApnSetting;
        this.log("setupData: apnContext=" + apnContext + ", requestType=" + DcTracker.requestTypeToString(requestType));
        apnContext.requestLog("setupData. requestType=" + DcTracker.requestTypeToString(requestType));
        DataConnection dataConnection = null;
        ApnSetting apnSetting = apnContext.getNextApnSetting();
        if (apnSetting == null) {
            this.log("setupData: return for no apn found!");
            return false;
        }
        int profileId = -1;
        if (apnSetting.isPersistent() && (profileId = apnSetting.getProfileId()) == 0) {
            profileId = this.getApnProfileID(apnContext.getApnType());
        }
        if ((!apnContext.getApnType().equals("dun") || ServiceState.isGsm(this.getDataRat())) && (dataConnection = this.checkForCompatibleConnectedApnContext(apnContext)) != null && (dataConnectionApnSetting = dataConnection.getApnSetting()) != null) {
            apnSetting = dataConnectionApnSetting;
        }
        if (dataConnection == null) {
            if (this.isOnlySingleDcAllowed(radioTech)) {
                if (this.isHigherPriorityApnContextActive(apnContext)) {
                    this.log("setupData: Higher priority ApnContext active.  Ignoring call");
                    return false;
                }
                if (!apnContext.getApnType().equals("ims") && this.cleanUpAllConnectionsInternal(true, "SinglePdnArbitration")) {
                    this.log("setupData: Some calls are disconnecting first. Wait and retry");
                    return false;
                }
                this.log("setupData: Single pdp. Continue setting up data call.");
            }
            if ((dataConnection = this.findFreeDataConnection()) == null) {
                dataConnection = this.createDataConnection();
            }
            if (dataConnection == null) {
                this.log("setupData: No free DataConnection and couldn't create one, WEIRD");
                return false;
            }
        }
        int generation = apnContext.incAndGetConnectionGeneration();
        this.log("setupData: dc=" + dataConnection + " apnSetting=" + apnSetting + " gen#=" + generation);
        apnContext.setDataConnection(dataConnection);
        apnContext.setApnSetting(apnSetting);
        apnContext.setState(DctConstants.State.CONNECTING);
        this.mPhone.notifyDataConnection(apnContext.getApnType());
        Message msg = this.obtainMessage();
        msg.what = 270336;
        msg.obj = new Pair<ApnContext, Integer>(apnContext, generation);
        dataConnection.bringUp(apnContext, profileId, radioTech, msg, generation, requestType, this.mPhone.getSubId());
        this.log("setupData: initing!");
        return true;
    }

    private void setInitialAttachApn() {
        ApnSetting iaApnSetting = null;
        ApnSetting defaultApnSetting = null;
        ApnSetting firstNonEmergencyApnSetting = null;
        this.log("setInitialApn: E mPreferredApn=" + this.mPreferredApn);
        if (this.mPreferredApn != null && this.mPreferredApn.canHandleType(256)) {
            iaApnSetting = this.mPreferredApn;
        } else if (!this.mAllApnSettings.isEmpty()) {
            for (ApnSetting apn : this.mAllApnSettings) {
                if (firstNonEmergencyApnSetting == null && !apn.canHandleType(512)) {
                    firstNonEmergencyApnSetting = apn;
                    this.log("setInitialApn: firstNonEmergencyApnSetting=" + firstNonEmergencyApnSetting);
                }
                if (apn.canHandleType(256)) {
                    this.log("setInitialApn: iaApnSetting=" + apn);
                    iaApnSetting = apn;
                    break;
                }
                if (defaultApnSetting != null || !apn.canHandleType(17)) continue;
                this.log("setInitialApn: defaultApnSetting=" + apn);
                defaultApnSetting = apn;
            }
        }
        ApnSetting initialAttachApnSetting = null;
        if (iaApnSetting != null) {
            this.log("setInitialAttachApn: using iaApnSetting");
            initialAttachApnSetting = iaApnSetting;
        } else if (this.mPreferredApn != null) {
            this.log("setInitialAttachApn: using mPreferredApn");
            initialAttachApnSetting = this.mPreferredApn;
        } else if (defaultApnSetting != null) {
            this.log("setInitialAttachApn: using defaultApnSetting");
            initialAttachApnSetting = defaultApnSetting;
        } else if (firstNonEmergencyApnSetting != null) {
            this.log("setInitialAttachApn: using firstNonEmergencyApnSetting");
            initialAttachApnSetting = firstNonEmergencyApnSetting;
        }
        if (initialAttachApnSetting == null) {
            this.log("setInitialAttachApn: X There in no available apn");
        } else {
            this.log("setInitialAttachApn: X selected Apn=" + initialAttachApnSetting);
            this.mDataServiceManager.setInitialAttachApn(DcTracker.createDataProfile(initialAttachApnSetting, initialAttachApnSetting.equals(this.getPreferredApn())), this.mPhone.getServiceState().getDataRoamingFromRegistration(), null);
        }
    }

    private void onApnChanged() {
        boolean isDisconnected;
        DctConstants.State overallState = this.getOverallState();
        boolean bl = isDisconnected = overallState == DctConstants.State.IDLE || overallState == DctConstants.State.FAILED;
        if (this.mPhone instanceof GsmCdmaPhone) {
            ((GsmCdmaPhone)this.mPhone).updateCurrentCarrierInProvider();
        }
        this.log("onApnChanged: createAllApnList and cleanUpAllConnections");
        this.createAllApnList();
        this.setDataProfilesAsNeeded();
        this.setInitialAttachApn();
        this.cleanUpConnectionsOnUpdatedApns(!isDisconnected, "apnChanged");
        if (this.mPhone.getSubId() == SubscriptionManager.getDefaultDataSubscriptionId()) {
            this.setupDataOnAllConnectableApns("apnChanged", RetryFailures.ALWAYS);
        }
    }

    private boolean isHigherPriorityApnContextActive(ApnContext apnContext) {
        if (apnContext.getApnType().equals("ims")) {
            return false;
        }
        for (ApnContext otherContext : this.mPrioritySortedApnContexts) {
            if (otherContext.getApnType().equals("ims")) continue;
            if (apnContext.getApnType().equalsIgnoreCase(otherContext.getApnType())) {
                return false;
            }
            if (!otherContext.isEnabled() || otherContext.getState() == DctConstants.State.FAILED) continue;
            return true;
        }
        return false;
    }

    private boolean isOnlySingleDcAllowed(int rilRadioTech) {
        PersistableBundle bundle;
        int[] singleDcRats = null;
        CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        if (configManager != null && (bundle = configManager.getConfigForSubId(this.mPhone.getSubId())) != null) {
            singleDcRats = bundle.getIntArray("only_single_dc_allowed_int_array");
        }
        boolean onlySingleDcAllowed = false;
        if (Build.IS_DEBUGGABLE && SystemProperties.getBoolean("persist.telephony.test.singleDc", false)) {
            onlySingleDcAllowed = true;
        }
        if (singleDcRats != null) {
            for (int i = 0; i < singleDcRats.length && !onlySingleDcAllowed; ++i) {
                if (rilRadioTech != singleDcRats[i]) continue;
                onlySingleDcAllowed = true;
            }
        }
        this.log("isOnlySingleDcAllowed(" + rilRadioTech + "): " + onlySingleDcAllowed);
        return onlySingleDcAllowed;
    }

    void sendRestartRadio() {
        this.log("sendRestartRadio:");
        Message msg = this.obtainMessage(270362);
        this.sendMessage(msg);
    }

    private void restartRadio() {
        this.log("restartRadio: ************TURN OFF RADIO**************");
        this.cleanUpAllConnectionsInternal(true, "radioTurnedOff");
        this.mPhone.getServiceStateTracker().powerOffRadioSafely();
        int reset = Integer.parseInt(SystemProperties.get("net.ppp.reset-by-timeout", "0"));
        try {
            SystemProperties.set("net.ppp.reset-by-timeout", String.valueOf(reset + 1));
        }
        catch (RuntimeException ex) {
            this.log("Failed to set net.ppp.reset-by-timeout");
        }
    }

    private boolean retryAfterDisconnected(ApnContext apnContext) {
        boolean retry = true;
        String reason = apnContext.getReason();
        if ("radioTurnedOff".equals(reason) || this.isOnlySingleDcAllowed(this.getDataRat()) && this.isHigherPriorityApnContextActive(apnContext)) {
            retry = false;
        }
        return retry;
    }

    private void startAlarmForReconnect(long delay, ApnContext apnContext) {
        String apnType = apnContext.getApnType();
        Intent intent = new Intent("com.android.internal.telephony.data-reconnect." + apnType);
        intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON, apnContext.getReason());
        intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_TYPE, apnType);
        intent.putExtra(INTENT_RECONNECT_ALARM_EXTRA_TRANSPORT_TYPE, this.mTransportType);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
        intent.addFlags(0x10000000);
        this.log("startAlarmForReconnect: delay=" + delay + " action=" + intent.getAction() + " apn=" + apnContext);
        PendingIntent alarmIntent = PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
        apnContext.setReconnectIntent(alarmIntent);
        this.mAlarmManager.setExact(2, SystemClock.elapsedRealtime() + delay, alarmIntent);
    }

    private void notifyNoData(int lastFailCauseCode, ApnContext apnContext) {
        this.log("notifyNoData: type=" + apnContext.getApnType());
        if (this.isPermanentFailure(lastFailCauseCode) && !apnContext.getApnType().equals("default")) {
            this.mPhone.notifyDataConnectionFailed(apnContext.getApnType());
        }
    }

    private void onRecordsLoadedOrSubIdChanged() {
        this.log("onRecordsLoadedOrSubIdChanged: createAllApnList");
        if (this.mTransportType == 1) {
            this.mAutoAttachOnCreationConfig = this.mPhone.getContext().getResources().getBoolean(17891366);
        }
        this.createAllApnList();
        this.setDataProfilesAsNeeded();
        this.setInitialAttachApn();
        this.mPhone.notifyDataConnection();
        this.setupDataOnAllConnectableApns("simLoaded", RetryFailures.ALWAYS);
    }

    private void onSimNotReady() {
        this.log("onSimNotReady");
        this.cleanUpAllConnectionsInternal(true, "simNotReady");
        this.mAllApnSettings.clear();
        this.mAutoAttachOnCreationConfig = false;
        this.mAutoAttachEnabled.set(false);
        this.mOnSubscriptionsChangedListener.mPreviousSubId.set(-1);
        this.createAllApnList();
        this.setDataProfilesAsNeeded();
    }

    private DataConnection checkForCompatibleConnectedApnContext(ApnContext apnContext) {
        int apnType = apnContext.getApnTypeBitmask();
        ArrayList<ApnSetting> dunSettings = null;
        if (8 == apnType) {
            dunSettings = this.sortApnListByPreferred(this.fetchDunApns());
        }
        this.log("checkForCompatibleConnectedApnContext: apnContext=" + apnContext);
        DataConnection potentialDc = null;
        ApnContext potentialApnCtx = null;
        for (ApnContext curApnCtx : this.mApnContexts.values()) {
            DataConnection curDc = curApnCtx.getDataConnection();
            if (curDc == null) continue;
            ApnSetting apnSetting = curApnCtx.getApnSetting();
            this.log("apnSetting: " + apnSetting);
            if (dunSettings != null && dunSettings.size() > 0) {
                for (ApnSetting dunSetting : dunSettings) {
                    if (!dunSetting.equals(apnSetting)) continue;
                    switch (curApnCtx.getState()) {
                        case CONNECTED: {
                            this.log("checkForCompatibleConnectedApnContext: found dun conn=" + curDc + " curApnCtx=" + curApnCtx);
                            return curDc;
                        }
                        case CONNECTING: {
                            potentialDc = curDc;
                            potentialApnCtx = curApnCtx;
                            break;
                        }
                    }
                }
                continue;
            }
            if (apnSetting == null || !apnSetting.canHandleType(apnType)) continue;
            switch (curApnCtx.getState()) {
                case CONNECTED: {
                    this.log("checkForCompatibleConnectedApnContext: found canHandle conn=" + curDc + " curApnCtx=" + curApnCtx);
                    return curDc;
                }
                case CONNECTING: {
                    potentialDc = curDc;
                    potentialApnCtx = curApnCtx;
                    break;
                }
            }
        }
        if (potentialDc != null) {
            this.log("checkForCompatibleConnectedApnContext: found potential conn=" + potentialDc + " curApnCtx=" + potentialApnCtx);
            return potentialDc;
        }
        this.log("checkForCompatibleConnectedApnContext: NO conn apnContext=" + apnContext);
        return null;
    }

    private void addRequestNetworkCompleteMsg(Message onCompleteMsg, int apnType) {
        if (onCompleteMsg != null) {
            List<Message> messageList = this.mRequestNetworkCompletionMsgs.get(apnType);
            if (messageList == null) {
                messageList = new ArrayList<Message>();
            }
            messageList.add(onCompleteMsg);
            this.mRequestNetworkCompletionMsgs.put(apnType, messageList);
        }
    }

    private void sendRequestNetworkCompleteMsg(Message message, boolean success, int transport, int requestType) {
        if (message == null) {
            return;
        }
        Bundle b = message.getData();
        b.putBoolean(DATA_COMPLETE_MSG_EXTRA_SUCCESS, success);
        b.putInt(DATA_COMPLETE_MSG_EXTRA_REQUEST_TYPE, requestType);
        b.putInt(DATA_COMPLETE_MSG_EXTRA_TRANSPORT_TYPE, transport);
        message.sendToTarget();
    }

    public void enableApn(int apnType, int requestType, Message onCompleteMsg) {
        this.sendMessage(this.obtainMessage(270349, apnType, requestType, onCompleteMsg));
    }

    private void onEnableApn(int apnType, int requestType, Message onCompleteMsg) {
        ApnContext apnContext = this.mApnContextsByType.get(apnType);
        if (apnContext == null) {
            this.loge("onEnableApn(" + apnType + "): NO ApnContext");
            this.sendRequestNetworkCompleteMsg(onCompleteMsg, false, this.mTransportType, requestType);
            return;
        }
        String str = "onEnableApn: apnType=" + ApnSetting.getApnTypeString(apnType) + ", request type=" + DcTracker.requestTypeToString(requestType);
        this.log(str);
        apnContext.requestLog(str);
        if (!apnContext.isDependencyMet()) {
            apnContext.setReason("dependencyUnmet");
            apnContext.setEnabled(true);
            str = "onEnableApn: dependency is not met.";
            this.log(str);
            apnContext.requestLog(str);
            this.sendRequestNetworkCompleteMsg(onCompleteMsg, false, this.mTransportType, requestType);
            return;
        }
        if (apnContext.isReady()) {
            DctConstants.State state = apnContext.getState();
            switch (state) {
                case CONNECTING: {
                    this.log("onEnableApn: 'CONNECTING' so return");
                    apnContext.requestLog("onEnableApn state=CONNECTING, so return");
                    this.addRequestNetworkCompleteMsg(onCompleteMsg, apnType);
                    return;
                }
                case CONNECTED: {
                    this.log("onEnableApn: 'CONNECTED' so return");
                    apnContext.requestLog("onEnableApn state=CONNECTED, so return");
                    this.sendRequestNetworkCompleteMsg(onCompleteMsg, true, this.mTransportType, requestType);
                    return;
                }
                case DISCONNECTING: {
                    this.log("onEnableApn: 'DISCONNECTING' so return");
                    apnContext.requestLog("onEnableApn state=DISCONNECTING, so return");
                    this.sendRequestNetworkCompleteMsg(onCompleteMsg, false, this.mTransportType, requestType);
                    return;
                }
                case IDLE: 
                case RETRYING: 
                case FAILED: {
                    apnContext.setReason("dataEnabled");
                }
            }
        } else {
            if (apnContext.isEnabled()) {
                apnContext.setReason("dependencyMet");
            } else {
                apnContext.setReason("dataEnabled");
            }
            if (apnContext.getState() == DctConstants.State.FAILED) {
                apnContext.setState(DctConstants.State.IDLE);
            }
        }
        apnContext.setEnabled(true);
        apnContext.resetErrorCodeRetries();
        if (this.trySetupData(apnContext, requestType)) {
            this.addRequestNetworkCompleteMsg(onCompleteMsg, apnType);
        } else {
            this.sendRequestNetworkCompleteMsg(onCompleteMsg, false, this.mTransportType, requestType);
        }
    }

    public void disableApn(int apnType, int releaseType) {
        this.sendMessage(this.obtainMessage(270350, apnType, releaseType));
    }

    private void onDisableApn(int apnType, int releaseType) {
        ApnContext apnContext = this.mApnContextsByType.get(apnType);
        if (apnContext == null) {
            this.loge("disableApn(" + apnType + "): NO ApnContext");
            return;
        }
        boolean cleanup = false;
        String str = "onDisableApn: apnType=" + ApnSetting.getApnTypeString(apnType) + ", release type=" + DcTracker.releaseTypeToString(releaseType);
        this.log(str);
        apnContext.requestLog(str);
        if (apnContext.isReady()) {
            boolean bl = cleanup = releaseType == 2 || releaseType == 3;
            if (apnContext.isDependencyMet()) {
                apnContext.setReason("dataDisabledInternal");
                if ("dun".equals(apnContext.getApnType()) || apnContext.getState() != DctConstants.State.CONNECTED) {
                    str = "Clean up the connection. Apn type = " + apnContext.getApnType() + ", state = " + (Object)((Object)apnContext.getState());
                    this.log(str);
                    apnContext.requestLog(str);
                    cleanup = true;
                }
            } else {
                apnContext.setReason("dependencyUnmet");
            }
        }
        apnContext.setEnabled(false);
        if (cleanup) {
            this.cleanUpConnectionInternal(true, releaseType, apnContext);
        }
        if (this.isOnlySingleDcAllowed(this.getDataRat()) && !this.isHigherPriorityApnContextActive(apnContext)) {
            this.log("disableApn:isOnlySingleDcAllowed true & higher priority APN disabled");
            this.setupDataOnAllConnectableApns("SinglePdnArbitration", RetryFailures.ALWAYS);
        }
    }

    public void setDataRoamingEnabledByUser(boolean enabled) {
        this.mDataEnabledSettings.setDataRoamingEnabled(enabled);
        this.setDataRoamingFromUserAction(true);
        this.log("setDataRoamingEnabledByUser: set phoneSubId=" + this.mPhone.getSubId() + " isRoaming=" + enabled);
    }

    public boolean getDataRoamingEnabled() {
        boolean isDataRoamingEnabled = this.mDataEnabledSettings.getDataRoamingEnabled();
        return isDataRoamingEnabled;
    }

    private void setDefaultDataRoamingEnabled() {
        String setting = "data_roaming";
        boolean useCarrierSpecificDefault = false;
        if (this.mTelephonyManager.getSimCount() != 1) {
            setting = setting + this.mPhone.getSubId();
            try {
                Settings.Global.getInt(this.mResolver, setting);
            }
            catch (Settings.SettingNotFoundException ex) {
                useCarrierSpecificDefault = true;
            }
        } else if (!this.isDataRoamingFromUserAction()) {
            useCarrierSpecificDefault = true;
        }
        this.log("setDefaultDataRoamingEnabled: useCarrierSpecificDefault " + useCarrierSpecificDefault);
        if (useCarrierSpecificDefault) {
            boolean defaultVal = this.mDataEnabledSettings.getDefaultDataRoamingEnabled();
            this.mDataEnabledSettings.setDataRoamingEnabled(defaultVal);
        }
    }

    private boolean isDataRoamingFromUserAction() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
        if (!sp.contains("data_roaming_is_user_setting_key") && Settings.Global.getInt(this.mResolver, "device_provisioned", 0) == 0) {
            sp.edit().putBoolean("data_roaming_is_user_setting_key", false).commit();
        }
        return sp.getBoolean("data_roaming_is_user_setting_key", true);
    }

    private void setDataRoamingFromUserAction(boolean isUserAction) {
        SharedPreferences.Editor sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext()).edit();
        sp.putBoolean("data_roaming_is_user_setting_key", isUserAction).commit();
    }

    private void onDataRoamingOff() {
        this.log("onDataRoamingOff");
        this.reevaluateDataConnections();
        if (!this.getDataRoamingEnabled()) {
            this.setDataProfilesAsNeeded();
            this.setInitialAttachApn();
            this.setupDataOnAllConnectableApns("roamingOff", RetryFailures.ALWAYS);
        } else {
            this.mPhone.notifyDataConnection();
        }
    }

    private void onDataRoamingOnOrSettingsChanged(int messageType) {
        boolean settingChanged;
        this.log("onDataRoamingOnOrSettingsChanged");
        boolean bl = settingChanged = messageType == 270384;
        if (!this.mPhone.getServiceState().getDataRoaming()) {
            this.log("device is not roaming. ignored the request.");
            return;
        }
        this.checkDataRoamingStatus(settingChanged);
        if (this.getDataRoamingEnabled()) {
            if (settingChanged) {
                this.reevaluateDataConnections();
            }
            this.log("onDataRoamingOnOrSettingsChanged: setup data on roaming");
            this.setupDataOnAllConnectableApns("roamingOn", RetryFailures.ALWAYS);
            this.mPhone.notifyDataConnection();
        } else {
            this.log("onDataRoamingOnOrSettingsChanged: Tear down data connection on roaming.");
            this.cleanUpAllConnectionsInternal(true, "roamingOn");
        }
    }

    private void checkDataRoamingStatus(boolean settingChanged) {
        if (!settingChanged && !this.getDataRoamingEnabled() && this.mPhone.getServiceState().getDataRoaming()) {
            for (ApnContext apnContext : this.mApnContexts.values()) {
                if (apnContext.getState() != DctConstants.State.CONNECTED) continue;
                this.mDataRoamingLeakageLog.log("PossibleRoamingLeakage  connection params: " + (apnContext.getDataConnection() != null ? apnContext.getDataConnection().getConnectionParams() : ""));
            }
        }
    }

    private void onRadioAvailable() {
        this.log("onRadioAvailable");
        if (this.mPhone.getSimulatedRadioControl() != null) {
            this.mPhone.notifyDataConnection();
            this.log("onRadioAvailable: We're on the simulator; assuming data is connected");
        }
        if (this.getOverallState() != DctConstants.State.IDLE) {
            this.cleanUpConnectionInternal(true, 2, null);
        }
    }

    private void onRadioOffOrNotAvailable() {
        this.mReregisterOnReconnectFailure = false;
        this.mAutoAttachEnabled.set(false);
        if (this.mPhone.getSimulatedRadioControl() != null) {
            this.log("We're on the simulator; assuming radio off is meaningless");
        } else {
            this.log("onRadioOffOrNotAvailable: is off and clean up all connections");
            this.cleanUpAllConnectionsInternal(false, "radioTurnedOff");
        }
    }

    private void completeConnection(ApnContext apnContext, int type) {
        this.log("completeConnection: successful, notify the world apnContext=" + apnContext);
        if (this.mIsProvisioning && !TextUtils.isEmpty(this.mProvisioningUrl)) {
            this.log("completeConnection: MOBILE_PROVISIONING_ACTION url=" + this.mProvisioningUrl);
            Intent newIntent = Intent.makeMainSelectorActivity("android.intent.action.MAIN", "android.intent.category.APP_BROWSER");
            newIntent.setData(Uri.parse(this.mProvisioningUrl));
            newIntent.setFlags(0x10400000);
            try {
                this.mPhone.getContext().startActivity(newIntent);
            }
            catch (ActivityNotFoundException e) {
                this.loge("completeConnection: startActivityAsUser failed" + e);
            }
        }
        this.mIsProvisioning = false;
        this.mProvisioningUrl = null;
        if (this.mProvisioningSpinner != null) {
            this.sendMessage(this.obtainMessage(270378, this.mProvisioningSpinner));
        }
        if (type != 2) {
            this.mPhone.notifyDataConnection(apnContext.getApnType());
        }
        this.startNetStatPoll();
        this.startDataStallAlarm(false);
    }

    private void onDataSetupComplete(ApnContext apnContext, boolean success, int cause, int requestType) {
        int apnType = ApnSetting.getApnTypesBitmaskFromString(apnContext.getApnType());
        List<Message> messageList = this.mRequestNetworkCompletionMsgs.get(apnType);
        if (messageList != null) {
            for (Message msg : messageList) {
                this.sendRequestNetworkCompleteMsg(msg, success, this.mTransportType, requestType);
            }
            messageList.clear();
        }
        if (success) {
            DataConnection dataConnection = apnContext.getDataConnection();
            if (dataConnection == null) {
                this.log("onDataSetupComplete: no connection to DC, handle as error");
                this.onDataSetupCompleteError(apnContext, requestType);
            } else {
                String radioTestProperty;
                int pcoVal;
                ApnSetting apn = apnContext.getApnSetting();
                this.log("onDataSetupComplete: success apn=" + (apn == null ? "unknown" : apn.getApnName()));
                if (apn != null && !TextUtils.isEmpty(apn.getProxyAddressAsString())) {
                    try {
                        int port = apn.getProxyPort();
                        if (port == -1) {
                            port = 8080;
                        }
                        ProxyInfo proxy = new ProxyInfo(apn.getProxyAddressAsString(), port, null);
                        dataConnection.setLinkPropertiesHttpProxy(proxy);
                    }
                    catch (NumberFormatException e) {
                        this.loge("onDataSetupComplete: NumberFormatException making ProxyProperties (" + apn.getProxyPort() + "): " + e);
                    }
                }
                if (TextUtils.equals(apnContext.getApnType(), "default")) {
                    try {
                        SystemProperties.set(PUPPET_MASTER_RADIO_STRESS_TEST, "true");
                    }
                    catch (RuntimeException ex) {
                        this.log("Failed to set PUPPET_MASTER_RADIO_STRESS_TEST to true");
                    }
                    if (this.mCanSetPreferApn && this.mPreferredApn == null) {
                        this.log("onDataSetupComplete: PREFERRED APN is null");
                        this.mPreferredApn = apn;
                        if (this.mPreferredApn != null) {
                            this.setPreferredApn(this.mPreferredApn.getId());
                        }
                    }
                } else {
                    try {
                        SystemProperties.set(PUPPET_MASTER_RADIO_STRESS_TEST, "false");
                    }
                    catch (RuntimeException ex) {
                        this.log("Failed to set PUPPET_MASTER_RADIO_STRESS_TEST to false");
                    }
                }
                apnContext.setState(DctConstants.State.CONNECTED);
                this.checkDataRoamingStatus(false);
                boolean isProvApn = apnContext.isProvisioningApn();
                ConnectivityManager cm = ConnectivityManager.from(this.mPhone.getContext());
                if (this.mProvisionBroadcastReceiver != null) {
                    this.mPhone.getContext().unregisterReceiver(this.mProvisionBroadcastReceiver);
                    this.mProvisionBroadcastReceiver = null;
                }
                if (!isProvApn || this.mIsProvisioning) {
                    cm.setProvisioningNotificationVisible(false, 0, this.mProvisionActionName);
                    this.completeConnection(apnContext, requestType);
                } else {
                    this.log("onDataSetupComplete: successful, BUT send connected to prov apn as mIsProvisioning:" + this.mIsProvisioning + " == false && (isProvisioningApn:" + isProvApn + " == true");
                    this.mProvisionBroadcastReceiver = new ProvisionNotificationBroadcastReceiver(cm.getMobileProvisioningUrl(), this.mTelephonyManager.getNetworkOperatorName());
                    this.mPhone.getContext().registerReceiver(this.mProvisionBroadcastReceiver, new IntentFilter(this.mProvisionActionName));
                    cm.setProvisioningNotificationVisible(true, 0, this.mProvisionActionName);
                    this.setRadio(false);
                }
                this.log("onDataSetupComplete: SETUP complete type=" + apnContext.getApnType());
                if (Build.IS_DEBUGGABLE && (pcoVal = SystemProperties.getInt(radioTestProperty = "persist.radio.test.pco", -1)) != -1) {
                    this.log("PCO testing: read pco value from persist.radio.test.pco " + pcoVal);
                    byte[] value = new byte[]{(byte)pcoVal};
                    Intent intent = new Intent("com.android.internal.telephony.CARRIER_SIGNAL_PCO_VALUE");
                    intent.putExtra("apnType", "default");
                    intent.putExtra("apnProto", "IPV4V6");
                    intent.putExtra("pcoId", 65280);
                    intent.putExtra("pcoValue", value);
                    this.mPhone.getCarrierSignalAgent().notifyCarrierSignalReceivers(intent);
                }
            }
        } else {
            ApnSetting apn = apnContext.getApnSetting();
            this.log("onDataSetupComplete: error apn=" + apn.getApnName() + ", cause=" + cause + ", requestType=" + DcTracker.requestTypeToString(requestType));
            if (DataFailCause.isEventLoggable(cause)) {
                int cid = this.getCellLocationId();
                EventLog.writeEvent(50105, cause, cid, this.mTelephonyManager.getNetworkType());
            }
            apn = apnContext.getApnSetting();
            this.mPhone.notifyPreciseDataConnectionFailed(apnContext.getApnType(), apn != null ? apn.getApnName() : null, cause);
            Intent intent = new Intent("com.android.internal.telephony.CARRIER_SIGNAL_REQUEST_NETWORK_FAILED");
            intent.putExtra("errorCode", cause);
            intent.putExtra("apnType", apnContext.getApnType());
            this.mPhone.getCarrierSignalAgent().notifyCarrierSignalReceivers(intent);
            if (DataFailCause.isRadioRestartFailure(this.mPhone.getContext(), cause, this.mPhone.getSubId()) || apnContext.restartOnError(cause)) {
                this.log("Modem restarted.");
                this.sendRestartRadio();
            }
            if (this.isPermanentFailure(cause)) {
                this.log("cause = " + cause + ", mark apn as permanent failed. apn = " + apn);
                apnContext.markApnPermanentFailed(apn);
            }
            this.onDataSetupCompleteError(apnContext, requestType);
        }
    }

    private void onDataSetupCompleteError(ApnContext apnContext, int requestType) {
        long delay = apnContext.getDelayForNextApn(this.mFailFast);
        if (delay >= 0L) {
            this.log("onDataSetupCompleteError: Try next APN. delay = " + delay);
            apnContext.setState(DctConstants.State.RETRYING);
            this.startAlarmForReconnect(delay, apnContext);
        } else {
            apnContext.setState(DctConstants.State.FAILED);
            this.mPhone.notifyDataConnection(apnContext.getApnType());
            apnContext.setDataConnection(null);
            this.log("onDataSetupCompleteError: Stop retrying APNs. delay=" + delay + ", requestType=" + DcTracker.requestTypeToString(requestType));
        }
    }

    private void onNetworkStatusChanged(int status, String redirectUrl) {
        if (!TextUtils.isEmpty(redirectUrl)) {
            Intent intent = new Intent("com.android.internal.telephony.CARRIER_SIGNAL_REDIRECTED");
            intent.putExtra("redirectionUrl", redirectUrl);
            this.mPhone.getCarrierSignalAgent().notifyCarrierSignalReceivers(intent);
            this.log("Notify carrier signal receivers with redirectUrl: " + redirectUrl);
        } else {
            boolean isValid;
            boolean bl = isValid = status == 1;
            if (!this.mDsRecoveryHandler.isRecoveryOnBadNetworkEnabled()) {
                this.log("Skip data stall recovery on network status change with in threshold");
                return;
            }
            if (this.mTransportType != 1) {
                this.log("Skip data stall recovery on non WWAN");
                return;
            }
            this.mDsRecoveryHandler.processNetworkStatusChanged(isValid);
        }
    }

    private void onDisconnectDone(ApnContext apnContext) {
        this.log("onDisconnectDone: EVENT_DISCONNECT_DONE apnContext=" + apnContext);
        apnContext.setState(DctConstants.State.IDLE);
        DataConnection dc = apnContext.getDataConnection();
        if (dc != null && dc.isInactive() && !dc.hasBeenTransferred()) {
            String[] types;
            for (String type : types = ApnSetting.getApnTypesStringFromBitmask(apnContext.getApnSetting().getApnTypeBitmask()).split(",")) {
                this.mPhone.notifyDataConnection(type);
            }
        }
        if (this.isDisconnected() && this.mPhone.getServiceStateTracker().processPendingRadioPowerOffAfterDataOff()) {
            this.log("onDisconnectDone: radio will be turned off, no retries");
            apnContext.setApnSetting(null);
            apnContext.setDataConnection(null);
            if (this.mDisconnectPendingCount > 0) {
                --this.mDisconnectPendingCount;
            }
            if (this.mDisconnectPendingCount == 0) {
                this.notifyAllDataDisconnected();
            }
            return;
        }
        if (this.mAttached.get() && apnContext.isReady() && this.retryAfterDisconnected(apnContext)) {
            try {
                SystemProperties.set(PUPPET_MASTER_RADIO_STRESS_TEST, "false");
            }
            catch (RuntimeException ex) {
                this.log("Failed to set PUPPET_MASTER_RADIO_STRESS_TEST to false");
            }
            this.log("onDisconnectDone: attached, ready and retry after disconnect");
            long delay = apnContext.getRetryAfterDisconnectDelay();
            if (delay > 0L) {
                this.startAlarmForReconnect(delay, apnContext);
            }
        } else {
            boolean restartRadioAfterProvisioning = this.mPhone.getContext().getResources().getBoolean(17891500);
            if (apnContext.isProvisioningApn() && restartRadioAfterProvisioning) {
                this.log("onDisconnectDone: restartRadio after provisioning");
                this.restartRadio();
            }
            apnContext.setApnSetting(null);
            apnContext.setDataConnection(null);
            if (this.isOnlySingleDcAllowed(this.getDataRat())) {
                this.log("onDisconnectDone: isOnlySigneDcAllowed true so setup single apn");
                this.setupDataOnAllConnectableApns("SinglePdnArbitration", RetryFailures.ALWAYS);
            } else {
                this.log("onDisconnectDone: not retrying");
            }
        }
        if (this.mDisconnectPendingCount > 0) {
            --this.mDisconnectPendingCount;
        }
        if (this.mDisconnectPendingCount == 0) {
            apnContext.setConcurrentVoiceAndDataAllowed(this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed());
            this.notifyAllDataDisconnected();
        }
    }

    private void onVoiceCallStarted() {
        this.log("onVoiceCallStarted");
        this.mInVoiceCall = true;
        if (this.isConnected() && !this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) {
            this.log("onVoiceCallStarted stop polling");
            this.stopNetStatPoll();
            this.stopDataStallAlarm();
            this.mPhone.notifyDataConnection();
        }
    }

    private void onVoiceCallEnded() {
        this.log("onVoiceCallEnded");
        this.mInVoiceCall = false;
        if (this.isConnected()) {
            if (!this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) {
                this.startNetStatPoll();
                this.startDataStallAlarm(false);
                this.mPhone.notifyDataConnection();
            } else {
                this.resetPollStats();
            }
        }
        this.setupDataOnAllConnectableApns("2GVoiceCallEnded", RetryFailures.ALWAYS);
    }

    private boolean isConnected() {
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (apnContext.getState() != DctConstants.State.CONNECTED) continue;
            return true;
        }
        return false;
    }

    public boolean isDisconnected() {
        for (ApnContext apnContext : this.mApnContexts.values()) {
            if (apnContext.isDisconnected()) continue;
            return false;
        }
        return true;
    }

    private void setDataProfilesAsNeeded() {
        this.log("setDataProfilesAsNeeded");
        ArrayList<DataProfile> dataProfileList = new ArrayList<DataProfile>();
        for (ApnSetting apn : this.mAllApnSettings) {
            DataProfile dp = DcTracker.createDataProfile(apn, apn.equals(this.getPreferredApn()));
            if (dataProfileList.contains(dp)) continue;
            dataProfileList.add(dp);
        }
        if (!(dataProfileList.isEmpty() || dataProfileList.size() == this.mLastDataProfileList.size() && this.mLastDataProfileList.containsAll(dataProfileList))) {
            this.mDataServiceManager.setDataProfile(dataProfileList, this.mPhone.getServiceState().getDataRoamingFromRegistration(), null);
        }
    }

    private void createAllApnList() {
        this.mAllApnSettings.clear();
        IccRecords r = this.mIccRecords.get();
        String operator = r != null ? r.getOperatorNumeric() : "";
        Cursor cursor = this.mPhone.getContext().getContentResolver().query(Uri.withAppendedPath(Telephony.Carriers.SIM_APN_URI, "filtered/subId/" + this.mPhone.getSubId()), null, null, null, "_id");
        if (cursor != null) {
            while (cursor.moveToNext()) {
                ApnSetting apn = ApnSetting.makeApnSetting(cursor);
                if (apn == null) continue;
                this.mAllApnSettings.add(apn);
            }
            cursor.close();
        } else {
            this.log("createAllApnList: cursor is null");
            this.mApnSettingsInitializationLog.log("cursor is null for carrier, operator: " + operator);
        }
        this.addEmergencyApnSetting();
        this.dedupeApnSettings();
        if (this.mAllApnSettings.isEmpty()) {
            this.log("createAllApnList: No APN found for carrier, operator: " + operator);
            this.mApnSettingsInitializationLog.log("no APN found for carrier, operator: " + operator);
            this.mPreferredApn = null;
        } else {
            this.mPreferredApn = this.getPreferredApn();
            if (this.mPreferredApn != null && !this.mPreferredApn.getOperatorNumeric().equals(operator)) {
                this.mPreferredApn = null;
                this.setPreferredApn(-1);
            }
            this.log("createAllApnList: mPreferredApn=" + this.mPreferredApn);
        }
        this.log("createAllApnList: X mAllApnSettings=" + this.mAllApnSettings);
    }

    private void dedupeApnSettings() {
        ArrayList resultApns = new ArrayList();
        for (int i = 0; i < this.mAllApnSettings.size() - 1; ++i) {
            ApnSetting first = this.mAllApnSettings.get(i);
            ApnSetting second = null;
            int j = i + 1;
            while (j < this.mAllApnSettings.size()) {
                second = this.mAllApnSettings.get(j);
                if (first.similar(second)) {
                    ApnSetting newApn = this.mergeApns(first, second);
                    this.mAllApnSettings.set(i, newApn);
                    first = newApn;
                    this.mAllApnSettings.remove(j);
                    continue;
                }
                ++j;
            }
        }
    }

    private ApnSetting mergeApns(ApnSetting dest, ApnSetting src) {
        int id2 = dest.getId();
        if ((src.getApnTypeBitmask() & 0x11) == 17) {
            id2 = src.getId();
        }
        int resultApnType = src.getApnTypeBitmask() | dest.getApnTypeBitmask();
        Uri mmsc = dest.getMmsc() == null ? src.getMmsc() : dest.getMmsc();
        String mmsProxy = TextUtils.isEmpty(dest.getMmsProxyAddressAsString()) ? src.getMmsProxyAddressAsString() : dest.getMmsProxyAddressAsString();
        int mmsPort = dest.getMmsProxyPort() == -1 ? src.getMmsProxyPort() : dest.getMmsProxyPort();
        String proxy = TextUtils.isEmpty(dest.getProxyAddressAsString()) ? src.getProxyAddressAsString() : dest.getProxyAddressAsString();
        int port = dest.getProxyPort() == -1 ? src.getProxyPort() : dest.getProxyPort();
        int protocol = src.getProtocol() == 2 ? src.getProtocol() : dest.getProtocol();
        int roamingProtocol = src.getRoamingProtocol() == 2 ? src.getRoamingProtocol() : dest.getRoamingProtocol();
        int networkTypeBitmask = dest.getNetworkTypeBitmask() == 0 || src.getNetworkTypeBitmask() == 0 ? 0 : dest.getNetworkTypeBitmask() | src.getNetworkTypeBitmask();
        return ApnSetting.makeApnSetting(id2, dest.getOperatorNumeric(), dest.getEntryName(), dest.getApnName(), proxy, port, mmsc, mmsProxy, mmsPort, dest.getUser(), dest.getPassword(), dest.getAuthType(), resultApnType, protocol, roamingProtocol, dest.isEnabled(), networkTypeBitmask, dest.getProfileId(), dest.isPersistent() || src.isPersistent(), dest.getMaxConns(), dest.getWaitTime(), dest.getMaxConnsTime(), dest.getMtu(), dest.getMvnoType(), dest.getMvnoMatchData(), dest.getApnSetId(), dest.getCarrierId(), dest.getSkip464Xlat());
    }

    private DataConnection createDataConnection() {
        this.log("createDataConnection E");
        int id2 = this.mUniqueIdGenerator.getAndIncrement();
        DataConnection dataConnection = DataConnection.makeDataConnection(this.mPhone, id2, this, this.mDataServiceManager, this.mDcTesterFailBringUpAll, this.mDcc);
        this.mDataConnections.put(id2, dataConnection);
        this.log("createDataConnection() X id=" + id2 + " dc=" + dataConnection);
        return dataConnection;
    }

    private void destroyDataConnections() {
        if (this.mDataConnections != null) {
            this.log("destroyDataConnections: clear mDataConnectionList");
            this.mDataConnections.clear();
        } else {
            this.log("destroyDataConnections: mDataConnecitonList is empty, ignore");
        }
    }

    private ArrayList<ApnSetting> buildWaitingApns(String requestedApnType, int radioTech) {
        ArrayList<ApnSetting> dunApns;
        this.log("buildWaitingApns: E requestedApnType=" + requestedApnType);
        ArrayList<ApnSetting> apnList = new ArrayList<ApnSetting>();
        int requestedApnTypeBitmask = ApnSetting.getApnTypesBitmaskFromString(requestedApnType);
        if (requestedApnTypeBitmask == 8 && (dunApns = this.fetchDunApns()).size() > 0) {
            for (ApnSetting dun : dunApns) {
                apnList.add(dun);
                this.log("buildWaitingApns: X added APN_TYPE_DUN apnList=" + apnList);
            }
            return this.sortApnListByPreferred(apnList);
        }
        IccRecords r = this.mIccRecords.get();
        String operator = r != null ? r.getOperatorNumeric() : "";
        boolean usePreferred = true;
        try {
            usePreferred = !this.mPhone.getContext().getResources().getBoolean(17891415);
        }
        catch (Resources.NotFoundException e) {
            this.log("buildWaitingApns: usePreferred NotFoundException set to true");
            usePreferred = true;
        }
        if (usePreferred) {
            this.mPreferredApn = this.getPreferredApn();
        }
        this.log("buildWaitingApns: usePreferred=" + usePreferred + " canSetPreferApn=" + this.mCanSetPreferApn + " mPreferredApn=" + this.mPreferredApn + " operator=" + operator + " radioTech=" + radioTech + " IccRecords r=" + r);
        if (usePreferred && this.mCanSetPreferApn && this.mPreferredApn != null && this.mPreferredApn.canHandleType(requestedApnTypeBitmask)) {
            this.log("buildWaitingApns: Preferred APN:" + operator + ":" + this.mPreferredApn.getOperatorNumeric() + ":" + this.mPreferredApn);
            if (this.mPreferredApn.getOperatorNumeric().equals(operator)) {
                if (this.mPreferredApn.canSupportNetworkType(ServiceState.rilRadioTechnologyToNetworkType(radioTech))) {
                    apnList.add(this.mPreferredApn);
                    apnList = this.sortApnListByPreferred(apnList);
                    this.log("buildWaitingApns: X added preferred apnList=" + apnList);
                    return apnList;
                }
                this.log("buildWaitingApns: no preferred APN");
                this.setPreferredApn(-1);
                this.mPreferredApn = null;
            } else {
                this.log("buildWaitingApns: no preferred APN");
                this.setPreferredApn(-1);
                this.mPreferredApn = null;
            }
        }
        this.log("buildWaitingApns: mAllApnSettings=" + this.mAllApnSettings);
        for (ApnSetting apn : this.mAllApnSettings) {
            if (!apn.canHandleType(requestedApnTypeBitmask)) continue;
            if (apn.canSupportNetworkType(ServiceState.rilRadioTechnologyToNetworkType(radioTech))) {
                apnList.add(apn);
                continue;
            }
            this.log("buildWaitingApns: networkTypeBitmask:" + apn.getNetworkTypeBitmask() + " does not include radioTech:" + ServiceState.rilRadioTechnologyToString(radioTech));
        }
        apnList = this.sortApnListByPreferred(apnList);
        this.log("buildWaitingApns: " + apnList.size() + " APNs in the list: " + apnList);
        return apnList;
    }

    @VisibleForTesting
    public ArrayList<ApnSetting> sortApnListByPreferred(ArrayList<ApnSetting> list) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        final int preferredApnSetId = this.getPreferredApnSetId();
        if (preferredApnSetId != 0) {
            list.sort(new Comparator<ApnSetting>(){

                @Override
                public int compare(ApnSetting apn1, ApnSetting apn2) {
                    if (apn1.getApnSetId() == preferredApnSetId) {
                        return -1;
                    }
                    if (apn2.getApnSetId() == preferredApnSetId) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        return list;
    }

    private String apnListToString(ArrayList<ApnSetting> apns) {
        StringBuilder result = new StringBuilder();
        int size = apns.size();
        for (int i = 0; i < size; ++i) {
            result.append('[').append(apns.get(i).toString()).append(']');
        }
        return result.toString();
    }

    private void setPreferredApn(int pos) {
        if (!this.mCanSetPreferApn) {
            this.log("setPreferredApn: X !canSEtPreferApn");
            return;
        }
        String subId = Long.toString(this.mPhone.getSubId());
        Uri uri = Uri.withAppendedPath(PREFERAPN_NO_UPDATE_URI_USING_SUBID, subId);
        this.log("setPreferredApn: delete");
        ContentResolver resolver = this.mPhone.getContext().getContentResolver();
        resolver.delete(uri, null, null);
        if (pos >= 0) {
            this.log("setPreferredApn: insert");
            ContentValues values = new ContentValues();
            values.put(APN_ID, pos);
            resolver.insert(uri, values);
        }
    }

    ApnSetting getPreferredApn() {
        if (this.mAllApnSettings == null || this.mAllApnSettings.isEmpty()) {
            this.log("getPreferredApn: mAllApnSettings is empty");
            return null;
        }
        String subId = Long.toString(this.mPhone.getSubId());
        Uri uri = Uri.withAppendedPath(PREFERAPN_NO_UPDATE_URI_USING_SUBID, subId);
        Cursor cursor = this.mPhone.getContext().getContentResolver().query(uri, new String[]{"_id", "name", "apn"}, null, null, "name ASC");
        this.mCanSetPreferApn = cursor != null;
        if (this.mCanSetPreferApn && cursor.getCount() > 0) {
            cursor.moveToFirst();
            int pos = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
            for (ApnSetting p : this.mAllApnSettings) {
                if (p.getId() != pos || !p.canHandleType(this.mRequestedApnType)) continue;
                this.log("getPreferredApn: For APN type " + ApnSetting.getApnTypeString(this.mRequestedApnType) + " found apnSetting " + p);
                cursor.close();
                return p;
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        this.log("getPreferredApn: X not found");
        return null;
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 270338: {
                int subId = this.mPhone.getSubId();
                if (SubscriptionManager.isValidSubscriptionId(subId)) {
                    this.onRecordsLoadedOrSubIdChanged();
                    break;
                }
                this.log("Ignoring EVENT_RECORDS_LOADED as subId is not valid: " + subId);
                break;
            }
            case 270345: {
                this.onDataConnectionDetached();
                break;
            }
            case 270352: {
                this.onDataConnectionAttached();
                break;
            }
            case 270354: {
                this.mDsRecoveryHandler.doRecovery();
                break;
            }
            case 270355: {
                this.onApnChanged();
                break;
            }
            case 270358: {
                this.log("EVENT_PS_RESTRICT_ENABLED " + this.mIsPsRestricted);
                this.stopNetStatPoll();
                this.stopDataStallAlarm();
                this.mIsPsRestricted = true;
                break;
            }
            case 270359: {
                ApnContext apnContext;
                this.log("EVENT_PS_RESTRICT_DISABLED " + this.mIsPsRestricted);
                this.mIsPsRestricted = false;
                if (this.isConnected()) {
                    this.startNetStatPoll();
                    this.startDataStallAlarm(false);
                    break;
                }
                if (this.mState == DctConstants.State.FAILED) {
                    this.cleanUpAllConnectionsInternal(false, "psRestrictEnabled");
                    this.mReregisterOnReconnectFailure = false;
                }
                if ((apnContext = this.mApnContextsByType.get(17)) != null) {
                    apnContext.setReason("psRestrictEnabled");
                    this.trySetupData(apnContext, 1);
                    break;
                }
                this.loge("**** Default ApnContext not found ****");
                if (!Build.IS_DEBUGGABLE) break;
                throw new RuntimeException("Default ApnContext not found");
            }
            case 270339: {
                this.trySetupData((ApnContext)msg.obj, 1);
                break;
            }
            case 270360: {
                this.log("EVENT_CLEAN_UP_CONNECTION");
                this.cleanUpConnectionInternal(true, 2, (ApnContext)msg.obj);
                break;
            }
            case 270365: {
                if (msg.obj != null && !(msg.obj instanceof String)) {
                    msg.obj = null;
                }
                this.cleanUpAllConnectionsInternal(true, (String)msg.obj);
                break;
            }
            case 270377: {
                if (this.getDataRat() == 0) break;
                this.cleanUpConnectionsOnUpdatedApns(false, "nwTypeChanged");
                this.setupDataOnAllConnectableApns("nwTypeChanged", RetryFailures.ONLY_ON_CHANGE);
                break;
            }
            case 270378: {
                if (this.mProvisioningSpinner != msg.obj) break;
                this.mProvisioningSpinner.dismiss();
                this.mProvisioningSpinner = null;
                break;
            }
            case 270349: {
                this.onEnableApn(msg.arg1, msg.arg2, (Message)msg.obj);
                break;
            }
            case 270350: {
                this.onDisableApn(msg.arg1, msg.arg2);
                break;
            }
            case 270353: {
                this.onDataStallAlarm(msg.arg1);
                break;
            }
            case 270348: {
                this.onDataRoamingOff();
                break;
            }
            case 270347: 
            case 270384: {
                this.onDataRoamingOnOrSettingsChanged(msg.what);
                break;
            }
            case 270386: {
                SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
                if (sp.contains("data_roaming_is_user_setting_key")) break;
                sp.edit().putBoolean("data_roaming_is_user_setting_key", false).commit();
                break;
            }
            case 270380: {
                int status = msg.arg1;
                String url = (String)msg.obj;
                this.onNetworkStatusChanged(status, url);
                break;
            }
            case 270337: {
                this.onRadioAvailable();
                break;
            }
            case 270342: {
                this.onRadioOffOrNotAvailable();
                break;
            }
            case 270336: {
                AsyncResult ar = (AsyncResult)msg.obj;
                Pair pair = (Pair)ar.userObj;
                ApnContext apnContext = (ApnContext)pair.first;
                int generation = (Integer)pair.second;
                int requestType = msg.arg2;
                if (apnContext.getConnectionGeneration() == generation) {
                    boolean success = true;
                    int cause = 65536;
                    if (ar.exception != null) {
                        success = false;
                        cause = (Integer)ar.result;
                    }
                    this.onDataSetupComplete(apnContext, success, cause, requestType);
                    break;
                }
                this.loge("EVENT_DATA_SETUP_COMPLETE: Dropped the event because generation did not match.");
                break;
            }
            case 270371: {
                AsyncResult ar = (AsyncResult)msg.obj;
                Pair pair = (Pair)ar.userObj;
                ApnContext apnContext = (ApnContext)pair.first;
                int generation = (Integer)pair.second;
                int requestType = msg.arg2;
                if (apnContext.getConnectionGeneration() == generation) {
                    this.onDataSetupCompleteError(apnContext, requestType);
                    break;
                }
                this.loge("EVENT_DATA_SETUP_COMPLETE_ERROR: Dropped the event because generation did not match.");
                break;
            }
            case 270351: {
                this.log("EVENT_DISCONNECT_DONE msg=" + msg);
                AsyncResult ar = (AsyncResult)msg.obj;
                Pair pair = (Pair)ar.userObj;
                ApnContext apnContext = (ApnContext)pair.first;
                int generation = (Integer)pair.second;
                if (apnContext.getConnectionGeneration() == generation) {
                    this.onDisconnectDone(apnContext);
                    break;
                }
                this.loge("EVENT_DISCONNECT_DONE: Dropped the event because generation did not match.");
                break;
            }
            case 270343: {
                this.onVoiceCallStarted();
                break;
            }
            case 270344: {
                this.onVoiceCallEnded();
                break;
            }
            case 270372: {
                this.log("CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA:  sEnableFailFastRefCounter=" + (sEnableFailFastRefCounter += msg.arg1 == 1 ? 1 : -1));
                if (sEnableFailFastRefCounter < 0) {
                    String s = "CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA: sEnableFailFastRefCounter:" + sEnableFailFastRefCounter + " < 0";
                    this.loge(s);
                    sEnableFailFastRefCounter = 0;
                }
                boolean enabled = sEnableFailFastRefCounter > 0;
                this.log("CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA: enabled=" + enabled + " sEnableFailFastRefCounter=" + sEnableFailFastRefCounter);
                if (this.mFailFast == enabled) break;
                this.mFailFast = enabled;
                boolean bl = this.mDataStallNoRxEnabled = !enabled;
                if (this.mDsRecoveryHandler.isNoRxDataStallDetectionEnabled() && this.getOverallState() == DctConstants.State.CONNECTED && (!this.mInVoiceCall || this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed())) {
                    this.log("CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA: start data stall");
                    this.stopDataStallAlarm();
                    this.startDataStallAlarm(false);
                    break;
                }
                this.log("CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA: stop data stall");
                this.stopDataStallAlarm();
                break;
            }
            case 270373: {
                Bundle bundle = msg.getData();
                if (bundle != null) {
                    try {
                        this.mProvisioningUrl = (String)bundle.get("provisioningUrl");
                    }
                    catch (ClassCastException e) {
                        this.loge("CMD_ENABLE_MOBILE_PROVISIONING: provisioning url not a string" + e);
                        this.mProvisioningUrl = null;
                    }
                }
                if (TextUtils.isEmpty(this.mProvisioningUrl)) {
                    this.loge("CMD_ENABLE_MOBILE_PROVISIONING: provisioning url is empty, ignoring");
                    this.mIsProvisioning = false;
                    this.mProvisioningUrl = null;
                    break;
                }
                this.loge("CMD_ENABLE_MOBILE_PROVISIONING: provisioningUrl=" + this.mProvisioningUrl);
                this.mIsProvisioning = true;
                this.startProvisioningApnAlarm();
                break;
            }
            case 270375: {
                this.log("EVENT_PROVISIONING_APN_ALARM");
                ApnContext apnCtx = this.mApnContextsByType.get(17);
                if (apnCtx.isProvisioningApn() && apnCtx.isConnectedOrConnecting()) {
                    if (this.mProvisioningApnAlarmTag == msg.arg1) {
                        this.log("EVENT_PROVISIONING_APN_ALARM: Disconnecting");
                        this.mIsProvisioning = false;
                        this.mProvisioningUrl = null;
                        this.stopProvisioningApnAlarm();
                        this.cleanUpConnectionInternal(true, 2, apnCtx);
                        break;
                    }
                    this.log("EVENT_PROVISIONING_APN_ALARM: ignore stale tag, mProvisioningApnAlarmTag:" + this.mProvisioningApnAlarmTag + " != arg1:" + msg.arg1);
                    break;
                }
                this.log("EVENT_PROVISIONING_APN_ALARM: Not connected ignore");
                break;
            }
            case 270374: {
                boolean isProvApn;
                this.log("CMD_IS_PROVISIONING_APN");
                try {
                    String apnType = null;
                    Bundle bundle = msg.getData();
                    if (bundle != null) {
                        apnType = (String)bundle.get("apnType");
                    }
                    if (TextUtils.isEmpty(apnType)) {
                        this.loge("CMD_IS_PROVISIONING_APN: apnType is empty");
                        isProvApn = false;
                    } else {
                        isProvApn = this.isProvisioningApn(apnType);
                    }
                }
                catch (ClassCastException e) {
                    this.loge("CMD_IS_PROVISIONING_APN: NO provisioning url ignoring");
                    isProvApn = false;
                }
                this.log("CMD_IS_PROVISIONING_APN: ret=" + isProvApn);
                this.mReplyAc.replyToMessage(msg, 270374, isProvApn ? 1 : 0);
                break;
            }
            case 270369: {
                this.onUpdateIcc();
                break;
            }
            case 270362: {
                this.restartRadio();
                break;
            }
            case 270376: {
                if (msg.arg1 == 1) {
                    this.handleStartNetStatPoll((DctConstants.Activity)((Object)msg.obj));
                    break;
                }
                if (msg.arg1 != 0) break;
                this.handleStopNetStatPoll((DctConstants.Activity)((Object)msg.obj));
                break;
            }
            case 270381: {
                this.handlePcoData((AsyncResult)msg.obj);
                break;
            }
            case 270383: {
                this.onDataReconnect(msg.getData());
                break;
            }
            case 270385: {
                this.onDataServiceBindingChanged((Boolean)((AsyncResult)msg.obj).result);
                break;
            }
            case 270382: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (!(ar.result instanceof Pair)) break;
                Pair p = (Pair)ar.result;
                boolean enabled = (Boolean)p.first;
                int reason = (Integer)p.second;
                this.onDataEnabledChanged(enabled, reason);
                break;
            }
            case 270387: {
                this.onDataEnabledOverrideRulesChanged();
                break;
            }
            default: {
                Rlog.e("DcTracker", "Unhandled event=" + msg);
            }
        }
    }

    private int getApnProfileID(String apnType) {
        if (TextUtils.equals(apnType, "ims")) {
            return 2;
        }
        if (TextUtils.equals(apnType, "fota")) {
            return 3;
        }
        if (TextUtils.equals(apnType, "cbs")) {
            return 4;
        }
        if (TextUtils.equals(apnType, "ia")) {
            return 0;
        }
        if (TextUtils.equals(apnType, "dun")) {
            return 1;
        }
        return 0;
    }

    private int getCellLocationId() {
        int cid = -1;
        CellLocation loc = this.mPhone.getCellLocation();
        if (loc != null) {
            if (loc instanceof GsmCellLocation) {
                cid = ((GsmCellLocation)loc).getCid();
            } else if (loc instanceof CdmaCellLocation) {
                cid = ((CdmaCellLocation)loc).getBaseStationId();
            }
        }
        return cid;
    }

    private IccRecords getUiccRecords(int appFamily) {
        return this.mUiccController.getIccRecords(this.mPhone.getPhoneId(), appFamily);
    }

    private void onUpdateIcc() {
        if (this.mUiccController == null) {
            return;
        }
        IccRecords newIccRecords = this.getUiccRecords(1);
        IccRecords r = this.mIccRecords.get();
        if (r != newIccRecords) {
            if (r != null) {
                this.log("Removing stale icc objects.");
                r.unregisterForRecordsLoaded(this);
                this.mIccRecords.set(null);
            }
            if (newIccRecords != null) {
                if (SubscriptionManager.isValidSubscriptionId(this.mPhone.getSubId())) {
                    this.log("New records found.");
                    this.mIccRecords.set(newIccRecords);
                    newIccRecords.registerForRecordsLoaded(this, 270338, null);
                }
            } else {
                this.onSimNotReady();
            }
        }
    }

    public void update() {
        this.log("update sub = " + this.mPhone.getSubId());
        this.log("update(): Active DDS, register for all events now!");
        this.onUpdateIcc();
        this.mAutoAttachEnabled.set(false);
        this.mPhone.updateCurrentCarrierInProvider();
    }

    @VisibleForTesting
    public boolean shouldAutoAttach() {
        if (this.mAutoAttachEnabled.get()) {
            return true;
        }
        PhoneSwitcher phoneSwitcher = PhoneSwitcher.getInstance();
        ServiceState serviceState = this.mPhone.getServiceState();
        return phoneSwitcher != null && serviceState != null && this.mPhone.getPhoneId() != phoneSwitcher.getPreferredDataPhoneId() && serviceState.getVoiceRegState() == 0 && serviceState.getVoiceNetworkType() != 13 && serviceState.getVoiceNetworkType() != 20;
    }

    private void notifyAllDataDisconnected() {
        sEnableFailFastRefCounter = 0;
        this.mFailFast = false;
        this.mAllDataDisconnectedRegistrants.notifyRegistrants();
    }

    public void registerForAllDataDisconnected(Handler h, int what) {
        this.mAllDataDisconnectedRegistrants.addUnique(h, what, null);
        if (this.isDisconnected()) {
            this.log("notify All Data Disconnected");
            this.notifyAllDataDisconnected();
        }
    }

    public void unregisterForAllDataDisconnected(Handler h) {
        this.mAllDataDisconnectedRegistrants.remove(h);
    }

    private void onDataEnabledChanged(boolean enable, int enabledChangedReason) {
        this.log("onDataEnabledChanged: enable=" + enable + ", enabledChangedReason=" + enabledChangedReason);
        if (enable) {
            this.reevaluateDataConnections();
            this.setupDataOnAllConnectableApns("dataEnabled", RetryFailures.ALWAYS);
        } else {
            String cleanupReason;
            switch (enabledChangedReason) {
                case 1: {
                    cleanupReason = "dataDisabledInternal";
                    break;
                }
                case 4: {
                    cleanupReason = "carrierActionDisableMeteredApn";
                    break;
                }
                default: {
                    cleanupReason = "specificDisabled";
                }
            }
            this.cleanUpAllConnectionsInternal(true, cleanupReason);
        }
    }

    private void log(String s) {
        Rlog.d(this.mLogTag, s);
    }

    private void loge(String s) {
        Rlog.e(this.mLogTag, s);
    }

    /*
     * WARNING - void declaration
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        void var8_14;
        pw.println("DcTracker:");
        pw.println(" RADIO_TESTS=false");
        pw.println(" mDataEnabledSettings=" + this.mDataEnabledSettings);
        pw.println(" isDataAllowed=" + this.isDataAllowed(null));
        pw.flush();
        pw.println(" mRequestedApnType=" + this.mRequestedApnType);
        pw.println(" mPhone=" + this.mPhone.getPhoneName());
        pw.println(" mActivity=" + (Object)((Object)this.mActivity));
        pw.println(" mState=" + (Object)((Object)this.mState));
        pw.println(" mTxPkts=" + this.mTxPkts);
        pw.println(" mRxPkts=" + this.mRxPkts);
        pw.println(" mNetStatPollPeriod=" + this.mNetStatPollPeriod);
        pw.println(" mNetStatPollEnabled=" + this.mNetStatPollEnabled);
        pw.println(" mDataStallTxRxSum=" + this.mDataStallTxRxSum);
        pw.println(" mDataStallAlarmTag=" + this.mDataStallAlarmTag);
        pw.println(" mDataStallNoRxEnabled=" + this.mDataStallNoRxEnabled);
        pw.println(" mEmergencyApn=" + this.mEmergencyApn);
        pw.println(" mSentSinceLastRecv=" + this.mSentSinceLastRecv);
        pw.println(" mNoRecvPollCount=" + this.mNoRecvPollCount);
        pw.println(" mResolver=" + this.mResolver);
        pw.println(" mReconnectIntent=" + this.mReconnectIntent);
        pw.println(" mAutoAttachEnabled=" + this.mAutoAttachEnabled.get());
        pw.println(" mIsScreenOn=" + this.mIsScreenOn);
        pw.println(" mUniqueIdGenerator=" + this.mUniqueIdGenerator);
        pw.println(" mDataServiceBound=" + this.mDataServiceBound);
        pw.println(" mDataRoamingLeakageLog= ");
        this.mDataRoamingLeakageLog.dump(fd, pw, args);
        pw.println(" mApnSettingsInitializationLog= ");
        this.mApnSettingsInitializationLog.dump(fd, pw, args);
        pw.flush();
        pw.println(" ***************************************");
        DcController dcc = this.mDcc;
        if (dcc != null) {
            if (this.mDataServiceBound) {
                dcc.dump(fd, pw, args);
            } else {
                pw.println(" Can't dump mDcc because data service is not bound.");
            }
        } else {
            pw.println(" mDcc=null");
        }
        pw.println(" ***************************************");
        HashMap<Integer, DataConnection> dcs = this.mDataConnections;
        if (dcs != null) {
            Set<Map.Entry<Integer, DataConnection>> mDcSet = this.mDataConnections.entrySet();
            pw.println(" mDataConnections: count=" + mDcSet.size());
            for (Map.Entry<Integer, DataConnection> entry : mDcSet) {
                pw.printf(" *** mDataConnection[%d] \n", entry.getKey());
                entry.getValue().dump(fd, pw, args);
            }
        } else {
            pw.println("mDataConnections=null");
        }
        pw.println(" ***************************************");
        pw.flush();
        HashMap<String, Integer> apnToDcId = this.mApnToDataConnectionId;
        if (apnToDcId != null) {
            Set<Map.Entry<String, Integer>> apnToDcIdSet = apnToDcId.entrySet();
            pw.println(" mApnToDataConnectonId size=" + apnToDcIdSet.size());
            for (Map.Entry<String, Integer> entry : apnToDcIdSet) {
                pw.printf(" mApnToDataConnectonId[%s]=%d\n", entry.getKey(), entry.getValue());
            }
        } else {
            pw.println("mApnToDataConnectionId=null");
        }
        pw.println(" ***************************************");
        pw.flush();
        ConcurrentHashMap<String, ApnContext> apnCtxs = this.mApnContexts;
        if (apnCtxs != null) {
            Set<Map.Entry<String, ApnContext>> set = apnCtxs.entrySet();
            pw.println(" mApnContexts size=" + set.size());
            for (Map.Entry<String, ApnContext> entry : set) {
                entry.getValue().dump(fd, pw, args);
            }
            pw.println(" ***************************************");
        } else {
            pw.println(" mApnContexts=null");
        }
        pw.flush();
        pw.println(" mAllApnSettings size=" + this.mAllApnSettings.size());
        boolean bl = false;
        while (var8_14 < this.mAllApnSettings.size()) {
            pw.printf(" mAllApnSettings[%d]: %s\n", (int)var8_14, this.mAllApnSettings.get((int)var8_14));
            ++var8_14;
        }
        pw.flush();
        pw.println(" mPreferredApn=" + this.mPreferredApn);
        pw.println(" mIsPsRestricted=" + this.mIsPsRestricted);
        pw.println(" mIsDisposed=" + this.mIsDisposed);
        pw.println(" mIntentReceiver=" + this.mIntentReceiver);
        pw.println(" mReregisterOnReconnectFailure=" + this.mReregisterOnReconnectFailure);
        pw.println(" canSetPreferApn=" + this.mCanSetPreferApn);
        pw.println(" mApnObserver=" + this.mApnObserver);
        pw.println(" getOverallState=" + (Object)((Object)this.getOverallState()));
        pw.println(" mAttached=" + this.mAttached.get());
        this.mDataEnabledSettings.dump(fd, pw, args);
        pw.flush();
    }

    public String[] getPcscfAddress(String apnType) {
        this.log("getPcscfAddress()");
        ApnContext apnContext = null;
        if (apnType == null) {
            this.log("apnType is null, return null");
            return null;
        }
        if (TextUtils.equals(apnType, "emergency")) {
            apnContext = this.mApnContextsByType.get(512);
        } else if (TextUtils.equals(apnType, "ims")) {
            apnContext = this.mApnContextsByType.get(64);
        } else {
            this.log("apnType is invalid, return null");
            return null;
        }
        if (apnContext == null) {
            this.log("apnContext is null, return null");
            return null;
        }
        DataConnection dataConnection = apnContext.getDataConnection();
        String[] result = null;
        if (dataConnection != null) {
            result = dataConnection.getPcscfAddresses();
            if (result != null) {
                for (int i = 0; i < result.length; ++i) {
                    this.log("Pcscf[" + i + "]: " + result[i]);
                }
            }
            return result;
        }
        return null;
    }

    private void initEmergencyApnSetting() {
        String selection = "type=\"emergency\"";
        Cursor cursor = this.mPhone.getContext().getContentResolver().query(Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "filtered"), null, selection, null, null);
        if (cursor != null) {
            if (cursor.getCount() > 0 && cursor.moveToFirst()) {
                this.mEmergencyApn = ApnSetting.makeApnSetting(cursor);
            }
            cursor.close();
        }
        if (this.mEmergencyApn != null) {
            return;
        }
        this.mEmergencyApn = new ApnSetting.Builder().setEntryName("Emergency").setProtocol(2).setApnName("sos").setApnTypeBitmask(512).build();
    }

    private void addEmergencyApnSetting() {
        if (this.mEmergencyApn != null) {
            for (ApnSetting apn : this.mAllApnSettings) {
                if (!apn.canHandleType(512)) continue;
                this.log("addEmergencyApnSetting - E-APN setting is already present");
                return;
            }
            if (!this.mAllApnSettings.contains(this.mEmergencyApn)) {
                this.mAllApnSettings.add(this.mEmergencyApn);
                this.log("Adding emergency APN : " + this.mEmergencyApn);
                return;
            }
        }
    }

    private boolean containsAllApns(ArrayList<ApnSetting> oldApnList, ArrayList<ApnSetting> newApnList) {
        for (ApnSetting newApnSetting : newApnList) {
            boolean canHandle = false;
            for (ApnSetting oldApnSetting : oldApnList) {
                if (!oldApnSetting.equals(newApnSetting, this.mPhone.getServiceState().getDataRoamingFromRegistration())) continue;
                canHandle = true;
                break;
            }
            if (canHandle) continue;
            return false;
        }
        return true;
    }

    private void cleanUpConnectionsOnUpdatedApns(boolean detach, String reason) {
        this.log("cleanUpConnectionsOnUpdatedApns: detach=" + detach);
        if (this.mAllApnSettings.isEmpty()) {
            this.cleanUpAllConnectionsInternal(detach, "apnChanged");
        } else {
            if (this.getDataRat() == 0) {
                return;
            }
            for (ApnContext apnContext : this.mApnContexts.values()) {
                ArrayList<ApnSetting> currentWaitingApns = apnContext.getWaitingApns();
                ArrayList<ApnSetting> waitingApns = this.buildWaitingApns(apnContext.getApnType(), this.getDataRat());
                if (currentWaitingApns == null || waitingApns.size() == currentWaitingApns.size() && this.containsAllApns(currentWaitingApns, waitingApns)) continue;
                apnContext.setWaitingApns(waitingApns);
                if (apnContext.isDisconnected()) continue;
                apnContext.setReason(reason);
                this.cleanUpConnectionInternal(true, 2, apnContext);
            }
        }
        if (!this.isConnected()) {
            this.stopNetStatPoll();
            this.stopDataStallAlarm();
        }
        this.mRequestedApnType = 17;
        this.log("mDisconnectPendingCount = " + this.mDisconnectPendingCount);
        if (detach && this.mDisconnectPendingCount == 0) {
            this.notifyAllDataDisconnected();
        }
    }

    private void resetPollStats() {
        this.mTxPkts = -1L;
        this.mRxPkts = -1L;
        this.mNetStatPollPeriod = 1000;
    }

    private void startNetStatPoll() {
        if (this.getOverallState() == DctConstants.State.CONNECTED && !this.mNetStatPollEnabled) {
            this.log("startNetStatPoll");
            this.resetPollStats();
            this.mNetStatPollEnabled = true;
            this.mPollNetStat.run();
        }
        if (this.mPhone != null) {
            this.mPhone.notifyDataActivity();
        }
    }

    private void stopNetStatPoll() {
        this.mNetStatPollEnabled = false;
        this.removeCallbacks(this.mPollNetStat);
        this.log("stopNetStatPoll");
        if (this.mPhone != null) {
            this.mPhone.notifyDataActivity();
        }
    }

    public void sendStartNetStatPoll(DctConstants.Activity activity) {
        Message msg = this.obtainMessage(270376);
        msg.arg1 = 1;
        msg.obj = activity;
        this.sendMessage(msg);
    }

    private void handleStartNetStatPoll(DctConstants.Activity activity) {
        this.startNetStatPoll();
        this.startDataStallAlarm(false);
        this.setActivity(activity);
    }

    public void sendStopNetStatPoll(DctConstants.Activity activity) {
        Message msg = this.obtainMessage(270376);
        msg.arg1 = 0;
        msg.obj = activity;
        this.sendMessage(msg);
    }

    private void handleStopNetStatPoll(DctConstants.Activity activity) {
        this.stopNetStatPoll();
        this.stopDataStallAlarm();
        this.setActivity(activity);
    }

    private void onDataEnabledOverrideRulesChanged() {
        this.log("onDataEnabledOverrideRulesChanged");
        for (ApnContext apnContext : this.mPrioritySortedApnContexts) {
            if (this.isDataAllowed(apnContext, 1, null)) {
                if (apnContext.getDataConnection() != null) {
                    apnContext.getDataConnection().reevaluateRestrictedState();
                }
                this.setupDataOnConnectableApn(apnContext, "dataEnabledOverride", RetryFailures.ALWAYS);
                continue;
            }
            if (!this.shouldCleanUpConnection(apnContext, true)) continue;
            apnContext.setReason("dataEnabledOverride");
            this.cleanUpConnectionInternal(true, 2, apnContext);
        }
    }

    private void updateDataActivity() {
        TxRxSum preTxRxSum = new TxRxSum(this.mTxPkts, this.mRxPkts);
        TxRxSum curTxRxSum = new TxRxSum();
        curTxRxSum.updateTotalTxRxSum();
        this.mTxPkts = curTxRxSum.txPkts;
        this.mRxPkts = curTxRxSum.rxPkts;
        if (this.mNetStatPollEnabled && (preTxRxSum.txPkts > 0L || preTxRxSum.rxPkts > 0L)) {
            DctConstants.Activity newActivity;
            long sent = this.mTxPkts - preTxRxSum.txPkts;
            long received = this.mRxPkts - preTxRxSum.rxPkts;
            if (sent > 0L && received > 0L) {
                newActivity = DctConstants.Activity.DATAINANDOUT;
            } else if (sent > 0L && received == 0L) {
                newActivity = DctConstants.Activity.DATAOUT;
            } else if (sent == 0L && received > 0L) {
                newActivity = DctConstants.Activity.DATAIN;
            } else {
                DctConstants.Activity activity = newActivity = this.mActivity == DctConstants.Activity.DORMANT ? this.mActivity : DctConstants.Activity.NONE;
            }
            if (this.mActivity != newActivity && this.mIsScreenOn) {
                this.mActivity = newActivity;
                this.mPhone.notifyDataActivity();
            }
        }
    }

    private void handlePcoData(AsyncResult ar) {
        List<ApnContext> apnContextList;
        DataConnection dc2;
        if (ar.exception != null) {
            this.loge("PCO_DATA exception: " + ar.exception);
            return;
        }
        PcoData pcoData = (PcoData)ar.result;
        ArrayList<DataConnection> dcList = new ArrayList<DataConnection>();
        DataConnection temp = this.mDcc.getActiveDcByCid(pcoData.cid);
        if (temp != null) {
            dcList.add(temp);
        }
        if (dcList.size() == 0) {
            this.loge("PCO_DATA for unknown cid: " + pcoData.cid + ", inferring");
            block0: for (DataConnection dc2 : this.mDataConnections.values()) {
                int cid = dc2.getCid();
                if (cid == pcoData.cid) {
                    dcList.clear();
                    dcList.add(dc2);
                    break;
                }
                if (cid != -1) continue;
                for (ApnContext apnContext : dc2.getApnContexts()) {
                    if (apnContext.getState() != DctConstants.State.CONNECTING) continue;
                    dcList.add(dc2);
                    continue block0;
                }
            }
        }
        if (dcList.size() == 0) {
            this.loge("PCO_DATA - couldn't infer cid");
            return;
        }
        Iterator<Object> iterator = dcList.iterator();
        while (iterator.hasNext() && (apnContextList = (dc2 = (DataConnection)iterator.next()).getApnContexts()).size() != 0) {
            for (ApnContext apnContext : apnContextList) {
                String apnType = apnContext.getApnType();
                Intent intent = new Intent("com.android.internal.telephony.CARRIER_SIGNAL_PCO_VALUE");
                intent.putExtra("apnType", apnType);
                intent.putExtra("apnProto", pcoData.bearerProto);
                intent.putExtra("pcoId", pcoData.pcoId);
                intent.putExtra("pcoValue", pcoData.contents);
                this.mPhone.getCarrierSignalAgent().notifyCarrierSignalReceivers(intent);
            }
        }
    }

    private void updateDataStallInfo() {
        TxRxSum preTxRxSum = new TxRxSum(this.mDataStallTxRxSum);
        this.mDataStallTxRxSum.updateTcpTxRxSum();
        long sent = this.mDataStallTxRxSum.txPkts - preTxRxSum.txPkts;
        long received = this.mDataStallTxRxSum.rxPkts - preTxRxSum.rxPkts;
        if (sent > 0L && received > 0L) {
            this.mSentSinceLastRecv = 0L;
            this.mDsRecoveryHandler.reset();
        } else if (sent > 0L && received == 0L) {
            this.mSentSinceLastRecv = this.isPhoneStateIdle() ? (this.mSentSinceLastRecv += sent) : 0L;
            this.log("updateDataStallInfo: OUT sent=" + sent + " mSentSinceLastRecv=" + this.mSentSinceLastRecv);
        } else if (sent == 0L && received > 0L) {
            this.mSentSinceLastRecv = 0L;
            this.mDsRecoveryHandler.reset();
        }
    }

    private boolean isPhoneStateIdle() {
        for (int i = 0; i < this.mTelephonyManager.getPhoneCount(); ++i) {
            Phone phone = PhoneFactory.getPhone(i);
            if (phone == null || phone.getState() == PhoneConstants.State.IDLE) continue;
            this.log("isPhoneStateIdle false: Voice call active on phone " + i);
            return false;
        }
        return true;
    }

    private void onDataStallAlarm(int tag) {
        if (this.mDataStallAlarmTag != tag) {
            this.log("onDataStallAlarm: ignore, tag=" + tag + " expecting " + this.mDataStallAlarmTag);
            return;
        }
        this.log("Data stall alarm");
        this.updateDataStallInfo();
        int hangWatchdogTrigger = Settings.Global.getInt(this.mResolver, "pdp_watchdog_trigger_packet_count", 10);
        boolean suspectedStall = false;
        if (this.mSentSinceLastRecv >= (long)hangWatchdogTrigger) {
            this.log("onDataStallAlarm: tag=" + tag + " do recovery action=" + this.mDsRecoveryHandler.getRecoveryAction());
            suspectedStall = true;
            this.sendMessage(this.obtainMessage(270354));
        }
        this.startDataStallAlarm(suspectedStall);
    }

    private void startDataStallAlarm(boolean suspectedStall) {
        if (this.mDsRecoveryHandler.isNoRxDataStallDetectionEnabled() && this.getOverallState() == DctConstants.State.CONNECTED) {
            int delayInMs = this.mIsScreenOn || suspectedStall || this.mDsRecoveryHandler.isAggressiveRecovery() ? Settings.Global.getInt(this.mResolver, "data_stall_alarm_aggressive_delay_in_ms", 60000) : Settings.Global.getInt(this.mResolver, "data_stall_alarm_non_aggressive_delay_in_ms", 360000);
            ++this.mDataStallAlarmTag;
            Intent intent = new Intent(INTENT_DATA_STALL_ALARM);
            intent.putExtra(INTENT_DATA_STALL_ALARM_EXTRA_TAG, this.mDataStallAlarmTag);
            intent.putExtra(INTENT_DATA_STALL_ALARM_EXTRA_TRANSPORT_TYPE, this.mTransportType);
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
            this.mDataStallAlarmIntent = PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
            this.mAlarmManager.set(3, SystemClock.elapsedRealtime() + (long)delayInMs, this.mDataStallAlarmIntent);
        }
    }

    private void stopDataStallAlarm() {
        ++this.mDataStallAlarmTag;
        if (this.mDataStallAlarmIntent != null) {
            this.mAlarmManager.cancel(this.mDataStallAlarmIntent);
            this.mDataStallAlarmIntent = null;
        }
    }

    private void restartDataStallAlarm() {
        if (!this.isConnected()) {
            return;
        }
        if (this.mDsRecoveryHandler.isAggressiveRecovery()) {
            this.log("restartDataStallAlarm: action is pending. not resetting the alarm.");
            return;
        }
        this.stopDataStallAlarm();
        this.startDataStallAlarm(false);
    }

    private void onActionIntentProvisioningApnAlarm(Intent intent) {
        this.log("onActionIntentProvisioningApnAlarm: action=" + intent.getAction());
        Message msg = this.obtainMessage(270375, intent.getAction());
        msg.arg1 = intent.getIntExtra(PROVISIONING_APN_ALARM_TAG_EXTRA, 0);
        this.sendMessage(msg);
    }

    private void startProvisioningApnAlarm() {
        int delayInMs = Settings.Global.getInt(this.mResolver, "provisioning_apn_alarm_delay_in_ms", 900000);
        if (Build.IS_DEBUGGABLE) {
            String delayInMsStrg = Integer.toString(delayInMs);
            delayInMsStrg = System.getProperty(DEBUG_PROV_APN_ALARM, delayInMsStrg);
            try {
                delayInMs = Integer.parseInt(delayInMsStrg);
            }
            catch (NumberFormatException e) {
                this.loge("startProvisioningApnAlarm: e=" + e);
            }
        }
        ++this.mProvisioningApnAlarmTag;
        this.log("startProvisioningApnAlarm: tag=" + this.mProvisioningApnAlarmTag + " delay=" + delayInMs / 1000 + "s");
        Intent intent = new Intent(INTENT_PROVISIONING_APN_ALARM);
        intent.putExtra(PROVISIONING_APN_ALARM_TAG_EXTRA, this.mProvisioningApnAlarmTag);
        this.mProvisioningApnAlarmIntent = PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
        this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + (long)delayInMs, this.mProvisioningApnAlarmIntent);
    }

    private void stopProvisioningApnAlarm() {
        this.log("stopProvisioningApnAlarm: current tag=" + this.mProvisioningApnAlarmTag + " mProvsioningApnAlarmIntent=" + this.mProvisioningApnAlarmIntent);
        ++this.mProvisioningApnAlarmTag;
        if (this.mProvisioningApnAlarmIntent != null) {
            this.mAlarmManager.cancel(this.mProvisioningApnAlarmIntent);
            this.mProvisioningApnAlarmIntent = null;
        }
    }

    private static DataProfile createDataProfile(ApnSetting apn, boolean isPreferred) {
        return DcTracker.createDataProfile(apn, apn.getProfileId(), isPreferred);
    }

    @VisibleForTesting
    public static DataProfile createDataProfile(ApnSetting apn, int profileId, boolean isPreferred) {
        int networkTypeBitmask = apn.getNetworkTypeBitmask();
        int profileType = networkTypeBitmask == 0 ? 0 : (ServiceState.bearerBitmapHasCdma(networkTypeBitmask) ? 2 : 1);
        return new DataProfile.Builder().setProfileId(profileId).setApn(apn.getApnName()).setProtocolType(apn.getProtocol()).setAuthType(apn.getAuthType()).setUserName(apn.getUser()).setPassword(apn.getPassword()).setType(profileType).setMaxConnectionsTime(apn.getMaxConnsTime()).setMaxConnections(apn.getMaxConns()).setWaitTime(apn.getWaitTime()).enable(apn.isEnabled()).setSupportedApnTypesBitmask(apn.getApnTypeBitmask()).setRoamingProtocolType(apn.getRoamingProtocol()).setBearerBitmask(networkTypeBitmask).setMtu(apn.getMtu()).setPersistent(apn.isPersistent()).setPreferred(isPreferred).build();
    }

    private void onDataServiceBindingChanged(boolean bound) {
        if (bound) {
            this.mDcc.start();
        } else {
            this.mDcc.dispose();
        }
        this.mDataServiceBound = bound;
    }

    public static String requestTypeToString(int type) {
        switch (type) {
            case 1: {
                return "NORMAL";
            }
            case 2: {
                return "HANDOVER";
            }
        }
        return "UNKNOWN";
    }

    public static String releaseTypeToString(int type) {
        switch (type) {
            case 1: {
                return "NORMAL";
            }
            case 2: {
                return "DETACH";
            }
            case 3: {
                return "HANDOVER";
            }
        }
        return "UNKNOWN";
    }

    private int getDataRat() {
        ServiceState ss = this.mPhone.getServiceState();
        NetworkRegistrationInfo nrs = ss.getNetworkRegistrationInfo(2, this.mTransportType);
        if (nrs != null) {
            return ServiceState.networkTypeToRilRadioTechnology(nrs.getAccessNetworkTechnology());
        }
        return 0;
    }

    private int getVoiceRat() {
        ServiceState ss = this.mPhone.getServiceState();
        NetworkRegistrationInfo nrs = ss.getNetworkRegistrationInfo(1, this.mTransportType);
        if (nrs != null) {
            return ServiceState.networkTypeToRilRadioTechnology(nrs.getAccessNetworkTechnology());
        }
        return 0;
    }

    private class DataStallRecoveryHandler {
        private static final int DEFAULT_MIN_DURATION_BETWEEN_RECOVERY_STEPS_IN_MS = 180000;
        private long mTimeLastRecoveryStartMs;
        private boolean mIsValidNetwork;

        public DataStallRecoveryHandler() {
            this.reset();
        }

        public void reset() {
            this.mTimeLastRecoveryStartMs = 0L;
            this.putRecoveryAction(0);
        }

        public boolean isAggressiveRecovery() {
            int action = this.getRecoveryAction();
            return action == 1 || action == 2 || action == 3;
        }

        private long getMinDurationBetweenRecovery() {
            return Settings.Global.getLong(DcTracker.this.mResolver, "min_duration_between_recovery_steps", 180000L);
        }

        private long getElapsedTimeSinceRecoveryMs() {
            return SystemClock.elapsedRealtime() - this.mTimeLastRecoveryStartMs;
        }

        private int getRecoveryAction() {
            int action = Settings.System.getInt(DcTracker.this.mResolver, "radio.data.stall.recovery.action", 0);
            return action;
        }

        private void putRecoveryAction(int action) {
            Settings.System.putInt(DcTracker.this.mResolver, "radio.data.stall.recovery.action", action);
        }

        private void broadcastDataStallDetected(int recoveryAction) {
            Intent intent = new Intent("android.intent.action.DATA_STALL_DETECTED");
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, DcTracker.this.mPhone.getPhoneId());
            intent.putExtra("recoveryAction", recoveryAction);
            DcTracker.this.mPhone.getContext().sendBroadcast(intent, "android.permission.READ_PRIVILEGED_PHONE_STATE");
        }

        private boolean isRecoveryAlreadyStarted() {
            return this.getRecoveryAction() != 0;
        }

        private boolean checkRecovery() {
            if (this.getElapsedTimeSinceRecoveryMs() < this.getMinDurationBetweenRecovery()) {
                return false;
            }
            return DcTracker.this.mAttached.get() && DcTracker.this.isDataAllowed(null);
        }

        private void triggerRecovery() {
            DcTracker.this.sendMessage(DcTracker.this.obtainMessage(270354));
        }

        public void doRecovery() {
            if (DcTracker.this.getOverallState() == DctConstants.State.CONNECTED) {
                int recoveryAction = this.getRecoveryAction();
                TelephonyMetrics.getInstance().writeDataStallEvent(DcTracker.this.mPhone.getPhoneId(), recoveryAction);
                this.broadcastDataStallDetected(recoveryAction);
                switch (recoveryAction) {
                    case 0: {
                        EventLog.writeEvent(50118, DcTracker.this.mSentSinceLastRecv);
                        DcTracker.this.log("doRecovery() get data call list");
                        DcTracker.this.mDataServiceManager.requestDataCallList(DcTracker.this.obtainMessage());
                        this.putRecoveryAction(1);
                        break;
                    }
                    case 1: {
                        EventLog.writeEvent(50119, DcTracker.this.mSentSinceLastRecv);
                        DcTracker.this.log("doRecovery() cleanup all connections");
                        DcTracker.this.cleanUpConnection((ApnContext)DcTracker.this.mApnContexts.get(ApnSetting.getApnTypeString(17)));
                        this.putRecoveryAction(2);
                        break;
                    }
                    case 2: {
                        EventLog.writeEvent(50120, DcTracker.this.mSentSinceLastRecv);
                        DcTracker.this.log("doRecovery() re-register");
                        DcTracker.this.mPhone.getServiceStateTracker().reRegisterNetwork(null);
                        this.putRecoveryAction(3);
                        break;
                    }
                    case 3: {
                        EventLog.writeEvent(50121, DcTracker.this.mSentSinceLastRecv);
                        DcTracker.this.log("restarting radio");
                        DcTracker.this.restartRadio();
                        this.reset();
                        break;
                    }
                    default: {
                        throw new RuntimeException("doRecovery: Invalid recoveryAction=" + recoveryAction);
                    }
                }
                DcTracker.this.mSentSinceLastRecv = 0L;
                this.mTimeLastRecoveryStartMs = SystemClock.elapsedRealtime();
            }
        }

        public void processNetworkStatusChanged(boolean isValid) {
            if (isValid) {
                this.mIsValidNetwork = true;
                this.reset();
            } else if (this.mIsValidNetwork || this.isRecoveryAlreadyStarted()) {
                this.mIsValidNetwork = false;
                if (this.checkRecovery()) {
                    DcTracker.this.log("trigger data stall recovery");
                    this.triggerRecovery();
                }
            }
        }

        public boolean isRecoveryOnBadNetworkEnabled() {
            return Settings.Global.getInt(DcTracker.this.mResolver, "data_stall_recovery_on_bad_network", 1) == 1;
        }

        public boolean isNoRxDataStallDetectionEnabled() {
            return DcTracker.this.mDataStallNoRxEnabled && !this.isRecoveryOnBadNetworkEnabled();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface RecoveryAction {
    }

    private static enum RetryFailures {
        ALWAYS,
        ONLY_ON_CHANGE;

    }

    private class ProvisionNotificationBroadcastReceiver
    extends BroadcastReceiver {
        private final String mNetworkOperator;
        private final String mProvisionUrl;

        public ProvisionNotificationBroadcastReceiver(String provisionUrl, String networkOperator) {
            this.mNetworkOperator = networkOperator;
            this.mProvisionUrl = provisionUrl;
        }

        private void setEnableFailFastMobileData(int enabled) {
            DcTracker.this.sendMessage(DcTracker.this.obtainMessage(270372, enabled, 0));
        }

        private void enableMobileProvisioning() {
            Message msg = DcTracker.this.obtainMessage(270373);
            msg.setData(Bundle.forPair("provisioningUrl", this.mProvisionUrl));
            DcTracker.this.sendMessage(msg);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            DcTracker.this.log("onReceive : ProvisionNotificationBroadcastReceiver");
            DcTracker.this.mProvisioningSpinner = new ProgressDialog(context);
            DcTracker.this.mProvisioningSpinner.setTitle(this.mNetworkOperator);
            DcTracker.this.mProvisioningSpinner.setMessage(context.getText(17040314));
            DcTracker.this.mProvisioningSpinner.setIndeterminate(true);
            DcTracker.this.mProvisioningSpinner.setCancelable(true);
            DcTracker.this.mProvisioningSpinner.getWindow().setType(2009);
            DcTracker.this.mProvisioningSpinner.show();
            DcTracker.this.sendMessageDelayed(DcTracker.this.obtainMessage(270378, DcTracker.this.mProvisioningSpinner), 120000L);
            DcTracker.this.setRadio(true);
            this.setEnableFailFastMobileData(1);
            this.enableMobileProvisioning();
        }
    }

    private class ApnChangeObserver
    extends ContentObserver {
        public ApnChangeObserver() {
            super(DcTracker.this.mDataConnectionTracker);
        }

        @Override
        public void onChange(boolean selfChange) {
            DcTracker.this.sendMessage(DcTracker.this.obtainMessage(270355));
        }
    }

    public static class TxRxSum {
        public long txPkts;
        public long rxPkts;

        public TxRxSum() {
            this.reset();
        }

        public TxRxSum(long txPkts, long rxPkts) {
            this.txPkts = txPkts;
            this.rxPkts = rxPkts;
        }

        public TxRxSum(TxRxSum sum) {
            this.txPkts = sum.txPkts;
            this.rxPkts = sum.rxPkts;
        }

        public void reset() {
            this.txPkts = -1L;
            this.rxPkts = -1L;
        }

        public String toString() {
            return "{txSum=" + this.txPkts + " rxSum=" + this.rxPkts + "}";
        }

        public void updateTcpTxRxSum() {
            this.txPkts = TrafficStats.getMobileTcpTxPackets();
            this.rxPkts = TrafficStats.getMobileTcpRxPackets();
        }

        public void updateTotalTxRxSum() {
            this.txPkts = TrafficStats.getMobileTxPackets();
            this.rxPkts = TrafficStats.getMobileRxPackets();
        }
    }

    private class DctOnSubscriptionsChangedListener
    extends SubscriptionManager.OnSubscriptionsChangedListener {
        public final AtomicInteger mPreviousSubId = new AtomicInteger(-1);

        private DctOnSubscriptionsChangedListener() {
        }

        @Override
        public void onSubscriptionsChanged() {
            DcTracker.this.log("SubscriptionListener.onSubscriptionInfoChanged");
            int subId = DcTracker.this.mPhone.getSubId();
            if (SubscriptionManager.isValidSubscriptionId(subId)) {
                DcTracker.this.registerSettingsObserver();
            }
            if (SubscriptionManager.isValidSubscriptionId(subId) && this.mPreviousSubId.getAndSet(subId) != subId) {
                DcTracker.this.onRecordsLoadedOrSubIdChanged();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ReleaseNetworkType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestNetworkType {
    }
}

