/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.net.NetworkCapabilities;
import android.net.NetworkFactory;
import android.net.NetworkRequest;
import android.net.StringNetworkSpecifier;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.AccessNetworkConstants;
import android.telephony.Rlog;
import android.telephony.data.ApnSetting;
import android.util.LocalLog;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneSwitcher;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.SubscriptionMonitor;
import com.android.internal.telephony.dataconnection.ApnContext;
import com.android.internal.telephony.dataconnection.DataConnection;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.dataconnection.TransportManager;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class TelephonyNetworkFactory
extends NetworkFactory {
    public final String LOG_TAG;
    protected static final boolean DBG = true;
    private static final int REQUEST_LOG_SIZE = 40;
    private static final int ACTION_NO_OP = 0;
    private static final int ACTION_REQUEST = 1;
    private static final int ACTION_RELEASE = 2;
    private static final int TELEPHONY_NETWORK_SCORE = 50;
    private static final int EVENT_ACTIVE_PHONE_SWITCH = 1;
    private static final int EVENT_SUBSCRIPTION_CHANGED = 2;
    private static final int EVENT_NETWORK_REQUEST = 3;
    private static final int EVENT_NETWORK_RELEASE = 4;
    private static final int EVENT_DATA_HANDOVER_NEEDED = 5;
    private static final int EVENT_DATA_HANDOVER_COMPLETED = 6;
    private final PhoneSwitcher mPhoneSwitcher;
    private final SubscriptionController mSubscriptionController;
    private final SubscriptionMonitor mSubscriptionMonitor;
    private final LocalLog mLocalLog = new LocalLog(40);
    private final Map<NetworkRequest, Integer> mNetworkRequests = new HashMap<NetworkRequest, Integer>();
    private final Map<Message, TransportManager.HandoverParams> mPendingHandovers = new HashMap<Message, TransportManager.HandoverParams>();
    private final Phone mPhone;
    private final TransportManager mTransportManager;
    private int mSubscriptionId;
    private final Handler mInternalHandler;

    public TelephonyNetworkFactory(SubscriptionMonitor subscriptionMonitor, Looper looper, Phone phone) {
        super(looper, phone.getContext(), "TelephonyNetworkFactory[" + phone.getPhoneId() + "]", null);
        this.mPhone = phone;
        this.mTransportManager = this.mPhone.getTransportManager();
        this.mInternalHandler = new InternalHandler(looper);
        this.mSubscriptionController = SubscriptionController.getInstance();
        this.setCapabilityFilter(this.makeNetworkFilter(this.mSubscriptionController, this.mPhone.getPhoneId()));
        this.setScoreFilter(50);
        this.mPhoneSwitcher = PhoneSwitcher.getInstance();
        this.mSubscriptionMonitor = subscriptionMonitor;
        this.LOG_TAG = "TelephonyNetworkFactory[" + this.mPhone.getPhoneId() + "]";
        this.mPhoneSwitcher.registerForActivePhoneSwitch(this.mInternalHandler, 1, null);
        this.mTransportManager.registerForHandoverNeededEvent(this.mInternalHandler, 5);
        this.mSubscriptionId = -1;
        this.mSubscriptionMonitor.registerForSubscriptionChanged(this.mPhone.getPhoneId(), this.mInternalHandler, 2, null);
        this.register();
    }

    private NetworkCapabilities makeNetworkFilter(SubscriptionController subscriptionController, int phoneId) {
        int subscriptionId = subscriptionController.getSubIdUsingPhoneId(phoneId);
        return this.makeNetworkFilter(subscriptionId);
    }

    private NetworkCapabilities makeNetworkFilter(int subscriptionId) {
        NetworkCapabilities nc = new NetworkCapabilities();
        nc.addTransportType(0);
        nc.addCapability(0);
        nc.addCapability(1);
        nc.addCapability(2);
        nc.addCapability(3);
        nc.addCapability(4);
        nc.addCapability(5);
        nc.addCapability(7);
        nc.addCapability(8);
        nc.addCapability(9);
        nc.addCapability(10);
        nc.addCapability(13);
        nc.addCapability(12);
        nc.setNetworkSpecifier(new StringNetworkSpecifier(String.valueOf(subscriptionId)));
        return nc;
    }

    private int getTransportTypeFromNetworkRequest(NetworkRequest networkRequest) {
        int apnType = ApnContext.getApnTypeFromNetworkRequest(networkRequest);
        return this.mTransportManager.getCurrentTransport(apnType);
    }

    private void requestNetworkInternal(NetworkRequest networkRequest, int requestType, int transport, Message onCompleteMsg) {
        if (this.mPhone.getDcTracker(transport) != null) {
            this.mPhone.getDcTracker(transport).requestNetwork(networkRequest, requestType, onCompleteMsg);
        }
    }

    private void releaseNetworkInternal(NetworkRequest networkRequest, int releaseType, int transport) {
        if (this.mPhone.getDcTracker(transport) != null) {
            this.mPhone.getDcTracker(transport).releaseNetwork(networkRequest, releaseType);
        }
    }

    private static int getAction(boolean wasActive, boolean isActive) {
        if (!wasActive && isActive) {
            return 1;
        }
        if (wasActive && !isActive) {
            return 2;
        }
        return 0;
    }

    private void onActivePhoneSwitch() {
        for (Map.Entry<NetworkRequest, Integer> entry : this.mNetworkRequests.entrySet()) {
            boolean shouldApply;
            NetworkRequest networkRequest = entry.getKey();
            boolean applied = entry.getValue() != -1;
            int action = TelephonyNetworkFactory.getAction(applied, shouldApply = this.mPhoneSwitcher.shouldApplyNetworkRequest(networkRequest, this.mPhone.getPhoneId()));
            if (action == 0) continue;
            this.logl("onActivePhoneSwitch: " + (action == 1 ? "Requesting" : "Releasing") + " network request " + networkRequest);
            int transportType = this.getTransportTypeFromNetworkRequest(networkRequest);
            if (action == 1) {
                this.requestNetworkInternal(networkRequest, 1, this.getTransportTypeFromNetworkRequest(networkRequest), null);
            } else if (action == 2) {
                this.releaseNetworkInternal(networkRequest, 2, this.getTransportTypeFromNetworkRequest(networkRequest));
            }
            this.mNetworkRequests.put(networkRequest, shouldApply ? transportType : -1);
        }
    }

    private void onSubIdChange() {
        int newSubscriptionId = this.mSubscriptionController.getSubIdUsingPhoneId(this.mPhone.getPhoneId());
        if (this.mSubscriptionId != newSubscriptionId) {
            this.log("onSubIdChange " + this.mSubscriptionId + "->" + newSubscriptionId);
            this.mSubscriptionId = newSubscriptionId;
            this.setCapabilityFilter(this.makeNetworkFilter(this.mSubscriptionId));
        }
    }

    @Override
    public void needNetworkFor(NetworkRequest networkRequest, int score) {
        Message msg = this.mInternalHandler.obtainMessage(3);
        msg.obj = networkRequest;
        msg.sendToTarget();
    }

    private void onNeedNetworkFor(Message msg) {
        NetworkRequest networkRequest;
        boolean shouldApply = this.mPhoneSwitcher.shouldApplyNetworkRequest(networkRequest = (NetworkRequest)msg.obj, this.mPhone.getPhoneId());
        this.mNetworkRequests.put(networkRequest, shouldApply ? this.getTransportTypeFromNetworkRequest(networkRequest) : -1);
        this.logl("onNeedNetworkFor " + networkRequest + " shouldApply " + shouldApply);
        if (shouldApply) {
            this.requestNetworkInternal(networkRequest, 1, this.getTransportTypeFromNetworkRequest(networkRequest), null);
        }
    }

    @Override
    public void releaseNetworkFor(NetworkRequest networkRequest) {
        Message msg = this.mInternalHandler.obtainMessage(4);
        msg.obj = networkRequest;
        msg.sendToTarget();
    }

    private void onReleaseNetworkFor(Message msg) {
        NetworkRequest networkRequest = (NetworkRequest)msg.obj;
        boolean applied = this.mNetworkRequests.get(networkRequest) != -1;
        this.mNetworkRequests.remove(networkRequest);
        this.logl("onReleaseNetworkFor " + networkRequest + " applied " + applied);
        if (applied) {
            int transport = this.getTransportTypeFromNetworkRequest(networkRequest);
            this.releaseNetworkInternal(networkRequest, 1, transport);
        }
    }

    private void onDataHandoverNeeded(int apnType, int targetTransport, TransportManager.HandoverParams handoverParams) {
        this.log("onDataHandoverNeeded: apnType=" + ApnSetting.getApnTypeString(apnType) + ", target transport=" + AccessNetworkConstants.transportTypeToString(targetTransport));
        if (this.mTransportManager.getCurrentTransport(apnType) == targetTransport) {
            this.log("APN type " + ApnSetting.getApnTypeString(apnType) + " is already on " + AccessNetworkConstants.transportTypeToString(targetTransport));
            return;
        }
        boolean handoverPending = false;
        for (Map.Entry<NetworkRequest, Integer> entry : this.mNetworkRequests.entrySet()) {
            boolean applied;
            NetworkRequest networkRequest = entry.getKey();
            int currentTransport = entry.getValue();
            boolean bl = applied = currentTransport != -1;
            if (ApnContext.getApnTypeFromNetworkRequest(networkRequest) != apnType || !applied || currentTransport == targetTransport) continue;
            DcTracker dcTracker = this.mPhone.getDcTracker(currentTransport);
            if (dcTracker != null) {
                DataConnection dc = dcTracker.getDataConnectionByApnType(ApnSetting.getApnTypeString(apnType));
                if (dc != null && (dc.isActive() || dc.isActivating())) {
                    Message onCompleteMsg = this.mInternalHandler.obtainMessage(6);
                    onCompleteMsg.getData().putParcelable("extra_network_request", networkRequest);
                    this.mPendingHandovers.put(onCompleteMsg, handoverParams);
                    this.requestNetworkInternal(networkRequest, 2, targetTransport, onCompleteMsg);
                    handoverPending = true;
                    continue;
                }
                this.log("The network request is on transport " + AccessNetworkConstants.transportTypeToString(currentTransport) + ", but no live data connection. Just move the request to transport " + AccessNetworkConstants.transportTypeToString(targetTransport) + ", dc=" + dc);
                this.releaseNetworkInternal(networkRequest, 1, currentTransport);
                this.requestNetworkInternal(networkRequest, 1, targetTransport, null);
                continue;
            }
            this.log("DcTracker on " + AccessNetworkConstants.transportTypeToString(currentTransport) + " is not available.");
        }
        if (!handoverPending) {
            this.log("No handover request pending. Handover process is now completed");
            handoverParams.callback.onCompleted(true);
        }
    }

    private void onDataHandoverSetupCompleted(NetworkRequest networkRequest, boolean success, int targetTransport, TransportManager.HandoverParams handoverParams) {
        this.log("onDataHandoverSetupCompleted: " + networkRequest + ", success=" + success + ", targetTransport=" + AccessNetworkConstants.transportTypeToString(targetTransport));
        int originTransport = targetTransport == 1 ? 2 : 1;
        int releaseType = success ? 3 : 1;
        this.releaseNetworkInternal(networkRequest, releaseType, originTransport);
        this.mNetworkRequests.put(networkRequest, targetTransport);
        handoverParams.callback.onCompleted(success);
    }

    @Override
    protected void log(String s) {
        Rlog.d(this.LOG_TAG, s);
    }

    protected void logl(String s) {
        this.log(s);
        this.mLocalLog.log(s);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println("Network Requests:");
        pw.increaseIndent();
        for (Map.Entry<NetworkRequest, Integer> entry : this.mNetworkRequests.entrySet()) {
            NetworkRequest nr = entry.getKey();
            int transport = entry.getValue();
            pw.println(nr + (transport != -1 ? " applied on " + transport : " not applied"));
        }
        this.mLocalLog.dump(fd, pw, args);
        pw.decreaseIndent();
    }

    private class InternalHandler
    extends Handler {
        public InternalHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    TelephonyNetworkFactory.this.onActivePhoneSwitch();
                    break;
                }
                case 2: {
                    TelephonyNetworkFactory.this.onSubIdChange();
                    break;
                }
                case 3: {
                    TelephonyNetworkFactory.this.onNeedNetworkFor(msg);
                    break;
                }
                case 4: {
                    TelephonyNetworkFactory.this.onReleaseNetworkFor(msg);
                    break;
                }
                case 5: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    TransportManager.HandoverParams handoverParams = (TransportManager.HandoverParams)ar.result;
                    TelephonyNetworkFactory.this.onDataHandoverNeeded(handoverParams.apnType, handoverParams.targetTransport, handoverParams);
                    break;
                }
                case 6: {
                    Bundle bundle = msg.getData();
                    int requestType = bundle.getInt("extra_request_type");
                    if (requestType != 2) break;
                    NetworkRequest nr = (NetworkRequest)bundle.getParcelable("extra_network_request");
                    boolean success = bundle.getBoolean("extra_success");
                    int transport = bundle.getInt("extra_transport_type");
                    TransportManager.HandoverParams handoverParams = (TransportManager.HandoverParams)TelephonyNetworkFactory.this.mPendingHandovers.remove(msg);
                    if (handoverParams != null) {
                        TelephonyNetworkFactory.this.onDataHandoverSetupCompleted(nr, success, transport, handoverParams);
                        break;
                    }
                    TelephonyNetworkFactory.this.logl("Handover completed but cannot find handover entry!");
                    break;
                }
            }
        }
    }
}

