/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.AccessNetworkConstants;
import android.telephony.Rlog;
import android.telephony.data.ApnSetting;
import android.util.LocalLog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.dataconnection.AccessNetworksManager;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class TransportManager
extends Handler {
    private static final String TAG = TransportManager.class.getSimpleName();
    private static final Map<Integer, Integer> ACCESS_NETWORK_TRANSPORT_TYPE_MAP = new HashMap<Integer, Integer>();
    private static final int EVENT_QUALIFIED_NETWORKS_CHANGED = 1;
    private static final int EVENT_UPDATE_AVAILABLE_NETWORKS = 2;
    public static final String SYSTEM_PROPERTIES_IWLAN_OPERATION_MODE = "ro.telephony.iwlan_operation_mode";
    public static final String IWLAN_OPERATION_MODE_DEFAULT = "default";
    public static final String IWLAN_OPERATION_MODE_LEGACY = "legacy";
    public static final String IWLAN_OPERATION_MODE_AP_ASSISTED = "AP-assisted";
    private final Phone mPhone;
    private final LocalLog mLocalLog = new LocalLog(100);
    private final int[] mAvailableTransports;
    private AccessNetworksManager mAccessNetworksManager;
    private final SparseArray<int[]> mCurrentAvailableNetworks;
    private final LinkedList<List<AccessNetworksManager.QualifiedNetworks>> mAvailableNetworksList;
    private final Map<Integer, Integer> mCurrentTransports;
    private final SparseIntArray mPendingHandoverApns;
    private final RegistrantList mHandoverNeededEventRegistrants;

    public TransportManager(Phone phone) {
        this.mPhone = phone;
        this.mCurrentAvailableNetworks = new SparseArray();
        this.mCurrentTransports = new ConcurrentHashMap<Integer, Integer>();
        this.mPendingHandoverApns = new SparseIntArray();
        this.mHandoverNeededEventRegistrants = new RegistrantList();
        this.mAvailableNetworksList = new LinkedList();
        if (this.isInLegacyMode()) {
            this.log("operates in legacy mode.");
            this.mAvailableTransports = new int[]{1};
        } else {
            this.log("operates in AP-assisted mode.");
            this.mAccessNetworksManager = new AccessNetworksManager(phone);
            this.mAccessNetworksManager.registerForQualifiedNetworksChanged(this, 1);
            this.mAvailableTransports = new int[]{1, 2};
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                List networks = (List)ar.result;
                this.mAvailableNetworksList.add(networks);
                this.sendEmptyMessage(2);
                break;
            }
            case 2: {
                this.updateAvailableNetworks();
                break;
            }
            default: {
                this.loge("Unexpected event " + msg.what);
            }
        }
    }

    private boolean isHandoverNeeded(AccessNetworksManager.QualifiedNetworks newNetworks) {
        int apnType = newNetworks.apnType;
        int[] newNetworkList = newNetworks.qualifiedNetworks;
        int[] currentNetworkList = this.mCurrentAvailableNetworks.get(apnType);
        if (ArrayUtils.isEmpty(currentNetworkList) && ACCESS_NETWORK_TRANSPORT_TYPE_MAP.get(newNetworkList[0]) == 2) {
            return true;
        }
        if (ArrayUtils.isEmpty(newNetworkList) || ArrayUtils.isEmpty(currentNetworkList)) {
            return false;
        }
        if (this.mPendingHandoverApns.get(newNetworks.apnType) == ACCESS_NETWORK_TRANSPORT_TYPE_MAP.get(newNetworkList[0]).intValue()) {
            this.log("Handover not needed. There is already an ongoing handover.");
            return false;
        }
        return !ACCESS_NETWORK_TRANSPORT_TYPE_MAP.get(newNetworkList[0]).equals(this.getCurrentTransport(newNetworks.apnType));
    }

    private static boolean areNetworksValid(AccessNetworksManager.QualifiedNetworks networks) {
        if (networks.qualifiedNetworks == null) {
            return false;
        }
        for (int network : networks.qualifiedNetworks) {
            if (ACCESS_NETWORK_TRANSPORT_TYPE_MAP.containsKey(network)) continue;
            return false;
        }
        return true;
    }

    private synchronized void setCurrentTransport(int apnType, int transport) {
        this.mCurrentTransports.put(apnType, transport);
        this.logl("setCurrentTransport: apnType=" + ApnSetting.getApnTypeString(apnType) + ", transport=" + AccessNetworkConstants.transportTypeToString(transport));
    }

    private boolean isHandoverPending() {
        return this.mPendingHandoverApns.size() > 0;
    }

    private void updateAvailableNetworks() {
        if (this.isHandoverPending()) {
            this.log("There's ongoing handover. Will update networks once handover completed.");
            return;
        }
        if (this.mAvailableNetworksList.size() == 0) {
            this.log("Nothing in the available network list queue.");
            return;
        }
        List<AccessNetworksManager.QualifiedNetworks> networksList = this.mAvailableNetworksList.remove();
        this.logl("updateAvailableNetworks: " + networksList);
        for (AccessNetworksManager.QualifiedNetworks networks : networksList) {
            if (TransportManager.areNetworksValid(networks)) {
                if (this.isHandoverNeeded(networks)) {
                    int targetTransport = ACCESS_NETWORK_TRANSPORT_TYPE_MAP.get(networks.qualifiedNetworks[0]);
                    this.logl("Handover needed for APN type: " + ApnSetting.getApnTypeString(networks.apnType) + ", target transport: " + AccessNetworkConstants.transportTypeToString(targetTransport));
                    this.mPendingHandoverApns.put(networks.apnType, targetTransport);
                    this.mHandoverNeededEventRegistrants.notifyResult(new HandoverParams(networks.apnType, targetTransport, success -> {
                        if (success) {
                            this.logl("Handover succeeded.");
                        } else {
                            this.logl("APN type " + ApnSetting.getApnTypeString(networks.apnType) + " handover to " + AccessNetworkConstants.transportTypeToString(targetTransport) + " failed.");
                        }
                        this.setCurrentTransport(networks.apnType, targetTransport);
                        this.mPendingHandoverApns.delete(networks.apnType);
                        if (this.mAvailableNetworksList.size() > 0) {
                            this.sendEmptyMessage(2);
                        }
                    }));
                }
                this.mCurrentAvailableNetworks.put(networks.apnType, networks.qualifiedNetworks);
                continue;
            }
            this.loge("Invalid networks received: " + networks);
        }
        if (this.mAvailableNetworksList.size() > 0) {
            this.sendEmptyMessage(2);
        }
    }

    public synchronized int[] getAvailableTransports() {
        return this.mAvailableTransports;
    }

    public boolean isInLegacyMode() {
        String mode = SystemProperties.get(SYSTEM_PROPERTIES_IWLAN_OPERATION_MODE);
        return mode.equals(IWLAN_OPERATION_MODE_LEGACY) || this.mPhone.getHalVersion().less(RIL.RADIO_HAL_VERSION_1_4);
    }

    public int getCurrentTransport(int apnType) {
        if (this.isInLegacyMode()) {
            return 1;
        }
        return this.mCurrentTransports.get(apnType) == null ? 1 : this.mCurrentTransports.get(apnType);
    }

    public boolean isAnyApnPreferredOnIwlan() {
        for (int i = 0; i < this.mCurrentAvailableNetworks.size(); ++i) {
            int[] networkList = this.mCurrentAvailableNetworks.valueAt(i);
            if (networkList.length <= 0 || networkList[0] != 5) continue;
            return true;
        }
        return false;
    }

    public void registerForHandoverNeededEvent(Handler h, int what) {
        if (h != null) {
            this.mHandoverNeededEventRegistrants.addUnique(h, what, null);
        }
    }

    public void unregisterForHandoverNeededEvent(Handler h) {
        this.mHandoverNeededEventRegistrants.remove(h);
    }

    public void dump(FileDescriptor fd, PrintWriter printwriter, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printwriter, "  ");
        pw.println("TransportManager:");
        pw.increaseIndent();
        pw.println("mAvailableTransports=[" + Arrays.stream(this.mAvailableTransports).mapToObj(type -> AccessNetworkConstants.transportTypeToString(type)).collect(Collectors.joining(",")) + "]");
        pw.println("mCurrentAvailableNetworks=" + this.mCurrentAvailableNetworks);
        pw.println("mAvailableNetworksList=" + this.mAvailableNetworksList);
        pw.println("mPendingHandoverApns=" + this.mPendingHandoverApns);
        pw.println("mCurrentTransports=" + this.mCurrentTransports);
        pw.println("isInLegacy=" + this.isInLegacyMode());
        pw.println("IWLAN operation mode=" + SystemProperties.get(SYSTEM_PROPERTIES_IWLAN_OPERATION_MODE));
        if (this.mAccessNetworksManager != null) {
            this.mAccessNetworksManager.dump(fd, pw, args);
        }
        pw.println("Local logs=");
        pw.increaseIndent();
        this.mLocalLog.dump(fd, pw, args);
        pw.decreaseIndent();
        pw.decreaseIndent();
        pw.flush();
    }

    private void logl(String s) {
        this.log(s);
        this.mLocalLog.log(s);
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    private void loge(String s) {
        Rlog.e(TAG, s);
    }

    static {
        ACCESS_NETWORK_TRANSPORT_TYPE_MAP.put(1, 1);
        ACCESS_NETWORK_TRANSPORT_TYPE_MAP.put(2, 1);
        ACCESS_NETWORK_TRANSPORT_TYPE_MAP.put(3, 1);
        ACCESS_NETWORK_TRANSPORT_TYPE_MAP.put(4, 1);
        ACCESS_NETWORK_TRANSPORT_TYPE_MAP.put(5, 2);
    }

    @VisibleForTesting
    public static final class HandoverParams {
        public final int apnType;
        public final int targetTransport;
        public final HandoverCallback callback;

        HandoverParams(int apnType, int targetTransport, HandoverCallback callback) {
            this.apnType = apnType;
            this.targetTransport = targetTransport;
            this.callback = callback;
        }

        public static interface HandoverCallback {
            public void onCompleted(boolean var1);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IwlanOperationMode {
    }
}

