/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.emergency;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.SystemProperties;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.emergency.EmergencyNumber;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.i18n.phonenumbers.ShortNumberInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.LocaleTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.util.IndentingPrintWriter;
import com.android.phone.ecc.nano.ProtobufEccData;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import libcore.io.IoUtils;

public class EmergencyNumberTracker
extends Handler {
    private static final String TAG = EmergencyNumberTracker.class.getSimpleName();
    public static boolean DBG = false;
    public static final int ADD_EMERGENCY_NUMBER_TEST_MODE = 1;
    public static final int REMOVE_EMERGENCY_NUMBER_TEST_MODE = 2;
    public static final int RESET_EMERGENCY_NUMBER_TEST_MODE = 3;
    private final CommandsInterface mCi;
    private final Phone mPhone;
    private String mCountryIso;
    private String[] mEmergencyNumberPrefix = new String[0];
    private static final String EMERGENCY_NUMBER_DB_ASSETS_FILE = "eccdata";
    private List<EmergencyNumber> mEmergencyNumberListFromDatabase = new ArrayList<EmergencyNumber>();
    private List<EmergencyNumber> mEmergencyNumberListFromRadio = new ArrayList<EmergencyNumber>();
    private List<EmergencyNumber> mEmergencyNumberListWithPrefix = new ArrayList<EmergencyNumber>();
    private List<EmergencyNumber> mEmergencyNumberListFromTestMode = new ArrayList<EmergencyNumber>();
    private List<EmergencyNumber> mEmergencyNumberList = new ArrayList<EmergencyNumber>();
    private final LocalLog mEmergencyNumberListDatabaseLocalLog = new LocalLog(20);
    private final LocalLog mEmergencyNumberListRadioLocalLog = new LocalLog(20);
    private final LocalLog mEmergencyNumberListPrefixLocalLog = new LocalLog(20);
    private final LocalLog mEmergencyNumberListTestModeLocalLog = new LocalLog(20);
    private final LocalLog mEmergencyNumberListLocalLog = new LocalLog(20);
    private static final int EVENT_UNSOL_EMERGENCY_NUMBER_LIST = 1;
    private static final int EVENT_UPDATE_DB_COUNTRY_ISO_CHANGED = 2;
    private static final int EVENT_UPDATE_EMERGENCY_NUMBER_TEST_MODE = 3;
    private static final int EVENT_UPDATE_EMERGENCY_NUMBER_PREFIX = 4;
    private BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                EmergencyNumberTracker.this.onCarrierConfigChanged();
                return;
            }
            if (intent.getAction().equals("android.telephony.action.NETWORK_COUNTRY_CHANGED")) {
                int phoneId = intent.getIntExtra("phone", -1);
                if (phoneId == EmergencyNumberTracker.this.mPhone.getPhoneId()) {
                    String countryIso = intent.getStringExtra("android.telephony.extra.NETWORK_COUNTRY");
                    EmergencyNumberTracker.logd("ACTION_NETWORK_COUNTRY_CHANGED: PhoneId: " + phoneId + " CountryIso: " + countryIso);
                    if (TextUtils.isEmpty(countryIso)) {
                        return;
                    }
                    EmergencyNumberTracker.this.updateEmergencyNumberDatabaseCountryChange(countryIso);
                }
                return;
            }
        }
    };

    public EmergencyNumberTracker(Phone phone, CommandsInterface ci) {
        this.mPhone = phone;
        this.mCi = ci;
        if (this.mPhone != null) {
            CarrierConfigManager configMgr = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            if (configMgr != null) {
                PersistableBundle b = configMgr.getConfigForSubId(this.mPhone.getSubId());
                if (b != null) {
                    this.mEmergencyNumberPrefix = b.getStringArray("emergency_number_prefix_string_array");
                }
            } else {
                EmergencyNumberTracker.loge("CarrierConfigManager is null.");
            }
            IntentFilter filter = new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED");
            filter.addAction("android.telephony.action.NETWORK_COUNTRY_CHANGED");
            this.mPhone.getContext().registerReceiver(this.mIntentReceiver, filter);
        } else {
            EmergencyNumberTracker.loge("mPhone is null.");
        }
        this.initializeDatabaseEmergencyNumberList();
        this.mCi.registerForEmergencyNumberList(this, 1, null);
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.result == null) {
                    EmergencyNumberTracker.loge("EVENT_UNSOL_EMERGENCY_NUMBER_LIST: Result from RIL is null.");
                    break;
                }
                if (ar.result != null && ar.exception == null) {
                    this.updateRadioEmergencyNumberListAndNotify((List)ar.result);
                    break;
                }
                EmergencyNumberTracker.loge("EVENT_UNSOL_EMERGENCY_NUMBER_LIST: Exception from RIL : " + ar.exception);
                break;
            }
            case 2: {
                if (msg.obj == null) {
                    EmergencyNumberTracker.loge("EVENT_UPDATE_DB_COUNTRY_ISO_CHANGED: Result from UpdateCountryIso is null.");
                    break;
                }
                this.updateEmergencyNumberListDatabaseAndNotify((String)msg.obj);
                break;
            }
            case 3: {
                if (msg.obj == null) {
                    EmergencyNumberTracker.loge("EVENT_UPDATE_EMERGENCY_NUMBER_TEST_MODE: Result from executeEmergencyNumberTestModeCommand is null.");
                    break;
                }
                this.updateEmergencyNumberListTestModeAndNotify(msg.arg1, (EmergencyNumber)msg.obj);
                break;
            }
            case 4: {
                if (msg.obj == null) {
                    EmergencyNumberTracker.loge("EVENT_UPDATE_EMERGENCY_NUMBER_PREFIX: Result from onCarrierConfigChanged is null.");
                    break;
                }
                this.updateEmergencyNumberPrefixAndNotify((String[])msg.obj);
            }
        }
    }

    private void initializeDatabaseEmergencyNumberList() {
        if (this.mCountryIso == null) {
            this.mCountryIso = this.getInitialCountryIso().toLowerCase();
            this.cacheEmergencyDatabaseByCountry(this.mCountryIso);
        }
    }

    private void onCarrierConfigChanged() {
        if (this.mPhone != null) {
            String[] emergencyNumberPrefix;
            PersistableBundle b;
            CarrierConfigManager configMgr = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            if (configMgr != null && (b = configMgr.getConfigForSubId(this.mPhone.getSubId())) != null && !this.mEmergencyNumberPrefix.equals(emergencyNumberPrefix = b.getStringArray("emergency_number_prefix_string_array"))) {
                this.obtainMessage(4, emergencyNumberPrefix).sendToTarget();
            }
        } else {
            EmergencyNumberTracker.loge("onCarrierConfigChanged mPhone is null.");
        }
    }

    private String getInitialCountryIso() {
        if (this.mPhone != null) {
            LocaleTracker lt;
            ServiceStateTracker sst = this.mPhone.getServiceStateTracker();
            if (sst != null && (lt = sst.getLocaleTracker()) != null) {
                return lt.getCurrentCountry();
            }
        } else {
            EmergencyNumberTracker.loge("getInitialCountryIso mPhone is null.");
        }
        return "";
    }

    public void updateEmergencyNumberDatabaseCountryChange(String countryIso) {
        this.obtainMessage(2, countryIso).sendToTarget();
    }

    private EmergencyNumber convertEmergencyNumberFromEccInfo(ProtobufEccData.EccInfo eccInfo, String countryIso) {
        String phoneNumber = eccInfo.phoneNumber.trim();
        if (phoneNumber.isEmpty()) {
            EmergencyNumberTracker.loge("EccInfo has empty phone number.");
            return null;
        }
        int emergencyServiceCategoryBitmask = 0;
        block5: for (int typeData : eccInfo.types) {
            switch (typeData) {
                case 1: {
                    emergencyServiceCategoryBitmask = emergencyServiceCategoryBitmask == 0 ? 1 : emergencyServiceCategoryBitmask | 1;
                    continue block5;
                }
                case 2: {
                    emergencyServiceCategoryBitmask = emergencyServiceCategoryBitmask == 0 ? 2 : emergencyServiceCategoryBitmask | 2;
                    continue block5;
                }
                case 3: {
                    emergencyServiceCategoryBitmask = emergencyServiceCategoryBitmask == 0 ? 4 : emergencyServiceCategoryBitmask | 4;
                    continue block5;
                }
            }
        }
        return new EmergencyNumber(phoneNumber, countryIso, "", emergencyServiceCategoryBitmask, new ArrayList<String>(), 16, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheEmergencyDatabaseByCountry(String countryIso) {
        BufferedInputStream inputStream = null;
        ProtobufEccData.AllInfo allEccMessages = null;
        ArrayList<EmergencyNumber> updatedEmergencyNumberList = new ArrayList<EmergencyNumber>();
        try {
            inputStream = new BufferedInputStream(this.mPhone.getContext().getAssets().open(EMERGENCY_NUMBER_DB_ASSETS_FILE));
            allEccMessages = ProtobufEccData.AllInfo.parseFrom(EmergencyNumberTracker.readInputStreamToByteArray(new GZIPInputStream(inputStream)));
            EmergencyNumberTracker.logd(countryIso + " emergency database is loaded. ");
            for (ProtobufEccData.CountryInfo countryEccInfo : allEccMessages.countries) {
                if (!countryEccInfo.isoCode.equals(countryIso.toUpperCase())) continue;
                for (ProtobufEccData.EccInfo eccInfo : countryEccInfo.eccs) {
                    updatedEmergencyNumberList.add(this.convertEmergencyNumberFromEccInfo(eccInfo, countryIso));
                }
            }
            EmergencyNumber.mergeSameNumbersInEmergencyNumberList(updatedEmergencyNumberList);
            this.mEmergencyNumberListFromDatabase = updatedEmergencyNumberList;
        }
        catch (IOException ex) {
            try {
                EmergencyNumberTracker.loge("Cache emergency database failure: " + ex);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IoUtils.closeQuietly(inputStream);
        }
        IoUtils.closeQuietly(inputStream);
    }

    private static byte[] readInputStreamToByteArray(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int size = 16384;
        byte[] data = new byte[size];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private void updateRadioEmergencyNumberListAndNotify(List<EmergencyNumber> emergencyNumberListRadio) {
        Collections.sort(emergencyNumberListRadio);
        EmergencyNumberTracker.logd("updateRadioEmergencyNumberListAndNotify(): receiving " + emergencyNumberListRadio);
        if (!emergencyNumberListRadio.equals(this.mEmergencyNumberListFromRadio)) {
            try {
                EmergencyNumber.mergeSameNumbersInEmergencyNumberList(emergencyNumberListRadio);
                this.writeUpdatedEmergencyNumberListMetrics(emergencyNumberListRadio);
                this.mEmergencyNumberListFromRadio = emergencyNumberListRadio;
                if (!DBG) {
                    this.mEmergencyNumberListRadioLocalLog.log("updateRadioEmergencyNumberList:" + emergencyNumberListRadio);
                }
                this.updateEmergencyNumberList();
                if (!DBG) {
                    this.mEmergencyNumberListLocalLog.log("updateRadioEmergencyNumberListAndNotify:" + this.mEmergencyNumberList);
                }
                this.notifyEmergencyNumberList();
            }
            catch (NullPointerException ex) {
                EmergencyNumberTracker.loge("updateRadioEmergencyNumberListAndNotify() Phone already destroyed: " + ex + " EmergencyNumberList not notified");
            }
        }
    }

    private void updateEmergencyNumberListDatabaseAndNotify(String countryIso) {
        EmergencyNumberTracker.logd("updateEmergencyNumberListDatabaseAndNotify(): receiving countryIso: " + countryIso);
        this.mCountryIso = countryIso.toLowerCase();
        this.cacheEmergencyDatabaseByCountry(countryIso);
        this.writeUpdatedEmergencyNumberListMetrics(this.mEmergencyNumberListFromDatabase);
        if (!DBG) {
            this.mEmergencyNumberListDatabaseLocalLog.log("updateEmergencyNumberListDatabaseAndNotify:" + this.mEmergencyNumberListFromDatabase);
        }
        this.updateEmergencyNumberList();
        if (!DBG) {
            this.mEmergencyNumberListLocalLog.log("updateEmergencyNumberListDatabaseAndNotify:" + this.mEmergencyNumberList);
        }
        this.notifyEmergencyNumberList();
    }

    private void updateEmergencyNumberPrefixAndNotify(String[] emergencyNumberPrefix) {
        EmergencyNumberTracker.logd("updateEmergencyNumberPrefixAndNotify(): receiving emergencyNumberPrefix: " + emergencyNumberPrefix.toString());
        this.mEmergencyNumberPrefix = emergencyNumberPrefix;
        this.updateEmergencyNumberList();
        if (!DBG) {
            this.mEmergencyNumberListLocalLog.log("updateEmergencyNumberPrefixAndNotify:" + this.mEmergencyNumberList);
        }
        this.notifyEmergencyNumberList();
    }

    private void notifyEmergencyNumberList() {
        try {
            if (this.getEmergencyNumberList() != null) {
                this.mPhone.notifyEmergencyNumberList();
                EmergencyNumberTracker.logd("notifyEmergencyNumberList(): notified");
            }
        }
        catch (NullPointerException ex) {
            EmergencyNumberTracker.loge("notifyEmergencyNumberList(): failure: Phone already destroyed: " + ex);
        }
    }

    private void updateEmergencyNumberList() {
        ArrayList<EmergencyNumber> mergedEmergencyNumberList = new ArrayList<EmergencyNumber>(this.mEmergencyNumberListFromDatabase);
        mergedEmergencyNumberList.addAll(this.mEmergencyNumberListFromRadio);
        this.mEmergencyNumberListWithPrefix.clear();
        if (this.mEmergencyNumberPrefix.length != 0) {
            this.mEmergencyNumberListWithPrefix.addAll(this.getEmergencyNumberListWithPrefix(this.mEmergencyNumberListFromRadio));
            this.mEmergencyNumberListWithPrefix.addAll(this.getEmergencyNumberListWithPrefix(this.mEmergencyNumberListFromDatabase));
        }
        if (!DBG) {
            this.mEmergencyNumberListPrefixLocalLog.log("updateEmergencyNumberList:" + this.mEmergencyNumberListWithPrefix);
        }
        mergedEmergencyNumberList.addAll(this.mEmergencyNumberListWithPrefix);
        mergedEmergencyNumberList.addAll(this.mEmergencyNumberListFromTestMode);
        EmergencyNumber.mergeSameNumbersInEmergencyNumberList(mergedEmergencyNumberList);
        this.mEmergencyNumberList = mergedEmergencyNumberList;
    }

    public List<EmergencyNumber> getEmergencyNumberList() {
        if (!this.mEmergencyNumberListFromRadio.isEmpty()) {
            return Collections.unmodifiableList(this.mEmergencyNumberList);
        }
        return this.getEmergencyNumberListFromEccListAndTest();
    }

    public boolean isEmergencyNumber(String number, boolean exactMatch) {
        if (number == null) {
            return false;
        }
        number = PhoneNumberUtils.stripSeparators(number);
        if (!this.mEmergencyNumberListFromRadio.isEmpty()) {
            for (EmergencyNumber num : this.mEmergencyNumberList) {
                if (this.mCountryIso.equals("br") || this.mCountryIso.equals("cl") || this.mCountryIso.equals("ni")) {
                    exactMatch = true;
                }
                if (!(exactMatch ? num.getNumber().equals(number) : number.startsWith(num.getNumber()))) continue;
                return true;
            }
            return false;
        }
        return this.isEmergencyNumberFromEccList(number, exactMatch) || this.isEmergencyNumberForTest(number);
    }

    public EmergencyNumber getEmergencyNumber(String emergencyNumber) {
        emergencyNumber = PhoneNumberUtils.stripSeparators(emergencyNumber);
        for (EmergencyNumber num : this.getEmergencyNumberList()) {
            if (!num.getNumber().equals(emergencyNumber)) continue;
            return num;
        }
        return null;
    }

    public int getEmergencyServiceCategories(String emergencyNumber) {
        emergencyNumber = PhoneNumberUtils.stripSeparators(emergencyNumber);
        for (EmergencyNumber num : this.getEmergencyNumberList()) {
            if (!num.getNumber().equals(emergencyNumber) || !num.isFromSources(1) && !num.isFromSources(2)) continue;
            return num.getEmergencyServiceCategoryBitmask();
        }
        return 0;
    }

    public int getEmergencyCallRouting(String emergencyNumber) {
        emergencyNumber = PhoneNumberUtils.stripSeparators(emergencyNumber);
        for (EmergencyNumber num : this.getEmergencyNumberList()) {
            if (!num.getNumber().equals(emergencyNumber) || !num.isFromSources(16)) continue;
            return num.getEmergencyCallRouting();
        }
        return 0;
    }

    private List<EmergencyNumber> getEmergencyNumberListFromEccList() {
        ArrayList<EmergencyNumber> emergencyNumberList = new ArrayList<EmergencyNumber>();
        int slotId = SubscriptionController.getInstance().getSlotIndex(this.mPhone.getSubId());
        String ecclist = slotId <= 0 ? "ril.ecclist" : "ril.ecclist" + slotId;
        String emergencyNumbers = SystemProperties.get(ecclist, "");
        if (TextUtils.isEmpty(emergencyNumbers)) {
            emergencyNumbers = SystemProperties.get("ro.ril.ecclist");
        }
        if (!TextUtils.isEmpty(emergencyNumbers)) {
            for (String emergencyNum : emergencyNumbers.split(",")) {
                emergencyNumberList.add(this.getLabeledEmergencyNumberForEcclist(emergencyNum));
            }
        }
        emergencyNumbers = slotId < 0 ? "112,911,000,08,110,118,119,999" : "112,911";
        for (String emergencyNum : emergencyNumbers.split(",")) {
            emergencyNumberList.add(this.getLabeledEmergencyNumberForEcclist(emergencyNum));
        }
        if (this.mEmergencyNumberPrefix.length != 0) {
            emergencyNumberList.addAll(this.getEmergencyNumberListWithPrefix(emergencyNumberList));
        }
        EmergencyNumber.mergeSameNumbersInEmergencyNumberList(emergencyNumberList);
        return emergencyNumberList;
    }

    private List<EmergencyNumber> getEmergencyNumberListWithPrefix(List<EmergencyNumber> emergencyNumberList) {
        ArrayList<EmergencyNumber> emergencyNumberListWithPrefix = new ArrayList<EmergencyNumber>();
        for (EmergencyNumber num : emergencyNumberList) {
            for (String prefix : this.mEmergencyNumberPrefix) {
                if (num.getNumber().startsWith(prefix)) continue;
                emergencyNumberListWithPrefix.add(new EmergencyNumber(prefix + num.getNumber(), num.getCountryIso(), num.getMnc(), num.getEmergencyServiceCategoryBitmask(), num.getEmergencyUrns(), num.getEmergencyNumberSourceBitmask(), num.getEmergencyCallRouting()));
            }
        }
        return emergencyNumberListWithPrefix;
    }

    private boolean isEmergencyNumberForTest(String number) {
        number = PhoneNumberUtils.stripSeparators(number);
        for (EmergencyNumber num : this.mEmergencyNumberListFromTestMode) {
            if (!num.getNumber().equals(number)) continue;
            return true;
        }
        return false;
    }

    private EmergencyNumber getLabeledEmergencyNumberForEcclist(String number) {
        number = PhoneNumberUtils.stripSeparators(number);
        for (EmergencyNumber num : this.mEmergencyNumberListFromDatabase) {
            if (!num.getNumber().equals(number)) continue;
            return new EmergencyNumber(number, this.mCountryIso.toLowerCase(), "", num.getEmergencyServiceCategoryBitmask(), new ArrayList<String>(), 16, 0);
        }
        return new EmergencyNumber(number, "", "", 0, new ArrayList<String>(), 0, 0);
    }

    private boolean isEmergencyNumberFromEccList(String number, boolean useExactMatch) {
        if (number == null) {
            return false;
        }
        if (PhoneNumberUtils.isUriNumber(number)) {
            return false;
        }
        number = PhoneNumberUtils.extractNetworkPortionAlt(number);
        String emergencyNumbers = "";
        int slotId = SubscriptionController.getInstance().getSlotIndex(this.mPhone.getSubId());
        String ecclist = slotId <= 0 ? "ril.ecclist" : "ril.ecclist" + slotId;
        emergencyNumbers = SystemProperties.get(ecclist, "");
        EmergencyNumberTracker.logd("slotId:" + slotId + " country:" + this.mCountryIso + " emergencyNumbers: " + emergencyNumbers);
        if (TextUtils.isEmpty(emergencyNumbers)) {
            emergencyNumbers = SystemProperties.get("ro.ril.ecclist");
        }
        if (!TextUtils.isEmpty(emergencyNumbers)) {
            for (String emergencyNum : emergencyNumbers.split(",")) {
                if (useExactMatch || this.mCountryIso.equals("br") || this.mCountryIso.equals("cl") || this.mCountryIso.equals("ni")) {
                    if (number.equals(emergencyNum)) {
                        return true;
                    }
                    for (String prefix : this.mEmergencyNumberPrefix) {
                        if (!number.equals(prefix + emergencyNum)) continue;
                        return true;
                    }
                    continue;
                }
                if (number.startsWith(emergencyNum)) {
                    return true;
                }
                for (String prefix : this.mEmergencyNumberPrefix) {
                    if (!number.startsWith(prefix + emergencyNum)) continue;
                    return true;
                }
            }
            return false;
        }
        EmergencyNumberTracker.logd("System property doesn't provide any emergency numbers. Use embedded logic for determining ones.");
        emergencyNumbers = slotId < 0 ? "112,911,000,08,110,118,119,999" : "112,911";
        for (String emergencyNum : emergencyNumbers.split(",")) {
            if (useExactMatch) {
                if (number.equals(emergencyNum)) {
                    return true;
                }
                for (String prefix : this.mEmergencyNumberPrefix) {
                    if (!number.equals(prefix + emergencyNum)) continue;
                    return true;
                }
                continue;
            }
            if (number.startsWith(emergencyNum)) {
                return true;
            }
            for (String prefix : this.mEmergencyNumberPrefix) {
                if (!number.equals(prefix + emergencyNum)) continue;
                return true;
            }
        }
        if (this.mCountryIso != null) {
            ShortNumberInfo info = ShortNumberInfo.getInstance();
            if (useExactMatch) {
                if (info.isEmergencyNumber(number, this.mCountryIso.toUpperCase())) {
                    return true;
                }
                for (String prefix : this.mEmergencyNumberPrefix) {
                    if (!info.isEmergencyNumber(prefix + number, this.mCountryIso.toUpperCase())) continue;
                    return true;
                }
                return false;
            }
            if (info.connectsToEmergencyNumber(number, this.mCountryIso.toUpperCase())) {
                return true;
            }
            for (String prefix : this.mEmergencyNumberPrefix) {
                if (!info.connectsToEmergencyNumber(prefix + number, this.mCountryIso.toUpperCase())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void executeEmergencyNumberTestModeCommand(int action, EmergencyNumber num) {
        this.obtainMessage(3, action, 0, num).sendToTarget();
    }

    private void updateEmergencyNumberListTestModeAndNotify(int action, EmergencyNumber num) {
        if (action == 1) {
            if (!this.isEmergencyNumber(num.getNumber(), true)) {
                this.mEmergencyNumberListFromTestMode.add(num);
            }
        } else if (action == 3) {
            this.mEmergencyNumberListFromTestMode.clear();
        } else if (action == 2) {
            this.mEmergencyNumberListFromTestMode.remove(num);
        } else {
            EmergencyNumberTracker.loge("updateEmergencyNumberListTestModeAndNotify: Unexpected action in test mode.");
            return;
        }
        if (!DBG) {
            this.mEmergencyNumberListTestModeLocalLog.log("updateEmergencyNumberListTestModeAndNotify:" + this.mEmergencyNumberListFromTestMode);
        }
        this.updateEmergencyNumberList();
        if (!DBG) {
            this.mEmergencyNumberListLocalLog.log("updateEmergencyNumberListTestModeAndNotify:" + this.mEmergencyNumberList);
        }
        this.notifyEmergencyNumberList();
    }

    private List<EmergencyNumber> getEmergencyNumberListFromEccListAndTest() {
        List<EmergencyNumber> mergedEmergencyNumberList = this.getEmergencyNumberListFromEccList();
        mergedEmergencyNumberList.addAll(this.getEmergencyNumberListTestMode());
        return mergedEmergencyNumberList;
    }

    public List<EmergencyNumber> getEmergencyNumberListTestMode() {
        return Collections.unmodifiableList(this.mEmergencyNumberListFromTestMode);
    }

    @VisibleForTesting
    public List<EmergencyNumber> getRadioEmergencyNumberList() {
        return new ArrayList<EmergencyNumber>(this.mEmergencyNumberListFromRadio);
    }

    private static void logd(String str) {
        Rlog.d(TAG, str);
    }

    private static void loge(String str) {
        Rlog.e(TAG, str);
    }

    private void writeUpdatedEmergencyNumberListMetrics(List<EmergencyNumber> updatedEmergencyNumberList) {
        if (updatedEmergencyNumberList == null) {
            return;
        }
        for (EmergencyNumber num : updatedEmergencyNumberList) {
            TelephonyMetrics.getInstance().writeEmergencyNumberUpdateEvent(this.mPhone.getPhoneId(), num);
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        ipw.println(" Hal Version:" + this.mPhone.getHalVersion());
        ipw.println(" ========================================= ");
        ipw.println("mEmergencyNumberListDatabaseLocalLog:");
        ipw.increaseIndent();
        this.mEmergencyNumberListDatabaseLocalLog.dump(fd, pw, args);
        ipw.decreaseIndent();
        ipw.println(" ========================================= ");
        ipw.println("mEmergencyNumberListRadioLocalLog:");
        ipw.increaseIndent();
        this.mEmergencyNumberListRadioLocalLog.dump(fd, pw, args);
        ipw.decreaseIndent();
        ipw.println(" ========================================= ");
        ipw.println("mEmergencyNumberListPrefixLocalLog:");
        ipw.increaseIndent();
        this.mEmergencyNumberListPrefixLocalLog.dump(fd, pw, args);
        ipw.decreaseIndent();
        ipw.println(" ========================================= ");
        ipw.println("mEmergencyNumberListTestModeLocalLog:");
        ipw.increaseIndent();
        this.mEmergencyNumberListTestModeLocalLog.dump(fd, pw, args);
        ipw.decreaseIndent();
        ipw.println(" ========================================= ");
        ipw.println("mEmergencyNumberListLocalLog (valid >= 1.4 HAL):");
        ipw.increaseIndent();
        this.mEmergencyNumberListLocalLog.dump(fd, pw, args);
        ipw.decreaseIndent();
        ipw.println(" ========================================= ");
        int slotId = SubscriptionController.getInstance().getSlotIndex(this.mPhone.getSubId());
        String ecclist = slotId <= 0 ? "ril.ecclist" : "ril.ecclist" + slotId;
        ipw.println(" ril.ecclist: " + SystemProperties.get(ecclist, ""));
        ipw.println(" ========================================= ");
        ipw.println("Emergency Number List for Phone(" + this.mPhone.getPhoneId() + ")");
        ipw.increaseIndent();
        ipw.println(this.getEmergencyNumberList());
        ipw.decreaseIndent();
        ipw.println(" ========================================= ");
        ipw.flush();
    }
}

