/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.euicc;

import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ComponentInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.service.euicc.EuiccProfileInfo;
import android.telephony.euicc.EuiccNotification;
import android.telephony.euicc.EuiccRulesAuthTable;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.euicc.EuiccConnector;
import com.android.internal.telephony.euicc.EuiccController;
import com.android.internal.telephony.euicc.IAuthenticateServerCallback;
import com.android.internal.telephony.euicc.ICancelSessionCallback;
import com.android.internal.telephony.euicc.IDeleteProfileCallback;
import com.android.internal.telephony.euicc.IDisableProfileCallback;
import com.android.internal.telephony.euicc.IEuiccCardController;
import com.android.internal.telephony.euicc.IGetAllProfilesCallback;
import com.android.internal.telephony.euicc.IGetDefaultSmdpAddressCallback;
import com.android.internal.telephony.euicc.IGetEuiccChallengeCallback;
import com.android.internal.telephony.euicc.IGetEuiccInfo1Callback;
import com.android.internal.telephony.euicc.IGetEuiccInfo2Callback;
import com.android.internal.telephony.euicc.IGetProfileCallback;
import com.android.internal.telephony.euicc.IGetRulesAuthTableCallback;
import com.android.internal.telephony.euicc.IGetSmdsAddressCallback;
import com.android.internal.telephony.euicc.IListNotificationsCallback;
import com.android.internal.telephony.euicc.ILoadBoundProfilePackageCallback;
import com.android.internal.telephony.euicc.IPrepareDownloadCallback;
import com.android.internal.telephony.euicc.IRemoveNotificationFromListCallback;
import com.android.internal.telephony.euicc.IResetMemoryCallback;
import com.android.internal.telephony.euicc.IRetrieveNotificationCallback;
import com.android.internal.telephony.euicc.IRetrieveNotificationListCallback;
import com.android.internal.telephony.euicc.ISetDefaultSmdpAddressCallback;
import com.android.internal.telephony.euicc.ISetNicknameCallback;
import com.android.internal.telephony.euicc.ISwitchToProfileCallback;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.UiccSlot;
import com.android.internal.telephony.uicc.euicc.EuiccCard;
import com.android.internal.telephony.uicc.euicc.EuiccCardErrorException;
import com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class EuiccCardController
extends IEuiccCardController.Stub {
    private static final String TAG = "EuiccCardController";
    private static final String KEY_LAST_BOOT_COUNT = "last_boot_count";
    private final Context mContext;
    private AppOpsManager mAppOps;
    private String mCallingPackage;
    private ComponentInfo mBestComponent;
    private Handler mEuiccMainThreadHandler;
    private SimSlotStatusChangedBroadcastReceiver mSimSlotStatusChangeReceiver;
    private EuiccController mEuiccController;
    private UiccController mUiccController;
    private static EuiccCardController sInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EuiccCardController init(Context context) {
        Class<EuiccCardController> clazz = EuiccCardController.class;
        synchronized (EuiccCardController.class) {
            if (sInstance == null) {
                sInstance = new EuiccCardController(context);
            } else {
                Log.wtf(TAG, "init() called multiple times! sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EuiccCardController get() {
        if (sInstance != null) return sInstance;
        Class<EuiccCardController> clazz = EuiccCardController.class;
        synchronized (EuiccCardController.class) {
            if (sInstance != null) return sInstance;
            throw new IllegalStateException("get() called before init()");
        }
    }

    private EuiccCardController(Context context) {
        this(context, new Handler(), EuiccController.get(), UiccController.getInstance());
        ServiceManager.addService("euicc_card_controller", this);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public EuiccCardController(Context context, Handler handler, EuiccController euiccController, UiccController uiccController) {
        this.mContext = context;
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mEuiccMainThreadHandler = handler;
        this.mUiccController = uiccController;
        this.mEuiccController = euiccController;
        if (EuiccCardController.isBootUp(this.mContext)) {
            this.mSimSlotStatusChangeReceiver = new SimSlotStatusChangedBroadcastReceiver();
            this.mContext.registerReceiver(this.mSimSlotStatusChangeReceiver, new IntentFilter("android.telephony.action.SIM_SLOT_STATUS_CHANGED"));
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static boolean isBootUp(Context context) {
        int bootCount = Settings.Global.getInt(context.getContentResolver(), "boot_count", -1);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        int lastBootCount = sp.getInt(KEY_LAST_BOOT_COUNT, -1);
        if (bootCount == -1 || lastBootCount == -1 || bootCount != lastBootCount) {
            sp.edit().putInt(KEY_LAST_BOOT_COUNT, bootCount).apply();
            return true;
        }
        return false;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public boolean isEmbeddedSlotActivated() {
        UiccSlot[] slots = this.mUiccController.getUiccSlots();
        if (slots == null) {
            return false;
        }
        for (int i = 0; i < slots.length; ++i) {
            UiccSlot slotInfo = slots[i];
            if (slotInfo == null || slotInfo.isRemovable() || !slotInfo.isActive()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public boolean isEmbeddedCardPresent() {
        UiccSlot[] slots = this.mUiccController.getUiccSlots();
        if (slots == null) {
            return false;
        }
        for (UiccSlot slotInfo : slots) {
            if (slotInfo == null || slotInfo.isRemovable() || slotInfo.getCardState() == null || !slotInfo.getCardState().isCardPresent()) continue;
            return true;
        }
        return false;
    }

    private void checkCallingPackage(String callingPackage) {
        this.mAppOps.checkPackage(Binder.getCallingUid(), callingPackage);
        this.mCallingPackage = callingPackage;
        this.mBestComponent = EuiccConnector.findBestComponent(this.mContext.getPackageManager());
        if (this.mBestComponent == null || !TextUtils.equals(this.mCallingPackage, this.mBestComponent.packageName)) {
            throw new SecurityException("The calling package can only be LPA.");
        }
    }

    private EuiccCard getEuiccCard(String cardId) {
        UiccSlot slot;
        UiccController controller = UiccController.getInstance();
        int slotId = controller.getUiccSlotForCardId(cardId);
        if (slotId != -1 && (slot = controller.getUiccSlot(slotId)).isEuicc()) {
            return (EuiccCard)controller.getUiccCardForSlot(slotId);
        }
        EuiccCardController.loge("EuiccCard is null. CardId : " + cardId);
        return null;
    }

    private int getResultCode(Throwable e) {
        if (e instanceof EuiccCardErrorException) {
            return ((EuiccCardErrorException)e).getErrorCode();
        }
        return -1;
    }

    @Override
    public void getAllProfiles(String callingPackage, String cardId, final IGetAllProfilesCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getAllProfiles callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccProfileInfo[]> cardCb = new AsyncResultCallback<EuiccProfileInfo[]>(){

            @Override
            public void onResult(EuiccProfileInfo[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getAllProfiles callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("getAllProfiles callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getAllProfiles callback failure.", exception);
                }
            }
        };
        card.getAllProfiles(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getProfile(String callingPackage, String cardId, String iccid, final IGetProfileCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getProfile callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccProfileInfo> cardCb = new AsyncResultCallback<EuiccProfileInfo>(){

            @Override
            public void onResult(EuiccProfileInfo result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getProfile callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("getProfile callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getProfile callback failure.", exception);
                }
            }
        };
        card.getProfile(iccid, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void disableProfile(String callingPackage, String cardId, String iccid, boolean refresh, final IDisableProfileCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("disableProfile callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(){

            @Override
            public void onResult(Void result) {
                try {
                    callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("disableProfile callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("disableProfile callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e));
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("disableProfile callback failure.", exception);
                }
            }
        };
        card.disableProfile(iccid, refresh, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void switchToProfile(String callingPackage, String cardId, final String iccid, final boolean refresh, final ISwitchToProfileCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        final EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("switchToProfile callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccProfileInfo> profileCb = new AsyncResultCallback<EuiccProfileInfo>(){

            @Override
            public void onResult(final EuiccProfileInfo profile) {
                AsyncResultCallback<Void> switchCb = new AsyncResultCallback<Void>(){

                    @Override
                    public void onResult(Void result) {
                        try {
                            callback.onComplete(0, profile);
                        }
                        catch (RemoteException exception) {
                            EuiccCardController.loge("switchToProfile callback failure.", exception);
                        }
                    }

                    @Override
                    public void onException(Throwable e) {
                        try {
                            EuiccCardController.loge("switchToProfile callback onException: ", e);
                            callback.onComplete(EuiccCardController.this.getResultCode(e), profile);
                        }
                        catch (RemoteException exception) {
                            EuiccCardController.loge("switchToProfile callback failure.", exception);
                        }
                    }
                };
                card.switchToProfile(iccid, refresh, switchCb, EuiccCardController.this.mEuiccMainThreadHandler);
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("getProfile in switchToProfile callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("switchToProfile callback failure.", exception);
                }
            }
        };
        card.getProfile(iccid, profileCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void setNickname(String callingPackage, String cardId, String iccid, String nickname, final ISetNicknameCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("setNickname callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(){

            @Override
            public void onResult(Void result) {
                try {
                    callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("setNickname callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("setNickname callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e));
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("setNickname callback failure.", exception);
                }
            }
        };
        card.setNickname(iccid, nickname, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void deleteProfile(String callingPackage, final String cardId, String iccid, final IDeleteProfileCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("deleteProfile callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(){

            @Override
            public void onResult(Void result) {
                Log.i(EuiccCardController.TAG, "Request subscription info list refresh after delete.");
                SubscriptionController.getInstance().requestEmbeddedSubscriptionInfoListRefresh(EuiccCardController.this.mUiccController.convertToPublicCardId(cardId));
                try {
                    callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("deleteProfile callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("deleteProfile callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e));
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("deleteProfile callback failure.", exception);
                }
            }
        };
        card.deleteProfile(iccid, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void resetMemory(String callingPackage, final String cardId, int options, final IResetMemoryCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("resetMemory callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(){

            @Override
            public void onResult(Void result) {
                Log.i(EuiccCardController.TAG, "Request subscription info list refresh after reset memory.");
                SubscriptionController.getInstance().requestEmbeddedSubscriptionInfoListRefresh(EuiccCardController.this.mUiccController.convertToPublicCardId(cardId));
                try {
                    callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("resetMemory callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("resetMemory callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e));
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("resetMemory callback failure.", exception);
                }
            }
        };
        card.resetMemory(options, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getDefaultSmdpAddress(String callingPackage, String cardId, final IGetDefaultSmdpAddressCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getDefaultSmdpAddress callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<String> cardCb = new AsyncResultCallback<String>(){

            @Override
            public void onResult(String result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getDefaultSmdpAddress callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("getDefaultSmdpAddress callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getDefaultSmdpAddress callback failure.", exception);
                }
            }
        };
        card.getDefaultSmdpAddress(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getSmdsAddress(String callingPackage, String cardId, final IGetSmdsAddressCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getSmdsAddress callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<String> cardCb = new AsyncResultCallback<String>(){

            @Override
            public void onResult(String result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getSmdsAddress callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("getSmdsAddress callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getSmdsAddress callback failure.", exception);
                }
            }
        };
        card.getSmdsAddress(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void setDefaultSmdpAddress(String callingPackage, String cardId, String address, final ISetDefaultSmdpAddressCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("setDefaultSmdpAddress callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(){

            @Override
            public void onResult(Void result) {
                try {
                    callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("setDefaultSmdpAddress callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("setDefaultSmdpAddress callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e));
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("setDefaultSmdpAddress callback failure.", exception);
                }
            }
        };
        card.setDefaultSmdpAddress(address, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getRulesAuthTable(String callingPackage, String cardId, final IGetRulesAuthTableCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getRulesAuthTable callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccRulesAuthTable> cardCb = new AsyncResultCallback<EuiccRulesAuthTable>(){

            @Override
            public void onResult(EuiccRulesAuthTable result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getRulesAuthTable callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("getRulesAuthTable callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getRulesAuthTable callback failure.", exception);
                }
            }
        };
        card.getRulesAuthTable(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getEuiccChallenge(String callingPackage, String cardId, final IGetEuiccChallengeCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getEuiccChallenge callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getEuiccChallenge callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("getEuiccChallenge callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getEuiccChallenge callback failure.", exception);
                }
            }
        };
        card.getEuiccChallenge(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getEuiccInfo1(String callingPackage, String cardId, final IGetEuiccInfo1Callback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getEuiccInfo1 callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getEuiccInfo1 callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("getEuiccInfo1 callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getEuiccInfo1 callback failure.", exception);
                }
            }
        };
        card.getEuiccInfo1(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void getEuiccInfo2(String callingPackage, String cardId, final IGetEuiccInfo2Callback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getEuiccInfo2 callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getEuiccInfo2 callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("getEuiccInfo2 callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getEuiccInfo2 callback failure.", exception);
                }
            }
        };
        card.getEuiccInfo2(cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void authenticateServer(String callingPackage, String cardId, String matchingId, byte[] serverSigned1, byte[] serverSignature1, byte[] euiccCiPkIdToBeUsed, byte[] serverCertificate, final IAuthenticateServerCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("authenticateServer callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("authenticateServer callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("authenticateServer callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("authenticateServer callback failure.", exception);
                }
            }
        };
        card.authenticateServer(matchingId, serverSigned1, serverSignature1, euiccCiPkIdToBeUsed, serverCertificate, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void prepareDownload(String callingPackage, String cardId, byte[] hashCc, byte[] smdpSigned2, byte[] smdpSignature2, byte[] smdpCertificate, final IPrepareDownloadCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("prepareDownload callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("prepareDownload callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("prepareDownload callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("prepareDownload callback failure.", exception);
                }
            }
        };
        card.prepareDownload(hashCc, smdpSigned2, smdpSignature2, smdpCertificate, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void loadBoundProfilePackage(String callingPackage, final String cardId, byte[] boundProfilePackage, final ILoadBoundProfilePackageCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("loadBoundProfilePackage callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                Log.i(EuiccCardController.TAG, "Request subscription info list refresh after install.");
                SubscriptionController.getInstance().requestEmbeddedSubscriptionInfoListRefresh(EuiccCardController.this.mUiccController.convertToPublicCardId(cardId));
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("loadBoundProfilePackage callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("loadBoundProfilePackage callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("loadBoundProfilePackage callback failure.", exception);
                }
            }
        };
        card.loadBoundProfilePackage(boundProfilePackage, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void cancelSession(String callingPackage, String cardId, byte[] transactionId, int reason, final ICancelSessionCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("cancelSession callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(){

            @Override
            public void onResult(byte[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("cancelSession callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("cancelSession callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("cancelSession callback failure.", exception);
                }
            }
        };
        card.cancelSession(transactionId, reason, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void listNotifications(String callingPackage, String cardId, int events, final IListNotificationsCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("listNotifications callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccNotification[]> cardCb = new AsyncResultCallback<EuiccNotification[]>(){

            @Override
            public void onResult(EuiccNotification[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("listNotifications callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("listNotifications callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("listNotifications callback failure.", exception);
                }
            }
        };
        card.listNotifications(events, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void retrieveNotificationList(String callingPackage, String cardId, int events, final IRetrieveNotificationListCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("retrieveNotificationList callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccNotification[]> cardCb = new AsyncResultCallback<EuiccNotification[]>(){

            @Override
            public void onResult(EuiccNotification[] result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("retrieveNotificationList callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("retrieveNotificationList callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("retrieveNotificationList callback failure.", exception);
                }
            }
        };
        card.retrieveNotificationList(events, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void retrieveNotification(String callingPackage, String cardId, int seqNumber, final IRetrieveNotificationCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3, null);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("retrieveNotification callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccNotification> cardCb = new AsyncResultCallback<EuiccNotification>(){

            @Override
            public void onResult(EuiccNotification result) {
                try {
                    callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("retrieveNotification callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("retrieveNotification callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("retrieveNotification callback failure.", exception);
                }
            }
        };
        card.retrieveNotification(seqNumber, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void removeNotificationFromList(String callingPackage, String cardId, int seqNumber, final IRemoveNotificationFromListCallback callback) {
        try {
            this.checkCallingPackage(callingPackage);
        }
        catch (SecurityException se) {
            try {
                callback.onComplete(-3);
            }
            catch (RemoteException re) {
                EuiccCardController.loge("callback onComplete failure after checkCallingPackage.", re);
            }
            return;
        }
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("removeNotificationFromList callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(){

            @Override
            public void onResult(Void result) {
                try {
                    callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("removeNotificationFromList callback failure.", exception);
                }
            }

            @Override
            public void onException(Throwable e) {
                try {
                    EuiccCardController.loge("removeNotificationFromList callback onException: ", e);
                    callback.onComplete(EuiccCardController.this.getResultCode(e));
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("removeNotificationFromList callback failure.", exception);
                }
            }
        };
        card.removeNotificationFromList(seqNumber, cardCb, this.mEuiccMainThreadHandler);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "Requires DUMP");
        long token = Binder.clearCallingIdentity();
        super.dump(fd, pw, args);
        pw.println("mCallingPackage=" + this.mCallingPackage);
        pw.println("mBestComponent=" + this.mBestComponent);
        Binder.restoreCallingIdentity(token);
    }

    private static void loge(String message) {
        Log.e(TAG, message);
    }

    private static void loge(String message, Throwable tr) {
        Log.e(TAG, message, tr);
    }

    private class SimSlotStatusChangedBroadcastReceiver
    extends BroadcastReceiver {
        private SimSlotStatusChangedBroadcastReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.telephony.action.SIM_SLOT_STATUS_CHANGED".equals(intent.getAction())) {
                if (!EuiccCardController.this.isEmbeddedCardPresent()) {
                    return;
                }
                if (EuiccCardController.this.isEmbeddedSlotActivated()) {
                    EuiccCardController.this.mEuiccController.startOtaUpdatingIfNecessary();
                }
                EuiccCardController.this.mContext.unregisterReceiver(EuiccCardController.this.mSimSlotStatusChangeReceiver);
            }
        }
    }
}

