/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.euicc;

import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.ServiceManager;
import android.provider.Settings;
import android.service.euicc.DownloadSubscriptionResult;
import android.service.euicc.GetDefaultDownloadableSubscriptionListResult;
import android.service.euicc.GetDownloadableSubscriptionMetadataResult;
import android.service.euicc.GetEuiccProfileInfoListResult;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.UiccAccessRule;
import android.telephony.UiccCardInfo;
import android.telephony.euicc.DownloadableSubscription;
import android.telephony.euicc.EuiccInfo;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.euicc.EuiccConnector;
import com.android.internal.telephony.euicc.EuiccOperation;
import com.android.internal.telephony.euicc.IEuiccController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class EuiccController
extends IEuiccController.Stub {
    private static final String TAG = "EuiccController";
    @VisibleForTesting
    static final String EXTRA_OPERATION = "operation";
    private static final int OK = 0;
    private static final int RESOLVABLE_ERROR = 1;
    private static final int ERROR = 2;
    private static final String EXTRA_EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTION = "android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTION";
    private static EuiccController sInstance;
    private final Context mContext;
    private final EuiccConnector mConnector;
    private final SubscriptionManager mSubscriptionManager;
    private final TelephonyManager mTelephonyManager;
    private final AppOpsManager mAppOpsManager;
    private final PackageManager mPackageManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EuiccController init(Context context) {
        Class<EuiccController> clazz = EuiccController.class;
        synchronized (EuiccController.class) {
            if (sInstance == null) {
                sInstance = new EuiccController(context);
            } else {
                Log.wtf(TAG, "init() called multiple times! sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EuiccController get() {
        if (sInstance != null) return sInstance;
        Class<EuiccController> clazz = EuiccController.class;
        synchronized (EuiccController.class) {
            if (sInstance != null) return sInstance;
            throw new IllegalStateException("get() called before init()");
        }
    }

    private EuiccController(Context context) {
        this(context, new EuiccConnector(context));
        ServiceManager.addService("econtroller", this);
    }

    @VisibleForTesting
    public EuiccController(Context context, EuiccConnector connector) {
        this.mContext = context;
        this.mConnector = connector;
        this.mSubscriptionManager = (SubscriptionManager)context.getSystemService("telephony_subscription_service");
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.mAppOpsManager = (AppOpsManager)context.getSystemService("appops");
        this.mPackageManager = context.getPackageManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void continueOperation(int cardId, Intent resolutionIntent, Bundle resolutionExtras) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to continue operation");
        }
        long token = Binder.clearCallingIdentity();
        try {
            EuiccOperation op = (EuiccOperation)resolutionIntent.getParcelableExtra(EXTRA_OPERATION);
            if (op == null) {
                throw new IllegalArgumentException("Invalid resolution intent");
            }
            PendingIntent callbackIntent = (PendingIntent)resolutionIntent.getParcelableExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_RESOLUTION_CALLBACK_INTENT");
            op.continueOperation(cardId, resolutionExtras, callbackIntent);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEid(int cardId, String callingPackage) {
        boolean callerCanReadPhoneStatePrivileged = this.callerCanReadPhoneStatePrivileged();
        long token = Binder.clearCallingIdentity();
        try {
            if (!callerCanReadPhoneStatePrivileged && !this.canManageSubscriptionOnTargetSim(cardId, callingPackage)) {
                throw new SecurityException("Must have carrier privileges on subscription to read EID for cardId=" + cardId);
            }
            String string2 = this.blockingGetEidFromEuiccService(cardId);
            return string2;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOtaStatus(int cardId) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to get OTA status");
        }
        long token = Binder.clearCallingIdentity();
        try {
            int n = this.blockingGetOtaStatusFromEuiccService(cardId);
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    public void startOtaUpdatingIfNecessary() {
        this.startOtaUpdatingIfNecessary(this.mTelephonyManager.getCardIdForDefaultEuicc());
    }

    public void startOtaUpdatingIfNecessary(int cardId) {
        this.mConnector.startOtaIfNecessary(cardId, new EuiccConnector.OtaStatusChangedCallback(){

            @Override
            public void onOtaStatusChanged(int status) {
                EuiccController.this.sendOtaStatusChangedBroadcast();
            }

            @Override
            public void onEuiccServiceUnavailable() {
            }
        });
    }

    @Override
    public void getDownloadableSubscriptionMetadata(int cardId, DownloadableSubscription subscription, String callingPackage, PendingIntent callbackIntent) {
        this.getDownloadableSubscriptionMetadata(cardId, subscription, false, callingPackage, callbackIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getDownloadableSubscriptionMetadata(int cardId, DownloadableSubscription subscription, boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to get metadata");
        }
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.getDownloadableSubscriptionMetadata(cardId, subscription, forceDeactivateSim, new GetMetadataCommandCallback(token, subscription, callingPackage, callbackIntent));
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public void downloadSubscription(int cardId, DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage, Bundle resolvedBundle, PendingIntent callbackIntent) {
        this.downloadSubscription(cardId, subscription, switchAfterDownload, callingPackage, false, resolvedBundle, callbackIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadSubscription(int cardId, DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage, boolean forceDeactivateSim, Bundle resolvedBundle, PendingIntent callbackIntent) {
        boolean callerCanWriteEmbeddedSubscriptions = this.callerCanWriteEmbeddedSubscriptions();
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            if (callerCanWriteEmbeddedSubscriptions) {
                this.downloadSubscriptionPrivileged(cardId, token, subscription, switchAfterDownload, forceDeactivateSim, callingPackage, resolvedBundle, callbackIntent);
                return;
            }
            if (this.canManageSubscriptionOnTargetSim(cardId, callingPackage)) {
                this.mConnector.getDownloadableSubscriptionMetadata(cardId, subscription, forceDeactivateSim, new DownloadSubscriptionGetMetadataCommandCallback(token, subscription, switchAfterDownload, callingPackage, forceDeactivateSim, callbackIntent, false));
            } else {
                Log.i(TAG, "Caller can't manage subscription on target SIM. Ask user's consent first");
                Intent extrasIntent = new Intent();
                this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_NO_PRIVILEGES", callingPackage, 0, false, EuiccOperation.forDownloadNoPrivilegesOrDeactivateSimCheckMetadata(token, subscription, switchAfterDownload, callingPackage), cardId);
                this.sendResult(callbackIntent, 1, extrasIntent);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void downloadSubscriptionPrivilegedCheckMetadata(int cardId, long callingToken, DownloadableSubscription subscription, boolean switchAfterDownload, boolean forceDeactivateSim, String callingPackage, Bundle resolvedBundle, PendingIntent callbackIntent) {
        this.mConnector.getDownloadableSubscriptionMetadata(cardId, subscription, forceDeactivateSim, new DownloadSubscriptionGetMetadataCommandCallback(callingToken, subscription, switchAfterDownload, callingPackage, forceDeactivateSim, callbackIntent, true));
    }

    void downloadSubscriptionPrivileged(final int cardId, final long callingToken, final DownloadableSubscription subscription, final boolean switchAfterDownload, boolean forceDeactivateSim, final String callingPackage, Bundle resolvedBundle, final PendingIntent callbackIntent) {
        this.mConnector.downloadSubscription(cardId, subscription, switchAfterDownload, forceDeactivateSim, resolvedBundle, new EuiccConnector.DownloadCommandCallback(){

            @Override
            public void onDownloadComplete(DownloadSubscriptionResult result) {
                int resultCode;
                Intent extrasIntent = new Intent();
                switch (result.getResult()) {
                    case 0: {
                        resultCode = 0;
                        Settings.Global.putInt(EuiccController.this.mContext.getContentResolver(), "euicc_provisioned", 1);
                        extrasIntent.putExtra(EuiccController.EXTRA_EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTION, subscription);
                        if (switchAfterDownload) break;
                        EuiccController.this.refreshSubscriptionsAndSendResult(callbackIntent, resultCode, extrasIntent);
                        return;
                    }
                    case -1: {
                        resultCode = 1;
                        EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", callingPackage, 0, false, EuiccOperation.forDownloadDeactivateSim(callingToken, subscription, switchAfterDownload, callingPackage), cardId);
                        break;
                    }
                    case -2: {
                        resultCode = 1;
                        boolean retried = false;
                        if (!TextUtils.isEmpty(subscription.getConfirmationCode())) {
                            retried = true;
                        }
                        if (result.getResolvableErrors() != 0) {
                            EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_RESOLVABLE_ERRORS", callingPackage, result.getResolvableErrors(), retried, EuiccOperation.forDownloadResolvableErrors(callingToken, subscription, switchAfterDownload, callingPackage, result.getResolvableErrors()), cardId);
                            break;
                        }
                        EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_CONFIRMATION_CODE", callingPackage, 0, retried, EuiccOperation.forDownloadConfirmationCode(callingToken, subscription, switchAfterDownload, callingPackage), cardId);
                        break;
                    }
                    default: {
                        resultCode = 2;
                        extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result.getResult());
                    }
                }
                EuiccController.this.sendResult(callbackIntent, resultCode, extrasIntent);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                EuiccController.this.sendResult(callbackIntent, 2, null);
            }
        });
    }

    public GetEuiccProfileInfoListResult blockingGetEuiccProfileInfoList(int cardId) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference resultRef = new AtomicReference();
        this.mConnector.getEuiccProfileInfoList(cardId, new EuiccConnector.GetEuiccProfileInfoListCommandCallback(){

            @Override
            public void onListComplete(GetEuiccProfileInfoListResult result) {
                resultRef.set(result);
                latch.countDown();
            }

            @Override
            public void onEuiccServiceUnavailable() {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Log.e(TAG, "blockingGetEuiccInfoFromEuiccService got InterruptedException e: " + e);
            Thread.currentThread().interrupt();
        }
        return (GetEuiccProfileInfoListResult)resultRef.get();
    }

    @Override
    public void getDefaultDownloadableSubscriptionList(int cardId, String callingPackage, PendingIntent callbackIntent) {
        this.getDefaultDownloadableSubscriptionList(cardId, false, callingPackage, callbackIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getDefaultDownloadableSubscriptionList(int cardId, boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to get default list");
        }
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.getDefaultDownloadableSubscriptionList(cardId, forceDeactivateSim, new GetDefaultListCommandCallback(token, callingPackage, callbackIntent));
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EuiccInfo getEuiccInfo(int cardId) {
        long token = Binder.clearCallingIdentity();
        try {
            EuiccInfo euiccInfo = this.blockingGetEuiccInfoFromEuiccService(cardId);
            return euiccInfo;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSubscription(int cardId, int subscriptionId, String callingPackage, PendingIntent callbackIntent) {
        boolean callerCanWriteEmbeddedSubscriptions = this.callerCanWriteEmbeddedSubscriptions();
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            SubscriptionInfo sub = this.getSubscriptionForSubscriptionId(subscriptionId);
            if (sub == null) {
                Log.e(TAG, "Cannot delete nonexistent subscription: " + subscriptionId);
                this.sendResult(callbackIntent, 2, null);
                return;
            }
            if (!callerCanWriteEmbeddedSubscriptions && !this.mSubscriptionManager.canManageSubscription(sub, callingPackage)) {
                Log.e(TAG, "No permissions: " + subscriptionId);
                this.sendResult(callbackIntent, 2, null);
                return;
            }
            this.deleteSubscriptionPrivileged(cardId, sub.getIccId(), callbackIntent);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void deleteSubscriptionPrivileged(int cardId, String iccid, final PendingIntent callbackIntent) {
        this.mConnector.deleteSubscription(cardId, iccid, new EuiccConnector.DeleteCommandCallback(){

            @Override
            public void onDeleteComplete(int result) {
                Intent extrasIntent = new Intent();
                switch (result) {
                    case 0: {
                        int resultCode = 0;
                        EuiccController.this.refreshSubscriptionsAndSendResult(callbackIntent, resultCode, extrasIntent);
                        return;
                    }
                }
                int resultCode = 2;
                extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                EuiccController.this.sendResult(callbackIntent, resultCode, extrasIntent);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                EuiccController.this.sendResult(callbackIntent, 2, null);
            }
        });
    }

    @Override
    public void switchToSubscription(int cardId, int subscriptionId, String callingPackage, PendingIntent callbackIntent) {
        this.switchToSubscription(cardId, subscriptionId, false, callingPackage, callbackIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchToSubscription(int cardId, int subscriptionId, boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        boolean callerCanWriteEmbeddedSubscriptions = this.callerCanWriteEmbeddedSubscriptions();
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            String iccid;
            if (callerCanWriteEmbeddedSubscriptions) {
                forceDeactivateSim = true;
            }
            boolean passConsent = false;
            if (subscriptionId == -1) {
                if (!callerCanWriteEmbeddedSubscriptions && !this.canManageActiveSubscriptionOnTargetSim(cardId, callingPackage)) {
                    Log.e(TAG, "Not permitted to switch to empty subscription");
                    this.sendResult(callbackIntent, 2, null);
                    return;
                }
                passConsent = true;
                iccid = null;
            } else {
                SubscriptionInfo sub = this.getSubscriptionForSubscriptionId(subscriptionId);
                if (sub == null) {
                    Log.e(TAG, "Cannot switch to nonexistent sub: " + subscriptionId);
                    this.sendResult(callbackIntent, 2, null);
                    return;
                }
                if (callerCanWriteEmbeddedSubscriptions) {
                    passConsent = true;
                } else {
                    if (!this.mSubscriptionManager.canManageSubscription(sub, callingPackage)) {
                        Log.e(TAG, "Not permitted to switch to sub: " + subscriptionId);
                        this.sendResult(callbackIntent, 2, null);
                        return;
                    }
                    if (this.canManageSubscriptionOnTargetSim(cardId, callingPackage)) {
                        passConsent = true;
                    }
                }
                iccid = sub.getIccId();
            }
            if (!passConsent) {
                Intent extrasIntent = new Intent();
                this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_NO_PRIVILEGES", callingPackage, 0, false, EuiccOperation.forSwitchNoPrivileges(token, subscriptionId, callingPackage), cardId);
                this.sendResult(callbackIntent, 1, extrasIntent);
                return;
            }
            this.switchToSubscriptionPrivileged(cardId, token, subscriptionId, iccid, forceDeactivateSim, callingPackage, callbackIntent);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void switchToSubscriptionPrivileged(int cardId, long callingToken, int subscriptionId, boolean forceDeactivateSim, String callingPackage, PendingIntent callbackIntent) {
        String iccid = null;
        SubscriptionInfo sub = this.getSubscriptionForSubscriptionId(subscriptionId);
        if (sub != null) {
            iccid = sub.getIccId();
        }
        this.switchToSubscriptionPrivileged(cardId, callingToken, subscriptionId, iccid, forceDeactivateSim, callingPackage, callbackIntent);
    }

    void switchToSubscriptionPrivileged(final int cardId, final long callingToken, final int subscriptionId, String iccid, boolean forceDeactivateSim, final String callingPackage, final PendingIntent callbackIntent) {
        this.mConnector.switchToSubscription(cardId, iccid, forceDeactivateSim, new EuiccConnector.SwitchCommandCallback(){

            @Override
            public void onSwitchComplete(int result) {
                int resultCode;
                Intent extrasIntent = new Intent();
                switch (result) {
                    case 0: {
                        resultCode = 0;
                        break;
                    }
                    case -1: {
                        resultCode = 1;
                        EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", callingPackage, 0, false, EuiccOperation.forSwitchDeactivateSim(callingToken, subscriptionId, callingPackage), cardId);
                        break;
                    }
                    default: {
                        resultCode = 2;
                        extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                    }
                }
                EuiccController.this.sendResult(callbackIntent, resultCode, extrasIntent);
            }

            @Override
            public void onEuiccServiceUnavailable() {
                EuiccController.this.sendResult(callbackIntent, 2, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSubscriptionNickname(int cardId, int subscriptionId, String nickname, String callingPackage, final PendingIntent callbackIntent) {
        boolean callerCanWriteEmbeddedSubscriptions = this.callerCanWriteEmbeddedSubscriptions();
        this.mAppOpsManager.checkPackage(Binder.getCallingUid(), callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            SubscriptionInfo sub = this.getSubscriptionForSubscriptionId(subscriptionId);
            if (sub == null) {
                Log.e(TAG, "Cannot update nickname to nonexistent sub: " + subscriptionId);
                this.sendResult(callbackIntent, 2, null);
                return;
            }
            if (!callerCanWriteEmbeddedSubscriptions && !this.mSubscriptionManager.canManageSubscription(sub, callingPackage)) {
                Log.e(TAG, "No permissions: " + subscriptionId);
                this.sendResult(callbackIntent, 2, null);
                return;
            }
            this.mConnector.updateSubscriptionNickname(cardId, sub.getIccId(), nickname, new EuiccConnector.UpdateNicknameCommandCallback(){

                @Override
                public void onUpdateNicknameComplete(int result) {
                    Intent extrasIntent = new Intent();
                    switch (result) {
                        case 0: {
                            int resultCode = 0;
                            EuiccController.this.refreshSubscriptionsAndSendResult(callbackIntent, resultCode, extrasIntent);
                            return;
                        }
                    }
                    int resultCode = 2;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                    EuiccController.this.sendResult(callbackIntent, resultCode, extrasIntent);
                }

                @Override
                public void onEuiccServiceUnavailable() {
                    EuiccController.this.sendResult(callbackIntent, 2, null);
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eraseSubscriptions(int cardId, final PendingIntent callbackIntent) {
        if (!this.callerCanWriteEmbeddedSubscriptions()) {
            throw new SecurityException("Must have WRITE_EMBEDDED_SUBSCRIPTIONS to erase subscriptions");
        }
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.eraseSubscriptions(cardId, new EuiccConnector.EraseCommandCallback(){

                @Override
                public void onEraseComplete(int result) {
                    Intent extrasIntent = new Intent();
                    switch (result) {
                        case 0: {
                            int resultCode = 0;
                            EuiccController.this.refreshSubscriptionsAndSendResult(callbackIntent, resultCode, extrasIntent);
                            return;
                        }
                    }
                    int resultCode = 2;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                    EuiccController.this.sendResult(callbackIntent, resultCode, extrasIntent);
                }

                @Override
                public void onEuiccServiceUnavailable() {
                    EuiccController.this.sendResult(callbackIntent, 2, null);
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retainSubscriptionsForFactoryReset(int cardId, final PendingIntent callbackIntent) {
        this.mContext.enforceCallingPermission("android.permission.MASTER_CLEAR", "Must have MASTER_CLEAR to retain subscriptions for factory reset");
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.retainSubscriptions(cardId, new EuiccConnector.RetainSubscriptionsCommandCallback(){

                @Override
                public void onRetainSubscriptionsComplete(int result) {
                    int resultCode;
                    Intent extrasIntent = new Intent();
                    switch (result) {
                        case 0: {
                            resultCode = 0;
                            break;
                        }
                        default: {
                            resultCode = 2;
                            extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result);
                        }
                    }
                    EuiccController.this.sendResult(callbackIntent, resultCode, extrasIntent);
                }

                @Override
                public void onEuiccServiceUnavailable() {
                    EuiccController.this.sendResult(callbackIntent, 2, null);
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void refreshSubscriptionsAndSendResult(PendingIntent callbackIntent, int resultCode, Intent extrasIntent) {
        SubscriptionController.getInstance().requestEmbeddedSubscriptionInfoListRefresh(() -> this.sendResult(callbackIntent, resultCode, extrasIntent));
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void sendResult(PendingIntent callbackIntent, int resultCode, Intent extrasIntent) {
        try {
            callbackIntent.send(this.mContext, resultCode, extrasIntent);
        }
        catch (PendingIntent.CanceledException canceledException) {
            // empty catch block
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void addResolutionIntent(Intent extrasIntent, String resolutionAction, String callingPackage, int resolvableErrors, boolean confirmationCodeRetried, EuiccOperation op, int cardId) {
        Intent intent = new Intent("android.telephony.euicc.action.RESOLVE_ERROR");
        intent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_RESOLUTION_ACTION", resolutionAction);
        intent.putExtra("android.service.euicc.extra.RESOLUTION_CALLING_PACKAGE", callingPackage);
        intent.putExtra("android.service.euicc.extra.RESOLVABLE_ERRORS", resolvableErrors);
        intent.putExtra("android.service.euicc.extra.RESOLUTION_CARD_ID", cardId);
        intent.putExtra("android.service.euicc.extra.RESOLUTION_CONFIRMATION_CODE_RETRIED", confirmationCodeRetried);
        intent.putExtra(EXTRA_OPERATION, op);
        PendingIntent resolutionIntent = PendingIntent.getActivity(this.mContext, 0, intent, 0x40000000);
        extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_RESOLUTION_INTENT", resolutionIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "Requires DUMP");
        long token = Binder.clearCallingIdentity();
        try {
            this.mConnector.dump(fd, pw, args);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void sendOtaStatusChangedBroadcast() {
        Intent intent = new Intent("android.telephony.euicc.action.OTA_STATUS_CHANGED");
        ComponentInfo bestComponent = EuiccConnector.findBestComponent(this.mContext.getPackageManager());
        if (bestComponent != null) {
            intent.setPackage(bestComponent.packageName);
        }
        this.mContext.sendBroadcast(intent, "android.permission.WRITE_EMBEDDED_SUBSCRIPTIONS");
    }

    private SubscriptionInfo getSubscriptionForSubscriptionId(int subscriptionId) {
        List<SubscriptionInfo> subs = this.mSubscriptionManager.getAvailableSubscriptionInfoList();
        int subCount = subs != null ? subs.size() : 0;
        for (int i = 0; i < subCount; ++i) {
            SubscriptionInfo sub = subs.get(i);
            if (subscriptionId != sub.getSubscriptionId()) continue;
            return sub;
        }
        return null;
    }

    private String blockingGetEidFromEuiccService(int cardId) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference eidRef = new AtomicReference();
        this.mConnector.getEid(cardId, new EuiccConnector.GetEidCommandCallback(){

            @Override
            public void onGetEidComplete(String eid) {
                eidRef.set(eid);
                latch.countDown();
            }

            @Override
            public void onEuiccServiceUnavailable() {
                latch.countDown();
            }
        });
        return (String)EuiccController.awaitResult(latch, eidRef);
    }

    private int blockingGetOtaStatusFromEuiccService(int cardId) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference<Integer> statusRef = new AtomicReference<Integer>(5);
        this.mConnector.getOtaStatus(cardId, new EuiccConnector.GetOtaStatusCommandCallback(){

            @Override
            public void onGetOtaStatusComplete(int status) {
                statusRef.set(status);
                latch.countDown();
            }

            @Override
            public void onEuiccServiceUnavailable() {
                latch.countDown();
            }
        });
        return EuiccController.awaitResult(latch, statusRef);
    }

    private EuiccInfo blockingGetEuiccInfoFromEuiccService(int cardId) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference euiccInfoRef = new AtomicReference();
        this.mConnector.getEuiccInfo(cardId, new EuiccConnector.GetEuiccInfoCommandCallback(){

            @Override
            public void onGetEuiccInfoComplete(EuiccInfo euiccInfo) {
                euiccInfoRef.set(euiccInfo);
                latch.countDown();
            }

            @Override
            public void onEuiccServiceUnavailable() {
                latch.countDown();
            }
        });
        return (EuiccInfo)EuiccController.awaitResult(latch, euiccInfoRef);
    }

    private static <T> T awaitResult(CountDownLatch latch, AtomicReference<T> resultRef) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return resultRef.get();
    }

    private boolean checkCarrierPrivilegeInMetadata(DownloadableSubscription subscription, String callingPackage) {
        PackageInfo info;
        UiccAccessRule[] rules = null;
        List<UiccAccessRule> rulesList = subscription.getAccessRules();
        if (rulesList != null) {
            rules = rulesList.toArray(new UiccAccessRule[rulesList.size()]);
        }
        if (rules == null) {
            Log.e(TAG, "No access rules but caller is unprivileged");
            return false;
        }
        try {
            info = this.mPackageManager.getPackageInfo(callingPackage, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Calling package valid but gone");
            return false;
        }
        for (int i = 0; i < rules.length; ++i) {
            if (rules[i].getCarrierPrivilegeStatus(info) != 1) continue;
            Log.i(TAG, "Calling package has carrier privilege to this profile");
            return true;
        }
        Log.e(TAG, "Calling package doesn't have carrier privilege to this profile");
        return false;
    }

    private boolean supportMultiActiveSlots() {
        return this.mTelephonyManager.getPhoneCount() > 1;
    }

    private boolean canManageActiveSubscriptionOnTargetSim(int cardId, String callingPackage) {
        List<SubscriptionInfo> subInfoList = this.mSubscriptionManager.getActiveSubscriptionInfoList(false);
        if (subInfoList == null || subInfoList.size() == 0) {
            return false;
        }
        for (SubscriptionInfo subInfo : subInfoList) {
            if (cardId != -1 && subInfo.getCardId() != cardId || !subInfo.isEmbedded() || !this.mSubscriptionManager.canManageSubscription(subInfo, callingPackage)) continue;
            return true;
        }
        return false;
    }

    private boolean canManageSubscriptionOnTargetSim(int cardId, String callingPackage) {
        List<SubscriptionInfo> subInfoList = this.mSubscriptionManager.getActiveSubscriptionInfoList(false);
        if (subInfoList == null || subInfoList.size() == 0) {
            return false;
        }
        if (this.supportMultiActiveSlots()) {
            List<UiccCardInfo> cardInfos = this.mTelephonyManager.getUiccCardsInfo();
            if (cardInfos == null || cardInfos.isEmpty()) {
                return false;
            }
            boolean isEuicc = false;
            for (UiccCardInfo info : cardInfos) {
                if (info == null || info.getCardId() != cardId || !info.isEuicc()) continue;
                isEuicc = true;
                break;
            }
            if (!isEuicc) {
                Log.i(TAG, "The target SIM is not an eUICC.");
                return false;
            }
            for (SubscriptionInfo subInfo : subInfoList) {
                if (!subInfo.isEmbedded() || subInfo.getCardId() != cardId) continue;
                return this.mSubscriptionManager.canManageSubscription(subInfo, callingPackage);
            }
            return this.mTelephonyManager.checkCarrierPrivilegesForPackageAnyPhone(callingPackage) == 1;
        }
        for (SubscriptionInfo subInfo : subInfoList) {
            if (!subInfo.isEmbedded() || !this.mSubscriptionManager.canManageSubscription(subInfo, callingPackage)) continue;
            return true;
        }
        return false;
    }

    private boolean callerCanReadPhoneStatePrivileged() {
        return this.mContext.checkCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE") == 0;
    }

    private boolean callerCanWriteEmbeddedSubscriptions() {
        return this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_EMBEDDED_SUBSCRIPTIONS") == 0;
    }

    class GetDefaultListCommandCallback
    implements EuiccConnector.GetDefaultListCommandCallback {
        final long mCallingToken;
        final String mCallingPackage;
        final PendingIntent mCallbackIntent;

        GetDefaultListCommandCallback(long callingToken, String callingPackage, PendingIntent callbackIntent) {
            this.mCallingToken = callingToken;
            this.mCallingPackage = callingPackage;
            this.mCallbackIntent = callbackIntent;
        }

        @Override
        public void onGetDefaultListComplete(int cardId, GetDefaultDownloadableSubscriptionListResult result) {
            int resultCode;
            Intent extrasIntent = new Intent();
            switch (result.getResult()) {
                case 0: {
                    resultCode = 0;
                    List<DownloadableSubscription> list = result.getDownloadableSubscriptions();
                    if (list == null || list.size() <= 0) break;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTIONS", list.toArray(new DownloadableSubscription[list.size()]));
                    break;
                }
                case -1: {
                    resultCode = 1;
                    EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", this.mCallingPackage, 0, false, EuiccOperation.forGetDefaultListDeactivateSim(this.mCallingToken, this.mCallingPackage), cardId);
                    break;
                }
                default: {
                    resultCode = 2;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result.getResult());
                }
            }
            EuiccController.this.sendResult(this.mCallbackIntent, resultCode, extrasIntent);
        }

        @Override
        public void onEuiccServiceUnavailable() {
            EuiccController.this.sendResult(this.mCallbackIntent, 2, null);
        }
    }

    class DownloadSubscriptionGetMetadataCommandCallback
    extends GetMetadataCommandCallback {
        private final boolean mSwitchAfterDownload;
        private final boolean mForceDeactivateSim;
        private final boolean mWithUserConsent;

        DownloadSubscriptionGetMetadataCommandCallback(long callingToken, DownloadableSubscription subscription, boolean switchAfterDownload, String callingPackage, boolean forceDeactivateSim, PendingIntent callbackIntent, boolean withUserConsent) {
            super(callingToken, subscription, callingPackage, callbackIntent);
            this.mSwitchAfterDownload = switchAfterDownload;
            this.mForceDeactivateSim = forceDeactivateSim;
            this.mWithUserConsent = withUserConsent;
        }

        @Override
        public void onGetMetadataComplete(int cardId, GetDownloadableSubscriptionMetadataResult result) {
            DownloadableSubscription subscription = result.getDownloadableSubscription();
            if (this.mWithUserConsent) {
                if (result.getResult() != 0) {
                    super.onGetMetadataComplete(cardId, result);
                    return;
                }
                if (EuiccController.this.checkCarrierPrivilegeInMetadata(subscription, this.mCallingPackage)) {
                    EuiccController.this.downloadSubscriptionPrivileged(cardId, this.mCallingToken, subscription, this.mSwitchAfterDownload, this.mForceDeactivateSim, this.mCallingPackage, null, this.mCallbackIntent);
                } else {
                    Log.e(EuiccController.TAG, "Caller does not have carrier privilege in metadata.");
                    EuiccController.this.sendResult(this.mCallbackIntent, 2, null);
                }
            } else {
                if (result.getResult() == -1) {
                    Intent extrasIntent = new Intent();
                    EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", this.mCallingPackage, 0, false, EuiccOperation.forDownloadNoPrivilegesOrDeactivateSimCheckMetadata(this.mCallingToken, this.mSubscription, this.mSwitchAfterDownload, this.mCallingPackage), cardId);
                    EuiccController.this.sendResult(this.mCallbackIntent, 1, extrasIntent);
                    return;
                }
                if (result.getResult() != 0) {
                    super.onGetMetadataComplete(cardId, result);
                    return;
                }
                if (EuiccController.this.checkCarrierPrivilegeInMetadata(subscription, this.mCallingPackage)) {
                    EuiccController.this.downloadSubscriptionPrivileged(cardId, this.mCallingToken, subscription, this.mSwitchAfterDownload, this.mForceDeactivateSim, this.mCallingPackage, null, this.mCallbackIntent);
                } else {
                    Log.e(EuiccController.TAG, "Caller is not permitted to download this profile per metadata");
                    EuiccController.this.sendResult(this.mCallbackIntent, 2, null);
                }
            }
        }
    }

    class GetMetadataCommandCallback
    implements EuiccConnector.GetMetadataCommandCallback {
        protected final long mCallingToken;
        protected final DownloadableSubscription mSubscription;
        protected final String mCallingPackage;
        protected final PendingIntent mCallbackIntent;

        GetMetadataCommandCallback(long callingToken, DownloadableSubscription subscription, String callingPackage, PendingIntent callbackIntent) {
            this.mCallingToken = callingToken;
            this.mSubscription = subscription;
            this.mCallingPackage = callingPackage;
            this.mCallbackIntent = callbackIntent;
        }

        @Override
        public void onGetMetadataComplete(int cardId, GetDownloadableSubscriptionMetadataResult result) {
            int resultCode;
            Intent extrasIntent = new Intent();
            switch (result.getResult()) {
                case 0: {
                    resultCode = 0;
                    extrasIntent.putExtra(EuiccController.EXTRA_EMBEDDED_SUBSCRIPTION_DOWNLOADABLE_SUBSCRIPTION, result.getDownloadableSubscription());
                    break;
                }
                case -1: {
                    resultCode = 1;
                    EuiccController.this.addResolutionIntent(extrasIntent, "android.service.euicc.action.RESOLVE_DEACTIVATE_SIM", this.mCallingPackage, 0, false, this.getOperationForDeactivateSim(), cardId);
                    break;
                }
                default: {
                    resultCode = 2;
                    extrasIntent.putExtra("android.telephony.euicc.extra.EMBEDDED_SUBSCRIPTION_DETAILED_CODE", result.getResult());
                }
            }
            EuiccController.this.sendResult(this.mCallbackIntent, resultCode, extrasIntent);
        }

        @Override
        public void onEuiccServiceUnavailable() {
            EuiccController.this.sendResult(this.mCallbackIntent, 2, null);
        }

        protected EuiccOperation getOperationForDeactivateSim() {
            return EuiccOperation.forGetMetadataDeactivateSim(this.mCallingToken, this.mSubscription, this.mCallingPackage);
        }
    }
}

