/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.os.RemoteException;
import android.telephony.ims.stub.ImsConfigImplBase;
import android.util.Log;
import com.android.ims.internal.IImsConfig;

public class ImsConfigCompatAdapter
extends ImsConfigImplBase {
    private static final String TAG = "ImsConfigCompatAdapter";
    private final IImsConfig mOldConfigInterface;
    public static final int UNKNOWN = -1;
    public static final int SUCCESS = 0;
    public static final int FAILED = 1;

    public ImsConfigCompatAdapter(IImsConfig config) {
        this.mOldConfigInterface = config;
    }

    @Override
    public int setConfig(int item, int value) {
        try {
            if (this.mOldConfigInterface.setProvisionedValue(item, value) == 0) {
                return 0;
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "setConfig: item=" + item + " value=" + value + "failed: " + e.getMessage());
        }
        return 1;
    }

    @Override
    public int setConfig(int item, String value) {
        try {
            if (this.mOldConfigInterface.setProvisionedStringValue(item, value) == 0) {
                return 0;
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "setConfig: item=" + item + " value=" + value + "failed: " + e.getMessage());
        }
        return 1;
    }

    @Override
    public int getConfigInt(int item) {
        try {
            int value = this.mOldConfigInterface.getProvisionedValue(item);
            if (value != -1) {
                return value;
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "getConfigInt: item=" + item + "failed: " + e.getMessage());
        }
        return -1;
    }

    @Override
    public String getConfigString(int item) {
        try {
            return this.mOldConfigInterface.getProvisionedStringValue(item);
        }
        catch (RemoteException e) {
            Log.w(TAG, "getConfigInt: item=" + item + "failed: " + e.getMessage());
            return null;
        }
    }
}

