/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.telephony.CarrierConfigManager;
import android.telephony.SubscriptionManager;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRcsFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.stub.ImsFeatureConfiguration;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.android.ims.internal.IImsServiceFeatureCallback;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.SomeArgs;
import com.android.internal.telephony.ims.ImsServiceController;
import com.android.internal.telephony.ims.ImsServiceControllerCompat;
import com.android.internal.telephony.ims.ImsServiceControllerStaticCompat;
import com.android.internal.telephony.ims.ImsServiceFeatureQueryManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ImsResolver
implements ImsServiceController.ImsServiceControllerCallbacks {
    private static final String TAG = "ImsResolver";
    public static final String METADATA_EMERGENCY_MMTEL_FEATURE = "android.telephony.ims.EMERGENCY_MMTEL_FEATURE";
    public static final String METADATA_MMTEL_FEATURE = "android.telephony.ims.MMTEL_FEATURE";
    public static final String METADATA_RCS_FEATURE = "android.telephony.ims.RCS_FEATURE";
    private static final String METADATA_OVERRIDE_PERM_CHECK = "override_bind_check";
    private static final int HANDLER_ADD_PACKAGE = 0;
    private static final int HANDLER_REMOVE_PACKAGE = 1;
    private static final int HANDLER_CONFIG_CHANGED = 2;
    private static final int HANDLER_START_DYNAMIC_FEATURE_QUERY = 3;
    private static final int HANDLER_DYNAMIC_FEATURE_CHANGE = 4;
    private static final int HANDLER_OVERRIDE_IMS_SERVICE_CONFIG = 5;
    private static final int DELAY_DYNAMIC_QUERY_MS = 5000;
    private BroadcastReceiver mAppChangedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            String packageName = intent.getData().getSchemeSpecificPart();
            switch (action) {
                case "android.intent.action.PACKAGE_ADDED": 
                case "android.intent.action.PACKAGE_REPLACED": 
                case "android.intent.action.PACKAGE_CHANGED": {
                    ImsResolver.this.mHandler.obtainMessage(0, packageName).sendToTarget();
                    break;
                }
                case "android.intent.action.PACKAGE_REMOVED": {
                    ImsResolver.this.mHandler.obtainMessage(1, packageName).sendToTarget();
                    break;
                }
                default: {
                    return;
                }
            }
        }
    };
    private BroadcastReceiver mConfigChangedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            int slotId = intent.getIntExtra("android.telephony.extra.SLOT_INDEX", -1);
            if (slotId == -1) {
                Log.i(ImsResolver.TAG, "Received SIM change for invalid slot id.");
                return;
            }
            Log.i(ImsResolver.TAG, "Received Carrier Config Changed for SlotId: " + slotId);
            ImsResolver.this.mHandler.obtainMessage(2, slotId).sendToTarget();
        }
    };
    private SubscriptionManagerProxy mSubscriptionManagerProxy = new SubscriptionManagerProxy(){

        @Override
        public int getSubId(int slotId) {
            int[] subIds = SubscriptionManager.getSubId(slotId);
            if (subIds != null) {
                return subIds[0];
            }
            return -1;
        }

        @Override
        public int getSlotIndex(int subId) {
            return SubscriptionManager.getSlotIndex(subId);
        }
    };
    private ImsServiceControllerFactory mImsServiceControllerFactory = new ImsServiceControllerFactory(){

        @Override
        public String getServiceInterface() {
            return "android.telephony.ims.ImsService";
        }

        @Override
        public ImsServiceController create(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks callbacks) {
            return new ImsServiceController(context, componentName, callbacks);
        }
    };
    private ImsServiceControllerFactory mImsServiceControllerFactoryCompat = new ImsServiceControllerFactory(){

        @Override
        public String getServiceInterface() {
            return "android.telephony.ims.compat.ImsService";
        }

        @Override
        public ImsServiceController create(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks callbacks) {
            return new ImsServiceControllerCompat(context, componentName, callbacks);
        }
    };
    private ImsServiceControllerFactory mImsServiceControllerFactoryStaticBindingCompat = new ImsServiceControllerFactory(){

        @Override
        public String getServiceInterface() {
            return null;
        }

        @Override
        public ImsServiceController create(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks callbacks) {
            return new ImsServiceControllerStaticCompat(context, componentName, callbacks);
        }
    };
    private ImsDynamicQueryManagerFactory mDynamicQueryManagerFactory = ImsServiceFeatureQueryManager::new;
    private final CarrierConfigManager mCarrierConfigManager;
    private final Context mContext;
    private final Object mBoundServicesLock = new Object();
    private final int mNumSlots;
    private final boolean mIsDynamicBinding;
    private String mDeviceService;
    private Handler mHandler = new Handler(Looper.getMainLooper(), msg -> {
        switch (msg.what) {
            case 0: {
                String packageName = (String)msg.obj;
                this.maybeAddedImsService(packageName);
                break;
            }
            case 1: {
                String packageName = (String)msg.obj;
                this.maybeRemovedImsService(packageName);
                break;
            }
            case 2: {
                int slotId = (Integer)msg.obj;
                this.carrierConfigChanged(slotId);
                break;
            }
            case 3: {
                ImsServiceInfo info = (ImsServiceInfo)msg.obj;
                this.startDynamicQuery(info);
                break;
            }
            case 4: {
                SomeArgs args = (SomeArgs)msg.obj;
                ComponentName name = (ComponentName)args.arg1;
                Set features = (Set)args.arg2;
                args.recycle();
                this.dynamicQueryComplete(name, features);
                break;
            }
            case 5: {
                int slotId = msg.arg1;
                boolean isCarrierImsService = msg.arg2 == 1;
                String packageName = (String)msg.obj;
                if (isCarrierImsService) {
                    Log.i(TAG, "overriding carrier ImsService - slot=" + slotId + " packageName=" + packageName);
                    this.maybeRebindService(slotId, packageName);
                    break;
                }
                Log.i(TAG, "overriding device ImsService -  packageName=" + packageName);
                if (TextUtils.equals(this.mDeviceService, packageName)) break;
                this.unbindImsService(this.getImsServiceInfoFromCache(this.mDeviceService));
                this.mDeviceService = packageName;
                ImsServiceInfo deviceInfo = this.getImsServiceInfoFromCache(this.mDeviceService);
                if (deviceInfo == null) break;
                if (deviceInfo.featureFromMetadata) {
                    this.bindImsService(deviceInfo);
                    break;
                }
                this.scheduleQueryForFeatures(deviceInfo);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    });
    private ImsServiceFeatureQueryManager.Listener mDynamicQueryListener = new ImsServiceFeatureQueryManager.Listener(){

        @Override
        public void onComplete(ComponentName name, Set<ImsFeatureConfiguration.FeatureSlotPair> features) {
            Log.d(ImsResolver.TAG, "onComplete called for name: " + name + "features:" + ImsResolver.this.printFeatures(features));
            ImsResolver.this.handleFeaturesChanged(name, features);
        }

        @Override
        public void onError(ComponentName name) {
            Log.w(ImsResolver.TAG, "onError: " + name + "returned with an error result");
            ImsResolver.this.scheduleQueryForFeatures(name, 5000);
        }
    };
    private String[] mCarrierServices;
    private List<SparseArray<ImsServiceController>> mBoundImsServicesByFeature;
    private Map<ComponentName, ImsServiceInfo> mInstalledServicesCache = new HashMap<ComponentName, ImsServiceInfo>();
    private Map<ComponentName, ImsServiceController> mActiveControllers = new HashMap<ComponentName, ImsServiceController>();
    private final ComponentName mStaticComponent;
    private ImsServiceFeatureQueryManager mFeatureQueryManager;

    public ImsResolver(Context context, String defaultImsPackageName, int numSlots, boolean isDynamicBinding) {
        this.mContext = context;
        this.mDeviceService = defaultImsPackageName;
        this.mNumSlots = numSlots;
        this.mIsDynamicBinding = isDynamicBinding;
        this.mStaticComponent = new ComponentName(this.mContext, ImsResolver.class);
        if (!this.mIsDynamicBinding) {
            Log.i(TAG, "ImsResolver initialized with static binding.");
            this.mDeviceService = this.mStaticComponent.getPackageName();
        }
        this.mCarrierConfigManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        this.mCarrierServices = new String[numSlots];
        this.mBoundImsServicesByFeature = Stream.generate(SparseArray::new).limit(this.mNumSlots).collect(Collectors.toList());
        if (this.mIsDynamicBinding) {
            IntentFilter appChangedFilter = new IntentFilter();
            appChangedFilter.addAction("android.intent.action.PACKAGE_CHANGED");
            appChangedFilter.addAction("android.intent.action.PACKAGE_REMOVED");
            appChangedFilter.addAction("android.intent.action.PACKAGE_ADDED");
            appChangedFilter.addDataScheme("package");
            context.registerReceiverAsUser(this.mAppChangedReceiver, UserHandle.ALL, appChangedFilter, null, null);
            context.registerReceiver(this.mConfigChangedReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
        }
    }

    @VisibleForTesting
    public void setSubscriptionManagerProxy(SubscriptionManagerProxy proxy) {
        this.mSubscriptionManagerProxy = proxy;
    }

    @VisibleForTesting
    public void setImsServiceControllerFactory(ImsServiceControllerFactory factory) {
        this.mImsServiceControllerFactory = factory;
    }

    @VisibleForTesting
    public Handler getHandler() {
        return this.mHandler;
    }

    @VisibleForTesting
    public void setImsDynamicQueryManagerFactory(ImsDynamicQueryManagerFactory m) {
        this.mDynamicQueryManagerFactory = m;
    }

    public void initPopulateCacheAndStartBind() {
        Log.i(TAG, "Initializing cache and binding.");
        this.mFeatureQueryManager = this.mDynamicQueryManagerFactory.create(this.mContext, this.mDynamicQueryListener);
        this.mHandler.obtainMessage(2, -1).sendToTarget();
        this.mHandler.obtainMessage(0, null).sendToTarget();
    }

    public void enableIms(int slotId) {
        SparseArray<ImsServiceController> controllers = this.getImsServiceControllers(slotId);
        if (controllers != null) {
            for (int i = 0; i < controllers.size(); ++i) {
                int key = controllers.keyAt(i);
                controllers.get(key).enableIms(slotId);
            }
        }
    }

    public void disableIms(int slotId) {
        SparseArray<ImsServiceController> controllers = this.getImsServiceControllers(slotId);
        if (controllers != null) {
            for (int i = 0; i < controllers.size(); ++i) {
                int key = controllers.keyAt(i);
                controllers.get(key).disableIms(slotId);
            }
        }
    }

    public IImsMmTelFeature getMmTelFeatureAndListen(int slotId, IImsServiceFeatureCallback callback) {
        ImsServiceController controller = this.getImsServiceControllerAndListen(slotId, 1, callback);
        return controller != null ? controller.getMmTelFeature(slotId) : null;
    }

    public IImsRcsFeature getRcsFeatureAndListen(int slotId, IImsServiceFeatureCallback callback) {
        ImsServiceController controller = this.getImsServiceControllerAndListen(slotId, 2, callback);
        return controller != null ? controller.getRcsFeature(slotId) : null;
    }

    public IImsRegistration getImsRegistration(int slotId, int feature) throws RemoteException {
        ImsServiceController controller = this.getImsServiceController(slotId, feature);
        if (controller != null) {
            return controller.getRegistration(slotId);
        }
        return null;
    }

    public IImsConfig getImsConfig(int slotId, int feature) throws RemoteException {
        ImsServiceController controller = this.getImsServiceController(slotId, feature);
        if (controller != null) {
            return controller.getConfig(slotId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public ImsServiceController getImsServiceController(int slotId, int feature) {
        ImsServiceController controller;
        if (slotId < 0 || slotId >= this.mNumSlots) {
            return null;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                return null;
            }
            controller = services.get(feature);
        }
        return controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparseArray<ImsServiceController> getImsServiceControllers(int slotId) {
        if (slotId < 0 || slotId >= this.mNumSlots) {
            return null;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                return null;
            }
            return services;
        }
    }

    @VisibleForTesting
    public ImsServiceController getImsServiceControllerAndListen(int slotId, int feature, IImsServiceFeatureCallback callback) {
        ImsServiceController controller = this.getImsServiceController(slotId, feature);
        if (controller != null) {
            controller.addImsServiceFeatureCallback(callback);
            return controller;
        }
        return null;
    }

    public boolean overrideImsServiceConfiguration(int slotId, boolean isCarrierService, String packageName) {
        if (slotId < 0 || slotId >= this.mNumSlots) {
            Log.w(TAG, "overrideImsServiceConfiguration: invalid slotId!");
            return false;
        }
        if (packageName == null) {
            Log.w(TAG, "overrideImsServiceConfiguration: null packageName!");
            return false;
        }
        int carrierService = isCarrierService ? 1 : 0;
        Message.obtain(this.mHandler, 5, slotId, carrierService, packageName).sendToTarget();
        return true;
    }

    public String getImsServiceConfiguration(int slotId, boolean isCarrierService) {
        if (slotId < 0 || slotId >= this.mNumSlots) {
            Log.w(TAG, "getImsServiceConfiguration: invalid slotId!");
            return "";
        }
        return isCarrierService ? this.mCarrierServices[slotId] : this.mDeviceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putImsController(int slotId, int feature, ImsServiceController controller) {
        if (slotId < 0 || slotId >= this.mNumSlots || feature <= -1 || feature >= 3) {
            Log.w(TAG, "putImsController received invalid parameters - slot: " + slotId + ", feature: " + feature);
            return;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                services = new SparseArray();
                this.mBoundImsServicesByFeature.add(slotId, services);
            }
            Log.i(TAG, "ImsServiceController added on slot: " + slotId + " with feature: " + feature + " using package: " + controller.getComponentName());
            services.put(feature, controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImsServiceController removeImsController(int slotId, int feature) {
        if (slotId < 0 || slotId >= this.mNumSlots || feature <= -1 || feature >= 3) {
            Log.w(TAG, "removeImsController received invalid parameters - slot: " + slotId + ", feature: " + feature);
            return null;
        }
        Object object = this.mBoundServicesLock;
        synchronized (object) {
            SparseArray<ImsServiceController> services = this.mBoundImsServicesByFeature.get(slotId);
            if (services == null) {
                return null;
            }
            ImsServiceController c = services.get(feature, null);
            if (c != null) {
                Log.i(TAG, "ImsServiceController removed on slot: " + slotId + " with feature: " + feature + " using package: " + c.getComponentName());
                services.remove(feature);
            }
            return c;
        }
    }

    private void maybeAddedImsService(String packageName) {
        Log.d(TAG, "maybeAddedImsService, packageName: " + packageName);
        List<ImsServiceInfo> infos = this.getImsServiceInfo(packageName);
        ArrayList<ImsServiceInfo> newlyAddedInfos = new ArrayList<ImsServiceInfo>();
        for (ImsServiceInfo info : infos) {
            ImsServiceInfo match = this.getInfoByComponentName(this.mInstalledServicesCache, info.name);
            if (match != null) {
                if (info.featureFromMetadata) {
                    Log.i(TAG, "Updating features in cached ImsService: " + info.name);
                    Log.d(TAG, "Updating features - Old features: " + match + " new features: " + info);
                    match.replaceFeatures(info.getSupportedFeatures());
                    this.updateImsServiceFeatures(info);
                    continue;
                }
                this.scheduleQueryForFeatures(info);
                continue;
            }
            Log.i(TAG, "Adding newly added ImsService to cache: " + info.name);
            this.mInstalledServicesCache.put(info.name, info);
            if (info.featureFromMetadata) {
                newlyAddedInfos.add(info);
                continue;
            }
            this.scheduleQueryForFeatures(info);
        }
        for (ImsServiceInfo info : newlyAddedInfos) {
            if (this.isActiveCarrierService(info)) {
                this.bindImsService(info);
                this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
                continue;
            }
            if (!this.isDeviceService(info)) continue;
            this.bindImsService(info);
        }
    }

    private boolean maybeRemovedImsService(String packageName) {
        ImsServiceInfo match = this.getInfoByPackageName(this.mInstalledServicesCache, packageName);
        if (match != null) {
            this.mInstalledServicesCache.remove(match.name);
            Log.i(TAG, "Removing ImsService: " + match.name);
            this.unbindImsService(match);
            this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
            return true;
        }
        return false;
    }

    private boolean isActiveCarrierService(ImsServiceInfo info) {
        for (int i = 0; i < this.mNumSlots; ++i) {
            if (!TextUtils.equals(this.mCarrierServices[i], info.name.getPackageName())) continue;
            return true;
        }
        return false;
    }

    private boolean isDeviceService(ImsServiceInfo info) {
        return TextUtils.equals(this.mDeviceService, info.name.getPackageName());
    }

    private int getSlotForActiveCarrierService(ImsServiceInfo info) {
        for (int i = 0; i < this.mNumSlots; ++i) {
            if (!TextUtils.equals(this.mCarrierServices[i], info.name.getPackageName())) continue;
            return i;
        }
        return -1;
    }

    private ImsServiceController getControllerByServiceInfo(Map<ComponentName, ImsServiceController> searchMap, ImsServiceInfo matchValue) {
        return searchMap.values().stream().filter(c -> Objects.equals(c.getComponentName(), matchValue.name)).findFirst().orElse(null);
    }

    private ImsServiceInfo getInfoByPackageName(Map<ComponentName, ImsServiceInfo> searchMap, String matchValue) {
        return searchMap.values().stream().filter(i -> Objects.equals(i.name.getPackageName(), matchValue)).findFirst().orElse(null);
    }

    private ImsServiceInfo getInfoByComponentName(Map<ComponentName, ImsServiceInfo> searchMap, ComponentName matchValue) {
        return searchMap.get(matchValue);
    }

    private void updateImsServiceFeatures(ImsServiceInfo newInfo) {
        if (newInfo == null) {
            return;
        }
        ImsServiceController controller = this.getControllerByServiceInfo(this.mActiveControllers, newInfo);
        HashSet<ImsFeatureConfiguration.FeatureSlotPair> features = this.calculateFeaturesToCreate(newInfo);
        if (this.shouldFeaturesCauseBind(features)) {
            try {
                if (controller != null) {
                    Log.i(TAG, "Updating features for ImsService: " + controller.getComponentName());
                    Log.d(TAG, "Updating Features - New Features: " + features);
                    controller.changeImsServiceFeatures(features);
                } else {
                    Log.i(TAG, "updateImsServiceFeatures: unbound with active features, rebinding");
                    this.bindImsServiceWithFeatures(newInfo, features);
                }
                if (this.isActiveCarrierService(newInfo) && !TextUtils.equals(newInfo.name.getPackageName(), this.mDeviceService)) {
                    Log.i(TAG, "Updating device default");
                    this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "updateImsServiceFeatures: Remote Exception: " + e.getMessage());
            }
        } else if (controller != null) {
            Log.i(TAG, "Unbinding: features = 0 for ImsService: " + controller.getComponentName());
            this.unbindImsService(newInfo);
        }
    }

    private void bindImsService(ImsServiceInfo info) {
        if (info == null) {
            return;
        }
        HashSet<ImsFeatureConfiguration.FeatureSlotPair> features = this.calculateFeaturesToCreate(info);
        this.bindImsServiceWithFeatures(info, features);
    }

    private void bindImsServiceWithFeatures(ImsServiceInfo info, HashSet<ImsFeatureConfiguration.FeatureSlotPair> features) {
        if (this.shouldFeaturesCauseBind(features)) {
            ImsServiceController controller = this.getControllerByServiceInfo(this.mActiveControllers, info);
            if (controller != null) {
                Log.i(TAG, "ImsService connection exists, updating features " + features);
                try {
                    controller.changeImsServiceFeatures(features);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "bindImsService: error=" + e.getMessage());
                }
            } else {
                controller = info.controllerFactory.create(this.mContext, info.name, this);
                Log.i(TAG, "Binding ImsService: " + controller.getComponentName() + " with features: " + features);
                controller.bind(features);
            }
            this.mActiveControllers.put(info.name, controller);
        }
    }

    private void unbindImsService(ImsServiceInfo info) {
        if (info == null) {
            return;
        }
        ImsServiceController controller = this.getControllerByServiceInfo(this.mActiveControllers, info);
        if (controller != null) {
            try {
                Log.i(TAG, "Unbinding ImsService: " + controller.getComponentName());
                controller.unbind();
            }
            catch (RemoteException e) {
                Log.e(TAG, "unbindImsService: Remote Exception: " + e.getMessage());
            }
            this.mActiveControllers.remove(info.name);
        }
    }

    private HashSet<ImsFeatureConfiguration.FeatureSlotPair> calculateFeaturesToCreate(ImsServiceInfo info) {
        HashSet<ImsFeatureConfiguration.FeatureSlotPair> imsFeaturesBySlot = new HashSet<ImsFeatureConfiguration.FeatureSlotPair>();
        int slotId = this.getSlotForActiveCarrierService(info);
        if (slotId != -1) {
            imsFeaturesBySlot.addAll(info.getSupportedFeatures().stream().filter(feature -> slotId == feature.slotId).collect(Collectors.toList()));
        } else if (this.isDeviceService(info)) {
            for (int i = 0; i < this.mNumSlots; ++i) {
                int currSlotId = i;
                ImsServiceInfo carrierImsInfo = this.getImsServiceInfoFromCache(this.mCarrierServices[i]);
                if (carrierImsInfo == null) {
                    imsFeaturesBySlot.addAll(info.getSupportedFeatures().stream().filter(feature -> currSlotId == feature.slotId).collect(Collectors.toList()));
                    continue;
                }
                HashSet<ImsFeatureConfiguration.FeatureSlotPair> deviceFeatures = new HashSet<ImsFeatureConfiguration.FeatureSlotPair>(info.getSupportedFeatures());
                deviceFeatures.removeAll(carrierImsInfo.getSupportedFeatures());
                imsFeaturesBySlot.addAll(deviceFeatures.stream().filter(feature -> currSlotId == feature.slotId).collect(Collectors.toList()));
            }
        }
        return imsFeaturesBySlot;
    }

    @Override
    public void imsServiceFeatureCreated(int slotId, int feature, ImsServiceController controller) {
        this.putImsController(slotId, feature, controller);
    }

    @Override
    public void imsServiceFeatureRemoved(int slotId, int feature, ImsServiceController controller) {
        this.removeImsController(slotId, feature);
    }

    @Override
    public void imsServiceFeaturesChanged(ImsFeatureConfiguration config, ImsServiceController controller) {
        if (controller == null || config == null) {
            return;
        }
        Log.i(TAG, "imsServiceFeaturesChanged: config=" + config.getServiceFeatures() + ", ComponentName=" + controller.getComponentName());
        this.handleFeaturesChanged(controller.getComponentName(), config.getServiceFeatures());
    }

    private boolean shouldFeaturesCauseBind(HashSet<ImsFeatureConfiguration.FeatureSlotPair> features) {
        long bindableFeatures = features.stream().filter(f -> f.featureType != 0).count();
        return bindableFeatures > 0L;
    }

    private void maybeRebindService(int slotId, String newPackageName) {
        if (slotId <= -1) {
            for (int i = 0; i < this.mNumSlots; ++i) {
                this.updateBoundCarrierServices(i, newPackageName);
            }
        } else {
            this.updateBoundCarrierServices(slotId, newPackageName);
        }
    }

    private void carrierConfigChanged(int slotId) {
        int subId = this.mSubscriptionManagerProxy.getSubId(slotId);
        PersistableBundle config = this.mCarrierConfigManager.getConfigForSubId(subId);
        if (config != null) {
            String newPackageName = config.getString("config_ims_package_override_string", null);
            this.maybeRebindService(slotId, newPackageName);
        } else {
            Log.w(TAG, "carrierConfigChanged: CarrierConfig is null!");
        }
    }

    private void updateBoundCarrierServices(int slotId, String newPackageName) {
        if (slotId > -1 && slotId < this.mNumSlots) {
            String oldPackageName = this.mCarrierServices[slotId];
            this.mCarrierServices[slotId] = newPackageName;
            if (!TextUtils.equals(newPackageName, oldPackageName)) {
                Log.i(TAG, "Carrier Config updated, binding new ImsService");
                this.unbindImsService(this.getImsServiceInfoFromCache(oldPackageName));
                ImsServiceInfo newInfo = this.getImsServiceInfoFromCache(newPackageName);
                if (newInfo == null || newInfo.featureFromMetadata) {
                    this.bindImsService(newInfo);
                    this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
                } else {
                    this.scheduleQueryForFeatures(newInfo);
                }
            }
        }
    }

    private void scheduleQueryForFeatures(ImsServiceInfo service, int delayMs) {
        if (!this.isDeviceService(service) && this.getSlotForActiveCarrierService(service) == -1) {
            Log.i(TAG, "scheduleQueryForFeatures: skipping query for ImsService that is not set as carrier/device ImsService.");
            return;
        }
        Message msg = Message.obtain(this.mHandler, 3, service);
        if (this.mHandler.hasMessages(3, service)) {
            Log.d(TAG, "scheduleQueryForFeatures: dynamic query for " + service.name + " already scheduled");
            return;
        }
        Log.d(TAG, "scheduleQueryForFeatures: starting dynamic query for " + service.name + " in " + delayMs + "ms.");
        this.mHandler.sendMessageDelayed(msg, delayMs);
    }

    private void scheduleQueryForFeatures(ComponentName name, int delayMs) {
        ImsServiceInfo service = this.getImsServiceInfoFromCache(name.getPackageName());
        if (service == null) {
            Log.w(TAG, "scheduleQueryForFeatures: Couldn't find cached info for name: " + name);
            return;
        }
        this.scheduleQueryForFeatures(service, delayMs);
    }

    private void scheduleQueryForFeatures(ImsServiceInfo service) {
        this.scheduleQueryForFeatures(service, 0);
    }

    private void handleFeaturesChanged(ComponentName name, Set<ImsFeatureConfiguration.FeatureSlotPair> features) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = name;
        args.arg2 = features;
        this.mHandler.obtainMessage(4, args).sendToTarget();
    }

    private void startDynamicQuery(ImsServiceInfo service) {
        boolean queryStarted = this.mFeatureQueryManager.startQuery(service.name, service.controllerFactory.getServiceInterface());
        if (!queryStarted) {
            Log.w(TAG, "startDynamicQuery: service could not connect. Retrying after delay.");
            this.scheduleQueryForFeatures(service, 5000);
        } else {
            Log.d(TAG, "startDynamicQuery: Service queried, waiting for response.");
        }
    }

    private void dynamicQueryComplete(ComponentName name, Set<ImsFeatureConfiguration.FeatureSlotPair> features) {
        ImsServiceInfo service = this.getImsServiceInfoFromCache(name.getPackageName());
        if (service == null) {
            Log.w(TAG, "handleFeaturesChanged: Couldn't find cached info for name: " + name);
            return;
        }
        service.replaceFeatures(features);
        if (this.isActiveCarrierService(service)) {
            this.bindImsService(service);
            this.updateImsServiceFeatures(this.getImsServiceInfoFromCache(this.mDeviceService));
        } else if (this.isDeviceService(service)) {
            this.bindImsService(service);
        }
    }

    private String printFeatures(Set<ImsFeatureConfiguration.FeatureSlotPair> features) {
        StringBuilder featureString = new StringBuilder();
        featureString.append("features: [");
        if (features != null) {
            for (ImsFeatureConfiguration.FeatureSlotPair feature : features) {
                featureString.append("{");
                featureString.append(feature.slotId);
                featureString.append(",");
                featureString.append(feature.featureType);
                featureString.append("} ");
            }
            featureString.append("]");
        }
        return featureString.toString();
    }

    @VisibleForTesting
    public ImsServiceInfo getImsServiceInfoFromCache(String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return null;
        }
        ImsServiceInfo infoFilter = this.getInfoByPackageName(this.mInstalledServicesCache, packageName);
        if (infoFilter != null) {
            return infoFilter;
        }
        return null;
    }

    private List<ImsServiceInfo> getImsServiceInfo(String packageName) {
        ArrayList<ImsServiceInfo> infos = new ArrayList<ImsServiceInfo>();
        if (!this.mIsDynamicBinding) {
            infos.addAll(this.getStaticImsService());
        } else {
            infos.addAll(this.searchForImsServices(packageName, this.mImsServiceControllerFactory));
            infos.addAll(this.searchForImsServices(packageName, this.mImsServiceControllerFactoryCompat));
        }
        return infos;
    }

    private List<ImsServiceInfo> getStaticImsService() {
        ArrayList<ImsServiceInfo> infos = new ArrayList<ImsServiceInfo>();
        ImsServiceInfo info = new ImsServiceInfo(this.mNumSlots);
        info.name = this.mStaticComponent;
        info.controllerFactory = this.mImsServiceControllerFactoryStaticBindingCompat;
        info.addFeatureForAllSlots(0);
        info.addFeatureForAllSlots(1);
        infos.add(info);
        return infos;
    }

    private List<ImsServiceInfo> searchForImsServices(String packageName, ImsServiceControllerFactory controllerFactory) {
        ArrayList<ImsServiceInfo> infos = new ArrayList<ImsServiceInfo>();
        Intent serviceIntent = new Intent(controllerFactory.getServiceInterface());
        serviceIntent.setPackage(packageName);
        PackageManager packageManager = this.mContext.getPackageManager();
        for (ResolveInfo entry : packageManager.queryIntentServicesAsUser(serviceIntent, 128, this.mContext.getUserId())) {
            ServiceInfo serviceInfo = entry.serviceInfo;
            if (serviceInfo == null) continue;
            ImsServiceInfo info = new ImsServiceInfo(this.mNumSlots);
            info.name = new ComponentName(serviceInfo.packageName, serviceInfo.name);
            info.controllerFactory = controllerFactory;
            if (this.isDeviceService(info) || this.mImsServiceControllerFactoryCompat == controllerFactory) {
                if (serviceInfo.metaData != null) {
                    if (serviceInfo.metaData.getBoolean(METADATA_EMERGENCY_MMTEL_FEATURE, false)) {
                        info.addFeatureForAllSlots(0);
                    }
                    if (serviceInfo.metaData.getBoolean(METADATA_MMTEL_FEATURE, false)) {
                        info.addFeatureForAllSlots(1);
                    }
                    if (serviceInfo.metaData.getBoolean(METADATA_RCS_FEATURE, false)) {
                        info.addFeatureForAllSlots(2);
                    }
                }
                if (this.mImsServiceControllerFactoryCompat != controllerFactory && info.getSupportedFeatures().isEmpty()) {
                    info.featureFromMetadata = false;
                }
            } else {
                info.featureFromMetadata = false;
            }
            Log.i(TAG, "service name: " + info.name + ", manifest query: " + info.featureFromMetadata);
            if (TextUtils.equals(serviceInfo.permission, "android.permission.BIND_IMS_SERVICE") || serviceInfo.metaData.getBoolean(METADATA_OVERRIDE_PERM_CHECK, false)) {
                infos.add(info);
                continue;
            }
            Log.w(TAG, "ImsService is not protected with BIND_IMS_SERVICE permission: " + info.name);
        }
        return infos;
    }

    @VisibleForTesting
    public static interface ImsDynamicQueryManagerFactory {
        public ImsServiceFeatureQueryManager create(Context var1, ImsServiceFeatureQueryManager.Listener var2);
    }

    @VisibleForTesting
    public static interface ImsServiceControllerFactory {
        public String getServiceInterface();

        public ImsServiceController create(Context var1, ComponentName var2, ImsServiceController.ImsServiceControllerCallbacks var3);
    }

    @VisibleForTesting
    public static interface SubscriptionManagerProxy {
        public int getSubId(int var1);

        public int getSlotIndex(int var1);
    }

    @VisibleForTesting
    public static class ImsServiceInfo {
        public ComponentName name;
        public boolean featureFromMetadata = true;
        public ImsServiceControllerFactory controllerFactory;
        private final HashSet<ImsFeatureConfiguration.FeatureSlotPair> mSupportedFeatures;
        private final int mNumSlots;

        public ImsServiceInfo(int numSlots) {
            this.mNumSlots = numSlots;
            this.mSupportedFeatures = new HashSet();
        }

        void addFeatureForAllSlots(int feature) {
            for (int i = 0; i < this.mNumSlots; ++i) {
                this.mSupportedFeatures.add(new ImsFeatureConfiguration.FeatureSlotPair(i, feature));
            }
        }

        void replaceFeatures(Set<ImsFeatureConfiguration.FeatureSlotPair> newFeatures) {
            this.mSupportedFeatures.clear();
            this.mSupportedFeatures.addAll(newFeatures);
        }

        @VisibleForTesting
        public HashSet<ImsFeatureConfiguration.FeatureSlotPair> getSupportedFeatures() {
            return this.mSupportedFeatures;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImsServiceInfo that = (ImsServiceInfo)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (!this.mSupportedFeatures.equals(that.mSupportedFeatures)) {
                return false;
            }
            return this.controllerFactory != null ? this.controllerFactory.equals(that.controllerFactory) : that.controllerFactory == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.controllerFactory != null ? this.controllerFactory.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder res = new StringBuilder();
            res.append("[ImsServiceInfo] name=");
            res.append(this.name);
            res.append(", supportedFeatures=[ ");
            for (ImsFeatureConfiguration.FeatureSlotPair feature : this.mSupportedFeatures) {
                res.append("(");
                res.append(feature.slotId);
                res.append(",");
                res.append(feature.featureType);
                res.append(") ");
            }
            return res.toString();
        }
    }
}

