/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.IPackageManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.ims.ImsService;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRcsFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.aidl.IImsServiceController;
import android.telephony.ims.stub.ImsFeatureConfiguration;
import android.util.Log;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.ims.internal.IImsServiceFeatureCallback;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.ExponentialBackoff;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ImsServiceController {
    private ImsService.Listener mFeatureChangedListener = new ImsService.Listener(){

        @Override
        public void onUpdateSupportedImsFeatures(ImsFeatureConfiguration c) {
            if (ImsServiceController.this.mCallbacks == null) {
                return;
            }
            ImsServiceController.this.mCallbacks.imsServiceFeaturesChanged(c, ImsServiceController.this);
        }
    };
    private static final String LOG_TAG = "ImsServiceController";
    private static final int REBIND_START_DELAY_MS = 2000;
    private static final int REBIND_MAXIMUM_DELAY_MS = 60000;
    private final ComponentName mComponentName;
    private final HandlerThread mHandlerThread = new HandlerThread("ImsServiceControllerHandler");
    private final IPackageManager mPackageManager;
    private ImsServiceControllerCallbacks mCallbacks;
    private ExponentialBackoff mBackoff;
    private boolean mIsBound = false;
    private boolean mIsBinding = false;
    private HashSet<ImsFeatureConfiguration.FeatureSlotPair> mImsFeatures;
    private HashSet<ImsFeatureContainer> mImsFeatureBinders = new HashSet();
    private IImsServiceController mIImsServiceController;
    private ImsServiceConnection mImsServiceConnection;
    private Set<IImsServiceFeatureCallback> mImsStatusCallbacks = ConcurrentHashMap.newKeySet();
    private Set<ImsFeatureStatusCallback> mFeatureStatusCallbacks = new HashSet<ImsFeatureStatusCallback>();
    protected final Object mLock = new Object();
    protected final Context mContext;
    private Runnable mRestartImsServiceRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ImsServiceController.this.mLock;
            synchronized (object) {
                if (ImsServiceController.this.mIsBound) {
                    return;
                }
                ImsServiceController.this.bind(ImsServiceController.this.mImsFeatures);
            }
        }
    };
    private RebindRetry mRebindRetry = new RebindRetry(){

        @Override
        public long getStartDelay() {
            return 2000L;
        }

        @Override
        public long getMaximumDelay() {
            return 60000L;
        }
    };

    public ImsServiceController(Context context, ComponentName componentName, ImsServiceControllerCallbacks callbacks) {
        this.mContext = context;
        this.mComponentName = componentName;
        this.mCallbacks = callbacks;
        this.mHandlerThread.start();
        this.mBackoff = new ExponentialBackoff(this.mRebindRetry.getStartDelay(), this.mRebindRetry.getMaximumDelay(), 2, this.mHandlerThread.getLooper(), this.mRestartImsServiceRunnable);
        this.mPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
    }

    @VisibleForTesting
    public ImsServiceController(Context context, ComponentName componentName, ImsServiceControllerCallbacks callbacks, Handler handler, RebindRetry rebindRetry) {
        this.mContext = context;
        this.mComponentName = componentName;
        this.mCallbacks = callbacks;
        this.mBackoff = new ExponentialBackoff(rebindRetry.getStartDelay(), rebindRetry.getMaximumDelay(), 2, handler, this.mRestartImsServiceRunnable);
        this.mPackageManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind(HashSet<ImsFeatureConfiguration.FeatureSlotPair> imsFeatureSet) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsBound && !this.mIsBinding) {
                this.mIsBinding = true;
                this.mImsFeatures = imsFeatureSet;
                this.grantPermissionsToService();
                Intent imsServiceIntent = new Intent(this.getServiceInterface()).setComponent(this.mComponentName);
                this.mImsServiceConnection = new ImsServiceConnection();
                int serviceFlags = 0x4000041;
                Log.i(LOG_TAG, "Binding ImsService:" + this.mComponentName);
                try {
                    boolean bindSucceeded = this.startBindToService(imsServiceIntent, this.mImsServiceConnection, serviceFlags);
                    if (!bindSucceeded) {
                        this.mIsBinding = false;
                        this.mBackoff.notifyFailed();
                    }
                    return bindSucceeded;
                }
                catch (Exception e) {
                    this.mBackoff.notifyFailed();
                    Log.e(LOG_TAG, "Error binding (" + this.mComponentName + ") with exception: " + e.getMessage() + ", rebinding in " + this.mBackoff.getCurrentDelay() + " ms");
                    return false;
                }
            }
            return false;
        }
    }

    protected boolean startBindToService(Intent intent, ImsServiceConnection connection, int flags) {
        return this.mContext.bindService(intent, connection, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.mBackoff.stop();
            if (this.mImsServiceConnection == null) {
                return;
            }
            this.changeImsServiceFeatures(new HashSet<ImsFeatureConfiguration.FeatureSlotPair>());
            this.removeImsServiceFeatureCallbacks();
            Log.i(LOG_TAG, "Unbinding ImsService: " + this.mComponentName);
            this.mContext.unbindService(this.mImsServiceConnection);
            this.cleanUpService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeImsServiceFeatures(HashSet<ImsFeatureConfiguration.FeatureSlotPair> newImsFeatures) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            Log.i(LOG_TAG, "Features changed (" + this.mImsFeatures + "->" + newImsFeatures + ") for ImsService: " + this.mComponentName);
            HashSet<ImsFeatureConfiguration.FeatureSlotPair> oldImsFeatures = new HashSet<ImsFeatureConfiguration.FeatureSlotPair>(this.mImsFeatures);
            this.mImsFeatures = newImsFeatures;
            if (this.mIsBound) {
                HashSet<ImsFeatureConfiguration.FeatureSlotPair> newFeatures = new HashSet<ImsFeatureConfiguration.FeatureSlotPair>(this.mImsFeatures);
                newFeatures.removeAll(oldImsFeatures);
                for (ImsFeatureConfiguration.FeatureSlotPair i : newFeatures) {
                    this.addImsServiceFeature(i);
                }
                HashSet<ImsFeatureConfiguration.FeatureSlotPair> oldFeatures = new HashSet<ImsFeatureConfiguration.FeatureSlotPair>(oldImsFeatures);
                oldFeatures.removeAll(this.mImsFeatures);
                for (ImsFeatureConfiguration.FeatureSlotPair i : oldFeatures) {
                    this.removeImsServiceFeature(i);
                }
            }
        }
    }

    @VisibleForTesting
    public IImsServiceController getImsServiceController() {
        return this.mIImsServiceController;
    }

    @VisibleForTesting
    public long getRebindDelay() {
        return this.mBackoff.getCurrentDelay();
    }

    @VisibleForTesting
    public void stopBackoffTimerForTesting() {
        this.mBackoff.stop();
    }

    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImsServiceFeatureCallback(IImsServiceFeatureCallback callback) {
        this.mImsStatusCallbacks.add(callback);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mImsFeatures == null || this.mImsFeatures.isEmpty()) {
                return;
            }
            try {
                for (ImsFeatureConfiguration.FeatureSlotPair i : this.mImsFeatures) {
                    callback.imsFeatureCreated(i.slotId, i.featureType);
                }
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, "addImsServiceFeatureCallback: exception notifying callback");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableIms(int slotId) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.isServiceControllerAvailable()) {
                    this.mIImsServiceController.enableIms(slotId);
                }
            }
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Couldn't enable IMS: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableIms(int slotId) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.isServiceControllerAvailable()) {
                    this.mIImsServiceController.disableIms(slotId);
                }
            }
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Couldn't disable IMS: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsMmTelFeature getMmTelFeature(int slotId) {
        Object object = this.mLock;
        synchronized (object) {
            ImsFeatureContainer f = this.getImsFeatureContainer(slotId, 1);
            if (f == null) {
                Log.w(LOG_TAG, "Requested null MMTelFeature on slot " + slotId);
                return null;
            }
            return f.resolve(IImsMmTelFeature.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsRcsFeature getRcsFeature(int slotId) {
        Object object = this.mLock;
        synchronized (object) {
            ImsFeatureContainer f = this.getImsFeatureContainer(slotId, 2);
            if (f == null) {
                Log.w(LOG_TAG, "Requested null RcsFeature on slot " + slotId);
                return null;
            }
            return f.resolve(IImsRcsFeature.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsRegistration getRegistration(int slotId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            return this.isServiceControllerAvailable() ? this.mIImsServiceController.getRegistration(slotId) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsConfig getConfig(int slotId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            return this.isServiceControllerAvailable() ? this.mIImsServiceController.getConfig(slotId) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyImsServiceReady() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isServiceControllerAvailable()) {
                Log.d(LOG_TAG, "notifyImsServiceReady");
                this.mIImsServiceController.setListener(this.mFeatureChangedListener);
                this.mIImsServiceController.notifyImsServiceReadyForFeatureCreation();
            }
        }
    }

    protected String getServiceInterface() {
        return "android.telephony.ims.ImsService";
    }

    protected void setServiceController(IBinder serviceController) {
        this.mIImsServiceController = IImsServiceController.Stub.asInterface(serviceController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsBound;
        }
    }

    protected boolean isServiceControllerAvailable() {
        return this.mIImsServiceController != null;
    }

    @VisibleForTesting
    public void removeImsServiceFeatureCallbacks() {
        this.mImsStatusCallbacks.clear();
    }

    private void startDelayedRebindToService() {
        this.mBackoff.start();
    }

    private void grantPermissionsToService() {
        Log.i(LOG_TAG, "Granting Runtime permissions to:" + this.getComponentName());
        String[] pkgToGrant = new String[]{this.mComponentName.getPackageName()};
        try {
            if (this.mPackageManager != null) {
                this.mPackageManager.grantDefaultPermissionsToEnabledImsServices(pkgToGrant, this.mContext.getUserId());
            }
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Unable to grant permissions, binder died.");
        }
    }

    private void sendImsFeatureCreatedCallback(int slot, int feature) {
        Iterator<IImsServiceFeatureCallback> i = this.mImsStatusCallbacks.iterator();
        while (i.hasNext()) {
            IImsServiceFeatureCallback callbacks = i.next();
            try {
                callbacks.imsFeatureCreated(slot, feature);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, "sendImsFeatureCreatedCallback: Binder died, removing callback. Exception:" + e.getMessage());
                i.remove();
            }
        }
    }

    private void sendImsFeatureRemovedCallback(int slot, int feature) {
        Iterator<IImsServiceFeatureCallback> i = this.mImsStatusCallbacks.iterator();
        while (i.hasNext()) {
            IImsServiceFeatureCallback callbacks = i.next();
            try {
                callbacks.imsFeatureRemoved(slot, feature);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, "sendImsFeatureRemovedCallback: Binder died, removing callback. Exception:" + e.getMessage());
                i.remove();
            }
        }
    }

    private void sendImsFeatureStatusChanged(int slot, int feature, int status) {
        Iterator<IImsServiceFeatureCallback> i = this.mImsStatusCallbacks.iterator();
        while (i.hasNext()) {
            IImsServiceFeatureCallback callbacks = i.next();
            try {
                callbacks.imsStatusChanged(slot, feature, status);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, "sendImsFeatureStatusChanged: Binder died, removing callback. Exception:" + e.getMessage());
                i.remove();
            }
        }
    }

    private void addImsServiceFeature(ImsFeatureConfiguration.FeatureSlotPair featurePair) throws RemoteException {
        if (!this.isServiceControllerAvailable() || this.mCallbacks == null) {
            Log.w(LOG_TAG, "addImsServiceFeature called with null values.");
            return;
        }
        if (featurePair.featureType != 0) {
            ImsFeatureStatusCallback c = new ImsFeatureStatusCallback(featurePair.slotId, featurePair.featureType);
            this.mFeatureStatusCallbacks.add(c);
            IInterface f = this.createImsFeature(featurePair.slotId, featurePair.featureType, c.getCallback());
            this.addImsFeatureBinder(featurePair.slotId, featurePair.featureType, f);
            this.mCallbacks.imsServiceFeatureCreated(featurePair.slotId, featurePair.featureType, this);
        } else {
            Log.i(LOG_TAG, "supports emergency calling on slot " + featurePair.slotId);
        }
        this.sendImsFeatureCreatedCallback(featurePair.slotId, featurePair.featureType);
    }

    private void removeImsServiceFeature(ImsFeatureConfiguration.FeatureSlotPair featurePair) {
        if (!this.isServiceControllerAvailable() || this.mCallbacks == null) {
            Log.w(LOG_TAG, "removeImsServiceFeature called with null values.");
            return;
        }
        if (featurePair.featureType != 0) {
            ImsFeatureStatusCallback callbackToRemove = this.mFeatureStatusCallbacks.stream().filter(c -> ((ImsFeatureStatusCallback)c).mSlotId == featurePair.slotId && ((ImsFeatureStatusCallback)c).mFeatureType == featurePair.featureType).findFirst().orElse(null);
            if (callbackToRemove != null) {
                this.mFeatureStatusCallbacks.remove(callbackToRemove);
            }
            this.removeImsFeatureBinder(featurePair.slotId, featurePair.featureType);
            this.mCallbacks.imsServiceFeatureRemoved(featurePair.slotId, featurePair.featureType, this);
            try {
                this.removeImsFeature(featurePair.slotId, featurePair.featureType, callbackToRemove != null ? callbackToRemove.getCallback() : null);
            }
            catch (RemoteException e) {
                Log.i(LOG_TAG, "Couldn't remove feature {" + featurePair.featureType + "}, connection is down: " + e.getMessage());
            }
        } else {
            Log.i(LOG_TAG, "doesn't support emergency calling on slot " + featurePair.slotId);
        }
        this.sendImsFeatureRemovedCallback(featurePair.slotId, featurePair.featureType);
    }

    protected IInterface createImsFeature(int slotId, int featureType, IImsFeatureStatusCallback c) throws RemoteException {
        switch (featureType) {
            case 1: {
                return this.mIImsServiceController.createMmTelFeature(slotId, c);
            }
            case 2: {
                return this.mIImsServiceController.createRcsFeature(slotId, c);
            }
        }
        return null;
    }

    protected void removeImsFeature(int slotId, int featureType, IImsFeatureStatusCallback c) throws RemoteException {
        this.mIImsServiceController.removeImsFeature(slotId, featureType, c);
    }

    private void addImsFeatureBinder(int slotId, int featureType, IInterface b) {
        this.mImsFeatureBinders.add(new ImsFeatureContainer(slotId, featureType, b));
    }

    private void removeImsFeatureBinder(int slotId, int featureType) {
        ImsFeatureContainer container = this.mImsFeatureBinders.stream().filter(f -> f.slotId == slotId && f.featureType == featureType).findFirst().orElse(null);
        if (container != null) {
            this.mImsFeatureBinders.remove(container);
        }
    }

    private ImsFeatureContainer getImsFeatureContainer(int slotId, int featureType) {
        return this.mImsFeatureBinders.stream().filter(f -> f.slotId == slotId && f.featureType == featureType).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupAllFeatures() {
        Object object = this.mLock;
        synchronized (object) {
            for (ImsFeatureConfiguration.FeatureSlotPair i : this.mImsFeatures) {
                this.removeImsServiceFeature(i);
            }
            this.removeImsServiceFeatureCallbacks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpService() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImsServiceConnection = null;
            this.setServiceController(null);
        }
    }

    private class ImsFeatureStatusCallback {
        private int mSlotId;
        private int mFeatureType;
        private final IImsFeatureStatusCallback mCallback = new IImsFeatureStatusCallback.Stub(){

            @Override
            public void notifyImsFeatureStatus(int featureStatus) throws RemoteException {
                Log.i(ImsServiceController.LOG_TAG, "notifyImsFeatureStatus: slot=" + ImsFeatureStatusCallback.this.mSlotId + ", feature=" + ImsFeatureStatusCallback.this.mFeatureType + ", status=" + featureStatus);
                ImsServiceController.this.sendImsFeatureStatusChanged(ImsFeatureStatusCallback.this.mSlotId, ImsFeatureStatusCallback.this.mFeatureType, featureStatus);
            }
        };

        ImsFeatureStatusCallback(int slotId, int featureType) {
            this.mSlotId = slotId;
            this.mFeatureType = featureType;
        }

        public IImsFeatureStatusCallback getCallback() {
            return this.mCallback;
        }
    }

    private class ImsFeatureContainer {
        public int slotId;
        public int featureType;
        private IInterface mBinder;

        ImsFeatureContainer(int slotId, int featureType, IInterface binder) {
            this.slotId = slotId;
            this.featureType = featureType;
            this.mBinder = binder;
        }

        public <T extends IInterface> T resolve(Class<T> className) {
            return (T)((IInterface)className.cast(this.mBinder));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImsFeatureContainer that = (ImsFeatureContainer)o;
            if (this.slotId != that.slotId) {
                return false;
            }
            if (this.featureType != that.featureType) {
                return false;
            }
            return this.mBinder != null ? this.mBinder.equals(that.mBinder) : that.mBinder == null;
        }

        public int hashCode() {
            int result = this.slotId;
            result = 31 * result + this.featureType;
            result = 31 * result + (this.mBinder != null ? this.mBinder.hashCode() : 0);
            return result;
        }
    }

    @VisibleForTesting
    public static interface RebindRetry {
        public long getStartDelay();

        public long getMaximumDelay();
    }

    public static interface ImsServiceControllerCallbacks {
        public void imsServiceFeatureCreated(int var1, int var2, ImsServiceController var3);

        public void imsServiceFeatureRemoved(int var1, int var2, ImsServiceController var3);

        public void imsServiceFeaturesChanged(ImsFeatureConfiguration var1, ImsServiceController var2);
    }

    class ImsServiceConnection
    implements ServiceConnection {
        ImsServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            ImsServiceController.this.mBackoff.stop();
            Object object = ImsServiceController.this.mLock;
            synchronized (object) {
                ImsServiceController.this.mIsBound = true;
                ImsServiceController.this.mIsBinding = false;
                Log.d(ImsServiceController.LOG_TAG, "ImsService(" + name + "): onServiceConnected with binder: " + service);
                if (service != null) {
                    try {
                        ImsServiceController.this.setServiceController(service);
                        ImsServiceController.this.notifyImsServiceReady();
                        for (ImsFeatureConfiguration.FeatureSlotPair i : ImsServiceController.this.mImsFeatures) {
                            ImsServiceController.this.addImsServiceFeature(i);
                        }
                    }
                    catch (RemoteException e) {
                        ImsServiceController.this.mIsBound = false;
                        ImsServiceController.this.mIsBinding = false;
                        this.cleanupConnection();
                        ImsServiceController.this.startDelayedRebindToService();
                        Log.e(ImsServiceController.LOG_TAG, "ImsService(" + name + ") RemoteException:" + e.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = ImsServiceController.this.mLock;
            synchronized (object) {
                ImsServiceController.this.mIsBinding = false;
            }
            this.cleanupConnection();
            Log.w(ImsServiceController.LOG_TAG, "ImsService(" + name + "): onServiceDisconnected. Waiting...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBindingDied(ComponentName name) {
            Object object = ImsServiceController.this.mLock;
            synchronized (object) {
                ImsServiceController.this.mIsBinding = false;
                ImsServiceController.this.mIsBound = false;
            }
            this.cleanupConnection();
            Log.w(ImsServiceController.LOG_TAG, "ImsService(" + name + "): onBindingDied. Starting rebind...");
            ImsServiceController.this.startDelayedRebindToService();
        }

        private void cleanupConnection() {
            ImsServiceController.this.cleanupAllFeatures();
            ImsServiceController.this.cleanUpService();
        }
    }
}

