/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ComponentName;
import android.content.Context;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRcsFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.util.Log;
import android.util.SparseArray;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.ims.internal.IImsMMTelFeature;
import com.android.ims.internal.IImsServiceController;
import com.android.internal.telephony.ims.ImsConfigCompatAdapter;
import com.android.internal.telephony.ims.ImsRegistrationCompatAdapter;
import com.android.internal.telephony.ims.ImsServiceController;
import com.android.internal.telephony.ims.MmTelFeatureCompatAdapter;
import com.android.internal.telephony.ims.MmTelInterfaceAdapter;

public class ImsServiceControllerCompat
extends ImsServiceController {
    private static final String TAG = "ImsSCCompat";
    private IImsServiceController mServiceController;
    private final SparseArray<MmTelFeatureCompatAdapter> mMmTelCompatAdapters = new SparseArray();
    private final SparseArray<ImsConfigCompatAdapter> mConfigCompatAdapters = new SparseArray();
    private final SparseArray<ImsRegistrationCompatAdapter> mRegCompatAdapters = new SparseArray();

    public ImsServiceControllerCompat(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks callbacks) {
        super(context, componentName, callbacks);
    }

    @Override
    protected final String getServiceInterface() {
        return "android.telephony.ims.compat.ImsService";
    }

    @Override
    public final void enableIms(int slotId) {
        MmTelFeatureCompatAdapter adapter = this.mMmTelCompatAdapters.get(slotId);
        if (adapter == null) {
            Log.w(TAG, "enableIms: adapter null for slot :" + slotId);
            return;
        }
        try {
            adapter.enableIms();
        }
        catch (RemoteException e) {
            Log.w(TAG, "Couldn't enable IMS: " + e.getMessage());
        }
    }

    @Override
    public final void disableIms(int slotId) {
        MmTelFeatureCompatAdapter adapter = this.mMmTelCompatAdapters.get(slotId);
        if (adapter == null) {
            Log.w(TAG, "enableIms: adapter null for slot :" + slotId);
            return;
        }
        try {
            adapter.disableIms();
        }
        catch (RemoteException e) {
            Log.w(TAG, "Couldn't enable IMS: " + e.getMessage());
        }
    }

    @Override
    public final IImsRegistration getRegistration(int slotId) {
        ImsRegistrationCompatAdapter adapter = this.mRegCompatAdapters.get(slotId);
        if (adapter == null) {
            Log.w(TAG, "getRegistration: Registration does not exist for slot " + slotId);
            return null;
        }
        return adapter.getBinder();
    }

    @Override
    public final IImsConfig getConfig(int slotId) {
        ImsConfigCompatAdapter adapter = this.mConfigCompatAdapters.get(slotId);
        if (adapter == null) {
            Log.w(TAG, "getConfig: Config does not exist for slot " + slotId);
            return null;
        }
        return adapter.getIImsConfig();
    }

    @Override
    protected final void notifyImsServiceReady() {
        Log.d(TAG, "notifyImsServiceReady");
    }

    @Override
    protected final IInterface createImsFeature(int slotId, int featureType, IImsFeatureStatusCallback c) throws RemoteException {
        switch (featureType) {
            case 1: {
                return this.createMMTelCompat(slotId, c);
            }
            case 2: {
                return this.createRcsFeature(slotId, c);
            }
        }
        return null;
    }

    @Override
    protected final void removeImsFeature(int slotId, int featureType, IImsFeatureStatusCallback c) throws RemoteException {
        if (featureType == 1) {
            this.mMmTelCompatAdapters.remove(slotId);
            this.mRegCompatAdapters.remove(slotId);
            this.mConfigCompatAdapters.remove(slotId);
        }
        if (this.mServiceController != null) {
            this.mServiceController.removeImsFeature(slotId, featureType, c);
        }
    }

    @Override
    protected void setServiceController(IBinder serviceController) {
        this.mServiceController = IImsServiceController.Stub.asInterface(serviceController);
    }

    @Override
    protected boolean isServiceControllerAvailable() {
        return this.mServiceController != null;
    }

    protected MmTelInterfaceAdapter getInterface(int slotId, IImsFeatureStatusCallback c) throws RemoteException {
        IImsMMTelFeature feature = this.mServiceController.createMMTelFeature(slotId, c);
        if (feature == null) {
            Log.w(TAG, "createMMTelCompat: createMMTelFeature returned null.");
            return null;
        }
        return new MmTelInterfaceAdapter(slotId, feature.asBinder());
    }

    private IImsMmTelFeature createMMTelCompat(int slotId, IImsFeatureStatusCallback c) throws RemoteException {
        MmTelInterfaceAdapter interfaceAdapter = this.getInterface(slotId, c);
        MmTelFeatureCompatAdapter mmTelAdapter = new MmTelFeatureCompatAdapter(this.mContext, slotId, interfaceAdapter);
        this.mMmTelCompatAdapters.put(slotId, mmTelAdapter);
        ImsRegistrationCompatAdapter regAdapter = new ImsRegistrationCompatAdapter();
        mmTelAdapter.addRegistrationAdapter(regAdapter);
        this.mRegCompatAdapters.put(slotId, regAdapter);
        this.mConfigCompatAdapters.put(slotId, new ImsConfigCompatAdapter(mmTelAdapter.getOldConfigInterface()));
        return mmTelAdapter.getBinder();
    }

    private IImsRcsFeature createRcsFeature(int slotId, IImsFeatureStatusCallback c) {
        return null;
    }
}

