/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.ims.internal.IImsService;
import com.android.internal.telephony.ims.ImsServiceController;
import com.android.internal.telephony.ims.ImsServiceControllerCompat;
import com.android.internal.telephony.ims.ImsServiceInterfaceAdapter;
import com.android.internal.telephony.ims.MmTelInterfaceAdapter;

public class ImsServiceControllerStaticCompat
extends ImsServiceControllerCompat {
    private static final String TAG = "ImsSCStaticCompat";
    private static final String IMS_SERVICE_NAME = "ims";
    private IImsService mImsServiceCompat = null;
    private ImsDeathRecipient mImsDeathRecipient = null;

    public ImsServiceControllerStaticCompat(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks callbacks) {
        super(context, componentName, callbacks);
    }

    @Override
    public boolean startBindToService(Intent intent, ImsServiceController.ImsServiceConnection connection, int flags) {
        IBinder binder = ServiceManager.checkService(IMS_SERVICE_NAME);
        if (binder == null) {
            return false;
        }
        ComponentName name = new ComponentName(this.mContext, ImsServiceControllerStaticCompat.class);
        connection.onServiceConnected(name, binder);
        try {
            this.mImsDeathRecipient = new ImsDeathRecipient(name, connection);
            binder.linkToDeath(this.mImsDeathRecipient, 0);
        }
        catch (RemoteException e) {
            this.mImsDeathRecipient.binderDied();
            this.mImsDeathRecipient = null;
        }
        return true;
    }

    @Override
    protected void setServiceController(IBinder serviceController) {
        if (serviceController == null) {
            if (this.mImsServiceCompat != null) {
                this.mImsServiceCompat.asBinder().unlinkToDeath(this.mImsDeathRecipient, 0);
            }
            this.mImsDeathRecipient = null;
        }
        this.mImsServiceCompat = IImsService.Stub.asInterface(serviceController);
    }

    @Override
    protected boolean isServiceControllerAvailable() {
        return this.mImsServiceCompat != null;
    }

    @Override
    protected MmTelInterfaceAdapter getInterface(int slotId, IImsFeatureStatusCallback c) {
        if (this.mImsServiceCompat == null) {
            Log.w(TAG, "getInterface: IImsService returned null.");
            return null;
        }
        return new ImsServiceInterfaceAdapter(slotId, this.mImsServiceCompat.asBinder());
    }

    private class ImsDeathRecipient
    implements IBinder.DeathRecipient {
        private ComponentName mComponentName;
        private ServiceConnection mServiceConnection;

        ImsDeathRecipient(ComponentName name, ServiceConnection conn) {
            this.mComponentName = name;
            this.mServiceConnection = conn;
        }

        @Override
        public void binderDied() {
            Log.e(ImsServiceControllerStaticCompat.TAG, "ImsService(" + this.mComponentName + ") died. Restarting...");
            this.mServiceConnection.onBindingDied(this.mComponentName);
        }
    }
}

