/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.telephony.ims.aidl.IImsServiceController;
import android.telephony.ims.stub.ImsFeatureConfiguration;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ImsServiceFeatureQueryManager {
    private final Map<ComponentName, ImsServiceFeatureQuery> mActiveQueries = new HashMap<ComponentName, ImsServiceFeatureQuery>();
    private final Context mContext;
    private final Listener mListener;
    private final Object mLock = new Object();

    public ImsServiceFeatureQueryManager(Context context, Listener listener) {
        this.mContext = context;
        this.mListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startQuery(ComponentName name, String intentFilter) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mActiveQueries.containsKey(name)) {
                return true;
            }
            ImsServiceFeatureQuery query = new ImsServiceFeatureQuery(name, intentFilter);
            this.mActiveQueries.put(name, query);
            return query.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueryInProgress() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mActiveQueries.isEmpty();
        }
    }

    public static interface Listener {
        public void onComplete(ComponentName var1, Set<ImsFeatureConfiguration.FeatureSlotPair> var2);

        public void onError(ComponentName var1);
    }

    private final class ImsServiceFeatureQuery
    implements ServiceConnection {
        private static final String LOG_TAG = "ImsServiceFeatureQuery";
        private final ComponentName mName;
        private final String mIntentFilter;

        ImsServiceFeatureQuery(ComponentName name, String intentFilter) {
            this.mName = name;
            this.mIntentFilter = intentFilter;
        }

        public boolean start() {
            Log.d(LOG_TAG, "start: intent filter=" + this.mIntentFilter + ", name=" + this.mName);
            Intent imsServiceIntent = new Intent(this.mIntentFilter).setComponent(this.mName);
            int serviceFlags = 0x4000041;
            boolean bindStarted = ImsServiceFeatureQueryManager.this.mContext.bindService(imsServiceIntent, this, serviceFlags);
            if (!bindStarted) {
                this.cleanup();
            }
            return bindStarted;
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.i(LOG_TAG, "onServiceConnected for component: " + name);
            if (service != null) {
                this.queryImsFeatures(IImsServiceController.Stub.asInterface(service));
            } else {
                Log.w(LOG_TAG, "onServiceConnected: " + name + " binder null, cleaning up.");
                this.cleanup();
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            Log.w(LOG_TAG, "onServiceDisconnected for component: " + name);
        }

        private void queryImsFeatures(IImsServiceController controller) {
            ImsFeatureConfiguration config;
            try {
                config = controller.querySupportedImsFeatures();
            }
            catch (Exception e) {
                Log.w(LOG_TAG, "queryImsFeatures - error: " + e);
                this.cleanup();
                ImsServiceFeatureQueryManager.this.mListener.onError(this.mName);
                return;
            }
            Set<ImsFeatureConfiguration.FeatureSlotPair> servicePairs = config.getServiceFeatures();
            this.cleanup();
            ImsServiceFeatureQueryManager.this.mListener.onComplete(this.mName, servicePairs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() {
            ImsServiceFeatureQueryManager.this.mContext.unbindService(this);
            Object object = ImsServiceFeatureQueryManager.this.mLock;
            synchronized (object) {
                ImsServiceFeatureQueryManager.this.mActiveQueries.remove(this.mName);
            }
        }
    }
}

