/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.feature.CapabilityChangeRequest;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.feature.MmTelFeature;
import android.util.Log;
import com.android.ims.ImsConfigListener;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsConfig;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsRegistrationListener;
import com.android.ims.internal.IImsUt;
import com.android.internal.telephony.ims.ImsRegistrationCompatAdapter;
import com.android.internal.telephony.ims.MmTelInterfaceAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MmTelFeatureCompatAdapter
extends MmTelFeature {
    private static final String TAG = "MmTelFeatureCompat";
    public static final String ACTION_IMS_INCOMING_CALL = "com.android.ims.IMS_INCOMING_CALL";
    private static final int WAIT_TIMEOUT_MS = 2000;
    private final MmTelInterfaceAdapter mCompatFeature;
    private ImsRegistrationCompatAdapter mRegCompatAdapter;
    private int mSessionId = -1;
    private static final Map<Integer, Integer> REG_TECH_TO_NET_TYPE = new HashMap<Integer, Integer>(2);
    public static final int FEATURE_TYPE_UNKNOWN = -1;
    public static final int FEATURE_TYPE_VOICE_OVER_LTE = 0;
    public static final int FEATURE_TYPE_VIDEO_OVER_LTE = 1;
    public static final int FEATURE_TYPE_VOICE_OVER_WIFI = 2;
    public static final int FEATURE_TYPE_VIDEO_OVER_WIFI = 3;
    public static final int FEATURE_TYPE_UT_OVER_LTE = 4;
    public static final int FEATURE_TYPE_UT_OVER_WIFI = 5;
    public static final int FEATURE_UNKNOWN = -1;
    public static final int FEATURE_DISABLED = 0;
    public static final int FEATURE_ENABLED = 1;
    private final IImsRegistrationListener mListener = new IImsRegistrationListener.Stub(){

        @Override
        public void registrationConnected() throws RemoteException {
        }

        @Override
        public void registrationProgressing() throws RemoteException {
        }

        @Override
        public void registrationConnectedWithRadioTech(int imsRadioTech) throws RemoteException {
        }

        @Override
        public void registrationProgressingWithRadioTech(int imsRadioTech) throws RemoteException {
        }

        @Override
        public void registrationDisconnected(ImsReasonInfo imsReasonInfo) throws RemoteException {
            Log.i(MmTelFeatureCompatAdapter.TAG, "registrationDisconnected: resetting MMTEL capabilities.");
            MmTelFeatureCompatAdapter.this.notifyCapabilitiesStatusChanged(new MmTelFeature.MmTelCapabilities());
        }

        @Override
        public void registrationResumed() throws RemoteException {
        }

        @Override
        public void registrationSuspended() throws RemoteException {
        }

        @Override
        public void registrationServiceCapabilityChanged(int serviceClass, int event) throws RemoteException {
        }

        @Override
        public void registrationFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) throws RemoteException {
            MmTelFeatureCompatAdapter.this.notifyCapabilitiesStatusChanged(MmTelFeatureCompatAdapter.this.convertCapabilities(enabledFeatures));
        }

        @Override
        public void voiceMessageCountUpdate(int count) throws RemoteException {
            MmTelFeatureCompatAdapter.this.notifyVoiceMessageCountUpdate(count);
        }

        @Override
        public void registrationAssociatedUriChanged(Uri[] uris) throws RemoteException {
        }

        @Override
        public void registrationChangeFailed(int targetAccessTech, ImsReasonInfo imsReasonInfo) throws RemoteException {
        }
    };
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Log.i(MmTelFeatureCompatAdapter.TAG, "onReceive");
            if (intent.getAction().equals(MmTelFeatureCompatAdapter.ACTION_IMS_INCOMING_CALL)) {
                Log.i(MmTelFeatureCompatAdapter.TAG, "onReceive : incoming call intent.");
                String callId = intent.getStringExtra("android:imsCallID");
                try {
                    IImsCallSession session = MmTelFeatureCompatAdapter.this.mCompatFeature.getPendingCallSession(MmTelFeatureCompatAdapter.this.mSessionId, callId);
                    MmTelFeatureCompatAdapter.this.notifyIncomingCallSession(session, intent.getExtras());
                }
                catch (RemoteException e) {
                    Log.w(MmTelFeatureCompatAdapter.TAG, "onReceive: Couldn't get Incoming call session.");
                }
            }
        }
    };

    public MmTelFeatureCompatAdapter(Context context, int slotId, MmTelInterfaceAdapter compatFeature) {
        this.initialize(context, slotId);
        this.mCompatFeature = compatFeature;
    }

    @Override
    public boolean queryCapabilityConfiguration(int capability, int radioTech) {
        int capConverted = this.convertCapability(capability, radioTech);
        CountDownLatch latch = new CountDownLatch(1);
        final int[] returnValue = new int[]{-1};
        int regTech = REG_TECH_TO_NET_TYPE.getOrDefault(radioTech, -1);
        try {
            this.mCompatFeature.getConfigInterface().getFeatureValue(capConverted, regTech, new ConfigListener(capConverted, regTech, latch){

                @Override
                public void getFeatureValueReceived(int value) {
                    returnValue[0] = value;
                }
            });
        }
        catch (RemoteException e) {
            Log.w(TAG, "queryCapabilityConfiguration");
        }
        try {
            latch.await(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Log.w(TAG, "queryCapabilityConfiguration - error waiting: " + e.getMessage());
        }
        return returnValue[0] == 1;
    }

    @Override
    public void changeEnabledCapabilities(CapabilityChangeRequest request, final ImsFeature.CapabilityCallbackProxy c) {
        if (request == null) {
            return;
        }
        try {
            int radioTechConverted;
            int capConverted;
            CountDownLatch latch;
            IImsConfig imsConfig = this.mCompatFeature.getConfigInterface();
            for (final CapabilityChangeRequest.CapabilityPair cap : request.getCapabilitiesToDisable()) {
                latch = new CountDownLatch(1);
                capConverted = this.convertCapability(cap.getCapability(), cap.getRadioTech());
                radioTechConverted = REG_TECH_TO_NET_TYPE.getOrDefault(cap.getRadioTech(), -1);
                Log.i(TAG, "changeEnabledCapabilities - cap: " + capConverted + " radioTech: " + radioTechConverted + " disabled");
                imsConfig.setFeatureValue(capConverted, radioTechConverted, 0, new ConfigListener(capConverted, radioTechConverted, latch){

                    @Override
                    public void setFeatureValueReceived(int value) {
                        if (value != 0) {
                            if (c == null) {
                                return;
                            }
                            c.onChangeCapabilityConfigurationError(cap.getCapability(), cap.getRadioTech(), -1);
                        }
                        Log.i(MmTelFeatureCompatAdapter.TAG, "changeEnabledCapabilities - setFeatureValueReceived with value " + value);
                    }
                });
                latch.await(2000L, TimeUnit.MILLISECONDS);
            }
            for (final CapabilityChangeRequest.CapabilityPair cap : request.getCapabilitiesToEnable()) {
                latch = new CountDownLatch(1);
                capConverted = this.convertCapability(cap.getCapability(), cap.getRadioTech());
                radioTechConverted = REG_TECH_TO_NET_TYPE.getOrDefault(cap.getRadioTech(), -1);
                Log.i(TAG, "changeEnabledCapabilities - cap: " + capConverted + " radioTech: " + radioTechConverted + " enabled");
                imsConfig.setFeatureValue(capConverted, radioTechConverted, 1, new ConfigListener(capConverted, radioTechConverted, latch){

                    @Override
                    public void setFeatureValueReceived(int value) {
                        if (value != 1) {
                            if (c == null) {
                                return;
                            }
                            c.onChangeCapabilityConfigurationError(cap.getCapability(), cap.getRadioTech(), -1);
                        }
                        Log.i(MmTelFeatureCompatAdapter.TAG, "changeEnabledCapabilities - setFeatureValueReceived with value " + value);
                    }
                });
                latch.await(2000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (RemoteException | InterruptedException e) {
            Log.w(TAG, "changeEnabledCapabilities: Error processing: " + e.getMessage());
        }
    }

    @Override
    public ImsCallProfile createCallProfile(int callSessionType, int callType) {
        try {
            return this.mCompatFeature.createCallProfile(this.mSessionId, callSessionType, callType);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public IImsCallSession createCallSessionInterface(ImsCallProfile profile) throws RemoteException {
        return this.mCompatFeature.createCallSession(this.mSessionId, profile);
    }

    @Override
    public IImsUt getUtInterface() throws RemoteException {
        return this.mCompatFeature.getUtInterface();
    }

    @Override
    public IImsEcbm getEcbmInterface() throws RemoteException {
        return this.mCompatFeature.getEcbmInterface();
    }

    @Override
    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
        return this.mCompatFeature.getMultiEndpointInterface();
    }

    @Override
    public int getFeatureState() {
        try {
            return this.mCompatFeature.getFeatureState();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void setUiTtyMode(int mode, Message onCompleteMessage) {
        try {
            this.mCompatFeature.setUiTTYMode(mode, onCompleteMessage);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void onFeatureRemoved() {
        this.mContext.unregisterReceiver(this.mReceiver);
        try {
            this.mCompatFeature.endSession(this.mSessionId);
            this.mCompatFeature.removeRegistrationListener(this.mListener);
            if (this.mRegCompatAdapter != null) {
                this.mCompatFeature.removeRegistrationListener(this.mRegCompatAdapter.getRegistrationListener());
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "onFeatureRemoved: Couldn't end session: " + e.getMessage());
        }
    }

    @Override
    public void onFeatureReady() {
        Log.i(TAG, "onFeatureReady called!");
        IntentFilter intentFilter = new IntentFilter(ACTION_IMS_INCOMING_CALL);
        this.mContext.registerReceiver(this.mReceiver, intentFilter);
        try {
            this.mSessionId = this.mCompatFeature.startSession(this.createIncomingCallPendingIntent(), new ImsRegistrationListenerBase());
            this.mCompatFeature.addRegistrationListener(this.mListener);
            this.mCompatFeature.addRegistrationListener(this.mRegCompatAdapter.getRegistrationListener());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Couldn't start compat feature: " + e.getMessage());
        }
    }

    public void enableIms() throws RemoteException {
        this.mCompatFeature.turnOnIms();
    }

    public void disableIms() throws RemoteException {
        this.mCompatFeature.turnOffIms();
    }

    public IImsConfig getOldConfigInterface() {
        try {
            return this.mCompatFeature.getConfigInterface();
        }
        catch (RemoteException e) {
            Log.w(TAG, "getOldConfigInterface(): " + e.getMessage());
            return null;
        }
    }

    public void addRegistrationAdapter(ImsRegistrationCompatAdapter regCompat) throws RemoteException {
        this.mRegCompatAdapter = regCompat;
    }

    private MmTelFeature.MmTelCapabilities convertCapabilities(int[] enabledFeatures) {
        boolean[] featuresEnabled = new boolean[enabledFeatures.length];
        for (int i = 0; i <= 5 && i < enabledFeatures.length; ++i) {
            if (enabledFeatures[i] == i) {
                featuresEnabled[i] = true;
                continue;
            }
            if (enabledFeatures[i] != -1) continue;
            featuresEnabled[i] = false;
        }
        MmTelFeature.MmTelCapabilities capabilities = new MmTelFeature.MmTelCapabilities();
        if (featuresEnabled[0] || featuresEnabled[2]) {
            capabilities.addCapabilities(1);
        }
        if (featuresEnabled[1] || featuresEnabled[3]) {
            capabilities.addCapabilities(2);
        }
        if (featuresEnabled[4] || featuresEnabled[5]) {
            capabilities.addCapabilities(4);
        }
        Log.i(TAG, "convertCapabilities - capabilities: " + capabilities);
        return capabilities;
    }

    private PendingIntent createIncomingCallPendingIntent() {
        Intent intent = new Intent(ACTION_IMS_INCOMING_CALL);
        intent.setPackage("com.android.phone");
        return PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000);
    }

    private int convertCapability(int capability, int radioTech) {
        int capConverted = -1;
        if (radioTech == 0) {
            switch (capability) {
                case 1: {
                    capConverted = 0;
                    break;
                }
                case 2: {
                    capConverted = 1;
                    break;
                }
                case 4: {
                    capConverted = 4;
                }
            }
        } else if (radioTech == 1) {
            switch (capability) {
                case 1: {
                    capConverted = 2;
                    break;
                }
                case 2: {
                    capConverted = 3;
                    break;
                }
                case 4: {
                    capConverted = 5;
                }
            }
        }
        return capConverted;
    }

    static {
        REG_TECH_TO_NET_TYPE.put(0, 13);
        REG_TECH_TO_NET_TYPE.put(1, 18);
    }

    private class ImsRegistrationListenerBase
    extends IImsRegistrationListener.Stub {
        private ImsRegistrationListenerBase() {
        }

        @Override
        public void registrationConnected() throws RemoteException {
        }

        @Override
        public void registrationProgressing() throws RemoteException {
        }

        @Override
        public void registrationConnectedWithRadioTech(int imsRadioTech) throws RemoteException {
        }

        @Override
        public void registrationProgressingWithRadioTech(int imsRadioTech) throws RemoteException {
        }

        @Override
        public void registrationDisconnected(ImsReasonInfo imsReasonInfo) throws RemoteException {
        }

        @Override
        public void registrationResumed() throws RemoteException {
        }

        @Override
        public void registrationSuspended() throws RemoteException {
        }

        @Override
        public void registrationServiceCapabilityChanged(int serviceClass, int event) throws RemoteException {
        }

        @Override
        public void registrationFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) throws RemoteException {
        }

        @Override
        public void voiceMessageCountUpdate(int count) throws RemoteException {
        }

        @Override
        public void registrationAssociatedUriChanged(Uri[] uris) throws RemoteException {
        }

        @Override
        public void registrationChangeFailed(int targetAccessTech, ImsReasonInfo imsReasonInfo) throws RemoteException {
        }
    }

    private static class ConfigListener
    extends ImsConfigListener.Stub {
        private final int mCapability;
        private final int mTech;
        private final CountDownLatch mLatch;

        public ConfigListener(int capability, int tech, CountDownLatch latch) {
            this.mCapability = capability;
            this.mTech = tech;
            this.mLatch = latch;
        }

        @Override
        public void onGetFeatureResponse(int feature, int network, int value, int status) throws RemoteException {
            if (feature == this.mCapability && network == this.mTech) {
                this.mLatch.countDown();
                this.getFeatureValueReceived(value);
            } else {
                Log.i(MmTelFeatureCompatAdapter.TAG, "onGetFeatureResponse: response different than requested: feature=" + feature + " and network=" + network);
            }
        }

        @Override
        public void onSetFeatureResponse(int feature, int network, int value, int status) throws RemoteException {
            if (feature == this.mCapability && network == this.mTech) {
                this.mLatch.countDown();
                this.setFeatureValueReceived(value);
            } else {
                Log.i(MmTelFeatureCompatAdapter.TAG, "onSetFeatureResponse: response different than requested: feature=" + feature + " and network=" + network);
            }
        }

        @Override
        public void onGetVideoQuality(int status, int quality) throws RemoteException {
        }

        @Override
        public void onSetVideoQuality(int status) throws RemoteException {
        }

        public void getFeatureValueReceived(int value) {
        }

        public void setFeatureValueReceived(int value) {
        }
    }
}

