/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.provider.Telephony;
import android.telephony.Rlog;
import android.telephony.ims.RcsEventDescriptor;
import android.telephony.ims.RcsEventQueryResultDescriptor;
import android.telephony.ims.RcsGroupThreadIconChangedEventDescriptor;
import android.telephony.ims.RcsGroupThreadNameChangedEventDescriptor;
import android.telephony.ims.RcsGroupThreadParticipantJoinedEventDescriptor;
import android.telephony.ims.RcsGroupThreadParticipantLeftEventDescriptor;
import android.telephony.ims.RcsParticipantAliasChangedEventDescriptor;
import android.telephony.ims.RcsQueryContinuationToken;
import java.util.ArrayList;

class RcsEventQueryHelper {
    private final ContentResolver mContentResolver;

    RcsEventQueryHelper(ContentResolver contentResolver) {
        this.mContentResolver = contentResolver;
    }

    Uri getParticipantEventInsertionUri(int participantId) {
        return Telephony.RcsColumns.RcsParticipantColumns.RCS_PARTICIPANT_URI.buildUpon().appendPath(Integer.toString(participantId)).appendPath("alias_change_event").build();
    }

    RcsEventQueryResultDescriptor performEventQuery(Bundle bundle) throws RemoteException {
        RcsQueryContinuationToken continuationToken = null;
        ArrayList<RcsEventDescriptor> eventList = new ArrayList<RcsEventDescriptor>();
        try (Cursor cursor = this.mContentResolver.query(Telephony.RcsColumns.RcsUnifiedEventHelper.RCS_EVENT_QUERY_URI, null, bundle, null);){
            if (cursor == null) {
                throw new RemoteException("Event query failed, bundle: " + bundle);
            }
            block16: while (cursor.moveToNext()) {
                int eventType = cursor.getInt(cursor.getColumnIndex("event_type"));
                switch (eventType) {
                    case 1: {
                        eventList.add(this.createNewParticipantAliasChangedEvent(cursor));
                        continue block16;
                    }
                    case 2: {
                        eventList.add(this.createNewParticipantJoinedEvent(cursor));
                        continue block16;
                    }
                    case 4: {
                        eventList.add(this.createNewParticipantLeftEvent(cursor));
                        continue block16;
                    }
                    case 16: {
                        eventList.add(this.createNewGroupNameChangedEvent(cursor));
                        continue block16;
                    }
                    case 8: {
                        eventList.add(this.createNewGroupIconChangedEvent(cursor));
                        continue block16;
                    }
                }
                Rlog.e("RcsMsgStoreController", "RcsEventQueryHelper: invalid event type: " + eventType);
            }
            Bundle cursorExtras = cursor.getExtras();
            if (cursorExtras != null) {
                continuationToken = (RcsQueryContinuationToken)cursorExtras.getParcelable("query_continuation_token");
            }
        }
        return new RcsEventQueryResultDescriptor(continuationToken, eventList);
    }

    int createGroupThreadEvent(int eventType, long timestamp, int threadId, int originationParticipantId, ContentValues eventSpecificValues) throws RemoteException {
        ContentValues values = new ContentValues(eventSpecificValues);
        values.put("event_type", eventType);
        values.put("origination_timestamp", timestamp);
        values.put("source_participant", originationParticipantId);
        Uri eventUri = Telephony.RcsColumns.RcsGroupThreadColumns.RCS_GROUP_THREAD_URI.buildUpon().appendPath(Integer.toString(threadId)).appendPath(this.getPathForEventType(eventType)).build();
        Uri insertionUri = this.mContentResolver.insert(eventUri, values);
        int eventId = 0;
        if (insertionUri != null) {
            eventId = Integer.parseInt(insertionUri.getLastPathSegment());
        }
        if (eventId <= 0) {
            throw new RemoteException("Could not create event with type: " + eventType + " on thread: " + threadId);
        }
        return eventId;
    }

    private String getPathForEventType(int eventType) throws RemoteException {
        switch (eventType) {
            case 2: {
                return "participant_joined_event";
            }
            case 4: {
                return "participant_left_event";
            }
            case 16: {
                return "name_changed_event";
            }
            case 8: {
                return "icon_changed_event";
            }
        }
        throw new RemoteException("Event type unrecognized: " + eventType);
    }

    private RcsGroupThreadIconChangedEventDescriptor createNewGroupIconChangedEvent(Cursor cursor) {
        String newIcon = cursor.getString(cursor.getColumnIndex("new_icon_uri"));
        return new RcsGroupThreadIconChangedEventDescriptor(cursor.getLong(cursor.getColumnIndex("origination_timestamp")), cursor.getInt(cursor.getColumnIndex("rcs_thread_id")), cursor.getInt(cursor.getColumnIndex("source_participant")), newIcon == null ? null : Uri.parse(newIcon));
    }

    private RcsGroupThreadNameChangedEventDescriptor createNewGroupNameChangedEvent(Cursor cursor) {
        return new RcsGroupThreadNameChangedEventDescriptor(cursor.getLong(cursor.getColumnIndex("origination_timestamp")), cursor.getInt(cursor.getColumnIndex("rcs_thread_id")), cursor.getInt(cursor.getColumnIndex("source_participant")), cursor.getString(cursor.getColumnIndex("new_name")));
    }

    private RcsGroupThreadParticipantLeftEventDescriptor createNewParticipantLeftEvent(Cursor cursor) {
        return new RcsGroupThreadParticipantLeftEventDescriptor(cursor.getLong(cursor.getColumnIndex("origination_timestamp")), cursor.getInt(cursor.getColumnIndex("rcs_thread_id")), cursor.getInt(cursor.getColumnIndex("source_participant")), cursor.getInt(cursor.getColumnIndex("destination_participant")));
    }

    private RcsGroupThreadParticipantJoinedEventDescriptor createNewParticipantJoinedEvent(Cursor cursor) {
        return new RcsGroupThreadParticipantJoinedEventDescriptor(cursor.getLong(cursor.getColumnIndex("origination_timestamp")), cursor.getInt(cursor.getColumnIndex("rcs_thread_id")), cursor.getInt(cursor.getColumnIndex("source_participant")), cursor.getInt(cursor.getColumnIndex("destination_participant")));
    }

    private RcsParticipantAliasChangedEventDescriptor createNewParticipantAliasChangedEvent(Cursor cursor) {
        return new RcsParticipantAliasChangedEventDescriptor(cursor.getLong(cursor.getColumnIndex("origination_timestamp")), cursor.getInt(cursor.getColumnIndex("source_participant")), cursor.getString(cursor.getColumnIndex("new_alias")));
    }
}

