/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.provider.Telephony;
import android.telephony.ims.RcsFileTransferCreationParams;
import android.telephony.ims.RcsMessageCreationParams;
import android.telephony.ims.RcsMessageQueryResultParcelable;
import android.telephony.ims.RcsQueryContinuationToken;
import com.android.ims.RcsTypeIdPair;
import java.util.ArrayList;

class RcsMessageQueryHelper {
    private final ContentResolver mContentResolver;

    RcsMessageQueryHelper(ContentResolver contentResolver) {
        this.mContentResolver = contentResolver;
    }

    RcsMessageQueryResultParcelable performMessageQuery(Bundle bundle) throws RemoteException {
        RcsQueryContinuationToken continuationToken = null;
        ArrayList<RcsTypeIdPair> messageTypeIdPairs = new ArrayList<RcsTypeIdPair>();
        try (Cursor cursor = this.mContentResolver.query(Telephony.RcsColumns.RcsUnifiedMessageColumns.UNIFIED_MESSAGE_URI, null, bundle, null);){
            Bundle cursorExtras;
            if (cursor == null) {
                throw new RemoteException("Could not perform message query, bundle: " + bundle);
            }
            while (cursor != null && cursor.moveToNext()) {
                boolean isIncoming = cursor.getInt(cursor.getColumnIndex("message_type")) == 1;
                int messageId = cursor.getInt(cursor.getColumnIndex("rcs_message_row_id"));
                messageTypeIdPairs.add(new RcsTypeIdPair(isIncoming ? 1 : 0, messageId));
            }
            if (cursor != null && (cursorExtras = cursor.getExtras()) != null) {
                continuationToken = (RcsQueryContinuationToken)cursorExtras.getParcelable("query_continuation_token");
            }
        }
        return new RcsMessageQueryResultParcelable(continuationToken, messageTypeIdPairs);
    }

    void createContentValuesForGenericMessage(ContentValues contentValues, int threadId, RcsMessageCreationParams rcsMessageCreationParams) {
        contentValues.put("rcs_message_global_id", rcsMessageCreationParams.getRcsMessageGlobalId());
        contentValues.put("sub_id", rcsMessageCreationParams.getSubId());
        contentValues.put("status", rcsMessageCreationParams.getMessageStatus());
        contentValues.put("origination_timestamp", rcsMessageCreationParams.getOriginationTimestamp());
        contentValues.put("rcs_thread_id", threadId);
    }

    Uri getMessageInsertionUri(boolean isIncoming) {
        return isIncoming ? Telephony.RcsColumns.RcsIncomingMessageColumns.INCOMING_MESSAGE_URI : Telephony.RcsColumns.RcsOutgoingMessageColumns.OUTGOING_MESSAGE_URI;
    }

    Uri getMessageDeletionUri(int messageId, boolean isIncoming, int rcsThreadId, boolean isGroup) {
        return Telephony.RcsColumns.CONTENT_AND_AUTHORITY.buildUpon().appendPath(isGroup ? "group_thread" : "p2p_thread").appendPath(Integer.toString(rcsThreadId)).appendPath(isIncoming ? "incoming_message" : "outgoing_message").appendPath(Integer.toString(messageId)).build();
    }

    Uri getMessageUpdateUri(int messageId, boolean isIncoming) {
        return this.getMessageInsertionUri(isIncoming).buildUpon().appendPath(Integer.toString(messageId)).build();
    }

    int[] getDeliveryParticipantsForMessage(int messageId) throws RemoteException {
        int[] participantIds;
        try (Cursor cursor = this.mContentResolver.query(this.getMessageDeliveryQueryUri(messageId), null, null, null);){
            if (cursor == null) {
                throw new RemoteException("Could not query deliveries for message, messageId: " + messageId);
            }
            participantIds = new int[cursor.getCount()];
            int i = 0;
            while (cursor.moveToNext()) {
                participantIds[i] = cursor.getInt(cursor.getColumnIndex("rcs_participant_id"));
                ++i;
            }
        }
        return participantIds;
    }

    Uri getMessageDeliveryUri(int messageId, int participantId) {
        return Uri.withAppendedPath(this.getMessageDeliveryQueryUri(messageId), Integer.toString(participantId));
    }

    long getLongValueFromDelivery(int messageId, int participantId, String columnName) throws RemoteException {
        try (Cursor cursor = this.mContentResolver.query(this.getMessageDeliveryUri(messageId, participantId), null, null, null);){
            if (cursor == null || !cursor.moveToFirst()) {
                throw new RemoteException("Could not read delivery for message: " + messageId + ", participant: " + participantId);
            }
            long l = cursor.getLong(cursor.getColumnIndex(columnName));
            return l;
        }
    }

    private Uri getMessageDeliveryQueryUri(int messageId) {
        return this.getMessageInsertionUri(false).buildUpon().appendPath(Integer.toString(messageId)).appendPath("delivery").build();
    }

    ContentValues getContentValuesForFileTransfer(RcsFileTransferCreationParams fileTransferCreationParameters) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("session_id", fileTransferCreationParameters.getRcsFileTransferSessionId());
        contentValues.put("content_uri", fileTransferCreationParameters.getContentUri().toString());
        contentValues.put("content_type", fileTransferCreationParameters.getContentMimeType());
        contentValues.put("file_size", fileTransferCreationParameters.getFileSize());
        contentValues.put("transfer_offset", fileTransferCreationParameters.getTransferOffset());
        contentValues.put("transfer_status", fileTransferCreationParameters.getFileTransferStatus());
        contentValues.put("width", fileTransferCreationParameters.getWidth());
        contentValues.put("height", fileTransferCreationParameters.getHeight());
        contentValues.put("duration", fileTransferCreationParameters.getMediaDuration());
        contentValues.put("preview_uri", fileTransferCreationParameters.getPreviewUri().toString());
        contentValues.put("preview_type", fileTransferCreationParameters.getPreviewMimeType());
        return contentValues;
    }

    Uri getFileTransferInsertionUri(int messageId) {
        return Telephony.RcsColumns.RcsUnifiedMessageColumns.UNIFIED_MESSAGE_URI.buildUpon().appendPath(Integer.toString(messageId)).appendPath("file_transfer").build();
    }

    Uri getFileTransferUpdateUri(int partId) {
        return Uri.withAppendedPath(Telephony.RcsColumns.RcsFileTransferColumns.FILE_TRANSFER_URI, Integer.toString(partId));
    }
}

