/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Telephony;
import android.telephony.Rlog;
import android.telephony.ims.RcsEventQueryParams;
import android.telephony.ims.RcsEventQueryResultDescriptor;
import android.telephony.ims.RcsFileTransferCreationParams;
import android.telephony.ims.RcsIncomingMessageCreationParams;
import android.telephony.ims.RcsMessageQueryParams;
import android.telephony.ims.RcsMessageQueryResultParcelable;
import android.telephony.ims.RcsMessageSnippet;
import android.telephony.ims.RcsOutgoingMessageCreationParams;
import android.telephony.ims.RcsParticipantQueryParams;
import android.telephony.ims.RcsParticipantQueryResultParcelable;
import android.telephony.ims.RcsQueryContinuationToken;
import android.telephony.ims.RcsThreadQueryParams;
import android.telephony.ims.RcsThreadQueryResultParcelable;
import android.telephony.ims.aidl.IRcs;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.ims.RcsEventQueryHelper;
import com.android.internal.telephony.ims.RcsMessageQueryHelper;
import com.android.internal.telephony.ims.RcsMessageStoreUtil;
import com.android.internal.telephony.ims.RcsParticipantQueryHelper;
import com.android.internal.telephony.ims.RcsPermissions;
import com.android.internal.telephony.ims.RcsThreadQueryHelper;

public class RcsMessageStoreController
extends IRcs.Stub {
    static final String TAG = "RcsMsgStoreController";
    private static final String RCS_SERVICE_NAME = "ircs";
    private static RcsMessageStoreController sInstance;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final RcsParticipantQueryHelper mParticipantQueryHelper;
    private final RcsMessageQueryHelper mMessageQueryHelper;
    private final RcsEventQueryHelper mEventQueryHelper;
    private final RcsThreadQueryHelper mThreadQueryHelper;
    private final RcsMessageStoreUtil mMessageStoreUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RcsMessageStoreController init(Context context) {
        Class<RcsMessageStoreController> clazz = RcsMessageStoreController.class;
        synchronized (RcsMessageStoreController.class) {
            if (sInstance == null) {
                sInstance = new RcsMessageStoreController(context);
                if (ServiceManager.getService(RCS_SERVICE_NAME) == null) {
                    ServiceManager.addService(RCS_SERVICE_NAME, sInstance);
                }
            } else {
                Rlog.e(TAG, "init() called multiple times! sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private void performWriteOperation(String callingPackage, ThrowingRunnable fn) {
        RcsPermissions.checkWritePermissions(this.mContext, callingPackage);
        try {
            fn.run();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T performCreateOperation(String callingPackage, ThrowingSupplier<T> fn) {
        RcsPermissions.checkWritePermissions(this.mContext, callingPackage);
        try {
            return fn.get();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T performReadOperation(String callingPackage, ThrowingSupplier<T> fn) {
        RcsPermissions.checkReadPermissions(this.mContext, callingPackage);
        try {
            return fn.get();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public RcsMessageStoreController(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mParticipantQueryHelper = new RcsParticipantQueryHelper(this.mContentResolver);
        this.mMessageQueryHelper = new RcsMessageQueryHelper(this.mContentResolver);
        this.mThreadQueryHelper = new RcsThreadQueryHelper(this.mContentResolver, this.mParticipantQueryHelper);
        this.mEventQueryHelper = new RcsEventQueryHelper(this.mContentResolver);
        this.mMessageStoreUtil = new RcsMessageStoreUtil(this.mContentResolver);
    }

    @Override
    public boolean deleteThread(int threadId, int threadType, String callingPackage) {
        return this.performCreateOperation(callingPackage, () -> {
            int deletionCount = this.mContentResolver.delete(threadType == 1 ? Telephony.RcsColumns.RcsGroupThreadColumns.RCS_GROUP_THREAD_URI : Telephony.RcsColumns.Rcs1To1ThreadColumns.RCS_1_TO_1_THREAD_URI, "rcs_thread_id=?", new String[]{Integer.toString(threadId)});
            return deletionCount > 0;
        });
    }

    @Override
    public RcsMessageSnippet getMessageSnippet(int threadId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> null);
    }

    @Override
    public RcsThreadQueryResultParcelable getRcsThreads(RcsThreadQueryParams queryParameters, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> {
            Bundle bundle = new Bundle();
            bundle.putParcelable("thread_query_parameters", queryParameters);
            return this.mThreadQueryHelper.performThreadQuery(bundle);
        });
    }

    @Override
    public RcsThreadQueryResultParcelable getRcsThreadsWithToken(RcsQueryContinuationToken continuationToken, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> {
            Bundle bundle = new Bundle();
            bundle.putParcelable("query_continuation_token", continuationToken);
            return this.mThreadQueryHelper.performThreadQuery(bundle);
        });
    }

    @Override
    public RcsParticipantQueryResultParcelable getParticipants(RcsParticipantQueryParams queryParameters, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> {
            Bundle bundle = new Bundle();
            bundle.putParcelable("participant_query_parameters", queryParameters);
            return this.mParticipantQueryHelper.performParticipantQuery(bundle);
        });
    }

    @Override
    public RcsParticipantQueryResultParcelable getParticipantsWithToken(RcsQueryContinuationToken continuationToken, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> {
            Bundle bundle = new Bundle();
            bundle.putParcelable("query_continuation_token", continuationToken);
            return this.mParticipantQueryHelper.performParticipantQuery(bundle);
        });
    }

    @Override
    public RcsMessageQueryResultParcelable getMessages(RcsMessageQueryParams queryParams, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> {
            Bundle bundle = new Bundle();
            bundle.putParcelable("message_query_parameters", queryParams);
            return this.mMessageQueryHelper.performMessageQuery(bundle);
        });
    }

    @Override
    public RcsMessageQueryResultParcelable getMessagesWithToken(RcsQueryContinuationToken continuationToken, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> {
            Bundle bundle = new Bundle();
            bundle.putParcelable("query_continuation_token", continuationToken);
            return this.mMessageQueryHelper.performMessageQuery(bundle);
        });
    }

    @Override
    public RcsEventQueryResultDescriptor getEvents(RcsEventQueryParams queryParameters, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> {
            Bundle bundle = new Bundle();
            bundle.putParcelable("event_query_parameters", queryParameters);
            return this.mEventQueryHelper.performEventQuery(bundle);
        });
    }

    @Override
    public RcsEventQueryResultDescriptor getEventsWithToken(RcsQueryContinuationToken continuationToken, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> {
            Bundle bundle = new Bundle();
            bundle.putParcelable("query_continuation_token", continuationToken);
            return this.mEventQueryHelper.performEventQuery(bundle);
        });
    }

    @Override
    public int createRcs1To1Thread(int recipientId, String callingPackage) {
        return this.performCreateOperation(callingPackage, () -> this.mThreadQueryHelper.create1To1Thread(recipientId));
    }

    @Override
    public int createGroupThread(int[] participantIds, String groupName, Uri groupIcon, String callingPackage) {
        return this.performCreateOperation(callingPackage, () -> {
            int groupThreadId = this.mThreadQueryHelper.createGroupThread(groupName, groupIcon);
            if (groupThreadId <= 0) {
                throw new RemoteException("Could not create RcsGroupThread.");
            }
            if (participantIds != null) {
                for (int participantId : participantIds) {
                    this.addParticipantToGroupThread(groupThreadId, participantId, callingPackage);
                }
            }
            return groupThreadId;
        });
    }

    @Override
    public int createRcsParticipant(String canonicalAddress, String alias, String callingPackage) {
        return this.performCreateOperation(callingPackage, () -> {
            int newParticipantRowId;
            ContentValues contentValues = new ContentValues();
            long canonicalAddressId = Telephony.RcsColumns.RcsCanonicalAddressHelper.getOrCreateCanonicalAddressId(this.mContentResolver, canonicalAddress);
            if (canonicalAddressId == Integer.MIN_VALUE) {
                throw new RemoteException("Could not create or make canonical address entry");
            }
            contentValues.put("canonical_address_id", canonicalAddressId);
            contentValues.put("rcs_alias", alias);
            Uri newParticipantUri = this.mContentResolver.insert(Telephony.RcsColumns.RcsParticipantColumns.RCS_PARTICIPANT_URI, contentValues);
            if (newParticipantUri == null) {
                throw new RemoteException("Error inserting new participant into RcsProvider");
            }
            try {
                newParticipantRowId = Integer.parseInt(newParticipantUri.getLastPathSegment());
            }
            catch (NumberFormatException e) {
                throw new RemoteException("Uri returned after creating a participant is malformed: " + newParticipantUri);
            }
            return newParticipantRowId;
        });
    }

    @Override
    public String getRcsParticipantCanonicalAddress(int participantId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getStringValueFromTableRow(Telephony.RcsColumns.RcsParticipantColumns.RCS_PARTICIPANT_URI, "address", "rcs_participant_id", participantId));
    }

    @Override
    public String getRcsParticipantAlias(int participantId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getStringValueFromTableRow(Telephony.RcsColumns.RcsParticipantColumns.RCS_PARTICIPANT_URI, "rcs_alias", "rcs_participant_id", participantId));
    }

    @Override
    public void setRcsParticipantAlias(int id2, String alias, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(RcsParticipantQueryHelper.getUriForParticipant(id2), "rcs_alias", alias, "Could not update RCS participant alias"));
    }

    @Override
    public String getRcsParticipantContactId(int participantId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> null);
    }

    @Override
    public void setRcsParticipantContactId(int participantId, String contactId, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> {});
    }

    @Override
    public void set1To1ThreadFallbackThreadId(int rcsThreadId, long fallbackId, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(RcsThreadQueryHelper.get1To1ThreadUri(rcsThreadId), "rcs_fallback_thread_id", fallbackId, "Could not set fallback thread ID"));
    }

    @Override
    public long get1To1ThreadFallbackThreadId(int rcsThreadId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getLongValueFromTableRow(Telephony.RcsColumns.Rcs1To1ThreadColumns.RCS_1_TO_1_THREAD_URI, "rcs_fallback_thread_id", "rcs_thread_id", rcsThreadId));
    }

    @Override
    public int get1To1ThreadOtherParticipantId(int rcsThreadId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> {
            Uri uri = RcsThreadQueryHelper.get1To1ThreadUri(rcsThreadId);
            String[] projection = new String[]{"rcs_participant_id"};
            try (Cursor cursor = this.mContentResolver.query(uri, projection, null, null);){
                if (cursor == null || cursor.getCount() != 1) {
                    throw new RemoteException("Could not get the thread recipient");
                }
                cursor.moveToNext();
                Integer n = cursor.getInt(cursor.getColumnIndex("rcs_participant_id"));
                return n;
            }
        });
    }

    @Override
    public void setGroupThreadName(int rcsThreadId, String groupName, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(RcsThreadQueryHelper.getGroupThreadUri(rcsThreadId), "group_name", groupName, "Could not update group name"));
    }

    @Override
    public String getGroupThreadName(int rcsThreadId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getStringValueFromTableRow(Telephony.RcsColumns.RcsGroupThreadColumns.RCS_GROUP_THREAD_URI, "group_name", "rcs_thread_id", rcsThreadId));
    }

    @Override
    public void setGroupThreadIcon(int rcsThreadId, Uri groupIcon, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(RcsThreadQueryHelper.getGroupThreadUri(rcsThreadId), "group_icon", groupIcon, "Could not update group icon"));
    }

    @Override
    public Uri getGroupThreadIcon(int rcsThreadId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getUriValueFromTableRow(Telephony.RcsColumns.RcsGroupThreadColumns.RCS_GROUP_THREAD_URI, "group_icon", "rcs_thread_id", rcsThreadId));
    }

    @Override
    public void setGroupThreadOwner(int rcsThreadId, int participantId, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(RcsThreadQueryHelper.getGroupThreadUri(rcsThreadId), "owner_participant", participantId, "Could not set the group owner"));
    }

    @Override
    public int getGroupThreadOwner(int rcsThreadId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getIntValueFromTableRow(Telephony.RcsColumns.RcsGroupThreadColumns.RCS_GROUP_THREAD_URI, "owner_participant", "rcs_thread_id", rcsThreadId));
    }

    @Override
    public void setGroupThreadConferenceUri(int rcsThreadId, Uri uri, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(RcsThreadQueryHelper.getGroupThreadUri(rcsThreadId), "conference_uri", uri, "Could not set the conference URI for group"));
    }

    @Override
    public Uri getGroupThreadConferenceUri(int rcsThreadId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getUriValueFromTableRow(Telephony.RcsColumns.RcsGroupThreadColumns.RCS_GROUP_THREAD_URI, "conference_uri", "rcs_thread_id", rcsThreadId));
    }

    @Override
    public void addParticipantToGroupThread(int rcsThreadId, int participantId, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> {
            ContentValues contentValues = new ContentValues(2);
            contentValues.put("rcs_thread_id", rcsThreadId);
            contentValues.put("rcs_participant_id", participantId);
            this.mContentResolver.insert(RcsThreadQueryHelper.getAllParticipantsInThreadUri(rcsThreadId), contentValues);
        });
    }

    @Override
    public void removeParticipantFromGroupThread(int rcsThreadId, int participantId, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mContentResolver.delete(RcsThreadQueryHelper.getParticipantInThreadUri(rcsThreadId, participantId), null, null));
    }

    @Override
    public int addIncomingMessage(int rcsThreadId, RcsIncomingMessageCreationParams rcsIncomingMessageCreationParams, String callingPackage) {
        return this.performCreateOperation(callingPackage, () -> {
            ContentValues contentValues = new ContentValues();
            contentValues.put("arrival_timestamp", rcsIncomingMessageCreationParams.getArrivalTimestamp());
            contentValues.put("seen_timestamp", rcsIncomingMessageCreationParams.getSeenTimestamp());
            contentValues.put("sender_participant", rcsIncomingMessageCreationParams.getSenderParticipantId());
            this.mMessageQueryHelper.createContentValuesForGenericMessage(contentValues, rcsThreadId, rcsIncomingMessageCreationParams);
            return this.addMessage(rcsThreadId, true, contentValues);
        });
    }

    @Override
    public int addOutgoingMessage(int rcsThreadId, RcsOutgoingMessageCreationParams rcsOutgoingMessageCreationParameters, String callingPackage) {
        return this.performCreateOperation(callingPackage, () -> {
            ContentValues contentValues = new ContentValues();
            this.mMessageQueryHelper.createContentValuesForGenericMessage(contentValues, rcsThreadId, rcsOutgoingMessageCreationParameters);
            return this.addMessage(rcsThreadId, false, contentValues);
        });
    }

    private int addMessage(int rcsThreadId, boolean isIncoming, ContentValues contentValues) throws RemoteException {
        Uri uri = this.mContentResolver.insert(this.mMessageQueryHelper.getMessageInsertionUri(isIncoming), contentValues);
        if (uri == null) {
            throw new RemoteException("Could not create message on thread, threadId: " + rcsThreadId);
        }
        return Integer.parseInt(uri.getLastPathSegment());
    }

    @Override
    public void deleteMessage(int messageId, boolean isIncoming, int rcsThreadId, boolean isGroup, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mContentResolver.delete(this.mMessageQueryHelper.getMessageDeletionUri(messageId, isIncoming, rcsThreadId, isGroup), null, null));
    }

    @Override
    public void setMessageSubId(int messageId, boolean isIncoming, int subId, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getMessageUpdateUri(messageId, isIncoming), "sub_id", subId, "Could not set subscription ID for message"));
    }

    @Override
    public int getMessageSubId(int messageId, boolean isIncoming, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getIntValueFromTableRow(RcsMessageStoreUtil.getMessageTableUri(isIncoming), "sub_id", "rcs_message_row_id", messageId));
    }

    @Override
    public void setMessageStatus(int messageId, boolean isIncoming, int status, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getMessageUpdateUri(messageId, isIncoming), "status", status, "Could not set the status for message"));
    }

    @Override
    public int getMessageStatus(int messageId, boolean isIncoming, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getIntValueFromTableRow(RcsMessageStoreUtil.getMessageTableUri(isIncoming), "status", "rcs_message_row_id", messageId));
    }

    @Override
    public void setMessageOriginationTimestamp(int messageId, boolean isIncoming, long originationTimestamp, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getMessageUpdateUri(messageId, isIncoming), "origination_timestamp", originationTimestamp, "Could not set the origination timestamp for message"));
    }

    @Override
    public long getMessageOriginationTimestamp(int messageId, boolean isIncoming, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getLongValueFromTableRow(RcsMessageStoreUtil.getMessageTableUri(isIncoming), "origination_timestamp", "rcs_message_row_id", messageId));
    }

    @Override
    public void setGlobalMessageIdForMessage(int messageId, boolean isIncoming, String globalId, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getMessageUpdateUri(messageId, isIncoming), "rcs_message_global_id", globalId, "Could not set the global ID for message"));
    }

    @Override
    public String getGlobalMessageIdForMessage(int messageId, boolean isIncoming, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getStringValueFromTableRow(RcsMessageStoreUtil.getMessageTableUri(isIncoming), "rcs_message_global_id", "rcs_message_row_id", messageId));
    }

    @Override
    public void setMessageArrivalTimestamp(int messageId, boolean isIncoming, long arrivalTimestamp, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getMessageUpdateUri(messageId, isIncoming), "arrival_timestamp", arrivalTimestamp, "Could not update the arrival timestamp for message"));
    }

    @Override
    public long getMessageArrivalTimestamp(int messageId, boolean isIncoming, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getLongValueFromTableRow(RcsMessageStoreUtil.getMessageTableUri(isIncoming), "arrival_timestamp", "rcs_message_row_id", messageId));
    }

    @Override
    public void setMessageSeenTimestamp(int messageId, boolean isIncoming, long notifiedTimestamp, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getMessageUpdateUri(messageId, isIncoming), "seen_timestamp", notifiedTimestamp, "Could not set the notified timestamp for message"));
    }

    @Override
    public long getMessageSeenTimestamp(int messageId, boolean isIncoming, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getLongValueFromTableRow(RcsMessageStoreUtil.getMessageTableUri(isIncoming), "seen_timestamp", "rcs_message_row_id", messageId));
    }

    @Override
    public int[] getMessageRecipients(int messageId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageQueryHelper.getDeliveryParticipantsForMessage(messageId));
    }

    @Override
    public long getOutgoingDeliveryDeliveredTimestamp(int messageId, int participantId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageQueryHelper.getLongValueFromDelivery(messageId, participantId, "delivered_timestamp"));
    }

    @Override
    public void setOutgoingDeliveryDeliveredTimestamp(int messageId, int participantId, long deliveredTimestamp, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getMessageDeliveryUri(messageId, participantId), "delivered_timestamp", deliveredTimestamp, "Could not update the delivered timestamp for outgoing delivery"));
    }

    @Override
    public long getOutgoingDeliverySeenTimestamp(int messageId, int participantId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageQueryHelper.getLongValueFromDelivery(messageId, participantId, "seen_timestamp"));
    }

    @Override
    public void setOutgoingDeliverySeenTimestamp(int messageId, int participantId, long seenTimestamp, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getMessageDeliveryUri(messageId, participantId), "seen_timestamp", seenTimestamp, "Could not update the seen timestamp for outgoing delivery"));
    }

    @Override
    public int getOutgoingDeliveryStatus(int messageId, int participantId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> 0);
    }

    @Override
    public void setOutgoingDeliveryStatus(int messageId, int participantId, int status, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> {});
    }

    @Override
    public void setTextForMessage(int messageId, boolean isIncoming, String text, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getMessageUpdateUri(messageId, isIncoming), "rcs_text", text, "Could not set the text for message"));
    }

    @Override
    public String getTextForMessage(int messageId, boolean isIncoming, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getStringValueFromTableRow(RcsMessageStoreUtil.getMessageTableUri(isIncoming), "rcs_text", "rcs_message_row_id", messageId));
    }

    @Override
    public void setLatitudeForMessage(int messageId, boolean isIncoming, double latitude, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getMessageUpdateUri(messageId, isIncoming), "latitude", latitude, "Could not update latitude for message"));
    }

    @Override
    public double getLatitudeForMessage(int messageId, boolean isIncoming, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getDoubleValueFromTableRow(RcsMessageStoreUtil.getMessageTableUri(isIncoming), "latitude", "rcs_message_row_id", messageId));
    }

    @Override
    public void setLongitudeForMessage(int messageId, boolean isIncoming, double longitude, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getMessageUpdateUri(messageId, isIncoming), "longitude", longitude, "Could not set longitude for message"));
    }

    @Override
    public double getLongitudeForMessage(int messageId, boolean isIncoming, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getDoubleValueFromTableRow(RcsMessageStoreUtil.getMessageTableUri(isIncoming), "longitude", "rcs_message_row_id", messageId));
    }

    @Override
    public int[] getFileTransfersAttachedToMessage(int messageId, boolean isIncoming, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> new int[0]);
    }

    @Override
    public int getSenderParticipant(int messageId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getIntValueFromTableRow(Telephony.RcsColumns.RcsIncomingMessageColumns.INCOMING_MESSAGE_URI, "sender_participant", "rcs_message_row_id", messageId));
    }

    @Override
    public void deleteFileTransfer(int partId, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mContentResolver.delete(this.mMessageQueryHelper.getFileTransferUpdateUri(partId), null, null));
    }

    @Override
    public int storeFileTransfer(int messageId, boolean isIncoming, RcsFileTransferCreationParams fileTransferCreationParameters, String callingPackage) {
        return this.performCreateOperation(callingPackage, () -> {
            ContentValues contentValues = this.mMessageQueryHelper.getContentValuesForFileTransfer(fileTransferCreationParameters);
            Uri uri = this.mContentResolver.insert(this.mMessageQueryHelper.getFileTransferInsertionUri(messageId), contentValues);
            if (uri != null) {
                return Integer.parseInt(uri.getLastPathSegment());
            }
            return Integer.MIN_VALUE;
        });
    }

    @Override
    public void setFileTransferSessionId(int partId, String sessionId, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getFileTransferUpdateUri(partId), "session_id", sessionId, "Could not set session ID for file transfer"));
    }

    @Override
    public String getFileTransferSessionId(int partId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getStringValueFromTableRow(Telephony.RcsColumns.RcsFileTransferColumns.FILE_TRANSFER_URI, "session_id", "rcs_file_transfer_id", partId));
    }

    @Override
    public void setFileTransferContentUri(int partId, Uri contentUri, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getFileTransferUpdateUri(partId), "content_uri", contentUri, "Could not set content URI for file transfer"));
    }

    @Override
    public Uri getFileTransferContentUri(int partId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getUriValueFromTableRow(Telephony.RcsColumns.RcsFileTransferColumns.FILE_TRANSFER_URI, "content_uri", "rcs_file_transfer_id", partId));
    }

    @Override
    public void setFileTransferContentType(int partId, String contentType, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getFileTransferUpdateUri(partId), "content_type", contentType, "Could not set content type for file transfer"));
    }

    @Override
    public String getFileTransferContentType(int partId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getStringValueFromTableRow(Telephony.RcsColumns.RcsFileTransferColumns.FILE_TRANSFER_URI, "content_type", "rcs_file_transfer_id", partId));
    }

    @Override
    public void setFileTransferFileSize(int partId, long fileSize, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getFileTransferUpdateUri(partId), "file_size", fileSize, "Could not set file size for file transfer"));
    }

    @Override
    public long getFileTransferFileSize(int partId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getLongValueFromTableRow(Telephony.RcsColumns.RcsFileTransferColumns.FILE_TRANSFER_URI, "file_size", "rcs_file_transfer_id", partId));
    }

    @Override
    public void setFileTransferTransferOffset(int partId, long transferOffset, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getFileTransferUpdateUri(partId), "transfer_offset", transferOffset, "Could not set transfer offset for file transfer"));
    }

    @Override
    public long getFileTransferTransferOffset(int partId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getLongValueFromTableRow(Telephony.RcsColumns.RcsFileTransferColumns.FILE_TRANSFER_URI, "transfer_offset", "rcs_file_transfer_id", partId));
    }

    @Override
    public void setFileTransferStatus(int partId, int transferStatus, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getFileTransferUpdateUri(partId), "transfer_status", transferStatus, "Could not set transfer status for file transfer"));
    }

    @Override
    public int getFileTransferStatus(int partId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getIntValueFromTableRow(Telephony.RcsColumns.RcsFileTransferColumns.FILE_TRANSFER_URI, "status", "rcs_file_transfer_id", partId));
    }

    @Override
    public void setFileTransferWidth(int partId, int width, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getFileTransferUpdateUri(partId), "width", width, "Could not set width of file transfer"));
    }

    @Override
    public int getFileTransferWidth(int partId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getIntValueFromTableRow(Telephony.RcsColumns.RcsFileTransferColumns.FILE_TRANSFER_URI, "width", "rcs_file_transfer_id", partId));
    }

    @Override
    public void setFileTransferHeight(int partId, int height, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getFileTransferUpdateUri(partId), "height", height, "Could not set height of file transfer"));
    }

    @Override
    public int getFileTransferHeight(int partId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getIntValueFromTableRow(Telephony.RcsColumns.RcsFileTransferColumns.FILE_TRANSFER_URI, "height", "rcs_file_transfer_id", partId));
    }

    @Override
    public void setFileTransferLength(int partId, long length, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getFileTransferUpdateUri(partId), "duration", length, "Could not set length of file transfer"));
    }

    @Override
    public long getFileTransferLength(int partId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getLongValueFromTableRow(Telephony.RcsColumns.RcsFileTransferColumns.FILE_TRANSFER_URI, "duration", "rcs_file_transfer_id", partId));
    }

    @Override
    public void setFileTransferPreviewUri(int partId, Uri uri, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getFileTransferUpdateUri(partId), "preview_uri", uri, "Could not set preview URI of file transfer"));
    }

    @Override
    public Uri getFileTransferPreviewUri(int partId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getUriValueFromTableRow(Telephony.RcsColumns.RcsFileTransferColumns.FILE_TRANSFER_URI, "duration", "rcs_file_transfer_id", partId));
    }

    @Override
    public void setFileTransferPreviewType(int partId, String type, String callingPackage) {
        this.performWriteOperation(callingPackage, () -> this.mMessageStoreUtil.updateValueOfProviderUri(this.mMessageQueryHelper.getFileTransferUpdateUri(partId), "preview_type", type, "Could not set preview type of file transfer"));
    }

    @Override
    public String getFileTransferPreviewType(int partId, String callingPackage) {
        return this.performReadOperation(callingPackage, () -> this.mMessageStoreUtil.getStringValueFromTableRow(Telephony.RcsColumns.RcsFileTransferColumns.FILE_TRANSFER_URI, "preview_type", "rcs_file_transfer_id", partId));
    }

    @Override
    public int createGroupThreadNameChangedEvent(long timestamp, int threadId, int originationParticipantId, String newName, String callingPackage) {
        return this.performCreateOperation(callingPackage, () -> {
            ContentValues eventSpecificValues = new ContentValues();
            eventSpecificValues.put("new_name", newName);
            return this.mEventQueryHelper.createGroupThreadEvent(16, timestamp, threadId, originationParticipantId, eventSpecificValues);
        });
    }

    @Override
    public int createGroupThreadIconChangedEvent(long timestamp, int threadId, int originationParticipantId, Uri newIcon, String callingPackage) {
        return this.performCreateOperation(callingPackage, () -> {
            ContentValues eventSpecificValues = new ContentValues();
            eventSpecificValues.put("new_icon_uri", newIcon == null ? null : newIcon.toString());
            return this.mEventQueryHelper.createGroupThreadEvent(8, timestamp, threadId, originationParticipantId, eventSpecificValues);
        });
    }

    @Override
    public int createGroupThreadParticipantJoinedEvent(long timestamp, int threadId, int originationParticipantId, int participantId, String callingPackage) {
        return this.performCreateOperation(callingPackage, () -> {
            ContentValues eventSpecificValues = new ContentValues();
            eventSpecificValues.put("destination_participant", participantId);
            return this.mEventQueryHelper.createGroupThreadEvent(2, timestamp, threadId, originationParticipantId, eventSpecificValues);
        });
    }

    @Override
    public int createGroupThreadParticipantLeftEvent(long timestamp, int threadId, int originationParticipantId, int participantId, String callingPackage) {
        return this.performCreateOperation(callingPackage, () -> {
            ContentValues eventSpecificValues = new ContentValues();
            eventSpecificValues.put("destination_participant", participantId);
            return this.mEventQueryHelper.createGroupThreadEvent(4, timestamp, threadId, originationParticipantId, eventSpecificValues);
        });
    }

    @Override
    public int createParticipantAliasChangedEvent(long timestamp, int participantId, String newAlias, String callingPackage) {
        return this.performCreateOperation(callingPackage, () -> {
            ContentValues contentValues = new ContentValues(4);
            contentValues.put("origination_timestamp", timestamp);
            contentValues.put("source_participant", participantId);
            contentValues.put("new_alias", newAlias);
            Uri uri = this.mContentResolver.insert(this.mEventQueryHelper.getParticipantEventInsertionUri(participantId), contentValues);
            if (uri == null) {
                throw new RemoteException("Could not create RcsParticipantAliasChangedEvent with participant id: " + participantId);
            }
            return Integer.parseInt(uri.getLastPathSegment());
        });
    }

    static interface ThrowingRunnable {
        public void run() throws RemoteException;
    }

    static interface ThrowingSupplier<T> {
        public T get() throws RemoteException;
    }
}

