/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.Telephony;
import android.text.TextUtils;

public class RcsMessageStoreUtil {
    private ContentResolver mContentResolver;

    RcsMessageStoreUtil(ContentResolver contentResolver) {
        this.mContentResolver = contentResolver;
    }

    int getIntValueFromTableRow(Uri tableUri, String valueColumn, String idColumn, int idValue) throws RemoteException {
        Throwable throwable = null;
        try (Cursor cursor = this.getValueFromTableRow(tableUri, valueColumn, idColumn, idValue);){
            if (cursor != null && cursor.moveToFirst()) {
                int n = cursor.getInt(cursor.getColumnIndex(valueColumn));
                return n;
            }
            try {
                throw new RemoteException("The row with (" + idColumn + " = " + idValue + ") could not be found in " + tableUri);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    long getLongValueFromTableRow(Uri tableUri, String valueColumn, String idColumn, int idValue) throws RemoteException {
        Throwable throwable = null;
        try (Cursor cursor = this.getValueFromTableRow(tableUri, valueColumn, idColumn, idValue);){
            if (cursor != null && cursor.moveToFirst()) {
                long l = cursor.getLong(cursor.getColumnIndex(valueColumn));
                return l;
            }
            try {
                throw new RemoteException("The row with (" + idColumn + " = " + idValue + ") could not be found in " + tableUri);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    double getDoubleValueFromTableRow(Uri tableUri, String valueColumn, String idColumn, int idValue) throws RemoteException {
        Throwable throwable = null;
        try (Cursor cursor = this.getValueFromTableRow(tableUri, valueColumn, idColumn, idValue);){
            if (cursor != null && cursor.moveToFirst()) {
                double d = cursor.getDouble(cursor.getColumnIndex(valueColumn));
                return d;
            }
            try {
                throw new RemoteException("The row with (" + idColumn + " = " + idValue + ") could not be found in " + tableUri);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    String getStringValueFromTableRow(Uri tableUri, String valueColumn, String idColumn, int idValue) throws RemoteException {
        Throwable throwable = null;
        try (Cursor cursor = this.getValueFromTableRow(tableUri, valueColumn, idColumn, idValue);){
            if (cursor != null && cursor.moveToFirst()) {
                String string2 = cursor.getString(cursor.getColumnIndex(valueColumn));
                return string2;
            }
            try {
                throw new RemoteException("The row with (" + idColumn + " = " + idValue + ") could not be found in " + tableUri);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    Uri getUriValueFromTableRow(Uri tableUri, String valueColumn, String idColumn, int idValue) throws RemoteException {
        Throwable throwable = null;
        try (Cursor cursor = this.getValueFromTableRow(tableUri, valueColumn, idColumn, idValue);){
            if (cursor != null && cursor.moveToFirst()) {
                String uriAsString = cursor.getString(cursor.getColumnIndex(valueColumn));
                if (!TextUtils.isEmpty(uriAsString)) {
                    Uri uri = Uri.parse(uriAsString);
                    return uri;
                }
                Uri uri = null;
                return uri;
            }
            try {
                throw new RemoteException("The row with (" + idColumn + " = " + idValue + ") could not be found in " + tableUri);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    void updateValueOfProviderUri(Uri uri, String valueColumn, int value, String errorMessage) throws RemoteException {
        ContentValues contentValues = new ContentValues(1);
        contentValues.put(valueColumn, value);
        this.performUpdate(uri, contentValues, errorMessage);
    }

    void updateValueOfProviderUri(Uri uri, String valueColumn, double value, String errorMessage) throws RemoteException {
        ContentValues contentValues = new ContentValues(1);
        contentValues.put(valueColumn, value);
        this.performUpdate(uri, contentValues, errorMessage);
    }

    void updateValueOfProviderUri(Uri uri, String valueColumn, long value, String errorMessage) throws RemoteException {
        ContentValues contentValues = new ContentValues(1);
        contentValues.put(valueColumn, value);
        this.performUpdate(uri, contentValues, errorMessage);
    }

    void updateValueOfProviderUri(Uri uri, String valueColumn, String value, String errorMessage) throws RemoteException {
        ContentValues contentValues = new ContentValues(1);
        contentValues.put(valueColumn, value);
        this.performUpdate(uri, contentValues, errorMessage);
    }

    void updateValueOfProviderUri(Uri uri, String valueColumn, Uri value, String errorMessage) throws RemoteException {
        ContentValues contentValues = new ContentValues(1);
        contentValues.put(valueColumn, value == null ? null : value.toString());
        this.performUpdate(uri, contentValues, errorMessage);
    }

    private void performUpdate(Uri uri, ContentValues contentValues, String errorMessage) throws RemoteException {
        int updateCount = this.mContentResolver.update(uri, contentValues, null, null);
        if (updateCount <= 0) {
            throw new RemoteException(errorMessage);
        }
    }

    private Cursor getValueFromTableRow(Uri tableUri, String valueColumn, String idColumn, int idValue) {
        return this.mContentResolver.query(tableUri, new String[]{valueColumn}, idColumn + "=?", new String[]{Integer.toString(idValue)}, null);
    }

    static Uri getMessageTableUri(boolean isIncoming) {
        return isIncoming ? Telephony.RcsColumns.RcsIncomingMessageColumns.INCOMING_MESSAGE_URI : Telephony.RcsColumns.RcsOutgoingMessageColumns.OUTGOING_MESSAGE_URI;
    }
}

