/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.provider.Telephony;
import android.telephony.ims.RcsParticipantQueryResultParcelable;
import android.telephony.ims.RcsQueryContinuationToken;
import java.util.ArrayList;

class RcsParticipantQueryHelper {
    private final ContentResolver mContentResolver;

    RcsParticipantQueryHelper(ContentResolver contentResolver) {
        this.mContentResolver = contentResolver;
    }

    RcsParticipantQueryResultParcelable performParticipantQuery(Bundle bundle) throws RemoteException {
        RcsQueryContinuationToken continuationToken = null;
        ArrayList<Integer> participantList = new ArrayList<Integer>();
        try (Cursor cursor = this.mContentResolver.query(Telephony.RcsColumns.RcsParticipantColumns.RCS_PARTICIPANT_URI, null, bundle, null);){
            if (cursor == null) {
                throw new RemoteException("Could not perform participant query, bundle: " + bundle);
            }
            while (cursor.moveToNext()) {
                participantList.add(cursor.getInt(cursor.getColumnIndex("rcs_participant_id")));
            }
            Bundle cursorExtras = cursor.getExtras();
            if (cursorExtras != null) {
                continuationToken = (RcsQueryContinuationToken)cursorExtras.getParcelable("query_continuation_token");
            }
        }
        return new RcsParticipantQueryResultParcelable(continuationToken, participantList);
    }

    static Uri getUriForParticipant(int participantId) {
        return Uri.withAppendedPath(Telephony.RcsColumns.RcsParticipantColumns.RCS_PARTICIPANT_URI, Integer.toString(participantId));
    }
}

