/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;

class RcsPermissions {
    RcsPermissions() {
    }

    static void checkReadPermissions(Context context, String callingPackage) {
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        context.enforcePermission("android.permission.READ_SMS", pid, uid, null);
        RcsPermissions.checkOp(context, uid, callingPackage, 14);
    }

    static void checkWritePermissions(Context context, String callingPackage) {
        int uid = Binder.getCallingUid();
        RcsPermissions.checkOp(context, uid, callingPackage, 15);
    }

    private static void checkOp(Context context, int uid, String callingPackage, int op) {
        AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
        int mode = appOps.noteOp(op, uid, callingPackage);
        if (mode != 0) {
            throw new SecurityException(AppOpsManager.opToName(op) + " not allowed for " + callingPackage);
        }
    }
}

