/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.provider.Telephony;
import android.telephony.ims.RcsQueryContinuationToken;
import android.telephony.ims.RcsThreadQueryResultParcelable;
import com.android.ims.RcsTypeIdPair;
import com.android.internal.telephony.ims.RcsParticipantQueryHelper;
import java.util.ArrayList;

class RcsThreadQueryHelper {
    private static final int THREAD_ID_INDEX_IN_INSERTION_URI = 1;
    private final ContentResolver mContentResolver;
    private final RcsParticipantQueryHelper mParticipantQueryHelper;

    RcsThreadQueryHelper(ContentResolver contentResolver, RcsParticipantQueryHelper participantQueryHelper) {
        this.mContentResolver = contentResolver;
        this.mParticipantQueryHelper = participantQueryHelper;
    }

    RcsThreadQueryResultParcelable performThreadQuery(Bundle bundle) throws RemoteException {
        RcsQueryContinuationToken continuationToken = null;
        ArrayList<RcsTypeIdPair> rcsThreadIdList = new ArrayList<RcsTypeIdPair>();
        try (Cursor cursor = this.mContentResolver.query(Telephony.RcsColumns.RcsThreadColumns.RCS_THREAD_URI, null, bundle, null);){
            if (cursor == null) {
                throw new RemoteException("Could not perform thread query, bundle: " + bundle);
            }
            while (cursor.moveToNext()) {
                int threadId;
                boolean isGroup;
                boolean bl = isGroup = cursor.getInt(cursor.getColumnIndex("thread_type")) == 1;
                if (isGroup) {
                    threadId = cursor.getInt(cursor.getColumnIndex("rcs_thread_id"));
                    rcsThreadIdList.add(new RcsTypeIdPair(1, threadId));
                    continue;
                }
                threadId = cursor.getInt(cursor.getColumnIndex("rcs_thread_id"));
                rcsThreadIdList.add(new RcsTypeIdPair(0, threadId));
            }
            Bundle cursorExtras = cursor.getExtras();
            if (cursorExtras != null) {
                continuationToken = (RcsQueryContinuationToken)cursorExtras.getParcelable("query_continuation_token");
            }
        }
        return new RcsThreadQueryResultParcelable(continuationToken, rcsThreadIdList);
    }

    int create1To1Thread(int participantId) throws RemoteException {
        ContentValues contentValues = new ContentValues(1);
        contentValues.put("rcs_participant_id", participantId);
        Uri insertionUri = this.mContentResolver.insert(Telephony.RcsColumns.Rcs1To1ThreadColumns.RCS_1_TO_1_THREAD_URI, contentValues);
        if (insertionUri == null) {
            throw new RemoteException("Rcs1To1Thread creation failed");
        }
        String threadIdAsString = insertionUri.getLastPathSegment();
        int threadId = Integer.parseInt(threadIdAsString);
        if (threadId <= 0) {
            throw new RemoteException("Rcs1To1Thread creation failed");
        }
        return threadId;
    }

    int createGroupThread(String groupName, Uri groupIcon) throws RemoteException {
        Uri groupUri;
        ContentValues contentValues = new ContentValues(1);
        contentValues.put("group_name", groupName);
        if (groupIcon != null) {
            contentValues.put("group_icon", groupIcon.toString());
        }
        if ((groupUri = this.mContentResolver.insert(Telephony.RcsColumns.RcsGroupThreadColumns.RCS_GROUP_THREAD_URI, contentValues)) == null) {
            throw new RemoteException("RcsGroupThread creation failed");
        }
        String threadIdAsString = groupUri.getPathSegments().get(1);
        int threadId = Integer.parseInt(threadIdAsString);
        return threadId;
    }

    static Uri get1To1ThreadUri(int rcsThreadId) {
        return Uri.withAppendedPath(Telephony.RcsColumns.Rcs1To1ThreadColumns.RCS_1_TO_1_THREAD_URI, Integer.toString(rcsThreadId));
    }

    static Uri getGroupThreadUri(int rcsThreadId) {
        return Uri.withAppendedPath(Telephony.RcsColumns.RcsGroupThreadColumns.RCS_GROUP_THREAD_URI, Integer.toString(rcsThreadId));
    }

    static Uri getAllParticipantsInThreadUri(int rcsThreadId) {
        return Telephony.RcsColumns.RcsGroupThreadColumns.RCS_GROUP_THREAD_URI.buildUpon().appendPath(Integer.toString(rcsThreadId)).appendPath("participant").build();
    }

    static Uri getParticipantInThreadUri(int rcsThreadId, int participantId) {
        return Telephony.RcsColumns.RcsGroupThreadColumns.RCS_GROUP_THREAD_URI.buildUpon().appendPath(Integer.toString(rcsThreadId)).appendPath("participant").appendPath(Integer.toString(participantId)).build();
    }
}

