/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.annotation.UnsupportedAppUsage;
import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.NetworkStats;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.ResultReceiver;
import android.os.SystemProperties;
import android.telecom.Connection;
import android.telephony.CarrierConfigManager;
import android.telephony.NetworkRegistrationInfo;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.UssdResponse;
import android.telephony.ims.ImsCallForwardInfo;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsSsInfo;
import android.text.TextUtils;
import com.android.ims.ImsEcbm;
import com.android.ims.ImsEcbmStateListener;
import com.android.ims.ImsException;
import com.android.ims.ImsManager;
import com.android.ims.ImsUtInterface;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.dataconnection.TransportManager;
import com.android.internal.telephony.emergency.EmergencyNumberTracker;
import com.android.internal.telephony.gsm.GsmMmiCode;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.imsphone.ImsExternalCallTracker;
import com.android.internal.telephony.imsphone.ImsPhoneBase;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import com.android.internal.telephony.imsphone.ImsPhoneMmiCode;
import com.android.internal.telephony.uicc.IccRecords;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class ImsPhone
extends ImsPhoneBase {
    private static final String LOG_TAG = "ImsPhone";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int EVENT_SET_CALL_BARRING_DONE = 53;
    private static final int EVENT_GET_CALL_BARRING_DONE = 54;
    private static final int EVENT_SET_CALL_WAITING_DONE = 55;
    private static final int EVENT_GET_CALL_WAITING_DONE = 56;
    private static final int EVENT_SET_CLIR_DONE = 57;
    private static final int EVENT_GET_CLIR_DONE = 58;
    private static final int EVENT_DEFAULT_PHONE_DATA_STATE_CHANGED = 59;
    @VisibleForTesting
    public static final int EVENT_SERVICE_STATE_CHANGED = 60;
    private static final int EVENT_VOICE_CALL_ENDED = 61;
    static final int RESTART_ECM_TIMER = 0;
    static final int CANCEL_ECM_TIMER = 1;
    private static final int DEFAULT_ECM_EXIT_TIMER_VALUE = 300000;
    Phone mDefaultPhone;
    @UnsupportedAppUsage
    ImsPhoneCallTracker mCT;
    ImsExternalCallTracker mExternalCallTracker;
    @UnsupportedAppUsage
    private ArrayList<ImsPhoneMmiCode> mPendingMMIs = new ArrayList();
    @UnsupportedAppUsage
    private ServiceState mSS = new ServiceState();
    private String mLastDialString;
    private PowerManager.WakeLock mWakeLock;
    private Registrant mEcmExitRespRegistrant;
    private final RegistrantList mSilentRedialRegistrants = new RegistrantList();
    private boolean mImsRegistered = false;
    private boolean mRoaming = false;
    private RegistrantList mSsnRegistrants = new RegistrantList();
    private Runnable mExitEcmRunnable = new Runnable(){

        @Override
        public void run() {
            ImsPhone.this.exitEmergencyCallbackMode();
        }
    };
    private Uri[] mCurrentSubscriberUris;
    private ImsEcbmStateListener mImsEcbmStateListener = new ImsEcbmStateListener(){

        @Override
        public void onECBMEntered() {
            ImsPhone.this.logd("onECBMEntered");
            ImsPhone.this.handleEnterEmergencyCallbackMode();
        }

        @Override
        public void onECBMExited() {
            ImsPhone.this.logd("onECBMExited");
            ImsPhone.this.handleExitEmergencyCallbackMode();
        }
    };
    private BroadcastReceiver mResultReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (this.getResultCode() == -1) {
                CharSequence title = intent.getCharSequenceExtra("alertTitle");
                CharSequence messageAlert = intent.getCharSequenceExtra("alertMessage");
                CharSequence messageNotification = intent.getCharSequenceExtra("notificationMessage");
                Intent resultIntent = new Intent("android.intent.action.MAIN");
                resultIntent.setClassName("com.android.settings", "com.android.settings.Settings$WifiCallingSettingsActivity");
                resultIntent.putExtra("alertShow", true);
                resultIntent.putExtra("alertTitle", title);
                resultIntent.putExtra("alertMessage", messageAlert);
                PendingIntent resultPendingIntent = PendingIntent.getActivity(ImsPhone.this.mContext, 0, resultIntent, 0x8000000);
                Notification notification = new Notification.Builder(ImsPhone.this.mContext).setSmallIcon(17301642).setContentTitle(title).setContentText(messageNotification).setAutoCancel(true).setContentIntent(resultPendingIntent).setStyle(new Notification.BigTextStyle().bigText(messageNotification)).setChannelId("wfc").build();
                String notificationTag = "wifi_calling";
                boolean notificationId = true;
                NotificationManager notificationManager = (NotificationManager)ImsPhone.this.mContext.getSystemService("notification");
                notificationManager.notify("wifi_calling", 1, notification);
            }
        }
    };

    protected void setCurrentSubscriberUris(Uri[] currentSubscriberUris) {
        this.mCurrentSubscriberUris = currentSubscriberUris;
    }

    @Override
    public Uri[] getCurrentSubscriberUris() {
        return this.mCurrentSubscriberUris;
    }

    @Override
    public EmergencyNumberTracker getEmergencyNumberTracker() {
        return this.mDefaultPhone.getEmergencyNumberTracker();
    }

    @Override
    public ServiceStateTracker getServiceStateTracker() {
        return this.mDefaultPhone.getServiceStateTracker();
    }

    public ImsPhone(Context context, PhoneNotifier notifier, Phone defaultPhone) {
        this(context, notifier, defaultPhone, false);
    }

    @VisibleForTesting
    public ImsPhone(Context context, PhoneNotifier notifier, Phone defaultPhone, boolean unitTestMode) {
        super(LOG_TAG, context, notifier, unitTestMode);
        this.mDefaultPhone = defaultPhone;
        this.mExternalCallTracker = TelephonyComponentFactory.getInstance().inject(ImsExternalCallTracker.class.getName()).makeImsExternalCallTracker(this);
        this.mCT = TelephonyComponentFactory.getInstance().inject(ImsPhoneCallTracker.class.getName()).makeImsPhoneCallTracker(this);
        this.mCT.registerPhoneStateListener(this.mExternalCallTracker);
        this.mExternalCallTracker.setCallPuller(this.mCT);
        this.mSS.setStateOff();
        this.mPhoneId = this.mDefaultPhone.getPhoneId();
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, LOG_TAG);
        this.mWakeLock.setReferenceCounted(false);
        if (this.mDefaultPhone.getServiceStateTracker() != null && this.mDefaultPhone.getTransportManager() != null) {
            for (int transport : this.mDefaultPhone.getTransportManager().getAvailableTransports()) {
                this.mDefaultPhone.getServiceStateTracker().registerForDataRegStateOrRatChanged(transport, this, 59, null);
            }
        }
        this.setServiceState(1);
        this.mDefaultPhone.registerForServiceStateChanged(this, 60, null);
    }

    @Override
    public void dispose() {
        this.logd("dispose");
        this.mPendingMMIs.clear();
        this.mExternalCallTracker.tearDown();
        this.mCT.unregisterPhoneStateListener(this.mExternalCallTracker);
        this.mCT.unregisterForVoiceCallEnded(this);
        this.mCT.dispose();
        if (this.mDefaultPhone != null && this.mDefaultPhone.getServiceStateTracker() != null) {
            for (int transport : this.mDefaultPhone.getTransportManager().getAvailableTransports()) {
                this.mDefaultPhone.getServiceStateTracker().unregisterForDataRegStateOrRatChanged(transport, this);
            }
            this.mDefaultPhone.unregisterForServiceStateChanged(this);
        }
    }

    @Override
    @UnsupportedAppUsage
    public ServiceState getServiceState() {
        return this.mSS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @VisibleForTesting
    public void setServiceState(int state) {
        boolean isVoiceRegStateChanged = false;
        ImsPhone imsPhone = this;
        synchronized (imsPhone) {
            isVoiceRegStateChanged = this.mSS.getVoiceRegState() != state;
            this.mSS.setVoiceRegState(state);
        }
        this.updateDataServiceState();
        if (isVoiceRegStateChanged && this.mDefaultPhone.getServiceStateTracker() != null) {
            this.mDefaultPhone.getServiceStateTracker().onImsServiceStateChanged();
        }
    }

    @Override
    public CallTracker getCallTracker() {
        return this.mCT;
    }

    public ImsExternalCallTracker getExternalCallTracker() {
        return this.mExternalCallTracker;
    }

    public List<? extends ImsPhoneMmiCode> getPendingMmiCodes() {
        return this.mPendingMMIs;
    }

    @Override
    public void acceptCall(int videoState) throws CallStateException {
        this.mCT.acceptCall(videoState);
    }

    @Override
    public void rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        throw new UnsupportedOperationException("Use hold() and unhold() instead.");
    }

    @Override
    public boolean canConference() {
        return this.mCT.canConference();
    }

    @Override
    public boolean canDial() {
        try {
            this.mCT.checkForDialIssues();
        }
        catch (CallStateException cse) {
            return false;
        }
        return true;
    }

    @Override
    public void conference() {
        this.mCT.conference();
    }

    @Override
    public void clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    @Override
    public boolean canTransfer() {
        return this.mCT.canTransfer();
    }

    @Override
    public void explicitCallTransfer() {
        this.mCT.explicitCallTransfer();
    }

    @Override
    @UnsupportedAppUsage
    public ImsPhoneCall getForegroundCall() {
        return this.mCT.mForegroundCall;
    }

    @Override
    @UnsupportedAppUsage
    public ImsPhoneCall getBackgroundCall() {
        return this.mCT.mBackgroundCall;
    }

    @Override
    @UnsupportedAppUsage
    public ImsPhoneCall getRingingCall() {
        return this.mCT.mRingingCall;
    }

    @Override
    public boolean isImsAvailable() {
        return this.mCT.isImsServiceReady();
    }

    public void holdActiveCall() throws CallStateException {
        this.mCT.holdActiveCall();
    }

    public void unholdHeldCall() throws CallStateException {
        this.mCT.unholdHeldCall();
    }

    private boolean handleCallDeflectionIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        if (this.getRingingCall().getState() != Call.State.IDLE) {
            this.logd("MmiCode 0: rejectCall");
            try {
                this.mCT.rejectCall();
            }
            catch (CallStateException e) {
                Rlog.d(LOG_TAG, "reject failed", e);
                this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.REJECT);
            }
        } else if (this.getBackgroundCall().getState() != Call.State.IDLE) {
            this.logd("MmiCode 0: hangupWaitingOrBackground");
            try {
                this.mCT.hangup(this.getBackgroundCall());
            }
            catch (CallStateException e) {
                Rlog.d(LOG_TAG, "hangup failed", e);
            }
        }
        return true;
    }

    private void sendUssdResponse(String ussdRequest, CharSequence message, int returnCode, ResultReceiver wrappedCallback) {
        UssdResponse response = new UssdResponse(ussdRequest, message);
        Bundle returnData = new Bundle();
        returnData.putParcelable("USSD_RESPONSE", response);
        wrappedCallback.send(returnCode, returnData);
    }

    @Override
    public boolean handleUssdRequest(String ussdRequest, ResultReceiver wrappedCallback) throws CallStateException {
        if (this.mPendingMMIs.size() > 0) {
            this.logi("handleUssdRequest: queue full: " + Rlog.pii(LOG_TAG, (Object)ussdRequest));
            this.sendUssdResponse(ussdRequest, null, -1, wrappedCallback);
            return true;
        }
        try {
            this.dialInternal(ussdRequest, new ImsDialArgs.Builder().build(), wrappedCallback);
        }
        catch (CallStateException cse) {
            if ("cs_fallback".equals(cse.getMessage())) {
                throw cse;
            }
            Rlog.w(LOG_TAG, "Could not execute USSD " + cse);
            this.sendUssdResponse(ussdRequest, null, -1, wrappedCallback);
        }
        catch (Exception e) {
            Rlog.w(LOG_TAG, "Could not execute USSD " + e);
            this.sendUssdResponse(ussdRequest, null, -1, wrappedCallback);
            return false;
        }
        return true;
    }

    private boolean handleCallWaitingIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        ImsPhoneCall call = this.getForegroundCall();
        try {
            if (len > 1) {
                this.logd("not support 1X SEND");
                this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.HANGUP);
            } else if (call.getState() != Call.State.IDLE) {
                this.logd("MmiCode 1: hangup foreground");
                this.mCT.hangup(call);
            } else {
                this.logd("MmiCode 1: holdActiveCallForWaitingCall");
                this.mCT.holdActiveCallForWaitingCall();
            }
        }
        catch (CallStateException e) {
            Rlog.d(LOG_TAG, "hangup failed", e);
            this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.HANGUP);
        }
        return true;
    }

    private boolean handleCallHoldIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        if (len > 1) {
            this.logd("separate not supported");
            this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.SEPARATE);
        } else {
            try {
                if (this.getRingingCall().getState() != Call.State.IDLE) {
                    this.logd("MmiCode 2: accept ringing call");
                    this.mCT.acceptCall(2);
                } else {
                    this.logd("MmiCode 2: holdActiveCall");
                    this.mCT.holdActiveCall();
                }
            }
            catch (CallStateException e) {
                Rlog.d(LOG_TAG, "switch failed", e);
                this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.SWITCH);
            }
        }
        return true;
    }

    private boolean handleMultipartyIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        this.logd("MmiCode 3: merge calls");
        this.conference();
        return true;
    }

    private boolean handleEctIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len != 1) {
            return false;
        }
        this.logd("MmiCode 4: not support explicit call transfer");
        this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.TRANSFER);
        return true;
    }

    private boolean handleCcbsIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        this.logi("MmiCode 5: CCBS not supported!");
        this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.UNKNOWN);
        return true;
    }

    public void notifySuppSvcNotification(SuppServiceNotification suppSvc) {
        this.logd("notifySuppSvcNotification: suppSvc = " + suppSvc);
        AsyncResult ar = new AsyncResult(null, suppSvc, null);
        this.mSsnRegistrants.notifyRegistrants(ar);
    }

    @Override
    @UnsupportedAppUsage
    public boolean handleInCallMmiCommands(String dialString) {
        if (!this.isInCall()) {
            return false;
        }
        if (TextUtils.isEmpty(dialString)) {
            return false;
        }
        boolean result = false;
        char ch = dialString.charAt(0);
        switch (ch) {
            case '0': {
                result = this.handleCallDeflectionIncallSupplementaryService(dialString);
                break;
            }
            case '1': {
                result = this.handleCallWaitingIncallSupplementaryService(dialString);
                break;
            }
            case '2': {
                result = this.handleCallHoldIncallSupplementaryService(dialString);
                break;
            }
            case '3': {
                result = this.handleMultipartyIncallSupplementaryService(dialString);
                break;
            }
            case '4': {
                result = this.handleEctIncallSupplementaryService(dialString);
                break;
            }
            case '5': {
                result = this.handleCcbsIncallSupplementaryService(dialString);
                break;
            }
        }
        return result;
    }

    @Override
    boolean isInCall() {
        Call.State foregroundCallState = this.getForegroundCall().getState();
        Call.State backgroundCallState = this.getBackgroundCall().getState();
        Call.State ringingCallState = this.getRingingCall().getState();
        return foregroundCallState.isAlive() || backgroundCallState.isAlive() || ringingCallState.isAlive();
    }

    @Override
    public boolean isInEcm() {
        return this.mDefaultPhone.isInEcm();
    }

    @Override
    public void setIsInEcm(boolean isInEcm) {
        this.mDefaultPhone.setIsInEcm(isInEcm);
    }

    public void notifyNewRingingConnection(Connection c) {
        this.mDefaultPhone.notifyNewRingingConnectionP(c);
    }

    @UnsupportedAppUsage
    void notifyUnknownConnection(Connection c) {
        this.mDefaultPhone.notifyUnknownConnectionP(c);
    }

    @Override
    public void notifyForVideoCapabilityChanged(boolean isVideoCapable) {
        this.mIsVideoCapable = isVideoCapable;
        this.mDefaultPhone.notifyForVideoCapabilityChanged(isVideoCapable);
    }

    @Override
    public void setRadioPower(boolean on) {
        this.mDefaultPhone.setRadioPower(on);
    }

    @Override
    public Connection dial(String dialString, PhoneInternalInterface.DialArgs dialArgs) throws CallStateException {
        return this.dialInternal(dialString, dialArgs, null);
    }

    private Connection dialInternal(String dialString, PhoneInternalInterface.DialArgs dialArgs, ResultReceiver wrappedCallback) throws CallStateException {
        block7: {
            String newDialString = PhoneNumberUtils.stripSeparators(dialString);
            if (this.handleInCallMmiCommands(newDialString)) {
                return null;
            }
            ImsDialArgs.Builder imsDialArgsBuilder = !(dialArgs instanceof ImsDialArgs) ? ImsDialArgs.Builder.from(dialArgs) : ImsDialArgs.Builder.from((ImsDialArgs)dialArgs);
            imsDialArgsBuilder.setClirMode(this.mCT.getClirMode());
            if (this.mDefaultPhone.getPhoneType() == 2) {
                return this.mCT.dial(dialString, imsDialArgsBuilder.build());
            }
            String networkPortion = PhoneNumberUtils.extractNetworkPortionAlt(newDialString);
            ImsPhoneMmiCode mmi = ImsPhoneMmiCode.newFromDialString(networkPortion, this, wrappedCallback);
            this.logd("dialInternal: dialing w/ mmi '" + mmi + "'...");
            if (mmi == null) {
                return this.mCT.dial(dialString, imsDialArgsBuilder.build());
            }
            if (mmi.isTemporaryModeCLIR()) {
                imsDialArgsBuilder.setClirMode(mmi.getCLIRMode());
                return this.mCT.dial(mmi.getDialingNumber(), imsDialArgsBuilder.build());
            }
            if (!mmi.isSupportedOverImsPhone()) {
                this.logi("dialInternal: USSD not supported by IMS; fallback to CS.");
                throw new CallStateException("cs_fallback");
            }
            this.mPendingMMIs.add(mmi);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            try {
                mmi.processCode();
            }
            catch (CallStateException cse) {
                if (!"cs_fallback".equals(cse.getMessage())) break block7;
                this.logi("dialInternal: fallback to GSM required.");
                this.mPendingMMIs.remove(mmi);
                throw cse;
            }
        }
        return null;
    }

    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            this.loge("sendDtmf called with invalid character '" + c + "'");
        } else if (this.mCT.getState() == PhoneConstants.State.OFFHOOK) {
            this.mCT.sendDtmf(c, null);
        }
    }

    @Override
    public void startDtmf(char c) {
        if (!(PhoneNumberUtils.is12Key(c) || c >= 'A' && c <= 'D')) {
            this.loge("startDtmf called with invalid character '" + c + "'");
        } else {
            this.mCT.startDtmf(c);
        }
    }

    @Override
    public void stopDtmf() {
        this.mCT.stopDtmf();
    }

    public void notifyIncomingRing() {
        this.logd("notifyIncomingRing");
        AsyncResult ar = new AsyncResult(null, null, null);
        this.sendMessage(this.obtainMessage(14, ar));
    }

    @Override
    public void setMute(boolean muted) {
        this.mCT.setMute(muted);
    }

    @Override
    public void setTTYMode(int ttyMode, Message onComplete) {
        this.mCT.setTtyMode(ttyMode);
    }

    @Override
    public void setUiTTYMode(int uiTtyMode, Message onComplete) {
        this.mCT.setUiTTYMode(uiTtyMode, onComplete);
    }

    @Override
    public boolean getMute() {
        return this.mCT.getMute();
    }

    @Override
    @UnsupportedAppUsage
    public PhoneConstants.State getState() {
        return this.mCT.getState();
    }

    @UnsupportedAppUsage
    private boolean isValidCommandInterfaceCFReason(int commandInterfaceCFReason) {
        switch (commandInterfaceCFReason) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @UnsupportedAppUsage
    private boolean isValidCommandInterfaceCFAction(int commandInterfaceCFAction) {
        switch (commandInterfaceCFAction) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @UnsupportedAppUsage
    private boolean isCfEnable(int action) {
        return action == 1 || action == 3;
    }

    @UnsupportedAppUsage
    private int getConditionFromCFReason(int reason) {
        switch (reason) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return -1;
    }

    private int getCFReasonFromCondition(int condition) {
        switch (condition) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 3;
    }

    @UnsupportedAppUsage
    private int getActionFromCFAction(int action) {
        switch (action) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message onComplete) {
        this.logd("getCLIR");
        Message resp = this.obtainMessage(58, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.queryCLIR(resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    @Override
    public void setOutgoingCallerIdDisplay(int clirMode, Message onComplete) {
        this.logd("setCLIR action= " + clirMode);
        Message resp = this.obtainMessage(57, clirMode, 0, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.updateCLIR(clirMode, resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    @Override
    @UnsupportedAppUsage
    public void getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        this.logd("getCallForwardingOption reason=" + commandInterfaceCFReason);
        if (this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            this.logd("requesting call forwarding query.");
            Message resp = this.obtainMessage(13, onComplete);
            try {
                ImsUtInterface ut = this.mCT.getUtInterface();
                ut.queryCallForward(this.getConditionFromCFReason(commandInterfaceCFReason), null, resp);
            }
            catch (ImsException e) {
                this.sendErrorResponse(onComplete, e);
            }
        } else if (onComplete != null) {
            this.sendErrorResponse(onComplete);
        }
    }

    @Override
    public void setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int timerSeconds, Message onComplete) {
        this.setCallForwardingOption(commandInterfaceCFAction, commandInterfaceCFReason, dialingNumber, 1, timerSeconds, onComplete);
    }

    @UnsupportedAppUsage
    public void setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int serviceClass, int timerSeconds, Message onComplete) {
        this.logd("setCallForwardingOption action=" + commandInterfaceCFAction + ", reason=" + commandInterfaceCFReason + " serviceClass=" + serviceClass);
        if (this.isValidCommandInterfaceCFAction(commandInterfaceCFAction) && this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Cf cf = new Cf(dialingNumber, GsmMmiCode.isVoiceUnconditionalForwarding(commandInterfaceCFReason, serviceClass), onComplete);
            Message resp = this.obtainMessage(12, this.isCfEnable(commandInterfaceCFAction) ? 1 : 0, 0, cf);
            try {
                ImsUtInterface ut = this.mCT.getUtInterface();
                ut.updateCallForward(this.getActionFromCFAction(commandInterfaceCFAction), this.getConditionFromCFReason(commandInterfaceCFReason), dialingNumber, serviceClass, timerSeconds, resp);
            }
            catch (ImsException e) {
                this.sendErrorResponse(onComplete, e);
            }
        } else if (onComplete != null) {
            this.sendErrorResponse(onComplete);
        }
    }

    @Override
    @UnsupportedAppUsage
    public void getCallWaiting(Message onComplete) {
        this.logd("getCallWaiting");
        Message resp = this.obtainMessage(56, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.queryCallWaiting(resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    @Override
    @UnsupportedAppUsage
    public void setCallWaiting(boolean enable, Message onComplete) {
        int serviceClass = 1;
        CarrierConfigManager configManager = (CarrierConfigManager)this.getContext().getSystemService("carrier_config");
        PersistableBundle b = configManager.getConfigForSubId(this.getSubId());
        if (b != null) {
            serviceClass = b.getInt("call_waiting_service_class_int", 1);
        }
        this.setCallWaiting(enable, serviceClass, onComplete);
    }

    public void setCallWaiting(boolean enable, int serviceClass, Message onComplete) {
        this.logd("setCallWaiting enable=" + enable);
        Message resp = this.obtainMessage(55, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.updateCallWaiting(enable, serviceClass, resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    private int getCBTypeFromFacility(String facility) {
        if ("AO".equals(facility)) {
            return 2;
        }
        if ("OI".equals(facility)) {
            return 3;
        }
        if ("OX".equals(facility)) {
            return 4;
        }
        if ("AI".equals(facility)) {
            return 1;
        }
        if ("IR".equals(facility)) {
            return 5;
        }
        if ("AB".equals(facility)) {
            return 7;
        }
        if ("AG".equals(facility)) {
            return 8;
        }
        if ("AC".equals(facility)) {
            return 9;
        }
        return 0;
    }

    public void getCallBarring(String facility, Message onComplete) {
        this.getCallBarring(facility, onComplete, 0);
    }

    public void getCallBarring(String facility, Message onComplete, int serviceClass) {
        this.getCallBarring(facility, "", onComplete, serviceClass);
    }

    @Override
    public void getCallBarring(String facility, String password, Message onComplete, int serviceClass) {
        this.logd("getCallBarring facility=" + facility + ", serviceClass = " + serviceClass);
        Message resp = this.obtainMessage(54, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.queryCallBarring(this.getCBTypeFromFacility(facility), resp, serviceClass);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    public void setCallBarring(String facility, boolean lockState, String password, Message onComplete) {
        this.setCallBarring(facility, lockState, password, onComplete, 0);
    }

    @Override
    public void setCallBarring(String facility, boolean lockState, String password, Message onComplete, int serviceClass) {
        this.logd("setCallBarring facility=" + facility + ", lockState=" + lockState + ", serviceClass = " + serviceClass);
        Message resp = this.obtainMessage(53, onComplete);
        int action = lockState ? 1 : 0;
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.updateCallBarring(this.getCBTypeFromFacility(facility), action, resp, null, serviceClass);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    @Override
    public void sendUssdResponse(String ussdMessge) {
        this.logd("sendUssdResponse");
        ImsPhoneMmiCode mmi = ImsPhoneMmiCode.newFromUssdUserInput(ussdMessge, this);
        this.mPendingMMIs.add(mmi);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        mmi.sendUssd(ussdMessge);
    }

    public void sendUSSD(String ussdString, Message response) {
        this.mCT.sendUSSD(ussdString, response);
    }

    @Override
    public void cancelUSSD(Message msg) {
        this.mCT.cancelUSSD(msg);
    }

    @UnsupportedAppUsage
    private void sendErrorResponse(Message onComplete) {
        this.logd("sendErrorResponse");
        if (onComplete != null) {
            AsyncResult.forMessage(onComplete, null, new CommandException(CommandException.Error.GENERIC_FAILURE));
            onComplete.sendToTarget();
        }
    }

    @UnsupportedAppUsage
    @VisibleForTesting
    public void sendErrorResponse(Message onComplete, Throwable e) {
        this.logd("sendErrorResponse");
        if (onComplete != null) {
            AsyncResult.forMessage(onComplete, null, this.getCommandException(e));
            onComplete.sendToTarget();
        }
    }

    private CommandException getCommandException(int code, String errorString) {
        this.logd("getCommandException code= " + code + ", errorString= " + errorString);
        CommandException.Error error = CommandException.Error.GENERIC_FAILURE;
        switch (code) {
            case 801: {
                error = CommandException.Error.REQUEST_NOT_SUPPORTED;
                break;
            }
            case 821: {
                error = CommandException.Error.PASSWORD_INCORRECT;
                break;
            }
            case 802: {
                error = CommandException.Error.RADIO_NOT_AVAILABLE;
                break;
            }
            case 241: {
                error = CommandException.Error.FDN_CHECK_FAILURE;
                break;
            }
            case 822: {
                error = CommandException.Error.SS_MODIFIED_TO_DIAL;
                break;
            }
            case 823: {
                error = CommandException.Error.SS_MODIFIED_TO_USSD;
                break;
            }
            case 824: {
                error = CommandException.Error.SS_MODIFIED_TO_SS;
                break;
            }
            case 825: {
                error = CommandException.Error.SS_MODIFIED_TO_DIAL_VIDEO;
                break;
            }
        }
        return new CommandException(error, errorString);
    }

    private CommandException getCommandException(Throwable e) {
        CommandException ex = null;
        if (e instanceof ImsException) {
            ex = this.getCommandException(((ImsException)e).getCode(), e.getMessage());
        } else {
            this.logd("getCommandException generic failure");
            ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
        }
        return ex;
    }

    private void onNetworkInitiatedUssd(ImsPhoneMmiCode mmi) {
        this.logd("onNetworkInitiatedUssd");
        this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
    }

    void onIncomingUSSD(int ussdMode, String ussdMessage) {
        this.logd("onIncomingUSSD ussdMode=" + ussdMode);
        boolean isUssdRequest = ussdMode == 1;
        boolean isUssdError = ussdMode != 0 && ussdMode != 1;
        ImsPhoneMmiCode found = null;
        int s = this.mPendingMMIs.size();
        for (int i = 0; i < s; ++i) {
            if (!this.mPendingMMIs.get(i).isPendingUSSD()) continue;
            found = this.mPendingMMIs.get(i);
            break;
        }
        if (found != null) {
            if (isUssdError) {
                found.onUssdFinishedError();
            } else {
                found.onUssdFinished(ussdMessage, isUssdRequest);
            }
        } else if (!isUssdError && ussdMessage != null) {
            ImsPhoneMmiCode mmi = ImsPhoneMmiCode.newNetworkInitiatedUssd(ussdMessage, isUssdRequest, this);
            this.onNetworkInitiatedUssd(mmi);
        }
    }

    @UnsupportedAppUsage
    public void onMMIDone(ImsPhoneMmiCode mmi) {
        this.logd("onMMIDone: mmi=" + mmi);
        if (this.mPendingMMIs.remove(mmi) || mmi.isUssdRequest() || mmi.isSsInfo()) {
            ResultReceiver receiverCallback = mmi.getUssdCallbackReceiver();
            if (receiverCallback != null) {
                int returnCode = mmi.getState() == MmiCode.State.COMPLETE ? 100 : -1;
                this.sendUssdResponse(mmi.getDialString(), mmi.getMessage(), returnCode, receiverCallback);
            } else {
                this.logv("onMMIDone: notifyRegistrants");
                this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            }
        }
    }

    @Override
    public ArrayList<Connection> getHandoverConnection() {
        ArrayList<Connection> connList = new ArrayList<Connection>();
        connList.addAll(this.getForegroundCall().mConnections);
        connList.addAll(this.getBackgroundCall().mConnections);
        connList.addAll(this.getRingingCall().mConnections);
        if (connList.size() > 0) {
            return connList;
        }
        return null;
    }

    @Override
    public void notifySrvccState(Call.SrvccState state) {
        this.mCT.notifySrvccState(state);
    }

    void initiateSilentRedial() {
        String result = this.mLastDialString;
        AsyncResult ar = new AsyncResult(null, result, null);
        if (ar != null) {
            this.mSilentRedialRegistrants.notifyRegistrants(ar);
        }
    }

    @Override
    public void registerForSilentRedial(Handler h, int what, Object obj) {
        this.mSilentRedialRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForSilentRedial(Handler h) {
        this.mSilentRedialRegistrants.remove(h);
    }

    @Override
    public void registerForSuppServiceNotification(Handler h, int what, Object obj) {
        this.mSsnRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler h) {
        this.mSsnRegistrants.remove(h);
    }

    @Override
    public int getSubId() {
        return this.mDefaultPhone.getSubId();
    }

    @Override
    public int getPhoneId() {
        return this.mDefaultPhone.getPhoneId();
    }

    private CallForwardInfo getCallForwardInfo(ImsCallForwardInfo info) {
        CallForwardInfo cfInfo = new CallForwardInfo();
        cfInfo.status = info.getStatus();
        cfInfo.reason = this.getCFReasonFromCondition(info.getCondition());
        cfInfo.serviceClass = 1;
        cfInfo.toa = info.getToA();
        cfInfo.number = info.getNumber();
        cfInfo.timeSeconds = info.getTimeSeconds();
        return cfInfo;
    }

    public CallForwardInfo[] handleCfQueryResult(ImsCallForwardInfo[] infos) {
        CallForwardInfo[] cfInfos = null;
        if (infos != null && infos.length != 0) {
            cfInfos = new CallForwardInfo[infos.length];
        }
        IccRecords r = this.mDefaultPhone.getIccRecords();
        if (infos == null || infos.length == 0) {
            if (r != null) {
                this.setVoiceCallForwardingFlag(r, 1, false, null);
            }
        } else {
            int s = infos.length;
            for (int i = 0; i < s; ++i) {
                if (infos[i].getCondition() == 0 && r != null) {
                    this.setVoiceCallForwardingFlag(r, 1, infos[i].getStatus() == 1, infos[i].getNumber());
                }
                cfInfos[i] = this.getCallForwardInfo(infos[i]);
            }
        }
        return cfInfos;
    }

    private int[] handleCbQueryResult(ImsSsInfo[] infos) {
        int[] cbInfos = new int[]{0};
        if (infos[0].getStatus() == 1) {
            cbInfos[0] = 1;
        }
        return cbInfos;
    }

    private int[] handleCwQueryResult(ImsSsInfo[] infos) {
        int[] cwInfos = new int[2];
        cwInfos[0] = 0;
        if (infos[0].getStatus() == 1) {
            cwInfos[0] = 1;
            cwInfos[1] = 1;
        }
        return cwInfos;
    }

    private void sendResponse(Message onComplete, Object result, Throwable e) {
        if (onComplete != null) {
            CommandException ex = null;
            if (e != null) {
                ex = this.getCommandException(e);
            }
            AsyncResult.forMessage(onComplete, result, ex);
            onComplete.sendToTarget();
        }
    }

    private void updateDataServiceState() {
        if (this.mSS != null && this.mDefaultPhone.getServiceStateTracker() != null && this.mDefaultPhone.getServiceStateTracker().mSS != null) {
            ServiceState ss = this.mDefaultPhone.getServiceStateTracker().mSS;
            this.mSS.setDataRegState(ss.getDataRegState());
            List<NetworkRegistrationInfo> nriList = ss.getNetworkRegistrationInfoListForDomain(2);
            for (NetworkRegistrationInfo nri : nriList) {
                this.mSS.addNetworkRegistrationInfo(nri);
            }
            this.logd("updateDataServiceState: defSs = " + ss + " imsSs = " + this.mSS);
        }
    }

    @Override
    public void handleMessage(Message msg) {
        AsyncResult ar = (AsyncResult)msg.obj;
        this.logd("handleMessage what=" + msg.what);
        switch (msg.what) {
            case 12: {
                IccRecords r = this.mDefaultPhone.getIccRecords();
                Cf cf = (Cf)ar.userObj;
                if (cf.mIsCfu && ar.exception == null && r != null) {
                    this.setVoiceCallForwardingFlag(r, 1, msg.arg1 == 1, cf.mSetCfNumber);
                }
                this.sendResponse(cf.mOnComplete, null, ar.exception);
                break;
            }
            case 13: {
                CallForwardInfo[] cfInfos = null;
                if (ar.exception == null) {
                    cfInfos = this.handleCfQueryResult((ImsCallForwardInfo[])ar.result);
                }
                this.sendResponse((Message)ar.userObj, cfInfos, ar.exception);
                break;
            }
            case 54: 
            case 56: {
                int[] ssInfos = null;
                if (ar.exception == null) {
                    if (msg.what == 54) {
                        ssInfos = this.handleCbQueryResult((ImsSsInfo[])ar.result);
                    } else if (msg.what == 56) {
                        ssInfos = this.handleCwQueryResult((ImsSsInfo[])ar.result);
                    }
                }
                this.sendResponse((Message)ar.userObj, ssInfos, ar.exception);
                break;
            }
            case 58: {
                Bundle ssInfo = (Bundle)ar.result;
                int[] clirInfo = null;
                if (ssInfo != null) {
                    clirInfo = ssInfo.getIntArray("queryClir");
                }
                this.sendResponse((Message)ar.userObj, clirInfo, ar.exception);
                break;
            }
            case 57: {
                if (ar.exception == null) {
                    this.saveClirSetting(msg.arg1);
                }
            }
            case 53: 
            case 55: {
                this.sendResponse((Message)ar.userObj, null, ar.exception);
                break;
            }
            case 59: {
                this.logd("EVENT_DEFAULT_PHONE_DATA_STATE_CHANGED");
                this.updateDataServiceState();
                break;
            }
            case 60: {
                ar = (AsyncResult)msg.obj;
                ServiceState newServiceState = (ServiceState)ar.result;
                this.updateRoamingState(newServiceState);
                break;
            }
            case 61: {
                this.logd("Voice call ended. Handle pending updateRoamingState.");
                this.mCT.unregisterForVoiceCallEnded(this);
                ServiceStateTracker sst = this.getDefaultPhone().getServiceStateTracker();
                if (sst == null) break;
                this.updateRoamingState(sst.mSS);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    @VisibleForTesting
    public ImsEcbmStateListener getImsEcbmStateListener() {
        return this.mImsEcbmStateListener;
    }

    @Override
    public boolean isInEmergencyCall() {
        return this.mCT.isInEmergencyCall();
    }

    private void sendEmergencyCallbackModeChange() {
        Intent intent = new Intent("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        intent.putExtra("phoneinECMState", this.isInEcm());
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.getPhoneId());
        ActivityManager.broadcastStickyIntent(intent, -1);
        this.logd("sendEmergencyCallbackModeChange: isInEcm=" + this.isInEcm());
    }

    @Override
    public void exitEmergencyCallbackMode() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        this.logd("exitEmergencyCallbackMode()");
        try {
            ImsEcbm ecbm = this.mCT.getEcbmInterface();
            ecbm.exitEmergencyCallbackMode();
        }
        catch (ImsException e) {
            e.printStackTrace();
        }
    }

    @UnsupportedAppUsage
    private void handleEnterEmergencyCallbackMode() {
        this.logd("handleEnterEmergencyCallbackMode,mIsPhoneInEcmState= " + this.isInEcm());
        if (!this.isInEcm()) {
            this.setIsInEcm(true);
            this.sendEmergencyCallbackModeChange();
            ((GsmCdmaPhone)this.mDefaultPhone).notifyEmergencyCallRegistrants(true);
            long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
            this.postDelayed(this.mExitEcmRunnable, delayInMillis);
            this.mWakeLock.acquire();
        }
    }

    @Override
    @UnsupportedAppUsage
    protected void handleExitEmergencyCallbackMode() {
        this.logd("handleExitEmergencyCallbackMode: mIsPhoneInEcmState = " + this.isInEcm());
        if (this.isInEcm()) {
            this.setIsInEcm(false);
        }
        this.removeCallbacks(this.mExitEcmRunnable);
        if (this.mEcmExitRespRegistrant != null) {
            this.mEcmExitRespRegistrant.notifyResult(Boolean.TRUE);
        }
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        this.sendEmergencyCallbackModeChange();
        ((GsmCdmaPhone)this.mDefaultPhone).notifyEmergencyCallRegistrants(false);
    }

    void handleTimerInEmergencyCallbackMode(int action) {
        switch (action) {
            case 1: {
                this.removeCallbacks(this.mExitEcmRunnable);
                ((GsmCdmaPhone)this.mDefaultPhone).notifyEcbmTimerReset(Boolean.TRUE);
                break;
            }
            case 0: {
                long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
                this.postDelayed(this.mExitEcmRunnable, delayInMillis);
                ((GsmCdmaPhone)this.mDefaultPhone).notifyEcbmTimerReset(Boolean.FALSE);
                break;
            }
            default: {
                this.loge("handleTimerInEmergencyCallbackMode, unsupported action " + action);
            }
        }
    }

    @Override
    @UnsupportedAppUsage
    public void setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        this.mEcmExitRespRegistrant = new Registrant(h, what, obj);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler h) {
        this.mEcmExitRespRegistrant.clear();
    }

    public void onFeatureCapabilityChanged() {
        this.mDefaultPhone.getServiceStateTracker().onImsCapabilityChanged();
    }

    @Override
    public boolean isImsCapabilityAvailable(int capability, int regTech) {
        return this.mCT.isImsCapabilityAvailable(capability, regTech);
    }

    @Override
    @UnsupportedAppUsage
    public boolean isVolteEnabled() {
        return this.mCT.isVolteEnabled();
    }

    @Override
    public boolean isWifiCallingEnabled() {
        return this.mCT.isVowifiEnabled();
    }

    @Override
    public boolean isVideoEnabled() {
        return this.mCT.isVideoCallEnabled();
    }

    @Override
    public int getImsRegistrationTech() {
        return this.mCT.getImsRegistrationTech();
    }

    @Override
    public Phone getDefaultPhone() {
        return this.mDefaultPhone;
    }

    @Override
    public boolean isImsRegistered() {
        return this.mImsRegistered;
    }

    @UnsupportedAppUsage
    public void setImsRegistered(boolean value) {
        this.mImsRegistered = value;
    }

    @Override
    public void callEndCleanupHandOverCallIfAny() {
        this.mCT.callEndCleanupHandOverCallIfAny();
    }

    public void processDisconnectReason(ImsReasonInfo imsReasonInfo) {
        if (imsReasonInfo.mCode == 1000 && imsReasonInfo.mExtraMessage != null && ImsManager.getInstance(this.mContext, this.mPhoneId).isWfcEnabledByUser()) {
            this.processWfcDisconnectForNotification(imsReasonInfo);
        }
    }

    private void processWfcDisconnectForNotification(ImsReasonInfo imsReasonInfo) {
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (configManager == null) {
            this.loge("processDisconnectReason: CarrierConfigManager is not ready");
            return;
        }
        PersistableBundle pb = configManager.getConfigForSubId(this.getSubId());
        if (pb == null) {
            this.loge("processDisconnectReason: no config for subId " + this.getSubId());
            return;
        }
        String[] wfcOperatorErrorCodes = pb.getStringArray("wfc_operator_error_codes_string_array");
        if (wfcOperatorErrorCodes == null) {
            return;
        }
        String[] wfcOperatorErrorAlertMessages = this.mContext.getResources().getStringArray(17236114);
        String[] wfcOperatorErrorNotificationMessages = this.mContext.getResources().getStringArray(17236115);
        for (int i = 0; i < wfcOperatorErrorCodes.length; ++i) {
            char nextChar;
            int codeStringLength;
            char lastChar;
            String[] codes = wfcOperatorErrorCodes[i].split("\\|");
            if (codes.length != 2) {
                this.loge("Invalid carrier config: " + wfcOperatorErrorCodes[i]);
                continue;
            }
            if (!imsReasonInfo.mExtraMessage.startsWith(codes[0]) || Character.isLetterOrDigit(lastChar = codes[0].charAt((codeStringLength = codes[0].length()) - 1)) && imsReasonInfo.mExtraMessage.length() > codeStringLength && Character.isLetterOrDigit(nextChar = imsReasonInfo.mExtraMessage.charAt(codeStringLength))) continue;
            CharSequence title = this.mContext.getText(17041223);
            int idx = Integer.parseInt(codes[1]);
            if (idx < 0 || idx >= wfcOperatorErrorAlertMessages.length || idx >= wfcOperatorErrorNotificationMessages.length) {
                this.loge("Invalid index: " + wfcOperatorErrorCodes[i]);
                continue;
            }
            String messageAlert = imsReasonInfo.mExtraMessage;
            String messageNotification = imsReasonInfo.mExtraMessage;
            if (!wfcOperatorErrorAlertMessages[idx].isEmpty()) {
                messageAlert = String.format(wfcOperatorErrorAlertMessages[idx], imsReasonInfo.mExtraMessage);
            }
            if (!wfcOperatorErrorNotificationMessages[idx].isEmpty()) {
                messageNotification = String.format(wfcOperatorErrorNotificationMessages[idx], imsReasonInfo.mExtraMessage);
            }
            Intent intent = new Intent("com.android.ims.REGISTRATION_ERROR");
            intent.putExtra("alertTitle", title);
            intent.putExtra("alertMessage", messageAlert);
            intent.putExtra("notificationMessage", messageNotification);
            this.mContext.sendOrderedBroadcast(intent, null, this.mResultReceiver, null, -1, null, null);
            break;
        }
    }

    @Override
    @UnsupportedAppUsage
    public boolean isUtEnabled() {
        return this.mCT.isUtEnabled();
    }

    @Override
    public void sendEmergencyCallStateChange(boolean callActive) {
        this.mDefaultPhone.sendEmergencyCallStateChange(callActive);
    }

    @Override
    public void setBroadcastEmergencyCallStateChanges(boolean broadcast) {
        this.mDefaultPhone.setBroadcastEmergencyCallStateChanges(broadcast);
    }

    @VisibleForTesting
    public PowerManager.WakeLock getWakeLock() {
        return this.mWakeLock;
    }

    @Override
    public NetworkStats getVtDataUsage(boolean perUidStats) {
        return this.mCT.getVtDataUsage(perUidStats);
    }

    private void updateRoamingState(ServiceState ss) {
        boolean isInService;
        if (ss == null) {
            this.loge("updateRoamingState: null ServiceState!");
            return;
        }
        boolean newRoamingState = ss.getRoaming();
        if (this.mRoaming == newRoamingState) {
            return;
        }
        boolean bl = isInService = ss.getVoiceRegState() == 0 || ss.getDataRegState() == 0;
        if (!isInService) {
            this.logi("updateRoamingState: we are OUT_OF_SERVICE, ignoring roaming change.");
            return;
        }
        if (this.isCsNotInServiceAndPsWwanReportingWlan(ss)) {
            this.logi("updateRoamingState: IWLAN masking roaming, ignore roaming change.");
            return;
        }
        if (this.mCT.getState() == PhoneConstants.State.IDLE) {
            this.logd("updateRoamingState now: " + newRoamingState);
            this.mRoaming = newRoamingState;
            ImsManager imsManager = ImsManager.getInstance(this.mContext, this.mPhoneId);
            imsManager.setWfcMode(imsManager.getWfcMode(newRoamingState), newRoamingState);
        } else {
            this.logd("updateRoamingState postponed: " + newRoamingState);
            this.mCT.registerForVoiceCallEnded(this, 61, null);
        }
    }

    private boolean isCsNotInServiceAndPsWwanReportingWlan(ServiceState ss) {
        TransportManager tm = this.mDefaultPhone.getTransportManager();
        if (tm == null || !tm.isInLegacyMode()) {
            return false;
        }
        NetworkRegistrationInfo csInfo = ss.getNetworkRegistrationInfo(1, 1);
        NetworkRegistrationInfo psInfo = ss.getNetworkRegistrationInfo(2, 1);
        return psInfo != null && csInfo != null && !csInfo.isInService() && psInfo.getAccessNetworkTechnology() == 18;
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ImsPhone extends:");
        super.dump(fd, pw, args);
        pw.flush();
        pw.println("ImsPhone:");
        pw.println("  mDefaultPhone = " + this.mDefaultPhone);
        pw.println("  mPendingMMIs = " + this.mPendingMMIs);
        pw.println("  mPostDialHandler = " + this.mPostDialHandler);
        pw.println("  mSS = " + this.mSS);
        pw.println("  mWakeLock = " + this.mWakeLock);
        pw.println("  mIsPhoneInEcmState = " + this.isInEcm());
        pw.println("  mEcmExitRespRegistrant = " + this.mEcmExitRespRegistrant);
        pw.println("  mSilentRedialRegistrants = " + this.mSilentRedialRegistrants);
        pw.println("  mImsRegistered = " + this.mImsRegistered);
        pw.println("  mRoaming = " + this.mRoaming);
        pw.println("  mSsnRegistrants = " + this.mSsnRegistrants);
        pw.flush();
    }

    private void logi(String s) {
        Rlog.i(LOG_TAG, "[" + this.mPhoneId + "] " + s);
    }

    private void logv(String s) {
        Rlog.v(LOG_TAG, "[" + this.mPhoneId + "] " + s);
    }

    private void logd(String s) {
        Rlog.d(LOG_TAG, "[" + this.mPhoneId + "] " + s);
    }

    private void loge(String s) {
        Rlog.e(LOG_TAG, "[" + this.mPhoneId + "] " + s);
    }

    private static class Cf {
        final String mSetCfNumber;
        final Message mOnComplete;
        final boolean mIsCfu;

        @UnsupportedAppUsage
        Cf(String cfNumber, boolean isCfu, Message onComplete) {
            this.mSetCfNumber = cfNumber;
            this.mIsCfu = isCfu;
            this.mOnComplete = onComplete;
        }
    }

    public static class ImsDialArgs
    extends PhoneInternalInterface.DialArgs {
        public final Connection.RttTextStream rttTextStream;
        public final int clirMode;

        private ImsDialArgs(Builder b) {
            super(b);
            this.rttTextStream = b.mRttTextStream;
            this.clirMode = b.mClirMode;
        }

        public static class Builder
        extends PhoneInternalInterface.DialArgs.Builder<Builder> {
            private Connection.RttTextStream mRttTextStream;
            private int mClirMode = 0;

            public static Builder from(PhoneInternalInterface.DialArgs dialArgs) {
                return (Builder)((Builder)((Builder)new Builder().setUusInfo(dialArgs.uusInfo)).setVideoState(dialArgs.videoState)).setIntentExtras(dialArgs.intentExtras);
            }

            public static Builder from(ImsDialArgs dialArgs) {
                return ((Builder)((Builder)((Builder)new Builder().setUusInfo(dialArgs.uusInfo)).setVideoState(dialArgs.videoState)).setIntentExtras(dialArgs.intentExtras)).setRttTextStream(dialArgs.rttTextStream).setClirMode(dialArgs.clirMode);
            }

            public Builder setRttTextStream(Connection.RttTextStream s) {
                this.mRttTextStream = s;
                return this;
            }

            public Builder setClirMode(int clirMode) {
                this.mClirMode = clirMode;
                return this;
            }

            @Override
            public ImsDialArgs build() {
                return new ImsDialArgs(this);
            }
        }
    }
}

