/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.NetworkStats;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telecom.ConferenceParticipant;
import android.telecom.Connection;
import android.telecom.TelecomManager;
import android.telecom.VideoProfile;
import android.telephony.CallQuality;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.emergency.EmergencyNumber;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsMmTelManager;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsStreamMediaProfile;
import android.telephony.ims.ImsSuppServiceNotification;
import android.telephony.ims.ProvisioningManager;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.feature.MmTelFeature;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.ims.ImsCall;
import com.android.ims.ImsConfigListener;
import com.android.ims.ImsEcbm;
import com.android.ims.ImsException;
import com.android.ims.ImsManager;
import com.android.ims.ImsMultiEndpoint;
import com.android.ims.ImsUtInterface;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsVideoCallProvider;
import com.android.ims.internal.ImsVideoCallProviderWrapper;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.SomeArgs;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.LocaleTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import com.android.internal.telephony.imsphone.ImsPhoneMmiCode;
import com.android.internal.telephony.imsphone.ImsPullCall;
import com.android.internal.telephony.metrics.CallQualityMetrics;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class ImsPhoneCallTracker
extends CallTracker
implements ImsPullCall {
    static final String LOG_TAG = "ImsPhoneCallTracker";
    static final String VERBOSE_STATE_TAG = "IPCTState";
    private static final boolean DBG = true;
    private static final boolean FORCE_VERBOSE_STATE_LOGGING = false;
    private static final boolean VERBOSE_STATE_LOGGING = Rlog.isLoggable("IPCTState", 2);
    private MmTelFeature.MmTelCapabilities mMmTelCapabilities = new MmTelFeature.MmTelCapabilities();
    private TelephonyMetrics mMetrics;
    private final Map<String, CallQualityMetrics> mCallQualityMetrics = new ConcurrentHashMap<String, CallQualityMetrics>();
    private final ConcurrentLinkedQueue<CallQualityMetrics> mCallQualityMetricsHistory = new ConcurrentLinkedQueue();
    private boolean mCarrierConfigLoaded = false;
    private final MmTelFeatureListener mMmTelFeatureListener = new MmTelFeatureListener();
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                int subId = intent.getIntExtra("subscription", -1);
                if (subId == ImsPhoneCallTracker.this.mPhone.getSubId()) {
                    ImsPhoneCallTracker.this.cacheCarrierConfiguration(subId);
                    ImsPhoneCallTracker.this.log("onReceive : Updating mAllowEmergencyVideoCalls = " + ImsPhoneCallTracker.this.mAllowEmergencyVideoCalls);
                }
            } else if ("android.telecom.action.CHANGE_DEFAULT_DIALER".equals(intent.getAction())) {
                ImsPhoneCallTracker.this.mDefaultDialerUid.set(ImsPhoneCallTracker.this.getPackageUid(context, intent.getStringExtra("android.telecom.extra.CHANGE_DEFAULT_DIALER_PACKAGE_NAME")));
            }
        }
    };
    private boolean mIsMonitoringConnectivity = false;
    private ConnectivityManager.NetworkCallback mNetworkCallback = new ConnectivityManager.NetworkCallback(){

        @Override
        public void onAvailable(Network network) {
            Rlog.i(ImsPhoneCallTracker.LOG_TAG, "Network available: " + network);
            ImsPhoneCallTracker.this.scheduleHandoverCheck();
        }
    };
    static final int MAX_CONNECTIONS = 7;
    static final int MAX_CONNECTIONS_PER_CALL = 5;
    private static final int MAX_CALL_QUALITY_HISTORY = 10;
    private static final int EVENT_HANGUP_PENDINGMO = 18;
    private static final int EVENT_DIAL_PENDINGMO = 20;
    private static final int EVENT_EXIT_ECBM_BEFORE_PENDINGMO = 21;
    private static final int EVENT_VT_DATA_USAGE_UPDATE = 22;
    private static final int EVENT_DATA_ENABLED_CHANGED = 23;
    private static final int EVENT_CHECK_FOR_WIFI_HANDOVER = 25;
    private static final int EVENT_ON_FEATURE_CAPABILITY_CHANGED = 26;
    private static final int EVENT_SUPP_SERVICE_INDICATION = 27;
    private static final int EVENT_REDIAL_WIFI_E911_CALL = 28;
    private static final int EVENT_REDIAL_WIFI_E911_TIMEOUT = 29;
    private static final int EVENT_ANSWER_WAITING_CALL = 30;
    private static final int EVENT_RESUME_NOW_FOREGROUND_CALL = 31;
    private static final int TIMEOUT_HANGUP_PENDINGMO = 500;
    private static final int HANDOVER_TO_WIFI_TIMEOUT_MS = 60000;
    private static final int TIMEOUT_REDIAL_WIFI_E911_MS = 10000;
    private static final int TIMEOUT_PARTICIPANT_CONNECT_TIME_CACHE_MS = 60000;
    @UnsupportedAppUsage
    private ArrayList<ImsPhoneConnection> mConnections = new ArrayList();
    private RegistrantList mVoiceCallEndedRegistrants = new RegistrantList();
    private RegistrantList mVoiceCallStartedRegistrants = new RegistrantList();
    @UnsupportedAppUsage
    public ImsPhoneCall mRingingCall = new ImsPhoneCall(this, "RG");
    @UnsupportedAppUsage
    public ImsPhoneCall mForegroundCall = new ImsPhoneCall(this, "FG");
    @UnsupportedAppUsage
    public ImsPhoneCall mBackgroundCall = new ImsPhoneCall(this, "BG");
    @UnsupportedAppUsage
    public ImsPhoneCall mHandoverCall = new ImsPhoneCall(this, "HO");
    private final HashMap<Integer, Long> mVtDataUsageMap = new HashMap();
    private final Map<String, CacheEntry> mPhoneNumAndConnTime = new ConcurrentHashMap<String, CacheEntry>();
    private final Queue<CacheEntry> mUnknownPeerConnTime = new LinkedBlockingQueue<CacheEntry>();
    private volatile NetworkStats mVtDataUsageSnapshot = null;
    private volatile NetworkStats mVtDataUsageUidSnapshot = null;
    private final AtomicInteger mDefaultDialerUid = new AtomicInteger(-1);
    @UnsupportedAppUsage
    private ImsPhoneConnection mPendingMO;
    private int mClirMode = 0;
    @UnsupportedAppUsage
    private Object mSyncHold = new Object();
    private ImsCall mUssdSession = null;
    @UnsupportedAppUsage
    private Message mPendingUssd = null;
    @UnsupportedAppUsage
    ImsPhone mPhone;
    private boolean mDesiredMute = false;
    @UnsupportedAppUsage
    private boolean mOnHoldToneStarted = false;
    @UnsupportedAppUsage
    private int mOnHoldToneId = -1;
    private PhoneConstants.State mState = PhoneConstants.State.IDLE;
    private ImsManager mImsManager;
    private ImsUtInterface mUtInterface;
    private Call.SrvccState mSrvccState = Call.SrvccState.NONE;
    private boolean mIsInEmergencyCall = false;
    private boolean mIsDataEnabled = false;
    private int pendingCallClirMode;
    private int mPendingCallVideoState;
    private Bundle mPendingIntentExtras;
    private boolean pendingCallInEcm = false;
    @UnsupportedAppUsage
    private boolean mSwitchingFgAndBgCalls = false;
    private ImsCall mCallExpectedToResume = null;
    @UnsupportedAppUsage
    private boolean mAllowEmergencyVideoCalls = false;
    private boolean mIgnoreDataEnabledChangedForVideoCalls = false;
    private boolean mIsViLteDataMetered = false;
    private boolean mAlwaysPlayRemoteHoldTone = false;
    private boolean mAutoRetryFailedWifiEmergencyCall = false;
    private HoldSwapState mHoldSwitchingState = HoldSwapState.INACTIVE;
    private String mLastDialString = null;
    private PhoneInternalInterface.DialArgs mLastDialArgs = null;
    private List<PhoneStateListener> mPhoneStateListeners = new ArrayList<PhoneStateListener>();
    private boolean mTreatDowngradedVideoCallsAsVideoCalls = false;
    private boolean mDropVideoCallWhenAnsweringAudioCall = false;
    private boolean mAllowAddCallDuringVideoCall = true;
    private boolean mNotifyVtHandoverToWifiFail = false;
    private boolean mSupportDowngradeVtToAudio = false;
    private boolean mNotifyHandoverVideoFromWifiToLTE = false;
    private boolean mNotifyHandoverVideoFromLTEToWifi = false;
    private boolean mHasAttemptedStartOfCallHandover = false;
    private boolean mSupportPauseVideo = false;
    private Map<Pair<Integer, String>, Integer> mImsReasonCodeMap = new ArrayMap<Pair<Integer, String>, Integer>();
    private boolean mShouldUpdateImsConfigOnDisconnect = false;
    private SharedPreferenceProxy mSharedPreferenceProxy = context -> PreferenceManager.getDefaultSharedPreferences(context);
    private PhoneNumberUtilsProxy mPhoneNumberUtilsProxy = string2 -> PhoneNumberUtils.isEmergencyNumber(string2);
    private final ImsManager.Connector mImsManagerConnector;
    private ImsCall.Listener mImsCallListener = new ImsCall.Listener(){

        @Override
        public void onCallProgressing(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallProgressing");
            ImsPhoneCallTracker.this.mPendingMO = null;
            ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.ALERTING, 0);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallProgressing(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession());
        }

        @Override
        public void onCallStarted(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallStarted");
            if (ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.HOLDING_TO_ANSWER_INCOMING && ImsPhoneCallTracker.this.mCallExpectedToResume != null && ImsPhoneCallTracker.this.mCallExpectedToResume == imsCall) {
                ImsPhoneCallTracker.this.log("onCallStarted: starting a call as a result of a switch.");
                ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                ImsPhoneCallTracker.this.logHoldSwapState("onCallStarted");
            }
            ImsPhoneCallTracker.this.mPendingMO = null;
            ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.ACTIVE, 0);
            if (ImsPhoneCallTracker.this.mNotifyVtHandoverToWifiFail && imsCall.isVideoCall() && !imsCall.isWifiCall()) {
                if (ImsPhoneCallTracker.this.isWifiConnected()) {
                    ImsPhoneCallTracker.this.sendMessageDelayed(ImsPhoneCallTracker.this.obtainMessage(25, imsCall), 60000L);
                    ImsPhoneCallTracker.this.mHasAttemptedStartOfCallHandover = false;
                } else {
                    ImsPhoneCallTracker.this.registerForConnectivityChanges();
                    ImsPhoneCallTracker.this.mHasAttemptedStartOfCallHandover = true;
                }
            }
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallStarted(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession());
        }

        @Override
        public void onCallUpdated(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallUpdated");
            if (imsCall == null) {
                return;
            }
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                ImsPhoneCallTracker.this.log("onCallUpdated: profile is " + imsCall.getCallProfile());
                ImsPhoneCallTracker.this.processCallStateChange(imsCall, conn.getCall().mState, 0, true);
                ImsPhoneCallTracker.this.mMetrics.writeImsCallState(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession(), conn.getCall().mState);
            }
        }

        @Override
        public void onCallStartFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallStartFailed reasonCode=" + reasonInfo.getCode());
            if (ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.HOLDING_TO_ANSWER_INCOMING && ImsPhoneCallTracker.this.mCallExpectedToResume != null && ImsPhoneCallTracker.this.mCallExpectedToResume == imsCall) {
                ImsPhoneCallTracker.this.log("onCallStarted: starting a call as a result of a switch.");
                ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                ImsPhoneCallTracker.this.logHoldSwapState("onCallStartFailed");
            }
            if (ImsPhoneCallTracker.this.mPendingMO != null) {
                if (reasonInfo.getCode() == 146 && ImsPhoneCallTracker.this.mBackgroundCall.getState() == Call.State.IDLE && ImsPhoneCallTracker.this.mRingingCall.getState() == Call.State.IDLE) {
                    ImsPhoneCallTracker.this.mForegroundCall.detach(ImsPhoneCallTracker.this.mPendingMO);
                    ImsPhoneCallTracker.this.removeConnection(ImsPhoneCallTracker.this.mPendingMO);
                    ImsPhoneCallTracker.this.mPendingMO.finalize();
                    ImsPhoneCallTracker.this.mPendingMO = null;
                    ImsPhoneCallTracker.this.mPhone.initiateSilentRedial();
                    return;
                }
                ImsPhoneCallTracker.this.sendCallStartFailedDisconnect(imsCall, reasonInfo);
                ImsPhoneCallTracker.this.mMetrics.writeOnImsCallStartFailed(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession(), reasonInfo);
            }
        }

        @Override
        public void onCallTerminated(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            Connection.VideoProvider videoProvider;
            ImsPhoneCallTracker.this.log("onCallTerminated reasonCode=" + reasonInfo.getCode());
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            Call.State callState = conn != null ? conn.getState() : Call.State.ACTIVE;
            int cause = ImsPhoneCallTracker.this.getDisconnectCauseFromReasonInfo(reasonInfo, callState);
            ImsPhoneCallTracker.this.log("cause = " + cause + " conn = " + conn);
            if (conn != null && (videoProvider = conn.getVideoProvider()) instanceof ImsVideoCallProviderWrapper) {
                ImsVideoCallProviderWrapper wrapper = (ImsVideoCallProviderWrapper)videoProvider;
                wrapper.unregisterForDataUsageUpdate(ImsPhoneCallTracker.this);
                wrapper.removeImsVideoProviderCallback(conn);
            }
            if (ImsPhoneCallTracker.this.mOnHoldToneId == System.identityHashCode(conn)) {
                if (conn != null && ImsPhoneCallTracker.this.mOnHoldToneStarted) {
                    ImsPhoneCallTracker.this.mPhone.stopOnHoldTone(conn);
                }
                ImsPhoneCallTracker.this.mOnHoldToneStarted = false;
                ImsPhoneCallTracker.this.mOnHoldToneId = -1;
            }
            if (conn != null) {
                if (conn.isPulledCall() && (reasonInfo.getCode() == 1015 || reasonInfo.getCode() == 336 || reasonInfo.getCode() == 332) && ImsPhoneCallTracker.this.mPhone != null && ImsPhoneCallTracker.this.mPhone.getExternalCallTracker() != null) {
                    ImsPhoneCallTracker.this.log("Call pull failed.");
                    conn.onCallPullFailed(ImsPhoneCallTracker.this.mPhone.getExternalCallTracker().getConnectionById(conn.getPulledDialogId()));
                    cause = 0;
                } else if (conn.isIncoming() && conn.getConnectTime() == 0L && cause != 52) {
                    cause = cause == 2 ? 1 : 16;
                    ImsPhoneCallTracker.this.log("Incoming connection of 0 connect time detected - translated cause = " + cause);
                }
            }
            if (cause == 2 && conn != null && conn.getImsCall().isMerged()) {
                cause = 45;
            }
            String callId = imsCall.getSession().getCallId();
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallTerminated(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession(), reasonInfo, (CallQualityMetrics)ImsPhoneCallTracker.this.mCallQualityMetrics.get(callId), conn.getEmergencyNumberInfo(), ImsPhoneCallTracker.this.getNetworkCountryIso());
            CallQualityMetrics lastCallMetrics = (CallQualityMetrics)ImsPhoneCallTracker.this.mCallQualityMetrics.remove(callId);
            if (lastCallMetrics != null) {
                ImsPhoneCallTracker.this.mCallQualityMetricsHistory.add(lastCallMetrics);
            }
            ImsPhoneCallTracker.this.pruneCallQualityMetricsHistory();
            ImsPhoneCallTracker.this.mPhone.notifyImsReason(reasonInfo);
            if (reasonInfo.getCode() == 1514 && ImsPhoneCallTracker.this.mAutoRetryFailedWifiEmergencyCall) {
                Pair<ImsCall, ImsReasonInfo> callInfo = new Pair<ImsCall, ImsReasonInfo>(imsCall, reasonInfo);
                ImsPhoneCallTracker.this.mPhone.getDefaultPhone().getServiceStateTracker().registerForNetworkAttached(ImsPhoneCallTracker.this, 28, callInfo);
                ImsPhoneCallTracker.this.sendMessageDelayed(ImsPhoneCallTracker.this.obtainMessage(29, callInfo), 10000L);
                ConnectivityManager mgr = (ConnectivityManager)ImsPhoneCallTracker.this.mPhone.getContext().getSystemService("connectivity");
                mgr.setAirplaneMode(false);
                return;
            }
            ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.DISCONNECTED, cause);
            if (ImsPhoneCallTracker.this.mForegroundCall.getState() != Call.State.ACTIVE && ImsPhoneCallTracker.this.mRingingCall.getState().isRinging()) {
                ImsPhoneCallTracker.this.mPendingMO = null;
            }
            if (ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.SWAPPING_ACTIVE_AND_HELD) {
                ImsPhoneCallTracker.this.log("onCallTerminated: Call terminated in the midst of Switching Fg and Bg calls.");
                if (imsCall == ImsPhoneCallTracker.this.mCallExpectedToResume) {
                    ImsPhoneCallTracker.this.log("onCallTerminated: switching " + ImsPhoneCallTracker.this.mForegroundCall + " with " + ImsPhoneCallTracker.this.mBackgroundCall);
                    ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                }
                ImsPhoneCallTracker.this.log("onCallTerminated: foreground call in state " + (Object)((Object)ImsPhoneCallTracker.this.mForegroundCall.getState()) + " and ringing call in state " + (ImsPhoneCallTracker.this.mRingingCall == null ? "null" : ImsPhoneCallTracker.this.mRingingCall.getState().toString()));
                ImsPhoneCallTracker.this.sendEmptyMessage(31);
                ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                ImsPhoneCallTracker.this.logHoldSwapState("onCallTerminated swap active and hold case");
            } else if (ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.PENDING_SINGLE_CALL_UNHOLD || ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.PENDING_SINGLE_CALL_HOLD) {
                ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                ImsPhoneCallTracker.this.logHoldSwapState("onCallTerminated single call case");
            } else if (ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.HOLDING_TO_ANSWER_INCOMING) {
                if (imsCall == ImsPhoneCallTracker.this.mCallExpectedToResume) {
                    ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                    ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                    ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                    ImsPhoneCallTracker.this.logHoldSwapState("onCallTerminated hold to answer case");
                    ImsPhoneCallTracker.this.sendEmptyMessage(31);
                }
            } else if (ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.HOLDING_TO_DIAL_OUTGOING) {
                if (ImsPhoneCallTracker.this.mPendingMO == null || ImsPhoneCallTracker.this.mPendingMO.getDisconnectCause() != 0) {
                    ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                    ImsPhoneCallTracker.this.logHoldSwapState("onCallTerminated hold to dial but no pendingMo");
                } else if (imsCall != ImsPhoneCallTracker.this.mPendingMO.getImsCall()) {
                    ImsPhoneCallTracker.this.sendEmptyMessage(20);
                    ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                    ImsPhoneCallTracker.this.logHoldSwapState("onCallTerminated hold to dial, dial pendingMo");
                }
            }
            if (ImsPhoneCallTracker.this.mShouldUpdateImsConfigOnDisconnect) {
                if (ImsPhoneCallTracker.this.mImsManager != null) {
                    ImsPhoneCallTracker.this.mImsManager.updateImsServiceConfig(true);
                }
                ImsPhoneCallTracker.this.mShouldUpdateImsConfigOnDisconnect = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallHeld(ImsCall imsCall) {
            if (ImsPhoneCallTracker.this.mForegroundCall.getImsCall() == imsCall) {
                ImsPhoneCallTracker.this.log("onCallHeld (fg) " + imsCall);
            } else if (ImsPhoneCallTracker.this.mBackgroundCall.getImsCall() == imsCall) {
                ImsPhoneCallTracker.this.log("onCallHeld (bg) " + imsCall);
            }
            Object object = ImsPhoneCallTracker.this.mSyncHold;
            synchronized (object) {
                Call.State oldState = ImsPhoneCallTracker.this.mBackgroundCall.getState();
                ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.HOLDING, 0);
                if (oldState == Call.State.ACTIVE) {
                    if (ImsPhoneCallTracker.this.mForegroundCall.getState() == Call.State.HOLDING && ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.SWAPPING_ACTIVE_AND_HELD) {
                        ImsPhoneCallTracker.this.sendEmptyMessage(31);
                    } else if (ImsPhoneCallTracker.this.mRingingCall.getState() == Call.State.WAITING && ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.HOLDING_TO_ANSWER_INCOMING) {
                        ImsPhoneCallTracker.this.sendEmptyMessage(30);
                    } else if (ImsPhoneCallTracker.this.mPendingMO != null && ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.HOLDING_TO_DIAL_OUTGOING) {
                        ImsPhoneCallTracker.this.dialPendingMO();
                        ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                        ImsPhoneCallTracker.this.logHoldSwapState("onCallHeld hold to dial");
                    } else {
                        ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                        ImsPhoneCallTracker.this.logHoldSwapState("onCallHeld normal case");
                    }
                } else if (oldState == Call.State.IDLE && (ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.SWAPPING_ACTIVE_AND_HELD || ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.HOLDING_TO_ANSWER_INCOMING) && ImsPhoneCallTracker.this.mForegroundCall.getState() == Call.State.HOLDING) {
                    ImsPhoneCallTracker.this.sendEmptyMessage(31);
                    ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                    ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                    ImsPhoneCallTracker.this.logHoldSwapState("onCallHeld premature termination of other call");
                }
            }
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallHeld(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallHoldFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallHoldFailed reasonCode=" + reasonInfo.getCode());
            Object object = ImsPhoneCallTracker.this.mSyncHold;
            synchronized (object) {
                Call.State bgState = ImsPhoneCallTracker.this.mBackgroundCall.getState();
                if (reasonInfo.getCode() == 148) {
                    if (ImsPhoneCallTracker.this.mPendingMO != null) {
                        ImsPhoneCallTracker.this.dialPendingMO();
                    } else if (ImsPhoneCallTracker.this.mRingingCall.getState() == Call.State.WAITING && ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.HOLDING_TO_ANSWER_INCOMING) {
                        ImsPhoneCallTracker.this.sendEmptyMessage(30);
                    }
                    ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                } else if (ImsPhoneCallTracker.this.mPendingMO != null && ImsPhoneCallTracker.this.mPendingMO.isEmergency()) {
                    ImsPhoneCallTracker.this.mBackgroundCall.getImsCall().terminate(0);
                    if (imsCall != ImsPhoneCallTracker.this.mCallExpectedToResume) {
                        ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                    }
                } else if (ImsPhoneCallTracker.this.mRingingCall.getState() == Call.State.WAITING && ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.HOLDING_TO_ANSWER_INCOMING) {
                    ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                    ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                    ImsPhoneCallTracker.this.logHoldSwapState("onCallHoldFailed unable to answer waiting call");
                } else if (bgState == Call.State.ACTIVE) {
                    ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                    if (ImsPhoneCallTracker.this.mPendingMO != null) {
                        ImsPhoneCallTracker.this.mPendingMO.setDisconnectCause(36);
                        ImsPhoneCallTracker.this.sendEmptyMessageDelayed(18, 500L);
                    }
                    if (imsCall != ImsPhoneCallTracker.this.mCallExpectedToResume) {
                        ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                    }
                    ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                }
                ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
                if (conn != null) {
                    conn.onConnectionEvent("android.telecom.event.CALL_HOLD_FAILED", null);
                }
                ImsPhoneCallTracker.this.mPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.HOLD);
            }
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallHoldFailed(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession(), reasonInfo);
        }

        @Override
        public void onCallResumed(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallResumed");
            if (ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.SWAPPING_ACTIVE_AND_HELD || ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.PENDING_RESUME_FOREGROUND_AFTER_FAILURE || ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.PENDING_SINGLE_CALL_UNHOLD) {
                if (imsCall != ImsPhoneCallTracker.this.mCallExpectedToResume) {
                    ImsPhoneCallTracker.this.log("onCallResumed : switching " + ImsPhoneCallTracker.this.mForegroundCall + " with " + ImsPhoneCallTracker.this.mBackgroundCall);
                    ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                } else {
                    ImsPhoneCallTracker.this.log("onCallResumed : expected call resumed.");
                }
                ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                ImsPhoneCallTracker.this.logHoldSwapState("onCallResumed");
            }
            ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.ACTIVE, 0);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallResumed(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession());
        }

        @Override
        public void onCallResumeFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            if (ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.SWAPPING_ACTIVE_AND_HELD || ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.PENDING_RESUME_FOREGROUND_AFTER_FAILURE) {
                if (imsCall == ImsPhoneCallTracker.this.mCallExpectedToResume) {
                    ImsPhoneCallTracker.this.log("onCallResumeFailed : switching " + ImsPhoneCallTracker.this.mForegroundCall + " with " + ImsPhoneCallTracker.this.mBackgroundCall);
                    ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                    if (ImsPhoneCallTracker.this.mForegroundCall.getState() == Call.State.HOLDING) {
                        ImsPhoneCallTracker.this.sendEmptyMessage(31);
                    }
                }
                ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                ImsPhoneCallTracker.this.logHoldSwapState("onCallResumeFailed: multi calls");
            } else if (ImsPhoneCallTracker.this.mHoldSwitchingState == HoldSwapState.PENDING_SINGLE_CALL_UNHOLD) {
                if (imsCall == ImsPhoneCallTracker.this.mCallExpectedToResume) {
                    ImsPhoneCallTracker.this.log("onCallResumeFailed: single call unhold case");
                    ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                    ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                    ImsPhoneCallTracker.this.mHoldSwitchingState = HoldSwapState.INACTIVE;
                    ImsPhoneCallTracker.this.logHoldSwapState("onCallResumeFailed: single call");
                } else {
                    Rlog.w(ImsPhoneCallTracker.LOG_TAG, "onCallResumeFailed: got a resume failed for a different call in the single call unhold case");
                }
            }
            ImsPhoneCallTracker.this.mPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.RESUME);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallResumeFailed(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession(), reasonInfo);
        }

        @Override
        public void onCallResumeReceived(ImsCall imsCall) {
            boolean useVideoPauseWorkaround;
            ImsPhoneCallTracker.this.log("onCallResumeReceived");
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                if (ImsPhoneCallTracker.this.mOnHoldToneStarted) {
                    ImsPhoneCallTracker.this.mPhone.stopOnHoldTone(conn);
                    ImsPhoneCallTracker.this.mOnHoldToneStarted = false;
                }
                conn.onConnectionEvent("android.telecom.event.CALL_REMOTELY_UNHELD", null);
            }
            if ((useVideoPauseWorkaround = ImsPhoneCallTracker.this.mPhone.getContext().getResources().getBoolean(17891562)) && ImsPhoneCallTracker.this.mSupportPauseVideo && VideoProfile.isVideo(conn.getVideoState())) {
                conn.changeToUnPausedState();
            }
            SuppServiceNotification supp = new SuppServiceNotification();
            supp.notificationType = 1;
            supp.code = 3;
            ImsPhoneCallTracker.this.mPhone.notifySuppSvcNotification(supp);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallResumeReceived(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getCallSession());
        }

        @Override
        public void onCallHoldReceived(ImsCall imsCall) {
            ImsPhoneCallTracker.this.onCallHoldReceived(imsCall);
        }

        @Override
        public void onCallSuppServiceReceived(ImsCall call, ImsSuppServiceNotification suppServiceInfo) {
            ImsPhoneCallTracker.this.log("onCallSuppServiceReceived: suppServiceInfo=" + suppServiceInfo);
            SuppServiceNotification supp = new SuppServiceNotification();
            supp.notificationType = suppServiceInfo.notificationType;
            supp.code = suppServiceInfo.code;
            supp.index = suppServiceInfo.index;
            supp.number = suppServiceInfo.number;
            supp.history = suppServiceInfo.history;
            ImsPhoneCallTracker.this.mPhone.notifySuppSvcNotification(supp);
        }

        @Override
        public void onCallMerged(ImsCall call, ImsCall peerCall, boolean swapCalls) {
            ImsPhoneCall peerImsPhoneCall;
            ImsPhoneCallTracker.this.log("onCallMerged");
            ImsPhoneCall foregroundImsPhoneCall = ImsPhoneCallTracker.this.findConnection(call).getCall();
            ImsPhoneConnection peerConnection = ImsPhoneCallTracker.this.findConnection(peerCall);
            ImsPhoneCall imsPhoneCall = peerImsPhoneCall = peerConnection == null ? null : peerConnection.getCall();
            if (swapCalls) {
                ImsPhoneCallTracker.this.switchAfterConferenceSuccess();
            }
            foregroundImsPhoneCall.merge(peerImsPhoneCall, Call.State.ACTIVE);
            try {
                ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(call);
                ImsPhoneCallTracker.this.log("onCallMerged: ImsPhoneConnection=" + conn);
                ImsPhoneCallTracker.this.log("onCallMerged: CurrentVideoProvider=" + conn.getVideoProvider());
                ImsPhoneCallTracker.this.setVideoCallProvider(conn, call);
                ImsPhoneCallTracker.this.log("onCallMerged: CurrentVideoProvider=" + conn.getVideoProvider());
            }
            catch (Exception e) {
                ImsPhoneCallTracker.this.loge("onCallMerged: exception " + e);
            }
            ImsPhoneCallTracker.this.processCallStateChange(ImsPhoneCallTracker.this.mForegroundCall.getImsCall(), Call.State.ACTIVE, 0);
            if (peerConnection != null) {
                ImsPhoneCallTracker.this.processCallStateChange(ImsPhoneCallTracker.this.mBackgroundCall.getImsCall(), Call.State.HOLDING, 0);
            }
            if (!call.isMergeRequestedByConf()) {
                ImsPhoneCallTracker.this.log("onCallMerged :: calling onMultipartyStateChanged()");
                this.onMultipartyStateChanged(call, true);
            } else {
                ImsPhoneCallTracker.this.log("onCallMerged :: Merge requested by existing conference.");
                call.resetIsMergeRequestedByConf(false);
            }
            ImsPhoneCallTracker.this.logState();
        }

        @Override
        public void onCallMergeFailed(ImsCall call, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallMergeFailed reasonInfo=" + reasonInfo);
            ImsPhoneCallTracker.this.mPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.CONFERENCE);
            call.resetIsMergeRequestedByConf(false);
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(call);
            if (conn != null) {
                conn.onConferenceMergeFailed();
                conn.handleMergeComplete();
            }
        }

        private void updateConferenceParticipantsTiming(List<ConferenceParticipant> participants) {
            for (ConferenceParticipant participant : participants) {
                CacheEntry cachedConnectTime = ImsPhoneCallTracker.this.findConnectionTimeUsePhoneNumber(participant);
                if (cachedConnectTime == null) continue;
                participant.setConnectTime(cachedConnectTime.mConnectTime);
                participant.setConnectElapsedTime(cachedConnectTime.mConnectElapsedTime);
                participant.setCallDirection(cachedConnectTime.mCallDirection);
            }
        }

        @Override
        public void onConferenceParticipantsStateChanged(ImsCall call, List<ConferenceParticipant> participants) {
            ImsPhoneCallTracker.this.log("onConferenceParticipantsStateChanged");
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(call);
            if (conn != null) {
                this.updateConferenceParticipantsTiming(participants);
                conn.updateConferenceParticipants(participants);
            }
        }

        @Override
        public void onCallSessionTtyModeReceived(ImsCall call, int mode) {
            ImsPhoneCallTracker.this.mPhone.onTtyModeReceived(mode);
        }

        @Override
        public void onCallHandover(ImsCall imsCall, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
            boolean isDataEnabled = ImsPhoneCallTracker.this.mPhone.getDefaultPhone().getDataEnabledSettings().isDataEnabled();
            ImsPhoneCallTracker.this.log("onCallHandover ::  srcAccessTech=" + srcAccessTech + ", targetAccessTech=" + targetAccessTech + ", reasonInfo=" + reasonInfo + ", dataEnabled=" + ImsPhoneCallTracker.this.mIsDataEnabled + "/" + isDataEnabled + ", dataMetered=" + ImsPhoneCallTracker.this.mIsViLteDataMetered);
            if (ImsPhoneCallTracker.this.mIsDataEnabled != isDataEnabled) {
                ImsPhoneCallTracker.this.loge("onCallHandover: data enabled state doesn't match! (was=" + ImsPhoneCallTracker.this.mIsDataEnabled + ", actually=" + isDataEnabled);
                ImsPhoneCallTracker.this.mIsDataEnabled = isDataEnabled;
            }
            boolean isHandoverToWifi = srcAccessTech != 0 && srcAccessTech != 18 && targetAccessTech == 18;
            boolean isHandoverFromWifi = srcAccessTech == 18 && targetAccessTech != 0 && targetAccessTech != 18;
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                ImsPhoneCall imsPhoneCall = conn.getCall();
                if (imsPhoneCall != null) {
                    imsPhoneCall.maybeStopRingback();
                }
                if (conn.getDisconnectCause() == 0) {
                    if (isHandoverToWifi) {
                        ImsPhoneCallTracker.this.removeMessages(25);
                        if (ImsPhoneCallTracker.this.mNotifyHandoverVideoFromLTEToWifi && ImsPhoneCallTracker.this.mHasAttemptedStartOfCallHandover) {
                            conn.onConnectionEvent("android.telephony.event.EVENT_HANDOVER_VIDEO_FROM_LTE_TO_WIFI", null);
                        }
                        ImsPhoneCallTracker.this.unregisterForConnectivityChanges();
                    } else if (isHandoverFromWifi && imsCall.isVideoCall()) {
                        ImsPhoneCallTracker.this.registerForConnectivityChanges();
                    }
                }
                if (isHandoverToWifi && ImsPhoneCallTracker.this.mIsViLteDataMetered) {
                    conn.setLocalVideoCapable(true);
                }
                if (isHandoverFromWifi && imsCall.isVideoCall()) {
                    if (ImsPhoneCallTracker.this.mIsViLteDataMetered) {
                        conn.setLocalVideoCapable(ImsPhoneCallTracker.this.mIsDataEnabled);
                    }
                    if (ImsPhoneCallTracker.this.mNotifyHandoverVideoFromWifiToLTE && ImsPhoneCallTracker.this.mIsDataEnabled) {
                        if (conn.getDisconnectCause() == 0) {
                            ImsPhoneCallTracker.this.log("onCallHandover :: notifying of WIFI to LTE handover.");
                            conn.onConnectionEvent("android.telephony.event.EVENT_HANDOVER_VIDEO_FROM_WIFI_TO_LTE", null);
                        } else {
                            ImsPhoneCallTracker.this.log("onCallHandover :: skip notify of WIFI to LTE handover for disconnected call.");
                        }
                    }
                    if (!ImsPhoneCallTracker.this.mIsDataEnabled && ImsPhoneCallTracker.this.mIsViLteDataMetered) {
                        ImsPhoneCallTracker.this.log("onCallHandover :: data is not enabled; attempt to downgrade.");
                        ImsPhoneCallTracker.this.downgradeVideoCall(1407, conn);
                    }
                }
            } else {
                ImsPhoneCallTracker.this.loge("onCallHandover :: connection null.");
            }
            if (!ImsPhoneCallTracker.this.mHasAttemptedStartOfCallHandover) {
                ImsPhoneCallTracker.this.mHasAttemptedStartOfCallHandover = true;
            }
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallHandoverEvent(ImsPhoneCallTracker.this.mPhone.getPhoneId(), 18, imsCall.getCallSession(), srcAccessTech, targetAccessTech, reasonInfo);
        }

        @Override
        public void onCallHandoverFailed(ImsCall imsCall, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallHandoverFailed :: srcAccessTech=" + srcAccessTech + ", targetAccessTech=" + targetAccessTech + ", reasonInfo=" + reasonInfo);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsCallHandoverEvent(ImsPhoneCallTracker.this.mPhone.getPhoneId(), 19, imsCall.getCallSession(), srcAccessTech, targetAccessTech, reasonInfo);
            boolean isHandoverToWifi = srcAccessTech != 18 && targetAccessTech == 18;
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null && isHandoverToWifi) {
                ImsPhoneCallTracker.this.log("onCallHandoverFailed - handover to WIFI Failed");
                ImsPhoneCallTracker.this.removeMessages(25);
                if (imsCall.isVideoCall() && conn.getDisconnectCause() == 0) {
                    ImsPhoneCallTracker.this.registerForConnectivityChanges();
                }
                if (ImsPhoneCallTracker.this.mNotifyVtHandoverToWifiFail) {
                    conn.onHandoverToWifiFailed();
                }
            }
            if (!ImsPhoneCallTracker.this.mHasAttemptedStartOfCallHandover) {
                ImsPhoneCallTracker.this.mHasAttemptedStartOfCallHandover = true;
            }
        }

        @Override
        public void onRttModifyRequestReceived(ImsCall imsCall) {
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                conn.onRttModifyRequestReceived();
            }
        }

        @Override
        public void onRttModifyResponseReceived(ImsCall imsCall, int status) {
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                conn.onRttModifyResponseReceived(status);
            }
        }

        @Override
        public void onRttMessageReceived(ImsCall imsCall, String message) {
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                conn.onRttMessageReceived(message);
            }
        }

        @Override
        public void onRttAudioIndicatorChanged(ImsCall imsCall, ImsStreamMediaProfile profile) {
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                conn.onRttAudioIndicatorChanged(profile);
            }
        }

        @Override
        public void onMultipartyStateChanged(ImsCall imsCall, boolean isMultiParty) {
            ImsPhoneCallTracker.this.log("onMultipartyStateChanged to " + (isMultiParty ? "Y" : "N"));
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                conn.updateMultipartyState(isMultiParty);
            }
        }

        @Override
        public void onCallQualityChanged(ImsCall imsCall, CallQuality callQuality) {
            ImsPhoneCallTracker.this.mPhone.onCallQualityChanged(callQuality, ServiceState.rilRadioTechnologyToNetworkType(imsCall.getRadioTechnology()));
            String callId = imsCall.getSession().getCallId();
            CallQualityMetrics cqm = (CallQualityMetrics)ImsPhoneCallTracker.this.mCallQualityMetrics.get(callId);
            if (cqm == null) {
                cqm = new CallQualityMetrics(ImsPhoneCallTracker.this.mPhone);
            }
            cqm.saveCallQuality(callQuality);
            ImsPhoneCallTracker.this.mCallQualityMetrics.put(callId, cqm);
        }
    };
    private ImsCall.Listener mImsUssdListener = new ImsCall.Listener(){

        @Override
        public void onCallStarted(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("mImsUssdListener onCallStarted");
            if (imsCall == ImsPhoneCallTracker.this.mUssdSession && ImsPhoneCallTracker.this.mPendingUssd != null) {
                AsyncResult.forMessage(ImsPhoneCallTracker.this.mPendingUssd);
                ImsPhoneCallTracker.this.mPendingUssd.sendToTarget();
                ImsPhoneCallTracker.this.mPendingUssd = null;
            }
        }

        @Override
        public void onCallStartFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("mImsUssdListener onCallStartFailed reasonCode=" + reasonInfo.getCode());
            this.onCallTerminated(imsCall, reasonInfo);
        }

        @Override
        public void onCallTerminated(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("mImsUssdListener onCallTerminated reasonCode=" + reasonInfo.getCode());
            ImsPhoneCallTracker.this.removeMessages(25);
            ImsPhoneCallTracker.this.mHasAttemptedStartOfCallHandover = false;
            ImsPhoneCallTracker.this.unregisterForConnectivityChanges();
            if (imsCall == ImsPhoneCallTracker.this.mUssdSession) {
                ImsPhoneCallTracker.this.mUssdSession = null;
                if (ImsPhoneCallTracker.this.mPendingUssd != null) {
                    CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
                    AsyncResult.forMessage(ImsPhoneCallTracker.this.mPendingUssd, null, ex);
                    ImsPhoneCallTracker.this.mPendingUssd.sendToTarget();
                    ImsPhoneCallTracker.this.mPendingUssd = null;
                }
            }
            imsCall.close();
        }

        @Override
        public void onCallUssdMessageReceived(ImsCall call, int mode, String ussdMessage) {
            ImsPhoneCallTracker.this.log("mImsUssdListener onCallUssdMessageReceived mode=" + mode);
            int ussdMode = -1;
            switch (mode) {
                case 1: {
                    ussdMode = 1;
                    break;
                }
                case 0: {
                    ussdMode = 0;
                }
            }
            ImsPhoneCallTracker.this.mPhone.onIncomingUSSD(ussdMode, ussdMessage);
        }
    };
    private final ImsMmTelManager.RegistrationCallback mImsRegistrationCallback = new ImsMmTelManager.RegistrationCallback(){

        @Override
        public void onRegistered(int imsRadioTech) {
            ImsPhoneCallTracker.this.log("onImsConnected imsRadioTech=" + imsRadioTech);
            ImsPhoneCallTracker.this.mPhone.setServiceState(0);
            ImsPhoneCallTracker.this.mPhone.setImsRegistered(true);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsConnectionState(ImsPhoneCallTracker.this.mPhone.getPhoneId(), 1, null);
        }

        @Override
        public void onRegistering(int imsRadioTech) {
            ImsPhoneCallTracker.this.log("onImsProgressing imsRadioTech=" + imsRadioTech);
            ImsPhoneCallTracker.this.mPhone.setServiceState(1);
            ImsPhoneCallTracker.this.mPhone.setImsRegistered(false);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsConnectionState(ImsPhoneCallTracker.this.mPhone.getPhoneId(), 2, null);
        }

        @Override
        public void onUnregistered(ImsReasonInfo imsReasonInfo) {
            ImsPhoneCallTracker.this.log("onImsDisconnected imsReasonInfo=" + imsReasonInfo);
            ImsPhoneCallTracker.this.mPhone.setServiceState(1);
            ImsPhoneCallTracker.this.mPhone.setImsRegistered(false);
            ImsPhoneCallTracker.this.mPhone.processDisconnectReason(imsReasonInfo);
            ImsPhoneCallTracker.this.mMetrics.writeOnImsConnectionState(ImsPhoneCallTracker.this.mPhone.getPhoneId(), 3, imsReasonInfo);
        }

        @Override
        public void onSubscriberAssociatedUriChanged(Uri[] uris) {
            ImsPhoneCallTracker.this.log("registrationAssociatedUriChanged");
            ImsPhoneCallTracker.this.mPhone.setCurrentSubscriberUris(uris);
        }
    };
    private final ImsMmTelManager.CapabilityCallback mImsCapabilityCallback = new ImsMmTelManager.CapabilityCallback(){

        @Override
        public void onCapabilitiesStatusChanged(MmTelFeature.MmTelCapabilities capabilities) {
            ImsPhoneCallTracker.this.log("onCapabilitiesStatusChanged: " + capabilities);
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = capabilities;
            ImsPhoneCallTracker.this.removeMessages(26);
            ImsPhoneCallTracker.this.obtainMessage(26, args).sendToTarget();
        }
    };
    private ImsConfigListener.Stub mImsConfigListener = new ImsConfigListener.Stub(){

        @Override
        public void onGetFeatureResponse(int feature, int network, int value, int status) {
        }

        @Override
        public void onSetFeatureResponse(int feature, int network, int value, int status) {
            ImsPhoneCallTracker.this.mMetrics.writeImsSetFeatureValue(ImsPhoneCallTracker.this.mPhone.getPhoneId(), feature, network, value);
        }

        @Override
        public void onGetVideoQuality(int status, int quality) {
        }

        @Override
        public void onSetVideoQuality(int status) {
        }
    };
    private final ProvisioningManager.Callback mConfigCallback = new ProvisioningManager.Callback(){

        @Override
        public void onProvisioningIntChanged(int item, int value) {
            this.sendConfigChangedIntent(item, Integer.toString(value));
        }

        @Override
        public void onProvisioningStringChanged(int item, String value) {
            this.sendConfigChangedIntent(item, value);
        }

        private void sendConfigChangedIntent(int item, String value) {
            ImsPhoneCallTracker.this.log("sendConfigChangedIntent - [" + item + ", " + value + "]");
            Intent configChangedIntent = new Intent("com.android.intent.action.IMS_CONFIG_CHANGED");
            configChangedIntent.putExtra("item", item);
            configChangedIntent.putExtra("value", value);
            if (ImsPhoneCallTracker.this.mPhone != null && ImsPhoneCallTracker.this.mPhone.getContext() != null) {
                ImsPhoneCallTracker.this.mPhone.getContext().sendBroadcast(configChangedIntent);
            }
        }
    };

    public ImsPhoneCallTracker(ImsPhone phone) {
        this(phone, phone.getContext().getMainExecutor());
    }

    @VisibleForTesting
    public ImsPhoneCallTracker(ImsPhone phone, Executor executor) {
        this.mPhone = phone;
        this.mMetrics = TelephonyMetrics.getInstance();
        IntentFilter intentfilter = new IntentFilter();
        intentfilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        intentfilter.addAction("android.telecom.action.CHANGE_DEFAULT_DIALER");
        this.mPhone.getContext().registerReceiver(this.mReceiver, intentfilter);
        this.cacheCarrierConfiguration(this.mPhone.getSubId());
        this.mPhone.getDefaultPhone().getDataEnabledSettings().registerForDataEnabledChanged(this, 23, null);
        TelecomManager telecomManager = (TelecomManager)this.mPhone.getContext().getSystemService("telecom");
        this.mDefaultDialerUid.set(this.getPackageUid(this.mPhone.getContext(), telecomManager.getDefaultDialerPackage()));
        long currentTime = SystemClock.elapsedRealtime();
        this.mVtDataUsageSnapshot = new NetworkStats(currentTime, 1);
        this.mVtDataUsageUidSnapshot = new NetworkStats(currentTime, 1);
        this.mImsManagerConnector = new ImsManager.Connector(phone.getContext(), phone.getPhoneId(), new ImsManager.Connector.Listener(){

            @Override
            public void connectionReady(ImsManager manager) throws ImsException {
                ImsPhoneCallTracker.this.mImsManager = manager;
                ImsPhoneCallTracker.this.startListeningForCalls();
            }

            @Override
            public void connectionUnavailable() {
                ImsPhoneCallTracker.this.stopListeningForCalls();
            }
        }, executor);
        this.mImsManagerConnector.connect();
    }

    @VisibleForTesting
    public void setSharedPreferenceProxy(SharedPreferenceProxy sharedPreferenceProxy) {
        this.mSharedPreferenceProxy = sharedPreferenceProxy;
    }

    @VisibleForTesting
    public void setPhoneNumberUtilsProxy(PhoneNumberUtilsProxy phoneNumberUtilsProxy) {
        this.mPhoneNumberUtilsProxy = phoneNumberUtilsProxy;
    }

    @VisibleForTesting
    public void setRetryTimeout(ImsManager.Connector.RetryTimeout retryTimeout) {
        this.mImsManagerConnector.mRetryTimeout = retryTimeout;
    }

    private int getPackageUid(Context context, String pkg) {
        if (pkg == null) {
            return -1;
        }
        int uid = -1;
        try {
            uid = context.getPackageManager().getPackageUid(pkg, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            this.loge("Cannot find package uid. pkg = " + pkg);
        }
        return uid;
    }

    private void startListeningForCalls() throws ImsException {
        this.log("startListeningForCalls");
        this.mImsManager.open(this.mMmTelFeatureListener);
        this.mImsManager.addRegistrationCallback(this.mImsRegistrationCallback);
        this.mImsManager.addCapabilitiesCallback(this.mImsCapabilityCallback);
        this.mImsManager.setConfigListener(this.mImsConfigListener);
        this.mImsManager.getConfigInterface().addConfigCallback(this.mConfigCallback);
        this.getEcbmInterface().setEcbmStateListener(this.mPhone.getImsEcbmStateListener());
        if (this.mPhone.isInEcm()) {
            this.mPhone.exitEmergencyCallbackMode();
        }
        int mPreferredTtyMode = Settings.Secure.getInt(this.mPhone.getContext().getContentResolver(), "preferred_tty_mode", 0);
        this.mImsManager.setUiTTYMode(this.mPhone.getContext(), mPreferredTtyMode, null);
        ImsMultiEndpoint multiEndpoint = this.getMultiEndpointInterface();
        if (multiEndpoint != null) {
            multiEndpoint.setExternalCallStateListener(this.mPhone.getExternalCallTracker().getExternalCallStateListener());
        }
        this.mUtInterface = this.getUtInterface();
        if (this.mUtInterface != null) {
            this.mUtInterface.registerForSuppServiceIndication(this, 27, null);
        }
        if (this.mCarrierConfigLoaded) {
            this.mImsManager.updateImsServiceConfig(true);
        }
        this.sendImsServiceStateIntent("com.android.ims.IMS_SERVICE_UP");
    }

    private void stopListeningForCalls() {
        this.log("stopListeningForCalls");
        this.resetImsCapabilities();
        if (this.mImsManager != null) {
            try {
                this.mImsManager.getConfigInterface().removeConfigCallback(this.mConfigCallback.getBinder());
            }
            catch (ImsException e) {
                Log.w(LOG_TAG, "stopListeningForCalls: unable to remove config callback.");
            }
            this.mImsManager.close();
        }
        this.sendImsServiceStateIntent("com.android.ims.IMS_SERVICE_DOWN");
    }

    private void sendImsServiceStateIntent(String intentAction) {
        Intent intent = new Intent(intentAction);
        intent.putExtra("android:phone_id", this.mPhone.getPhoneId());
        if (this.mPhone != null && this.mPhone.getContext() != null) {
            this.mPhone.getContext().sendBroadcast(intent);
        }
    }

    public void dispose() {
        this.log("dispose");
        this.mRingingCall.dispose();
        this.mBackgroundCall.dispose();
        this.mForegroundCall.dispose();
        this.mHandoverCall.dispose();
        this.clearDisconnected();
        if (this.mUtInterface != null) {
            this.mUtInterface.unregisterForSuppServiceIndication(this);
        }
        this.mPhone.getContext().unregisterReceiver(this.mReceiver);
        this.mPhone.getDefaultPhone().getDataEnabledSettings().unregisterForDataEnabledChanged(this);
        this.mImsManagerConnector.disconnect();
    }

    protected void finalize() {
        this.log("ImsPhoneCallTracker finalized");
    }

    @Override
    public void registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallStartedRegistrants.add(r);
    }

    @Override
    public void unregisterForVoiceCallStarted(Handler h) {
        this.mVoiceCallStartedRegistrants.remove(h);
    }

    @Override
    public void registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallEndedRegistrants.add(r);
    }

    @Override
    public void unregisterForVoiceCallEnded(Handler h) {
        this.mVoiceCallEndedRegistrants.remove(h);
    }

    public int getClirMode() {
        if (this.mSharedPreferenceProxy != null && this.mPhone.getDefaultPhone() != null) {
            SharedPreferences sp = this.mSharedPreferenceProxy.getDefaultSharedPreferences(this.mPhone.getContext());
            return sp.getInt("clir_key" + this.mPhone.getDefaultPhone().getPhoneId(), 0);
        }
        this.loge("dial; could not get default CLIR mode.");
        return 0;
    }

    @UnsupportedAppUsage
    public Connection dial(String dialString, int videoState, Bundle intentExtras) throws CallStateException {
        ImsPhone.ImsDialArgs dialArgs = ((ImsPhone.ImsDialArgs.Builder)((ImsPhone.ImsDialArgs.Builder)new ImsPhone.ImsDialArgs.Builder().setIntentExtras(intentExtras)).setVideoState(videoState)).setClirMode(this.getClirMode()).build();
        return this.dial(dialString, dialArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Connection dial(String dialString, ImsPhone.ImsDialArgs dialArgs) throws CallStateException {
        boolean isPhoneInEcmMode = this.isPhoneInEcbMode();
        boolean isEmergencyNumber = this.mPhoneNumberUtilsProxy.isEmergencyNumber(dialString);
        if (!this.shouldNumberBePlacedOnIms(isEmergencyNumber, dialString)) {
            Rlog.i(LOG_TAG, "dial: shouldNumberBePlacedOnIms = false");
            throw new CallStateException("cs_fallback");
        }
        int clirMode = dialArgs.clirMode;
        int videoState = dialArgs.videoState;
        this.log("dial clirMode=" + clirMode);
        if (isEmergencyNumber) {
            clirMode = 2;
            this.log("dial emergency call, set clirModIe=" + clirMode);
        }
        this.clearDisconnected();
        if (this.mImsManager == null) {
            throw new CallStateException("service not available");
        }
        this.checkForDialIssues();
        if (isPhoneInEcmMode && isEmergencyNumber) {
            this.handleEcmTimer(1);
        }
        if (isEmergencyNumber && VideoProfile.isVideo(videoState) && !this.mAllowEmergencyVideoCalls) {
            this.loge("dial: carrier does not support video emergency calls; downgrade to audio-only");
            videoState = 0;
        }
        boolean holdBeforeDial = false;
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            if (this.mBackgroundCall.getState() != Call.State.IDLE) {
                throw new CallStateException(6, "Already too many ongoing calls.");
            }
            holdBeforeDial = true;
            this.mPendingCallVideoState = videoState;
            this.mPendingIntentExtras = dialArgs.intentExtras;
            this.holdActiveCallForPendingMo();
        }
        Call.State fgState = Call.State.IDLE;
        Call.State bgState = Call.State.IDLE;
        this.mClirMode = clirMode;
        Object object = this.mSyncHold;
        synchronized (object) {
            if (holdBeforeDial) {
                fgState = this.mForegroundCall.getState();
                bgState = this.mBackgroundCall.getState();
                if (fgState == Call.State.ACTIVE) {
                    throw new CallStateException("cannot dial in current state");
                }
                if (bgState == Call.State.HOLDING) {
                    holdBeforeDial = false;
                }
            }
            this.mLastDialString = dialString;
            this.mLastDialArgs = dialArgs;
            this.mPendingMO = new ImsPhoneConnection((Phone)this.mPhone, this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall, isEmergencyNumber);
            if (isEmergencyNumber && dialArgs != null && dialArgs.intentExtras != null) {
                Rlog.i(LOG_TAG, "dial ims emergency dialer: " + dialArgs.intentExtras.getBoolean("android.telecom.extra.IS_USER_INTENT_EMERGENCY_CALL"));
                this.mPendingMO.setHasKnownUserIntentEmergency(dialArgs.intentExtras.getBoolean("android.telecom.extra.IS_USER_INTENT_EMERGENCY_CALL"));
            }
            this.mPendingMO.setVideoState(videoState);
            if (dialArgs.rttTextStream != null) {
                this.log("dial: setting RTT stream on mPendingMO");
                this.mPendingMO.setCurrentRttTextStream(dialArgs.rttTextStream);
            }
        }
        this.addConnection(this.mPendingMO);
        if (!holdBeforeDial) {
            if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyNumber) {
                this.dialInternal(this.mPendingMO, clirMode, videoState, dialArgs.intentExtras);
            } else {
                try {
                    this.getEcbmInterface().exitEmergencyCallbackMode();
                }
                catch (ImsException e) {
                    e.printStackTrace();
                    throw new CallStateException("service not available");
                }
                this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                this.pendingCallClirMode = clirMode;
                this.mPendingCallVideoState = videoState;
                this.pendingCallInEcm = true;
            }
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    boolean isImsServiceReady() {
        if (this.mImsManager == null) {
            return false;
        }
        return this.mImsManager.isServiceReady();
    }

    private boolean shouldNumberBePlacedOnIms(boolean isEmergency, String number) {
        int processCallResult;
        try {
            if (this.mImsManager == null) {
                Rlog.w(LOG_TAG, "ImsManager unavailable, shouldProcessCall returning false.");
                return false;
            }
            processCallResult = this.mImsManager.shouldProcessCall(isEmergency, new String[]{number});
            Rlog.i(LOG_TAG, "shouldProcessCall: number: " + Rlog.pii(LOG_TAG, (Object)number) + ", result: " + processCallResult);
        }
        catch (ImsException e) {
            Rlog.w(LOG_TAG, "ImsService unavailable, shouldProcessCall returning false.");
            return false;
        }
        switch (processCallResult) {
            case 0: {
                return true;
            }
            case 1: {
                Rlog.i(LOG_TAG, "shouldProcessCall: place over CSFB instead.");
                return false;
            }
        }
        Rlog.w(LOG_TAG, "shouldProcessCall returned unknown result.");
        return false;
    }

    private void cacheCarrierConfiguration(int subId) {
        CarrierConfigManager carrierConfigManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        if (carrierConfigManager == null || !SubscriptionController.getInstance().isActiveSubId(subId)) {
            this.loge("cacheCarrierConfiguration: No carrier config service found or not active subId = " + subId);
            this.mCarrierConfigLoaded = false;
            return;
        }
        PersistableBundle carrierConfig = carrierConfigManager.getConfigForSubId(subId);
        if (carrierConfig == null) {
            this.loge("cacheCarrierConfiguration: Empty carrier config.");
            this.mCarrierConfigLoaded = false;
            return;
        }
        this.mCarrierConfigLoaded = true;
        this.updateCarrierConfigCache(carrierConfig);
    }

    @VisibleForTesting
    public void updateCarrierConfigCache(PersistableBundle carrierConfig) {
        this.mAllowEmergencyVideoCalls = carrierConfig.getBoolean("allow_emergency_video_calls_bool");
        this.mTreatDowngradedVideoCallsAsVideoCalls = carrierConfig.getBoolean("treat_downgraded_video_calls_as_video_calls_bool");
        this.mDropVideoCallWhenAnsweringAudioCall = carrierConfig.getBoolean("drop_video_call_when_answering_audio_call_bool");
        this.mAllowAddCallDuringVideoCall = carrierConfig.getBoolean("allow_add_call_during_video_call");
        this.mNotifyVtHandoverToWifiFail = carrierConfig.getBoolean("notify_vt_handover_to_wifi_failure_bool");
        this.mSupportDowngradeVtToAudio = carrierConfig.getBoolean("support_downgrade_vt_to_audio_bool");
        this.mNotifyHandoverVideoFromWifiToLTE = carrierConfig.getBoolean("notify_handover_video_from_wifi_to_lte_bool");
        this.mNotifyHandoverVideoFromLTEToWifi = carrierConfig.getBoolean("notify_handover_video_from_lte_to_wifi_bool");
        this.mIgnoreDataEnabledChangedForVideoCalls = carrierConfig.getBoolean("ignore_data_enabled_changed_for_video_calls");
        this.mIsViLteDataMetered = carrierConfig.getBoolean("vilte_data_is_metered_bool");
        this.mSupportPauseVideo = carrierConfig.getBoolean("support_pause_ims_video_calls_bool");
        this.mAlwaysPlayRemoteHoldTone = carrierConfig.getBoolean("always_play_remote_hold_tone_bool");
        this.mAutoRetryFailedWifiEmergencyCall = carrierConfig.getBoolean("auto_retry_failed_wifi_emergency_call");
        String[] mappings = carrierConfig.getStringArray("ims_reasoninfo_mapping_string_array");
        if (mappings != null && mappings.length > 0) {
            for (String mapping : mappings) {
                String[] values = mapping.split(Pattern.quote("|"));
                if (values.length != 3) continue;
                try {
                    Integer fromCode = values[0].equals("*") ? null : Integer.valueOf(Integer.parseInt(values[0]));
                    String message = values[1];
                    if (message == null) {
                        message = "";
                    }
                    int toCode = Integer.parseInt(values[2]);
                    this.addReasonCodeRemapping(fromCode, message, toCode);
                    this.log("Loaded ImsReasonInfo mapping : fromCode = " + fromCode == null ? "any" : fromCode + " ; message = " + message + " ; toCode = " + toCode);
                }
                catch (NumberFormatException nfe) {
                    this.loge("Invalid ImsReasonInfo mapping found: " + mapping);
                }
            }
        } else {
            this.log("No carrier ImsReasonInfo mappings defined.");
        }
    }

    @UnsupportedAppUsage
    private void handleEcmTimer(int action) {
        this.mPhone.handleTimerInEmergencyCallbackMode(action);
        switch (action) {
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.log("handleEcmTimer, unsupported action " + action);
            }
        }
    }

    private void dialInternal(ImsPhoneConnection conn, int clirMode, int videoState, Bundle intentExtras) {
        if (conn == null) {
            return;
        }
        if (conn.getAddress() == null || conn.getAddress().length() == 0 || conn.getAddress().indexOf(78) >= 0) {
            conn.setDisconnectCause(7);
            this.sendEmptyMessageDelayed(18, 500L);
            return;
        }
        this.setMute(false);
        boolean isEmergencyCall = this.mPhoneNumberUtilsProxy.isEmergencyNumber(conn.getAddress());
        int serviceType = isEmergencyCall ? 2 : 1;
        int callType = ImsCallProfile.getCallTypeFromVideoState(videoState);
        conn.setVideoState(videoState);
        try {
            String[] callees = new String[]{conn.getAddress()};
            ImsCallProfile profile = this.mImsManager.createCallProfile(serviceType, callType);
            profile.setCallExtraInt("oir", clirMode);
            if (isEmergencyCall) {
                this.setEmergencyCallInfo(profile, conn);
            }
            if (intentExtras != null) {
                if (intentExtras.containsKey("android.telecom.extra.CALL_SUBJECT")) {
                    intentExtras.putString("DisplayText", this.cleanseInstantLetteringMessage(intentExtras.getString("android.telecom.extra.CALL_SUBJECT")));
                }
                if (conn.hasRttTextStream()) {
                    profile.mMediaProfile.mRttMode = 1;
                }
                if (intentExtras.containsKey("CallPull")) {
                    profile.mCallExtras.putBoolean("CallPull", intentExtras.getBoolean("CallPull"));
                    int dialogId = intentExtras.getInt("android.telephony.ImsExternalCallTracker.extra.EXTERNAL_CALL_ID");
                    conn.setIsPulledCall(true);
                    conn.setPulledDialogId(dialogId);
                }
                profile.mCallExtras.putBundle("OemCallExtras", intentExtras);
            }
            ImsCall imsCall = this.mImsManager.makeCall(profile, callees, this.mImsCallListener);
            conn.setImsCall(imsCall);
            this.mMetrics.writeOnImsCallStart(this.mPhone.getPhoneId(), imsCall.getSession());
            this.setVideoCallProvider(conn, imsCall);
            conn.setAllowAddCallDuringVideoCall(this.mAllowAddCallDuringVideoCall);
        }
        catch (ImsException e) {
            this.loge("dialInternal : " + e);
            conn.setDisconnectCause(36);
            this.sendEmptyMessageDelayed(18, 500L);
            this.retryGetImsService();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void acceptCall(int videoState) throws CallStateException {
        this.log("acceptCall");
        if (this.mForegroundCall.getState().isAlive() && this.mBackgroundCall.getState().isAlive()) {
            throw new CallStateException("cannot accept call");
        }
        if (this.mRingingCall.getState() == Call.State.WAITING && this.mForegroundCall.getState().isAlive()) {
            this.setMute(false);
            boolean answeringWillDisconnect = false;
            ImsCall activeCall = this.mForegroundCall.getImsCall();
            ImsCall ringingCall = this.mRingingCall.getImsCall();
            if (this.mForegroundCall.hasConnections() && this.mRingingCall.hasConnections()) {
                answeringWillDisconnect = this.shouldDisconnectActiveCallOnAnswer(activeCall, ringingCall);
            }
            this.mPendingCallVideoState = videoState;
            if (answeringWillDisconnect) {
                this.mForegroundCall.hangup();
                try {
                    ringingCall.accept(ImsCallProfile.getCallTypeFromVideoState(videoState));
                }
                catch (ImsException e) {
                    throw new CallStateException("cannot accept call");
                }
            } else {
                this.holdActiveCallForWaitingCall();
            }
        } else if (this.mRingingCall.getState().isRinging()) {
            this.log("acceptCall: incoming...");
            this.setMute(false);
            try {
                ImsCall imsCall = this.mRingingCall.getImsCall();
                if (imsCall == null) {
                    throw new CallStateException("no valid ims call");
                }
                imsCall.accept(ImsCallProfile.getCallTypeFromVideoState(videoState));
                this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 2);
            }
            catch (ImsException e) {
                throw new CallStateException("cannot accept call");
            }
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    public void rejectCall() throws CallStateException {
        this.log("rejectCall");
        if (!this.mRingingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.hangup(this.mRingingCall);
    }

    private void setEmergencyCallInfo(ImsCallProfile profile, Connection conn) {
        EmergencyNumber num = conn.getEmergencyNumberInfo();
        if (num != null) {
            profile.setEmergencyCallInfo(num, conn.hasKnownUserIntentEmergency());
        }
    }

    @UnsupportedAppUsage
    private void switchAfterConferenceSuccess() {
        this.log("switchAfterConferenceSuccess fg =" + (Object)((Object)this.mForegroundCall.getState()) + ", bg = " + (Object)((Object)this.mBackgroundCall.getState()));
        if (this.mBackgroundCall.getState() == Call.State.HOLDING) {
            this.log("switchAfterConferenceSuccess");
            this.mForegroundCall.switchWith(this.mBackgroundCall);
        }
    }

    private void holdActiveCallForPendingMo() throws CallStateException {
        if (this.mHoldSwitchingState == HoldSwapState.PENDING_SINGLE_CALL_HOLD || this.mHoldSwitchingState == HoldSwapState.SWAPPING_ACTIVE_AND_HELD) {
            this.logi("Ignoring hold request while already holding or swapping");
            return;
        }
        ImsCall callToHold = this.mForegroundCall.getImsCall();
        this.mHoldSwitchingState = HoldSwapState.HOLDING_TO_DIAL_OUTGOING;
        this.logHoldSwapState("holdActiveCallForPendingMo");
        this.mForegroundCall.switchWith(this.mBackgroundCall);
        try {
            callToHold.hold();
            this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), callToHold.getSession(), 5);
        }
        catch (ImsException e) {
            this.mForegroundCall.switchWith(this.mBackgroundCall);
            throw new CallStateException(e.getMessage());
        }
    }

    public void holdActiveCall() throws CallStateException {
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            if (this.mHoldSwitchingState == HoldSwapState.PENDING_SINGLE_CALL_HOLD || this.mHoldSwitchingState == HoldSwapState.SWAPPING_ACTIVE_AND_HELD) {
                this.logi("Ignoring hold request while already holding or swapping");
                return;
            }
            ImsCall callToHold = this.mForegroundCall.getImsCall();
            if (this.mBackgroundCall.getState().isAlive()) {
                this.mCallExpectedToResume = this.mBackgroundCall.getImsCall();
                this.mHoldSwitchingState = HoldSwapState.SWAPPING_ACTIVE_AND_HELD;
            } else {
                this.mHoldSwitchingState = HoldSwapState.PENDING_SINGLE_CALL_HOLD;
            }
            this.logHoldSwapState("holdActiveCall");
            this.mForegroundCall.switchWith(this.mBackgroundCall);
            try {
                callToHold.hold();
                this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), callToHold.getSession(), 5);
            }
            catch (ImsException e) {
                this.mForegroundCall.switchWith(this.mBackgroundCall);
                throw new CallStateException(e.getMessage());
            }
        }
    }

    public void holdActiveCallForWaitingCall() throws CallStateException {
        boolean switchingWithWaitingCall;
        boolean bl = switchingWithWaitingCall = !this.mBackgroundCall.getState().isAlive() && this.mRingingCall.getState() == Call.State.WAITING;
        if (switchingWithWaitingCall) {
            ImsCall callToHold = this.mForegroundCall.getImsCall();
            this.mHoldSwitchingState = HoldSwapState.HOLDING_TO_ANSWER_INCOMING;
            this.mForegroundCall.switchWith(this.mBackgroundCall);
            this.logHoldSwapState("holdActiveCallForWaitingCall");
            try {
                callToHold.hold();
                this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), callToHold.getSession(), 5);
            }
            catch (ImsException e) {
                this.mForegroundCall.switchWith(this.mBackgroundCall);
                throw new CallStateException(e.getMessage());
            }
        }
    }

    void unholdHeldCall() throws CallStateException {
        try {
            ImsCall imsCall = this.mBackgroundCall.getImsCall();
            if (this.mHoldSwitchingState == HoldSwapState.PENDING_SINGLE_CALL_UNHOLD || this.mHoldSwitchingState == HoldSwapState.SWAPPING_ACTIVE_AND_HELD) {
                this.logi("Ignoring unhold request while already unholding or swapping");
                return;
            }
            if (imsCall != null) {
                this.mCallExpectedToResume = imsCall;
                this.mHoldSwitchingState = HoldSwapState.PENDING_SINGLE_CALL_UNHOLD;
                this.mForegroundCall.switchWith(this.mBackgroundCall);
                this.logHoldSwapState("unholdCurrentCall");
                imsCall.resume();
                this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 6);
            }
        }
        catch (ImsException e) {
            throw new CallStateException(e.getMessage());
        }
    }

    private void resumeForegroundCall() throws ImsException {
        ImsCall imsCall = this.mForegroundCall.getImsCall();
        if (imsCall != null) {
            imsCall.resume();
            this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 6);
        }
    }

    private void answerWaitingCall() throws ImsException {
        ImsCall imsCall = this.mRingingCall.getImsCall();
        if (imsCall != null) {
            imsCall.accept(ImsCallProfile.getCallTypeFromVideoState(this.mPendingCallVideoState));
            this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 2);
        }
    }

    private void maintainConnectTimeCache() {
        long threshold = SystemClock.elapsedRealtime() - 60000L;
        this.mPhoneNumAndConnTime.entrySet().removeIf(e -> ((CacheEntry)e.getValue()).mCachedTime < threshold);
        while (!this.mUnknownPeerConnTime.isEmpty() && this.mUnknownPeerConnTime.peek().mCachedTime < threshold) {
            this.mUnknownPeerConnTime.poll();
        }
    }

    private void cacheConnectionTimeWithPhoneNumber(ImsPhoneConnection connection) {
        int callDirection = connection.isIncoming() ? 0 : 1;
        CacheEntry cachedConnectTime = new CacheEntry(SystemClock.elapsedRealtime(), connection.getConnectTime(), connection.getConnectTimeReal(), callDirection);
        this.maintainConnectTimeCache();
        if (1 == connection.getNumberPresentation()) {
            String phoneNumber = this.getFormattedPhoneNumber(connection.getAddress());
            if (this.mPhoneNumAndConnTime.containsKey(phoneNumber) && connection.getConnectTime() <= this.mPhoneNumAndConnTime.get(phoneNumber).mConnectTime) {
                return;
            }
            this.mPhoneNumAndConnTime.put(phoneNumber, cachedConnectTime);
        } else {
            this.mUnknownPeerConnTime.add(cachedConnectTime);
        }
    }

    private CacheEntry findConnectionTimeUsePhoneNumber(ConferenceParticipant participant) {
        this.maintainConnectTimeCache();
        if (1 == participant.getParticipantPresentation()) {
            if (participant.getHandle() == null || participant.getHandle().getSchemeSpecificPart() == null) {
                return null;
            }
            String number = ConferenceParticipant.getParticipantAddress(participant.getHandle(), this.getCountryIso()).getSchemeSpecificPart();
            if (TextUtils.isEmpty(number)) {
                return null;
            }
            String formattedNumber = this.getFormattedPhoneNumber(number);
            return this.mPhoneNumAndConnTime.get(formattedNumber);
        }
        return this.mUnknownPeerConnTime.poll();
    }

    private String getFormattedPhoneNumber(String number) {
        String countryIso = this.getCountryIso();
        if (countryIso == null) {
            return number;
        }
        String phoneNumber = PhoneNumberUtils.formatNumberToE164(number, countryIso);
        return phoneNumber == null ? number : phoneNumber;
    }

    private String getCountryIso() {
        int subId = this.mPhone.getSubId();
        SubscriptionInfo info = SubscriptionManager.from(this.mPhone.getContext()).getActiveSubscriptionInfo(subId);
        return info == null ? null : info.getCountryIso();
    }

    public void conference() {
        long conferenceConnectTime;
        ImsCall fgImsCall = this.mForegroundCall.getImsCall();
        if (fgImsCall == null) {
            this.log("conference no foreground ims call");
            return;
        }
        ImsCall bgImsCall = this.mBackgroundCall.getImsCall();
        if (bgImsCall == null) {
            this.log("conference no background ims call");
            return;
        }
        if (fgImsCall.isCallSessionMergePending()) {
            this.log("conference: skip; foreground call already in process of merging.");
            return;
        }
        if (bgImsCall.isCallSessionMergePending()) {
            this.log("conference: skip; background call already in process of merging.");
            return;
        }
        long foregroundConnectTime = this.mForegroundCall.getEarliestConnectTime();
        long backgroundConnectTime = this.mBackgroundCall.getEarliestConnectTime();
        if (foregroundConnectTime > 0L && backgroundConnectTime > 0L) {
            conferenceConnectTime = Math.min(this.mForegroundCall.getEarliestConnectTime(), this.mBackgroundCall.getEarliestConnectTime());
            this.log("conference - using connect time = " + conferenceConnectTime);
        } else if (foregroundConnectTime > 0L) {
            this.log("conference - bg call connect time is 0; using fg = " + foregroundConnectTime);
            conferenceConnectTime = foregroundConnectTime;
        } else {
            this.log("conference - fg call connect time is 0; using bg = " + backgroundConnectTime);
            conferenceConnectTime = backgroundConnectTime;
        }
        String foregroundId = "";
        ImsPhoneConnection foregroundConnection = this.mForegroundCall.getFirstConnection();
        if (foregroundConnection != null) {
            foregroundConnection.setConferenceConnectTime(conferenceConnectTime);
            foregroundConnection.handleMergeStart();
            foregroundId = foregroundConnection.getTelecomCallId();
            this.cacheConnectionTimeWithPhoneNumber(foregroundConnection);
        }
        String backgroundId = "";
        ImsPhoneConnection backgroundConnection = this.findConnection(bgImsCall);
        if (backgroundConnection != null) {
            backgroundConnection.handleMergeStart();
            backgroundId = backgroundConnection.getTelecomCallId();
            this.cacheConnectionTimeWithPhoneNumber(backgroundConnection);
        }
        this.log("conference: fgCallId=" + foregroundId + ", bgCallId=" + backgroundId);
        try {
            fgImsCall.merge(bgImsCall);
        }
        catch (ImsException e) {
            this.log("conference " + e.getMessage());
        }
    }

    public void explicitCallTransfer() {
    }

    @UnsupportedAppUsage
    public void clearDisconnected() {
        this.log("clearDisconnected");
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    public boolean canConference() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING && !this.mBackgroundCall.isFull() && !this.mForegroundCall.isFull();
    }

    public void checkForDialIssues() throws CallStateException {
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        if (disableCall.equals("true")) {
            throw new CallStateException(5, "ro.telephony.disable-call has been used to disable calling.");
        }
        if (this.mPendingMO != null) {
            throw new CallStateException(3, "Another outgoing call is already being dialed.");
        }
        if (this.mRingingCall.isRinging()) {
            throw new CallStateException(4, "Can't place a call while another is ringing.");
        }
        if (this.mForegroundCall.getState().isAlive() & this.mBackgroundCall.getState().isAlive()) {
            throw new CallStateException(6, "Already an active foreground and background call.");
        }
    }

    public boolean canTransfer() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING;
    }

    private void internalClearDisconnected() {
        this.mRingingCall.clearDisconnected();
        this.mForegroundCall.clearDisconnected();
        this.mBackgroundCall.clearDisconnected();
        this.mHandoverCall.clearDisconnected();
    }

    @UnsupportedAppUsage
    private void updatePhoneState() {
        boolean isPendingMOIdle;
        PhoneConstants.State oldState = this.mState;
        boolean bl = isPendingMOIdle = this.mPendingMO == null || !this.mPendingMO.getState().isAlive();
        this.mState = this.mRingingCall.isRinging() ? PhoneConstants.State.RINGING : (!isPendingMOIdle || !this.mForegroundCall.isIdle() || !this.mBackgroundCall.isIdle() ? PhoneConstants.State.OFFHOOK : PhoneConstants.State.IDLE);
        if (this.mState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        this.log("updatePhoneState pendingMo = " + (this.mPendingMO == null ? "null" : this.mPendingMO.getState()) + ", fg= " + (Object)((Object)this.mForegroundCall.getState()) + "(" + this.mForegroundCall.getConnections().size() + "), bg= " + (Object)((Object)this.mBackgroundCall.getState()) + "(" + this.mBackgroundCall.getConnections().size() + ")");
        this.log("updatePhoneState oldState=" + (Object)((Object)oldState) + ", newState=" + (Object)((Object)this.mState));
        if (this.mState != oldState) {
            this.mPhone.notifyPhoneStateChanged();
            this.mMetrics.writePhoneState(this.mPhone.getPhoneId(), this.mState);
            this.notifyPhoneStateChanged(oldState, this.mState);
        }
    }

    private void handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private void dumpState() {
        int i;
        this.log("Phone State:" + (Object)((Object)this.mState));
        this.log("Ringing call: " + this.mRingingCall.toString());
        List<Connection> l = this.mRingingCall.getConnections();
        int s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
        this.log("Foreground call: " + this.mForegroundCall.toString());
        l = this.mForegroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
        this.log("Background call: " + this.mBackgroundCall.toString());
        l = this.mBackgroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
    }

    public void setTtyMode(int ttyMode) {
        if (this.mImsManager == null) {
            Log.w(LOG_TAG, "ImsManager is null when setting TTY mode");
            return;
        }
        try {
            this.mImsManager.setTtyMode(ttyMode);
        }
        catch (ImsException e) {
            this.loge("setTtyMode : " + e);
            this.retryGetImsService();
        }
    }

    public void setUiTTYMode(int uiTtyMode, Message onComplete) {
        if (this.mImsManager == null) {
            this.mPhone.sendErrorResponse(onComplete, this.getImsManagerIsNullException());
            return;
        }
        try {
            this.mImsManager.setUiTTYMode(this.mPhone.getContext(), uiTtyMode, onComplete);
        }
        catch (ImsException e) {
            this.loge("setUITTYMode : " + e);
            this.mPhone.sendErrorResponse(onComplete, e);
            this.retryGetImsService();
        }
    }

    public void setMute(boolean mute) {
        this.mDesiredMute = mute;
        this.mForegroundCall.setMute(mute);
    }

    public boolean getMute() {
        return this.mDesiredMute;
    }

    public void sendDtmf(char c, Message result) {
        this.log("sendDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.sendDtmf(c, result);
        }
    }

    public void startDtmf(char c) {
        this.log("startDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.startDtmf(c);
        } else {
            this.loge("startDtmf : no foreground call");
        }
    }

    public void stopDtmf() {
        this.log("stopDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.stopDtmf();
        } else {
            this.loge("stopDtmf : no foreground call");
        }
    }

    public void hangup(ImsPhoneConnection conn) throws CallStateException {
        this.log("hangup connection");
        if (conn.getOwner() != this) {
            throw new CallStateException("ImsPhoneConnection " + conn + "does not belong to ImsPhoneCallTracker " + this);
        }
        this.hangup(conn.getCall());
    }

    public void hangup(ImsPhoneCall call) throws CallStateException {
        this.log("hangup call");
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections");
        }
        ImsCall imsCall = call.getImsCall();
        boolean rejectCall = false;
        if (call == this.mRingingCall) {
            this.log("(ringing) hangup incoming");
            rejectCall = true;
        } else if (call == this.mForegroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
            } else {
                this.log("(foregnd) hangup foreground");
            }
        } else if (call == this.mBackgroundCall) {
            this.log("(backgnd) hangup waiting or background");
        } else {
            throw new CallStateException("ImsPhoneCall " + call + "does not belong to ImsPhoneCallTracker " + this);
        }
        call.onHangupLocal();
        try {
            if (imsCall != null) {
                if (rejectCall) {
                    imsCall.reject(504);
                    this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 3);
                } else {
                    imsCall.terminate(501);
                    this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 4);
                }
            } else if (this.mPendingMO != null && call == this.mForegroundCall) {
                this.mPendingMO.update(null, Call.State.DISCONNECTED);
                this.mPendingMO.onDisconnect();
                this.removeConnection(this.mPendingMO);
                this.mPendingMO = null;
                this.updatePhoneState();
                this.removeMessages(20);
            }
        }
        catch (ImsException e) {
            throw new CallStateException(e.getMessage());
        }
        this.mPhone.notifyPreciseCallStateChanged();
    }

    void callEndCleanupHandOverCallIfAny() {
        if (this.mHandoverCall.mConnections.size() > 0) {
            this.log("callEndCleanupHandOverCallIfAny, mHandoverCall.mConnections=" + this.mHandoverCall.mConnections);
            this.mHandoverCall.mConnections.clear();
            this.mConnections.clear();
            this.mState = PhoneConstants.State.IDLE;
        }
    }

    public void sendUSSD(String ussdString, Message response) {
        this.log("sendUSSD");
        try {
            if (this.mUssdSession != null) {
                this.mPendingUssd = null;
                this.mUssdSession.sendUssd(ussdString);
                AsyncResult.forMessage(response, null, null);
                response.sendToTarget();
                return;
            }
            if (this.mImsManager == null) {
                this.mPhone.sendErrorResponse(response, this.getImsManagerIsNullException());
                return;
            }
            String[] callees = new String[]{ussdString};
            ImsCallProfile profile = this.mImsManager.createCallProfile(1, 2);
            profile.setCallExtraInt("dialstring", 2);
            this.mUssdSession = this.mImsManager.makeCall(profile, callees, this.mImsUssdListener);
            this.mPendingUssd = response;
            this.log("pending ussd updated, " + this.mPendingUssd);
        }
        catch (ImsException e) {
            this.loge("sendUSSD : " + e);
            this.mPhone.sendErrorResponse(response, e);
            this.retryGetImsService();
        }
    }

    public void cancelUSSD(Message msg) {
        if (this.mUssdSession == null) {
            return;
        }
        this.mPendingUssd = msg;
        this.mUssdSession.terminate(501);
    }

    private synchronized ImsPhoneConnection findConnection(ImsCall imsCall) {
        for (ImsPhoneConnection conn : this.mConnections) {
            if (conn.getImsCall() != imsCall) continue;
            return conn;
        }
        return null;
    }

    @UnsupportedAppUsage
    private synchronized void removeConnection(ImsPhoneConnection conn) {
        this.mConnections.remove(conn);
        if (this.mIsInEmergencyCall) {
            boolean isEmergencyCallInList = false;
            for (ImsPhoneConnection imsPhoneConnection : this.mConnections) {
                if (imsPhoneConnection == null || !imsPhoneConnection.isEmergency()) continue;
                isEmergencyCallInList = true;
                break;
            }
            if (!isEmergencyCallInList) {
                this.mIsInEmergencyCall = false;
                this.mPhone.sendEmergencyCallStateChange(false);
            }
        }
    }

    @UnsupportedAppUsage
    private synchronized void addConnection(ImsPhoneConnection conn) {
        this.mConnections.add(conn);
        if (conn.isEmergency()) {
            this.mIsInEmergencyCall = true;
            this.mPhone.sendEmergencyCallStateChange(true);
        }
    }

    private void processCallStateChange(ImsCall imsCall, Call.State state, int cause) {
        this.log("processCallStateChange " + imsCall + " state=" + (Object)((Object)state) + " cause=" + cause);
        this.processCallStateChange(imsCall, state, cause, false);
    }

    private void processCallStateChange(ImsCall imsCall, Call.State state, int cause, boolean ignoreState) {
        this.log("processCallStateChange state=" + (Object)((Object)state) + " cause=" + cause + " ignoreState=" + ignoreState);
        if (imsCall == null) {
            return;
        }
        boolean changed = false;
        ImsPhoneConnection conn = this.findConnection(imsCall);
        if (conn == null) {
            return;
        }
        conn.updateMediaCapabilities(imsCall);
        if (ignoreState) {
            conn.updateAddressDisplay(imsCall);
            conn.updateExtras(imsCall);
            this.maybeSetVideoCallProvider(conn, imsCall);
            return;
        }
        changed = conn.update(imsCall, state);
        if (state == Call.State.DISCONNECTED) {
            changed = conn.onDisconnect(cause) || changed;
            conn.getCall().detach(conn);
            this.removeConnection(conn);
        }
        if (changed) {
            if (conn.getCall() == this.mHandoverCall) {
                return;
            }
            this.updatePhoneState();
            this.mPhone.notifyPreciseCallStateChanged();
        }
    }

    private void maybeSetVideoCallProvider(ImsPhoneConnection conn, ImsCall imsCall) {
        Connection.VideoProvider connVideoProvider = conn.getVideoProvider();
        if (connVideoProvider != null || imsCall.getCallSession().getVideoCallProvider() == null) {
            return;
        }
        try {
            this.setVideoCallProvider(conn, imsCall);
        }
        catch (RemoteException e) {
            this.loge("maybeSetVideoCallProvider: exception " + e);
        }
    }

    @VisibleForTesting
    public void addReasonCodeRemapping(Integer fromCode, String message, Integer toCode) {
        this.mImsReasonCodeMap.put(new Pair<Integer, String>(fromCode, message), toCode);
    }

    @VisibleForTesting
    public int maybeRemapReasonCode(ImsReasonInfo reasonInfo) {
        int code = reasonInfo.getCode();
        String reason = reasonInfo.getExtraMessage();
        if (reason == null) {
            reason = "";
        }
        this.log("maybeRemapReasonCode : fromCode = " + reasonInfo.getCode() + " ; message = " + reason);
        Pair<Integer, String> toCheck = new Pair<Integer, String>(code, reason);
        Pair<Object, String> wildcardToCheck = new Pair<Object, String>(null, reason);
        if (this.mImsReasonCodeMap.containsKey(toCheck)) {
            int toCode = this.mImsReasonCodeMap.get(toCheck);
            this.log("maybeRemapReasonCode : fromCode = " + reasonInfo.getCode() + " ; message = " + reason + " ; toCode = " + toCode);
            return toCode;
        }
        if (!reason.isEmpty() && this.mImsReasonCodeMap.containsKey(wildcardToCheck)) {
            int toCode = this.mImsReasonCodeMap.get(wildcardToCheck);
            this.log("maybeRemapReasonCode : fromCode(wildcard) = " + reasonInfo.getCode() + " ; message = " + reason + " ; toCode = " + toCode);
            return toCode;
        }
        return code;
    }

    @VisibleForTesting
    public int getDisconnectCauseFromReasonInfo(ImsReasonInfo reasonInfo, Call.State callState) {
        int cause = 36;
        int code = this.maybeRemapReasonCode(reasonInfo);
        switch (code) {
            case 1514: {
                return 71;
            }
            case 337: 
            case 341: {
                return 8;
            }
            case 338: {
                return 4;
            }
            case 501: {
                return 3;
            }
            case 108: {
                return 45;
            }
            case 143: 
            case 1404: {
                return 16;
            }
            case 361: 
            case 510: {
                return 2;
            }
            case 332: {
                return 12;
            }
            case 321: 
            case 331: 
            case 340: 
            case 362: {
                return 12;
            }
            case 352: 
            case 354: {
                return 9;
            }
            case 333: {
                return 7;
            }
            case 106: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 131: 
            case 132: 
            case 144: {
                return 18;
            }
            case 201: 
            case 202: 
            case 203: 
            case 335: {
                return 13;
            }
            case 111: {
                return 17;
            }
            case 112: 
            case 505: {
                if (callState == Call.State.DIALING) {
                    return 62;
                }
                return 61;
            }
            case 240: {
                return 20;
            }
            case 241: {
                return 21;
            }
            case 243: {
                return 58;
            }
            case 1014: {
                return 52;
            }
            case 1016: {
                return 51;
            }
            case 1403: {
                return 53;
            }
            case 1406: {
                return 54;
            }
            case 1405: {
                return 55;
            }
            case 1407: {
                return 59;
            }
            case 1512: {
                return 60;
            }
            case 363: {
                return 63;
            }
            case 364: {
                return 64;
            }
            case 244: {
                return 46;
            }
            case 245: {
                return 47;
            }
            case 246: {
                return 48;
            }
            case 247: {
                return 66;
            }
            case 248: {
                return 69;
            }
            case 249: {
                return 70;
            }
            case 250: {
                return 67;
            }
            case 251: {
                return 68;
            }
            case 1515: {
                return 25;
            }
            case 0: {
                if (this.mPhone.getDefaultPhone().getServiceStateTracker().mRestrictedState.isCsRestricted()) {
                    return 22;
                }
                if (this.mPhone.getDefaultPhone().getServiceStateTracker().mRestrictedState.isCsEmergencyRestricted()) {
                    return 24;
                }
                if (!this.mPhone.getDefaultPhone().getServiceStateTracker().mRestrictedState.isCsNormalRestricted()) break;
                return 23;
            }
        }
        return cause;
    }

    private boolean isPhoneInEcbMode() {
        return this.mPhone != null && this.mPhone.isInEcm();
    }

    @UnsupportedAppUsage
    private void dialPendingMO() {
        boolean isPhoneInEcmMode = this.isPhoneInEcbMode();
        boolean isEmergencyNumber = this.mPendingMO.isEmergency();
        if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyNumber) {
            this.sendEmptyMessage(20);
        } else {
            this.sendEmptyMessage(21);
        }
    }

    public void sendCallStartFailedDisconnect(ImsCall imsCall, ImsReasonInfo reasonInfo) {
        this.mPendingMO = null;
        ImsPhoneConnection conn = this.findConnection(imsCall);
        Call.State callState = conn != null ? conn.getState() : Call.State.DIALING;
        int cause = this.getDisconnectCauseFromReasonInfo(reasonInfo, callState);
        this.processCallStateChange(imsCall, Call.State.DISCONNECTED, cause);
        this.mPhone.notifyImsReason(reasonInfo);
    }

    @UnsupportedAppUsage
    public ImsUtInterface getUtInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw this.getImsManagerIsNullException();
        }
        ImsUtInterface ut = this.mImsManager.getSupplementaryServiceConfiguration();
        return ut;
    }

    private void transferHandoverConnections(ImsPhoneCall call) {
        if (call.mConnections != null) {
            for (Connection c : call.mConnections) {
                c.mPreHandoverState = call.mState;
                this.log("Connection state before handover is " + (Object)((Object)c.getStateBeforeHandover()));
            }
        }
        if (this.mHandoverCall.mConnections == null) {
            this.mHandoverCall.mConnections = call.mConnections;
        } else {
            this.mHandoverCall.mConnections.addAll(call.mConnections);
        }
        if (this.mHandoverCall.mConnections != null) {
            if (call.getImsCall() != null) {
                call.getImsCall().close();
            }
            for (Connection c : this.mHandoverCall.mConnections) {
                ((ImsPhoneConnection)c).changeParent(this.mHandoverCall);
                ((ImsPhoneConnection)c).releaseWakeLock();
            }
        }
        if (call.getState().isAlive()) {
            this.log("Call is alive and state is " + (Object)((Object)call.mState));
            this.mHandoverCall.mState = call.mState;
        }
        call.mConnections.clear();
        call.mState = Call.State.IDLE;
        if (this.mPendingMO != null) {
            this.logi("pending MO on handover, clearing...");
            this.mPendingMO = null;
        }
    }

    void notifySrvccState(Call.SrvccState state) {
        this.log("notifySrvccState state=" + (Object)((Object)state));
        this.mSrvccState = state;
        if (this.mSrvccState == Call.SrvccState.COMPLETED) {
            this.resetState();
            this.transferHandoverConnections(this.mForegroundCall);
            this.transferHandoverConnections(this.mBackgroundCall);
            this.transferHandoverConnections(this.mRingingCall);
        }
    }

    private void resetState() {
        this.mIsInEmergencyCall = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        this.log("handleMessage what=" + msg.what);
        switch (msg.what) {
            case 18: {
                if (this.mPendingMO != null) {
                    this.mPendingMO.onDisconnect();
                    this.removeConnection(this.mPendingMO);
                    this.mPendingMO = null;
                }
                this.mPendingIntentExtras = null;
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                break;
            }
            case 31: {
                try {
                    this.resumeForegroundCall();
                }
                catch (ImsException e) {
                    this.loge("handleMessage EVENT_RESUME_NOW_FOREGROUND_CALL exception=" + e);
                }
                break;
            }
            case 30: {
                try {
                    this.answerWaitingCall();
                }
                catch (ImsException e) {
                    this.loge("handleMessage EVENT_ANSWER_WAITING_CALL exception=" + e);
                }
                break;
            }
            case 20: {
                this.dialInternal(this.mPendingMO, this.mClirMode, this.mPendingCallVideoState, this.mPendingIntentExtras);
                this.mPendingIntentExtras = null;
                break;
            }
            case 21: {
                if (this.mPendingMO == null) break;
                try {
                    this.getEcbmInterface().exitEmergencyCallbackMode();
                    this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                    this.pendingCallClirMode = this.mClirMode;
                    this.pendingCallInEcm = true;
                }
                catch (ImsException e) {
                    e.printStackTrace();
                    this.mPendingMO.setDisconnectCause(36);
                    this.sendEmptyMessageDelayed(18, 500L);
                }
                break;
            }
            case 14: {
                if (this.pendingCallInEcm) {
                    this.dialInternal(this.mPendingMO, this.pendingCallClirMode, this.mPendingCallVideoState, this.mPendingIntentExtras);
                    this.mPendingIntentExtras = null;
                    this.pendingCallInEcm = false;
                }
                this.mPhone.unsetOnEcbModeExitResponse(this);
                break;
            }
            case 22: {
                AsyncResult ar = (AsyncResult)msg.obj;
                ImsCall call = (ImsCall)ar.userObj;
                Long usage = (long)((Long)ar.result);
                this.log("VT data usage update. usage = " + usage + ", imsCall = " + call);
                if (usage <= 0L) break;
                this.updateVtDataUsage(call, usage);
                break;
            }
            case 23: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (!(ar.result instanceof Pair)) break;
                Pair p = (Pair)ar.result;
                this.onDataEnabledChanged((Boolean)p.first, (Integer)p.second);
                break;
            }
            case 25: {
                if (!(msg.obj instanceof ImsCall)) break;
                ImsCall imsCall = (ImsCall)msg.obj;
                if (imsCall != this.mForegroundCall.getImsCall()) {
                    Rlog.i(LOG_TAG, "handoverCheck: no longer FG; check skipped.");
                    this.unregisterForConnectivityChanges();
                    return;
                }
                if (!this.mHasAttemptedStartOfCallHandover) {
                    this.mHasAttemptedStartOfCallHandover = true;
                }
                if (imsCall.isWifiCall()) break;
                ImsPhoneConnection conn = this.findConnection(imsCall);
                if (conn != null) {
                    Rlog.i(LOG_TAG, "handoverCheck: handover failed.");
                    conn.onHandoverToWifiFailed();
                }
                if (!imsCall.isVideoCall() || conn.getDisconnectCause() != 0) break;
                this.registerForConnectivityChanges();
                break;
            }
            case 26: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ImsFeature.Capabilities capabilities = (ImsFeature.Capabilities)args.arg1;
                    this.handleFeatureCapabilityChanged(capabilities);
                    break;
                }
                finally {
                    args.recycle();
                }
            }
            case 27: {
                AsyncResult ar = (AsyncResult)msg.obj;
                ImsPhoneMmiCode mmiCode = new ImsPhoneMmiCode(this.mPhone);
                try {
                    mmiCode.setIsSsInfo(true);
                    mmiCode.processImsSsData(ar);
                }
                catch (ImsException e) {
                    Rlog.e(LOG_TAG, "Exception in parsing SS Data: " + e);
                }
                break;
            }
            case 28: {
                Pair callInfo = (Pair)((AsyncResult)msg.obj).userObj;
                this.removeMessages(29);
                this.mPhone.getDefaultPhone().getServiceStateTracker().unregisterForNetworkAttached(this);
                ImsPhoneConnection oldConnection = this.findConnection((ImsCall)callInfo.first);
                if (oldConnection == null) {
                    this.sendCallStartFailedDisconnect((ImsCall)callInfo.first, (ImsReasonInfo)callInfo.second);
                    break;
                }
                this.mForegroundCall.detach(oldConnection);
                this.removeConnection(oldConnection);
                try {
                    Connection newConnection = this.mPhone.getDefaultPhone().dial(this.mLastDialString, this.mLastDialArgs);
                    oldConnection.onOriginalConnectionReplaced(newConnection);
                }
                catch (CallStateException e) {
                    this.sendCallStartFailedDisconnect((ImsCall)callInfo.first, (ImsReasonInfo)callInfo.second);
                }
                break;
            }
            case 29: {
                Pair callInfo = (Pair)msg.obj;
                this.mPhone.getDefaultPhone().getServiceStateTracker().unregisterForNetworkAttached(this);
                this.removeMessages(28);
                this.sendCallStartFailedDisconnect((ImsCall)callInfo.first, (ImsReasonInfo)callInfo.second);
                break;
            }
        }
    }

    private void updateVtDataUsage(ImsCall call, long dataUsage) {
        long oldUsage = 0L;
        if (this.mVtDataUsageMap.containsKey(call.uniqueId)) {
            oldUsage = this.mVtDataUsageMap.get(call.uniqueId);
        }
        long delta = dataUsage - oldUsage;
        this.mVtDataUsageMap.put(call.uniqueId, dataUsage);
        this.log("updateVtDataUsage: call=" + call + ", delta=" + delta);
        long currentTime = SystemClock.elapsedRealtime();
        int isRoaming = this.mPhone.getServiceState().getDataRoaming() ? 1 : 0;
        NetworkStats vtDataUsageSnapshot = new NetworkStats(currentTime, 1);
        vtDataUsageSnapshot.combineAllValues(this.mVtDataUsageSnapshot);
        vtDataUsageSnapshot.combineValues(new NetworkStats.Entry("vt_data0", -1, 1, 0, 1, isRoaming, 1, delta / 2L, 0L, delta / 2L, 0L, 0L));
        this.mVtDataUsageSnapshot = vtDataUsageSnapshot;
        NetworkStats vtDataUsageUidSnapshot = new NetworkStats(currentTime, 1);
        vtDataUsageUidSnapshot.combineAllValues(this.mVtDataUsageUidSnapshot);
        if (this.mDefaultDialerUid.get() == -1) {
            TelecomManager telecomManager = (TelecomManager)this.mPhone.getContext().getSystemService("telecom");
            this.mDefaultDialerUid.set(this.getPackageUid(this.mPhone.getContext(), telecomManager.getDefaultDialerPackage()));
        }
        vtDataUsageUidSnapshot.combineValues(new NetworkStats.Entry("vt_data0", this.mDefaultDialerUid.get(), 1, 0, 1, isRoaming, 1, delta / 2L, 0L, delta / 2L, 0L, 0L));
        this.mVtDataUsageUidSnapshot = vtDataUsageUidSnapshot;
    }

    @Override
    @UnsupportedAppUsage
    protected void log(String msg) {
        Rlog.d(LOG_TAG, "[" + this.mPhone.getPhoneId() + "] " + msg);
    }

    @UnsupportedAppUsage
    protected void loge(String msg) {
        Rlog.e(LOG_TAG, "[" + this.mPhone.getPhoneId() + "] " + msg);
    }

    void logi(String msg) {
        Rlog.i(LOG_TAG, "[" + this.mPhone.getPhoneId() + "] " + msg);
    }

    void logHoldSwapState(String loc) {
        String holdSwapState = "???";
        switch (this.mHoldSwitchingState) {
            case INACTIVE: {
                holdSwapState = "INACTIVE";
                break;
            }
            case PENDING_SINGLE_CALL_HOLD: {
                holdSwapState = "PENDING_SINGLE_CALL_HOLD";
                break;
            }
            case PENDING_SINGLE_CALL_UNHOLD: {
                holdSwapState = "PENDING_SINGLE_CALL_UNHOLD";
                break;
            }
            case SWAPPING_ACTIVE_AND_HELD: {
                holdSwapState = "SWAPPING_ACTIVE_AND_HELD";
                break;
            }
            case HOLDING_TO_ANSWER_INCOMING: {
                holdSwapState = "HOLDING_TO_ANSWER_INCOMING";
                break;
            }
            case PENDING_RESUME_FOREGROUND_AFTER_FAILURE: {
                holdSwapState = "PENDING_RESUME_FOREGROUND_AFTER_FAILURE";
                break;
            }
            case HOLDING_TO_DIAL_OUTGOING: {
                holdSwapState = "HOLDING_TO_DIAL_OUTGOING";
            }
        }
        this.logi("holdSwapState set to " + holdSwapState + " at " + loc);
    }

    void logState() {
        if (!VERBOSE_STATE_LOGGING) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Current IMS PhoneCall State:\n");
        sb.append(" Foreground: ");
        sb.append(this.mForegroundCall);
        sb.append("\n");
        sb.append(" Background: ");
        sb.append(this.mBackgroundCall);
        sb.append("\n");
        sb.append(" Ringing: ");
        sb.append(this.mRingingCall);
        sb.append("\n");
        sb.append(" Handover: ");
        sb.append(this.mHandoverCall);
        sb.append("\n");
        Rlog.v(LOG_TAG, sb.toString());
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ImsPhoneCallTracker extends:");
        super.dump(fd, pw, args);
        pw.println(" mVoiceCallEndedRegistrants=" + this.mVoiceCallEndedRegistrants);
        pw.println(" mVoiceCallStartedRegistrants=" + this.mVoiceCallStartedRegistrants);
        pw.println(" mRingingCall=" + this.mRingingCall);
        pw.println(" mForegroundCall=" + this.mForegroundCall);
        pw.println(" mBackgroundCall=" + this.mBackgroundCall);
        pw.println(" mHandoverCall=" + this.mHandoverCall);
        pw.println(" mPendingMO=" + this.mPendingMO);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mDesiredMute=" + this.mDesiredMute);
        pw.println(" mState=" + (Object)((Object)this.mState));
        pw.println(" mMmTelCapabilities=" + this.mMmTelCapabilities);
        pw.println(" mDefaultDialerUid=" + this.mDefaultDialerUid.get());
        pw.println(" mVtDataUsageSnapshot=" + this.mVtDataUsageSnapshot);
        pw.println(" mVtDataUsageUidSnapshot=" + this.mVtDataUsageUidSnapshot);
        pw.println(" mCallQualityMetrics=" + this.mCallQualityMetrics);
        pw.println(" mCallQualityMetricsHistory=" + this.mCallQualityMetricsHistory);
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            if (this.mImsManager != null) {
                this.mImsManager.dump(fd, pw, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mConnections != null && this.mConnections.size() > 0) {
            pw.println("mConnections:");
            for (int i = 0; i < this.mConnections.size(); ++i) {
                pw.println("  [" + i + "]: " + this.mConnections.get(i));
            }
        }
    }

    @Override
    protected void handlePollCalls(AsyncResult ar) {
    }

    ImsEcbm getEcbmInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw this.getImsManagerIsNullException();
        }
        ImsEcbm ecbm = this.mImsManager.getEcbmInterface();
        return ecbm;
    }

    ImsMultiEndpoint getMultiEndpointInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw this.getImsManagerIsNullException();
        }
        try {
            return this.mImsManager.getMultiEndpointInterface();
        }
        catch (ImsException e) {
            if (e.getCode() == 902) {
                return null;
            }
            throw e;
        }
    }

    public boolean isInEmergencyCall() {
        return this.mIsInEmergencyCall;
    }

    public boolean isImsCapabilityAvailable(int capability, int regTech) {
        return this.getImsRegistrationTech() == regTech && this.mMmTelCapabilities.isCapable(capability);
    }

    public boolean isVolteEnabled() {
        boolean isRadioTechLte = this.getImsRegistrationTech() == 0;
        return isRadioTechLte && this.mMmTelCapabilities.isCapable(1);
    }

    public boolean isVowifiEnabled() {
        boolean isRadioTechIwlan = this.getImsRegistrationTech() == 1;
        return isRadioTechIwlan && this.mMmTelCapabilities.isCapable(1);
    }

    public boolean isVideoCallEnabled() {
        return this.mMmTelCapabilities.isCapable(2);
    }

    @Override
    public PhoneConstants.State getState() {
        return this.mState;
    }

    public int getImsRegistrationTech() {
        if (this.mImsManager != null) {
            return this.mImsManager.getRegistrationTech();
        }
        return -1;
    }

    private void retryGetImsService() {
        if (this.mImsManager.isServiceAvailable()) {
            return;
        }
        this.mImsManagerConnector.connect();
    }

    private void setVideoCallProvider(ImsPhoneConnection conn, ImsCall imsCall) throws RemoteException {
        IImsVideoCallProvider imsVideoCallProvider = imsCall.getCallSession().getVideoCallProvider();
        if (imsVideoCallProvider != null) {
            boolean useVideoPauseWorkaround = this.mPhone.getContext().getResources().getBoolean(17891562);
            ImsVideoCallProviderWrapper imsVideoCallProviderWrapper = new ImsVideoCallProviderWrapper(imsVideoCallProvider);
            if (useVideoPauseWorkaround) {
                imsVideoCallProviderWrapper.setUseVideoPauseWorkaround(useVideoPauseWorkaround);
            }
            conn.setVideoProvider(imsVideoCallProviderWrapper);
            imsVideoCallProviderWrapper.registerForDataUsageUpdate(this, 22, imsCall);
            imsVideoCallProviderWrapper.addImsVideoProviderCallback(conn);
        }
    }

    public boolean isUtEnabled() {
        return this.mMmTelCapabilities.isCapable(4);
    }

    private String cleanseInstantLetteringMessage(String callSubject) {
        String escapedCharacters;
        if (TextUtils.isEmpty(callSubject)) {
            return callSubject;
        }
        CarrierConfigManager configMgr = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        if (configMgr == null) {
            return callSubject;
        }
        PersistableBundle carrierConfig = configMgr.getConfigForSubId(this.mPhone.getSubId());
        if (carrierConfig == null) {
            return callSubject;
        }
        String invalidCharacters = carrierConfig.getString("carrier_instant_lettering_invalid_chars_string");
        if (!TextUtils.isEmpty(invalidCharacters)) {
            callSubject = callSubject.replaceAll(invalidCharacters, "");
        }
        if (!TextUtils.isEmpty(escapedCharacters = carrierConfig.getString("carrier_instant_lettering_escaped_chars_string"))) {
            callSubject = this.escapeChars(escapedCharacters, callSubject);
        }
        return callSubject;
    }

    private String escapeChars(String toEscape, String source) {
        StringBuilder escaped = new StringBuilder();
        for (char c : source.toCharArray()) {
            if (toEscape.contains(Character.toString(c))) {
                escaped.append("\\");
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    @Override
    public void pullExternalCall(String number, int videoState, int dialogId) {
        Bundle extras = new Bundle();
        extras.putBoolean("CallPull", true);
        extras.putInt("android.telephony.ImsExternalCallTracker.extra.EXTERNAL_CALL_ID", dialogId);
        try {
            Connection connection = this.dial(number, videoState, extras);
            this.mPhone.notifyUnknownConnection(connection);
        }
        catch (CallStateException e) {
            this.loge("pullExternalCall failed - " + e);
        }
    }

    private ImsException getImsManagerIsNullException() {
        return new ImsException("no ims manager", 102);
    }

    private boolean shouldDisconnectActiveCallOnAnswer(ImsCall activeCall, ImsCall incomingCall) {
        if (activeCall == null || incomingCall == null) {
            return false;
        }
        if (!this.mDropVideoCallWhenAnsweringAudioCall) {
            return false;
        }
        boolean isActiveCallVideo = activeCall.isVideoCall() || this.mTreatDowngradedVideoCallsAsVideoCalls && activeCall.wasVideoCall();
        boolean isActiveCallOnWifi = activeCall.isWifiCall();
        boolean isVoWifiEnabled = this.mImsManager.isWfcEnabledByPlatform() && this.mImsManager.isWfcEnabledByUser();
        boolean isIncomingCallAudio = !incomingCall.isVideoCall();
        this.log("shouldDisconnectActiveCallOnAnswer : isActiveCallVideo=" + isActiveCallVideo + " isActiveCallOnWifi=" + isActiveCallOnWifi + " isIncomingCallAudio=" + isIncomingCallAudio + " isVowifiEnabled=" + isVoWifiEnabled);
        return isActiveCallVideo && isActiveCallOnWifi && isIncomingCallAudio && !isVoWifiEnabled;
    }

    public NetworkStats getVtDataUsage(boolean perUidStats) {
        if (this.mState != PhoneConstants.State.IDLE) {
            for (ImsPhoneConnection conn : this.mConnections) {
                Connection.VideoProvider videoProvider = conn.getVideoProvider();
                if (videoProvider == null) continue;
                videoProvider.onRequestConnectionDataUsage();
            }
        }
        return perUidStats ? this.mVtDataUsageUidSnapshot : this.mVtDataUsageSnapshot;
    }

    public void registerPhoneStateListener(PhoneStateListener listener) {
        this.mPhoneStateListeners.add(listener);
    }

    public void unregisterPhoneStateListener(PhoneStateListener listener) {
        this.mPhoneStateListeners.remove(listener);
    }

    private void notifyPhoneStateChanged(PhoneConstants.State oldState, PhoneConstants.State newState) {
        for (PhoneStateListener listener : this.mPhoneStateListeners) {
            listener.onPhoneStateChanged(oldState, newState);
        }
    }

    private void modifyVideoCall(ImsCall imsCall, int newVideoState) {
        ImsPhoneConnection conn = this.findConnection(imsCall);
        if (conn != null) {
            int oldVideoState = conn.getVideoState();
            if (conn.getVideoProvider() != null) {
                conn.getVideoProvider().onSendSessionModifyRequest(new VideoProfile(oldVideoState), new VideoProfile(newVideoState));
            }
        }
    }

    public boolean isViLteDataMetered() {
        return this.mIsViLteDataMetered;
    }

    private void onDataEnabledChanged(boolean enabled, int reason) {
        this.log("onDataEnabledChanged: enabled=" + enabled + ", reason=" + reason);
        this.mIsDataEnabled = enabled;
        if (!this.mIsViLteDataMetered) {
            this.log("Ignore data " + (enabled ? "enabled" : "disabled") + " - carrier policy indicates that data is not metered for ViLTE calls.");
            return;
        }
        for (ImsPhoneConnection conn : this.mConnections) {
            ImsCall imsCall = conn.getImsCall();
            boolean isLocalVideoCapable = enabled || imsCall != null && imsCall.isWifiCall();
            conn.setLocalVideoCapable(isLocalVideoCapable);
        }
        int reasonCode = reason == 3 ? 1405 : (reason == 2 ? 1406 : 1406);
        this.maybeNotifyDataDisabled(enabled, reasonCode);
        this.handleDataEnabledChange(enabled, reasonCode);
        if (!this.mShouldUpdateImsConfigOnDisconnect && reason != 0 && this.mCarrierConfigLoaded && this.mImsManager != null) {
            this.mImsManager.updateImsServiceConfig(true);
        }
    }

    private void maybeNotifyDataDisabled(boolean enabled, int reasonCode) {
        if (!enabled) {
            for (ImsPhoneConnection conn : this.mConnections) {
                ImsCall imsCall = conn.getImsCall();
                if (imsCall == null || !imsCall.isVideoCall() || imsCall.isWifiCall() || !conn.hasCapabilities(3)) continue;
                if (reasonCode == 1406) {
                    conn.onConnectionEvent("android.telephony.event.EVENT_DOWNGRADE_DATA_DISABLED", null);
                    continue;
                }
                if (reasonCode != 1405) continue;
                conn.onConnectionEvent("android.telephony.event.EVENT_DOWNGRADE_DATA_LIMIT_REACHED", null);
            }
        }
    }

    private void handleDataEnabledChange(boolean enabled, int reasonCode) {
        if (!enabled) {
            for (ImsPhoneConnection conn : this.mConnections) {
                ImsCall imsCall = conn.getImsCall();
                if (imsCall == null || !imsCall.isVideoCall() || imsCall.isWifiCall()) continue;
                this.log("handleDataEnabledChange - downgrading " + conn);
                this.downgradeVideoCall(reasonCode, conn);
            }
        } else if (this.mSupportPauseVideo) {
            for (ImsPhoneConnection conn : this.mConnections) {
                this.log("handleDataEnabledChange - resuming " + conn);
                if (!VideoProfile.isPaused(conn.getVideoState()) || !conn.wasVideoPausedFromSource(2)) continue;
                conn.resumeVideo(2);
            }
            this.mShouldUpdateImsConfigOnDisconnect = false;
        }
    }

    private void downgradeVideoCall(int reasonCode, ImsPhoneConnection conn) {
        ImsCall imsCall = conn.getImsCall();
        if (imsCall != null) {
            if (conn.hasCapabilities(3) && !this.mSupportPauseVideo) {
                this.log("downgradeVideoCall :: callId=" + conn.getTelecomCallId() + " Downgrade to audio");
                this.modifyVideoCall(imsCall, 0);
            } else if (this.mSupportPauseVideo && reasonCode != 1407) {
                this.log("downgradeVideoCall :: callId=" + conn.getTelecomCallId() + " Pause audio");
                this.mShouldUpdateImsConfigOnDisconnect = true;
                conn.pauseVideo(2);
            } else {
                this.log("downgradeVideoCall :: callId=" + conn.getTelecomCallId() + " Disconnect call.");
                imsCall.terminate(501, reasonCode);
            }
        }
    }

    private void resetImsCapabilities() {
        this.log("Resetting Capabilities...");
        boolean tmpIsVideoCallEnabled = this.isVideoCallEnabled();
        this.mMmTelCapabilities = new MmTelFeature.MmTelCapabilities();
        boolean isVideoEnabled = this.isVideoCallEnabled();
        if (tmpIsVideoCallEnabled != isVideoEnabled) {
            this.mPhone.notifyForVideoCapabilityChanged(isVideoEnabled);
        }
    }

    private boolean isWifiConnected() {
        NetworkInfo ni;
        ConnectivityManager cm = (ConnectivityManager)this.mPhone.getContext().getSystemService("connectivity");
        if (cm != null && (ni = cm.getActiveNetworkInfo()) != null && ni.isConnected()) {
            return ni.getType() == 1;
        }
        return false;
    }

    private void registerForConnectivityChanges() {
        if (this.mIsMonitoringConnectivity || !this.mNotifyVtHandoverToWifiFail) {
            return;
        }
        ConnectivityManager cm = (ConnectivityManager)this.mPhone.getContext().getSystemService("connectivity");
        if (cm != null) {
            Rlog.i(LOG_TAG, "registerForConnectivityChanges");
            NetworkCapabilities capabilities = new NetworkCapabilities();
            capabilities.addTransportType(1);
            NetworkRequest.Builder builder = new NetworkRequest.Builder();
            builder.setCapabilities(capabilities);
            cm.registerNetworkCallback(builder.build(), this.mNetworkCallback);
            this.mIsMonitoringConnectivity = true;
        }
    }

    private void unregisterForConnectivityChanges() {
        if (!this.mIsMonitoringConnectivity || !this.mNotifyVtHandoverToWifiFail) {
            return;
        }
        ConnectivityManager cm = (ConnectivityManager)this.mPhone.getContext().getSystemService("connectivity");
        if (cm != null) {
            Rlog.i(LOG_TAG, "unregisterForConnectivityChanges");
            cm.unregisterNetworkCallback(this.mNetworkCallback);
            this.mIsMonitoringConnectivity = false;
        }
    }

    private void scheduleHandoverCheck() {
        ImsCall fgCall = this.mForegroundCall.getImsCall();
        ImsPhoneConnection conn = this.mForegroundCall.getFirstConnection();
        if (!this.mNotifyVtHandoverToWifiFail || fgCall == null || !fgCall.isVideoCall() || conn == null || conn.getDisconnectCause() != 0) {
            return;
        }
        if (!this.hasMessages(25)) {
            Rlog.i(LOG_TAG, "scheduleHandoverCheck: schedule");
            this.sendMessageDelayed(this.obtainMessage(25, fgCall), 60000L);
        }
    }

    public boolean isCarrierDowngradeOfVtCallSupported() {
        return this.mSupportDowngradeVtToAudio;
    }

    @VisibleForTesting
    public void setDataEnabled(boolean isDataEnabled) {
        this.mIsDataEnabled = isDataEnabled;
    }

    private void pruneCallQualityMetricsHistory() {
        if (this.mCallQualityMetricsHistory.size() > 10) {
            this.mCallQualityMetricsHistory.poll();
        }
    }

    private void handleFeatureCapabilityChanged(ImsFeature.Capabilities capabilities) {
        boolean tmpIsVideoCallEnabled = this.isVideoCallEnabled();
        StringBuilder sb = new StringBuilder(120);
        sb.append("handleFeatureCapabilityChanged: ");
        sb.append(capabilities);
        this.mMmTelCapabilities = new MmTelFeature.MmTelCapabilities(capabilities);
        boolean isVideoEnabled = this.isVideoCallEnabled();
        boolean isVideoEnabledStatechanged = tmpIsVideoCallEnabled != isVideoEnabled;
        sb.append(" isVideoEnabledStateChanged=");
        sb.append(isVideoEnabledStatechanged);
        if (isVideoEnabledStatechanged) {
            this.log("handleFeatureCapabilityChanged - notifyForVideoCapabilityChanged=" + isVideoEnabled);
            this.mPhone.notifyForVideoCapabilityChanged(isVideoEnabled);
        }
        this.log(sb.toString());
        this.log("handleFeatureCapabilityChanged: isVolteEnabled=" + this.isVolteEnabled() + ", isVideoCallEnabled=" + this.isVideoCallEnabled() + ", isVowifiEnabled=" + this.isVowifiEnabled() + ", isUtEnabled=" + this.isUtEnabled());
        this.mPhone.onFeatureCapabilityChanged();
        this.mMetrics.writeOnImsCapabilities(this.mPhone.getPhoneId(), this.getImsRegistrationTech(), this.mMmTelCapabilities);
    }

    @VisibleForTesting
    public void onCallHoldReceived(ImsCall imsCall) {
        this.log("onCallHoldReceived");
        ImsPhoneConnection conn = this.findConnection(imsCall);
        if (conn != null) {
            if (!this.mOnHoldToneStarted && (ImsPhoneCall.isLocalTone(imsCall) || this.mAlwaysPlayRemoteHoldTone) && conn.getState() == Call.State.ACTIVE) {
                this.mPhone.startOnHoldTone(conn);
                this.mOnHoldToneStarted = true;
                this.mOnHoldToneId = System.identityHashCode(conn);
            }
            conn.onConnectionEvent("android.telecom.event.CALL_REMOTELY_HELD", null);
            boolean useVideoPauseWorkaround = this.mPhone.getContext().getResources().getBoolean(17891562);
            if (useVideoPauseWorkaround && this.mSupportPauseVideo && VideoProfile.isVideo(conn.getVideoState())) {
                conn.changeToPausedState();
            }
        }
        SuppServiceNotification supp = new SuppServiceNotification();
        supp.notificationType = 1;
        supp.code = 2;
        this.mPhone.notifySuppSvcNotification(supp);
        this.mMetrics.writeOnImsCallHoldReceived(this.mPhone.getPhoneId(), imsCall.getCallSession());
    }

    @VisibleForTesting
    public void setAlwaysPlayRemoteHoldTone(boolean shouldPlayRemoteHoldTone) {
        this.mAlwaysPlayRemoteHoldTone = shouldPlayRemoteHoldTone;
    }

    private String getNetworkCountryIso() {
        LocaleTracker lt;
        ServiceStateTracker sst;
        String countryIso = "";
        if (this.mPhone != null && (sst = this.mPhone.getServiceStateTracker()) != null && (lt = sst.getLocaleTracker()) != null) {
            countryIso = lt.getCurrentCountry();
        }
        return countryIso;
    }

    @Override
    public ImsPhone getPhone() {
        return this.mPhone;
    }

    private static class CacheEntry {
        private long mCachedTime;
        private long mConnectTime;
        private long mConnectElapsedTime;
        private int mCallDirection;

        CacheEntry(long cachedTime, long connectTime, long connectElapsedTime, int callDirection) {
            this.mCachedTime = cachedTime;
            this.mConnectTime = connectTime;
            this.mConnectElapsedTime = connectElapsedTime;
            this.mCallDirection = callDirection;
        }
    }

    private static enum HoldSwapState {
        INACTIVE,
        PENDING_SINGLE_CALL_HOLD,
        PENDING_SINGLE_CALL_UNHOLD,
        SWAPPING_ACTIVE_AND_HELD,
        HOLDING_TO_ANSWER_INCOMING,
        PENDING_RESUME_FOREGROUND_AFTER_FAILURE,
        HOLDING_TO_DIAL_OUTGOING;

    }

    private class MmTelFeatureListener
    extends MmTelFeature.Listener {
        private MmTelFeatureListener() {
        }

        @Override
        public void onIncomingCall(IImsCallSession c, Bundle extras) {
            ImsPhoneCallTracker.this.log("onReceive : incoming call intent");
            if (ImsPhoneCallTracker.this.mImsManager == null) {
                return;
            }
            try {
                ImsCall activeCall;
                boolean isUssd = extras.getBoolean("android:ussd", false);
                if (isUssd) {
                    ImsPhoneCallTracker.this.log("onReceive : USSD");
                    ImsPhoneCallTracker.this.mUssdSession = ImsPhoneCallTracker.this.mImsManager.takeCall(c, extras, ImsPhoneCallTracker.this.mImsUssdListener);
                    if (ImsPhoneCallTracker.this.mUssdSession != null) {
                        ImsPhoneCallTracker.this.mUssdSession.accept(2);
                    }
                    return;
                }
                boolean isUnknown = extras.getBoolean("android:isUnknown", false);
                ImsPhoneCallTracker.this.log("onReceive : isUnknown = " + isUnknown + " fg = " + (Object)((Object)ImsPhoneCallTracker.this.mForegroundCall.getState()) + " bg = " + (Object)((Object)ImsPhoneCallTracker.this.mBackgroundCall.getState()));
                ImsCall imsCall = ImsPhoneCallTracker.this.mImsManager.takeCall(c, extras, ImsPhoneCallTracker.this.mImsCallListener);
                ImsPhoneConnection conn = new ImsPhoneConnection((Phone)ImsPhoneCallTracker.this.mPhone, imsCall, ImsPhoneCallTracker.this, isUnknown ? ImsPhoneCallTracker.this.mForegroundCall : ImsPhoneCallTracker.this.mRingingCall, isUnknown);
                if (ImsPhoneCallTracker.this.mForegroundCall.hasConnections() && (activeCall = ImsPhoneCallTracker.this.mForegroundCall.getFirstConnection().getImsCall()) != null && imsCall != null) {
                    boolean answeringWillDisconnect = ImsPhoneCallTracker.this.shouldDisconnectActiveCallOnAnswer(activeCall, imsCall);
                    conn.setActiveCallDisconnectedOnAnswer(answeringWillDisconnect);
                }
                conn.setAllowAddCallDuringVideoCall(ImsPhoneCallTracker.this.mAllowAddCallDuringVideoCall);
                ImsPhoneCallTracker.this.addConnection(conn);
                ImsPhoneCallTracker.this.setVideoCallProvider(conn, imsCall);
                TelephonyMetrics.getInstance().writeOnImsCallReceive(ImsPhoneCallTracker.this.mPhone.getPhoneId(), imsCall.getSession());
                if (isUnknown) {
                    ImsPhoneCallTracker.this.mPhone.notifyUnknownConnection(conn);
                } else {
                    if (ImsPhoneCallTracker.this.mForegroundCall.getState() != Call.State.IDLE || ImsPhoneCallTracker.this.mBackgroundCall.getState() != Call.State.IDLE) {
                        conn.update(imsCall, Call.State.WAITING);
                    }
                    ImsPhoneCallTracker.this.mPhone.notifyNewRingingConnection(conn);
                    ImsPhoneCallTracker.this.mPhone.notifyIncomingRing();
                }
                ImsPhoneCallTracker.this.updatePhoneState();
                ImsPhoneCallTracker.this.mPhone.notifyPreciseCallStateChanged();
            }
            catch (ImsException e) {
                ImsPhoneCallTracker.this.loge("onReceive : exception " + e);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        public void onVoiceMessageCountUpdate(int count) {
            if (ImsPhoneCallTracker.this.mPhone != null && ImsPhoneCallTracker.this.mPhone.mDefaultPhone != null) {
                ImsPhoneCallTracker.this.log("onVoiceMessageCountChanged :: count=" + count);
                ImsPhoneCallTracker.this.mPhone.mDefaultPhone.setVoiceMessageCount(count);
            } else {
                ImsPhoneCallTracker.this.loge("onVoiceMessageCountUpdate: null phone");
            }
        }
    }

    public static interface PhoneNumberUtilsProxy {
        public boolean isEmergencyNumber(String var1);
    }

    public static interface SharedPreferenceProxy {
        public SharedPreferences getDefaultSharedPreferences(Context var1);
    }

    public static interface PhoneStateListener {
        public void onPhoneStateChanged(PhoneConstants.State var1, PhoneConstants.State var2);
    }
}

