/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.ResultReceiver;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ims.ImsCallForwardInfo;
import android.telephony.ims.ImsSsData;
import android.telephony.ims.ImsSsInfo;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.android.ims.ImsException;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.uicc.IccRecords;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ImsPhoneMmiCode
extends Handler
implements MmiCode {
    static final String LOG_TAG = "ImsPhoneMmiCode";
    private static final int MAX_LENGTH_SHORT_CODE = 2;
    private static final char END_OF_USSD_COMMAND = '#';
    private static final String ACTION_ACTIVATE = "*";
    private static final String ACTION_DEACTIVATE = "#";
    private static final String ACTION_INTERROGATE = "*#";
    private static final String ACTION_REGISTER = "**";
    private static final String ACTION_ERASURE = "##";
    private static final String SC_CLIP = "30";
    private static final String SC_CLIR = "31";
    private static final String SC_COLP = "76";
    private static final String SC_COLR = "77";
    private static final String SC_CNAP = "300";
    private static final String SC_CFU = "21";
    private static final String SC_CFB = "67";
    private static final String SC_CFNRy = "61";
    private static final String SC_CFNR = "62";
    private static final String SC_CFUT = "22";
    private static final String SC_CF_All = "002";
    private static final String SC_CF_All_Conditional = "004";
    private static final String SC_WAIT = "43";
    private static final String SC_BAOC = "33";
    private static final String SC_BAOIC = "331";
    private static final String SC_BAOICxH = "332";
    private static final String SC_BAIC = "35";
    private static final String SC_BAICr = "351";
    private static final String SC_BA_ALL = "330";
    private static final String SC_BA_MO = "333";
    private static final String SC_BA_MT = "353";
    private static final String SC_BS_MT = "156";
    private static final String SC_BAICa = "157";
    private static final String SC_PWD = "03";
    private static final String SC_PIN = "04";
    private static final String SC_PIN2 = "042";
    private static final String SC_PUK = "05";
    private static final String SC_PUK2 = "052";
    private static final int EVENT_SET_COMPLETE = 0;
    private static final int EVENT_QUERY_CF_COMPLETE = 1;
    private static final int EVENT_USSD_COMPLETE = 2;
    private static final int EVENT_QUERY_COMPLETE = 3;
    private static final int EVENT_SET_CFF_COMPLETE = 4;
    private static final int EVENT_USSD_CANCEL_COMPLETE = 5;
    private static final int EVENT_GET_CLIR_COMPLETE = 6;
    private static final int EVENT_SUPP_SVC_QUERY_COMPLETE = 7;
    private static final int EVENT_QUERY_ICB_COMPLETE = 10;
    private static final int NUM_PRESENTATION_ALLOWED = 0;
    private static final int NUM_PRESENTATION_RESTRICTED = 1;
    public static final String UT_BUNDLE_KEY_CLIR = "queryClir";
    public static final String UT_BUNDLE_KEY_SSINFO = "imsSsInfo";
    @UnsupportedAppUsage
    private ImsPhone mPhone;
    @UnsupportedAppUsage
    private Context mContext;
    private IccRecords mIccRecords;
    private String mAction;
    private String mSc;
    private String mSia;
    private String mSib;
    private String mSic;
    private String mPoundString;
    private String mDialingNumber;
    private String mPwd;
    private ResultReceiver mCallbackReceiver;
    private boolean mIsPendingUSSD;
    private boolean mIsUssdRequest;
    private boolean mIsCallFwdReg;
    private MmiCode.State mState = MmiCode.State.PENDING;
    private CharSequence mMessage;
    private boolean mIsSsInfo = false;
    static final String IcbDnMmi = "Specific Incoming Call Barring";
    static final String IcbAnonymousMmi = "Anonymous Incoming Call Barring";
    private static Pattern sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    private static final int MATCH_GROUP_POUND_STRING = 1;
    private static final int MATCH_GROUP_ACTION = 2;
    private static final int MATCH_GROUP_SERVICE_CODE = 3;
    private static final int MATCH_GROUP_SIA = 5;
    private static final int MATCH_GROUP_SIB = 7;
    private static final int MATCH_GROUP_SIC = 9;
    private static final int MATCH_GROUP_PWD_CONFIRM = 11;
    private static final int MATCH_GROUP_DIALING_NUMBER = 12;
    private static String[] sTwoDigitNumberPattern;

    @UnsupportedAppUsage
    static ImsPhoneMmiCode newFromDialString(String dialString, ImsPhone phone) {
        return ImsPhoneMmiCode.newFromDialString(dialString, phone, null);
    }

    static ImsPhoneMmiCode newFromDialString(String dialString, ImsPhone phone, ResultReceiver wrappedCallback) {
        Matcher m;
        ImsPhoneMmiCode ret = null;
        if (phone.getDefaultPhone().getServiceState().getVoiceRoaming() && phone.getDefaultPhone().supportsConversionOfCdmaCallerIdMmiCodesWhileRoaming()) {
            dialString = ImsPhoneMmiCode.convertCdmaMmiCodesTo3gppMmiCodes(dialString);
        }
        if ((m = sPatternSuppService.matcher(dialString)).matches()) {
            ret = new ImsPhoneMmiCode(phone);
            ret.mPoundString = ImsPhoneMmiCode.makeEmptyNull(m.group(1));
            ret.mAction = ImsPhoneMmiCode.makeEmptyNull(m.group(2));
            ret.mSc = ImsPhoneMmiCode.makeEmptyNull(m.group(3));
            ret.mSia = ImsPhoneMmiCode.makeEmptyNull(m.group(5));
            ret.mSib = ImsPhoneMmiCode.makeEmptyNull(m.group(7));
            ret.mSic = ImsPhoneMmiCode.makeEmptyNull(m.group(9));
            ret.mPwd = ImsPhoneMmiCode.makeEmptyNull(m.group(11));
            ret.mDialingNumber = ImsPhoneMmiCode.makeEmptyNull(m.group(12));
            ret.mCallbackReceiver = wrappedCallback;
            if (ret.mDialingNumber != null && ret.mDialingNumber.endsWith(ACTION_DEACTIVATE) && dialString.endsWith(ACTION_DEACTIVATE)) {
                ret = new ImsPhoneMmiCode(phone);
                ret.mPoundString = dialString;
            }
        } else if (dialString.endsWith(ACTION_DEACTIVATE)) {
            ret = new ImsPhoneMmiCode(phone);
            ret.mPoundString = dialString;
        } else if (ImsPhoneMmiCode.isTwoDigitShortCode(phone.getContext(), dialString)) {
            ret = null;
        } else if (ImsPhoneMmiCode.isShortCode(dialString, phone)) {
            ret = new ImsPhoneMmiCode(phone);
            ret.mDialingNumber = dialString;
        }
        return ret;
    }

    private static String convertCdmaMmiCodesTo3gppMmiCodes(String dialString) {
        Matcher m = sPatternCdmaMmiCodeWhileRoaming.matcher(dialString);
        if (m.matches()) {
            String serviceCode = ImsPhoneMmiCode.makeEmptyNull(m.group(1));
            String prefix = m.group(2);
            String number = ImsPhoneMmiCode.makeEmptyNull(m.group(3));
            if (serviceCode.equals(SC_CFB) && number != null) {
                dialString = "#31#" + prefix + number;
            } else if (serviceCode.equals("82") && number != null) {
                dialString = "*31#" + prefix + number;
            }
        }
        return dialString;
    }

    static ImsPhoneMmiCode newNetworkInitiatedUssd(String ussdMessage, boolean isUssdRequest, ImsPhone phone) {
        ImsPhoneMmiCode ret = new ImsPhoneMmiCode(phone);
        ret.mMessage = ussdMessage;
        ret.mIsUssdRequest = isUssdRequest;
        if (isUssdRequest) {
            ret.mIsPendingUSSD = true;
            ret.mState = MmiCode.State.PENDING;
        } else {
            ret.mState = MmiCode.State.COMPLETE;
        }
        return ret;
    }

    static ImsPhoneMmiCode newFromUssdUserInput(String ussdMessge, ImsPhone phone) {
        ImsPhoneMmiCode ret = new ImsPhoneMmiCode(phone);
        ret.mMessage = ussdMessge;
        ret.mState = MmiCode.State.PENDING;
        ret.mIsPendingUSSD = true;
        return ret;
    }

    private static String makeEmptyNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    static boolean isScMatchesSuppServType(String dialString) {
        boolean isMatch = false;
        Matcher m = sPatternSuppService.matcher(dialString);
        if (m.matches()) {
            String sc = ImsPhoneMmiCode.makeEmptyNull(m.group(3));
            if (sc.equals(SC_CFUT)) {
                isMatch = true;
            } else if (sc.equals(SC_BS_MT)) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    @UnsupportedAppUsage
    private static boolean isEmptyOrNull(CharSequence s) {
        return s == null || s.length() == 0;
    }

    private static int scToCallForwardReason(String sc) {
        if (sc == null) {
            throw new RuntimeException("invalid call forward sc");
        }
        if (sc.equals(SC_CF_All)) {
            return 4;
        }
        if (sc.equals(SC_CFU)) {
            return 0;
        }
        if (sc.equals(SC_CFB)) {
            return 1;
        }
        if (sc.equals(SC_CFNR)) {
            return 3;
        }
        if (sc.equals(SC_CFNRy)) {
            return 2;
        }
        if (sc.equals(SC_CF_All_Conditional)) {
            return 5;
        }
        throw new RuntimeException("invalid call forward sc");
    }

    private static int siToServiceClass(String si) {
        if (si == null || si.length() == 0) {
            return 0;
        }
        int serviceCode = Integer.parseInt(si, 10);
        switch (serviceCode) {
            case 10: {
                return 13;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 4;
            }
            case 16: {
                return 8;
            }
            case 19: {
                return 5;
            }
            case 20: {
                return 48;
            }
            case 21: {
                return 160;
            }
            case 22: {
                return 80;
            }
            case 24: {
                return 16;
            }
            case 25: {
                return 32;
            }
            case 26: {
                return 17;
            }
            case 99: {
                return 64;
            }
        }
        throw new RuntimeException("unsupported MMI service code " + si);
    }

    private static int siToTime(String si) {
        if (si == null || si.length() == 0) {
            return 0;
        }
        return Integer.parseInt(si, 10);
    }

    static boolean isServiceCodeCallForwarding(String sc) {
        return sc != null && (sc.equals(SC_CFU) || sc.equals(SC_CFB) || sc.equals(SC_CFNRy) || sc.equals(SC_CFNR) || sc.equals(SC_CF_All) || sc.equals(SC_CF_All_Conditional));
    }

    static boolean isServiceCodeCallBarring(String sc) {
        String[] barringMMI;
        Resources resource = Resources.getSystem();
        if (sc != null && (barringMMI = resource.getStringArray(17235995)) != null) {
            for (String match : barringMMI) {
                if (!sc.equals(match)) continue;
                return true;
            }
        }
        return false;
    }

    static String scToBarringFacility(String sc) {
        if (sc == null) {
            throw new RuntimeException("invalid call barring sc");
        }
        if (sc.equals(SC_BAOC)) {
            return "AO";
        }
        if (sc.equals(SC_BAOIC)) {
            return "OI";
        }
        if (sc.equals(SC_BAOICxH)) {
            return "OX";
        }
        if (sc.equals(SC_BAIC)) {
            return "AI";
        }
        if (sc.equals(SC_BAICr)) {
            return "IR";
        }
        if (sc.equals(SC_BA_ALL)) {
            return "AB";
        }
        if (sc.equals(SC_BA_MO)) {
            return "AG";
        }
        if (sc.equals(SC_BA_MT)) {
            return "AC";
        }
        throw new RuntimeException("invalid call barring sc");
    }

    public ImsPhoneMmiCode(ImsPhone phone) {
        super(phone.getHandler().getLooper());
        this.mPhone = phone;
        this.mContext = phone.getContext();
        this.mIccRecords = this.mPhone.mDefaultPhone.getIccRecords();
    }

    @Override
    public MmiCode.State getState() {
        return this.mState;
    }

    @Override
    public CharSequence getMessage() {
        return this.mMessage;
    }

    @Override
    public Phone getPhone() {
        return this.mPhone;
    }

    @Override
    public void cancel() {
        if (this.mState == MmiCode.State.COMPLETE || this.mState == MmiCode.State.FAILED) {
            return;
        }
        this.mState = MmiCode.State.CANCELLED;
        if (this.mIsPendingUSSD) {
            this.mPhone.cancelUSSD(this.obtainMessage(5, this));
        } else {
            this.mPhone.onMMIDone(this);
        }
    }

    @Override
    public boolean isCancelable() {
        return this.mIsPendingUSSD;
    }

    @UnsupportedAppUsage
    String getDialingNumber() {
        return this.mDialingNumber;
    }

    boolean isMMI() {
        return this.mPoundString != null;
    }

    boolean isShortCode() {
        return this.mPoundString == null && this.mDialingNumber != null && this.mDialingNumber.length() <= 2;
    }

    @Override
    public String getDialString() {
        return this.mPoundString;
    }

    private static boolean isTwoDigitShortCode(Context context, String dialString) {
        Rlog.d(LOG_TAG, "isTwoDigitShortCode");
        if (dialString == null || dialString.length() > 2) {
            return false;
        }
        if (sTwoDigitNumberPattern == null) {
            sTwoDigitNumberPattern = context.getResources().getStringArray(17236073);
        }
        for (String dialnumber : sTwoDigitNumberPattern) {
            Rlog.d(LOG_TAG, "Two Digit Number Pattern " + dialnumber);
            if (!dialString.equals(dialnumber)) continue;
            Rlog.d(LOG_TAG, "Two Digit Number Pattern -true");
            return true;
        }
        Rlog.d(LOG_TAG, "Two Digit Number Pattern -false");
        return false;
    }

    private static boolean isShortCode(String dialString, ImsPhone phone) {
        if (dialString == null) {
            return false;
        }
        if (dialString.length() == 0) {
            return false;
        }
        if (PhoneNumberUtils.isLocalEmergencyNumber(phone.getContext(), dialString)) {
            return false;
        }
        return ImsPhoneMmiCode.isShortCodeUSSD(dialString, phone);
    }

    private static boolean isShortCodeUSSD(String dialString, ImsPhone phone) {
        if (dialString != null && dialString.length() <= 2) {
            if (phone.isInCall()) {
                return true;
            }
            if (dialString.length() != 2 || dialString.charAt(0) != '1') {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPinPukCommand() {
        return this.mSc != null && (this.mSc.equals(SC_PIN) || this.mSc.equals(SC_PIN2) || this.mSc.equals(SC_PUK) || this.mSc.equals(SC_PUK2));
    }

    @UnsupportedAppUsage
    boolean isTemporaryModeCLIR() {
        return this.mSc != null && this.mSc.equals(SC_CLIR) && this.mDialingNumber != null && (this.isActivate() || this.isDeactivate());
    }

    @UnsupportedAppUsage
    int getCLIRMode() {
        if (this.mSc != null && this.mSc.equals(SC_CLIR)) {
            if (this.isActivate()) {
                return 2;
            }
            if (this.isDeactivate()) {
                return 1;
            }
        }
        return 0;
    }

    @UnsupportedAppUsage
    boolean isActivate() {
        return this.mAction != null && this.mAction.equals(ACTION_ACTIVATE);
    }

    @UnsupportedAppUsage
    boolean isDeactivate() {
        return this.mAction != null && this.mAction.equals(ACTION_DEACTIVATE);
    }

    boolean isInterrogate() {
        return this.mAction != null && this.mAction.equals(ACTION_INTERROGATE);
    }

    @UnsupportedAppUsage
    boolean isRegister() {
        return this.mAction != null && this.mAction.equals(ACTION_REGISTER);
    }

    @UnsupportedAppUsage
    boolean isErasure() {
        return this.mAction != null && this.mAction.equals(ACTION_ERASURE);
    }

    public boolean isPendingUSSD() {
        return this.mIsPendingUSSD;
    }

    @Override
    public boolean isUssdRequest() {
        return this.mIsUssdRequest;
    }

    @UnsupportedAppUsage
    boolean isSupportedOverImsPhone() {
        if (this.isShortCode()) {
            return true;
        }
        if (ImsPhoneMmiCode.isServiceCodeCallForwarding(this.mSc) || ImsPhoneMmiCode.isServiceCodeCallBarring(this.mSc) || this.mSc != null && this.mSc.equals(SC_WAIT) || this.mSc != null && this.mSc.equals(SC_CLIR) || this.mSc != null && this.mSc.equals(SC_CLIP) || this.mSc != null && this.mSc.equals(SC_COLR) || this.mSc != null && this.mSc.equals(SC_COLP) || this.mSc != null && this.mSc.equals(SC_BS_MT) || this.mSc != null && this.mSc.equals(SC_BAICa)) {
            try {
                int serviceClass = ImsPhoneMmiCode.siToServiceClass(this.mSib);
                return serviceClass == 0 || serviceClass == 1 || serviceClass == 80;
            }
            catch (RuntimeException exc) {
                Rlog.d(LOG_TAG, "Invalid service class " + exc);
            }
        } else {
            if (this.isPinPukCommand() || this.mSc != null && (this.mSc.equals(SC_PWD) || this.mSc.equals(SC_CLIP) || this.mSc.equals(SC_CLIR))) {
                return false;
            }
            if (this.mPoundString != null) {
                return true;
            }
        }
        return false;
    }

    public int callBarAction(String dialingNumber) {
        if (this.isActivate()) {
            return 1;
        }
        if (this.isDeactivate()) {
            return 0;
        }
        if (this.isRegister()) {
            if (!ImsPhoneMmiCode.isEmptyOrNull(dialingNumber)) {
                return 3;
            }
            throw new RuntimeException("invalid action");
        }
        if (this.isErasure()) {
            return 4;
        }
        throw new RuntimeException("invalid action");
    }

    @Override
    @UnsupportedAppUsage
    public void processCode() throws CallStateException {
        block69: {
            try {
                if (this.isShortCode()) {
                    Rlog.d(LOG_TAG, "processCode: isShortCode");
                    Rlog.d(LOG_TAG, "processCode: Sending short code '" + this.mDialingNumber + "' over CS pipe.");
                    throw new CallStateException("cs_fallback");
                }
                if (ImsPhoneMmiCode.isServiceCodeCallForwarding(this.mSc)) {
                    Rlog.d(LOG_TAG, "processCode: is CF");
                    String dialingNumber = this.mSia;
                    int reason = ImsPhoneMmiCode.scToCallForwardReason(this.mSc);
                    int serviceClass = ImsPhoneMmiCode.siToServiceClass(this.mSib);
                    int time = ImsPhoneMmiCode.siToTime(this.mSic);
                    if (this.isInterrogate()) {
                        this.mPhone.getCallForwardingOption(reason, this.obtainMessage(1, this));
                    } else {
                        int cfAction;
                        if (this.isActivate()) {
                            if (ImsPhoneMmiCode.isEmptyOrNull(dialingNumber)) {
                                cfAction = 1;
                                this.mIsCallFwdReg = false;
                            } else {
                                cfAction = 3;
                                this.mIsCallFwdReg = true;
                            }
                        } else if (this.isDeactivate()) {
                            cfAction = 0;
                        } else if (this.isRegister()) {
                            cfAction = 3;
                        } else if (this.isErasure()) {
                            cfAction = 4;
                        } else {
                            throw new RuntimeException("invalid action");
                        }
                        int isSettingUnconditional = reason == 0 || reason == 4 ? 1 : 0;
                        int isEnableDesired = cfAction == 1 || cfAction == 3 ? 1 : 0;
                        Rlog.d(LOG_TAG, "processCode: is CF setCallForward");
                        this.mPhone.setCallForwardingOption(cfAction, reason, dialingNumber, serviceClass, time, this.obtainMessage(4, isSettingUnconditional, isEnableDesired, this));
                    }
                    break block69;
                }
                if (ImsPhoneMmiCode.isServiceCodeCallBarring(this.mSc)) {
                    String password = this.mSia;
                    String facility = ImsPhoneMmiCode.scToBarringFacility(this.mSc);
                    int serviceClass = ImsPhoneMmiCode.siToServiceClass(this.mSib);
                    if (this.isInterrogate()) {
                        this.mPhone.getCallBarring(facility, this.obtainMessage(7, this), serviceClass);
                        break block69;
                    }
                    if (this.isActivate() || this.isDeactivate()) {
                        this.mPhone.setCallBarring(facility, this.isActivate(), password, this.obtainMessage(0, this), serviceClass);
                        break block69;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_CLIR)) {
                    if (this.isActivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCLIR(1, this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "processCode: Could not get UT handle for updateCLIR.");
                        }
                        break block69;
                    }
                    if (this.isDeactivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCLIR(2, this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "processCode: Could not get UT handle for updateCLIR.");
                        }
                        break block69;
                    }
                    if (this.isInterrogate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().queryCLIR(this.obtainMessage(6, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "processCode: Could not get UT handle for queryCLIR.");
                        }
                        break block69;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_CLIP)) {
                    if (this.isInterrogate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().queryCLIP(this.obtainMessage(7, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "processCode: Could not get UT handle for queryCLIP.");
                        }
                        break block69;
                    }
                    if (this.isActivate() || this.isDeactivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCLIP(this.isActivate(), this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "processCode: Could not get UT handle for updateCLIP.");
                        }
                        break block69;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_COLP)) {
                    if (this.isInterrogate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().queryCOLP(this.obtainMessage(7, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "processCode: Could not get UT handle for queryCOLP.");
                        }
                        break block69;
                    }
                    if (this.isActivate() || this.isDeactivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCOLP(this.isActivate(), this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "processCode: Could not get UT handle for updateCOLP.");
                        }
                        break block69;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_COLR)) {
                    if (this.isActivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCOLR(1, this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "processCode: Could not get UT handle for updateCOLR.");
                        }
                        break block69;
                    }
                    if (this.isDeactivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCOLR(0, this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "processCode: Could not get UT handle for updateCOLR.");
                        }
                        break block69;
                    }
                    if (this.isInterrogate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().queryCOLR(this.obtainMessage(7, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "processCode: Could not get UT handle for queryCOLR.");
                        }
                        break block69;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_BS_MT)) {
                    try {
                        if (this.isInterrogate()) {
                            this.mPhone.mCT.getUtInterface().queryCallBarring(10, this.obtainMessage(10, this));
                            break block69;
                        }
                        this.processIcbMmiCodeForUpdate();
                    }
                    catch (ImsException e) {
                        Rlog.d(LOG_TAG, "processCode: Could not get UT handle for ICB.");
                    }
                    break block69;
                }
                if (this.mSc != null && this.mSc.equals(SC_BAICa)) {
                    int callAction = 0;
                    try {
                        if (this.isInterrogate()) {
                            this.mPhone.mCT.getUtInterface().queryCallBarring(6, this.obtainMessage(10, this));
                            break block69;
                        }
                        if (this.isActivate()) {
                            callAction = 1;
                        } else if (this.isDeactivate()) {
                            callAction = 0;
                        }
                        this.mPhone.mCT.getUtInterface().updateCallBarring(6, callAction, this.obtainMessage(0, this), null);
                    }
                    catch (ImsException e) {
                        Rlog.d(LOG_TAG, "processCode: Could not get UT handle for ICBa.");
                    }
                    break block69;
                }
                if (this.mSc != null && this.mSc.equals(SC_WAIT)) {
                    int serviceClass = ImsPhoneMmiCode.siToServiceClass(this.mSib);
                    if (this.isActivate() || this.isDeactivate()) {
                        this.mPhone.setCallWaiting(this.isActivate(), serviceClass, this.obtainMessage(0, this));
                        break block69;
                    }
                    if (this.isInterrogate()) {
                        this.mPhone.getCallWaiting(this.obtainMessage(3, this));
                        break block69;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mPoundString != null) {
                    if (this.mPhone.getDefaultPhone().getServiceStateTracker().mSS.getState() == 0) {
                        Rlog.i(LOG_TAG, "processCode: Sending ussd string '" + Rlog.pii(LOG_TAG, (Object)this.mPoundString) + "' over CS pipe.");
                        throw new CallStateException("cs_fallback");
                    }
                    Rlog.i(LOG_TAG, "processCode: CS is out of service, sending ussd string '" + Rlog.pii(LOG_TAG, (Object)this.mPoundString) + "' over IMS pipe.");
                    this.sendUssd(this.mPoundString);
                    break block69;
                }
                Rlog.d(LOG_TAG, "processCode: invalid or unsupported MMI");
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
            catch (RuntimeException exc) {
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.mContext.getText(17040444);
                Rlog.d(LOG_TAG, "processCode: RuntimeException = " + exc);
                this.mPhone.onMMIDone(this);
            }
        }
    }

    void onUssdFinished(String ussdMessage, boolean isUssdRequest) {
        if (this.mState == MmiCode.State.PENDING) {
            if (TextUtils.isEmpty(ussdMessage)) {
                this.mMessage = this.mContext.getText(17040443);
                Rlog.v(LOG_TAG, "onUssdFinished: no message; using: " + this.mMessage);
            } else {
                Rlog.v(LOG_TAG, "onUssdFinished: message: " + ussdMessage);
                this.mMessage = ussdMessage;
            }
            this.mIsUssdRequest = isUssdRequest;
            if (!isUssdRequest) {
                this.mState = MmiCode.State.COMPLETE;
            }
            this.mPhone.onMMIDone(this);
        }
    }

    void onUssdFinishedError() {
        if (this.mState == MmiCode.State.PENDING) {
            this.mState = MmiCode.State.FAILED;
            this.mMessage = this.mContext.getText(17040444);
            Rlog.d(LOG_TAG, "onUssdFinishedError: mmi=" + this);
            this.mPhone.onMMIDone(this);
        }
    }

    void sendUssd(String ussdMessage) {
        this.mIsPendingUSSD = true;
        this.mPhone.sendUSSD(ussdMessage, this.obtainMessage(2, this));
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSetComplete(msg, ar);
                break;
            }
            case 4: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null && msg.arg1 == 1) {
                    boolean cffEnabled;
                    boolean bl = cffEnabled = msg.arg2 == 1;
                    if (this.mIccRecords != null) {
                        this.mPhone.setVoiceCallForwardingFlag(1, cffEnabled, this.mDialingNumber);
                    }
                }
                this.onSetComplete(msg, ar);
                break;
            }
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryCfComplete(ar);
                break;
            }
            case 3: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryComplete(ar);
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) break;
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.getErrorMessage(ar);
                this.mPhone.onMMIDone(this);
                break;
            }
            case 5: {
                this.mPhone.onMMIDone(this);
                break;
            }
            case 7: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSuppSvcQueryComplete(ar);
                break;
            }
            case 10: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onIcbQueryComplete(ar);
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryClirComplete(ar);
                break;
            }
        }
    }

    private void processIcbMmiCodeForUpdate() {
        String dialingNumber = this.mSia;
        String[] icbNum = null;
        if (dialingNumber != null) {
            icbNum = dialingNumber.split("\\$");
        }
        int callAction = this.callBarAction(dialingNumber);
        try {
            this.mPhone.mCT.getUtInterface().updateCallBarring(10, callAction, this.obtainMessage(0, this), icbNum);
        }
        catch (ImsException e) {
            Rlog.d(LOG_TAG, "processIcbMmiCodeForUpdate:Could not get UT handle for updating ICB.");
        }
    }

    @UnsupportedAppUsage
    private CharSequence getErrorMessage(AsyncResult ar) {
        CharSequence errorMessage = this.getMmiErrorMessage(ar);
        return errorMessage != null ? errorMessage : this.mContext.getText(17040444);
    }

    private CharSequence getMmiErrorMessage(AsyncResult ar) {
        if (ar.exception instanceof ImsException) {
            switch (((ImsException)ar.exception).getCode()) {
                case 241: {
                    return this.mContext.getText(17040446);
                }
                case 822: {
                    return this.mContext.getText(17041095);
                }
                case 823: {
                    return this.mContext.getText(17041098);
                }
                case 824: {
                    return this.mContext.getText(17041097);
                }
                case 825: {
                    return this.mContext.getText(17041096);
                }
            }
            return null;
        }
        if (ar.exception instanceof CommandException) {
            CommandException err = (CommandException)ar.exception;
            if (err.getCommandError() == CommandException.Error.FDN_CHECK_FAILURE) {
                return this.mContext.getText(17040446);
            }
            if (err.getCommandError() == CommandException.Error.SS_MODIFIED_TO_DIAL) {
                return this.mContext.getText(17041095);
            }
            if (err.getCommandError() == CommandException.Error.SS_MODIFIED_TO_USSD) {
                return this.mContext.getText(17041098);
            }
            if (err.getCommandError() == CommandException.Error.SS_MODIFIED_TO_SS) {
                return this.mContext.getText(17041097);
            }
            if (err.getCommandError() == CommandException.Error.SS_MODIFIED_TO_DIAL_VIDEO) {
                return this.mContext.getText(17041096);
            }
        }
        return null;
    }

    @UnsupportedAppUsage
    private CharSequence getScString() {
        if (this.mSc != null) {
            if (ImsPhoneMmiCode.isServiceCodeCallBarring(this.mSc)) {
                return this.mContext.getText(17039397);
            }
            if (ImsPhoneMmiCode.isServiceCodeCallForwarding(this.mSc)) {
                return this.mContext.getText(17039403);
            }
            if (this.mSc.equals(SC_PWD)) {
                return this.mContext.getText(17039420);
            }
            if (this.mSc.equals(SC_WAIT)) {
                return this.mContext.getText(17039411);
            }
            if (this.mSc.equals(SC_CLIP)) {
                return this.mContext.getText(17039404);
            }
            if (this.mSc.equals(SC_CLIR)) {
                return this.mContext.getText(17039405);
            }
            if (this.mSc.equals(SC_COLP)) {
                return this.mContext.getText(17039409);
            }
            if (this.mSc.equals(SC_COLR)) {
                return this.mContext.getText(17039410);
            }
            if (this.mSc.equals(SC_BS_MT)) {
                return IcbDnMmi;
            }
            if (this.mSc.equals(SC_BAICa)) {
                return IcbAnonymousMmi;
            }
        }
        return "";
    }

    private void onSetComplete(Message msg, AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof CommandException) {
                CommandException err = (CommandException)ar.exception;
                if (err.getCommandError() == CommandException.Error.PASSWORD_INCORRECT) {
                    sb.append(this.mContext.getText(17040537));
                } else {
                    CharSequence errorMessage = this.getMmiErrorMessage(ar);
                    if (errorMessage != null) {
                        sb.append(errorMessage);
                    } else if (err.getMessage() != null) {
                        sb.append(err.getMessage());
                    } else {
                        sb.append(this.mContext.getText(17040444));
                    }
                }
            } else if (ar.exception instanceof ImsException) {
                sb.append(this.getImsErrorMessage(ar));
            }
        } else if (this.isActivate()) {
            this.mState = MmiCode.State.COMPLETE;
            if (this.mIsCallFwdReg) {
                sb.append(this.mContext.getText(17041002));
            } else {
                sb.append(this.mContext.getText(17040998));
            }
            if (this.mSc.equals(SC_CLIR)) {
                this.mPhone.saveClirSetting(1);
            }
        } else if (this.isDeactivate()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17040997));
            if (this.mSc.equals(SC_CLIR)) {
                this.mPhone.saveClirSetting(2);
            }
        } else if (this.isRegister()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17041002));
        } else if (this.isErasure()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17041000));
        } else {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.mContext.getText(17040444));
        }
        this.mMessage = sb;
        Rlog.d(LOG_TAG, "onSetComplete: mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    @UnsupportedAppUsage
    private CharSequence serviceClassToCFString(int serviceClass) {
        switch (serviceClass) {
            case 1: {
                return this.mContext.getText(17040996);
            }
            case 2: {
                return this.mContext.getText(17040989);
            }
            case 4: {
                return this.mContext.getText(17040992);
            }
            case 8: {
                return this.mContext.getText(17040995);
            }
            case 16: {
                return this.mContext.getText(17040991);
            }
            case 32: {
                return this.mContext.getText(17040990);
            }
            case 64: {
                return this.mContext.getText(17040994);
            }
            case 128: {
                return this.mContext.getText(17040993);
            }
        }
        return null;
    }

    private CharSequence makeCFQueryResultMessage(CallForwardInfo info, int serviceClassMask) {
        boolean needTimeTemplate;
        String[] sources = new String[]{"{0}", "{1}", "{2}"};
        CharSequence[] destinations = new CharSequence[3];
        boolean bl = needTimeTemplate = info.reason == 2;
        CharSequence template = info.status == 1 ? (needTimeTemplate ? this.mContext.getText(17039648) : this.mContext.getText(17039647)) : (info.status == 0 && ImsPhoneMmiCode.isEmptyOrNull(info.number) ? this.mContext.getText(17039649) : (needTimeTemplate ? this.mContext.getText(17039651) : this.mContext.getText(17039650)));
        destinations[0] = this.serviceClassToCFString(info.serviceClass & serviceClassMask);
        destinations[1] = PhoneNumberUtils.stringFromStringAndTOA(info.number, info.toa);
        destinations[2] = Integer.toString(info.timeSeconds);
        if (info.reason == 0 && (info.serviceClass & serviceClassMask) == 1) {
            boolean cffEnabled;
            boolean bl2 = cffEnabled = info.status == 1;
            if (this.mIccRecords != null) {
                this.mPhone.setVoiceCallForwardingFlag(1, cffEnabled, info.number);
            }
        }
        return TextUtils.replace(template, sources, destinations);
    }

    private void onQueryCfComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof ImsException) {
                sb.append(this.getImsErrorMessage(ar));
            } else {
                sb.append(this.getErrorMessage(ar));
            }
        } else {
            CallForwardInfo[] infos = (CallForwardInfo[])ar.result;
            if (infos == null || infos.length == 0) {
                sb.append(this.mContext.getText(17040997));
                if (this.mIccRecords != null) {
                    this.mPhone.setVoiceCallForwardingFlag(1, false, null);
                }
            } else {
                SpannableStringBuilder tb = new SpannableStringBuilder();
                for (int serviceClassMask = 1; serviceClassMask <= 128; serviceClassMask <<= 1) {
                    int s = infos.length;
                    for (int i = 0; i < s; ++i) {
                        if ((serviceClassMask & infos[i].serviceClass) == 0) continue;
                        tb.append(this.makeCFQueryResultMessage(infos[i], serviceClassMask));
                        tb.append("\n");
                    }
                }
                sb.append(tb);
            }
            this.mState = MmiCode.State.COMPLETE;
        }
        this.mMessage = sb;
        Rlog.d(LOG_TAG, "onQueryCfComplete: mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private void onSuppSvcQueryComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        this.mState = MmiCode.State.FAILED;
        if (ar.exception != null) {
            if (ar.exception instanceof ImsException) {
                sb.append(this.getImsErrorMessage(ar));
            } else {
                sb.append(this.getErrorMessage(ar));
            }
        } else {
            ImsSsInfo ssInfo = null;
            if (ar.result instanceof Bundle) {
                Rlog.d(LOG_TAG, "onSuppSvcQueryComplete: Received CLIP/COLP/COLR Response.");
                Bundle ssInfoResp = (Bundle)ar.result;
                ssInfo = (ImsSsInfo)ssInfoResp.getParcelable(UT_BUNDLE_KEY_SSINFO);
                if (ssInfo != null) {
                    Rlog.d(LOG_TAG, "onSuppSvcQueryComplete: ImsSsInfo mStatus = " + ssInfo.getStatus());
                    if (ssInfo.getProvisionStatus() == 0) {
                        sb.append(this.mContext.getText(17041001));
                        this.mState = MmiCode.State.COMPLETE;
                    } else if (ssInfo.getStatus() == 0) {
                        sb.append(this.mContext.getText(17040997));
                        this.mState = MmiCode.State.COMPLETE;
                    } else if (ssInfo.getStatus() == 1) {
                        sb.append(this.mContext.getText(17040998));
                        this.mState = MmiCode.State.COMPLETE;
                    } else {
                        sb.append(this.mContext.getText(17040444));
                    }
                } else {
                    sb.append(this.mContext.getText(17040444));
                }
            } else {
                Rlog.d(LOG_TAG, "onSuppSvcQueryComplete: Received Call Barring Response.");
                int[] cbInfos = (int[])ar.result;
                if (cbInfos[0] == 1) {
                    sb.append(this.mContext.getText(17040998));
                    this.mState = MmiCode.State.COMPLETE;
                } else {
                    sb.append(this.mContext.getText(17040997));
                    this.mState = MmiCode.State.COMPLETE;
                }
            }
        }
        this.mMessage = sb;
        Rlog.d(LOG_TAG, "onSuppSvcQueryComplete mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private void onIcbQueryComplete(AsyncResult ar) {
        Rlog.d(LOG_TAG, "onIcbQueryComplete mmi=" + this);
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof ImsException) {
                sb.append(this.getImsErrorMessage(ar));
            } else {
                sb.append(this.getErrorMessage(ar));
            }
        } else {
            List<ImsSsInfo> infos = null;
            try {
                infos = (List<ImsSsInfo>)ar.result;
            }
            catch (ClassCastException cce) {
                infos = Arrays.asList((ImsSsInfo[])ar.result);
            }
            if (infos == null || infos.size() == 0) {
                sb.append(this.mContext.getText(17040997));
            } else {
                int s = infos.size();
                for (int i = 0; i < s; ++i) {
                    ImsSsInfo info = infos.get(i);
                    if (info.getIncomingCommunicationBarringNumber() != null) {
                        sb.append("Num: " + info.getIncomingCommunicationBarringNumber() + " status: " + info.getStatus() + "\n");
                        continue;
                    }
                    if (info.getStatus() == 1) {
                        sb.append(this.mContext.getText(17040998));
                        continue;
                    }
                    sb.append(this.mContext.getText(17040997));
                }
            }
            this.mState = MmiCode.State.COMPLETE;
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private void onQueryClirComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        this.mState = MmiCode.State.FAILED;
        if (ar.exception != null) {
            if (ar.exception instanceof ImsException) {
                sb.append(this.getImsErrorMessage(ar));
            }
        } else {
            Bundle ssInfo = (Bundle)ar.result;
            int[] clirInfo = ssInfo.getIntArray(UT_BUNDLE_KEY_CLIR);
            Rlog.d(LOG_TAG, "onQueryClirComplete: CLIR param n=" + clirInfo[0] + " m=" + clirInfo[1]);
            block0 : switch (clirInfo[1]) {
                case 0: {
                    sb.append(this.mContext.getText(17041001));
                    this.mState = MmiCode.State.COMPLETE;
                    break;
                }
                case 1: {
                    sb.append(this.mContext.getText(17039402));
                    this.mState = MmiCode.State.COMPLETE;
                    break;
                }
                case 3: {
                    switch (clirInfo[0]) {
                        case 0: {
                            sb.append(this.mContext.getText(17039401));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                        case 1: {
                            sb.append(this.mContext.getText(17039401));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                        case 2: {
                            sb.append(this.mContext.getText(17039400));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                    }
                    sb.append(this.mContext.getText(17040444));
                    this.mState = MmiCode.State.FAILED;
                    break;
                }
                case 4: {
                    switch (clirInfo[0]) {
                        case 0: {
                            sb.append(this.mContext.getText(17039398));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                        case 1: {
                            sb.append(this.mContext.getText(17039399));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                        case 2: {
                            sb.append(this.mContext.getText(17039398));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                    }
                    sb.append(this.mContext.getText(17040444));
                    this.mState = MmiCode.State.FAILED;
                    break;
                }
                default: {
                    sb.append(this.mContext.getText(17040444));
                    this.mState = MmiCode.State.FAILED;
                }
            }
        }
        this.mMessage = sb;
        Rlog.d(LOG_TAG, "onQueryClirComplete mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private void onQueryComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof ImsException) {
                sb.append(this.getImsErrorMessage(ar));
            } else {
                sb.append(this.getErrorMessage(ar));
            }
        } else {
            int[] ints = (int[])ar.result;
            if (ints.length != 0) {
                if (ints[0] == 0) {
                    sb.append(this.mContext.getText(17040997));
                } else if (this.mSc.equals(SC_WAIT)) {
                    sb.append(this.createQueryCallWaitingResultMessage(ints[1]));
                } else if (ints[0] == 1) {
                    sb.append(this.mContext.getText(17040998));
                } else {
                    sb.append(this.mContext.getText(17040444));
                }
            } else {
                sb.append(this.mContext.getText(17040444));
            }
            this.mState = MmiCode.State.COMPLETE;
        }
        this.mMessage = sb;
        Rlog.d(LOG_TAG, "onQueryComplete mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private CharSequence createQueryCallWaitingResultMessage(int serviceClass) {
        StringBuilder sb = new StringBuilder(this.mContext.getText(17040999));
        for (int classMask = 1; classMask <= 128; classMask <<= 1) {
            if ((classMask & serviceClass) == 0) continue;
            sb.append("\n");
            sb.append(this.serviceClassToCFString(classMask & serviceClass));
        }
        return sb;
    }

    private CharSequence getImsErrorMessage(AsyncResult ar) {
        ImsException error = (ImsException)ar.exception;
        CharSequence errorMessage = this.getMmiErrorMessage(ar);
        if (errorMessage != null) {
            return errorMessage;
        }
        if (error.getMessage() != null) {
            return error.getMessage();
        }
        return this.getErrorMessage(ar);
    }

    @Override
    public ResultReceiver getUssdCallbackReceiver() {
        return this.mCallbackReceiver;
    }

    public void processImsSsData(AsyncResult data) throws ImsException {
        try {
            ImsSsData ssData = (ImsSsData)data.result;
            this.parseSsData(ssData);
        }
        catch (ClassCastException | NullPointerException ex) {
            throw new ImsException("Exception in parsing SS Data", 0);
        }
    }

    void parseSsData(ImsSsData ssData) {
        ImsException ex = ssData.getResult() != 0 ? new ImsException(null, ssData.getResult()) : null;
        this.mSc = this.getScStringFromScType(ssData.getServiceType());
        this.mAction = this.getActionStringFromReqType(ssData.getRequestType());
        Rlog.d(LOG_TAG, "parseSsData msc = " + this.mSc + ", action = " + this.mAction + ", ex = " + ex);
        switch (ssData.getRequestType()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                if (ssData.getResult() == 0 && ssData.isTypeUnConditional()) {
                    boolean cffEnabled = (ssData.getRequestType() == 0 || ssData.getRequestType() == 3) && this.isServiceClassVoiceVideoOrNone(ssData.getServiceClass());
                    Rlog.d(LOG_TAG, "setCallForwardingFlag cffEnabled: " + cffEnabled);
                    if (this.mIccRecords != null) {
                        Rlog.d(LOG_TAG, "setVoiceCallForwardingFlag done from SS Info.");
                        this.mPhone.setVoiceCallForwardingFlag(1, cffEnabled, null);
                    } else {
                        Rlog.e(LOG_TAG, "setCallForwardingFlag aborted. sim records is null.");
                    }
                }
                this.onSetComplete(null, new AsyncResult(null, ssData.getCallForwardInfo(), ex));
                break;
            }
            case 2: {
                if (ssData.isTypeClir()) {
                    Rlog.d(LOG_TAG, "CLIR INTERROGATION");
                    Bundle clirInfo = new Bundle();
                    clirInfo.putIntArray(UT_BUNDLE_KEY_CLIR, ssData.getSuppServiceInfoCompat());
                    this.onQueryClirComplete(new AsyncResult(null, clirInfo, ex));
                    break;
                }
                if (ssData.isTypeCF()) {
                    Rlog.d(LOG_TAG, "CALL FORWARD INTERROGATION");
                    List<ImsCallForwardInfo> mCfInfos = ssData.getCallForwardInfo();
                    ImsCallForwardInfo[] mCfInfosCompat = null;
                    if (mCfInfos != null) {
                        mCfInfosCompat = new ImsCallForwardInfo[mCfInfos.size()];
                        mCfInfosCompat = mCfInfos.toArray(mCfInfosCompat);
                    }
                    this.onQueryCfComplete(new AsyncResult(null, this.mPhone.handleCfQueryResult(mCfInfosCompat), ex));
                    break;
                }
                if (ssData.isTypeBarring()) {
                    this.onSuppSvcQueryComplete(new AsyncResult(null, ssData.getSuppServiceInfoCompat(), ex));
                    break;
                }
                if (ssData.isTypeColr() || ssData.isTypeClip() || ssData.isTypeColp()) {
                    int[] suppServiceInfo = ssData.getSuppServiceInfoCompat();
                    ImsSsInfo ssInfo = new ImsSsInfo.Builder(suppServiceInfo[0]).build();
                    Bundle clInfo = new Bundle();
                    clInfo.putParcelable(UT_BUNDLE_KEY_SSINFO, ssInfo);
                    this.onSuppSvcQueryComplete(new AsyncResult(null, clInfo, ex));
                    break;
                }
                if (ssData.isTypeIcb()) {
                    this.onIcbQueryComplete(new AsyncResult(null, ssData.getSuppServiceInfo(), ex));
                    break;
                }
                this.onQueryComplete(new AsyncResult(null, ssData.getSuppServiceInfoCompat(), ex));
                break;
            }
            default: {
                Rlog.e(LOG_TAG, "Invaid requestType in SSData : " + ssData.getRequestType());
            }
        }
    }

    private String getScStringFromScType(int serviceType) {
        switch (serviceType) {
            case 0: {
                return SC_CFU;
            }
            case 1: {
                return SC_CFB;
            }
            case 2: {
                return SC_CFNRy;
            }
            case 3: {
                return SC_CFNR;
            }
            case 4: {
                return SC_CF_All;
            }
            case 5: {
                return SC_CF_All_Conditional;
            }
            case 7: {
                return SC_CLIP;
            }
            case 8: {
                return SC_CLIR;
            }
            case 9: {
                return SC_COLP;
            }
            case 10: {
                return SC_COLR;
            }
            case 11: {
                return SC_CNAP;
            }
            case 12: {
                return SC_WAIT;
            }
            case 13: {
                return SC_BAOC;
            }
            case 14: {
                return SC_BAOIC;
            }
            case 15: {
                return SC_BAOICxH;
            }
            case 16: {
                return SC_BAIC;
            }
            case 17: {
                return SC_BAICr;
            }
            case 18: {
                return SC_BA_ALL;
            }
            case 19: {
                return SC_BA_MO;
            }
            case 20: {
                return SC_BA_MT;
            }
            case 21: {
                return SC_BS_MT;
            }
            case 22: {
                return SC_BAICa;
            }
        }
        return null;
    }

    private String getActionStringFromReqType(int requestType) {
        switch (requestType) {
            case 0: {
                return ACTION_ACTIVATE;
            }
            case 1: {
                return ACTION_DEACTIVATE;
            }
            case 2: {
                return ACTION_INTERROGATE;
            }
            case 3: {
                return ACTION_REGISTER;
            }
            case 4: {
                return ACTION_ERASURE;
            }
        }
        return null;
    }

    private boolean isServiceClassVoiceVideoOrNone(int serviceClass) {
        return serviceClass == 0 || serviceClass == 1 || serviceClass == 80;
    }

    public boolean isSsInfo() {
        return this.mIsSsInfo;
    }

    public void setIsSsInfo(boolean isSsInfo) {
        this.mIsSsInfo = isSsInfo;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ImsPhoneMmiCode {");
        sb.append("State=" + (Object)((Object)this.getState()));
        if (this.mAction != null) {
            sb.append(" action=" + this.mAction);
        }
        if (this.mSc != null) {
            sb.append(" sc=" + this.mSc);
        }
        if (this.mSia != null) {
            sb.append(" sia=" + this.mSia);
        }
        if (this.mSib != null) {
            sb.append(" sib=" + this.mSib);
        }
        if (this.mSic != null) {
            sb.append(" sic=" + this.mSic);
        }
        if (this.mPoundString != null) {
            sb.append(" poundString=" + Rlog.pii(LOG_TAG, (Object)this.mPoundString));
        }
        if (this.mDialingNumber != null) {
            sb.append(" dialingNumber=" + Rlog.pii(LOG_TAG, (Object)this.mDialingNumber));
        }
        if (this.mPwd != null) {
            sb.append(" pwd=" + Rlog.pii(LOG_TAG, (Object)this.mPwd));
        }
        if (this.mCallbackReceiver != null) {
            sb.append(" hasReceiver");
        }
        sb.append("}");
        return sb.toString();
    }
}

