/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.metrics;

import android.os.Build;
import android.telephony.CallQuality;
import android.telephony.CellSignalStrengthLte;
import android.telephony.Rlog;
import android.telephony.SignalStrength;
import android.util.Pair;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.nano.TelephonyProto;
import java.util.ArrayList;

public class CallQualityMetrics {
    private static final String TAG = CallQualityMetrics.class.getSimpleName();
    private static final boolean USERDEBUG_MODE = Build.IS_USERDEBUG;
    private static final int MAX_SNAPSHOTS = 5;
    private static final int GOOD_QUALITY = 0;
    private static final int BAD_QUALITY = 1;
    private Phone mPhone;
    private ArrayList<Pair<CallQuality, Integer>> mUlSnapshots = new ArrayList();
    private ArrayList<Pair<CallQuality, Integer>> mDlSnapshots = new ArrayList();
    private int mDlCallQualityState = 0;
    private int mUlCallQualityState = 0;
    private CallQuality mLastCallQuality;
    private Pair<CallQuality, Integer> mWorstSsWithGoodDlQuality;
    private Pair<CallQuality, Integer> mBestSsWithGoodDlQuality;
    private Pair<CallQuality, Integer> mWorstSsWithBadDlQuality;
    private Pair<CallQuality, Integer> mBestSsWithBadDlQuality;
    private Pair<CallQuality, Integer> mWorstSsWithGoodUlQuality;
    private Pair<CallQuality, Integer> mBestSsWithGoodUlQuality;
    private Pair<CallQuality, Integer> mWorstSsWithBadUlQuality;
    private Pair<CallQuality, Integer> mBestSsWithBadUlQuality;
    private int mTotalDlGoodQualityTimeMs = 0;
    private int mTotalDlBadQualityTimeMs = 0;
    private int mTotalUlGoodQualityTimeMs = 0;
    private int mTotalUlBadQualityTimeMs = 0;

    public CallQualityMetrics(Phone phone) {
        this.mPhone = phone;
        this.mLastCallQuality = new CallQuality();
    }

    public void saveCallQuality(CallQuality cq) {
        if (cq.getUplinkCallQualityLevel() == 5 || cq.getDownlinkCallQualityLevel() == 5) {
            return;
        }
        int newUlCallQualityState = 1;
        int newDlCallQualityState = 1;
        if (CallQualityMetrics.isGoodQuality(cq.getUplinkCallQualityLevel())) {
            newUlCallQualityState = 0;
        }
        if (CallQualityMetrics.isGoodQuality(cq.getDownlinkCallQualityLevel())) {
            newDlCallQualityState = 0;
        }
        if (USERDEBUG_MODE) {
            if (newUlCallQualityState != this.mUlCallQualityState) {
                this.mUlSnapshots = this.addSnapshot(cq, this.mUlSnapshots);
            }
            if (newDlCallQualityState != this.mDlCallQualityState) {
                this.mDlSnapshots = this.addSnapshot(cq, this.mDlSnapshots);
            }
        }
        this.updateTotalDurations(newDlCallQualityState, newUlCallQualityState, cq);
        this.updateMinAndMaxSignalStrengthSnapshots(newDlCallQualityState, newUlCallQualityState, cq);
        this.mUlCallQualityState = newUlCallQualityState;
        this.mDlCallQualityState = newDlCallQualityState;
        this.mLastCallQuality = cq;
    }

    private static boolean isGoodQuality(int callQualityLevel) {
        return callQualityLevel < 4;
    }

    private ArrayList<Pair<CallQuality, Integer>> addSnapshot(CallQuality cq, ArrayList<Pair<CallQuality, Integer>> snapshots) {
        if (snapshots.size() < 5) {
            Integer ss = this.getLteSnr();
            snapshots.add(Pair.create(cq, ss));
        }
        return snapshots;
    }

    private void updateTotalDurations(int newDlCallQualityState, int newUlCallQualityState, CallQuality cq) {
        int timePassed = cq.getCallDuration() - this.mLastCallQuality.getCallDuration();
        if (newDlCallQualityState == 0) {
            this.mTotalDlGoodQualityTimeMs += timePassed;
        } else {
            this.mTotalDlBadQualityTimeMs += timePassed;
        }
        if (newUlCallQualityState == 0) {
            this.mTotalUlGoodQualityTimeMs += timePassed;
        } else {
            this.mTotalUlBadQualityTimeMs += timePassed;
        }
    }

    private void updateMinAndMaxSignalStrengthSnapshots(int newDlCallQualityState, int newUlCallQualityState, CallQuality cq) {
        Integer ss = this.getLteSnr();
        if (ss.equals(Integer.MAX_VALUE)) {
            return;
        }
        if (newDlCallQualityState == 0) {
            if (this.mWorstSsWithGoodDlQuality == null || ss < (Integer)this.mWorstSsWithGoodDlQuality.second) {
                this.mWorstSsWithGoodDlQuality = Pair.create(cq, ss);
            }
            if (this.mBestSsWithGoodDlQuality == null || ss > (Integer)this.mBestSsWithGoodDlQuality.second) {
                this.mBestSsWithGoodDlQuality = Pair.create(cq, ss);
            }
        } else {
            if (this.mWorstSsWithBadDlQuality == null || ss < (Integer)this.mWorstSsWithBadDlQuality.second) {
                this.mWorstSsWithBadDlQuality = Pair.create(cq, ss);
            }
            if (this.mBestSsWithBadDlQuality == null || ss > (Integer)this.mBestSsWithBadDlQuality.second) {
                this.mBestSsWithBadDlQuality = Pair.create(cq, ss);
            }
        }
        if (newUlCallQualityState == 0) {
            if (this.mWorstSsWithGoodUlQuality == null || ss < (Integer)this.mWorstSsWithGoodUlQuality.second) {
                this.mWorstSsWithGoodUlQuality = Pair.create(cq, ss);
            }
            if (this.mBestSsWithGoodUlQuality == null || ss > (Integer)this.mBestSsWithGoodUlQuality.second) {
                this.mBestSsWithGoodUlQuality = Pair.create(cq, ss);
            }
        } else {
            if (this.mWorstSsWithBadUlQuality == null || ss < (Integer)this.mWorstSsWithBadUlQuality.second) {
                this.mWorstSsWithBadUlQuality = Pair.create(cq, ss);
            }
            if (this.mBestSsWithBadUlQuality == null || ss > (Integer)this.mBestSsWithBadUlQuality.second) {
                this.mBestSsWithBadUlQuality = Pair.create(cq, ss);
            }
        }
    }

    private Integer getLteSnr() {
        ServiceStateTracker sst = this.mPhone.getDefaultPhone().getServiceStateTracker();
        if (sst == null) {
            Rlog.e(TAG, "getLteSnr: unable to get SST for phone " + this.mPhone.getPhoneId());
            return Integer.MAX_VALUE;
        }
        SignalStrength ss = sst.getSignalStrength();
        if (ss == null) {
            Rlog.e(TAG, "getLteSnr: unable to get SignalStrength for phone " + this.mPhone.getPhoneId());
            return Integer.MAX_VALUE;
        }
        for (CellSignalStrengthLte lteSs : ss.getCellSignalStrengths(CellSignalStrengthLte.class)) {
            int snr = lteSs.getRssnr();
            if (snr == Integer.MAX_VALUE) continue;
            return snr;
        }
        return Integer.MAX_VALUE;
    }

    private static TelephonyProto.TelephonyCallSession.Event.SignalStrength toProto(int ss) {
        TelephonyProto.TelephonyCallSession.Event.SignalStrength ret = new TelephonyProto.TelephonyCallSession.Event.SignalStrength();
        ret.lteSnr = ss;
        return ret;
    }

    public TelephonyProto.TelephonyCallSession.Event.CallQualitySummary getCallQualitySummaryDl() {
        TelephonyProto.TelephonyCallSession.Event.CallQualitySummary summary = new TelephonyProto.TelephonyCallSession.Event.CallQualitySummary();
        summary.totalGoodQualityDurationInSeconds = this.mTotalDlGoodQualityTimeMs / 1000;
        summary.totalBadQualityDurationInSeconds = this.mTotalDlBadQualityTimeMs / 1000;
        summary.totalDurationWithQualityInformationInSeconds = this.mLastCallQuality.getCallDuration() / 1000;
        if (this.mWorstSsWithGoodDlQuality != null) {
            summary.snapshotOfWorstSsWithGoodQuality = TelephonyMetrics.toCallQualityProto((CallQuality)this.mWorstSsWithGoodDlQuality.first);
            summary.worstSsWithGoodQuality = CallQualityMetrics.toProto((Integer)this.mWorstSsWithGoodDlQuality.second);
        }
        if (this.mBestSsWithGoodDlQuality != null) {
            summary.snapshotOfBestSsWithGoodQuality = TelephonyMetrics.toCallQualityProto((CallQuality)this.mBestSsWithGoodDlQuality.first);
            summary.bestSsWithGoodQuality = CallQualityMetrics.toProto((Integer)this.mBestSsWithGoodDlQuality.second);
        }
        if (this.mWorstSsWithBadDlQuality != null) {
            summary.snapshotOfWorstSsWithBadQuality = TelephonyMetrics.toCallQualityProto((CallQuality)this.mWorstSsWithBadDlQuality.first);
            summary.worstSsWithBadQuality = CallQualityMetrics.toProto((Integer)this.mWorstSsWithBadDlQuality.second);
        }
        if (this.mBestSsWithBadDlQuality != null) {
            summary.snapshotOfBestSsWithBadQuality = TelephonyMetrics.toCallQualityProto((CallQuality)this.mBestSsWithBadDlQuality.first);
            summary.bestSsWithBadQuality = CallQualityMetrics.toProto((Integer)this.mBestSsWithBadDlQuality.second);
        }
        summary.snapshotOfEnd = TelephonyMetrics.toCallQualityProto(this.mLastCallQuality);
        return summary;
    }

    public TelephonyProto.TelephonyCallSession.Event.CallQualitySummary getCallQualitySummaryUl() {
        TelephonyProto.TelephonyCallSession.Event.CallQualitySummary summary = new TelephonyProto.TelephonyCallSession.Event.CallQualitySummary();
        summary.totalGoodQualityDurationInSeconds = this.mTotalUlGoodQualityTimeMs / 1000;
        summary.totalBadQualityDurationInSeconds = this.mTotalUlBadQualityTimeMs / 1000;
        summary.totalDurationWithQualityInformationInSeconds = this.mLastCallQuality.getCallDuration() / 1000;
        if (this.mWorstSsWithGoodUlQuality != null) {
            summary.snapshotOfWorstSsWithGoodQuality = TelephonyMetrics.toCallQualityProto((CallQuality)this.mWorstSsWithGoodUlQuality.first);
            summary.worstSsWithGoodQuality = CallQualityMetrics.toProto((Integer)this.mWorstSsWithGoodUlQuality.second);
        }
        if (this.mBestSsWithGoodUlQuality != null) {
            summary.snapshotOfBestSsWithGoodQuality = TelephonyMetrics.toCallQualityProto((CallQuality)this.mBestSsWithGoodUlQuality.first);
            summary.bestSsWithGoodQuality = CallQualityMetrics.toProto((Integer)this.mBestSsWithGoodUlQuality.second);
        }
        if (this.mWorstSsWithBadUlQuality != null) {
            summary.snapshotOfWorstSsWithBadQuality = TelephonyMetrics.toCallQualityProto((CallQuality)this.mWorstSsWithBadUlQuality.first);
            summary.worstSsWithBadQuality = CallQualityMetrics.toProto((Integer)this.mWorstSsWithBadUlQuality.second);
        }
        if (this.mBestSsWithBadUlQuality != null) {
            summary.snapshotOfBestSsWithBadQuality = TelephonyMetrics.toCallQualityProto((CallQuality)this.mBestSsWithBadUlQuality.first);
            summary.bestSsWithBadQuality = CallQualityMetrics.toProto((Integer)this.mBestSsWithBadUlQuality.second);
        }
        summary.snapshotOfEnd = TelephonyMetrics.toCallQualityProto(this.mLastCallQuality);
        return summary;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[CallQualityMetrics phone ");
        sb.append(this.mPhone.getPhoneId());
        sb.append(" mUlSnapshots: {");
        for (Pair<CallQuality, Integer> snapshot : this.mUlSnapshots) {
            sb.append(" {cq=");
            sb.append(snapshot.first);
            sb.append(" ss=");
            sb.append(snapshot.second);
            sb.append("}");
        }
        sb.append("}");
        sb.append(" mDlSnapshots:{");
        for (Pair<CallQuality, Integer> snapshot : this.mDlSnapshots) {
            sb.append(" {cq=");
            sb.append(snapshot.first);
            sb.append(" ss=");
            sb.append(snapshot.second);
            sb.append("}");
        }
        sb.append("}");
        sb.append(" ");
        sb.append(" mTotalDlGoodQualityTimeMs: ");
        sb.append(this.mTotalDlGoodQualityTimeMs);
        sb.append(" mTotalDlBadQualityTimeMs: ");
        sb.append(this.mTotalDlBadQualityTimeMs);
        sb.append(" mTotalUlGoodQualityTimeMs: ");
        sb.append(this.mTotalUlGoodQualityTimeMs);
        sb.append(" mTotalUlBadQualityTimeMs: ");
        sb.append(this.mTotalUlBadQualityTimeMs);
        sb.append("]");
        return sb.toString();
    }
}

