/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.metrics;

import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.util.SparseArray;
import com.android.internal.telephony.nano.TelephonyProto;
import java.util.Arrays;

public class TelephonyEventBuilder {
    private final TelephonyProto.TelephonyEvent mEvent = new TelephonyProto.TelephonyEvent();

    public TelephonyProto.TelephonyEvent build() {
        return this.mEvent;
    }

    public TelephonyEventBuilder() {
        this(-1);
    }

    public TelephonyEventBuilder(int phoneId) {
        this(SystemClock.elapsedRealtime(), phoneId);
    }

    public TelephonyEventBuilder(long timestamp, int phoneId) {
        this.mEvent.timestampMillis = timestamp;
        this.mEvent.phoneId = phoneId;
    }

    public TelephonyEventBuilder setSettings(TelephonyProto.TelephonySettings settings) {
        this.mEvent.type = 1;
        this.mEvent.settings = settings;
        return this;
    }

    public TelephonyEventBuilder setServiceState(TelephonyProto.TelephonyServiceState state) {
        this.mEvent.type = 2;
        this.mEvent.serviceState = state;
        return this;
    }

    public TelephonyEventBuilder setImsConnectionState(TelephonyProto.ImsConnectionState state) {
        this.mEvent.type = 3;
        this.mEvent.imsConnectionState = state;
        return this;
    }

    public TelephonyEventBuilder setImsCapabilities(TelephonyProto.ImsCapabilities capabilities) {
        this.mEvent.type = 4;
        this.mEvent.imsCapabilities = capabilities;
        return this;
    }

    public TelephonyEventBuilder setDataStallRecoveryAction(int action) {
        this.mEvent.type = 10;
        this.mEvent.dataStallAction = action;
        return this;
    }

    public TelephonyEventBuilder setSetupDataCall(TelephonyProto.TelephonyEvent.RilSetupDataCall request) {
        this.mEvent.type = 5;
        this.mEvent.setupDataCall = request;
        return this;
    }

    public TelephonyEventBuilder setSetupDataCallResponse(TelephonyProto.TelephonyEvent.RilSetupDataCallResponse rsp) {
        this.mEvent.type = 6;
        this.mEvent.setupDataCallResponse = rsp;
        return this;
    }

    public TelephonyEventBuilder setDeactivateDataCall(TelephonyProto.TelephonyEvent.RilDeactivateDataCall request) {
        this.mEvent.type = 8;
        this.mEvent.deactivateDataCall = request;
        return this;
    }

    public TelephonyEventBuilder setDeactivateDataCallResponse(int errno) {
        this.mEvent.type = 9;
        this.mEvent.error = errno;
        return this;
    }

    public TelephonyEventBuilder setDataCalls(TelephonyProto.RilDataCall[] dataCalls) {
        this.mEvent.type = 7;
        this.mEvent.dataCalls = dataCalls;
        return this;
    }

    public TelephonyEventBuilder setNITZ(long timestamp) {
        this.mEvent.type = 12;
        this.mEvent.nitzTimestampMillis = timestamp;
        return this;
    }

    public TelephonyEventBuilder setModemRestart(TelephonyProto.TelephonyEvent.ModemRestart modemRestart) {
        this.mEvent.type = 11;
        this.mEvent.modemRestart = modemRestart;
        return this;
    }

    public TelephonyEventBuilder setCarrierIdMatching(TelephonyProto.TelephonyEvent.CarrierIdMatching carrierIdMatching) {
        this.mEvent.type = 13;
        this.mEvent.carrierIdMatching = carrierIdMatching;
        return this;
    }

    public TelephonyEventBuilder setUpdatedEmergencyNumber(TelephonyProto.EmergencyNumberInfo emergencyNumberInfo) {
        this.mEvent.type = 21;
        this.mEvent.updatedEmergencyNumber = emergencyNumberInfo;
        return this;
    }

    public TelephonyEventBuilder setCarrierKeyChange(TelephonyProto.TelephonyEvent.CarrierKeyChange carrierKeyChange) {
        this.mEvent.type = 14;
        this.mEvent.carrierKeyChange = carrierKeyChange;
        return this;
    }

    public TelephonyEventBuilder setSimStateChange(SparseArray<Integer> simStates) {
        int phoneCount = TelephonyManager.getDefault().getPhoneCount();
        this.mEvent.simState = new int[phoneCount];
        Arrays.fill(this.mEvent.simState, 0);
        this.mEvent.type = 18;
        for (int i = 0; i < simStates.size(); ++i) {
            int key = simStates.keyAt(i);
            if (0 > key || key >= phoneCount) continue;
            this.mEvent.simState[key] = simStates.get(key);
        }
        return this;
    }

    public TelephonyEventBuilder setActiveSubscriptionInfoChange(TelephonyProto.ActiveSubscriptionInfo info) {
        this.mEvent.type = 19;
        this.mEvent.activeSubscriptionInfo = info;
        return this;
    }

    public TelephonyEventBuilder setEnabledModemBitmap(int enabledModemBitmap) {
        this.mEvent.type = 20;
        this.mEvent.enabledModemBitmap = enabledModemBitmap;
        return this;
    }

    public TelephonyEventBuilder setDataSwitch(TelephonyProto.TelephonyEvent.DataSwitch dataSwitch) {
        this.mEvent.type = 15;
        this.mEvent.dataSwitch = dataSwitch;
        return this;
    }

    public TelephonyEventBuilder setNetworkValidate(int networkValidationState) {
        this.mEvent.type = 16;
        this.mEvent.networkValidationState = networkValidationState;
        return this;
    }

    public TelephonyEventBuilder setOnDemandDataSwitch(TelephonyProto.TelephonyEvent.OnDemandDataSwitch onDemandDataSwitch) {
        this.mEvent.type = 17;
        this.mEvent.onDemandDataSwitch = onDemandDataSwitch;
        return this;
    }
}

