/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.nano;

import com.android.internal.telephony.protobuf.nano.CodedInputByteBufferNano;
import com.android.internal.telephony.protobuf.nano.CodedOutputByteBufferNano;
import com.android.internal.telephony.protobuf.nano.ExtendableMessageNano;
import com.android.internal.telephony.protobuf.nano.InternalNano;
import com.android.internal.telephony.protobuf.nano.InvalidProtocolBufferNanoException;
import com.android.internal.telephony.protobuf.nano.MessageNano;
import com.android.internal.telephony.protobuf.nano.WireFormatNano;
import java.io.IOException;

public interface TelephonyProto {

    public static final class ModemPowerStats
    extends ExtendableMessageNano<ModemPowerStats> {
        private static volatile ModemPowerStats[] _emptyArray;
        public long loggingDurationMs;
        public double energyConsumedMah;
        public long numPacketsTx;
        public long cellularKernelActiveTimeMs;
        public long timeInVeryPoorRxSignalLevelMs;
        public long sleepTimeMs;
        public long idleTimeMs;
        public long rxTimeMs;
        public long[] txTimeMs;
        public long numBytesTx;
        public long numPacketsRx;
        public long numBytesRx;
        public long[] timeInRatMs;
        public long[] timeInRxSignalStrengthLevelMs;
        public double monitoredRailEnergyConsumedMah;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ModemPowerStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ModemPowerStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public ModemPowerStats() {
            this.clear();
        }

        public ModemPowerStats clear() {
            this.loggingDurationMs = 0L;
            this.energyConsumedMah = 0.0;
            this.numPacketsTx = 0L;
            this.cellularKernelActiveTimeMs = 0L;
            this.timeInVeryPoorRxSignalLevelMs = 0L;
            this.sleepTimeMs = 0L;
            this.idleTimeMs = 0L;
            this.rxTimeMs = 0L;
            this.txTimeMs = WireFormatNano.EMPTY_LONG_ARRAY;
            this.numBytesTx = 0L;
            this.numPacketsRx = 0L;
            this.numBytesRx = 0L;
            this.timeInRatMs = WireFormatNano.EMPTY_LONG_ARRAY;
            this.timeInRxSignalStrengthLevelMs = WireFormatNano.EMPTY_LONG_ARRAY;
            this.monitoredRailEnergyConsumedMah = 0.0;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            int i;
            if (this.loggingDurationMs != 0L) {
                output.writeInt64(1, this.loggingDurationMs);
            }
            if (Double.doubleToLongBits(this.energyConsumedMah) != Double.doubleToLongBits(0.0)) {
                output.writeDouble(2, this.energyConsumedMah);
            }
            if (this.numPacketsTx != 0L) {
                output.writeInt64(3, this.numPacketsTx);
            }
            if (this.cellularKernelActiveTimeMs != 0L) {
                output.writeInt64(4, this.cellularKernelActiveTimeMs);
            }
            if (this.timeInVeryPoorRxSignalLevelMs != 0L) {
                output.writeInt64(5, this.timeInVeryPoorRxSignalLevelMs);
            }
            if (this.sleepTimeMs != 0L) {
                output.writeInt64(6, this.sleepTimeMs);
            }
            if (this.idleTimeMs != 0L) {
                output.writeInt64(7, this.idleTimeMs);
            }
            if (this.rxTimeMs != 0L) {
                output.writeInt64(8, this.rxTimeMs);
            }
            if (this.txTimeMs != null && this.txTimeMs.length > 0) {
                for (i = 0; i < this.txTimeMs.length; ++i) {
                    output.writeInt64(9, this.txTimeMs[i]);
                }
            }
            if (this.numBytesTx != 0L) {
                output.writeInt64(10, this.numBytesTx);
            }
            if (this.numPacketsRx != 0L) {
                output.writeInt64(11, this.numPacketsRx);
            }
            if (this.numBytesRx != 0L) {
                output.writeInt64(12, this.numBytesRx);
            }
            if (this.timeInRatMs != null && this.timeInRatMs.length > 0) {
                for (i = 0; i < this.timeInRatMs.length; ++i) {
                    output.writeInt64(13, this.timeInRatMs[i]);
                }
            }
            if (this.timeInRxSignalStrengthLevelMs != null && this.timeInRxSignalStrengthLevelMs.length > 0) {
                for (i = 0; i < this.timeInRxSignalStrengthLevelMs.length; ++i) {
                    output.writeInt64(14, this.timeInRxSignalStrengthLevelMs[i]);
                }
            }
            if (Double.doubleToLongBits(this.monitoredRailEnergyConsumedMah) != Double.doubleToLongBits(0.0)) {
                output.writeDouble(15, this.monitoredRailEnergyConsumedMah);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            long element;
            int i;
            int dataSize;
            int size = super.computeSerializedSize();
            if (this.loggingDurationMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.loggingDurationMs);
            }
            if (Double.doubleToLongBits(this.energyConsumedMah) != Double.doubleToLongBits(0.0)) {
                size += CodedOutputByteBufferNano.computeDoubleSize(2, this.energyConsumedMah);
            }
            if (this.numPacketsTx != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(3, this.numPacketsTx);
            }
            if (this.cellularKernelActiveTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(4, this.cellularKernelActiveTimeMs);
            }
            if (this.timeInVeryPoorRxSignalLevelMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(5, this.timeInVeryPoorRxSignalLevelMs);
            }
            if (this.sleepTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(6, this.sleepTimeMs);
            }
            if (this.idleTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(7, this.idleTimeMs);
            }
            if (this.rxTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(8, this.rxTimeMs);
            }
            if (this.txTimeMs != null && this.txTimeMs.length > 0) {
                dataSize = 0;
                for (i = 0; i < this.txTimeMs.length; ++i) {
                    element = this.txTimeMs[i];
                    dataSize += CodedOutputByteBufferNano.computeInt64SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.txTimeMs.length;
            }
            if (this.numBytesTx != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(10, this.numBytesTx);
            }
            if (this.numPacketsRx != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(11, this.numPacketsRx);
            }
            if (this.numBytesRx != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(12, this.numBytesRx);
            }
            if (this.timeInRatMs != null && this.timeInRatMs.length > 0) {
                dataSize = 0;
                for (i = 0; i < this.timeInRatMs.length; ++i) {
                    element = this.timeInRatMs[i];
                    dataSize += CodedOutputByteBufferNano.computeInt64SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.timeInRatMs.length;
            }
            if (this.timeInRxSignalStrengthLevelMs != null && this.timeInRxSignalStrengthLevelMs.length > 0) {
                dataSize = 0;
                for (i = 0; i < this.timeInRxSignalStrengthLevelMs.length; ++i) {
                    element = this.timeInRxSignalStrengthLevelMs[i];
                    dataSize += CodedOutputByteBufferNano.computeInt64SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.timeInRxSignalStrengthLevelMs.length;
            }
            if (Double.doubleToLongBits(this.monitoredRailEnergyConsumedMah) != Double.doubleToLongBits(0.0)) {
                size += CodedOutputByteBufferNano.computeDoubleSize(15, this.monitoredRailEnergyConsumedMah);
            }
            return size;
        }

        @Override
        public ModemPowerStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block21: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block21;
                        return this;
                    }
                    case 8: {
                        this.loggingDurationMs = input.readInt64();
                        continue block21;
                    }
                    case 17: {
                        this.energyConsumedMah = input.readDouble();
                        continue block21;
                    }
                    case 24: {
                        this.numPacketsTx = input.readInt64();
                        continue block21;
                    }
                    case 32: {
                        this.cellularKernelActiveTimeMs = input.readInt64();
                        continue block21;
                    }
                    case 40: {
                        this.timeInVeryPoorRxSignalLevelMs = input.readInt64();
                        continue block21;
                    }
                    case 48: {
                        this.sleepTimeMs = input.readInt64();
                        continue block21;
                    }
                    case 56: {
                        this.idleTimeMs = input.readInt64();
                        continue block21;
                    }
                    case 64: {
                        this.rxTimeMs = input.readInt64();
                        continue block21;
                    }
                    case 72: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 72);
                        int i = this.txTimeMs == null ? 0 : this.txTimeMs.length;
                        long[] newArray = new long[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.txTimeMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readInt64();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readInt64();
                        this.txTimeMs = newArray;
                        continue block21;
                    }
                    case 74: {
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        int arrayLength = 0;
                        int startPos = input.getPosition();
                        while (input.getBytesUntilLimit() > 0) {
                            input.readInt64();
                            ++arrayLength;
                        }
                        input.rewindToPosition(startPos);
                        int i = this.txTimeMs == null ? 0 : this.txTimeMs.length;
                        long[] newArray = new long[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.txTimeMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length) {
                            newArray[i] = input.readInt64();
                            ++i;
                        }
                        this.txTimeMs = newArray;
                        input.popLimit(limit);
                        continue block21;
                    }
                    case 80: {
                        this.numBytesTx = input.readInt64();
                        continue block21;
                    }
                    case 88: {
                        this.numPacketsRx = input.readInt64();
                        continue block21;
                    }
                    case 96: {
                        this.numBytesRx = input.readInt64();
                        continue block21;
                    }
                    case 104: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 104);
                        int i = this.timeInRatMs == null ? 0 : this.timeInRatMs.length;
                        long[] newArray = new long[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.timeInRatMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readInt64();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readInt64();
                        this.timeInRatMs = newArray;
                        continue block21;
                    }
                    case 106: {
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        int arrayLength = 0;
                        int startPos = input.getPosition();
                        while (input.getBytesUntilLimit() > 0) {
                            input.readInt64();
                            ++arrayLength;
                        }
                        input.rewindToPosition(startPos);
                        int i = this.timeInRatMs == null ? 0 : this.timeInRatMs.length;
                        long[] newArray = new long[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.timeInRatMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length) {
                            newArray[i] = input.readInt64();
                            ++i;
                        }
                        this.timeInRatMs = newArray;
                        input.popLimit(limit);
                        continue block21;
                    }
                    case 112: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 112);
                        int i = this.timeInRxSignalStrengthLevelMs == null ? 0 : this.timeInRxSignalStrengthLevelMs.length;
                        long[] newArray = new long[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.timeInRxSignalStrengthLevelMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readInt64();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readInt64();
                        this.timeInRxSignalStrengthLevelMs = newArray;
                        continue block21;
                    }
                    case 114: {
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        int arrayLength = 0;
                        int startPos = input.getPosition();
                        while (input.getBytesUntilLimit() > 0) {
                            input.readInt64();
                            ++arrayLength;
                        }
                        input.rewindToPosition(startPos);
                        int i = this.timeInRxSignalStrengthLevelMs == null ? 0 : this.timeInRxSignalStrengthLevelMs.length;
                        long[] newArray = new long[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.timeInRxSignalStrengthLevelMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length) {
                            newArray[i] = input.readInt64();
                            ++i;
                        }
                        this.timeInRxSignalStrengthLevelMs = newArray;
                        input.popLimit(limit);
                        continue block21;
                    }
                    case 121: 
                }
                this.monitoredRailEnergyConsumedMah = input.readDouble();
            }
        }

        public static ModemPowerStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new ModemPowerStats(), data);
        }

        public static ModemPowerStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new ModemPowerStats().mergeFrom(input);
        }
    }

    public static final class SmsSession
    extends ExtendableMessageNano<SmsSession> {
        private static volatile SmsSession[] _emptyArray;
        public int startTimeMinutes;
        public int phoneId;
        public Event[] events;
        public boolean eventsDropped;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static SmsSession[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new SmsSession[0];
                    }
                }
            }
            return _emptyArray;
        }

        public SmsSession() {
            this.clear();
        }

        public SmsSession clear() {
            this.startTimeMinutes = 0;
            this.phoneId = 0;
            this.events = Event.emptyArray();
            this.eventsDropped = false;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.startTimeMinutes != 0) {
                output.writeInt32(1, this.startTimeMinutes);
            }
            if (this.phoneId != 0) {
                output.writeInt32(2, this.phoneId);
            }
            if (this.events != null && this.events.length > 0) {
                for (int i = 0; i < this.events.length; ++i) {
                    Event element = this.events[i];
                    if (element == null) continue;
                    output.writeMessage(3, element);
                }
            }
            if (this.eventsDropped) {
                output.writeBool(4, this.eventsDropped);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.startTimeMinutes != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.startTimeMinutes);
            }
            if (this.phoneId != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.phoneId);
            }
            if (this.events != null && this.events.length > 0) {
                for (int i = 0; i < this.events.length; ++i) {
                    Event element = this.events[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(3, element);
                }
            }
            if (this.eventsDropped) {
                size += CodedOutputByteBufferNano.computeBoolSize(4, this.eventsDropped);
            }
            return size;
        }

        @Override
        public SmsSession mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block7: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block7;
                        return this;
                    }
                    case 8: {
                        this.startTimeMinutes = input.readInt32();
                        continue block7;
                    }
                    case 16: {
                        this.phoneId = input.readInt32();
                        continue block7;
                    }
                    case 26: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 26);
                        int i = this.events == null ? 0 : this.events.length;
                        Event[] newArray = new Event[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.events, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new Event();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new Event();
                        input.readMessage(newArray[i]);
                        this.events = newArray;
                        continue block7;
                    }
                    case 32: 
                }
                this.eventsDropped = input.readBool();
            }
        }

        public static SmsSession parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new SmsSession(), data);
        }

        public static SmsSession parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new SmsSession().mergeFrom(input);
        }

        public static final class Event
        extends ExtendableMessageNano<Event> {
            private static volatile Event[] _emptyArray;
            public int type;
            public int delay;
            public TelephonySettings settings;
            public TelephonyServiceState serviceState;
            public ImsConnectionState imsConnectionState;
            public ImsCapabilities imsCapabilities;
            public RilDataCall[] dataCalls;
            public int format;
            public int tech;
            public int errorCode;
            public int error;
            public int rilRequestId;
            public CBMessage cellBroadcastMessage;
            public int imsError;
            public IncompleteSms incompleteSms;
            public int smsType;
            public boolean blocked;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static Event[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new Event[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public Event() {
                this.clear();
            }

            public Event clear() {
                this.type = 0;
                this.delay = 0;
                this.settings = null;
                this.serviceState = null;
                this.imsConnectionState = null;
                this.imsCapabilities = null;
                this.dataCalls = RilDataCall.emptyArray();
                this.format = 0;
                this.tech = 0;
                this.errorCode = 0;
                this.error = 0;
                this.rilRequestId = 0;
                this.cellBroadcastMessage = null;
                this.imsError = 0;
                this.incompleteSms = null;
                this.smsType = 0;
                this.blocked = false;
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.type != 0) {
                    output.writeInt32(1, this.type);
                }
                if (this.delay != 0) {
                    output.writeInt32(2, this.delay);
                }
                if (this.settings != null) {
                    output.writeMessage(3, this.settings);
                }
                if (this.serviceState != null) {
                    output.writeMessage(4, this.serviceState);
                }
                if (this.imsConnectionState != null) {
                    output.writeMessage(5, this.imsConnectionState);
                }
                if (this.imsCapabilities != null) {
                    output.writeMessage(6, this.imsCapabilities);
                }
                if (this.dataCalls != null && this.dataCalls.length > 0) {
                    for (int i = 0; i < this.dataCalls.length; ++i) {
                        RilDataCall element = this.dataCalls[i];
                        if (element == null) continue;
                        output.writeMessage(7, element);
                    }
                }
                if (this.format != 0) {
                    output.writeInt32(8, this.format);
                }
                if (this.tech != 0) {
                    output.writeInt32(9, this.tech);
                }
                if (this.errorCode != 0) {
                    output.writeInt32(10, this.errorCode);
                }
                if (this.error != 0) {
                    output.writeInt32(11, this.error);
                }
                if (this.rilRequestId != 0) {
                    output.writeInt32(12, this.rilRequestId);
                }
                if (this.cellBroadcastMessage != null) {
                    output.writeMessage(13, this.cellBroadcastMessage);
                }
                if (this.imsError != 0) {
                    output.writeInt32(14, this.imsError);
                }
                if (this.incompleteSms != null) {
                    output.writeMessage(15, this.incompleteSms);
                }
                if (this.smsType != 0) {
                    output.writeInt32(16, this.smsType);
                }
                if (this.blocked) {
                    output.writeBool(17, this.blocked);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.type != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.type);
                }
                if (this.delay != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.delay);
                }
                if (this.settings != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(3, this.settings);
                }
                if (this.serviceState != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(4, this.serviceState);
                }
                if (this.imsConnectionState != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(5, this.imsConnectionState);
                }
                if (this.imsCapabilities != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(6, this.imsCapabilities);
                }
                if (this.dataCalls != null && this.dataCalls.length > 0) {
                    for (int i = 0; i < this.dataCalls.length; ++i) {
                        RilDataCall element = this.dataCalls[i];
                        if (element == null) continue;
                        size += CodedOutputByteBufferNano.computeMessageSize(7, element);
                    }
                }
                if (this.format != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(8, this.format);
                }
                if (this.tech != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(9, this.tech);
                }
                if (this.errorCode != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(10, this.errorCode);
                }
                if (this.error != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(11, this.error);
                }
                if (this.rilRequestId != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(12, this.rilRequestId);
                }
                if (this.cellBroadcastMessage != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(13, this.cellBroadcastMessage);
                }
                if (this.imsError != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(14, this.imsError);
                }
                if (this.incompleteSms != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(15, this.incompleteSms);
                }
                if (this.smsType != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(16, this.smsType);
                }
                if (this.blocked) {
                    size += CodedOutputByteBufferNano.computeBoolSize(17, this.blocked);
                }
                return size;
            }

            @Override
            public Event mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block41: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block41;
                            return this;
                        }
                        case 8: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: {
                                    this.type = value;
                                    continue block41;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block41;
                        }
                        case 16: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: {
                                    this.delay = value;
                                    continue block41;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block41;
                        }
                        case 26: {
                            if (this.settings == null) {
                                this.settings = new TelephonySettings();
                            }
                            input.readMessage(this.settings);
                            continue block41;
                        }
                        case 34: {
                            if (this.serviceState == null) {
                                this.serviceState = new TelephonyServiceState();
                            }
                            input.readMessage(this.serviceState);
                            continue block41;
                        }
                        case 42: {
                            if (this.imsConnectionState == null) {
                                this.imsConnectionState = new ImsConnectionState();
                            }
                            input.readMessage(this.imsConnectionState);
                            continue block41;
                        }
                        case 50: {
                            if (this.imsCapabilities == null) {
                                this.imsCapabilities = new ImsCapabilities();
                            }
                            input.readMessage(this.imsCapabilities);
                            continue block41;
                        }
                        case 58: {
                            int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 58);
                            int i = this.dataCalls == null ? 0 : this.dataCalls.length;
                            RilDataCall[] newArray = new RilDataCall[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.dataCalls, 0, newArray, 0, i);
                            }
                            while (i < newArray.length - 1) {
                                newArray[i] = new RilDataCall();
                                input.readMessage(newArray[i]);
                                input.readTag();
                                ++i;
                            }
                            newArray[i] = new RilDataCall();
                            input.readMessage(newArray[i]);
                            this.dataCalls = newArray;
                            continue block41;
                        }
                        case 64: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    this.format = value;
                                    continue block41;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block41;
                        }
                        case 72: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: {
                                    this.tech = value;
                                    continue block41;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block41;
                        }
                        case 80: {
                            this.errorCode = input.readInt32();
                            continue block41;
                        }
                        case 88: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: 
                                case 25: 
                                case 26: 
                                case 27: 
                                case 28: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 39: 
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: 
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 58: 
                                case 59: 
                                case 60: 
                                case 61: 
                                case 62: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 66: 
                                case 67: {
                                    this.error = value;
                                    continue block41;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block41;
                        }
                        case 96: {
                            this.rilRequestId = input.readInt32();
                            continue block41;
                        }
                        case 106: {
                            if (this.cellBroadcastMessage == null) {
                                this.cellBroadcastMessage = new CBMessage();
                            }
                            input.readMessage(this.cellBroadcastMessage);
                            continue block41;
                        }
                        case 112: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: {
                                    this.imsError = value;
                                    continue block41;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block41;
                        }
                        case 122: {
                            if (this.incompleteSms == null) {
                                this.incompleteSms = new IncompleteSms();
                            }
                            input.readMessage(this.incompleteSms);
                            continue block41;
                        }
                        case 128: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: {
                                    this.smsType = value;
                                    continue block41;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block41;
                        }
                        case 136: 
                    }
                    this.blocked = input.readBool();
                }
            }

            public static Event parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new Event(), data);
            }

            public static Event parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new Event().mergeFrom(input);
            }

            public static final class IncompleteSms
            extends ExtendableMessageNano<IncompleteSms> {
                private static volatile IncompleteSms[] _emptyArray;
                public int receivedParts;
                public int totalParts;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public static IncompleteSms[] emptyArray() {
                    if (_emptyArray == null) {
                        Object object = InternalNano.LAZY_INIT_LOCK;
                        synchronized (object) {
                            if (_emptyArray == null) {
                                _emptyArray = new IncompleteSms[0];
                            }
                        }
                    }
                    return _emptyArray;
                }

                public IncompleteSms() {
                    this.clear();
                }

                public IncompleteSms clear() {
                    this.receivedParts = 0;
                    this.totalParts = 0;
                    this.unknownFieldData = null;
                    this.cachedSize = -1;
                    return this;
                }

                @Override
                public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                    if (this.receivedParts != 0) {
                        output.writeInt32(1, this.receivedParts);
                    }
                    if (this.totalParts != 0) {
                        output.writeInt32(2, this.totalParts);
                    }
                    super.writeTo(output);
                }

                @Override
                protected int computeSerializedSize() {
                    int size = super.computeSerializedSize();
                    if (this.receivedParts != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(1, this.receivedParts);
                    }
                    if (this.totalParts != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(2, this.totalParts);
                    }
                    return size;
                }

                @Override
                public IncompleteSms mergeFrom(CodedInputByteBufferNano input) throws IOException {
                    block5: while (true) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                return this;
                            }
                            default: {
                                if (this.storeUnknownField(input, tag)) continue block5;
                                return this;
                            }
                            case 8: {
                                this.receivedParts = input.readInt32();
                                continue block5;
                            }
                            case 16: 
                        }
                        this.totalParts = input.readInt32();
                    }
                }

                public static IncompleteSms parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                    return MessageNano.mergeFrom(new IncompleteSms(), data);
                }

                public static IncompleteSms parseFrom(CodedInputByteBufferNano input) throws IOException {
                    return new IncompleteSms().mergeFrom(input);
                }
            }

            public static final class CBMessage
            extends ExtendableMessageNano<CBMessage> {
                private static volatile CBMessage[] _emptyArray;
                public int msgFormat;
                public int msgPriority;
                public int msgType;
                public int serviceCategory;
                public int serialNumber;
                public long deliveredTimestampMillis;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public static CBMessage[] emptyArray() {
                    if (_emptyArray == null) {
                        Object object = InternalNano.LAZY_INIT_LOCK;
                        synchronized (object) {
                            if (_emptyArray == null) {
                                _emptyArray = new CBMessage[0];
                            }
                        }
                    }
                    return _emptyArray;
                }

                public CBMessage() {
                    this.clear();
                }

                public CBMessage clear() {
                    this.msgFormat = 0;
                    this.msgPriority = 0;
                    this.msgType = 0;
                    this.serviceCategory = 0;
                    this.serialNumber = 0;
                    this.deliveredTimestampMillis = 0L;
                    this.unknownFieldData = null;
                    this.cachedSize = -1;
                    return this;
                }

                @Override
                public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                    if (this.msgFormat != 0) {
                        output.writeInt32(1, this.msgFormat);
                    }
                    if (this.msgPriority != 0) {
                        output.writeInt32(2, this.msgPriority);
                    }
                    if (this.msgType != 0) {
                        output.writeInt32(3, this.msgType);
                    }
                    if (this.serviceCategory != 0) {
                        output.writeInt32(4, this.serviceCategory);
                    }
                    if (this.serialNumber != 0) {
                        output.writeInt32(5, this.serialNumber);
                    }
                    if (this.deliveredTimestampMillis != 0L) {
                        output.writeInt64(6, this.deliveredTimestampMillis);
                    }
                    super.writeTo(output);
                }

                @Override
                protected int computeSerializedSize() {
                    int size = super.computeSerializedSize();
                    if (this.msgFormat != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(1, this.msgFormat);
                    }
                    if (this.msgPriority != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(2, this.msgPriority);
                    }
                    if (this.msgType != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(3, this.msgType);
                    }
                    if (this.serviceCategory != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(4, this.serviceCategory);
                    }
                    if (this.serialNumber != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(5, this.serialNumber);
                    }
                    if (this.deliveredTimestampMillis != 0L) {
                        size += CodedOutputByteBufferNano.computeInt64Size(6, this.deliveredTimestampMillis);
                    }
                    return size;
                }

                @Override
                public CBMessage mergeFrom(CodedInputByteBufferNano input) throws IOException {
                    block18: while (true) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                return this;
                            }
                            default: {
                                if (this.storeUnknownField(input, tag)) continue block18;
                                return this;
                            }
                            case 8: {
                                int initialPos = input.getPosition();
                                int value = input.readInt32();
                                switch (value) {
                                    case 0: 
                                    case 1: 
                                    case 2: {
                                        this.msgFormat = value;
                                        continue block18;
                                    }
                                }
                                input.rewindToPosition(initialPos);
                                this.storeUnknownField(input, tag);
                                continue block18;
                            }
                            case 16: {
                                int initialPos = input.getPosition();
                                int value = input.readInt32();
                                switch (value) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        this.msgPriority = value;
                                        continue block18;
                                    }
                                }
                                input.rewindToPosition(initialPos);
                                this.storeUnknownField(input, tag);
                                continue block18;
                            }
                            case 24: {
                                int initialPos = input.getPosition();
                                int value = input.readInt32();
                                switch (value) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        this.msgType = value;
                                        continue block18;
                                    }
                                }
                                input.rewindToPosition(initialPos);
                                this.storeUnknownField(input, tag);
                                continue block18;
                            }
                            case 32: {
                                this.serviceCategory = input.readInt32();
                                continue block18;
                            }
                            case 40: {
                                this.serialNumber = input.readInt32();
                                continue block18;
                            }
                            case 48: 
                        }
                        this.deliveredTimestampMillis = input.readInt64();
                    }
                }

                public static CBMessage parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                    return MessageNano.mergeFrom(new CBMessage(), data);
                }

                public static CBMessage parseFrom(CodedInputByteBufferNano input) throws IOException {
                    return new CBMessage().mergeFrom(input);
                }
            }

            public static interface SmsType {
                public static final int SMS_TYPE_NORMAL = 0;
                public static final int SMS_TYPE_SMS_PP = 1;
                public static final int SMS_TYPE_VOICEMAIL_INDICATION = 2;
                public static final int SMS_TYPE_ZERO = 3;
                public static final int SMS_TYPE_WAP_PUSH = 4;
            }

            public static interface CBPriority {
                public static final int PRIORITY_UNKNOWN = 0;
                public static final int NORMAL = 1;
                public static final int INTERACTIVE = 2;
                public static final int URGENT = 3;
                public static final int EMERGENCY = 4;
            }

            public static interface CBMessageType {
                public static final int TYPE_UNKNOWN = 0;
                public static final int ETWS = 1;
                public static final int CMAS = 2;
                public static final int OTHER = 3;
            }

            public static interface Tech {
                public static final int SMS_UNKNOWN = 0;
                public static final int SMS_GSM = 1;
                public static final int SMS_CDMA = 2;
                public static final int SMS_IMS = 3;
            }

            public static interface Format {
                public static final int SMS_FORMAT_UNKNOWN = 0;
                public static final int SMS_FORMAT_3GPP = 1;
                public static final int SMS_FORMAT_3GPP2 = 2;
            }

            public static interface Type {
                public static final int EVENT_UNKNOWN = 0;
                public static final int SETTINGS_CHANGED = 1;
                public static final int RIL_SERVICE_STATE_CHANGED = 2;
                public static final int IMS_CONNECTION_STATE_CHANGED = 3;
                public static final int IMS_CAPABILITIES_CHANGED = 4;
                public static final int DATA_CALL_LIST_CHANGED = 5;
                public static final int SMS_SEND = 6;
                public static final int SMS_SEND_RESULT = 7;
                public static final int SMS_RECEIVED = 8;
                public static final int CB_SMS_RECEIVED = 9;
                public static final int INCOMPLETE_SMS_RECEIVED = 10;
            }
        }
    }

    public static final class TelephonyCallSession
    extends ExtendableMessageNano<TelephonyCallSession> {
        private static volatile TelephonyCallSession[] _emptyArray;
        public int startTimeMinutes;
        public int phoneId;
        public Event[] events;
        public boolean eventsDropped;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TelephonyCallSession[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new TelephonyCallSession[0];
                    }
                }
            }
            return _emptyArray;
        }

        public TelephonyCallSession() {
            this.clear();
        }

        public TelephonyCallSession clear() {
            this.startTimeMinutes = 0;
            this.phoneId = 0;
            this.events = Event.emptyArray();
            this.eventsDropped = false;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.startTimeMinutes != 0) {
                output.writeInt32(1, this.startTimeMinutes);
            }
            if (this.phoneId != 0) {
                output.writeInt32(2, this.phoneId);
            }
            if (this.events != null && this.events.length > 0) {
                for (int i = 0; i < this.events.length; ++i) {
                    Event element = this.events[i];
                    if (element == null) continue;
                    output.writeMessage(3, element);
                }
            }
            if (this.eventsDropped) {
                output.writeBool(4, this.eventsDropped);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.startTimeMinutes != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.startTimeMinutes);
            }
            if (this.phoneId != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.phoneId);
            }
            if (this.events != null && this.events.length > 0) {
                for (int i = 0; i < this.events.length; ++i) {
                    Event element = this.events[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(3, element);
                }
            }
            if (this.eventsDropped) {
                size += CodedOutputByteBufferNano.computeBoolSize(4, this.eventsDropped);
            }
            return size;
        }

        @Override
        public TelephonyCallSession mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block7: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block7;
                        return this;
                    }
                    case 8: {
                        this.startTimeMinutes = input.readInt32();
                        continue block7;
                    }
                    case 16: {
                        this.phoneId = input.readInt32();
                        continue block7;
                    }
                    case 26: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 26);
                        int i = this.events == null ? 0 : this.events.length;
                        Event[] newArray = new Event[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.events, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new Event();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new Event();
                        input.readMessage(newArray[i]);
                        this.events = newArray;
                        continue block7;
                    }
                    case 32: 
                }
                this.eventsDropped = input.readBool();
            }
        }

        public static TelephonyCallSession parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new TelephonyCallSession(), data);
        }

        public static TelephonyCallSession parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new TelephonyCallSession().mergeFrom(input);
        }

        public static final class Event
        extends ExtendableMessageNano<Event> {
            private static volatile Event[] _emptyArray;
            public int type;
            public int delay;
            public TelephonySettings settings;
            public TelephonyServiceState serviceState;
            public ImsConnectionState imsConnectionState;
            public ImsCapabilities imsCapabilities;
            public RilDataCall[] dataCalls;
            public int phoneState;
            public int callState;
            public int callIndex;
            public int mergedCallIndex;
            public RilCall[] calls;
            public int error;
            public int rilRequest;
            public int rilRequestId;
            public int srvccState;
            public int imsCommand;
            public ImsReasonInfo reasonInfo;
            public int srcAccessTech;
            public int targetAccessTech;
            public long nitzTimestampMillis;
            public int audioCodec;
            public CallQuality callQuality;
            public CallQualitySummary callQualitySummaryDl;
            public CallQualitySummary callQualitySummaryUl;
            public boolean isImsEmergencyCall;
            public EmergencyNumberInfo imsEmergencyNumberInfo;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static Event[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new Event[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public Event() {
                this.clear();
            }

            public Event clear() {
                this.type = 0;
                this.delay = 0;
                this.settings = null;
                this.serviceState = null;
                this.imsConnectionState = null;
                this.imsCapabilities = null;
                this.dataCalls = RilDataCall.emptyArray();
                this.phoneState = 0;
                this.callState = 0;
                this.callIndex = 0;
                this.mergedCallIndex = 0;
                this.calls = RilCall.emptyArray();
                this.error = 0;
                this.rilRequest = 0;
                this.rilRequestId = 0;
                this.srvccState = 0;
                this.imsCommand = 0;
                this.reasonInfo = null;
                this.srcAccessTech = -1;
                this.targetAccessTech = -1;
                this.nitzTimestampMillis = 0L;
                this.audioCodec = 0;
                this.callQuality = null;
                this.callQualitySummaryDl = null;
                this.callQualitySummaryUl = null;
                this.isImsEmergencyCall = false;
                this.imsEmergencyNumberInfo = null;
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                ExtendableMessageNano element;
                int i;
                if (this.type != 0) {
                    output.writeInt32(1, this.type);
                }
                if (this.delay != 0) {
                    output.writeInt32(2, this.delay);
                }
                if (this.settings != null) {
                    output.writeMessage(3, this.settings);
                }
                if (this.serviceState != null) {
                    output.writeMessage(4, this.serviceState);
                }
                if (this.imsConnectionState != null) {
                    output.writeMessage(5, this.imsConnectionState);
                }
                if (this.imsCapabilities != null) {
                    output.writeMessage(6, this.imsCapabilities);
                }
                if (this.dataCalls != null && this.dataCalls.length > 0) {
                    for (i = 0; i < this.dataCalls.length; ++i) {
                        element = this.dataCalls[i];
                        if (element == null) continue;
                        output.writeMessage(7, element);
                    }
                }
                if (this.phoneState != 0) {
                    output.writeInt32(8, this.phoneState);
                }
                if (this.callState != 0) {
                    output.writeInt32(9, this.callState);
                }
                if (this.callIndex != 0) {
                    output.writeInt32(10, this.callIndex);
                }
                if (this.mergedCallIndex != 0) {
                    output.writeInt32(11, this.mergedCallIndex);
                }
                if (this.calls != null && this.calls.length > 0) {
                    for (i = 0; i < this.calls.length; ++i) {
                        element = this.calls[i];
                        if (element == null) continue;
                        output.writeMessage(12, element);
                    }
                }
                if (this.error != 0) {
                    output.writeInt32(13, this.error);
                }
                if (this.rilRequest != 0) {
                    output.writeInt32(14, this.rilRequest);
                }
                if (this.rilRequestId != 0) {
                    output.writeInt32(15, this.rilRequestId);
                }
                if (this.srvccState != 0) {
                    output.writeInt32(16, this.srvccState);
                }
                if (this.imsCommand != 0) {
                    output.writeInt32(17, this.imsCommand);
                }
                if (this.reasonInfo != null) {
                    output.writeMessage(18, this.reasonInfo);
                }
                if (this.srcAccessTech != -1) {
                    output.writeInt32(19, this.srcAccessTech);
                }
                if (this.targetAccessTech != -1) {
                    output.writeInt32(20, this.targetAccessTech);
                }
                if (this.nitzTimestampMillis != 0L) {
                    output.writeInt64(21, this.nitzTimestampMillis);
                }
                if (this.audioCodec != 0) {
                    output.writeInt32(22, this.audioCodec);
                }
                if (this.callQuality != null) {
                    output.writeMessage(23, this.callQuality);
                }
                if (this.callQualitySummaryDl != null) {
                    output.writeMessage(24, this.callQualitySummaryDl);
                }
                if (this.callQualitySummaryUl != null) {
                    output.writeMessage(25, this.callQualitySummaryUl);
                }
                if (this.isImsEmergencyCall) {
                    output.writeBool(26, this.isImsEmergencyCall);
                }
                if (this.imsEmergencyNumberInfo != null) {
                    output.writeMessage(27, this.imsEmergencyNumberInfo);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                ExtendableMessageNano element;
                int i;
                int size = super.computeSerializedSize();
                if (this.type != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.type);
                }
                if (this.delay != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.delay);
                }
                if (this.settings != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(3, this.settings);
                }
                if (this.serviceState != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(4, this.serviceState);
                }
                if (this.imsConnectionState != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(5, this.imsConnectionState);
                }
                if (this.imsCapabilities != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(6, this.imsCapabilities);
                }
                if (this.dataCalls != null && this.dataCalls.length > 0) {
                    for (i = 0; i < this.dataCalls.length; ++i) {
                        element = this.dataCalls[i];
                        if (element == null) continue;
                        size += CodedOutputByteBufferNano.computeMessageSize(7, element);
                    }
                }
                if (this.phoneState != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(8, this.phoneState);
                }
                if (this.callState != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(9, this.callState);
                }
                if (this.callIndex != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(10, this.callIndex);
                }
                if (this.mergedCallIndex != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(11, this.mergedCallIndex);
                }
                if (this.calls != null && this.calls.length > 0) {
                    for (i = 0; i < this.calls.length; ++i) {
                        element = this.calls[i];
                        if (element == null) continue;
                        size += CodedOutputByteBufferNano.computeMessageSize(12, element);
                    }
                }
                if (this.error != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(13, this.error);
                }
                if (this.rilRequest != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(14, this.rilRequest);
                }
                if (this.rilRequestId != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(15, this.rilRequestId);
                }
                if (this.srvccState != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(16, this.srvccState);
                }
                if (this.imsCommand != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(17, this.imsCommand);
                }
                if (this.reasonInfo != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(18, this.reasonInfo);
                }
                if (this.srcAccessTech != -1) {
                    size += CodedOutputByteBufferNano.computeInt32Size(19, this.srcAccessTech);
                }
                if (this.targetAccessTech != -1) {
                    size += CodedOutputByteBufferNano.computeInt32Size(20, this.targetAccessTech);
                }
                if (this.nitzTimestampMillis != 0L) {
                    size += CodedOutputByteBufferNano.computeInt64Size(21, this.nitzTimestampMillis);
                }
                if (this.audioCodec != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(22, this.audioCodec);
                }
                if (this.callQuality != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(23, this.callQuality);
                }
                if (this.callQualitySummaryDl != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(24, this.callQualitySummaryDl);
                }
                if (this.callQualitySummaryUl != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(25, this.callQualitySummaryUl);
                }
                if (this.isImsEmergencyCall) {
                    size += CodedOutputByteBufferNano.computeBoolSize(26, this.isImsEmergencyCall);
                }
                if (this.imsEmergencyNumberInfo != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(27, this.imsEmergencyNumberInfo);
                }
                return size;
            }

            @Override
            public Event mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block63: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block63;
                            return this;
                        }
                        case 8: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: 
                                case 21: 
                                case 22: 
                                case 23: {
                                    this.type = value;
                                    continue block63;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block63;
                        }
                        case 16: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: {
                                    this.delay = value;
                                    continue block63;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block63;
                        }
                        case 26: {
                            if (this.settings == null) {
                                this.settings = new TelephonySettings();
                            }
                            input.readMessage(this.settings);
                            continue block63;
                        }
                        case 34: {
                            if (this.serviceState == null) {
                                this.serviceState = new TelephonyServiceState();
                            }
                            input.readMessage(this.serviceState);
                            continue block63;
                        }
                        case 42: {
                            if (this.imsConnectionState == null) {
                                this.imsConnectionState = new ImsConnectionState();
                            }
                            input.readMessage(this.imsConnectionState);
                            continue block63;
                        }
                        case 50: {
                            if (this.imsCapabilities == null) {
                                this.imsCapabilities = new ImsCapabilities();
                            }
                            input.readMessage(this.imsCapabilities);
                            continue block63;
                        }
                        case 58: {
                            int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 58);
                            int i = this.dataCalls == null ? 0 : this.dataCalls.length;
                            ExtendableMessageNano[] newArray = new RilDataCall[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.dataCalls, 0, newArray, 0, i);
                            }
                            while (i < newArray.length - 1) {
                                newArray[i] = new RilDataCall();
                                input.readMessage(newArray[i]);
                                input.readTag();
                                ++i;
                            }
                            newArray[i] = new RilDataCall();
                            input.readMessage(newArray[i]);
                            this.dataCalls = newArray;
                            continue block63;
                        }
                        case 64: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: {
                                    this.phoneState = value;
                                    continue block63;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block63;
                        }
                        case 72: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: {
                                    this.callState = value;
                                    continue block63;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block63;
                        }
                        case 80: {
                            this.callIndex = input.readInt32();
                            continue block63;
                        }
                        case 88: {
                            this.mergedCallIndex = input.readInt32();
                            continue block63;
                        }
                        case 98: {
                            int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 98);
                            int i = this.calls == null ? 0 : this.calls.length;
                            ExtendableMessageNano[] newArray = new RilCall[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.calls, 0, newArray, 0, i);
                            }
                            while (i < newArray.length - 1) {
                                newArray[i] = new RilCall();
                                input.readMessage(newArray[i]);
                                input.readTag();
                                ++i;
                            }
                            newArray[i] = new RilCall();
                            input.readMessage(newArray[i]);
                            this.calls = newArray;
                            continue block63;
                        }
                        case 104: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: 
                                case 25: 
                                case 26: 
                                case 27: 
                                case 28: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 39: 
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: 
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 58: 
                                case 59: 
                                case 60: 
                                case 61: 
                                case 62: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 66: 
                                case 67: {
                                    this.error = value;
                                    continue block63;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block63;
                        }
                        case 112: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    this.rilRequest = value;
                                    continue block63;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block63;
                        }
                        case 120: {
                            this.rilRequestId = input.readInt32();
                            continue block63;
                        }
                        case 128: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: {
                                    this.srvccState = value;
                                    continue block63;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block63;
                        }
                        case 136: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: {
                                    this.imsCommand = value;
                                    continue block63;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block63;
                        }
                        case 146: {
                            if (this.reasonInfo == null) {
                                this.reasonInfo = new ImsReasonInfo();
                            }
                            input.readMessage(this.reasonInfo);
                            continue block63;
                        }
                        case 152: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case -1: 
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: {
                                    this.srcAccessTech = value;
                                    continue block63;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block63;
                        }
                        case 160: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case -1: 
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: {
                                    this.targetAccessTech = value;
                                    continue block63;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block63;
                        }
                        case 168: {
                            this.nitzTimestampMillis = input.readInt64();
                            continue block63;
                        }
                        case 176: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: {
                                    this.audioCodec = value;
                                    continue block63;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block63;
                        }
                        case 186: {
                            if (this.callQuality == null) {
                                this.callQuality = new CallQuality();
                            }
                            input.readMessage(this.callQuality);
                            continue block63;
                        }
                        case 194: {
                            if (this.callQualitySummaryDl == null) {
                                this.callQualitySummaryDl = new CallQualitySummary();
                            }
                            input.readMessage(this.callQualitySummaryDl);
                            continue block63;
                        }
                        case 202: {
                            if (this.callQualitySummaryUl == null) {
                                this.callQualitySummaryUl = new CallQualitySummary();
                            }
                            input.readMessage(this.callQualitySummaryUl);
                            continue block63;
                        }
                        case 208: {
                            this.isImsEmergencyCall = input.readBool();
                            continue block63;
                        }
                        case 218: 
                    }
                    if (this.imsEmergencyNumberInfo == null) {
                        this.imsEmergencyNumberInfo = new EmergencyNumberInfo();
                    }
                    input.readMessage(this.imsEmergencyNumberInfo);
                }
            }

            public static Event parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new Event(), data);
            }

            public static Event parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new Event().mergeFrom(input);
            }

            public static final class CallQualitySummary
            extends ExtendableMessageNano<CallQualitySummary> {
                private static volatile CallQualitySummary[] _emptyArray;
                public int totalGoodQualityDurationInSeconds;
                public int totalBadQualityDurationInSeconds;
                public int totalDurationWithQualityInformationInSeconds;
                public CallQuality snapshotOfWorstSsWithGoodQuality;
                public CallQuality snapshotOfBestSsWithGoodQuality;
                public CallQuality snapshotOfWorstSsWithBadQuality;
                public CallQuality snapshotOfBestSsWithBadQuality;
                public SignalStrength worstSsWithGoodQuality;
                public SignalStrength bestSsWithGoodQuality;
                public SignalStrength worstSsWithBadQuality;
                public SignalStrength bestSsWithBadQuality;
                public CallQuality snapshotOfEnd;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public static CallQualitySummary[] emptyArray() {
                    if (_emptyArray == null) {
                        Object object = InternalNano.LAZY_INIT_LOCK;
                        synchronized (object) {
                            if (_emptyArray == null) {
                                _emptyArray = new CallQualitySummary[0];
                            }
                        }
                    }
                    return _emptyArray;
                }

                public CallQualitySummary() {
                    this.clear();
                }

                public CallQualitySummary clear() {
                    this.totalGoodQualityDurationInSeconds = 0;
                    this.totalBadQualityDurationInSeconds = 0;
                    this.totalDurationWithQualityInformationInSeconds = 0;
                    this.snapshotOfWorstSsWithGoodQuality = null;
                    this.snapshotOfBestSsWithGoodQuality = null;
                    this.snapshotOfWorstSsWithBadQuality = null;
                    this.snapshotOfBestSsWithBadQuality = null;
                    this.worstSsWithGoodQuality = null;
                    this.bestSsWithGoodQuality = null;
                    this.worstSsWithBadQuality = null;
                    this.bestSsWithBadQuality = null;
                    this.snapshotOfEnd = null;
                    this.unknownFieldData = null;
                    this.cachedSize = -1;
                    return this;
                }

                @Override
                public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                    if (this.totalGoodQualityDurationInSeconds != 0) {
                        output.writeInt32(1, this.totalGoodQualityDurationInSeconds);
                    }
                    if (this.totalBadQualityDurationInSeconds != 0) {
                        output.writeInt32(2, this.totalBadQualityDurationInSeconds);
                    }
                    if (this.totalDurationWithQualityInformationInSeconds != 0) {
                        output.writeInt32(3, this.totalDurationWithQualityInformationInSeconds);
                    }
                    if (this.snapshotOfWorstSsWithGoodQuality != null) {
                        output.writeMessage(4, this.snapshotOfWorstSsWithGoodQuality);
                    }
                    if (this.snapshotOfBestSsWithGoodQuality != null) {
                        output.writeMessage(5, this.snapshotOfBestSsWithGoodQuality);
                    }
                    if (this.snapshotOfWorstSsWithBadQuality != null) {
                        output.writeMessage(6, this.snapshotOfWorstSsWithBadQuality);
                    }
                    if (this.snapshotOfBestSsWithBadQuality != null) {
                        output.writeMessage(7, this.snapshotOfBestSsWithBadQuality);
                    }
                    if (this.worstSsWithGoodQuality != null) {
                        output.writeMessage(8, this.worstSsWithGoodQuality);
                    }
                    if (this.bestSsWithGoodQuality != null) {
                        output.writeMessage(9, this.bestSsWithGoodQuality);
                    }
                    if (this.worstSsWithBadQuality != null) {
                        output.writeMessage(10, this.worstSsWithBadQuality);
                    }
                    if (this.bestSsWithBadQuality != null) {
                        output.writeMessage(11, this.bestSsWithBadQuality);
                    }
                    if (this.snapshotOfEnd != null) {
                        output.writeMessage(12, this.snapshotOfEnd);
                    }
                    super.writeTo(output);
                }

                @Override
                protected int computeSerializedSize() {
                    int size = super.computeSerializedSize();
                    if (this.totalGoodQualityDurationInSeconds != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(1, this.totalGoodQualityDurationInSeconds);
                    }
                    if (this.totalBadQualityDurationInSeconds != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(2, this.totalBadQualityDurationInSeconds);
                    }
                    if (this.totalDurationWithQualityInformationInSeconds != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(3, this.totalDurationWithQualityInformationInSeconds);
                    }
                    if (this.snapshotOfWorstSsWithGoodQuality != null) {
                        size += CodedOutputByteBufferNano.computeMessageSize(4, this.snapshotOfWorstSsWithGoodQuality);
                    }
                    if (this.snapshotOfBestSsWithGoodQuality != null) {
                        size += CodedOutputByteBufferNano.computeMessageSize(5, this.snapshotOfBestSsWithGoodQuality);
                    }
                    if (this.snapshotOfWorstSsWithBadQuality != null) {
                        size += CodedOutputByteBufferNano.computeMessageSize(6, this.snapshotOfWorstSsWithBadQuality);
                    }
                    if (this.snapshotOfBestSsWithBadQuality != null) {
                        size += CodedOutputByteBufferNano.computeMessageSize(7, this.snapshotOfBestSsWithBadQuality);
                    }
                    if (this.worstSsWithGoodQuality != null) {
                        size += CodedOutputByteBufferNano.computeMessageSize(8, this.worstSsWithGoodQuality);
                    }
                    if (this.bestSsWithGoodQuality != null) {
                        size += CodedOutputByteBufferNano.computeMessageSize(9, this.bestSsWithGoodQuality);
                    }
                    if (this.worstSsWithBadQuality != null) {
                        size += CodedOutputByteBufferNano.computeMessageSize(10, this.worstSsWithBadQuality);
                    }
                    if (this.bestSsWithBadQuality != null) {
                        size += CodedOutputByteBufferNano.computeMessageSize(11, this.bestSsWithBadQuality);
                    }
                    if (this.snapshotOfEnd != null) {
                        size += CodedOutputByteBufferNano.computeMessageSize(12, this.snapshotOfEnd);
                    }
                    return size;
                }

                @Override
                public CallQualitySummary mergeFrom(CodedInputByteBufferNano input) throws IOException {
                    block15: while (true) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                return this;
                            }
                            default: {
                                if (this.storeUnknownField(input, tag)) continue block15;
                                return this;
                            }
                            case 8: {
                                this.totalGoodQualityDurationInSeconds = input.readInt32();
                                continue block15;
                            }
                            case 16: {
                                this.totalBadQualityDurationInSeconds = input.readInt32();
                                continue block15;
                            }
                            case 24: {
                                this.totalDurationWithQualityInformationInSeconds = input.readInt32();
                                continue block15;
                            }
                            case 34: {
                                if (this.snapshotOfWorstSsWithGoodQuality == null) {
                                    this.snapshotOfWorstSsWithGoodQuality = new CallQuality();
                                }
                                input.readMessage(this.snapshotOfWorstSsWithGoodQuality);
                                continue block15;
                            }
                            case 42: {
                                if (this.snapshotOfBestSsWithGoodQuality == null) {
                                    this.snapshotOfBestSsWithGoodQuality = new CallQuality();
                                }
                                input.readMessage(this.snapshotOfBestSsWithGoodQuality);
                                continue block15;
                            }
                            case 50: {
                                if (this.snapshotOfWorstSsWithBadQuality == null) {
                                    this.snapshotOfWorstSsWithBadQuality = new CallQuality();
                                }
                                input.readMessage(this.snapshotOfWorstSsWithBadQuality);
                                continue block15;
                            }
                            case 58: {
                                if (this.snapshotOfBestSsWithBadQuality == null) {
                                    this.snapshotOfBestSsWithBadQuality = new CallQuality();
                                }
                                input.readMessage(this.snapshotOfBestSsWithBadQuality);
                                continue block15;
                            }
                            case 66: {
                                if (this.worstSsWithGoodQuality == null) {
                                    this.worstSsWithGoodQuality = new SignalStrength();
                                }
                                input.readMessage(this.worstSsWithGoodQuality);
                                continue block15;
                            }
                            case 74: {
                                if (this.bestSsWithGoodQuality == null) {
                                    this.bestSsWithGoodQuality = new SignalStrength();
                                }
                                input.readMessage(this.bestSsWithGoodQuality);
                                continue block15;
                            }
                            case 82: {
                                if (this.worstSsWithBadQuality == null) {
                                    this.worstSsWithBadQuality = new SignalStrength();
                                }
                                input.readMessage(this.worstSsWithBadQuality);
                                continue block15;
                            }
                            case 90: {
                                if (this.bestSsWithBadQuality == null) {
                                    this.bestSsWithBadQuality = new SignalStrength();
                                }
                                input.readMessage(this.bestSsWithBadQuality);
                                continue block15;
                            }
                            case 98: 
                        }
                        if (this.snapshotOfEnd == null) {
                            this.snapshotOfEnd = new CallQuality();
                        }
                        input.readMessage(this.snapshotOfEnd);
                    }
                }

                public static CallQualitySummary parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                    return MessageNano.mergeFrom(new CallQualitySummary(), data);
                }

                public static CallQualitySummary parseFrom(CodedInputByteBufferNano input) throws IOException {
                    return new CallQualitySummary().mergeFrom(input);
                }
            }

            public static final class CallQuality
            extends ExtendableMessageNano<CallQuality> {
                private static volatile CallQuality[] _emptyArray;
                public int downlinkLevel;
                public int uplinkLevel;
                public int durationInSeconds;
                public int rtpPacketsTransmitted;
                public int rtpPacketsReceived;
                public int rtpPacketsTransmittedLost;
                public int rtpPacketsNotReceived;
                public int averageRelativeJitterMillis;
                public int maxRelativeJitterMillis;
                public int averageRoundTripTime;
                public int codecType;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public static CallQuality[] emptyArray() {
                    if (_emptyArray == null) {
                        Object object = InternalNano.LAZY_INIT_LOCK;
                        synchronized (object) {
                            if (_emptyArray == null) {
                                _emptyArray = new CallQuality[0];
                            }
                        }
                    }
                    return _emptyArray;
                }

                public CallQuality() {
                    this.clear();
                }

                public CallQuality clear() {
                    this.downlinkLevel = 0;
                    this.uplinkLevel = 0;
                    this.durationInSeconds = 0;
                    this.rtpPacketsTransmitted = 0;
                    this.rtpPacketsReceived = 0;
                    this.rtpPacketsTransmittedLost = 0;
                    this.rtpPacketsNotReceived = 0;
                    this.averageRelativeJitterMillis = 0;
                    this.maxRelativeJitterMillis = 0;
                    this.averageRoundTripTime = 0;
                    this.codecType = 0;
                    this.unknownFieldData = null;
                    this.cachedSize = -1;
                    return this;
                }

                @Override
                public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                    if (this.downlinkLevel != 0) {
                        output.writeInt32(1, this.downlinkLevel);
                    }
                    if (this.uplinkLevel != 0) {
                        output.writeInt32(2, this.uplinkLevel);
                    }
                    if (this.durationInSeconds != 0) {
                        output.writeInt32(3, this.durationInSeconds);
                    }
                    if (this.rtpPacketsTransmitted != 0) {
                        output.writeInt32(4, this.rtpPacketsTransmitted);
                    }
                    if (this.rtpPacketsReceived != 0) {
                        output.writeInt32(5, this.rtpPacketsReceived);
                    }
                    if (this.rtpPacketsTransmittedLost != 0) {
                        output.writeInt32(6, this.rtpPacketsTransmittedLost);
                    }
                    if (this.rtpPacketsNotReceived != 0) {
                        output.writeInt32(7, this.rtpPacketsNotReceived);
                    }
                    if (this.averageRelativeJitterMillis != 0) {
                        output.writeInt32(8, this.averageRelativeJitterMillis);
                    }
                    if (this.maxRelativeJitterMillis != 0) {
                        output.writeInt32(9, this.maxRelativeJitterMillis);
                    }
                    if (this.averageRoundTripTime != 0) {
                        output.writeInt32(10, this.averageRoundTripTime);
                    }
                    if (this.codecType != 0) {
                        output.writeInt32(11, this.codecType);
                    }
                    super.writeTo(output);
                }

                @Override
                protected int computeSerializedSize() {
                    int size = super.computeSerializedSize();
                    if (this.downlinkLevel != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(1, this.downlinkLevel);
                    }
                    if (this.uplinkLevel != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(2, this.uplinkLevel);
                    }
                    if (this.durationInSeconds != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(3, this.durationInSeconds);
                    }
                    if (this.rtpPacketsTransmitted != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(4, this.rtpPacketsTransmitted);
                    }
                    if (this.rtpPacketsReceived != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(5, this.rtpPacketsReceived);
                    }
                    if (this.rtpPacketsTransmittedLost != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(6, this.rtpPacketsTransmittedLost);
                    }
                    if (this.rtpPacketsNotReceived != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(7, this.rtpPacketsNotReceived);
                    }
                    if (this.averageRelativeJitterMillis != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(8, this.averageRelativeJitterMillis);
                    }
                    if (this.maxRelativeJitterMillis != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(9, this.maxRelativeJitterMillis);
                    }
                    if (this.averageRoundTripTime != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(10, this.averageRoundTripTime);
                    }
                    if (this.codecType != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(11, this.codecType);
                    }
                    return size;
                }

                @Override
                public CallQuality mergeFrom(CodedInputByteBufferNano input) throws IOException {
                    block23: while (true) {
                        int value;
                        int initialPos;
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                return this;
                            }
                            default: {
                                if (this.storeUnknownField(input, tag)) continue block23;
                                return this;
                            }
                            case 8: {
                                initialPos = input.getPosition();
                                value = input.readInt32();
                                switch (value) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: {
                                        this.downlinkLevel = value;
                                        continue block23;
                                    }
                                }
                                input.rewindToPosition(initialPos);
                                this.storeUnknownField(input, tag);
                                continue block23;
                            }
                            case 16: {
                                initialPos = input.getPosition();
                                value = input.readInt32();
                                switch (value) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: {
                                        this.uplinkLevel = value;
                                        continue block23;
                                    }
                                }
                                input.rewindToPosition(initialPos);
                                this.storeUnknownField(input, tag);
                                continue block23;
                            }
                            case 24: {
                                this.durationInSeconds = input.readInt32();
                                continue block23;
                            }
                            case 32: {
                                this.rtpPacketsTransmitted = input.readInt32();
                                continue block23;
                            }
                            case 40: {
                                this.rtpPacketsReceived = input.readInt32();
                                continue block23;
                            }
                            case 48: {
                                this.rtpPacketsTransmittedLost = input.readInt32();
                                continue block23;
                            }
                            case 56: {
                                this.rtpPacketsNotReceived = input.readInt32();
                                continue block23;
                            }
                            case 64: {
                                this.averageRelativeJitterMillis = input.readInt32();
                                continue block23;
                            }
                            case 72: {
                                this.maxRelativeJitterMillis = input.readInt32();
                                continue block23;
                            }
                            case 80: {
                                this.averageRoundTripTime = input.readInt32();
                                continue block23;
                            }
                            case 88: 
                        }
                        initialPos = input.getPosition();
                        value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: {
                                this.codecType = value;
                                continue block23;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                    }
                }

                public static CallQuality parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                    return MessageNano.mergeFrom(new CallQuality(), data);
                }

                public static CallQuality parseFrom(CodedInputByteBufferNano input) throws IOException {
                    return new CallQuality().mergeFrom(input);
                }

                public static interface CallQualityLevel {
                    public static final int UNDEFINED = 0;
                    public static final int EXCELLENT = 1;
                    public static final int GOOD = 2;
                    public static final int FAIR = 3;
                    public static final int POOR = 4;
                    public static final int BAD = 5;
                    public static final int NOT_AVAILABLE = 6;
                }
            }

            public static final class SignalStrength
            extends ExtendableMessageNano<SignalStrength> {
                private static volatile SignalStrength[] _emptyArray;
                public int lteSnr;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public static SignalStrength[] emptyArray() {
                    if (_emptyArray == null) {
                        Object object = InternalNano.LAZY_INIT_LOCK;
                        synchronized (object) {
                            if (_emptyArray == null) {
                                _emptyArray = new SignalStrength[0];
                            }
                        }
                    }
                    return _emptyArray;
                }

                public SignalStrength() {
                    this.clear();
                }

                public SignalStrength clear() {
                    this.lteSnr = 0;
                    this.unknownFieldData = null;
                    this.cachedSize = -1;
                    return this;
                }

                @Override
                public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                    if (this.lteSnr != 0) {
                        output.writeInt32(1, this.lteSnr);
                    }
                    super.writeTo(output);
                }

                @Override
                protected int computeSerializedSize() {
                    int size = super.computeSerializedSize();
                    if (this.lteSnr != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(1, this.lteSnr);
                    }
                    return size;
                }

                @Override
                public SignalStrength mergeFrom(CodedInputByteBufferNano input) throws IOException {
                    block4: while (true) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                return this;
                            }
                            default: {
                                if (this.storeUnknownField(input, tag)) continue block4;
                                return this;
                            }
                            case 8: 
                        }
                        this.lteSnr = input.readInt32();
                    }
                }

                public static SignalStrength parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                    return MessageNano.mergeFrom(new SignalStrength(), data);
                }

                public static SignalStrength parseFrom(CodedInputByteBufferNano input) throws IOException {
                    return new SignalStrength().mergeFrom(input);
                }
            }

            public static final class RilCall
            extends ExtendableMessageNano<RilCall> {
                private static volatile RilCall[] _emptyArray;
                public int index;
                public int state;
                public int type;
                public int callEndReason;
                public boolean isMultiparty;
                public int preciseDisconnectCause;
                public boolean isEmergencyCall;
                public EmergencyNumberInfo emergencyNumberInfo;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public static RilCall[] emptyArray() {
                    if (_emptyArray == null) {
                        Object object = InternalNano.LAZY_INIT_LOCK;
                        synchronized (object) {
                            if (_emptyArray == null) {
                                _emptyArray = new RilCall[0];
                            }
                        }
                    }
                    return _emptyArray;
                }

                public RilCall() {
                    this.clear();
                }

                public RilCall clear() {
                    this.index = 0;
                    this.state = 0;
                    this.type = 0;
                    this.callEndReason = 0;
                    this.isMultiparty = false;
                    this.preciseDisconnectCause = 0;
                    this.isEmergencyCall = false;
                    this.emergencyNumberInfo = null;
                    this.unknownFieldData = null;
                    this.cachedSize = -1;
                    return this;
                }

                @Override
                public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                    if (this.index != 0) {
                        output.writeInt32(1, this.index);
                    }
                    if (this.state != 0) {
                        output.writeInt32(2, this.state);
                    }
                    if (this.type != 0) {
                        output.writeInt32(3, this.type);
                    }
                    if (this.callEndReason != 0) {
                        output.writeInt32(4, this.callEndReason);
                    }
                    if (this.isMultiparty) {
                        output.writeBool(5, this.isMultiparty);
                    }
                    if (this.preciseDisconnectCause != 0) {
                        output.writeInt32(6, this.preciseDisconnectCause);
                    }
                    if (this.isEmergencyCall) {
                        output.writeBool(7, this.isEmergencyCall);
                    }
                    if (this.emergencyNumberInfo != null) {
                        output.writeMessage(8, this.emergencyNumberInfo);
                    }
                    super.writeTo(output);
                }

                @Override
                protected int computeSerializedSize() {
                    int size = super.computeSerializedSize();
                    if (this.index != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(1, this.index);
                    }
                    if (this.state != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(2, this.state);
                    }
                    if (this.type != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(3, this.type);
                    }
                    if (this.callEndReason != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(4, this.callEndReason);
                    }
                    if (this.isMultiparty) {
                        size += CodedOutputByteBufferNano.computeBoolSize(5, this.isMultiparty);
                    }
                    if (this.preciseDisconnectCause != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(6, this.preciseDisconnectCause);
                    }
                    if (this.isEmergencyCall) {
                        size += CodedOutputByteBufferNano.computeBoolSize(7, this.isEmergencyCall);
                    }
                    if (this.emergencyNumberInfo != null) {
                        size += CodedOutputByteBufferNano.computeMessageSize(8, this.emergencyNumberInfo);
                    }
                    return size;
                }

                @Override
                public RilCall mergeFrom(CodedInputByteBufferNano input) throws IOException {
                    block17: while (true) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                return this;
                            }
                            default: {
                                if (this.storeUnknownField(input, tag)) continue block17;
                                return this;
                            }
                            case 8: {
                                this.index = input.readInt32();
                                continue block17;
                            }
                            case 16: {
                                int initialPos = input.getPosition();
                                int value = input.readInt32();
                                switch (value) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 8: 
                                    case 9: {
                                        this.state = value;
                                        continue block17;
                                    }
                                }
                                input.rewindToPosition(initialPos);
                                this.storeUnknownField(input, tag);
                                continue block17;
                            }
                            case 24: {
                                int initialPos = input.getPosition();
                                int value = input.readInt32();
                                switch (value) {
                                    case 0: 
                                    case 1: 
                                    case 2: {
                                        this.type = value;
                                        continue block17;
                                    }
                                }
                                input.rewindToPosition(initialPos);
                                this.storeUnknownField(input, tag);
                                continue block17;
                            }
                            case 32: {
                                this.callEndReason = input.readInt32();
                                continue block17;
                            }
                            case 40: {
                                this.isMultiparty = input.readBool();
                                continue block17;
                            }
                            case 48: {
                                this.preciseDisconnectCause = input.readInt32();
                                continue block17;
                            }
                            case 56: {
                                this.isEmergencyCall = input.readBool();
                                continue block17;
                            }
                            case 66: 
                        }
                        if (this.emergencyNumberInfo == null) {
                            this.emergencyNumberInfo = new EmergencyNumberInfo();
                        }
                        input.readMessage(this.emergencyNumberInfo);
                    }
                }

                public static RilCall parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                    return MessageNano.mergeFrom(new RilCall(), data);
                }

                public static RilCall parseFrom(CodedInputByteBufferNano input) throws IOException {
                    return new RilCall().mergeFrom(input);
                }

                public static interface Type {
                    public static final int UNKNOWN = 0;
                    public static final int MO = 1;
                    public static final int MT = 2;
                }
            }

            public static interface RilSrvccState {
                public static final int HANDOVER_UNKNOWN = 0;
                public static final int HANDOVER_STARTED = 1;
                public static final int HANDOVER_COMPLETED = 2;
                public static final int HANDOVER_FAILED = 3;
                public static final int HANDOVER_CANCELED = 4;
            }

            public static interface AudioCodec {
                public static final int AUDIO_CODEC_UNKNOWN = 0;
                public static final int AUDIO_CODEC_AMR = 1;
                public static final int AUDIO_CODEC_AMR_WB = 2;
                public static final int AUDIO_CODEC_QCELP13K = 3;
                public static final int AUDIO_CODEC_EVRC = 4;
                public static final int AUDIO_CODEC_EVRC_B = 5;
                public static final int AUDIO_CODEC_EVRC_WB = 6;
                public static final int AUDIO_CODEC_EVRC_NW = 7;
                public static final int AUDIO_CODEC_GSM_EFR = 8;
                public static final int AUDIO_CODEC_GSM_FR = 9;
                public static final int AUDIO_CODEC_GSM_HR = 10;
                public static final int AUDIO_CODEC_G711U = 11;
                public static final int AUDIO_CODEC_G723 = 12;
                public static final int AUDIO_CODEC_G711A = 13;
                public static final int AUDIO_CODEC_G722 = 14;
                public static final int AUDIO_CODEC_G711AB = 15;
                public static final int AUDIO_CODEC_G729 = 16;
                public static final int AUDIO_CODEC_EVS_NB = 17;
                public static final int AUDIO_CODEC_EVS_WB = 18;
                public static final int AUDIO_CODEC_EVS_SWB = 19;
                public static final int AUDIO_CODEC_EVS_FB = 20;
            }

            public static interface CallState {
                public static final int CALL_UNKNOWN = 0;
                public static final int CALL_IDLE = 1;
                public static final int CALL_ACTIVE = 2;
                public static final int CALL_HOLDING = 3;
                public static final int CALL_DIALING = 4;
                public static final int CALL_ALERTING = 5;
                public static final int CALL_INCOMING = 6;
                public static final int CALL_WAITING = 7;
                public static final int CALL_DISCONNECTED = 8;
                public static final int CALL_DISCONNECTING = 9;
            }

            public static interface PhoneState {
                public static final int STATE_UNKNOWN = 0;
                public static final int STATE_IDLE = 1;
                public static final int STATE_RINGING = 2;
                public static final int STATE_OFFHOOK = 3;
            }

            public static interface ImsCommand {
                public static final int IMS_CMD_UNKNOWN = 0;
                public static final int IMS_CMD_START = 1;
                public static final int IMS_CMD_ACCEPT = 2;
                public static final int IMS_CMD_REJECT = 3;
                public static final int IMS_CMD_TERMINATE = 4;
                public static final int IMS_CMD_HOLD = 5;
                public static final int IMS_CMD_RESUME = 6;
                public static final int IMS_CMD_MERGE = 7;
                public static final int IMS_CMD_UPDATE = 8;
                public static final int IMS_CMD_CONFERENCE_EXTEND = 9;
                public static final int IMS_CMD_INVITE_PARTICIPANT = 10;
                public static final int IMS_CMD_REMOVE_PARTICIPANT = 11;
            }

            public static interface RilRequest {
                public static final int RIL_REQUEST_UNKNOWN = 0;
                public static final int RIL_REQUEST_DIAL = 1;
                public static final int RIL_REQUEST_ANSWER = 2;
                public static final int RIL_REQUEST_HANGUP = 3;
                public static final int RIL_REQUEST_SET_CALL_WAITING = 4;
                public static final int RIL_REQUEST_SWITCH_HOLDING_AND_ACTIVE = 5;
                public static final int RIL_REQUEST_CDMA_FLASH = 6;
                public static final int RIL_REQUEST_CONFERENCE = 7;
            }

            public static interface Type {
                public static final int EVENT_UNKNOWN = 0;
                public static final int SETTINGS_CHANGED = 1;
                public static final int RIL_SERVICE_STATE_CHANGED = 2;
                public static final int IMS_CONNECTION_STATE_CHANGED = 3;
                public static final int IMS_CAPABILITIES_CHANGED = 4;
                public static final int DATA_CALL_LIST_CHANGED = 5;
                public static final int RIL_REQUEST = 6;
                public static final int RIL_RESPONSE = 7;
                public static final int RIL_CALL_RING = 8;
                public static final int RIL_CALL_SRVCC = 9;
                public static final int RIL_CALL_LIST_CHANGED = 10;
                public static final int IMS_COMMAND = 11;
                public static final int IMS_COMMAND_RECEIVED = 12;
                public static final int IMS_COMMAND_FAILED = 13;
                public static final int IMS_COMMAND_COMPLETE = 14;
                public static final int IMS_CALL_RECEIVE = 15;
                public static final int IMS_CALL_STATE_CHANGED = 16;
                public static final int IMS_CALL_TERMINATED = 17;
                public static final int IMS_CALL_HANDOVER = 18;
                public static final int IMS_CALL_HANDOVER_FAILED = 19;
                public static final int PHONE_STATE_CHANGED = 20;
                public static final int NITZ_TIME = 21;
                public static final int AUDIO_CODEC = 22;
                public static final int CALL_QUALITY_CHANGED = 23;
            }
        }
    }

    public static final class ActiveSubscriptionInfo
    extends ExtendableMessageNano<ActiveSubscriptionInfo> {
        private static volatile ActiveSubscriptionInfo[] _emptyArray;
        public int slotIndex;
        public int carrierId;
        public int isOpportunistic;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ActiveSubscriptionInfo[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ActiveSubscriptionInfo[0];
                    }
                }
            }
            return _emptyArray;
        }

        public ActiveSubscriptionInfo() {
            this.clear();
        }

        public ActiveSubscriptionInfo clear() {
            this.slotIndex = 0;
            this.carrierId = 0;
            this.isOpportunistic = 0;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.slotIndex != 0) {
                output.writeInt32(1, this.slotIndex);
            }
            if (this.carrierId != 0) {
                output.writeInt32(2, this.carrierId);
            }
            if (this.isOpportunistic != 0) {
                output.writeInt32(3, this.isOpportunistic);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.slotIndex != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.slotIndex);
            }
            if (this.carrierId != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.carrierId);
            }
            if (this.isOpportunistic != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.isOpportunistic);
            }
            return size;
        }

        @Override
        public ActiveSubscriptionInfo mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block6: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block6;
                        return this;
                    }
                    case 8: {
                        this.slotIndex = input.readInt32();
                        continue block6;
                    }
                    case 16: {
                        this.carrierId = input.readInt32();
                        continue block6;
                    }
                    case 24: 
                }
                this.isOpportunistic = input.readInt32();
            }
        }

        public static ActiveSubscriptionInfo parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new ActiveSubscriptionInfo(), data);
        }

        public static ActiveSubscriptionInfo parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new ActiveSubscriptionInfo().mergeFrom(input);
        }
    }

    public static final class TelephonyEvent
    extends ExtendableMessageNano<TelephonyEvent> {
        private static volatile TelephonyEvent[] _emptyArray;
        public long timestampMillis;
        public int phoneId;
        public int type;
        public TelephonySettings settings;
        public TelephonyServiceState serviceState;
        public ImsConnectionState imsConnectionState;
        public ImsCapabilities imsCapabilities;
        public RilDataCall[] dataCalls;
        public int error;
        public RilSetupDataCall setupDataCall;
        public RilSetupDataCallResponse setupDataCallResponse;
        public RilDeactivateDataCall deactivateDataCall;
        public int dataStallAction;
        public ModemRestart modemRestart;
        public long nitzTimestampMillis;
        public CarrierIdMatching carrierIdMatching;
        public CarrierKeyChange carrierKeyChange;
        public DataSwitch dataSwitch;
        public int networkValidationState;
        public OnDemandDataSwitch onDemandDataSwitch;
        public int[] simState;
        public ActiveSubscriptionInfo activeSubscriptionInfo;
        public int enabledModemBitmap;
        public EmergencyNumberInfo updatedEmergencyNumber;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TelephonyEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new TelephonyEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public TelephonyEvent() {
            this.clear();
        }

        public TelephonyEvent clear() {
            this.timestampMillis = 0L;
            this.phoneId = 0;
            this.type = 0;
            this.settings = null;
            this.serviceState = null;
            this.imsConnectionState = null;
            this.imsCapabilities = null;
            this.dataCalls = RilDataCall.emptyArray();
            this.error = 0;
            this.setupDataCall = null;
            this.setupDataCallResponse = null;
            this.deactivateDataCall = null;
            this.dataStallAction = 0;
            this.modemRestart = null;
            this.nitzTimestampMillis = 0L;
            this.carrierIdMatching = null;
            this.carrierKeyChange = null;
            this.dataSwitch = null;
            this.networkValidationState = 0;
            this.onDemandDataSwitch = null;
            this.simState = WireFormatNano.EMPTY_INT_ARRAY;
            this.activeSubscriptionInfo = null;
            this.enabledModemBitmap = 0;
            this.updatedEmergencyNumber = null;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            int i;
            if (this.timestampMillis != 0L) {
                output.writeInt64(1, this.timestampMillis);
            }
            if (this.phoneId != 0) {
                output.writeInt32(2, this.phoneId);
            }
            if (this.type != 0) {
                output.writeInt32(3, this.type);
            }
            if (this.settings != null) {
                output.writeMessage(4, this.settings);
            }
            if (this.serviceState != null) {
                output.writeMessage(5, this.serviceState);
            }
            if (this.imsConnectionState != null) {
                output.writeMessage(6, this.imsConnectionState);
            }
            if (this.imsCapabilities != null) {
                output.writeMessage(7, this.imsCapabilities);
            }
            if (this.dataCalls != null && this.dataCalls.length > 0) {
                for (i = 0; i < this.dataCalls.length; ++i) {
                    RilDataCall element = this.dataCalls[i];
                    if (element == null) continue;
                    output.writeMessage(8, element);
                }
            }
            if (this.error != 0) {
                output.writeInt32(9, this.error);
            }
            if (this.setupDataCall != null) {
                output.writeMessage(10, this.setupDataCall);
            }
            if (this.setupDataCallResponse != null) {
                output.writeMessage(11, this.setupDataCallResponse);
            }
            if (this.deactivateDataCall != null) {
                output.writeMessage(12, this.deactivateDataCall);
            }
            if (this.dataStallAction != 0) {
                output.writeInt32(13, this.dataStallAction);
            }
            if (this.modemRestart != null) {
                output.writeMessage(14, this.modemRestart);
            }
            if (this.nitzTimestampMillis != 0L) {
                output.writeInt64(15, this.nitzTimestampMillis);
            }
            if (this.carrierIdMatching != null) {
                output.writeMessage(16, this.carrierIdMatching);
            }
            if (this.carrierKeyChange != null) {
                output.writeMessage(17, this.carrierKeyChange);
            }
            if (this.dataSwitch != null) {
                output.writeMessage(19, this.dataSwitch);
            }
            if (this.networkValidationState != 0) {
                output.writeInt32(20, this.networkValidationState);
            }
            if (this.onDemandDataSwitch != null) {
                output.writeMessage(21, this.onDemandDataSwitch);
            }
            if (this.simState != null && this.simState.length > 0) {
                for (i = 0; i < this.simState.length; ++i) {
                    output.writeInt32(22, this.simState[i]);
                }
            }
            if (this.activeSubscriptionInfo != null) {
                output.writeMessage(23, this.activeSubscriptionInfo);
            }
            if (this.enabledModemBitmap != 0) {
                output.writeInt32(24, this.enabledModemBitmap);
            }
            if (this.updatedEmergencyNumber != null) {
                output.writeMessage(25, this.updatedEmergencyNumber);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.timestampMillis != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.timestampMillis);
            }
            if (this.phoneId != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.phoneId);
            }
            if (this.type != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.type);
            }
            if (this.settings != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(4, this.settings);
            }
            if (this.serviceState != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(5, this.serviceState);
            }
            if (this.imsConnectionState != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(6, this.imsConnectionState);
            }
            if (this.imsCapabilities != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(7, this.imsCapabilities);
            }
            if (this.dataCalls != null && this.dataCalls.length > 0) {
                for (int i = 0; i < this.dataCalls.length; ++i) {
                    RilDataCall element = this.dataCalls[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(8, element);
                }
            }
            if (this.error != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(9, this.error);
            }
            if (this.setupDataCall != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(10, this.setupDataCall);
            }
            if (this.setupDataCallResponse != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(11, this.setupDataCallResponse);
            }
            if (this.deactivateDataCall != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(12, this.deactivateDataCall);
            }
            if (this.dataStallAction != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(13, this.dataStallAction);
            }
            if (this.modemRestart != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(14, this.modemRestart);
            }
            if (this.nitzTimestampMillis != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(15, this.nitzTimestampMillis);
            }
            if (this.carrierIdMatching != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(16, this.carrierIdMatching);
            }
            if (this.carrierKeyChange != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(17, this.carrierKeyChange);
            }
            if (this.dataSwitch != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(19, this.dataSwitch);
            }
            if (this.networkValidationState != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(20, this.networkValidationState);
            }
            if (this.onDemandDataSwitch != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(21, this.onDemandDataSwitch);
            }
            if (this.simState != null && this.simState.length > 0) {
                int dataSize = 0;
                for (int i = 0; i < this.simState.length; ++i) {
                    int element = this.simState[i];
                    dataSize += CodedOutputByteBufferNano.computeInt32SizeNoTag(element);
                }
                size += dataSize;
                size += 2 * this.simState.length;
            }
            if (this.activeSubscriptionInfo != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(23, this.activeSubscriptionInfo);
            }
            if (this.enabledModemBitmap != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(24, this.enabledModemBitmap);
            }
            if (this.updatedEmergencyNumber != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(25, this.updatedEmergencyNumber);
            }
            return size;
        }

        @Override
        public TelephonyEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block46: while (true) {
                int tag = input.readTag();
                block0 : switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block46;
                        return this;
                    }
                    case 8: {
                        this.timestampMillis = input.readInt64();
                        break;
                    }
                    case 16: {
                        this.phoneId = input.readInt32();
                        break;
                    }
                    case 24: {
                        int initialPos = input.getPosition();
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 21: {
                                this.type = value;
                                break block0;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                        break;
                    }
                    case 34: {
                        if (this.settings == null) {
                            this.settings = new TelephonySettings();
                        }
                        input.readMessage(this.settings);
                        break;
                    }
                    case 42: {
                        if (this.serviceState == null) {
                            this.serviceState = new TelephonyServiceState();
                        }
                        input.readMessage(this.serviceState);
                        break;
                    }
                    case 50: {
                        if (this.imsConnectionState == null) {
                            this.imsConnectionState = new ImsConnectionState();
                        }
                        input.readMessage(this.imsConnectionState);
                        break;
                    }
                    case 58: {
                        if (this.imsCapabilities == null) {
                            this.imsCapabilities = new ImsCapabilities();
                        }
                        input.readMessage(this.imsCapabilities);
                        break;
                    }
                    case 66: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 66);
                        int i = this.dataCalls == null ? 0 : this.dataCalls.length;
                        RilDataCall[] newArray = new RilDataCall[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.dataCalls, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new RilDataCall();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new RilDataCall();
                        input.readMessage(newArray[i]);
                        this.dataCalls = newArray;
                        break;
                    }
                    case 72: {
                        int initialPos = input.getPosition();
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: 
                            case 26: 
                            case 27: 
                            case 28: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: {
                                this.error = value;
                                break block0;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                        break;
                    }
                    case 82: {
                        if (this.setupDataCall == null) {
                            this.setupDataCall = new RilSetupDataCall();
                        }
                        input.readMessage(this.setupDataCall);
                        break;
                    }
                    case 90: {
                        if (this.setupDataCallResponse == null) {
                            this.setupDataCallResponse = new RilSetupDataCallResponse();
                        }
                        input.readMessage(this.setupDataCallResponse);
                        break;
                    }
                    case 98: {
                        if (this.deactivateDataCall == null) {
                            this.deactivateDataCall = new RilDeactivateDataCall();
                        }
                        input.readMessage(this.deactivateDataCall);
                        break;
                    }
                    case 104: {
                        this.dataStallAction = input.readInt32();
                        break;
                    }
                    case 114: {
                        if (this.modemRestart == null) {
                            this.modemRestart = new ModemRestart();
                        }
                        input.readMessage(this.modemRestart);
                        break;
                    }
                    case 120: {
                        this.nitzTimestampMillis = input.readInt64();
                        break;
                    }
                    case 130: {
                        if (this.carrierIdMatching == null) {
                            this.carrierIdMatching = new CarrierIdMatching();
                        }
                        input.readMessage(this.carrierIdMatching);
                        break;
                    }
                    case 138: {
                        if (this.carrierKeyChange == null) {
                            this.carrierKeyChange = new CarrierKeyChange();
                        }
                        input.readMessage(this.carrierKeyChange);
                        break;
                    }
                    case 154: {
                        if (this.dataSwitch == null) {
                            this.dataSwitch = new DataSwitch();
                        }
                        input.readMessage(this.dataSwitch);
                        break;
                    }
                    case 160: {
                        int initialPos = input.getPosition();
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.networkValidationState = value;
                                break block0;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                        break;
                    }
                    case 170: {
                        if (this.onDemandDataSwitch == null) {
                            this.onDemandDataSwitch = new OnDemandDataSwitch();
                        }
                        input.readMessage(this.onDemandDataSwitch);
                        break;
                    }
                    case 176: {
                        int i;
                        int length = WireFormatNano.getRepeatedFieldArrayLength(input, 176);
                        int[] validValues = new int[length];
                        int validCount = 0;
                        block48: for (i = 0; i < length; ++i) {
                            if (i != 0) {
                                input.readTag();
                            }
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    validValues[validCount++] = value;
                                    continue block48;
                                }
                                default: {
                                    input.rewindToPosition(initialPos);
                                    this.storeUnknownField(input, tag);
                                }
                            }
                        }
                        if (validCount == 0) continue block46;
                        int n = i = this.simState == null ? 0 : this.simState.length;
                        if (i == 0 && validCount == validValues.length) {
                            this.simState = validValues;
                            break;
                        }
                        int[] newArray = new int[i + validCount];
                        if (i != 0) {
                            System.arraycopy(this.simState, 0, newArray, 0, i);
                        }
                        System.arraycopy(validValues, 0, newArray, i, validCount);
                        this.simState = newArray;
                        break;
                    }
                    case 178: {
                        int bytes = input.readRawVarint32();
                        int limit = input.pushLimit(bytes);
                        int arrayLength = 0;
                        int startPos = input.getPosition();
                        while (input.getBytesUntilLimit() > 0) {
                            switch (input.readInt32()) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    ++arrayLength;
                                }
                            }
                        }
                        if (arrayLength != 0) {
                            input.rewindToPosition(startPos);
                            int i = this.simState == null ? 0 : this.simState.length;
                            int[] newArray = new int[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.simState, 0, newArray, 0, i);
                            }
                            block50: while (input.getBytesUntilLimit() > 0) {
                                int initialPos = input.getPosition();
                                int value = input.readInt32();
                                switch (value) {
                                    case 0: 
                                    case 1: 
                                    case 2: {
                                        newArray[i++] = value;
                                        continue block50;
                                    }
                                }
                                input.rewindToPosition(initialPos);
                                this.storeUnknownField(input, 176);
                            }
                            this.simState = newArray;
                        }
                        input.popLimit(limit);
                        break;
                    }
                    case 186: {
                        if (this.activeSubscriptionInfo == null) {
                            this.activeSubscriptionInfo = new ActiveSubscriptionInfo();
                        }
                        input.readMessage(this.activeSubscriptionInfo);
                        break;
                    }
                    case 192: {
                        this.enabledModemBitmap = input.readInt32();
                        break;
                    }
                    case 202: {
                        if (this.updatedEmergencyNumber == null) {
                            this.updatedEmergencyNumber = new EmergencyNumberInfo();
                        }
                        input.readMessage(this.updatedEmergencyNumber);
                    }
                }
            }
        }

        public static TelephonyEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new TelephonyEvent(), data);
        }

        public static TelephonyEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new TelephonyEvent().mergeFrom(input);
        }

        public static final class CarrierIdMatchingResult
        extends ExtendableMessageNano<CarrierIdMatchingResult> {
            private static volatile CarrierIdMatchingResult[] _emptyArray;
            public int carrierId;
            public String unknownGid1;
            public String unknownMccmnc;
            public String mccmnc;
            public String gid1;
            public String gid2;
            public String spn;
            public String pnn;
            public String iccidPrefix;
            public String imsiPrefix;
            public String[] privilegeAccessRule;
            public String preferApn;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static CarrierIdMatchingResult[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new CarrierIdMatchingResult[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public CarrierIdMatchingResult() {
                this.clear();
            }

            public CarrierIdMatchingResult clear() {
                this.carrierId = 0;
                this.unknownGid1 = "";
                this.unknownMccmnc = "";
                this.mccmnc = "";
                this.gid1 = "";
                this.gid2 = "";
                this.spn = "";
                this.pnn = "";
                this.iccidPrefix = "";
                this.imsiPrefix = "";
                this.privilegeAccessRule = WireFormatNano.EMPTY_STRING_ARRAY;
                this.preferApn = "";
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.carrierId != 0) {
                    output.writeInt32(1, this.carrierId);
                }
                if (!this.unknownGid1.equals("")) {
                    output.writeString(2, this.unknownGid1);
                }
                if (!this.unknownMccmnc.equals("")) {
                    output.writeString(3, this.unknownMccmnc);
                }
                if (!this.mccmnc.equals("")) {
                    output.writeString(4, this.mccmnc);
                }
                if (!this.gid1.equals("")) {
                    output.writeString(5, this.gid1);
                }
                if (!this.gid2.equals("")) {
                    output.writeString(6, this.gid2);
                }
                if (!this.spn.equals("")) {
                    output.writeString(7, this.spn);
                }
                if (!this.pnn.equals("")) {
                    output.writeString(8, this.pnn);
                }
                if (!this.iccidPrefix.equals("")) {
                    output.writeString(9, this.iccidPrefix);
                }
                if (!this.imsiPrefix.equals("")) {
                    output.writeString(10, this.imsiPrefix);
                }
                if (this.privilegeAccessRule != null && this.privilegeAccessRule.length > 0) {
                    for (int i = 0; i < this.privilegeAccessRule.length; ++i) {
                        String element = this.privilegeAccessRule[i];
                        if (element == null) continue;
                        output.writeString(11, element);
                    }
                }
                if (!this.preferApn.equals("")) {
                    output.writeString(12, this.preferApn);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.carrierId != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.carrierId);
                }
                if (!this.unknownGid1.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(2, this.unknownGid1);
                }
                if (!this.unknownMccmnc.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(3, this.unknownMccmnc);
                }
                if (!this.mccmnc.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(4, this.mccmnc);
                }
                if (!this.gid1.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(5, this.gid1);
                }
                if (!this.gid2.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(6, this.gid2);
                }
                if (!this.spn.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(7, this.spn);
                }
                if (!this.pnn.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(8, this.pnn);
                }
                if (!this.iccidPrefix.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(9, this.iccidPrefix);
                }
                if (!this.imsiPrefix.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(10, this.imsiPrefix);
                }
                if (this.privilegeAccessRule != null && this.privilegeAccessRule.length > 0) {
                    int dataCount = 0;
                    int dataSize = 0;
                    for (int i = 0; i < this.privilegeAccessRule.length; ++i) {
                        String element = this.privilegeAccessRule[i];
                        if (element == null) continue;
                        ++dataCount;
                        dataSize += CodedOutputByteBufferNano.computeStringSizeNoTag(element);
                    }
                    size += dataSize;
                    size += 1 * dataCount;
                }
                if (!this.preferApn.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(12, this.preferApn);
                }
                return size;
            }

            @Override
            public CarrierIdMatchingResult mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block15: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block15;
                            return this;
                        }
                        case 8: {
                            this.carrierId = input.readInt32();
                            continue block15;
                        }
                        case 18: {
                            this.unknownGid1 = input.readString();
                            continue block15;
                        }
                        case 26: {
                            this.unknownMccmnc = input.readString();
                            continue block15;
                        }
                        case 34: {
                            this.mccmnc = input.readString();
                            continue block15;
                        }
                        case 42: {
                            this.gid1 = input.readString();
                            continue block15;
                        }
                        case 50: {
                            this.gid2 = input.readString();
                            continue block15;
                        }
                        case 58: {
                            this.spn = input.readString();
                            continue block15;
                        }
                        case 66: {
                            this.pnn = input.readString();
                            continue block15;
                        }
                        case 74: {
                            this.iccidPrefix = input.readString();
                            continue block15;
                        }
                        case 82: {
                            this.imsiPrefix = input.readString();
                            continue block15;
                        }
                        case 90: {
                            int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 90);
                            int i = this.privilegeAccessRule == null ? 0 : this.privilegeAccessRule.length;
                            String[] newArray = new String[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.privilegeAccessRule, 0, newArray, 0, i);
                            }
                            while (i < newArray.length - 1) {
                                newArray[i] = input.readString();
                                input.readTag();
                                ++i;
                            }
                            newArray[i] = input.readString();
                            this.privilegeAccessRule = newArray;
                            continue block15;
                        }
                        case 98: 
                    }
                    this.preferApn = input.readString();
                }
            }

            public static CarrierIdMatchingResult parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new CarrierIdMatchingResult(), data);
            }

            public static CarrierIdMatchingResult parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new CarrierIdMatchingResult().mergeFrom(input);
            }
        }

        public static final class CarrierIdMatching
        extends ExtendableMessageNano<CarrierIdMatching> {
            private static volatile CarrierIdMatching[] _emptyArray;
            public int cidTableVersion;
            public CarrierIdMatchingResult result;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static CarrierIdMatching[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new CarrierIdMatching[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public CarrierIdMatching() {
                this.clear();
            }

            public CarrierIdMatching clear() {
                this.cidTableVersion = 0;
                this.result = null;
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.cidTableVersion != 0) {
                    output.writeInt32(1, this.cidTableVersion);
                }
                if (this.result != null) {
                    output.writeMessage(2, this.result);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.cidTableVersion != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.cidTableVersion);
                }
                if (this.result != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(2, this.result);
                }
                return size;
            }

            @Override
            public CarrierIdMatching mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block5: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block5;
                            return this;
                        }
                        case 8: {
                            this.cidTableVersion = input.readInt32();
                            continue block5;
                        }
                        case 18: 
                    }
                    if (this.result == null) {
                        this.result = new CarrierIdMatchingResult();
                    }
                    input.readMessage(this.result);
                }
            }

            public static CarrierIdMatching parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new CarrierIdMatching(), data);
            }

            public static CarrierIdMatching parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new CarrierIdMatching().mergeFrom(input);
            }
        }

        public static final class ModemRestart
        extends ExtendableMessageNano<ModemRestart> {
            private static volatile ModemRestart[] _emptyArray;
            public String basebandVersion;
            public String reason;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static ModemRestart[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new ModemRestart[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public ModemRestart() {
                this.clear();
            }

            public ModemRestart clear() {
                this.basebandVersion = "";
                this.reason = "";
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (!this.basebandVersion.equals("")) {
                    output.writeString(1, this.basebandVersion);
                }
                if (!this.reason.equals("")) {
                    output.writeString(2, this.reason);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (!this.basebandVersion.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(1, this.basebandVersion);
                }
                if (!this.reason.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(2, this.reason);
                }
                return size;
            }

            @Override
            public ModemRestart mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block5: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block5;
                            return this;
                        }
                        case 10: {
                            this.basebandVersion = input.readString();
                            continue block5;
                        }
                        case 18: 
                    }
                    this.reason = input.readString();
                }
            }

            public static ModemRestart parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new ModemRestart(), data);
            }

            public static ModemRestart parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new ModemRestart().mergeFrom(input);
            }
        }

        public static final class RilDeactivateDataCall
        extends ExtendableMessageNano<RilDeactivateDataCall> {
            private static volatile RilDeactivateDataCall[] _emptyArray;
            public int cid;
            public int reason;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static RilDeactivateDataCall[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new RilDeactivateDataCall[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public RilDeactivateDataCall() {
                this.clear();
            }

            public RilDeactivateDataCall clear() {
                this.cid = 0;
                this.reason = 0;
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.cid != 0) {
                    output.writeInt32(1, this.cid);
                }
                if (this.reason != 0) {
                    output.writeInt32(2, this.reason);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.cid != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.cid);
                }
                if (this.reason != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.reason);
                }
                return size;
            }

            @Override
            public RilDeactivateDataCall mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block8: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block8;
                            return this;
                        }
                        case 8: {
                            this.cid = input.readInt32();
                            continue block8;
                        }
                        case 16: 
                    }
                    int initialPos = input.getPosition();
                    int value = input.readInt32();
                    switch (value) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            this.reason = value;
                            continue block8;
                        }
                    }
                    input.rewindToPosition(initialPos);
                    this.storeUnknownField(input, tag);
                }
            }

            public static RilDeactivateDataCall parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new RilDeactivateDataCall(), data);
            }

            public static RilDeactivateDataCall parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new RilDeactivateDataCall().mergeFrom(input);
            }

            public static interface DeactivateReason {
                public static final int DEACTIVATE_REASON_UNKNOWN = 0;
                public static final int DEACTIVATE_REASON_NONE = 1;
                public static final int DEACTIVATE_REASON_RADIO_OFF = 2;
                public static final int DEACTIVATE_REASON_PDP_RESET = 3;
                public static final int DEACTIVATE_REASON_HANDOVER = 4;
            }
        }

        public static final class CarrierKeyChange
        extends ExtendableMessageNano<CarrierKeyChange> {
            private static volatile CarrierKeyChange[] _emptyArray;
            public int keyType;
            public boolean isDownloadSuccessful;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static CarrierKeyChange[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new CarrierKeyChange[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public CarrierKeyChange() {
                this.clear();
            }

            public CarrierKeyChange clear() {
                this.keyType = 0;
                this.isDownloadSuccessful = false;
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.keyType != 0) {
                    output.writeInt32(1, this.keyType);
                }
                if (this.isDownloadSuccessful) {
                    output.writeBool(2, this.isDownloadSuccessful);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.keyType != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.keyType);
                }
                if (this.isDownloadSuccessful) {
                    size += CodedOutputByteBufferNano.computeBoolSize(2, this.isDownloadSuccessful);
                }
                return size;
            }

            @Override
            public CarrierKeyChange mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block8: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block8;
                            return this;
                        }
                        case 8: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    this.keyType = value;
                                    continue block8;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block8;
                        }
                        case 16: 
                    }
                    this.isDownloadSuccessful = input.readBool();
                }
            }

            public static CarrierKeyChange parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new CarrierKeyChange(), data);
            }

            public static CarrierKeyChange parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new CarrierKeyChange().mergeFrom(input);
            }

            public static interface KeyType {
                public static final int UNKNOWN = 0;
                public static final int WLAN = 1;
                public static final int EPDG = 2;
            }
        }

        public static final class RilSetupDataCallResponse
        extends ExtendableMessageNano<RilSetupDataCallResponse> {
            private static volatile RilSetupDataCallResponse[] _emptyArray;
            public int status;
            public int suggestedRetryTimeMillis;
            public RilDataCall call;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static RilSetupDataCallResponse[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new RilSetupDataCallResponse[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public RilSetupDataCallResponse() {
                this.clear();
            }

            public RilSetupDataCallResponse clear() {
                this.status = 0;
                this.suggestedRetryTimeMillis = 0;
                this.call = null;
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.status != 0) {
                    output.writeInt32(1, this.status);
                }
                if (this.suggestedRetryTimeMillis != 0) {
                    output.writeInt32(2, this.suggestedRetryTimeMillis);
                }
                if (this.call != null) {
                    output.writeMessage(3, this.call);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.status != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.status);
                }
                if (this.suggestedRetryTimeMillis != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.suggestedRetryTimeMillis);
                }
                if (this.call != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(3, this.call);
                }
                return size;
            }

            @Override
            public RilSetupDataCallResponse mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block9: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block9;
                            return this;
                        }
                        case 8: {
                            int initialPos = input.getPosition();
                            int value = input.readInt32();
                            switch (value) {
                                case -6: 
                                case -5: 
                                case -4: 
                                case -3: 
                                case -2: 
                                case -1: 
                                case 0: 
                                case 1: 
                                case 8: 
                                case 14: 
                                case 25: 
                                case 26: 
                                case 27: 
                                case 28: 
                                case 29: 
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 39: 
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 48: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 58: 
                                case 59: 
                                case 60: 
                                case 65: 
                                case 66: 
                                case 81: 
                                case 95: 
                                case 96: 
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 111: 
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 117: 
                                case 118: 
                                case 119: 
                                case 120: 
                                case 121: 
                                case 122: 
                                case 123: 
                                case 124: 
                                case 127: 
                                case 128: 
                                case 2000: 
                                case 2001: 
                                case 2002: 
                                case 2003: 
                                case 2004: 
                                case 2005: 
                                case 2006: 
                                case 2007: 
                                case 2008: 
                                case 2009: 
                                case 2010: 
                                case 2011: 
                                case 2012: 
                                case 2013: 
                                case 2014: 
                                case 2015: 
                                case 2016: 
                                case 2017: 
                                case 2018: 
                                case 2019: 
                                case 2020: 
                                case 2021: 
                                case 2022: 
                                case 2023: 
                                case 2024: 
                                case 2025: 
                                case 2026: 
                                case 2027: 
                                case 2028: 
                                case 2029: 
                                case 2030: 
                                case 2031: 
                                case 2032: 
                                case 2033: 
                                case 2034: 
                                case 2035: 
                                case 2036: 
                                case 2037: 
                                case 2038: 
                                case 2039: 
                                case 2040: 
                                case 2041: 
                                case 2042: 
                                case 2043: 
                                case 2044: 
                                case 2045: 
                                case 2046: 
                                case 2047: 
                                case 2048: 
                                case 2049: 
                                case 2050: 
                                case 2051: 
                                case 2052: 
                                case 2053: 
                                case 2054: 
                                case 2055: 
                                case 2056: 
                                case 2057: 
                                case 2058: 
                                case 2059: 
                                case 2060: 
                                case 2061: 
                                case 2062: 
                                case 2063: 
                                case 2064: 
                                case 2065: 
                                case 2066: 
                                case 2067: 
                                case 2068: 
                                case 2069: 
                                case 2070: 
                                case 2071: 
                                case 2072: 
                                case 2073: 
                                case 2074: 
                                case 2075: 
                                case 2076: 
                                case 2077: 
                                case 2078: 
                                case 2079: 
                                case 2080: 
                                case 2081: 
                                case 2082: 
                                case 2083: 
                                case 2084: 
                                case 2085: 
                                case 2086: 
                                case 2087: 
                                case 2088: 
                                case 2089: 
                                case 2090: 
                                case 2091: 
                                case 2092: 
                                case 2093: 
                                case 2094: 
                                case 2095: 
                                case 2096: 
                                case 2097: 
                                case 2098: 
                                case 2099: 
                                case 2100: 
                                case 2101: 
                                case 2102: 
                                case 2103: 
                                case 2104: 
                                case 2105: 
                                case 2106: 
                                case 2107: 
                                case 2108: 
                                case 2109: 
                                case 2110: 
                                case 2111: 
                                case 2112: 
                                case 2113: 
                                case 2114: 
                                case 2115: 
                                case 2116: 
                                case 2117: 
                                case 2118: 
                                case 2119: 
                                case 2120: 
                                case 2121: 
                                case 2122: 
                                case 2123: 
                                case 2124: 
                                case 2125: 
                                case 2126: 
                                case 2127: 
                                case 2128: 
                                case 2129: 
                                case 2130: 
                                case 2131: 
                                case 2132: 
                                case 2133: 
                                case 2134: 
                                case 2135: 
                                case 2136: 
                                case 2137: 
                                case 2138: 
                                case 2139: 
                                case 2140: 
                                case 2141: 
                                case 2142: 
                                case 2143: 
                                case 2144: 
                                case 2145: 
                                case 2146: 
                                case 2147: 
                                case 2148: 
                                case 2149: 
                                case 2150: 
                                case 2151: 
                                case 2152: 
                                case 2153: 
                                case 2154: 
                                case 2155: 
                                case 2156: 
                                case 2157: 
                                case 2158: 
                                case 2159: 
                                case 2160: 
                                case 2161: 
                                case 2162: 
                                case 2163: 
                                case 2164: 
                                case 2165: 
                                case 2166: 
                                case 2167: 
                                case 2168: 
                                case 2169: 
                                case 2170: 
                                case 2171: 
                                case 2172: 
                                case 2173: 
                                case 2174: 
                                case 2175: 
                                case 2176: 
                                case 2177: 
                                case 2178: 
                                case 2179: 
                                case 2180: 
                                case 2181: 
                                case 2182: 
                                case 2183: 
                                case 2184: 
                                case 2185: 
                                case 2186: 
                                case 2187: 
                                case 2188: 
                                case 2189: 
                                case 2190: 
                                case 2191: 
                                case 2192: 
                                case 2193: 
                                case 2194: 
                                case 2195: 
                                case 2196: 
                                case 2197: 
                                case 2198: 
                                case 2199: 
                                case 2200: 
                                case 2201: 
                                case 2202: 
                                case 2203: 
                                case 2204: 
                                case 2205: 
                                case 2206: 
                                case 2207: 
                                case 2208: 
                                case 2209: 
                                case 2210: 
                                case 2211: 
                                case 2212: 
                                case 2213: 
                                case 2214: 
                                case 2215: 
                                case 2216: 
                                case 2217: 
                                case 2218: 
                                case 2219: 
                                case 2220: 
                                case 2221: 
                                case 2222: 
                                case 2223: 
                                case 2224: 
                                case 2225: 
                                case 2226: 
                                case 2227: 
                                case 2228: 
                                case 2229: 
                                case 2230: 
                                case 2231: 
                                case 2232: 
                                case 2233: 
                                case 2234: 
                                case 2235: 
                                case 2236: 
                                case 2237: 
                                case 2238: 
                                case 2239: 
                                case 2240: 
                                case 2241: 
                                case 2242: 
                                case 2243: 
                                case 2244: 
                                case 2245: 
                                case 2246: 
                                case 2247: 
                                case 2248: 
                                case 2249: 
                                case 2250: 
                                case 2251: 
                                case 65535: {
                                    this.status = value;
                                    continue block9;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block9;
                        }
                        case 16: {
                            this.suggestedRetryTimeMillis = input.readInt32();
                            continue block9;
                        }
                        case 26: 
                    }
                    if (this.call == null) {
                        this.call = new RilDataCall();
                    }
                    input.readMessage(this.call);
                }
            }

            public static RilSetupDataCallResponse parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new RilSetupDataCallResponse(), data);
            }

            public static RilSetupDataCallResponse parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new RilSetupDataCallResponse().mergeFrom(input);
            }

            public static interface RilDataCallFailCause {
                public static final int PDP_FAIL_UNKNOWN = 0;
                public static final int PDP_FAIL_NONE = 1;
                public static final int PDP_FAIL_OPERATOR_BARRED = 8;
                public static final int PDP_FAIL_NAS_SIGNALLING = 14;
                public static final int PDP_FAIL_LLC_SNDCP = 25;
                public static final int PDP_FAIL_INSUFFICIENT_RESOURCES = 26;
                public static final int PDP_FAIL_MISSING_UKNOWN_APN = 27;
                public static final int PDP_FAIL_UNKNOWN_PDP_ADDRESS_TYPE = 28;
                public static final int PDP_FAIL_USER_AUTHENTICATION = 29;
                public static final int PDP_FAIL_ACTIVATION_REJECT_GGSN = 30;
                public static final int PDP_FAIL_ACTIVATION_REJECT_UNSPECIFIED = 31;
                public static final int PDP_FAIL_SERVICE_OPTION_NOT_SUPPORTED = 32;
                public static final int PDP_FAIL_SERVICE_OPTION_NOT_SUBSCRIBED = 33;
                public static final int PDP_FAIL_SERVICE_OPTION_OUT_OF_ORDER = 34;
                public static final int PDP_FAIL_NSAPI_IN_USE = 35;
                public static final int PDP_FAIL_REGULAR_DEACTIVATION = 36;
                public static final int PDP_FAIL_QOS_NOT_ACCEPTED = 37;
                public static final int PDP_FAIL_NETWORK_FAILURE = 38;
                public static final int PDP_FAIL_UMTS_REACTIVATION_REQ = 39;
                public static final int PDP_FAIL_FEATURE_NOT_SUPP = 40;
                public static final int PDP_FAIL_TFT_SEMANTIC_ERROR = 41;
                public static final int PDP_FAIL_TFT_SYTAX_ERROR = 42;
                public static final int PDP_FAIL_UNKNOWN_PDP_CONTEXT = 43;
                public static final int PDP_FAIL_FILTER_SEMANTIC_ERROR = 44;
                public static final int PDP_FAIL_FILTER_SYTAX_ERROR = 45;
                public static final int PDP_FAIL_PDP_WITHOUT_ACTIVE_TFT = 46;
                public static final int PDP_FAIL_ACTIVATION_REJECTED_BCM_VIOLATION = 48;
                public static final int PDP_FAIL_ONLY_IPV4_ALLOWED = 50;
                public static final int PDP_FAIL_ONLY_IPV6_ALLOWED = 51;
                public static final int PDP_FAIL_ONLY_SINGLE_BEARER_ALLOWED = 52;
                public static final int PDP_FAIL_ESM_INFO_NOT_RECEIVED = 53;
                public static final int PDP_FAIL_PDN_CONN_DOES_NOT_EXIST = 54;
                public static final int PDP_FAIL_MULTI_CONN_TO_SAME_PDN_NOT_ALLOWED = 55;
                public static final int PDP_FAIL_COLLISION_WITH_NETWORK_INITIATED_REQUEST = 56;
                public static final int PDP_FAIL_ONLY_IPV4V6_ALLOWED = 57;
                public static final int PDP_FAIL_ONLY_NON_IP_ALLOWED = 58;
                public static final int PDP_FAIL_UNSUPPORTED_QCI_VALUE = 59;
                public static final int PDP_FAIL_BEARER_HANDLING_NOT_SUPPORTED = 60;
                public static final int PDP_FAIL_MAX_ACTIVE_PDP_CONTEXT_REACHED = 65;
                public static final int PDP_FAIL_UNSUPPORTED_APN_IN_CURRENT_PLMN = 66;
                public static final int PDP_FAIL_INVALID_TRANSACTION_ID = 81;
                public static final int PDP_FAIL_MESSAGE_INCORRECT_SEMANTIC = 95;
                public static final int PDP_FAIL_INVALID_MANDATORY_INFO = 96;
                public static final int PDP_FAIL_MESSAGE_TYPE_UNSUPPORTED = 97;
                public static final int PDP_FAIL_MSG_TYPE_NONCOMPATIBLE_STATE = 98;
                public static final int PDP_FAIL_UNKNOWN_INFO_ELEMENT = 99;
                public static final int PDP_FAIL_CONDITIONAL_IE_ERROR = 100;
                public static final int PDP_FAIL_MSG_AND_PROTOCOL_STATE_UNCOMPATIBLE = 101;
                public static final int PDP_FAIL_PROTOCOL_ERRORS = 111;
                public static final int PDP_FAIL_APN_TYPE_CONFLICT = 112;
                public static final int PDP_FAIL_INVALID_PCSCF_ADDR = 113;
                public static final int PDP_FAIL_INTERNAL_CALL_PREEMPT_BY_HIGH_PRIO_APN = 114;
                public static final int PDP_FAIL_EMM_ACCESS_BARRED = 115;
                public static final int PDP_FAIL_EMERGENCY_IFACE_ONLY = 116;
                public static final int PDP_FAIL_IFACE_MISMATCH = 117;
                public static final int PDP_FAIL_COMPANION_IFACE_IN_USE = 118;
                public static final int PDP_FAIL_IP_ADDRESS_MISMATCH = 119;
                public static final int PDP_FAIL_IFACE_AND_POL_FAMILY_MISMATCH = 120;
                public static final int PDP_FAIL_EMM_ACCESS_BARRED_INFINITE_RETRY = 121;
                public static final int PDP_FAIL_AUTH_FAILURE_ON_EMERGENCY_CALL = 122;
                public static final int PDP_FAIL_INVALID_DNS_ADDR = 123;
                public static final int PDP_FAIL_INVALID_PCSCF_OR_DNS_ADDRESS = 124;
                public static final int PDP_FAIL_CALL_PREEMPT_BY_EMERGENCY_APN = 127;
                public static final int PDP_FAIL_UE_INITIATED_DETACH_OR_DISCONNECT = 128;
                public static final int PDP_FAIL_MIP_FA_REASON_UNSPECIFIED = 2000;
                public static final int PDP_FAIL_MIP_FA_ADMIN_PROHIBITED = 2001;
                public static final int PDP_FAIL_MIP_FA_INSUFFICIENT_RESOURCES = 2002;
                public static final int PDP_FAIL_MIP_FA_MOBILE_NODE_AUTHENTICATION_FAILURE = 2003;
                public static final int PDP_FAIL_MIP_FA_HOME_AGENT_AUTHENTICATION_FAILURE = 2004;
                public static final int PDP_FAIL_MIP_FA_REQUESTED_LIFETIME_TOO_LONG = 2005;
                public static final int PDP_FAIL_MIP_FA_MALFORMED_REQUEST = 2006;
                public static final int PDP_FAIL_MIP_FA_MALFORMED_REPLY = 2007;
                public static final int PDP_FAIL_MIP_FA_ENCAPSULATION_UNAVAILABLE = 2008;
                public static final int PDP_FAIL_MIP_FA_VJ_HEADER_COMPRESSION_UNAVAILABLE = 2009;
                public static final int PDP_FAIL_MIP_FA_REVERSE_TUNNEL_UNAVAILABLE = 2010;
                public static final int PDP_FAIL_MIP_FA_REVERSE_TUNNEL_IS_MANDATORY = 2011;
                public static final int PDP_FAIL_MIP_FA_DELIVERY_STYLE_NOT_SUPPORTED = 2012;
                public static final int PDP_FAIL_MIP_FA_MISSING_NAI = 2013;
                public static final int PDP_FAIL_MIP_FA_MISSING_HOME_AGENT = 2014;
                public static final int PDP_FAIL_MIP_FA_MISSING_HOME_ADDRESS = 2015;
                public static final int PDP_FAIL_MIP_FA_UNKNOWN_CHALLENGE = 2016;
                public static final int PDP_FAIL_MIP_FA_MISSING_CHALLENGE = 2017;
                public static final int PDP_FAIL_MIP_FA_STALE_CHALLENGE = 2018;
                public static final int PDP_FAIL_MIP_HA_REASON_UNSPECIFIED = 2019;
                public static final int PDP_FAIL_MIP_HA_ADMIN_PROHIBITED = 2020;
                public static final int PDP_FAIL_MIP_HA_INSUFFICIENT_RESOURCES = 2021;
                public static final int PDP_FAIL_MIP_HA_MOBILE_NODE_AUTHENTICATION_FAILURE = 2022;
                public static final int PDP_FAIL_MIP_HA_FOREIGN_AGENT_AUTHENTICATION_FAILURE = 2023;
                public static final int PDP_FAIL_MIP_HA_REGISTRATION_ID_MISMATCH = 2024;
                public static final int PDP_FAIL_MIP_HA_MALFORMED_REQUEST = 2025;
                public static final int PDP_FAIL_MIP_HA_UNKNOWN_HOME_AGENT_ADDRESS = 2026;
                public static final int PDP_FAIL_MIP_HA_REVERSE_TUNNEL_UNAVAILABLE = 2027;
                public static final int PDP_FAIL_MIP_HA_REVERSE_TUNNEL_IS_MANDATORY = 2028;
                public static final int PDP_FAIL_MIP_HA_ENCAPSULATION_UNAVAILABLE = 2029;
                public static final int PDP_FAIL_CLOSE_IN_PROGRESS = 2030;
                public static final int PDP_FAIL_NETWORK_INITIATED_TERMINATION = 2031;
                public static final int PDP_FAIL_MODEM_APP_PREEMPTED = 2032;
                public static final int PDP_FAIL_PDN_IPV4_CALL_DISALLOWED = 2033;
                public static final int PDP_FAIL_PDN_IPV4_CALL_THROTTLED = 2034;
                public static final int PDP_FAIL_PDN_IPV6_CALL_DISALLOWED = 2035;
                public static final int PDP_FAIL_PDN_IPV6_CALL_THROTTLED = 2036;
                public static final int PDP_FAIL_MODEM_RESTART = 2037;
                public static final int PDP_FAIL_PDP_PPP_NOT_SUPPORTED = 2038;
                public static final int PDP_FAIL_UNPREFERRED_RAT = 2039;
                public static final int PDP_FAIL_PHYSICAL_LINK_CLOSE_IN_PROGRESS = 2040;
                public static final int PDP_FAIL_APN_PENDING_HANDOVER = 2041;
                public static final int PDP_FAIL_PROFILE_BEARER_INCOMPATIBLE = 2042;
                public static final int PDP_FAIL_SIM_CARD_CHANGED = 2043;
                public static final int PDP_FAIL_LOW_POWER_MODE_OR_POWERING_DOWN = 2044;
                public static final int PDP_FAIL_APN_DISABLED = 2045;
                public static final int PDP_FAIL_MAX_PPP_INACTIVITY_TIMER_EXPIRED = 2046;
                public static final int PDP_FAIL_IPV6_ADDRESS_TRANSFER_FAILED = 2047;
                public static final int PDP_FAIL_TRAT_SWAP_FAILED = 2048;
                public static final int PDP_FAIL_EHRPD_TO_HRPD_FALLBACK = 2049;
                public static final int PDP_FAIL_MIP_CONFIG_FAILURE = 2050;
                public static final int PDP_FAIL_PDN_INACTIVITY_TIMER_EXPIRED = 2051;
                public static final int PDP_FAIL_MAX_IPV4_CONNECTIONS = 2052;
                public static final int PDP_FAIL_MAX_IPV6_CONNECTIONS = 2053;
                public static final int PDP_FAIL_APN_MISMATCH = 2054;
                public static final int PDP_FAIL_IP_VERSION_MISMATCH = 2055;
                public static final int PDP_FAIL_DUN_CALL_DISALLOWED = 2056;
                public static final int PDP_FAIL_INTERNAL_EPC_NONEPC_TRANSITION = 2057;
                public static final int PDP_FAIL_INTERFACE_IN_USE = 2058;
                public static final int PDP_FAIL_APN_DISALLOWED_ON_ROAMING = 2059;
                public static final int PDP_FAIL_APN_PARAMETERS_CHANGED = 2060;
                public static final int PDP_FAIL_NULL_APN_DISALLOWED = 2061;
                public static final int PDP_FAIL_THERMAL_MITIGATION = 2062;
                public static final int PDP_FAIL_DATA_SETTINGS_DISABLED = 2063;
                public static final int PDP_FAIL_DATA_ROAMING_SETTINGS_DISABLED = 2064;
                public static final int PDP_FAIL_DDS_SWITCHED = 2065;
                public static final int PDP_FAIL_FORBIDDEN_APN_NAME = 2066;
                public static final int PDP_FAIL_DDS_SWITCH_IN_PROGRESS = 2067;
                public static final int PDP_FAIL_CALL_DISALLOWED_IN_ROAMING = 2068;
                public static final int PDP_FAIL_NON_IP_NOT_SUPPORTED = 2069;
                public static final int PDP_FAIL_PDN_NON_IP_CALL_THROTTLED = 2070;
                public static final int PDP_FAIL_PDN_NON_IP_CALL_DISALLOWED = 2071;
                public static final int PDP_FAIL_CDMA_LOCK = 2072;
                public static final int PDP_FAIL_CDMA_INTERCEPT = 2073;
                public static final int PDP_FAIL_CDMA_REORDER = 2074;
                public static final int PDP_FAIL_CDMA_RELEASE_DUE_TO_SO_REJECTION = 2075;
                public static final int PDP_FAIL_CDMA_INCOMING_CALL = 2076;
                public static final int PDP_FAIL_CDMA_ALERT_STOP = 2077;
                public static final int PDP_FAIL_CHANNEL_ACQUISITION_FAILURE = 2078;
                public static final int PDP_FAIL_MAX_ACCESS_PROBE = 2079;
                public static final int PDP_FAIL_CONCURRENT_SERVICE_NOT_SUPPORTED_BY_BASE_STATION = 2080;
                public static final int PDP_FAIL_NO_RESPONSE_FROM_BASE_STATION = 2081;
                public static final int PDP_FAIL_REJECTED_BY_BASE_STATION = 2082;
                public static final int PDP_FAIL_CONCURRENT_SERVICES_INCOMPATIBLE = 2083;
                public static final int PDP_FAIL_NO_CDMA_SERVICE = 2084;
                public static final int PDP_FAIL_RUIM_NOT_PRESENT = 2085;
                public static final int PDP_FAIL_CDMA_RETRY_ORDER = 2086;
                public static final int PDP_FAIL_ACCESS_BLOCK = 2087;
                public static final int PDP_FAIL_ACCESS_BLOCK_ALL = 2088;
                public static final int PDP_FAIL_IS707B_MAX_ACCESS_PROBES = 2089;
                public static final int PDP_FAIL_THERMAL_EMERGENCY = 2090;
                public static final int PDP_FAIL_CONCURRENT_SERVICES_NOT_ALLOWED = 2091;
                public static final int PDP_FAIL_INCOMING_CALL_REJECTED = 2092;
                public static final int PDP_FAIL_NO_SERVICE_ON_GATEWAY = 2093;
                public static final int PDP_FAIL_NO_GPRS_CONTEXT = 2094;
                public static final int PDP_FAIL_ILLEGAL_MS = 2095;
                public static final int PDP_FAIL_ILLEGAL_ME = 2096;
                public static final int PDP_FAIL_GPRS_SERVICES_AND_NON_GPRS_SERVICES_NOT_ALLOWED = 2097;
                public static final int PDP_FAIL_GPRS_SERVICES_NOT_ALLOWED = 2098;
                public static final int PDP_FAIL_MS_IDENTITY_CANNOT_BE_DERIVED_BY_THE_NETWORK = 2099;
                public static final int PDP_FAIL_IMPLICITLY_DETACHED = 2100;
                public static final int PDP_FAIL_PLMN_NOT_ALLOWED = 2101;
                public static final int PDP_FAIL_LOCATION_AREA_NOT_ALLOWED = 2102;
                public static final int PDP_FAIL_GPRS_SERVICES_NOT_ALLOWED_IN_THIS_PLMN = 2103;
                public static final int PDP_FAIL_PDP_DUPLICATE = 2104;
                public static final int PDP_FAIL_UE_RAT_CHANGE = 2105;
                public static final int PDP_FAIL_CONGESTION = 2106;
                public static final int PDP_FAIL_NO_PDP_CONTEXT_ACTIVATED = 2107;
                public static final int PDP_FAIL_ACCESS_CLASS_DSAC_REJECTION = 2108;
                public static final int PDP_FAIL_PDP_ACTIVATE_MAX_RETRY_FAILED = 2109;
                public static final int PDP_FAIL_RADIO_ACCESS_BEARER_FAILURE = 2110;
                public static final int PDP_FAIL_ESM_UNKNOWN_EPS_BEARER_CONTEXT = 2111;
                public static final int PDP_FAIL_DRB_RELEASED_BY_RRC = 2112;
                public static final int PDP_FAIL_CONNECTION_RELEASED = 2113;
                public static final int PDP_FAIL_EMM_DETACHED = 2114;
                public static final int PDP_FAIL_EMM_ATTACH_FAILED = 2115;
                public static final int PDP_FAIL_EMM_ATTACH_STARTED = 2116;
                public static final int PDP_FAIL_LTE_NAS_SERVICE_REQUEST_FAILED = 2117;
                public static final int PDP_FAIL_DUPLICATE_BEARER_ID = 2118;
                public static final int PDP_FAIL_ESM_COLLISION_SCENARIOS = 2119;
                public static final int PDP_FAIL_ESM_BEARER_DEACTIVATED_TO_SYNC_WITH_NETWORK = 2120;
                public static final int PDP_FAIL_ESM_NW_ACTIVATED_DED_BEARER_WITH_ID_OF_DEF_BEARER = 2121;
                public static final int PDP_FAIL_ESM_BAD_OTA_MESSAGE = 2122;
                public static final int PDP_FAIL_ESM_DOWNLOAD_SERVER_REJECTED_THE_CALL = 2123;
                public static final int PDP_FAIL_ESM_CONTEXT_TRANSFERRED_DUE_TO_IRAT = 2124;
                public static final int PDP_FAIL_DS_EXPLICIT_DEACTIVATION = 2125;
                public static final int PDP_FAIL_ESM_LOCAL_CAUSE_NONE = 2126;
                public static final int PDP_FAIL_LTE_THROTTLING_NOT_REQUIRED = 2127;
                public static final int PDP_FAIL_ACCESS_CONTROL_LIST_CHECK_FAILURE = 2128;
                public static final int PDP_FAIL_SERVICE_NOT_ALLOWED_ON_PLMN = 2129;
                public static final int PDP_FAIL_EMM_T3417_EXPIRED = 2130;
                public static final int PDP_FAIL_EMM_T3417_EXT_EXPIRED = 2131;
                public static final int PDP_FAIL_RRC_UPLINK_DATA_TRANSMISSION_FAILURE = 2132;
                public static final int PDP_FAIL_RRC_UPLINK_DELIVERY_FAILED_DUE_TO_HANDOVER = 2133;
                public static final int PDP_FAIL_RRC_UPLINK_CONNECTION_RELEASE = 2134;
                public static final int PDP_FAIL_RRC_UPLINK_RADIO_LINK_FAILURE = 2135;
                public static final int PDP_FAIL_RRC_UPLINK_ERROR_REQUEST_FROM_NAS = 2136;
                public static final int PDP_FAIL_RRC_CONNECTION_ACCESS_STRATUM_FAILURE = 2137;
                public static final int PDP_FAIL_RRC_CONNECTION_ANOTHER_PROCEDURE_IN_PROGRESS = 2138;
                public static final int PDP_FAIL_RRC_CONNECTION_ACCESS_BARRED = 2139;
                public static final int PDP_FAIL_RRC_CONNECTION_CELL_RESELECTION = 2140;
                public static final int PDP_FAIL_RRC_CONNECTION_CONFIG_FAILURE = 2141;
                public static final int PDP_FAIL_RRC_CONNECTION_TIMER_EXPIRED = 2142;
                public static final int PDP_FAIL_RRC_CONNECTION_LINK_FAILURE = 2143;
                public static final int PDP_FAIL_RRC_CONNECTION_CELL_NOT_CAMPED = 2144;
                public static final int PDP_FAIL_RRC_CONNECTION_SYSTEM_INTERVAL_FAILURE = 2145;
                public static final int PDP_FAIL_RRC_CONNECTION_REJECT_BY_NETWORK = 2146;
                public static final int PDP_FAIL_RRC_CONNECTION_NORMAL_RELEASE = 2147;
                public static final int PDP_FAIL_RRC_CONNECTION_RADIO_LINK_FAILURE = 2148;
                public static final int PDP_FAIL_RRC_CONNECTION_REESTABLISHMENT_FAILURE = 2149;
                public static final int PDP_FAIL_RRC_CONNECTION_OUT_OF_SERVICE_DURING_CELL_REGISTER = 2150;
                public static final int PDP_FAIL_RRC_CONNECTION_ABORT_REQUEST = 2151;
                public static final int PDP_FAIL_RRC_CONNECTION_SYSTEM_INFORMATION_BLOCK_READ_ERROR = 2152;
                public static final int PDP_FAIL_NETWORK_INITIATED_DETACH_WITH_AUTO_REATTACH = 2153;
                public static final int PDP_FAIL_NETWORK_INITIATED_DETACH_NO_AUTO_REATTACH = 2154;
                public static final int PDP_FAIL_ESM_PROCEDURE_TIME_OUT = 2155;
                public static final int PDP_FAIL_INVALID_CONNECTION_ID = 2156;
                public static final int PDP_FAIL_MAXIMIUM_NSAPIS_EXCEEDED = 2157;
                public static final int PDP_FAIL_INVALID_PRIMARY_NSAPI = 2158;
                public static final int PDP_FAIL_CANNOT_ENCODE_OTA_MESSAGE = 2159;
                public static final int PDP_FAIL_RADIO_ACCESS_BEARER_SETUP_FAILURE = 2160;
                public static final int PDP_FAIL_PDP_ESTABLISH_TIMEOUT_EXPIRED = 2161;
                public static final int PDP_FAIL_PDP_MODIFY_TIMEOUT_EXPIRED = 2162;
                public static final int PDP_FAIL_PDP_INACTIVE_TIMEOUT_EXPIRED = 2163;
                public static final int PDP_FAIL_PDP_LOWERLAYER_ERROR = 2164;
                public static final int PDP_FAIL_PDP_MODIFY_COLLISION = 2165;
                public static final int PDP_FAIL_MAXINUM_SIZE_OF_L2_MESSAGE_EXCEEDED = 2166;
                public static final int PDP_FAIL_NAS_REQUEST_REJECTED_BY_NETWORK = 2167;
                public static final int PDP_FAIL_RRC_CONNECTION_INVALID_REQUEST = 2168;
                public static final int PDP_FAIL_RRC_CONNECTION_TRACKING_AREA_ID_CHANGED = 2169;
                public static final int PDP_FAIL_RRC_CONNECTION_RF_UNAVAILABLE = 2170;
                public static final int PDP_FAIL_RRC_CONNECTION_ABORTED_DUE_TO_IRAT_CHANGE = 2171;
                public static final int PDP_FAIL_RRC_CONNECTION_RELEASED_SECURITY_NOT_ACTIVE = 2172;
                public static final int PDP_FAIL_RRC_CONNECTION_ABORTED_AFTER_HANDOVER = 2173;
                public static final int PDP_FAIL_RRC_CONNECTION_ABORTED_AFTER_IRAT_CELL_CHANGE = 2174;
                public static final int PDP_FAIL_RRC_CONNECTION_ABORTED_DURING_IRAT_CELL_CHANGE = 2175;
                public static final int PDP_FAIL_IMSI_UNKNOWN_IN_HOME_SUBSCRIBER_SERVER = 2176;
                public static final int PDP_FAIL_IMEI_NOT_ACCEPTED = 2177;
                public static final int PDP_FAIL_EPS_SERVICES_AND_NON_EPS_SERVICES_NOT_ALLOWED = 2178;
                public static final int PDP_FAIL_EPS_SERVICES_NOT_ALLOWED_IN_PLMN = 2179;
                public static final int PDP_FAIL_MSC_TEMPORARILY_NOT_REACHABLE = 2180;
                public static final int PDP_FAIL_CS_DOMAIN_NOT_AVAILABLE = 2181;
                public static final int PDP_FAIL_ESM_FAILURE = 2182;
                public static final int PDP_FAIL_MAC_FAILURE = 2183;
                public static final int PDP_FAIL_SYNCHRONIZATION_FAILURE = 2184;
                public static final int PDP_FAIL_UE_SECURITY_CAPABILITIES_MISMATCH = 2185;
                public static final int PDP_FAIL_SECURITY_MODE_REJECTED = 2186;
                public static final int PDP_FAIL_UNACCEPTABLE_NON_EPS_AUTHENTICATION = 2187;
                public static final int PDP_FAIL_CS_FALLBACK_CALL_ESTABLISHMENT_NOT_ALLOWED = 2188;
                public static final int PDP_FAIL_NO_EPS_BEARER_CONTEXT_ACTIVATED = 2189;
                public static final int PDP_FAIL_INVALID_EMM_STATE = 2190;
                public static final int PDP_FAIL_NAS_LAYER_FAILURE = 2191;
                public static final int PDP_FAIL_MULTIPLE_PDP_CALL_NOT_ALLOWED = 2192;
                public static final int PDP_FAIL_EMBMS_NOT_ENABLED = 2193;
                public static final int PDP_FAIL_IRAT_HANDOVER_FAILED = 2194;
                public static final int PDP_FAIL_EMBMS_REGULAR_DEACTIVATION = 2195;
                public static final int PDP_FAIL_TEST_LOOPBACK_REGULAR_DEACTIVATION = 2196;
                public static final int PDP_FAIL_LOWER_LAYER_REGISTRATION_FAILURE = 2197;
                public static final int PDP_FAIL_DATA_PLAN_EXPIRED = 2198;
                public static final int PDP_FAIL_UMTS_HANDOVER_TO_IWLAN = 2199;
                public static final int PDP_FAIL_EVDO_CONNECTION_DENY_BY_GENERAL_OR_NETWORK_BUSY = 2200;
                public static final int PDP_FAIL_EVDO_CONNECTION_DENY_BY_BILLING_OR_AUTHENTICATION_FAILURE = 2201;
                public static final int PDP_FAIL_EVDO_HDR_CHANGED = 2202;
                public static final int PDP_FAIL_EVDO_HDR_EXITED = 2203;
                public static final int PDP_FAIL_EVDO_HDR_NO_SESSION = 2204;
                public static final int PDP_FAIL_EVDO_USING_GPS_FIX_INSTEAD_OF_HDR_CALL = 2205;
                public static final int PDP_FAIL_EVDO_HDR_CONNECTION_SETUP_TIMEOUT = 2206;
                public static final int PDP_FAIL_FAILED_TO_ACQUIRE_COLOCATED_HDR = 2207;
                public static final int PDP_FAIL_OTASP_COMMIT_IN_PROGRESS = 2208;
                public static final int PDP_FAIL_NO_HYBRID_HDR_SERVICE = 2209;
                public static final int PDP_FAIL_HDR_NO_LOCK_GRANTED = 2210;
                public static final int PDP_FAIL_DBM_OR_SMS_IN_PROGRESS = 2211;
                public static final int PDP_FAIL_HDR_FADE = 2212;
                public static final int PDP_FAIL_HDR_ACCESS_FAILURE = 2213;
                public static final int PDP_FAIL_UNSUPPORTED_1X_PREV = 2214;
                public static final int PDP_FAIL_LOCAL_END = 2215;
                public static final int PDP_FAIL_NO_SERVICE = 2216;
                public static final int PDP_FAIL_FADE = 2217;
                public static final int PDP_FAIL_NORMAL_RELEASE = 2218;
                public static final int PDP_FAIL_ACCESS_ATTEMPT_ALREADY_IN_PROGRESS = 2219;
                public static final int PDP_FAIL_REDIRECTION_OR_HANDOFF_IN_PROGRESS = 2220;
                public static final int PDP_FAIL_EMERGENCY_MODE = 2221;
                public static final int PDP_FAIL_PHONE_IN_USE = 2222;
                public static final int PDP_FAIL_INVALID_MODE = 2223;
                public static final int PDP_FAIL_INVALID_SIM_STATE = 2224;
                public static final int PDP_FAIL_NO_COLLOCATED_HDR = 2225;
                public static final int PDP_FAIL_UE_IS_ENTERING_POWERSAVE_MODE = 2226;
                public static final int PDP_FAIL_DUAL_SWITCH = 2227;
                public static final int PDP_FAIL_PPP_TIMEOUT = 2228;
                public static final int PDP_FAIL_PPP_AUTH_FAILURE = 2229;
                public static final int PDP_FAIL_PPP_OPTION_MISMATCH = 2230;
                public static final int PDP_FAIL_PPP_PAP_FAILURE = 2231;
                public static final int PDP_FAIL_PPP_CHAP_FAILURE = 2232;
                public static final int PDP_FAIL_PPP_CLOSE_IN_PROGRESS = 2233;
                public static final int PDP_FAIL_LIMITED_TO_IPV4 = 2234;
                public static final int PDP_FAIL_LIMITED_TO_IPV6 = 2235;
                public static final int PDP_FAIL_VSNCP_TIMEOUT = 2236;
                public static final int PDP_FAIL_VSNCP_GEN_ERROR = 2237;
                public static final int PDP_FAIL_VSNCP_APN_UNATHORIZED = 2238;
                public static final int PDP_FAIL_VSNCP_PDN_LIMIT_EXCEEDED = 2239;
                public static final int PDP_FAIL_VSNCP_NO_PDN_GATEWAY_ADDRESS = 2240;
                public static final int PDP_FAIL_VSNCP_PDN_GATEWAY_UNREACHABLE = 2241;
                public static final int PDP_FAIL_VSNCP_PDN_GATEWAY_REJECT = 2242;
                public static final int PDP_FAIL_VSNCP_INSUFFICIENT_PARAMETERS = 2243;
                public static final int PDP_FAIL_VSNCP_RESOURCE_UNAVAILABLE = 2244;
                public static final int PDP_FAIL_VSNCP_ADMINISTRATIVELY_PROHIBITED = 2245;
                public static final int PDP_FAIL_VSNCP_PDN_ID_IN_USE = 2246;
                public static final int PDP_FAIL_VSNCP_SUBSCRIBER_LIMITATION = 2247;
                public static final int PDP_FAIL_VSNCP_PDN_EXISTS_FOR_THIS_APN = 2248;
                public static final int PDP_FAIL_VSNCP_RECONNECT_NOT_ALLOWED = 2249;
                public static final int PDP_FAIL_IPV6_PREFIX_UNAVAILABLE = 2250;
                public static final int PDP_FAIL_HANDOFF_PREFERENCE_CHANGED = 2251;
                public static final int PDP_FAIL_VOICE_REGISTRATION_FAIL = -1;
                public static final int PDP_FAIL_DATA_REGISTRATION_FAIL = -2;
                public static final int PDP_FAIL_SIGNAL_LOST = -3;
                public static final int PDP_FAIL_PREF_RADIO_TECH_CHANGED = -4;
                public static final int PDP_FAIL_RADIO_POWER_OFF = -5;
                public static final int PDP_FAIL_TETHERED_CALL_ACTIVE = -6;
                public static final int PDP_FAIL_ERROR_UNSPECIFIED = 65535;
            }
        }

        public static final class RilSetupDataCall
        extends ExtendableMessageNano<RilSetupDataCall> {
            private static volatile RilSetupDataCall[] _emptyArray;
            public int rat;
            public int dataProfile;
            public String apn;
            public int type;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static RilSetupDataCall[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new RilSetupDataCall[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public RilSetupDataCall() {
                this.clear();
            }

            public RilSetupDataCall clear() {
                this.rat = -1;
                this.dataProfile = 0;
                this.apn = "";
                this.type = 0;
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.rat != -1) {
                    output.writeInt32(1, this.rat);
                }
                if (this.dataProfile != 0) {
                    output.writeInt32(2, this.dataProfile);
                }
                if (!this.apn.equals("")) {
                    output.writeString(3, this.apn);
                }
                if (this.type != 0) {
                    output.writeInt32(4, this.type);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.rat != -1) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.rat);
                }
                if (this.dataProfile != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.dataProfile);
                }
                if (!this.apn.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(3, this.apn);
                }
                if (this.type != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(4, this.type);
                }
                return size;
            }

            @Override
            public RilSetupDataCall mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block16: while (true) {
                    int value;
                    int initialPos;
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block16;
                            return this;
                        }
                        case 8: {
                            initialPos = input.getPosition();
                            value = input.readInt32();
                            switch (value) {
                                case -1: 
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: {
                                    this.rat = value;
                                    continue block16;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block16;
                        }
                        case 16: {
                            initialPos = input.getPosition();
                            value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    this.dataProfile = value;
                                    continue block16;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block16;
                        }
                        case 26: {
                            this.apn = input.readString();
                            continue block16;
                        }
                        case 32: 
                    }
                    initialPos = input.getPosition();
                    value = input.readInt32();
                    switch (value) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            this.type = value;
                            continue block16;
                        }
                    }
                    input.rewindToPosition(initialPos);
                    this.storeUnknownField(input, tag);
                }
            }

            public static RilSetupDataCall parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new RilSetupDataCall(), data);
            }

            public static RilSetupDataCall parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new RilSetupDataCall().mergeFrom(input);
            }

            public static interface RilDataProfile {
                public static final int RIL_DATA_UNKNOWN = 0;
                public static final int RIL_DATA_PROFILE_DEFAULT = 1;
                public static final int RIL_DATA_PROFILE_TETHERED = 2;
                public static final int RIL_DATA_PROFILE_IMS = 3;
                public static final int RIL_DATA_PROFILE_FOTA = 4;
                public static final int RIL_DATA_PROFILE_CBS = 5;
                public static final int RIL_DATA_PROFILE_OEM_BASE = 6;
                public static final int RIL_DATA_PROFILE_INVALID = 7;
            }
        }

        public static final class OnDemandDataSwitch
        extends ExtendableMessageNano<OnDemandDataSwitch> {
            private static volatile OnDemandDataSwitch[] _emptyArray;
            public int apn;
            public int state;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static OnDemandDataSwitch[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new OnDemandDataSwitch[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public OnDemandDataSwitch() {
                this.clear();
            }

            public OnDemandDataSwitch clear() {
                this.apn = 0;
                this.state = 0;
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.apn != 0) {
                    output.writeInt32(1, this.apn);
                }
                if (this.state != 0) {
                    output.writeInt32(2, this.state);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.apn != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.apn);
                }
                if (this.state != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.state);
                }
                return size;
            }

            @Override
            public OnDemandDataSwitch mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block11: while (true) {
                    int value;
                    int initialPos;
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block11;
                            return this;
                        }
                        case 8: {
                            initialPos = input.getPosition();
                            value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: {
                                    this.apn = value;
                                    continue block11;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block11;
                        }
                        case 16: 
                    }
                    initialPos = input.getPosition();
                    value = input.readInt32();
                    switch (value) {
                        case 0: 
                        case 1: 
                        case 2: {
                            this.state = value;
                            continue block11;
                        }
                    }
                    input.rewindToPosition(initialPos);
                    this.storeUnknownField(input, tag);
                }
            }

            public static OnDemandDataSwitch parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new OnDemandDataSwitch(), data);
            }

            public static OnDemandDataSwitch parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new OnDemandDataSwitch().mergeFrom(input);
            }
        }

        public static final class DataSwitch
        extends ExtendableMessageNano<DataSwitch> {
            private static volatile DataSwitch[] _emptyArray;
            public int reason;
            public int state;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static DataSwitch[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new DataSwitch[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public DataSwitch() {
                this.clear();
            }

            public DataSwitch clear() {
                this.reason = 0;
                this.state = 0;
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.reason != 0) {
                    output.writeInt32(1, this.reason);
                }
                if (this.state != 0) {
                    output.writeInt32(2, this.state);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.reason != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.reason);
                }
                if (this.state != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.state);
                }
                return size;
            }

            @Override
            public DataSwitch mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block11: while (true) {
                    int value;
                    int initialPos;
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block11;
                            return this;
                        }
                        case 8: {
                            initialPos = input.getPosition();
                            value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: {
                                    this.reason = value;
                                    continue block11;
                                }
                            }
                            input.rewindToPosition(initialPos);
                            this.storeUnknownField(input, tag);
                            continue block11;
                        }
                        case 16: 
                    }
                    initialPos = input.getPosition();
                    value = input.readInt32();
                    switch (value) {
                        case 0: 
                        case 1: 
                        case 2: {
                            this.state = value;
                            continue block11;
                        }
                    }
                    input.rewindToPosition(initialPos);
                    this.storeUnknownField(input, tag);
                }
            }

            public static DataSwitch parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new DataSwitch(), data);
            }

            public static DataSwitch parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new DataSwitch().mergeFrom(input);
            }

            public static interface Reason {
                public static final int DATA_SWITCH_REASON_UNKNOWN = 0;
                public static final int DATA_SWITCH_REASON_MANUAL = 1;
                public static final int DATA_SWITCH_REASON_IN_CALL = 2;
                public static final int DATA_SWITCH_REASON_CBRS = 3;
            }
        }

        public static interface NetworkValidationState {
            public static final int NETWORK_VALIDATION_STATE_UNKNOWN = 0;
            public static final int NETWORK_VALIDATION_STATE_AVAILABLE = 1;
            public static final int NETWORK_VALIDATION_STATE_FAILED = 2;
            public static final int NETWORK_VALIDATION_STATE_PASSED = 3;
        }

        public static interface EventState {
            public static final int EVENT_STATE_UNKNOWN = 0;
            public static final int EVENT_STATE_START = 1;
            public static final int EVENT_STATE_END = 2;
        }

        public static interface ApnType {
            public static final int APN_TYPE_UNKNOWN = 0;
            public static final int APN_TYPE_DEFAULT = 1;
            public static final int APN_TYPE_MMS = 2;
            public static final int APN_TYPE_SUPL = 3;
            public static final int APN_TYPE_DUN = 4;
            public static final int APN_TYPE_HIPRI = 5;
            public static final int APN_TYPE_FOTA = 6;
            public static final int APN_TYPE_IMS = 7;
            public static final int APN_TYPE_CBS = 8;
            public static final int APN_TYPE_IA = 9;
            public static final int APN_TYPE_EMERGENCY = 10;
        }

        public static interface Type {
            public static final int UNKNOWN = 0;
            public static final int SETTINGS_CHANGED = 1;
            public static final int RIL_SERVICE_STATE_CHANGED = 2;
            public static final int IMS_CONNECTION_STATE_CHANGED = 3;
            public static final int IMS_CAPABILITIES_CHANGED = 4;
            public static final int DATA_CALL_SETUP = 5;
            public static final int DATA_CALL_SETUP_RESPONSE = 6;
            public static final int DATA_CALL_LIST_CHANGED = 7;
            public static final int DATA_CALL_DEACTIVATE = 8;
            public static final int DATA_CALL_DEACTIVATE_RESPONSE = 9;
            public static final int DATA_STALL_ACTION = 10;
            public static final int MODEM_RESTART = 11;
            public static final int NITZ_TIME = 12;
            public static final int CARRIER_ID_MATCHING = 13;
            public static final int CARRIER_KEY_CHANGED = 14;
            public static final int DATA_SWITCH = 15;
            public static final int NETWORK_VALIDATE = 16;
            public static final int ON_DEMAND_DATA_SWITCH = 17;
            public static final int SIM_STATE_CHANGED = 18;
            public static final int ACTIVE_SUBSCRIPTION_INFO_CHANGED = 19;
            public static final int ENABLED_MODEM_CHANGED = 20;
            public static final int EMERGENCY_NUMBER_REPORT = 21;
        }
    }

    public static final class EmergencyNumberInfo
    extends ExtendableMessageNano<EmergencyNumberInfo> {
        private static volatile EmergencyNumberInfo[] _emptyArray;
        public String address;
        public String countryIso;
        public String mnc;
        public int serviceCategoriesBitmask;
        public String[] urns;
        public int numberSourcesBitmask;
        public int routing;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static EmergencyNumberInfo[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new EmergencyNumberInfo[0];
                    }
                }
            }
            return _emptyArray;
        }

        public EmergencyNumberInfo() {
            this.clear();
        }

        public EmergencyNumberInfo clear() {
            this.address = "";
            this.countryIso = "";
            this.mnc = "";
            this.serviceCategoriesBitmask = 0;
            this.urns = WireFormatNano.EMPTY_STRING_ARRAY;
            this.numberSourcesBitmask = 0;
            this.routing = 0;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (!this.address.equals("")) {
                output.writeString(1, this.address);
            }
            if (!this.countryIso.equals("")) {
                output.writeString(2, this.countryIso);
            }
            if (!this.mnc.equals("")) {
                output.writeString(3, this.mnc);
            }
            if (this.serviceCategoriesBitmask != 0) {
                output.writeInt32(4, this.serviceCategoriesBitmask);
            }
            if (this.urns != null && this.urns.length > 0) {
                for (int i = 0; i < this.urns.length; ++i) {
                    String element = this.urns[i];
                    if (element == null) continue;
                    output.writeString(5, element);
                }
            }
            if (this.numberSourcesBitmask != 0) {
                output.writeInt32(6, this.numberSourcesBitmask);
            }
            if (this.routing != 0) {
                output.writeInt32(7, this.routing);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (!this.address.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(1, this.address);
            }
            if (!this.countryIso.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(2, this.countryIso);
            }
            if (!this.mnc.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(3, this.mnc);
            }
            if (this.serviceCategoriesBitmask != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.serviceCategoriesBitmask);
            }
            if (this.urns != null && this.urns.length > 0) {
                int dataCount = 0;
                int dataSize = 0;
                for (int i = 0; i < this.urns.length; ++i) {
                    String element = this.urns[i];
                    if (element == null) continue;
                    ++dataCount;
                    dataSize += CodedOutputByteBufferNano.computeStringSizeNoTag(element);
                }
                size += dataSize;
                size += 1 * dataCount;
            }
            if (this.numberSourcesBitmask != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(6, this.numberSourcesBitmask);
            }
            if (this.routing != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(7, this.routing);
            }
            return size;
        }

        @Override
        public EmergencyNumberInfo mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block10: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block10;
                        return this;
                    }
                    case 10: {
                        this.address = input.readString();
                        continue block10;
                    }
                    case 18: {
                        this.countryIso = input.readString();
                        continue block10;
                    }
                    case 26: {
                        this.mnc = input.readString();
                        continue block10;
                    }
                    case 32: {
                        this.serviceCategoriesBitmask = input.readInt32();
                        continue block10;
                    }
                    case 42: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 42);
                        int i = this.urns == null ? 0 : this.urns.length;
                        String[] newArray = new String[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.urns, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readString();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readString();
                        this.urns = newArray;
                        continue block10;
                    }
                    case 48: {
                        this.numberSourcesBitmask = input.readInt32();
                        continue block10;
                    }
                    case 56: 
                }
                this.routing = input.readInt32();
            }
        }

        public static EmergencyNumberInfo parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new EmergencyNumberInfo(), data);
        }

        public static EmergencyNumberInfo parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new EmergencyNumberInfo().mergeFrom(input);
        }
    }

    public static final class RilDataCall
    extends ExtendableMessageNano<RilDataCall> {
        private static volatile RilDataCall[] _emptyArray;
        public int cid;
        public int type;
        public String iframe;
        public int state;
        public int apnTypeBitmask;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RilDataCall[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new RilDataCall[0];
                    }
                }
            }
            return _emptyArray;
        }

        public RilDataCall() {
            this.clear();
        }

        public RilDataCall clear() {
            this.cid = 0;
            this.type = 0;
            this.iframe = "";
            this.state = 0;
            this.apnTypeBitmask = 0;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.cid != 0) {
                output.writeInt32(1, this.cid);
            }
            if (this.type != 0) {
                output.writeInt32(2, this.type);
            }
            if (!this.iframe.equals("")) {
                output.writeString(3, this.iframe);
            }
            if (this.state != 0) {
                output.writeInt32(4, this.state);
            }
            if (this.apnTypeBitmask != 0) {
                output.writeInt32(5, this.apnTypeBitmask);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.cid != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.cid);
            }
            if (this.type != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.type);
            }
            if (!this.iframe.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(3, this.iframe);
            }
            if (this.state != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.state);
            }
            if (this.apnTypeBitmask != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.apnTypeBitmask);
            }
            return size;
        }

        @Override
        public RilDataCall mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block14: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block14;
                        return this;
                    }
                    case 8: {
                        this.cid = input.readInt32();
                        continue block14;
                    }
                    case 16: {
                        int initialPos = input.getPosition();
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                this.type = value;
                                continue block14;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                        continue block14;
                    }
                    case 26: {
                        this.iframe = input.readString();
                        continue block14;
                    }
                    case 32: {
                        int initialPos = input.getPosition();
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: {
                                this.state = value;
                                continue block14;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                        continue block14;
                    }
                    case 40: 
                }
                this.apnTypeBitmask = input.readInt32();
            }
        }

        public static RilDataCall parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new RilDataCall(), data);
        }

        public static RilDataCall parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new RilDataCall().mergeFrom(input);
        }

        public static interface State {
            public static final int UNKNOWN = 0;
            public static final int CONNECTED = 1;
            public static final int DISCONNECTED = 2;
        }
    }

    public static final class ImsCapabilities
    extends ExtendableMessageNano<ImsCapabilities> {
        private static volatile ImsCapabilities[] _emptyArray;
        public boolean voiceOverLte;
        public boolean voiceOverWifi;
        public boolean videoOverLte;
        public boolean videoOverWifi;
        public boolean utOverLte;
        public boolean utOverWifi;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ImsCapabilities[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ImsCapabilities[0];
                    }
                }
            }
            return _emptyArray;
        }

        public ImsCapabilities() {
            this.clear();
        }

        public ImsCapabilities clear() {
            this.voiceOverLte = false;
            this.voiceOverWifi = false;
            this.videoOverLte = false;
            this.videoOverWifi = false;
            this.utOverLte = false;
            this.utOverWifi = false;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.voiceOverLte) {
                output.writeBool(1, this.voiceOverLte);
            }
            if (this.voiceOverWifi) {
                output.writeBool(2, this.voiceOverWifi);
            }
            if (this.videoOverLte) {
                output.writeBool(3, this.videoOverLte);
            }
            if (this.videoOverWifi) {
                output.writeBool(4, this.videoOverWifi);
            }
            if (this.utOverLte) {
                output.writeBool(5, this.utOverLte);
            }
            if (this.utOverWifi) {
                output.writeBool(6, this.utOverWifi);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.voiceOverLte) {
                size += CodedOutputByteBufferNano.computeBoolSize(1, this.voiceOverLte);
            }
            if (this.voiceOverWifi) {
                size += CodedOutputByteBufferNano.computeBoolSize(2, this.voiceOverWifi);
            }
            if (this.videoOverLte) {
                size += CodedOutputByteBufferNano.computeBoolSize(3, this.videoOverLte);
            }
            if (this.videoOverWifi) {
                size += CodedOutputByteBufferNano.computeBoolSize(4, this.videoOverWifi);
            }
            if (this.utOverLte) {
                size += CodedOutputByteBufferNano.computeBoolSize(5, this.utOverLte);
            }
            if (this.utOverWifi) {
                size += CodedOutputByteBufferNano.computeBoolSize(6, this.utOverWifi);
            }
            return size;
        }

        @Override
        public ImsCapabilities mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block9: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block9;
                        return this;
                    }
                    case 8: {
                        this.voiceOverLte = input.readBool();
                        continue block9;
                    }
                    case 16: {
                        this.voiceOverWifi = input.readBool();
                        continue block9;
                    }
                    case 24: {
                        this.videoOverLte = input.readBool();
                        continue block9;
                    }
                    case 32: {
                        this.videoOverWifi = input.readBool();
                        continue block9;
                    }
                    case 40: {
                        this.utOverLte = input.readBool();
                        continue block9;
                    }
                    case 48: 
                }
                this.utOverWifi = input.readBool();
            }
        }

        public static ImsCapabilities parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new ImsCapabilities(), data);
        }

        public static ImsCapabilities parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new ImsCapabilities().mergeFrom(input);
        }
    }

    public static final class ImsConnectionState
    extends ExtendableMessageNano<ImsConnectionState> {
        private static volatile ImsConnectionState[] _emptyArray;
        public int state;
        public ImsReasonInfo reasonInfo;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ImsConnectionState[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ImsConnectionState[0];
                    }
                }
            }
            return _emptyArray;
        }

        public ImsConnectionState() {
            this.clear();
        }

        public ImsConnectionState clear() {
            this.state = 0;
            this.reasonInfo = null;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.state != 0) {
                output.writeInt32(1, this.state);
            }
            if (this.reasonInfo != null) {
                output.writeMessage(2, this.reasonInfo);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.state != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.state);
            }
            if (this.reasonInfo != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(2, this.reasonInfo);
            }
            return size;
        }

        @Override
        public ImsConnectionState mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block8: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block8;
                        return this;
                    }
                    case 8: {
                        int initialPos = input.getPosition();
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                this.state = value;
                                continue block8;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                        continue block8;
                    }
                    case 18: 
                }
                if (this.reasonInfo == null) {
                    this.reasonInfo = new ImsReasonInfo();
                }
                input.readMessage(this.reasonInfo);
            }
        }

        public static ImsConnectionState parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new ImsConnectionState(), data);
        }

        public static ImsConnectionState parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new ImsConnectionState().mergeFrom(input);
        }

        public static interface State {
            public static final int STATE_UNKNOWN = 0;
            public static final int CONNECTED = 1;
            public static final int PROGRESSING = 2;
            public static final int DISCONNECTED = 3;
            public static final int RESUMED = 4;
            public static final int SUSPENDED = 5;
        }
    }

    public static final class ImsReasonInfo
    extends ExtendableMessageNano<ImsReasonInfo> {
        private static volatile ImsReasonInfo[] _emptyArray;
        public int reasonCode;
        public int extraCode;
        public String extraMessage;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ImsReasonInfo[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ImsReasonInfo[0];
                    }
                }
            }
            return _emptyArray;
        }

        public ImsReasonInfo() {
            this.clear();
        }

        public ImsReasonInfo clear() {
            this.reasonCode = 0;
            this.extraCode = 0;
            this.extraMessage = "";
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.reasonCode != 0) {
                output.writeInt32(1, this.reasonCode);
            }
            if (this.extraCode != 0) {
                output.writeInt32(2, this.extraCode);
            }
            if (!this.extraMessage.equals("")) {
                output.writeString(3, this.extraMessage);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.reasonCode != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.reasonCode);
            }
            if (this.extraCode != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.extraCode);
            }
            if (!this.extraMessage.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(3, this.extraMessage);
            }
            return size;
        }

        @Override
        public ImsReasonInfo mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block6: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block6;
                        return this;
                    }
                    case 8: {
                        this.reasonCode = input.readInt32();
                        continue block6;
                    }
                    case 16: {
                        this.extraCode = input.readInt32();
                        continue block6;
                    }
                    case 26: 
                }
                this.extraMessage = input.readString();
            }
        }

        public static ImsReasonInfo parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new ImsReasonInfo(), data);
        }

        public static ImsReasonInfo parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new ImsReasonInfo().mergeFrom(input);
        }
    }

    public static final class TelephonyServiceState
    extends ExtendableMessageNano<TelephonyServiceState> {
        private static volatile TelephonyServiceState[] _emptyArray;
        public TelephonyOperator voiceOperator;
        public TelephonyOperator dataOperator;
        public int voiceRoamingType;
        public int dataRoamingType;
        public int voiceRat;
        public int dataRat;
        public int channelNumber;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TelephonyServiceState[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new TelephonyServiceState[0];
                    }
                }
            }
            return _emptyArray;
        }

        public TelephonyServiceState() {
            this.clear();
        }

        public TelephonyServiceState clear() {
            this.voiceOperator = null;
            this.dataOperator = null;
            this.voiceRoamingType = -1;
            this.dataRoamingType = -1;
            this.voiceRat = -1;
            this.dataRat = -1;
            this.channelNumber = 0;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.voiceOperator != null) {
                output.writeMessage(1, this.voiceOperator);
            }
            if (this.dataOperator != null) {
                output.writeMessage(2, this.dataOperator);
            }
            if (this.voiceRoamingType != -1) {
                output.writeInt32(3, this.voiceRoamingType);
            }
            if (this.dataRoamingType != -1) {
                output.writeInt32(4, this.dataRoamingType);
            }
            if (this.voiceRat != -1) {
                output.writeInt32(5, this.voiceRat);
            }
            if (this.dataRat != -1) {
                output.writeInt32(6, this.dataRat);
            }
            if (this.channelNumber != 0) {
                output.writeInt32(7, this.channelNumber);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.voiceOperator != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(1, this.voiceOperator);
            }
            if (this.dataOperator != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(2, this.dataOperator);
            }
            if (this.voiceRoamingType != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.voiceRoamingType);
            }
            if (this.dataRoamingType != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.dataRoamingType);
            }
            if (this.voiceRat != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.voiceRat);
            }
            if (this.dataRat != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(6, this.dataRat);
            }
            if (this.channelNumber != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(7, this.channelNumber);
            }
            return size;
        }

        @Override
        public TelephonyServiceState mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block22: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block22;
                        return this;
                    }
                    case 10: {
                        if (this.voiceOperator == null) {
                            this.voiceOperator = new TelephonyOperator();
                        }
                        input.readMessage(this.voiceOperator);
                        continue block22;
                    }
                    case 18: {
                        if (this.dataOperator == null) {
                            this.dataOperator = new TelephonyOperator();
                        }
                        input.readMessage(this.dataOperator);
                        continue block22;
                    }
                    case 24: {
                        int initialPos = input.getPosition();
                        int value = input.readInt32();
                        switch (value) {
                            case -1: 
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.voiceRoamingType = value;
                                continue block22;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                        continue block22;
                    }
                    case 32: {
                        int initialPos = input.getPosition();
                        int value = input.readInt32();
                        switch (value) {
                            case -1: 
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.dataRoamingType = value;
                                continue block22;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                        continue block22;
                    }
                    case 40: {
                        int initialPos = input.getPosition();
                        int value = input.readInt32();
                        switch (value) {
                            case -1: 
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: {
                                this.voiceRat = value;
                                continue block22;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                        continue block22;
                    }
                    case 48: {
                        int initialPos = input.getPosition();
                        int value = input.readInt32();
                        switch (value) {
                            case -1: 
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: {
                                this.dataRat = value;
                                continue block22;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                        continue block22;
                    }
                    case 56: 
                }
                this.channelNumber = input.readInt32();
            }
        }

        public static TelephonyServiceState parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new TelephonyServiceState(), data);
        }

        public static TelephonyServiceState parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new TelephonyServiceState().mergeFrom(input);
        }

        public static final class TelephonyOperator
        extends ExtendableMessageNano<TelephonyOperator> {
            private static volatile TelephonyOperator[] _emptyArray;
            public String alphaLong;
            public String alphaShort;
            public String numeric;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static TelephonyOperator[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new TelephonyOperator[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public TelephonyOperator() {
                this.clear();
            }

            public TelephonyOperator clear() {
                this.alphaLong = "";
                this.alphaShort = "";
                this.numeric = "";
                this.unknownFieldData = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (!this.alphaLong.equals("")) {
                    output.writeString(1, this.alphaLong);
                }
                if (!this.alphaShort.equals("")) {
                    output.writeString(2, this.alphaShort);
                }
                if (!this.numeric.equals("")) {
                    output.writeString(3, this.numeric);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (!this.alphaLong.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(1, this.alphaLong);
                }
                if (!this.alphaShort.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(2, this.alphaShort);
                }
                if (!this.numeric.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(3, this.numeric);
                }
                return size;
            }

            @Override
            public TelephonyOperator mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block6: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (this.storeUnknownField(input, tag)) continue block6;
                            return this;
                        }
                        case 10: {
                            this.alphaLong = input.readString();
                            continue block6;
                        }
                        case 18: {
                            this.alphaShort = input.readString();
                            continue block6;
                        }
                        case 26: 
                    }
                    this.numeric = input.readString();
                }
            }

            public static TelephonyOperator parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new TelephonyOperator(), data);
            }

            public static TelephonyOperator parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new TelephonyOperator().mergeFrom(input);
            }
        }

        public static interface RoamingType {
            public static final int UNKNOWN = -1;
            public static final int ROAMING_TYPE_NOT_ROAMING = 0;
            public static final int ROAMING_TYPE_UNKNOWN = 1;
            public static final int ROAMING_TYPE_DOMESTIC = 2;
            public static final int ROAMING_TYPE_INTERNATIONAL = 3;
        }
    }

    public static final class TelephonySettings
    extends ExtendableMessageNano<TelephonySettings> {
        private static volatile TelephonySettings[] _emptyArray;
        public boolean isAirplaneMode;
        public boolean isCellularDataEnabled;
        public boolean isDataRoamingEnabled;
        public int preferredNetworkMode;
        public boolean isEnhanced4GLteModeEnabled;
        public boolean isWifiEnabled;
        public boolean isWifiCallingEnabled;
        public int wifiCallingMode;
        public boolean isVtOverLteEnabled;
        public boolean isVtOverWifiEnabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TelephonySettings[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new TelephonySettings[0];
                    }
                }
            }
            return _emptyArray;
        }

        public TelephonySettings() {
            this.clear();
        }

        public TelephonySettings clear() {
            this.isAirplaneMode = false;
            this.isCellularDataEnabled = false;
            this.isDataRoamingEnabled = false;
            this.preferredNetworkMode = 0;
            this.isEnhanced4GLteModeEnabled = false;
            this.isWifiEnabled = false;
            this.isWifiCallingEnabled = false;
            this.wifiCallingMode = 0;
            this.isVtOverLteEnabled = false;
            this.isVtOverWifiEnabled = false;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.isAirplaneMode) {
                output.writeBool(1, this.isAirplaneMode);
            }
            if (this.isCellularDataEnabled) {
                output.writeBool(2, this.isCellularDataEnabled);
            }
            if (this.isDataRoamingEnabled) {
                output.writeBool(3, this.isDataRoamingEnabled);
            }
            if (this.preferredNetworkMode != 0) {
                output.writeInt32(4, this.preferredNetworkMode);
            }
            if (this.isEnhanced4GLteModeEnabled) {
                output.writeBool(5, this.isEnhanced4GLteModeEnabled);
            }
            if (this.isWifiEnabled) {
                output.writeBool(6, this.isWifiEnabled);
            }
            if (this.isWifiCallingEnabled) {
                output.writeBool(7, this.isWifiCallingEnabled);
            }
            if (this.wifiCallingMode != 0) {
                output.writeInt32(8, this.wifiCallingMode);
            }
            if (this.isVtOverLteEnabled) {
                output.writeBool(9, this.isVtOverLteEnabled);
            }
            if (this.isVtOverWifiEnabled) {
                output.writeBool(10, this.isVtOverWifiEnabled);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.isAirplaneMode) {
                size += CodedOutputByteBufferNano.computeBoolSize(1, this.isAirplaneMode);
            }
            if (this.isCellularDataEnabled) {
                size += CodedOutputByteBufferNano.computeBoolSize(2, this.isCellularDataEnabled);
            }
            if (this.isDataRoamingEnabled) {
                size += CodedOutputByteBufferNano.computeBoolSize(3, this.isDataRoamingEnabled);
            }
            if (this.preferredNetworkMode != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.preferredNetworkMode);
            }
            if (this.isEnhanced4GLteModeEnabled) {
                size += CodedOutputByteBufferNano.computeBoolSize(5, this.isEnhanced4GLteModeEnabled);
            }
            if (this.isWifiEnabled) {
                size += CodedOutputByteBufferNano.computeBoolSize(6, this.isWifiEnabled);
            }
            if (this.isWifiCallingEnabled) {
                size += CodedOutputByteBufferNano.computeBoolSize(7, this.isWifiCallingEnabled);
            }
            if (this.wifiCallingMode != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(8, this.wifiCallingMode);
            }
            if (this.isVtOverLteEnabled) {
                size += CodedOutputByteBufferNano.computeBoolSize(9, this.isVtOverLteEnabled);
            }
            if (this.isVtOverWifiEnabled) {
                size += CodedOutputByteBufferNano.computeBoolSize(10, this.isVtOverWifiEnabled);
            }
            return size;
        }

        @Override
        public TelephonySettings mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block19: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block19;
                        return this;
                    }
                    case 8: {
                        this.isAirplaneMode = input.readBool();
                        continue block19;
                    }
                    case 16: {
                        this.isCellularDataEnabled = input.readBool();
                        continue block19;
                    }
                    case 24: {
                        this.isDataRoamingEnabled = input.readBool();
                        continue block19;
                    }
                    case 32: {
                        int initialPos = input.getPosition();
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: {
                                this.preferredNetworkMode = value;
                                continue block19;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                        continue block19;
                    }
                    case 40: {
                        this.isEnhanced4GLteModeEnabled = input.readBool();
                        continue block19;
                    }
                    case 48: {
                        this.isWifiEnabled = input.readBool();
                        continue block19;
                    }
                    case 56: {
                        this.isWifiCallingEnabled = input.readBool();
                        continue block19;
                    }
                    case 64: {
                        int initialPos = input.getPosition();
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.wifiCallingMode = value;
                                continue block19;
                            }
                        }
                        input.rewindToPosition(initialPos);
                        this.storeUnknownField(input, tag);
                        continue block19;
                    }
                    case 72: {
                        this.isVtOverLteEnabled = input.readBool();
                        continue block19;
                    }
                    case 80: 
                }
                this.isVtOverWifiEnabled = input.readBool();
            }
        }

        public static TelephonySettings parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new TelephonySettings(), data);
        }

        public static TelephonySettings parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new TelephonySettings().mergeFrom(input);
        }

        public static interface WiFiCallingMode {
            public static final int WFC_MODE_UNKNOWN = 0;
            public static final int WFC_MODE_WIFI_ONLY = 1;
            public static final int WFC_MODE_CELLULAR_PREFERRED = 2;
            public static final int WFC_MODE_WIFI_PREFERRED = 3;
        }

        public static interface RilNetworkMode {
            public static final int NETWORK_MODE_UNKNOWN = 0;
            public static final int NETWORK_MODE_WCDMA_PREF = 1;
            public static final int NETWORK_MODE_GSM_ONLY = 2;
            public static final int NETWORK_MODE_WCDMA_ONLY = 3;
            public static final int NETWORK_MODE_GSM_UMTS = 4;
            public static final int NETWORK_MODE_CDMA = 5;
            public static final int NETWORK_MODE_CDMA_NO_EVDO = 6;
            public static final int NETWORK_MODE_EVDO_NO_CDMA = 7;
            public static final int NETWORK_MODE_GLOBAL = 8;
            public static final int NETWORK_MODE_LTE_CDMA_EVDO = 9;
            public static final int NETWORK_MODE_LTE_GSM_WCDMA = 10;
            public static final int NETWORK_MODE_LTE_CDMA_EVDO_GSM_WCDMA = 11;
            public static final int NETWORK_MODE_LTE_ONLY = 12;
            public static final int NETWORK_MODE_LTE_WCDMA = 13;
            public static final int NETWORK_MODE_TDSCDMA_ONLY = 14;
            public static final int NETWORK_MODE_TDSCDMA_WCDMA = 15;
            public static final int NETWORK_MODE_LTE_TDSCDMA = 16;
            public static final int NETWORK_MODE_TDSCDMA_GSM = 17;
            public static final int NETWORK_MODE_LTE_TDSCDMA_GSM = 18;
            public static final int NETWORK_MODE_TDSCDMA_GSM_WCDMA = 19;
            public static final int NETWORK_MODE_LTE_TDSCDMA_WCDMA = 20;
            public static final int NETWORK_MODE_LTE_TDSCDMA_GSM_WCDMA = 21;
            public static final int NETWORK_MODE_TDSCDMA_CDMA_EVDO_GSM_WCDMA = 22;
            public static final int NETWORK_MODE_LTE_TDSCDMA_CDMA_EVDO_GSM_WCDMA = 23;
        }
    }

    public static final class TelephonyHistogram
    extends ExtendableMessageNano<TelephonyHistogram> {
        private static volatile TelephonyHistogram[] _emptyArray;
        public int category;
        public int id;
        public int minTimeMillis;
        public int maxTimeMillis;
        public int avgTimeMillis;
        public int count;
        public int bucketCount;
        public int[] bucketEndPoints;
        public int[] bucketCounters;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TelephonyHistogram[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new TelephonyHistogram[0];
                    }
                }
            }
            return _emptyArray;
        }

        public TelephonyHistogram() {
            this.clear();
        }

        public TelephonyHistogram clear() {
            this.category = 0;
            this.id = 0;
            this.minTimeMillis = 0;
            this.maxTimeMillis = 0;
            this.avgTimeMillis = 0;
            this.count = 0;
            this.bucketCount = 0;
            this.bucketEndPoints = WireFormatNano.EMPTY_INT_ARRAY;
            this.bucketCounters = WireFormatNano.EMPTY_INT_ARRAY;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            int i;
            if (this.category != 0) {
                output.writeInt32(1, this.category);
            }
            if (this.id != 0) {
                output.writeInt32(2, this.id);
            }
            if (this.minTimeMillis != 0) {
                output.writeInt32(3, this.minTimeMillis);
            }
            if (this.maxTimeMillis != 0) {
                output.writeInt32(4, this.maxTimeMillis);
            }
            if (this.avgTimeMillis != 0) {
                output.writeInt32(5, this.avgTimeMillis);
            }
            if (this.count != 0) {
                output.writeInt32(6, this.count);
            }
            if (this.bucketCount != 0) {
                output.writeInt32(7, this.bucketCount);
            }
            if (this.bucketEndPoints != null && this.bucketEndPoints.length > 0) {
                for (i = 0; i < this.bucketEndPoints.length; ++i) {
                    output.writeInt32(8, this.bucketEndPoints[i]);
                }
            }
            if (this.bucketCounters != null && this.bucketCounters.length > 0) {
                for (i = 0; i < this.bucketCounters.length; ++i) {
                    output.writeInt32(9, this.bucketCounters[i]);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int element;
            int i;
            int dataSize;
            int size = super.computeSerializedSize();
            if (this.category != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.category);
            }
            if (this.id != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.id);
            }
            if (this.minTimeMillis != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.minTimeMillis);
            }
            if (this.maxTimeMillis != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.maxTimeMillis);
            }
            if (this.avgTimeMillis != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.avgTimeMillis);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(6, this.count);
            }
            if (this.bucketCount != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(7, this.bucketCount);
            }
            if (this.bucketEndPoints != null && this.bucketEndPoints.length > 0) {
                dataSize = 0;
                for (i = 0; i < this.bucketEndPoints.length; ++i) {
                    element = this.bucketEndPoints[i];
                    dataSize += CodedOutputByteBufferNano.computeInt32SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.bucketEndPoints.length;
            }
            if (this.bucketCounters != null && this.bucketCounters.length > 0) {
                dataSize = 0;
                for (i = 0; i < this.bucketCounters.length; ++i) {
                    element = this.bucketCounters[i];
                    dataSize += CodedOutputByteBufferNano.computeInt32SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.bucketCounters.length;
            }
            return size;
        }

        @Override
        public TelephonyHistogram mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block14: while (true) {
                int[] newArray;
                int i;
                int startPos;
                int limit;
                int length;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block14;
                        return this;
                    }
                    case 8: {
                        this.category = input.readInt32();
                        continue block14;
                    }
                    case 16: {
                        this.id = input.readInt32();
                        continue block14;
                    }
                    case 24: {
                        this.minTimeMillis = input.readInt32();
                        continue block14;
                    }
                    case 32: {
                        this.maxTimeMillis = input.readInt32();
                        continue block14;
                    }
                    case 40: {
                        this.avgTimeMillis = input.readInt32();
                        continue block14;
                    }
                    case 48: {
                        this.count = input.readInt32();
                        continue block14;
                    }
                    case 56: {
                        this.bucketCount = input.readInt32();
                        continue block14;
                    }
                    case 64: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 64);
                        int i2 = this.bucketEndPoints == null ? 0 : this.bucketEndPoints.length;
                        int[] newArray2 = new int[i2 + arrayLength];
                        if (i2 != 0) {
                            System.arraycopy(this.bucketEndPoints, 0, newArray2, 0, i2);
                        }
                        while (i2 < newArray2.length - 1) {
                            newArray2[i2] = input.readInt32();
                            input.readTag();
                            ++i2;
                        }
                        newArray2[i2] = input.readInt32();
                        this.bucketEndPoints = newArray2;
                        continue block14;
                    }
                    case 66: {
                        length = input.readRawVarint32();
                        limit = input.pushLimit(length);
                        int arrayLength = 0;
                        startPos = input.getPosition();
                        while (input.getBytesUntilLimit() > 0) {
                            input.readInt32();
                            ++arrayLength;
                        }
                        input.rewindToPosition(startPos);
                        i = this.bucketEndPoints == null ? 0 : this.bucketEndPoints.length;
                        newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.bucketEndPoints, 0, newArray, 0, i);
                        }
                        while (i < newArray.length) {
                            newArray[i] = input.readInt32();
                            ++i;
                        }
                        this.bucketEndPoints = newArray;
                        input.popLimit(limit);
                        continue block14;
                    }
                    case 72: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 72);
                        int i2 = this.bucketCounters == null ? 0 : this.bucketCounters.length;
                        int[] newArray3 = new int[i2 + arrayLength];
                        if (i2 != 0) {
                            System.arraycopy(this.bucketCounters, 0, newArray3, 0, i2);
                        }
                        while (i2 < newArray3.length - 1) {
                            newArray3[i2] = input.readInt32();
                            input.readTag();
                            ++i2;
                        }
                        newArray3[i2] = input.readInt32();
                        this.bucketCounters = newArray3;
                        continue block14;
                    }
                    case 74: 
                }
                length = input.readRawVarint32();
                limit = input.pushLimit(length);
                int arrayLength = 0;
                startPos = input.getPosition();
                while (input.getBytesUntilLimit() > 0) {
                    input.readInt32();
                    ++arrayLength;
                }
                input.rewindToPosition(startPos);
                i = this.bucketCounters == null ? 0 : this.bucketCounters.length;
                newArray = new int[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.bucketCounters, 0, newArray, 0, i);
                }
                while (i < newArray.length) {
                    newArray[i] = input.readInt32();
                    ++i;
                }
                this.bucketCounters = newArray;
                input.popLimit(limit);
            }
        }

        public static TelephonyHistogram parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new TelephonyHistogram(), data);
        }

        public static TelephonyHistogram parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new TelephonyHistogram().mergeFrom(input);
        }
    }

    public static final class Time
    extends ExtendableMessageNano<Time> {
        private static volatile Time[] _emptyArray;
        public long systemTimestampMillis;
        public long elapsedTimestampMillis;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Time[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new Time[0];
                    }
                }
            }
            return _emptyArray;
        }

        public Time() {
            this.clear();
        }

        public Time clear() {
            this.systemTimestampMillis = 0L;
            this.elapsedTimestampMillis = 0L;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.systemTimestampMillis != 0L) {
                output.writeInt64(1, this.systemTimestampMillis);
            }
            if (this.elapsedTimestampMillis != 0L) {
                output.writeInt64(2, this.elapsedTimestampMillis);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.systemTimestampMillis != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.systemTimestampMillis);
            }
            if (this.elapsedTimestampMillis != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(2, this.elapsedTimestampMillis);
            }
            return size;
        }

        @Override
        public Time mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block5: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block5;
                        return this;
                    }
                    case 8: {
                        this.systemTimestampMillis = input.readInt64();
                        continue block5;
                    }
                    case 16: 
                }
                this.elapsedTimestampMillis = input.readInt64();
            }
        }

        public static Time parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new Time(), data);
        }

        public static Time parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new Time().mergeFrom(input);
        }
    }

    public static final class TelephonyLog
    extends ExtendableMessageNano<TelephonyLog> {
        private static volatile TelephonyLog[] _emptyArray;
        public TelephonyEvent[] events;
        public TelephonyCallSession[] callSessions;
        public SmsSession[] smsSessions;
        public TelephonyHistogram[] histograms;
        public boolean eventsDropped;
        public Time startTime;
        public Time endTime;
        public ModemPowerStats modemPowerStats;
        public String hardwareRevision;
        public ActiveSubscriptionInfo[] lastActiveSubscriptionInfo;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TelephonyLog[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new TelephonyLog[0];
                    }
                }
            }
            return _emptyArray;
        }

        public TelephonyLog() {
            this.clear();
        }

        public TelephonyLog clear() {
            this.events = TelephonyEvent.emptyArray();
            this.callSessions = TelephonyCallSession.emptyArray();
            this.smsSessions = SmsSession.emptyArray();
            this.histograms = TelephonyHistogram.emptyArray();
            this.eventsDropped = false;
            this.startTime = null;
            this.endTime = null;
            this.modemPowerStats = null;
            this.hardwareRevision = "";
            this.lastActiveSubscriptionInfo = ActiveSubscriptionInfo.emptyArray();
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            ExtendableMessageNano element;
            int i;
            if (this.events != null && this.events.length > 0) {
                for (i = 0; i < this.events.length; ++i) {
                    element = this.events[i];
                    if (element == null) continue;
                    output.writeMessage(1, element);
                }
            }
            if (this.callSessions != null && this.callSessions.length > 0) {
                for (i = 0; i < this.callSessions.length; ++i) {
                    element = this.callSessions[i];
                    if (element == null) continue;
                    output.writeMessage(2, element);
                }
            }
            if (this.smsSessions != null && this.smsSessions.length > 0) {
                for (i = 0; i < this.smsSessions.length; ++i) {
                    element = this.smsSessions[i];
                    if (element == null) continue;
                    output.writeMessage(3, element);
                }
            }
            if (this.histograms != null && this.histograms.length > 0) {
                for (i = 0; i < this.histograms.length; ++i) {
                    element = this.histograms[i];
                    if (element == null) continue;
                    output.writeMessage(4, element);
                }
            }
            if (this.eventsDropped) {
                output.writeBool(5, this.eventsDropped);
            }
            if (this.startTime != null) {
                output.writeMessage(6, this.startTime);
            }
            if (this.endTime != null) {
                output.writeMessage(7, this.endTime);
            }
            if (this.modemPowerStats != null) {
                output.writeMessage(8, this.modemPowerStats);
            }
            if (!this.hardwareRevision.equals("")) {
                output.writeString(9, this.hardwareRevision);
            }
            if (this.lastActiveSubscriptionInfo != null && this.lastActiveSubscriptionInfo.length > 0) {
                for (i = 0; i < this.lastActiveSubscriptionInfo.length; ++i) {
                    element = this.lastActiveSubscriptionInfo[i];
                    if (element == null) continue;
                    output.writeMessage(10, element);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            ExtendableMessageNano element;
            int i;
            int size = super.computeSerializedSize();
            if (this.events != null && this.events.length > 0) {
                for (i = 0; i < this.events.length; ++i) {
                    element = this.events[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(1, element);
                }
            }
            if (this.callSessions != null && this.callSessions.length > 0) {
                for (i = 0; i < this.callSessions.length; ++i) {
                    element = this.callSessions[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(2, element);
                }
            }
            if (this.smsSessions != null && this.smsSessions.length > 0) {
                for (i = 0; i < this.smsSessions.length; ++i) {
                    element = this.smsSessions[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(3, element);
                }
            }
            if (this.histograms != null && this.histograms.length > 0) {
                for (i = 0; i < this.histograms.length; ++i) {
                    element = this.histograms[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(4, element);
                }
            }
            if (this.eventsDropped) {
                size += CodedOutputByteBufferNano.computeBoolSize(5, this.eventsDropped);
            }
            if (this.startTime != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(6, this.startTime);
            }
            if (this.endTime != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(7, this.endTime);
            }
            if (this.modemPowerStats != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(8, this.modemPowerStats);
            }
            if (!this.hardwareRevision.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(9, this.hardwareRevision);
            }
            if (this.lastActiveSubscriptionInfo != null && this.lastActiveSubscriptionInfo.length > 0) {
                for (i = 0; i < this.lastActiveSubscriptionInfo.length; ++i) {
                    element = this.lastActiveSubscriptionInfo[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(10, element);
                }
            }
            return size;
        }

        @Override
        public TelephonyLog mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block13: while (true) {
                ExtendableMessageNano[] newArray;
                int i;
                int arrayLength;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (this.storeUnknownField(input, tag)) continue block13;
                        return this;
                    }
                    case 10: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 10);
                        i = this.events == null ? 0 : this.events.length;
                        newArray = new TelephonyEvent[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.events, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new TelephonyEvent();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new TelephonyEvent();
                        input.readMessage(newArray[i]);
                        this.events = newArray;
                        continue block13;
                    }
                    case 18: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 18);
                        i = this.callSessions == null ? 0 : this.callSessions.length;
                        newArray = new TelephonyCallSession[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.callSessions, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new TelephonyCallSession();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new TelephonyCallSession();
                        input.readMessage(newArray[i]);
                        this.callSessions = newArray;
                        continue block13;
                    }
                    case 26: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 26);
                        i = this.smsSessions == null ? 0 : this.smsSessions.length;
                        newArray = new SmsSession[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.smsSessions, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new SmsSession();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new SmsSession();
                        input.readMessage(newArray[i]);
                        this.smsSessions = newArray;
                        continue block13;
                    }
                    case 34: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 34);
                        i = this.histograms == null ? 0 : this.histograms.length;
                        newArray = new TelephonyHistogram[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histograms, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new TelephonyHistogram();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new TelephonyHistogram();
                        input.readMessage(newArray[i]);
                        this.histograms = newArray;
                        continue block13;
                    }
                    case 40: {
                        this.eventsDropped = input.readBool();
                        continue block13;
                    }
                    case 50: {
                        if (this.startTime == null) {
                            this.startTime = new Time();
                        }
                        input.readMessage(this.startTime);
                        continue block13;
                    }
                    case 58: {
                        if (this.endTime == null) {
                            this.endTime = new Time();
                        }
                        input.readMessage(this.endTime);
                        continue block13;
                    }
                    case 66: {
                        if (this.modemPowerStats == null) {
                            this.modemPowerStats = new ModemPowerStats();
                        }
                        input.readMessage(this.modemPowerStats);
                        continue block13;
                    }
                    case 74: {
                        this.hardwareRevision = input.readString();
                        continue block13;
                    }
                    case 82: 
                }
                arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 82);
                i = this.lastActiveSubscriptionInfo == null ? 0 : this.lastActiveSubscriptionInfo.length;
                newArray = new ActiveSubscriptionInfo[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.lastActiveSubscriptionInfo, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new ActiveSubscriptionInfo();
                    input.readMessage(newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new ActiveSubscriptionInfo();
                input.readMessage(newArray[i]);
                this.lastActiveSubscriptionInfo = newArray;
            }
        }

        public static TelephonyLog parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new TelephonyLog(), data);
        }

        public static TelephonyLog parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new TelephonyLog().mergeFrom(input);
        }
    }

    public static interface TimeInterval {
        public static final int TI_UNKNOWN = 0;
        public static final int TI_10_MILLIS = 1;
        public static final int TI_20_MILLIS = 2;
        public static final int TI_50_MILLIS = 3;
        public static final int TI_100_MILLIS = 4;
        public static final int TI_200_MILLIS = 5;
        public static final int TI_500_MILLIS = 6;
        public static final int TI_1_SEC = 7;
        public static final int TI_2_SEC = 8;
        public static final int TI_5_SEC = 9;
        public static final int TI_10_SEC = 10;
        public static final int TI_30_SEC = 11;
        public static final int TI_1_MINUTE = 12;
        public static final int TI_3_MINUTES = 13;
        public static final int TI_10_MINUTES = 14;
        public static final int TI_30_MINUTES = 15;
        public static final int TI_1_HOUR = 16;
        public static final int TI_2_HOURS = 17;
        public static final int TI_4_HOURS = 18;
        public static final int TI_MANY_HOURS = 19;
    }

    public static interface SimState {
        public static final int SIM_STATE_UNKNOWN = 0;
        public static final int SIM_STATE_ABSENT = 1;
        public static final int SIM_STATE_LOADED = 2;
    }

    public static interface PdpType {
        public static final int PDP_UNKNOWN = 0;
        public static final int PDP_TYPE_IP = 1;
        public static final int PDP_TYPE_IPV6 = 2;
        public static final int PDP_TYPE_IPV4V6 = 3;
        public static final int PDP_TYPE_PPP = 4;
        public static final int PDP_TYPE_NON_IP = 5;
        public static final int PDP_TYPE_UNSTRUCTURED = 6;
    }

    public static interface ImsServiceErrno {
        public static final int IMS_E_UNKNOWN = 0;
        public static final int IMS_E_SUCCESS = 1;
        public static final int IMS_E_SMS_SEND_STATUS_ERROR = 2;
        public static final int IMS_E_SMS_SEND_STATUS_ERROR_RETRY = 3;
        public static final int IMS_E_SMS_SEND_STATUS_ERROR_FALLBACK = 4;
    }

    public static interface RilErrno {
        public static final int RIL_E_UNKNOWN = 0;
        public static final int RIL_E_SUCCESS = 1;
        public static final int RIL_E_RADIO_NOT_AVAILABLE = 2;
        public static final int RIL_E_GENERIC_FAILURE = 3;
        public static final int RIL_E_PASSWORD_INCORRECT = 4;
        public static final int RIL_E_SIM_PIN2 = 5;
        public static final int RIL_E_SIM_PUK2 = 6;
        public static final int RIL_E_REQUEST_NOT_SUPPORTED = 7;
        public static final int RIL_E_CANCELLED = 8;
        public static final int RIL_E_OP_NOT_ALLOWED_DURING_VOICE_CALL = 9;
        public static final int RIL_E_OP_NOT_ALLOWED_BEFORE_REG_TO_NW = 10;
        public static final int RIL_E_SMS_SEND_FAIL_RETRY = 11;
        public static final int RIL_E_SIM_ABSENT = 12;
        public static final int RIL_E_SUBSCRIPTION_NOT_AVAILABLE = 13;
        public static final int RIL_E_MODE_NOT_SUPPORTED = 14;
        public static final int RIL_E_FDN_CHECK_FAILURE = 15;
        public static final int RIL_E_ILLEGAL_SIM_OR_ME = 16;
        public static final int RIL_E_MISSING_RESOURCE = 17;
        public static final int RIL_E_NO_SUCH_ELEMENT = 18;
        public static final int RIL_E_DIAL_MODIFIED_TO_USSD = 19;
        public static final int RIL_E_DIAL_MODIFIED_TO_SS = 20;
        public static final int RIL_E_DIAL_MODIFIED_TO_DIAL = 21;
        public static final int RIL_E_USSD_MODIFIED_TO_DIAL = 22;
        public static final int RIL_E_USSD_MODIFIED_TO_SS = 23;
        public static final int RIL_E_USSD_MODIFIED_TO_USSD = 24;
        public static final int RIL_E_SS_MODIFIED_TO_DIAL = 25;
        public static final int RIL_E_SS_MODIFIED_TO_USSD = 26;
        public static final int RIL_E_SUBSCRIPTION_NOT_SUPPORTED = 27;
        public static final int RIL_E_SS_MODIFIED_TO_SS = 28;
        public static final int RIL_E_LCE_NOT_SUPPORTED = 36;
        public static final int RIL_E_LCE_NOT_SUPPORTED_NEW = 37;
        public static final int RIL_E_NO_MEMORY = 38;
        public static final int RIL_E_INTERNAL_ERR = 39;
        public static final int RIL_E_SYSTEM_ERR = 40;
        public static final int RIL_E_MODEM_ERR = 41;
        public static final int RIL_E_INVALID_STATE = 42;
        public static final int RIL_E_NO_RESOURCES = 43;
        public static final int RIL_E_SIM_ERR = 44;
        public static final int RIL_E_INVALID_ARGUMENTS = 45;
        public static final int RIL_E_INVALID_SIM_STATE = 46;
        public static final int RIL_E_INVALID_MODEM_STATE = 47;
        public static final int RIL_E_INVALID_CALL_ID = 48;
        public static final int RIL_E_NO_SMS_TO_ACK = 49;
        public static final int RIL_E_NETWORK_ERR = 50;
        public static final int RIL_E_REQUEST_RATE_LIMITED = 51;
        public static final int RIL_E_SIM_BUSY = 52;
        public static final int RIL_E_SIM_FULL = 53;
        public static final int RIL_E_NETWORK_REJECT = 54;
        public static final int RIL_E_OPERATION_NOT_ALLOWED = 55;
        public static final int RIL_E_EMPTY_RECORD = 56;
        public static final int RIL_E_INVALID_SMS_FORMAT = 57;
        public static final int RIL_E_ENCODING_ERR = 58;
        public static final int RIL_E_INVALID_SMSC_ADDRESS = 59;
        public static final int RIL_E_NO_SUCH_ENTRY = 60;
        public static final int RIL_E_NETWORK_NOT_READY = 61;
        public static final int RIL_E_NOT_PROVISIONED = 62;
        public static final int RIL_E_NO_SUBSCRIPTION = 63;
        public static final int RIL_E_NO_NETWORK_FOUND = 64;
        public static final int RIL_E_DEVICE_IN_USE = 65;
        public static final int RIL_E_ABORTED = 66;
        public static final int RIL_E_INVALID_RESPONSE = 67;
    }

    public static interface RadioAccessTechnology {
        public static final int UNKNOWN = -1;
        public static final int RAT_UNKNOWN = 0;
        public static final int RAT_GPRS = 1;
        public static final int RAT_EDGE = 2;
        public static final int RAT_UMTS = 3;
        public static final int RAT_IS95A = 4;
        public static final int RAT_IS95B = 5;
        public static final int RAT_1XRTT = 6;
        public static final int RAT_EVDO_0 = 7;
        public static final int RAT_EVDO_A = 8;
        public static final int RAT_HSDPA = 9;
        public static final int RAT_HSUPA = 10;
        public static final int RAT_HSPA = 11;
        public static final int RAT_EVDO_B = 12;
        public static final int RAT_EHRPD = 13;
        public static final int RAT_LTE = 14;
        public static final int RAT_HSPAP = 15;
        public static final int RAT_GSM = 16;
        public static final int RAT_TD_SCDMA = 17;
        public static final int RAT_IWLAN = 18;
        public static final int RAT_LTE_CA = 19;
    }
}

