/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.uicc.IccUtils;
import java.util.Arrays;

public class AdnRecord
implements Parcelable {
    static final String LOG_TAG = "AdnRecord";
    @UnsupportedAppUsage
    String mAlphaTag = null;
    @UnsupportedAppUsage
    String mNumber = null;
    @UnsupportedAppUsage
    String[] mEmails;
    @UnsupportedAppUsage
    int mExtRecord = 255;
    @UnsupportedAppUsage
    int mEfid;
    @UnsupportedAppUsage
    int mRecordNumber;
    static final int FOOTER_SIZE_BYTES = 14;
    static final int MAX_NUMBER_SIZE_BYTES = 11;
    static final int EXT_RECORD_LENGTH_BYTES = 13;
    static final int EXT_RECORD_TYPE_ADDITIONAL_DATA = 2;
    static final int EXT_RECORD_TYPE_MASK = 3;
    static final int MAX_EXT_CALLED_PARTY_LENGTH = 10;
    static final int ADN_BCD_NUMBER_LENGTH = 0;
    static final int ADN_TON_AND_NPI = 1;
    static final int ADN_DIALING_NUMBER_START = 2;
    static final int ADN_DIALING_NUMBER_END = 11;
    static final int ADN_CAPABILITY_ID = 12;
    static final int ADN_EXTENSION_ID = 13;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<AdnRecord> CREATOR = new Parcelable.Creator<AdnRecord>(){

        @Override
        public AdnRecord createFromParcel(Parcel source) {
            int efid = source.readInt();
            int recordNumber = source.readInt();
            String alphaTag = source.readString();
            String number = source.readString();
            String[] emails = source.readStringArray();
            return new AdnRecord(efid, recordNumber, alphaTag, number, emails);
        }

        public AdnRecord[] newArray(int size) {
            return new AdnRecord[size];
        }
    };

    @UnsupportedAppUsage
    public AdnRecord(byte[] record) {
        this(0, 0, record);
    }

    @UnsupportedAppUsage
    public AdnRecord(int efid, int recordNumber, byte[] record) {
        this.mEfid = efid;
        this.mRecordNumber = recordNumber;
        this.parseRecord(record);
    }

    @UnsupportedAppUsage
    public AdnRecord(String alphaTag, String number) {
        this(0, 0, alphaTag, number);
    }

    @UnsupportedAppUsage
    public AdnRecord(String alphaTag, String number, String[] emails) {
        this(0, 0, alphaTag, number, emails);
    }

    @UnsupportedAppUsage
    public AdnRecord(int efid, int recordNumber, String alphaTag, String number, String[] emails) {
        this.mEfid = efid;
        this.mRecordNumber = recordNumber;
        this.mAlphaTag = alphaTag;
        this.mNumber = number;
        this.mEmails = emails;
    }

    @UnsupportedAppUsage
    public AdnRecord(int efid, int recordNumber, String alphaTag, String number) {
        this.mEfid = efid;
        this.mRecordNumber = recordNumber;
        this.mAlphaTag = alphaTag;
        this.mNumber = number;
        this.mEmails = null;
    }

    public String getAlphaTag() {
        return this.mAlphaTag;
    }

    public int getEfid() {
        return this.mEfid;
    }

    public int getRecId() {
        return this.mRecordNumber;
    }

    @UnsupportedAppUsage
    public String getNumber() {
        return this.mNumber;
    }

    public void setNumber(String number) {
        this.mNumber = number;
    }

    @UnsupportedAppUsage
    public String[] getEmails() {
        return this.mEmails;
    }

    @UnsupportedAppUsage
    public void setEmails(String[] emails) {
        this.mEmails = emails;
    }

    public String toString() {
        return "ADN Record '" + this.mAlphaTag + "' '" + Rlog.pii(LOG_TAG, (Object)this.mNumber) + " " + Rlog.pii(LOG_TAG, (Object)this.mEmails) + "'";
    }

    @UnsupportedAppUsage
    public boolean isEmpty() {
        return TextUtils.isEmpty(this.mAlphaTag) && TextUtils.isEmpty(this.mNumber) && this.mEmails == null;
    }

    public boolean hasExtendedRecord() {
        return this.mExtRecord != 0 && this.mExtRecord != 255;
    }

    private static boolean stringCompareNullEqualsEmpty(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.equals(s2);
    }

    public boolean isEqual(AdnRecord adn) {
        return AdnRecord.stringCompareNullEqualsEmpty(this.mAlphaTag, adn.mAlphaTag) && AdnRecord.stringCompareNullEqualsEmpty(this.mNumber, adn.mNumber) && Arrays.equals(this.mEmails, adn.mEmails);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mEfid);
        dest.writeInt(this.mRecordNumber);
        dest.writeString(this.mAlphaTag);
        dest.writeString(this.mNumber);
        dest.writeStringArray(this.mEmails);
    }

    @UnsupportedAppUsage
    public byte[] buildAdnString(int recordSize) {
        byte[] byteTag;
        int footerOffset = recordSize - 14;
        byte[] adnString = new byte[recordSize];
        for (int i = 0; i < recordSize; ++i) {
            adnString[i] = -1;
        }
        if (TextUtils.isEmpty(this.mNumber)) {
            Rlog.w(LOG_TAG, "[buildAdnString] Empty dialing number");
            return adnString;
        }
        if (this.mNumber.length() > 20) {
            Rlog.w(LOG_TAG, "[buildAdnString] Max length of dialing number is 20");
            return null;
        }
        byte[] byArray = byteTag = !TextUtils.isEmpty(this.mAlphaTag) ? GsmAlphabet.stringToGsm8BitPacked(this.mAlphaTag) : new byte[]{};
        if (byteTag.length > footerOffset) {
            Rlog.w(LOG_TAG, "[buildAdnString] Max length of tag is " + footerOffset);
            return null;
        }
        byte[] bcdNumber = PhoneNumberUtils.numberToCalledPartyBCD(this.mNumber, 1);
        System.arraycopy(bcdNumber, 0, adnString, footerOffset + 1, bcdNumber.length);
        adnString[footerOffset + 0] = (byte)bcdNumber.length;
        adnString[footerOffset + 12] = -1;
        adnString[footerOffset + 13] = -1;
        if (byteTag.length > 0) {
            System.arraycopy(byteTag, 0, adnString, 0, byteTag.length);
        }
        return adnString;
    }

    public void appendExtRecord(byte[] extRecord) {
        try {
            if (extRecord.length != 13) {
                return;
            }
            if ((extRecord[0] & 3) != 2) {
                return;
            }
            if ((0xFF & extRecord[1]) > 10) {
                return;
            }
            this.mNumber = this.mNumber + PhoneNumberUtils.calledPartyBCDFragmentToString(extRecord, 2, 0xFF & extRecord[1], 1);
        }
        catch (RuntimeException ex) {
            Rlog.w(LOG_TAG, "Error parsing AdnRecord ext record", ex);
        }
    }

    private void parseRecord(byte[] record) {
        try {
            this.mAlphaTag = IccUtils.adnStringFieldToString(record, 0, record.length - 14);
            int footerOffset = record.length - 14;
            int numberLength = 0xFF & record[footerOffset];
            if (numberLength > 11) {
                this.mNumber = "";
                return;
            }
            this.mNumber = PhoneNumberUtils.calledPartyBCDToString(record, footerOffset + 1, numberLength, 1);
            this.mExtRecord = 0xFF & record[record.length - 1];
            this.mEmails = null;
        }
        catch (RuntimeException ex) {
            Rlog.w(LOG_TAG, "Error parsing AdnRecord", ex);
            this.mNumber = "";
            this.mAlphaTag = "";
            this.mEmails = null;
        }
    }
}

