/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.CarrierTestOverride;
import com.android.internal.telephony.uicc.IccConstants;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.PlmnActRecord;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UsimServiceTable;
import com.android.internal.util.ArrayUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class IccRecords
extends Handler
implements IccConstants {
    protected static final boolean DBG = true;
    protected static final boolean VDBG = false;
    private static final String[] MCCMNC_CODES_HAVING_3DIGITS_MNC = new String[]{"302370", "302720", "310260", "405025", "405026", "405027", "405028", "405029", "405030", "405031", "405032", "405033", "405034", "405035", "405036", "405037", "405038", "405039", "405040", "405041", "405042", "405043", "405044", "405045", "405046", "405047", "405750", "405751", "405752", "405753", "405754", "405755", "405756", "405799", "405800", "405801", "405802", "405803", "405804", "405805", "405806", "405807", "405808", "405809", "405810", "405811", "405812", "405813", "405814", "405815", "405816", "405817", "405818", "405819", "405820", "405821", "405822", "405823", "405824", "405825", "405826", "405827", "405828", "405829", "405830", "405831", "405832", "405833", "405834", "405835", "405836", "405837", "405838", "405839", "405840", "405841", "405842", "405843", "405844", "405845", "405846", "405847", "405848", "405849", "405850", "405851", "405852", "405853", "405854", "405855", "405856", "405857", "405858", "405859", "405860", "405861", "405862", "405863", "405864", "405865", "405866", "405867", "405868", "405869", "405870", "405871", "405872", "405873", "405874", "405875", "405876", "405877", "405878", "405879", "405880", "405881", "405882", "405883", "405884", "405885", "405886", "405908", "405909", "405910", "405911", "405912", "405913", "405914", "405915", "405916", "405917", "405918", "405919", "405920", "405921", "405922", "405923", "405924", "405925", "405926", "405927", "405928", "405929", "405930", "405931", "405932", "502142", "502143", "502145", "502146", "502147", "502148"};
    @UnsupportedAppUsage
    protected AtomicBoolean mDestroyed = new AtomicBoolean(false);
    protected AtomicBoolean mLoaded = new AtomicBoolean(false);
    @UnsupportedAppUsage
    protected Context mContext;
    @UnsupportedAppUsage
    protected CommandsInterface mCi;
    @UnsupportedAppUsage
    protected IccFileHandler mFh;
    @UnsupportedAppUsage
    protected UiccCardApplication mParentApp;
    @UnsupportedAppUsage
    protected TelephonyManager mTelephonyManager;
    protected RegistrantList mRecordsLoadedRegistrants = new RegistrantList();
    protected RegistrantList mLockedRecordsLoadedRegistrants = new RegistrantList();
    protected RegistrantList mNetworkLockedRecordsLoadedRegistrants = new RegistrantList();
    protected RegistrantList mImsiReadyRegistrants = new RegistrantList();
    @UnsupportedAppUsage
    protected RegistrantList mRecordsEventsRegistrants = new RegistrantList();
    protected RegistrantList mNewSmsRegistrants = new RegistrantList();
    protected RegistrantList mNetworkSelectionModeAutomaticRegistrants = new RegistrantList();
    protected RegistrantList mSpnUpdatedRegistrants = new RegistrantList();
    protected RegistrantList mRecordsOverrideRegistrants = new RegistrantList();
    @UnsupportedAppUsage
    protected int mRecordsToLoad;
    @UnsupportedAppUsage
    protected AdnRecordCache mAdnCache;
    protected static final int LOCKED_RECORDS_REQ_REASON_NONE = 0;
    protected static final int LOCKED_RECORDS_REQ_REASON_LOCKED = 1;
    protected static final int LOCKED_RECORDS_REQ_REASON_NETWORK_LOCKED = 2;
    protected boolean mRecordsRequested = false;
    protected int mLockedRecordsReqReason = 0;
    @UnsupportedAppUsage
    protected String mIccId;
    protected String mFullIccId;
    protected String mMsisdn = null;
    protected String mMsisdnTag = null;
    protected String mNewMsisdn = null;
    protected String mNewMsisdnTag = null;
    @UnsupportedAppUsage
    protected String mVoiceMailNum = null;
    protected String mVoiceMailTag = null;
    protected String mNewVoiceMailNum = null;
    protected String mNewVoiceMailTag = null;
    @UnsupportedAppUsage
    protected boolean mIsVoiceMailFixed = false;
    @UnsupportedAppUsage
    protected String mImsi;
    @UnsupportedAppUsage
    private IccIoResult auth_rsp;
    @UnsupportedAppUsage
    protected int mMncLength = -1;
    protected int mMailboxIndex = 0;
    @UnsupportedAppUsage
    private String mSpn;
    @UnsupportedAppUsage
    protected String mGid1;
    protected String mGid2;
    protected String mPnnHomeName;
    protected String mPrefLang;
    protected PlmnActRecord[] mHplmnActRecords;
    protected PlmnActRecord[] mOplmnActRecords;
    protected PlmnActRecord[] mPlmnActRecords;
    protected String[] mSpdi;
    protected int mCarrierNameDisplayCondition;
    protected String[] mEhplmns;
    protected String[] mFplmns;
    @UnsupportedAppUsage
    private final Object mLock = new Object();
    CarrierTestOverride mCarrierTestOverride;
    protected static final int HANDLER_ACTION_BASE = 1238272;
    protected static final int HANDLER_ACTION_NONE = 1238272;
    protected static final int HANDLER_ACTION_SEND_RESPONSE = 1238273;
    protected static AtomicInteger sNextRequestId = new AtomicInteger(1);
    protected final HashMap<Integer, Message> mPendingResponses = new HashMap();
    protected static final int UNINITIALIZED = -1;
    protected static final int UNKNOWN = 0;
    public static final int CARRIER_NAME_DISPLAY_CONDITION_BITMASK_PLMN = 1;
    public static final int CARRIER_NAME_DISPLAY_CONDITION_BITMASK_SPN = 2;
    public static final int INVALID_CARRIER_NAME_DISPLAY_CONDITION_BITMASK = -1;
    public static final int DEFAULT_CARRIER_NAME_DISPLAY_CONDITION = 0;
    public static final int EVENT_MWI = 0;
    public static final int EVENT_CFI = 1;
    public static final int EVENT_SPN = 2;
    public static final int EVENT_GET_ICC_RECORD_DONE = 100;
    public static final int EVENT_REFRESH = 31;
    protected static final int EVENT_APP_READY = 1;
    private static final int EVENT_AKA_AUTHENTICATE_DONE = 90;
    public static final int CALL_FORWARDING_STATUS_DISABLED = 0;
    public static final int CALL_FORWARDING_STATUS_ENABLED = 1;
    public static final int CALL_FORWARDING_STATUS_UNKNOWN = -1;
    public static final int DEFAULT_VOICE_MESSAGE_COUNT = -2;
    public static final int UNKNOWN_VOICE_MESSAGE_COUNT = -1;

    @Override
    public String toString() {
        String iccIdToPrint = SubscriptionInfo.givePrintableIccid(this.mFullIccId);
        return "mDestroyed=" + this.mDestroyed + " mContext=" + this.mContext + " mCi=" + this.mCi + " mFh=" + this.mFh + " mParentApp=" + this.mParentApp + " recordsToLoad=" + this.mRecordsToLoad + " adnCache=" + this.mAdnCache + " recordsRequested=" + this.mRecordsRequested + " lockedRecordsReqReason=" + this.mLockedRecordsReqReason + " iccid=" + iccIdToPrint + (this.mCarrierTestOverride.isInTestMode() ? "mFakeIccid=" + this.mCarrierTestOverride.getFakeIccid() : "") + " msisdnTag=" + this.mMsisdnTag + " voiceMailNum=" + Rlog.pii(false, (Object)this.mVoiceMailNum) + " voiceMailTag=" + this.mVoiceMailTag + " voiceMailNum=" + Rlog.pii(false, (Object)this.mNewVoiceMailNum) + " newVoiceMailTag=" + this.mNewVoiceMailTag + " isVoiceMailFixed=" + this.mIsVoiceMailFixed + " mImsi=" + (this.mImsi != null ? this.mImsi.substring(0, 6) + Rlog.pii(false, (Object)this.mImsi.substring(6)) : "null") + (this.mCarrierTestOverride.isInTestMode() ? " mFakeImsi=" + this.mCarrierTestOverride.getFakeIMSI() : "") + " mncLength=" + this.mMncLength + " mailboxIndex=" + this.mMailboxIndex + " spn=" + this.mSpn + (this.mCarrierTestOverride.isInTestMode() ? " mFakeSpn=" + this.mCarrierTestOverride.getFakeSpn() : "");
    }

    public IccRecords(UiccCardApplication app, Context c, CommandsInterface ci) {
        this.mContext = c;
        this.mCi = ci;
        this.mFh = app.getIccFileHandler();
        this.mParentApp = app;
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.mCarrierTestOverride = new CarrierTestOverride();
        this.mCi.registerForIccRefresh(this, 31, null);
    }

    public void setCarrierTestOverride(String mccmnc, String imsi, String iccid, String gid1, String gid2, String pnn, String spn) {
        this.mCarrierTestOverride.override(mccmnc, imsi, iccid, gid1, gid2, pnn, spn);
        this.mTelephonyManager.setSimOperatorNameForPhone(this.mParentApp.getPhoneId(), spn);
        this.mTelephonyManager.setSimOperatorNumericForPhone(this.mParentApp.getPhoneId(), mccmnc);
        this.mRecordsOverrideRegistrants.notifyRegistrants();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.mDestroyed.set(true);
        this.auth_rsp = null;
        Object object = this.mLock;
        synchronized (object) {
            this.mLock.notifyAll();
        }
        this.mCi.unregisterForIccRefresh(this);
        this.mParentApp = null;
        this.mFh = null;
        this.mCi = null;
        this.mContext = null;
        if (this.mAdnCache != null) {
            this.mAdnCache.reset();
        }
        this.mLoaded.set(false);
    }

    public abstract void onReady();

    public AdnRecordCache getAdnCache() {
        return this.mAdnCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int storePendingResponseMessage(Message msg) {
        int key = sNextRequestId.getAndIncrement();
        HashMap<Integer, Message> hashMap = this.mPendingResponses;
        synchronized (hashMap) {
            this.mPendingResponses.put(key, msg);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message retrievePendingResponseMessage(Integer key) {
        HashMap<Integer, Message> hashMap = this.mPendingResponses;
        synchronized (hashMap) {
            return this.mPendingResponses.remove(key);
        }
    }

    @UnsupportedAppUsage
    public String getIccId() {
        if (this.mCarrierTestOverride.isInTestMode() && this.mCarrierTestOverride.getFakeIccid() != null) {
            return this.mCarrierTestOverride.getFakeIccid();
        }
        return this.mIccId;
    }

    public String getFullIccId() {
        return this.mFullIccId;
    }

    @UnsupportedAppUsage
    public void registerForRecordsLoaded(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mRecordsLoadedRegistrants.add(r);
        if (this.getRecordsLoaded()) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    @UnsupportedAppUsage
    public void unregisterForRecordsLoaded(Handler h) {
        this.mRecordsLoadedRegistrants.remove(h);
    }

    public void unregisterForRecordsOverride(Handler h) {
        this.mRecordsOverrideRegistrants.remove(h);
    }

    public void registerForRecordsOverride(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mRecordsOverrideRegistrants.add(r);
        if (this.getRecordsLoaded()) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void registerForLockedRecordsLoaded(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mLockedRecordsLoadedRegistrants.add(r);
        if (this.getLockedRecordsLoaded()) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForLockedRecordsLoaded(Handler h) {
        this.mLockedRecordsLoadedRegistrants.remove(h);
    }

    public void registerForNetworkLockedRecordsLoaded(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkLockedRecordsLoadedRegistrants.add(r);
        if (this.getNetworkLockedRecordsLoaded()) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForNetworkLockedRecordsLoaded(Handler h) {
        this.mNetworkLockedRecordsLoadedRegistrants.remove(h);
    }

    public void registerForImsiReady(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mImsiReadyRegistrants.add(r);
        if (this.getIMSI() != null) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForImsiReady(Handler h) {
        this.mImsiReadyRegistrants.remove(h);
    }

    public void registerForSpnUpdate(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mSpnUpdatedRegistrants.add(r);
        if (!TextUtils.isEmpty(this.mSpn)) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForSpnUpdate(Handler h) {
        this.mSpnUpdatedRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public void registerForRecordsEvents(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mRecordsEventsRegistrants.add(r);
        r.notifyResult(0);
        r.notifyResult(1);
    }

    @UnsupportedAppUsage
    public void unregisterForRecordsEvents(Handler h) {
        this.mRecordsEventsRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public void registerForNewSms(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNewSmsRegistrants.add(r);
    }

    @UnsupportedAppUsage
    public void unregisterForNewSms(Handler h) {
        this.mNewSmsRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public void registerForNetworkSelectionModeAutomatic(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkSelectionModeAutomaticRegistrants.add(r);
    }

    @UnsupportedAppUsage
    public void unregisterForNetworkSelectionModeAutomatic(Handler h) {
        this.mNetworkSelectionModeAutomaticRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public String getIMSI() {
        if (this.mCarrierTestOverride.isInTestMode() && this.mCarrierTestOverride.getFakeIMSI() != null) {
            return this.mCarrierTestOverride.getFakeIMSI();
        }
        return this.mImsi;
    }

    public void setImsi(String inImsi) {
        this.mImsi = IccUtils.stripTrailingFs(inImsi);
        if (!Objects.equals(this.mImsi, inImsi)) {
            this.loge("Invalid IMSI padding digits received.");
        }
        if (TextUtils.isEmpty(this.mImsi)) {
            this.mImsi = null;
        }
        if (this.mImsi != null && !this.mImsi.matches("[0-9]+")) {
            this.loge("Invalid non-numeric IMSI digits received.");
            this.mImsi = null;
        }
        if (this.mImsi != null && (this.mImsi.length() < 6 || this.mImsi.length() > 15)) {
            this.loge("invalid IMSI " + this.mImsi);
            this.mImsi = null;
        }
        this.log("IMSI: mMncLength=" + this.mMncLength);
        if (this.mImsi != null && this.mImsi.length() >= 6) {
            this.log("IMSI: " + this.mImsi.substring(0, 6) + Rlog.pii(false, (Object)this.mImsi.substring(6)));
        }
        this.updateOperatorPlmn();
        this.mImsiReadyRegistrants.notifyRegistrants();
    }

    protected void updateOperatorPlmn() {
        String imsi = this.getIMSI();
        if (imsi != null) {
            if ((this.mMncLength == 0 || this.mMncLength == 2) && imsi.length() >= 6) {
                String mccmncCode = imsi.substring(0, 6);
                for (String mccmnc : MCCMNC_CODES_HAVING_3DIGITS_MNC) {
                    if (!mccmnc.equals(mccmncCode)) continue;
                    this.mMncLength = 3;
                    this.log("IMSI: setting1 mMncLength=" + this.mMncLength);
                    break;
                }
            }
            if (this.mMncLength == 0) {
                try {
                    int mcc = Integer.parseInt(imsi.substring(0, 3));
                    this.mMncLength = MccTable.smallestDigitsMccForMnc(mcc);
                    this.log("setting2 mMncLength=" + this.mMncLength);
                }
                catch (NumberFormatException e) {
                    this.loge("Corrupt IMSI! setting3 mMncLength=" + this.mMncLength);
                }
            }
            if (this.mMncLength != 0 && this.mMncLength != -1 && imsi.length() >= 3 + this.mMncLength) {
                this.log("update mccmnc=" + imsi.substring(0, 3 + this.mMncLength));
                MccTable.updateMccMncConfiguration(this.mContext, imsi.substring(0, 3 + this.mMncLength));
            }
        }
    }

    public String getNAI() {
        return null;
    }

    @UnsupportedAppUsage
    public String getMsisdnNumber() {
        return this.mMsisdn;
    }

    @UnsupportedAppUsage
    public String getGid1() {
        if (this.mCarrierTestOverride.isInTestMode() && this.mCarrierTestOverride.getFakeGid1() != null) {
            return this.mCarrierTestOverride.getFakeGid1();
        }
        return this.mGid1;
    }

    public String getGid2() {
        if (this.mCarrierTestOverride.isInTestMode() && this.mCarrierTestOverride.getFakeGid2() != null) {
            return this.mCarrierTestOverride.getFakeGid2();
        }
        return this.mGid2;
    }

    public String getPnnHomeName() {
        if (this.mCarrierTestOverride.isInTestMode() && this.mCarrierTestOverride.getFakePnnHomeName() != null) {
            return this.mCarrierTestOverride.getFakePnnHomeName();
        }
        return this.mPnnHomeName;
    }

    @UnsupportedAppUsage
    public void setMsisdnNumber(String alphaTag, String number, Message onComplete) {
        this.loge("setMsisdn() should not be invoked on base IccRecords");
        AsyncResult.forMessage((Message)onComplete).exception = new IccIoResult(106, 130, (byte[])null).getException();
        onComplete.sendToTarget();
    }

    public String getMsisdnAlphaTag() {
        return this.mMsisdnTag;
    }

    public String getVoiceMailNumber() {
        return this.mVoiceMailNum;
    }

    @UnsupportedAppUsage
    public String getServiceProviderName() {
        if (this.mCarrierTestOverride.isInTestMode() && this.mCarrierTestOverride.getFakeSpn() != null) {
            return this.mCarrierTestOverride.getFakeSpn();
        }
        return this.mSpn;
    }

    protected void setServiceProviderName(String spn) {
        if (!TextUtils.equals(this.mSpn, spn)) {
            this.mSpn = spn != null ? spn.trim() : null;
            this.mSpnUpdatedRegistrants.notifyRegistrants();
        }
    }

    public abstract void setVoiceMailNumber(String var1, String var2, Message var3);

    public String getVoiceMailAlphaTag() {
        return this.mVoiceMailTag;
    }

    public abstract void setVoiceMessageWaiting(int var1, int var2);

    public abstract int getVoiceMessageCount();

    public abstract void onRefresh(boolean var1, int[] var2);

    @UnsupportedAppUsage
    public boolean getRecordsLoaded() {
        return this.mRecordsToLoad == 0 && this.mRecordsRequested;
    }

    protected boolean getLockedRecordsLoaded() {
        return this.mRecordsToLoad == 0 && this.mLockedRecordsReqReason == 1;
    }

    protected boolean getNetworkLockedRecordsLoaded() {
        return this.mRecordsToLoad == 0 && this.mLockedRecordsReqReason == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                try {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    IccRecordLoaded recordLoaded = (IccRecordLoaded)ar.userObj;
                    this.log(recordLoaded.getEfName() + " LOADED");
                    if (ar.exception != null) {
                        this.loge("Record Load Exception: " + ar.exception);
                        break;
                    }
                    recordLoaded.onRecordLoaded(ar);
                    break;
                }
                catch (RuntimeException exc) {
                    this.loge("Exception parsing SIM record: " + exc);
                    break;
                }
                finally {
                    this.onRecordLoaded();
                }
            }
            case 31: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.log("Card REFRESH occurred: ");
                if (ar.exception == null) {
                    this.handleRefresh((IccRefreshResponse)ar.result);
                    break;
                }
                this.loge("Icc refresh Exception: " + ar.exception);
                break;
            }
            case 90: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.auth_rsp = null;
                this.log("EVENT_AKA_AUTHENTICATE_DONE");
                if (ar.exception != null) {
                    this.loge("Exception ICC SIM AKA: " + ar.exception);
                } else {
                    try {
                        this.auth_rsp = (IccIoResult)ar.result;
                        this.log("ICC SIM AKA: auth_rsp = " + this.auth_rsp);
                    }
                    catch (Exception e) {
                        this.loge("Failed to parse ICC SIM AKA contents: " + e);
                    }
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notifyAll();
                    break;
                }
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    public String getSimLanguage() {
        return this.mPrefLang;
    }

    protected void setSimLanguage(byte[] efLi, byte[] efPl) {
        String[] locales = this.mContext.getAssets().getLocales();
        try {
            this.mPrefLang = IccRecords.findBestLanguage(efLi, locales);
        }
        catch (UnsupportedEncodingException uee) {
            this.log("Unable to parse EF-LI: " + Arrays.toString(efLi));
        }
        if (this.mPrefLang == null) {
            try {
                this.mPrefLang = IccRecords.findBestLanguage(efPl, locales);
            }
            catch (UnsupportedEncodingException uee) {
                this.log("Unable to parse EF-PL: " + Arrays.toString(efLi));
            }
        }
    }

    protected static String findBestLanguage(byte[] languages, String[] locales) throws UnsupportedEncodingException {
        if (languages == null || locales == null) {
            return null;
        }
        int i = 0;
        while (i + 1 < languages.length) {
            String lang = new String(languages, i, 2, "ISO-8859-1");
            for (int j = 0; j < locales.length; ++j) {
                if (locales[j] == null || locales[j].length() < 2 || !locales[j].substring(0, 2).equalsIgnoreCase(lang)) continue;
                return lang;
            }
            i += 2;
        }
        return null;
    }

    protected abstract void handleFileUpdate(int var1);

    @UnsupportedAppUsage
    protected void handleRefresh(IccRefreshResponse refreshResponse) {
        if (refreshResponse == null) {
            this.log("handleRefresh received without input");
            return;
        }
        if (!TextUtils.isEmpty(refreshResponse.aid) && !refreshResponse.aid.equals(this.mParentApp.getAid())) {
            return;
        }
        switch (refreshResponse.refreshResult) {
            case 0: {
                this.log("handleRefresh with SIM_FILE_UPDATED");
                this.handleFileUpdate(refreshResponse.efId);
                break;
            }
            default: {
                this.log("handleRefresh with unknown operation");
            }
        }
    }

    protected abstract void onRecordLoaded();

    protected abstract void onAllRecordsLoaded();

    public int getCarrierNameDisplayCondition() {
        return this.mCarrierNameDisplayCondition;
    }

    public String[] getServiceProviderDisplayInformation() {
        return this.mSpdi;
    }

    public String[] getHomePlmns() {
        String hplmn = this.getOperatorNumeric();
        String[] hplmns = this.getEhplmns();
        String[] spdi = this.getServiceProviderDisplayInformation();
        if (ArrayUtils.isEmpty(hplmns)) {
            hplmns = new String[]{hplmn};
        }
        if (!ArrayUtils.isEmpty(spdi)) {
            hplmns = ArrayUtils.concatElements(String.class, hplmns, spdi);
        }
        return hplmns;
    }

    public boolean isCspPlmnEnabled() {
        return false;
    }

    @UnsupportedAppUsage
    public String getOperatorNumeric() {
        return null;
    }

    public int getVoiceCallForwardingFlag() {
        return -1;
    }

    @UnsupportedAppUsage
    public void setVoiceCallForwardingFlag(int line, boolean enable, String number) {
    }

    public boolean isLoaded() {
        return this.mLoaded.get();
    }

    public boolean isProvisioned() {
        return true;
    }

    @UnsupportedAppUsage
    protected abstract void log(String var1);

    protected abstract void loge(String var1);

    public String[] getEhplmns() {
        return this.mEhplmns;
    }

    public String[] getPlmnsFromHplmnActRecord() {
        if (this.mHplmnActRecords == null) {
            return null;
        }
        String[] hplmns = new String[this.mHplmnActRecords.length];
        for (int i = 0; i < this.mHplmnActRecords.length; ++i) {
            hplmns[i] = this.mHplmnActRecords[i].plmn;
        }
        return hplmns;
    }

    public IsimRecords getIsimRecords() {
        return null;
    }

    @UnsupportedAppUsage
    public UsimServiceTable getUsimServiceTable() {
        return null;
    }

    protected void setSystemProperty(String key, String val) {
        TelephonyManager.getDefault();
        TelephonyManager.setTelephonyProperty(this.mParentApp.getPhoneId(), key, val);
        this.log("[key, value]=" + key + ", " + val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public String getIccSimChallengeResponse(int authContext, String data) {
        this.log("getIccSimChallengeResponse:");
        try {
            Object object = this.mLock;
            synchronized (object) {
                CommandsInterface ci = this.mCi;
                UiccCardApplication parentApp = this.mParentApp;
                if (ci != null && parentApp != null) {
                    ci.requestIccSimAuthentication(authContext, data, parentApp.getAid(), this.obtainMessage(90));
                    try {
                        this.mLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.loge("getIccSimChallengeResponse: Fail, interrupted while trying to request Icc Sim Auth");
                        return null;
                    }
                } else {
                    this.loge("getIccSimChallengeResponse: Fail, ci or parentApp is null");
                    return null;
                }
            }
        }
        catch (Exception e) {
            this.loge("getIccSimChallengeResponse: Fail while trying to request Icc Sim Auth");
            return null;
        }
        if (this.auth_rsp == null) {
            this.loge("getIccSimChallengeResponse: No authentication response");
            return null;
        }
        this.log("getIccSimChallengeResponse: return auth_rsp");
        return Base64.encodeToString(this.auth_rsp.payload, 2);
    }

    public static int convertSpnDisplayConditionToBitmask(int condition) {
        int carrierNameDisplayCondition = 0;
        if ((condition & 1) == 1) {
            carrierNameDisplayCondition |= 1;
        }
        if ((condition & 2) == 0) {
            carrierNameDisplayCondition |= 2;
        }
        return carrierNameDisplayCondition;
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("IccRecords: " + this);
        pw.println(" mDestroyed=" + this.mDestroyed);
        pw.println(" mCi=" + this.mCi);
        pw.println(" mFh=" + this.mFh);
        pw.println(" mParentApp=" + this.mParentApp);
        pw.println(" recordsLoadedRegistrants: size=" + this.mRecordsLoadedRegistrants.size());
        for (i = 0; i < this.mRecordsLoadedRegistrants.size(); ++i) {
            pw.println("  recordsLoadedRegistrants[" + i + "]=" + ((Registrant)this.mRecordsLoadedRegistrants.get(i)).getHandler());
        }
        pw.println(" mLockedRecordsLoadedRegistrants: size=" + this.mLockedRecordsLoadedRegistrants.size());
        for (i = 0; i < this.mLockedRecordsLoadedRegistrants.size(); ++i) {
            pw.println("  mLockedRecordsLoadedRegistrants[" + i + "]=" + ((Registrant)this.mLockedRecordsLoadedRegistrants.get(i)).getHandler());
        }
        pw.println(" mNetworkLockedRecordsLoadedRegistrants: size=" + this.mNetworkLockedRecordsLoadedRegistrants.size());
        for (i = 0; i < this.mNetworkLockedRecordsLoadedRegistrants.size(); ++i) {
            pw.println("  mLockedRecordsLoadedRegistrants[" + i + "]=" + ((Registrant)this.mNetworkLockedRecordsLoadedRegistrants.get(i)).getHandler());
        }
        pw.println(" mImsiReadyRegistrants: size=" + this.mImsiReadyRegistrants.size());
        for (i = 0; i < this.mImsiReadyRegistrants.size(); ++i) {
            pw.println("  mImsiReadyRegistrants[" + i + "]=" + ((Registrant)this.mImsiReadyRegistrants.get(i)).getHandler());
        }
        pw.println(" mRecordsEventsRegistrants: size=" + this.mRecordsEventsRegistrants.size());
        for (i = 0; i < this.mRecordsEventsRegistrants.size(); ++i) {
            pw.println("  mRecordsEventsRegistrants[" + i + "]=" + ((Registrant)this.mRecordsEventsRegistrants.get(i)).getHandler());
        }
        pw.println(" mNewSmsRegistrants: size=" + this.mNewSmsRegistrants.size());
        for (i = 0; i < this.mNewSmsRegistrants.size(); ++i) {
            pw.println("  mNewSmsRegistrants[" + i + "]=" + ((Registrant)this.mNewSmsRegistrants.get(i)).getHandler());
        }
        pw.println(" mNetworkSelectionModeAutomaticRegistrants: size=" + this.mNetworkSelectionModeAutomaticRegistrants.size());
        for (i = 0; i < this.mNetworkSelectionModeAutomaticRegistrants.size(); ++i) {
            pw.println("  mNetworkSelectionModeAutomaticRegistrants[" + i + "]=" + ((Registrant)this.mNetworkSelectionModeAutomaticRegistrants.get(i)).getHandler());
        }
        pw.println(" mRecordsRequested=" + this.mRecordsRequested);
        pw.println(" mLockedRecordsReqReason=" + this.mLockedRecordsReqReason);
        pw.println(" mRecordsToLoad=" + this.mRecordsToLoad);
        pw.println(" mRdnCache=" + this.mAdnCache);
        String iccIdToPrint = SubscriptionInfo.givePrintableIccid(this.mFullIccId);
        pw.println(" iccid=" + iccIdToPrint);
        pw.println(" mMsisdn=" + Rlog.pii(false, (Object)this.mMsisdn));
        pw.println(" mMsisdnTag=" + this.mMsisdnTag);
        pw.println(" mVoiceMailNum=" + Rlog.pii(false, (Object)this.mVoiceMailNum));
        pw.println(" mVoiceMailTag=" + this.mVoiceMailTag);
        pw.println(" mNewVoiceMailNum=" + Rlog.pii(false, (Object)this.mNewVoiceMailNum));
        pw.println(" mNewVoiceMailTag=" + this.mNewVoiceMailTag);
        pw.println(" mIsVoiceMailFixed=" + this.mIsVoiceMailFixed);
        pw.println(" mImsi=" + (this.mImsi != null ? this.mImsi.substring(0, 6) + Rlog.pii(false, (Object)this.mImsi.substring(6)) : "null"));
        if (this.mCarrierTestOverride.isInTestMode()) {
            pw.println(" mFakeImsi=" + this.mCarrierTestOverride.getFakeIMSI());
        }
        pw.println(" mMncLength=" + this.mMncLength);
        pw.println(" mMailboxIndex=" + this.mMailboxIndex);
        pw.println(" mSpn=" + this.mSpn);
        if (this.mCarrierTestOverride.isInTestMode()) {
            pw.println(" mFakeSpn=" + this.mCarrierTestOverride.getFakeSpn());
        }
        pw.flush();
    }

    public static final class PlmnNetworkName {
        public final String fullName;
        public final String shortName;

        public PlmnNetworkName(String fullName, String shortName) {
            this.fullName = fullName;
            this.shortName = shortName;
        }

        public String toString() {
            return "{ fullName = " + this.fullName + " shortName = " + this.shortName + " }";
        }
    }

    public static final class OperatorPlmnInfo {
        public final String plmnNumericPattern;
        public final int lacTacStart;
        public final int lacTacEnd;
        public final int plmnNetworkNameIndex;

        public OperatorPlmnInfo(String plmnNumericPattern, int lacTacStart, int lacTacEnd, int plmnNetworkNameIndex) {
            this.plmnNumericPattern = plmnNumericPattern;
            this.lacTacStart = lacTacStart;
            this.lacTacEnd = lacTacEnd;
            this.plmnNetworkNameIndex = plmnNetworkNameIndex;
        }

        public String toString() {
            return "{ plmnNumericPattern = " + this.plmnNumericPattern + "lacTacStart = " + this.lacTacStart + "lacTacEnd = " + this.lacTacEnd + "plmnNetworkNameIndex = " + this.plmnNetworkNameIndex + " }";
        }
    }

    public static interface IccRecordLoaded {
        public String getEfName();

        public void onRecordLoaded(AsyncResult var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CarrierNameDisplayConditionBitmask {
    }
}

