/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.telephony.SubscriptionInfo;
import android.text.TextUtils;
import com.android.internal.telephony.uicc.IccCardStatus;

public class IccSlotStatus {
    public IccCardStatus.CardState cardState;
    public SlotState slotState;
    public int logicalSlotIndex;
    public String atr;
    public String iccid;
    public String eid;

    public void setCardState(int state) {
        switch (state) {
            case 0: {
                this.cardState = IccCardStatus.CardState.CARDSTATE_ABSENT;
                break;
            }
            case 1: {
                this.cardState = IccCardStatus.CardState.CARDSTATE_PRESENT;
                break;
            }
            case 2: {
                this.cardState = IccCardStatus.CardState.CARDSTATE_ERROR;
                break;
            }
            case 3: {
                this.cardState = IccCardStatus.CardState.CARDSTATE_RESTRICTED;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized RIL_CardState: " + state);
            }
        }
    }

    public void setSlotState(int state) {
        switch (state) {
            case 0: {
                this.slotState = SlotState.SLOTSTATE_INACTIVE;
                break;
            }
            case 1: {
                this.slotState = SlotState.SLOTSTATE_ACTIVE;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized RIL_SlotState: " + state);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IccSlotStatus {").append((Object)this.cardState).append(",").append((Object)this.slotState).append(",").append("logicalSlotIndex=").append(this.logicalSlotIndex).append(",").append("atr=").append(this.atr).append(",iccid=").append(SubscriptionInfo.givePrintableIccid(this.iccid)).append(",").append("eid=").append(this.eid);
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IccSlotStatus that = (IccSlotStatus)obj;
        return this.cardState == that.cardState && this.slotState == that.slotState && this.logicalSlotIndex == that.logicalSlotIndex && TextUtils.equals(this.atr, that.atr) && TextUtils.equals(this.iccid, that.iccid) && TextUtils.equals(this.eid, that.eid);
    }

    public static enum SlotState {
        SLOTSTATE_INACTIVE,
        SLOTSTATE_ACTIVE;

    }
}

