/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.uicc.InstallCarrierAppUtils;
import java.util.concurrent.TimeUnit;

public class InstallCarrierAppTrampolineActivity
extends Activity {
    private static final String LOG_TAG = "CarrierAppInstall";
    private static final int INSTALL_CARRIER_APP_DIALOG_REQUEST = 1;
    private static final int DOWNLOAD_RESULT = 2;
    private static final String CARRIER_NAME = "carrier_name";
    private static final String BUNDLE_KEY_PACKAGE_NAME = "package_name";
    private String mPackageName;

    public static Intent get(Context context, String packageName) {
        Intent intent = new Intent(context, InstallCarrierAppTrampolineActivity.class);
        intent.putExtra(BUNDLE_KEY_PACKAGE_NAME, packageName);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mPackageName = intent.getStringExtra(BUNDLE_KEY_PACKAGE_NAME);
        }
        if (savedInstanceState == null) {
            long sleepTimeMillis = Settings.Global.getLong(this.getContentResolver(), "install_carrier_app_notification_sleep_millis", TimeUnit.HOURS.toMillis(24L));
            Log.d(LOG_TAG, "Sleeping carrier app install notification for : " + sleepTimeMillis + " millis");
            InstallCarrierAppUtils.showNotificationIfNotInstalledDelayed(this, this.mPackageName, sleepTimeMillis);
        }
        Intent showDialogIntent = new Intent();
        ComponentName dialogComponentName = ComponentName.unflattenFromString(Resources.getSystem().getString(0x1040144));
        showDialogIntent.setComponent(dialogComponentName);
        String appName = InstallCarrierAppUtils.getAppNameFromPackageName(this, this.mPackageName);
        if (!TextUtils.isEmpty(appName)) {
            showDialogIntent.putExtra(CARRIER_NAME, appName);
        }
        if (showDialogIntent.resolveActivity(this.getPackageManager()) == null) {
            Log.d(LOG_TAG, "Could not resolve activity for installing the carrier app");
            this.finishNoAnimation();
        } else {
            this.startActivityForResult(showDialogIntent, 1);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1) {
            if (resultCode == 2) {
                this.startActivity(InstallCarrierAppUtils.getPlayStoreIntent(this.mPackageName));
            }
            this.finishNoAnimation();
        }
    }

    private void finishNoAnimation() {
        this.finish();
        this.overridePendingTransition(0, 0);
    }
}

