/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.net.Uri;
import android.os.SystemClock;
import android.provider.Settings;
import android.service.notification.StatusBarNotification;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.uicc.CarrierAppInstallReceiver;
import com.android.internal.telephony.uicc.ShowInstallAppNotificationReceiver;
import java.util.Arrays;
import java.util.List;

@VisibleForTesting
public class InstallCarrierAppUtils {
    private static final int ACTIVATE_CELL_SERVICE_NOTIFICATION_ID = 12;
    private static CarrierAppInstallReceiver sCarrierAppInstallReceiver = null;

    static void showNotification(Context context, String pkgName) {
        Resources res = Resources.getSystem();
        String title = res.getString(17040139);
        String appName = InstallCarrierAppUtils.getAppNameFromPackageName(context, pkgName);
        String message = TextUtils.isEmpty(appName) ? res.getString(17040137) : res.getString(17040138, appName);
        String downloadButtonText = res.getString(17040136);
        boolean persistent = Settings.Global.getInt(context.getContentResolver(), "install_carrier_app_notification_persistent", 1) == 1;
        PendingIntent goToStore = PendingIntent.getActivity(context, 0, InstallCarrierAppUtils.getPlayStoreIntent(pkgName), 0x8000000);
        Notification.Action goToStoreAction = new Notification.Action.Builder(null, (CharSequence)downloadButtonText, goToStore).build();
        Notification notification = new Notification.Builder(context, "sim").setContentTitle(title).setContentText(message).setSmallIcon(17302811).addAction(goToStoreAction).setOngoing(persistent).setVisibility(-1).build();
        InstallCarrierAppUtils.getNotificationManager(context).notify(pkgName, 12, notification);
    }

    static void hideAllNotifications(Context context) {
        NotificationManager notificationManager = InstallCarrierAppUtils.getNotificationManager(context);
        StatusBarNotification[] activeNotifications = notificationManager.getActiveNotifications();
        if (activeNotifications == null) {
            return;
        }
        for (StatusBarNotification notification : activeNotifications) {
            if (notification.getId() != 12) continue;
            notificationManager.cancel(notification.getTag(), notification.getId());
        }
    }

    static void hideNotification(Context context, String pkgName) {
        InstallCarrierAppUtils.getNotificationManager(context).cancel(pkgName, 12);
    }

    static Intent getPlayStoreIntent(String pkgName) {
        Intent storeIntent = new Intent("android.intent.action.VIEW");
        storeIntent.setData(Uri.parse("market://details?id=" + pkgName));
        storeIntent.addFlags(0x10000000);
        return storeIntent;
    }

    static void showNotificationIfNotInstalledDelayed(Context context, String pkgName, long delayMillis) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        PendingIntent pendingIntent = PendingIntent.getBroadcast(context, 0, ShowInstallAppNotificationReceiver.get(context, pkgName), 0);
        alarmManager.set(3, SystemClock.elapsedRealtime() + delayMillis, pendingIntent);
    }

    static void registerPackageInstallReceiver(Context context) {
        if (sCarrierAppInstallReceiver == null) {
            sCarrierAppInstallReceiver = new CarrierAppInstallReceiver();
            context = context.getApplicationContext();
            IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
            intentFilter.addDataScheme("package");
            context.registerReceiver(sCarrierAppInstallReceiver, intentFilter);
        }
    }

    static void unregisterPackageInstallReceiver(Context context) {
        if (sCarrierAppInstallReceiver == null) {
            return;
        }
        context = context.getApplicationContext();
        context.unregisterReceiver(sCarrierAppInstallReceiver);
        sCarrierAppInstallReceiver = null;
    }

    static boolean isPackageInstallNotificationActive(Context context) {
        StatusBarNotification[] activeNotifications;
        for (StatusBarNotification notification : activeNotifications = InstallCarrierAppUtils.getNotificationManager(context).getActiveNotifications()) {
            if (notification.getId() != 12) continue;
            return true;
        }
        return false;
    }

    static String getAppNameFromPackageName(Context context, String packageName) {
        String whitelistSetting = Settings.Global.getString(context.getContentResolver(), "carrier_app_names");
        return InstallCarrierAppUtils.getAppNameFromPackageName(packageName, whitelistSetting);
    }

    @VisibleForTesting
    public static String getAppNameFromPackageName(String packageName, String mapString) {
        packageName = packageName.toLowerCase();
        String pairDelim = "\\s*;\\s*";
        String keyValueDelim = "\\s*:\\s*";
        if (TextUtils.isEmpty(mapString)) {
            return null;
        }
        List<String> keyValuePairList = Arrays.asList(mapString.split("\\s*;\\s*"));
        if (keyValuePairList.isEmpty()) {
            return null;
        }
        for (String keyValueString : keyValuePairList) {
            String[] keyValue = keyValueString.split("\\s*:\\s*");
            if (keyValue.length != 2 || !keyValue[0].equals(packageName)) continue;
            return keyValue[1];
        }
        return null;
    }

    private static NotificationManager getNotificationManager(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }
}

