/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class IsimUiccRecords
extends IccRecords
implements IsimRecords {
    protected static final String LOG_TAG = "IsimUiccRecords";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final boolean DUMP_RECORDS = false;
    public static final String INTENT_ISIM_REFRESH = "com.android.intent.isim_refresh";
    private static final int EVENT_APP_READY = 1;
    private static final int EVENT_ISIM_AUTHENTICATE_DONE = 91;
    @UnsupportedAppUsage
    private String mIsimImpi;
    @UnsupportedAppUsage
    private String mIsimDomain;
    @UnsupportedAppUsage
    private String[] mIsimImpu;
    @UnsupportedAppUsage
    private String mIsimIst;
    @UnsupportedAppUsage
    private String[] mIsimPcscf;
    @UnsupportedAppUsage
    private String auth_rsp;
    @UnsupportedAppUsage
    private final Object mLock = new Object();
    private static final int TAG_ISIM_VALUE = 128;

    @Override
    public String toString() {
        return "IsimUiccRecords: " + super.toString() + "";
    }

    public IsimUiccRecords(UiccCardApplication app, Context c, CommandsInterface ci) {
        super(app, c, ci);
        this.mRecordsRequested = false;
        this.mLockedRecordsReqReason = 0;
        this.mRecordsToLoad = 0;
        this.resetRecords();
        this.mParentApp.registerForReady(this, 1, null);
        this.log("IsimUiccRecords X ctor this=" + this);
    }

    @Override
    public void dispose() {
        this.log("Disposing " + this);
        this.mCi.unregisterForIccRefresh(this);
        this.mParentApp.unregisterForReady(this);
        this.resetRecords();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        if (this.mDestroyed.get()) {
            Rlog.e(LOG_TAG, "Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        this.loge("IsimUiccRecords: handleMessage " + msg + "[" + msg.what + "] ");
        try {
            switch (msg.what) {
                case 1: {
                    this.onReady();
                    break;
                }
                case 31: {
                    this.broadcastRefresh();
                    super.handleMessage(msg);
                    break;
                }
                case 91: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    this.log("EVENT_ISIM_AUTHENTICATE_DONE");
                    if (ar.exception != null) {
                        this.log("Exception ISIM AKA: " + ar.exception);
                    } else {
                        try {
                            this.auth_rsp = (String)ar.result;
                            this.log("ISIM AKA: auth_rsp = " + this.auth_rsp);
                        }
                        catch (Exception e) {
                            this.log("Failed to parse ISIM AKA contents: " + e);
                        }
                    }
                    Object e = this.mLock;
                    synchronized (e) {
                        this.mLock.notifyAll();
                        break;
                    }
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
        catch (RuntimeException exc) {
            Rlog.w(LOG_TAG, "Exception parsing SIM record", exc);
        }
    }

    @UnsupportedAppUsage
    protected void fetchIsimRecords() {
        this.mRecordsRequested = true;
        this.mFh.loadEFTransparent(28418, this.obtainMessage(100, new EfIsimImpiLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixedAll(28420, this.obtainMessage(100, new EfIsimImpuLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28419, this.obtainMessage(100, new EfIsimDomainLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28423, this.obtainMessage(100, new EfIsimIstLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixedAll(28425, this.obtainMessage(100, new EfIsimPcscfLoaded()));
        ++this.mRecordsToLoad;
        this.log("fetchIsimRecords " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
    }

    protected void resetRecords() {
        this.mIsimImpi = null;
        this.mIsimDomain = null;
        this.mIsimImpu = null;
        this.mIsimIst = null;
        this.mIsimPcscf = null;
        this.auth_rsp = null;
        this.mRecordsRequested = false;
        this.mLockedRecordsReqReason = 0;
        this.mLoaded.set(false);
    }

    @UnsupportedAppUsage
    private static String isimTlvToString(byte[] record) {
        SimTlv tlv = new SimTlv(record, 0, record.length);
        do {
            if (tlv.getTag() != 128) continue;
            return new String(tlv.getData(), Charset.forName("UTF-8"));
        } while (tlv.nextObject());
        return null;
    }

    @Override
    protected void onRecordLoaded() {
        --this.mRecordsToLoad;
        this.log("onRecordLoaded " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
        if (this.getRecordsLoaded()) {
            this.onAllRecordsLoaded();
        } else if (this.getLockedRecordsLoaded() || this.getNetworkLockedRecordsLoaded()) {
            this.onLockedAllRecordsLoaded();
        } else if (this.mRecordsToLoad < 0) {
            this.loge("recordsToLoad <0, programmer error suspected");
            this.mRecordsToLoad = 0;
        }
    }

    private void onLockedAllRecordsLoaded() {
        this.log("SIM locked; record load complete");
        if (this.mLockedRecordsReqReason == 1) {
            this.mLockedRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (this.mLockedRecordsReqReason == 2) {
            this.mNetworkLockedRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else {
            this.loge("onLockedAllRecordsLoaded: unexpected mLockedRecordsReqReason " + this.mLockedRecordsReqReason);
        }
    }

    @Override
    protected void onAllRecordsLoaded() {
        this.log("record load complete");
        this.mLoaded.set(true);
        this.mRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
    }

    @Override
    protected void handleFileUpdate(int efid) {
        switch (efid) {
            case 28418: {
                this.mFh.loadEFTransparent(28418, this.obtainMessage(100, new EfIsimImpiLoaded()));
                ++this.mRecordsToLoad;
                break;
            }
            case 28420: {
                this.mFh.loadEFLinearFixedAll(28420, this.obtainMessage(100, new EfIsimImpuLoaded()));
                ++this.mRecordsToLoad;
                break;
            }
            case 28419: {
                this.mFh.loadEFTransparent(28419, this.obtainMessage(100, new EfIsimDomainLoaded()));
                ++this.mRecordsToLoad;
                break;
            }
            case 28423: {
                this.mFh.loadEFTransparent(28423, this.obtainMessage(100, new EfIsimIstLoaded()));
                ++this.mRecordsToLoad;
                break;
            }
            case 28425: {
                this.mFh.loadEFLinearFixedAll(28425, this.obtainMessage(100, new EfIsimPcscfLoaded()));
                ++this.mRecordsToLoad;
            }
            default: {
                this.fetchIsimRecords();
            }
        }
    }

    private void broadcastRefresh() {
        Intent intent = new Intent(INTENT_ISIM_REFRESH);
        this.log("send ISim REFRESH: com.android.intent.isim_refresh");
        this.mContext.sendBroadcast(intent);
    }

    @Override
    public String getIsimImpi() {
        return this.mIsimImpi;
    }

    @Override
    public String getIsimDomain() {
        return this.mIsimDomain;
    }

    @Override
    public String[] getIsimImpu() {
        return this.mIsimImpu != null ? (String[])this.mIsimImpu.clone() : null;
    }

    @Override
    public String getIsimIst() {
        return this.mIsimIst;
    }

    @Override
    public String[] getIsimPcscf() {
        return this.mIsimPcscf != null ? (String[])this.mIsimPcscf.clone() : null;
    }

    @Override
    public void onReady() {
        this.fetchIsimRecords();
    }

    @Override
    public void onRefresh(boolean fileChanged, int[] fileList) {
        if (fileChanged) {
            this.fetchIsimRecords();
        }
    }

    @Override
    public void setVoiceMailNumber(String alphaTag, String voiceNumber, Message onComplete) {
    }

    @Override
    public void setVoiceMessageWaiting(int line, int countWaiting) {
    }

    @Override
    @UnsupportedAppUsage
    protected void log(String s) {
        Rlog.d(LOG_TAG, "[ISIM] " + s);
    }

    @Override
    protected void loge(String s) {
        Rlog.e(LOG_TAG, "[ISIM] " + s);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("IsimRecords: " + this);
        pw.println(" extends:");
        super.dump(fd, pw, args);
        pw.flush();
    }

    @Override
    public int getVoiceMessageCount() {
        return 0;
    }

    static /* synthetic */ String[] access$702(IsimUiccRecords x0, String[] x1) {
        x0.mIsimImpu = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1002(IsimUiccRecords x0, String[] x1) {
        x0.mIsimPcscf = x1;
        return x1;
    }

    private class EfIsimPcscfLoaded
    implements IccRecords.IccRecordLoaded {
        private EfIsimPcscfLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_ISIM_PCSCF";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            ArrayList pcscflist = (ArrayList)ar.result;
            IsimUiccRecords.this.log("EF_PCSCF record count: " + pcscflist.size());
            IsimUiccRecords.access$1002(IsimUiccRecords.this, new String[pcscflist.size()]);
            int i = 0;
            for (byte[] identity : pcscflist) {
                String pcscf = IsimUiccRecords.isimTlvToString(identity);
                ((IsimUiccRecords)IsimUiccRecords.this).mIsimPcscf[i++] = pcscf;
            }
        }
    }

    private class EfIsimIstLoaded
    implements IccRecords.IccRecordLoaded {
        private EfIsimIstLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_ISIM_IST";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            IsimUiccRecords.this.mIsimIst = IccUtils.bytesToHexString(data);
        }
    }

    private class EfIsimDomainLoaded
    implements IccRecords.IccRecordLoaded {
        private EfIsimDomainLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_ISIM_DOMAIN";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            IsimUiccRecords.this.mIsimDomain = IsimUiccRecords.isimTlvToString(data);
        }
    }

    private class EfIsimImpuLoaded
    implements IccRecords.IccRecordLoaded {
        private EfIsimImpuLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_ISIM_IMPU";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            ArrayList impuList = (ArrayList)ar.result;
            IsimUiccRecords.this.log("EF_IMPU record count: " + impuList.size());
            IsimUiccRecords.access$702(IsimUiccRecords.this, new String[impuList.size()]);
            int i = 0;
            for (byte[] identity : impuList) {
                String impu = IsimUiccRecords.isimTlvToString(identity);
                ((IsimUiccRecords)IsimUiccRecords.this).mIsimImpu[i++] = impu;
            }
        }
    }

    private class EfIsimImpiLoaded
    implements IccRecords.IccRecordLoaded {
        private EfIsimImpiLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_ISIM_IMPI";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            IsimUiccRecords.this.mIsimImpi = IsimUiccRecords.isimTlvToString(data);
        }
    }
}

