/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccProfile;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;

public class UiccCard {
    protected static final String LOG_TAG = "UiccCard";
    protected static final boolean DBG = true;
    public static final String EXTRA_ICC_CARD_ADDED = "com.android.internal.telephony.uicc.ICC_CARD_ADDED";
    @UnsupportedAppUsage
    protected final Object mLock;
    @UnsupportedAppUsage
    private IccCardStatus.CardState mCardState;
    private String mIccid;
    protected String mCardId;
    private UiccProfile mUiccProfile;
    @UnsupportedAppUsage
    private Context mContext;
    @UnsupportedAppUsage
    private CommandsInterface mCi;
    @UnsupportedAppUsage
    private final int mPhoneId;

    public UiccCard(Context c, CommandsInterface ci, IccCardStatus ics, int phoneId, Object lock) {
        this.log("Creating");
        this.mCardState = ics.mCardState;
        this.mPhoneId = phoneId;
        this.mLock = lock;
        this.update(c, ci, ics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mLock;
        synchronized (object) {
            this.log("Disposing card");
            if (this.mUiccProfile != null) {
                this.mUiccProfile.dispose();
            }
            this.mUiccProfile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Context c, CommandsInterface ci, IccCardStatus ics) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCardState = ics.mCardState;
            this.mContext = c;
            this.mCi = ci;
            this.mIccid = ics.iccid;
            this.updateCardId();
            if (this.mCardState != IccCardStatus.CardState.CARDSTATE_ABSENT) {
                if (this.mUiccProfile == null) {
                    this.mUiccProfile = TelephonyComponentFactory.getInstance().inject(UiccProfile.class.getName()).makeUiccProfile(this.mContext, this.mCi, ics, this.mPhoneId, this, this.mLock);
                } else {
                    this.mUiccProfile.update(this.mContext, this.mCi, ics);
                }
            } else {
                throw new RuntimeException("Card state is absent when updating!");
            }
        }
    }

    protected void finalize() {
        this.log("UiccCard finalized");
    }

    protected void updateCardId() {
        this.mCardId = this.mIccid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void registerForCarrierPrivilegeRulesLoaded(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccProfile != null) {
                this.mUiccProfile.registerForCarrierPrivilegeRulesLoaded(h, what, obj);
            } else {
                this.loge("registerForCarrierPrivilegeRulesLoaded Failed!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void unregisterForCarrierPrivilegeRulesLoaded(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccProfile != null) {
                this.mUiccProfile.unregisterForCarrierPrivilegeRulesLoaded(h);
            } else {
                this.loge("unregisterForCarrierPrivilegeRulesLoaded Failed!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public boolean isApplicationOnIcc(IccCardApplicationStatus.AppType type) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccProfile != null) {
                return this.mUiccProfile.isApplicationOnIcc(type);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public IccCardStatus.CardState getCardState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCardState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public IccCardStatus.PinState getUniversalPinState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccProfile != null) {
                return this.mUiccProfile.getUniversalPinState();
            }
            return IccCardStatus.PinState.PINSTATE_UNKNOWN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public UiccCardApplication getApplication(int family) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccProfile != null) {
                return this.mUiccProfile.getApplication(family);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public UiccCardApplication getApplicationIndex(int index) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccProfile != null) {
                return this.mUiccProfile.getApplicationIndex(index);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public UiccCardApplication getApplicationByType(int type) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccProfile != null) {
                return this.mUiccProfile.getApplicationByType(type);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean resetAppWithAid(String aid, boolean reset) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccProfile != null) {
                return this.mUiccProfile.resetAppWithAid(aid, reset);
            }
            return false;
        }
    }

    @Deprecated
    public void iccOpenLogicalChannel(String AID, int p2, Message response) {
        if (this.mUiccProfile != null) {
            this.mUiccProfile.iccOpenLogicalChannel(AID, p2, response);
        } else {
            this.loge("iccOpenLogicalChannel Failed!");
        }
    }

    @Deprecated
    public void iccCloseLogicalChannel(int channel, Message response) {
        if (this.mUiccProfile != null) {
            this.mUiccProfile.iccCloseLogicalChannel(channel, response);
        } else {
            this.loge("iccCloseLogicalChannel Failed!");
        }
    }

    @Deprecated
    public void iccTransmitApduLogicalChannel(int channel, int cla, int command, int p1, int p2, int p3, String data, Message response) {
        if (this.mUiccProfile != null) {
            this.mUiccProfile.iccTransmitApduLogicalChannel(channel, cla, command, p1, p2, p3, data, response);
        } else {
            this.loge("iccTransmitApduLogicalChannel Failed!");
        }
    }

    @Deprecated
    public void iccTransmitApduBasicChannel(int cla, int command, int p1, int p2, int p3, String data, Message response) {
        if (this.mUiccProfile != null) {
            this.mUiccProfile.iccTransmitApduBasicChannel(cla, command, p1, p2, p3, data, response);
        } else {
            this.loge("iccTransmitApduBasicChannel Failed!");
        }
    }

    @Deprecated
    public void iccExchangeSimIO(int fileID, int command, int p1, int p2, int p3, String pathID, Message response) {
        if (this.mUiccProfile != null) {
            this.mUiccProfile.iccExchangeSimIO(fileID, command, p1, p2, p3, pathID, response);
        } else {
            this.loge("iccExchangeSimIO Failed!");
        }
    }

    @Deprecated
    public void sendEnvelopeWithStatus(String contents, Message response) {
        if (this.mUiccProfile != null) {
            this.mUiccProfile.sendEnvelopeWithStatus(contents, response);
        } else {
            this.loge("sendEnvelopeWithStatus Failed!");
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public int getNumApplications() {
        if (this.mUiccProfile != null) {
            return this.mUiccProfile.getNumApplications();
        }
        return 0;
    }

    public int getPhoneId() {
        return this.mPhoneId;
    }

    public UiccProfile getUiccProfile() {
        return this.mUiccProfile;
    }

    @Deprecated
    public boolean areCarrierPriviligeRulesLoaded() {
        if (this.mUiccProfile != null) {
            return this.mUiccProfile.areCarrierPriviligeRulesLoaded();
        }
        return false;
    }

    @Deprecated
    public boolean hasCarrierPrivilegeRules() {
        if (this.mUiccProfile != null) {
            return this.mUiccProfile.hasCarrierPrivilegeRules();
        }
        return false;
    }

    @Deprecated
    public int getCarrierPrivilegeStatus(Signature signature, String packageName) {
        if (this.mUiccProfile != null) {
            return this.mUiccProfile.getCarrierPrivilegeStatus(signature, packageName);
        }
        return -1;
    }

    @Deprecated
    public int getCarrierPrivilegeStatus(PackageManager packageManager, String packageName) {
        if (this.mUiccProfile != null) {
            return this.mUiccProfile.getCarrierPrivilegeStatus(packageManager, packageName);
        }
        return -1;
    }

    @Deprecated
    public int getCarrierPrivilegeStatus(PackageInfo packageInfo) {
        if (this.mUiccProfile != null) {
            return this.mUiccProfile.getCarrierPrivilegeStatus(packageInfo);
        }
        return -1;
    }

    @Deprecated
    public int getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        if (this.mUiccProfile != null) {
            return this.mUiccProfile.getCarrierPrivilegeStatusForCurrentTransaction(packageManager);
        }
        return -1;
    }

    @Deprecated
    @UnsupportedAppUsage
    public List<String> getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        if (this.mUiccProfile != null) {
            return this.mUiccProfile.getCarrierPackageNamesForIntent(packageManager, intent);
        }
        return null;
    }

    @Deprecated
    public boolean setOperatorBrandOverride(String brand) {
        if (this.mUiccProfile != null) {
            return this.mUiccProfile.setOperatorBrandOverride(brand);
        }
        return false;
    }

    @Deprecated
    @UnsupportedAppUsage
    public String getOperatorBrandOverride() {
        if (this.mUiccProfile != null) {
            return this.mUiccProfile.getOperatorBrandOverride();
        }
        return null;
    }

    @UnsupportedAppUsage
    public String getIccId() {
        if (this.mIccid != null) {
            return this.mIccid;
        }
        if (this.mUiccProfile != null) {
            return this.mUiccProfile.getIccId();
        }
        return null;
    }

    public String getCardId() {
        if (!TextUtils.isEmpty(this.mCardId)) {
            return this.mCardId;
        }
        if (this.mUiccProfile != null) {
            return this.mUiccProfile.getIccId();
        }
        return null;
    }

    @UnsupportedAppUsage
    private void log(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    @UnsupportedAppUsage
    private void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("UiccCard:");
        pw.println(" mCi=" + this.mCi);
        pw.println(" mCardState=" + (Object)((Object)this.mCardState));
        pw.println(" mCardId=" + this.mCardId);
        pw.println(" mPhoneId=" + this.mPhoneId);
        pw.println();
        if (this.mUiccProfile != null) {
            this.mUiccProfile.dump(fd, pw, args);
        }
    }
}

