/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.annotation.UnsupportedAppUsage;
import android.app.BroadcastOptions;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.storage.StorageManager;
import android.preference.PreferenceManager;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.telephony.UiccCardInfo;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.RadioConfig;
import com.android.internal.telephony.SubscriptionInfoUpdater;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccSlotStatus;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccProfile;
import com.android.internal.telephony.uicc.UiccSlot;
import com.android.internal.telephony.uicc.UiccStateChangedLauncher;
import com.android.internal.telephony.uicc.euicc.EuiccCard;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class UiccController
extends Handler {
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String LOG_TAG = "UiccController";
    public static final int INVALID_SLOT_ID = -1;
    public static final int APP_FAM_3GPP = 1;
    public static final int APP_FAM_3GPP2 = 2;
    public static final int APP_FAM_IMS = 3;
    private static final int EVENT_ICC_STATUS_CHANGED = 1;
    private static final int EVENT_SLOT_STATUS_CHANGED = 2;
    private static final int EVENT_GET_ICC_STATUS_DONE = 3;
    private static final int EVENT_GET_SLOT_STATUS_DONE = 4;
    private static final int EVENT_RADIO_ON = 5;
    private static final int EVENT_RADIO_AVAILABLE = 6;
    private static final int EVENT_RADIO_UNAVAILABLE = 7;
    private static final int EVENT_SIM_REFRESH = 8;
    private static final int EVENT_EID_READY = 9;
    @UnsupportedAppUsage
    private CommandsInterface[] mCis;
    @VisibleForTesting
    public UiccSlot[] mUiccSlots;
    private int[] mPhoneIdToSlotId;
    private boolean mIsSlotStatusSupported = true;
    private ArrayList<String> mCardStrings;
    private int mDefaultEuiccCardId;
    private static final int TEMPORARILY_UNSUPPORTED_CARD_ID = -3;
    private static final int EID_LENGTH = 32;
    private static final String CARD_STRINGS = "card_strings";
    private static final String DEFAULT_CARD = "default_card";
    @UnsupportedAppUsage
    private static final Object mLock = new Object();
    @UnsupportedAppUsage
    private static UiccController mInstance;
    private static ArrayList<IccSlotStatus> sLastSlotStatus;
    @UnsupportedAppUsage
    @VisibleForTesting
    public Context mContext;
    protected RegistrantList mIccChangedRegistrants = new RegistrantList();
    private UiccStateChangedLauncher mLauncher;
    private RadioConfig mRadioConfig;
    static LocalLog sLocalLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UiccController make(Context c, CommandsInterface[] ci) {
        Object object = mLock;
        synchronized (object) {
            if (mInstance != null) {
                throw new RuntimeException("UiccController.make() should only be called once");
            }
            mInstance = new UiccController(c, ci);
            return mInstance;
        }
    }

    private UiccController(Context c, CommandsInterface[] ci) {
        this.log("Creating UiccController");
        this.mContext = c;
        this.mCis = ci;
        String logStr = "config_num_physical_slots = " + c.getResources().getInteger(17694871);
        this.log(logStr);
        sLocalLog.log(logStr);
        int numPhysicalSlots = c.getResources().getInteger(17694871);
        if (numPhysicalSlots < this.mCis.length) {
            numPhysicalSlots = this.mCis.length;
        }
        this.mUiccSlots = new UiccSlot[numPhysicalSlots];
        this.mPhoneIdToSlotId = new int[ci.length];
        Arrays.fill(this.mPhoneIdToSlotId, -1);
        this.mRadioConfig = RadioConfig.getInstance(this.mContext);
        this.mRadioConfig.registerForSimSlotStatusChanged(this, 2, null);
        for (int i = 0; i < this.mCis.length; ++i) {
            this.mCis[i].registerForIccStatusChanged(this, 1, i);
            if (!StorageManager.inCryptKeeperBounce()) {
                this.mCis[i].registerForAvailable(this, 6, i);
            } else {
                this.mCis[i].registerForOn(this, 5, i);
            }
            this.mCis[i].registerForNotAvailable(this, 7, i);
            this.mCis[i].registerForIccRefresh(this, 8, i);
        }
        this.mLauncher = new UiccStateChangedLauncher(c, this);
        this.mCardStrings = this.loadCardStrings();
        this.mDefaultEuiccCardId = -2;
    }

    public int getPhoneIdFromSlotId(int slotId) {
        for (int i = 0; i < this.mPhoneIdToSlotId.length; ++i) {
            if (this.mPhoneIdToSlotId[i] != slotId) continue;
            return i;
        }
        return -1;
    }

    public int getSlotIdFromPhoneId(int phoneId) {
        try {
            return this.mPhoneIdToSlotId[phoneId];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static UiccController getInstance() {
        Object object = mLock;
        synchronized (object) {
            if (mInstance == null) {
                throw new RuntimeException("UiccController.getInstance can't be called before make()");
            }
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public UiccCard getUiccCard(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            return this.getUiccCardForPhone(phoneId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCard getUiccCardForSlot(int slotId) {
        Object object = mLock;
        synchronized (object) {
            UiccSlot uiccSlot = this.getUiccSlot(slotId);
            if (uiccSlot != null) {
                return uiccSlot.getUiccCard();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCard getUiccCardForPhone(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            UiccSlot uiccSlot;
            if (this.isValidPhoneIndex(phoneId) && (uiccSlot = this.getUiccSlotForPhone(phoneId)) != null) {
                return uiccSlot.getUiccCard();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccProfile getUiccProfileForPhone(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            if (this.isValidPhoneIndex(phoneId)) {
                UiccCard uiccCard = this.getUiccCardForPhone(phoneId);
                UiccProfile uiccProfile = uiccCard != null ? uiccCard.getUiccProfile() : null;
                return uiccProfile;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccSlot[] getUiccSlots() {
        Object object = mLock;
        synchronized (object) {
            return this.mUiccSlots;
        }
    }

    public void switchSlots(int[] physicalSlots, Message response) {
        this.mRadioConfig.setSimSlotsMapping(physicalSlots, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccSlot getUiccSlot(int slotId) {
        Object object = mLock;
        synchronized (object) {
            if (this.isValidSlotIndex(slotId)) {
                return this.mUiccSlots[slotId];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccSlot getUiccSlotForPhone(int phoneId) {
        Object object = mLock;
        synchronized (object) {
            int slotId;
            if (this.isValidPhoneIndex(phoneId) && this.isValidSlotIndex(slotId = this.getSlotIdFromPhoneId(phoneId))) {
                return this.mUiccSlots[slotId];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUiccSlotForCardId(String cardId) {
        Object object = mLock;
        synchronized (object) {
            int idx;
            for (idx = 0; idx < this.mUiccSlots.length; ++idx) {
                UiccCard uiccCard;
                if (this.mUiccSlots[idx] == null || (uiccCard = this.mUiccSlots[idx].getUiccCard()) == null || !cardId.equals(uiccCard.getCardId())) continue;
                return idx;
            }
            for (idx = 0; idx < this.mUiccSlots.length; ++idx) {
                if (this.mUiccSlots[idx] == null || !cardId.equals(this.mUiccSlots[idx].getIccId())) continue;
                return idx;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public IccRecords getIccRecords(int phoneId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCardApplication app = this.getUiccCardApplication(phoneId, family);
            if (app != null) {
                return app.getIccRecords();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public IccFileHandler getIccFileHandler(int phoneId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCardApplication app = this.getUiccCardApplication(phoneId, family);
            if (app != null) {
                return app.getIccFileHandler();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void registerForIccChanged(Handler h, int what, Object obj) {
        Object object = mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mIccChangedRegistrants.add(r);
            r.notifyRegistrant();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForIccChanged(Handler h) {
        Object object = mLock;
        synchronized (object) {
            this.mIccChangedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        Object object = mLock;
        synchronized (object) {
            Integer phoneId = this.getCiIndex(msg);
            if (phoneId < 0 || phoneId >= this.mCis.length) {
                Rlog.e(LOG_TAG, "Invalid phoneId : " + phoneId + " received with event " + msg.what);
                return;
            }
            sLocalLog.log("handleMessage: Received " + msg.what + " for phoneId " + phoneId);
            AsyncResult ar = (AsyncResult)msg.obj;
            switch (msg.what) {
                case 1: {
                    this.log("Received EVENT_ICC_STATUS_CHANGED, calling getIccCardStatus");
                    this.mCis[phoneId].getIccCardStatus(this.obtainMessage(3, phoneId));
                    break;
                }
                case 5: 
                case 6: {
                    this.log("Received EVENT_RADIO_AVAILABLE/EVENT_RADIO_ON, calling getIccCardStatus");
                    this.mCis[phoneId].getIccCardStatus(this.obtainMessage(3, phoneId));
                    if (phoneId != 0) break;
                    this.log("Received EVENT_RADIO_AVAILABLE/EVENT_RADIO_ON for phoneId 0, calling getIccSlotsStatus");
                    this.mRadioConfig.getSimSlotsStatus(this.obtainMessage(4, phoneId));
                    break;
                }
                case 3: {
                    this.log("Received EVENT_GET_ICC_STATUS_DONE");
                    this.onGetIccCardStatusDone(ar, phoneId);
                    break;
                }
                case 2: 
                case 4: {
                    this.log("Received EVENT_SLOT_STATUS_CHANGED or EVENT_GET_SLOT_STATUS_DONE");
                    this.onGetSlotStatusDone(ar);
                    break;
                }
                case 7: {
                    this.log("EVENT_RADIO_UNAVAILABLE, dispose card");
                    UiccSlot uiccSlot = this.getUiccSlotForPhone(phoneId);
                    if (uiccSlot != null) {
                        uiccSlot.onRadioStateUnavailable();
                    }
                    this.mIccChangedRegistrants.notifyRegistrants(new AsyncResult(null, phoneId, null));
                    break;
                }
                case 8: {
                    this.log("Received EVENT_SIM_REFRESH");
                    this.onSimRefresh(ar, phoneId);
                    break;
                }
                case 9: {
                    this.log("Received EVENT_EID_READY");
                    this.onEidReady(ar, phoneId);
                    break;
                }
                default: {
                    Rlog.e(LOG_TAG, " Unknown Event " + msg.what);
                }
            }
        }
    }

    private Integer getCiIndex(Message msg) {
        Integer index = new Integer(0);
        if (msg != null) {
            if (msg.obj != null && msg.obj instanceof Integer) {
                index = (Integer)msg.obj;
            } else if (msg.obj != null && msg.obj instanceof AsyncResult) {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.userObj != null && ar.userObj instanceof Integer) {
                    index = (Integer)ar.userObj;
                }
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public UiccCardApplication getUiccCardApplication(int phoneId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCard uiccCard = this.getUiccCardForPhone(phoneId);
            if (uiccCard != null) {
                return uiccCard.getApplication(family);
            }
            return null;
        }
    }

    static String getIccStateIntentString(IccCardConstants.State state) {
        switch (state) {
            case ABSENT: {
                return "ABSENT";
            }
            case PIN_REQUIRED: {
                return "LOCKED";
            }
            case PUK_REQUIRED: {
                return "LOCKED";
            }
            case NETWORK_LOCKED: {
                return "LOCKED";
            }
            case READY: {
                return "READY";
            }
            case NOT_READY: {
                return "NOT_READY";
            }
            case PERM_DISABLED: {
                return "LOCKED";
            }
            case CARD_IO_ERROR: {
                return "CARD_IO_ERROR";
            }
            case CARD_RESTRICTED: {
                return "CARD_RESTRICTED";
            }
            case LOADED: {
                return "LOADED";
            }
        }
        return "UNKNOWN";
    }

    static void updateInternalIccState(Context context, IccCardConstants.State state, String reason, int phoneId) {
        UiccController.updateInternalIccState(context, state, reason, phoneId, false);
    }

    static void updateInternalIccState(Context context, IccCardConstants.State state, String reason, int phoneId, boolean absentAndInactive) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        telephonyManager.setSimStateForPhone(phoneId, state.toString());
        SubscriptionInfoUpdater subInfoUpdator = PhoneFactory.getSubscriptionInfoUpdater();
        if (subInfoUpdator != null) {
            subInfoUpdator.updateInternalIccState(UiccController.getIccStateIntentString(state), reason, phoneId, absentAndInactive);
        } else {
            Rlog.e(LOG_TAG, "subInfoUpdate is null.");
        }
    }

    private synchronized void onGetIccCardStatusDone(AsyncResult ar, Integer index) {
        if (ar.exception != null) {
            Rlog.e(LOG_TAG, "Error getting ICC status. RIL_REQUEST_GET_ICC_STATUS should never return an error", ar.exception);
            return;
        }
        if (!this.isValidPhoneIndex(index)) {
            Rlog.e(LOG_TAG, "onGetIccCardStatusDone: invalid index : " + index);
            return;
        }
        IccCardStatus status = (IccCardStatus)ar.result;
        sLocalLog.log("onGetIccCardStatusDone: phoneId " + index + " IccCardStatus: " + status);
        int slotId = status.physicalSlotIndex;
        if (slotId == -1) {
            slotId = index;
        }
        if (this.eidIsNotSupported(status)) {
            this.log("eid is not supported");
            this.mDefaultEuiccCardId = -1;
        }
        this.mPhoneIdToSlotId[index.intValue()] = slotId;
        if (this.mUiccSlots[slotId] == null) {
            this.mUiccSlots[slotId] = new UiccSlot(this.mContext, true);
        }
        this.mUiccSlots[slotId].update(this.mCis[index], status, index, slotId);
        UiccCard card = this.mUiccSlots[slotId].getUiccCard();
        if (card == null) {
            this.log("mUiccSlots[" + slotId + "] has no card. Notifying IccChangedRegistrants");
            this.mIccChangedRegistrants.notifyRegistrants(new AsyncResult(null, index, null));
            return;
        }
        String cardString = null;
        boolean isEuicc = this.mUiccSlots[slotId].isEuicc();
        cardString = isEuicc ? ((EuiccCard)card).getEid() : card.getIccId();
        if (isEuicc && cardString == null && this.mDefaultEuiccCardId != -1) {
            ((EuiccCard)card).registerForEidReady(this, 9, index);
        }
        if (cardString != null) {
            this.addCardId(cardString);
        }
        this.log("Notifying IccChangedRegistrants");
        this.mIccChangedRegistrants.notifyRegistrants(new AsyncResult(null, index, null));
    }

    private boolean eidIsNotSupported(IccCardStatus status) {
        return status.physicalSlotIndex == -1;
    }

    private void addCardId(String cardString) {
        if (TextUtils.isEmpty(cardString)) {
            return;
        }
        if (cardString.length() < 32) {
            cardString = IccUtils.stripTrailingFs(cardString);
        }
        if (!this.mCardStrings.contains(cardString)) {
            this.mCardStrings.add(cardString);
            this.saveCardStrings();
        }
    }

    public int convertToPublicCardId(String cardString) {
        int id2;
        if (this.mDefaultEuiccCardId == -1) {
            return -1;
        }
        if (TextUtils.isEmpty(cardString)) {
            return -2;
        }
        if (cardString.length() < 32) {
            cardString = IccUtils.stripTrailingFs(cardString);
        }
        if ((id2 = this.mCardStrings.indexOf(cardString)) == -1) {
            return -2;
        }
        return id2;
    }

    public ArrayList<UiccCardInfo> getAllUiccCardInfos() {
        ArrayList<UiccCardInfo> infos = new ArrayList<UiccCardInfo>();
        for (int slotIndex = 0; slotIndex < this.mUiccSlots.length; ++slotIndex) {
            UiccSlot slot = this.mUiccSlots[slotIndex];
            if (slot == null) continue;
            boolean isEuicc = slot.isEuicc();
            String eid = null;
            UiccCard card = slot.getUiccCard();
            String iccid = null;
            int cardId = -2;
            boolean isRemovable = slot.isRemovable();
            if (card != null) {
                iccid = card.getIccId();
                if (isEuicc) {
                    eid = ((EuiccCard)card).getEid();
                    cardId = this.convertToPublicCardId(eid);
                } else {
                    cardId = this.convertToPublicCardId(iccid);
                }
            } else {
                iccid = slot.getIccId();
                if (!isEuicc && !TextUtils.isEmpty(iccid)) {
                    cardId = this.convertToPublicCardId(iccid);
                }
            }
            UiccCardInfo info = new UiccCardInfo(isEuicc, cardId, eid, IccUtils.stripTrailingFs(iccid), slotIndex, isRemovable);
            infos.add(info);
        }
        return infos;
    }

    public int getCardIdForDefaultEuicc() {
        if (this.mDefaultEuiccCardId == -3) {
            return -1;
        }
        return this.mDefaultEuiccCardId;
    }

    private ArrayList<String> loadCardStrings() {
        String cardStrings = PreferenceManager.getDefaultSharedPreferences(this.mContext).getString(CARD_STRINGS, "");
        if (TextUtils.isEmpty(cardStrings)) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(cardStrings.split(",")));
    }

    private void saveCardStrings() {
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.mContext).edit();
        editor.putString(CARD_STRINGS, TextUtils.join((CharSequence)",", this.mCardStrings));
        editor.commit();
    }

    private synchronized void onGetSlotStatusDone(AsyncResult ar) {
        if (!this.mIsSlotStatusSupported) {
            return;
        }
        Throwable e = ar.exception;
        if (e != null) {
            if (!(e instanceof CommandException) || ((CommandException)e).getCommandError() != CommandException.Error.REQUEST_NOT_SUPPORTED) {
                String logStr = "Unexpected error getting slot status: " + ar.exception;
                Rlog.e(LOG_TAG, logStr);
                sLocalLog.log(logStr);
            } else {
                String logStr = "onGetSlotStatusDone: request not supported; marking mIsSlotStatusSupported to false";
                this.log(logStr);
                sLocalLog.log(logStr);
                this.mIsSlotStatusSupported = false;
            }
            return;
        }
        ArrayList status = (ArrayList)ar.result;
        if (!this.slotStatusChanged(status)) {
            this.log("onGetSlotStatusDone: No change in slot status");
            return;
        }
        sLastSlotStatus = status;
        int numActiveSlots = 0;
        boolean isDefaultEuiccCardIdSet = false;
        boolean anyEuiccIsActive = false;
        boolean hasEuicc = false;
        for (int i = 0; i < status.size(); ++i) {
            String eid;
            int isActive;
            IccSlotStatus iss = (IccSlotStatus)status.get(i);
            int n = isActive = iss.slotState == IccSlotStatus.SlotState.SLOTSTATE_ACTIVE ? 1 : 0;
            if (isActive != 0) {
                ++numActiveSlots;
                if (!this.isValidPhoneIndex(iss.logicalSlotIndex)) {
                    Rlog.e(LOG_TAG, "Skipping slot " + i + " as phone " + iss.logicalSlotIndex + " is not available to communicate with this slot");
                } else {
                    this.mPhoneIdToSlotId[iss.logicalSlotIndex] = i;
                }
            }
            if (this.mUiccSlots[i] == null) {
                this.mUiccSlots[i] = new UiccSlot(this.mContext, isActive != 0);
            }
            if (!this.isValidPhoneIndex(iss.logicalSlotIndex)) {
                this.mUiccSlots[i].update(null, iss, i);
            } else {
                this.mUiccSlots[i].update(isActive != 0 ? this.mCis[iss.logicalSlotIndex] : null, iss, i);
            }
            if (!this.mUiccSlots[i].isEuicc()) continue;
            hasEuicc = true;
            if (isActive != 0) {
                anyEuiccIsActive = true;
            }
            if (TextUtils.isEmpty(eid = iss.eid)) continue;
            this.addCardId(eid);
            if (isDefaultEuiccCardIdSet) continue;
            isDefaultEuiccCardIdSet = true;
            this.mDefaultEuiccCardId = this.convertToPublicCardId(eid);
            this.log("Using eid=" + eid + " in slot=" + i + " to set mDefaultEuiccCardId=" + this.mDefaultEuiccCardId);
        }
        if (hasEuicc && !anyEuiccIsActive && !isDefaultEuiccCardIdSet) {
            this.log("onGetSlotStatusDone: setting TEMPORARILY_UNSUPPORTED_CARD_ID");
            this.mDefaultEuiccCardId = -3;
        }
        if (numActiveSlots != this.mPhoneIdToSlotId.length) {
            Rlog.e(LOG_TAG, "Number of active slots " + numActiveSlots + " does not match the number of Phones" + this.mPhoneIdToSlotId.length);
        }
        HashSet<Integer> slotIds = new HashSet<Integer>();
        for (Object slotId : (IccSlotStatus)this.mPhoneIdToSlotId) {
            if (slotIds.contains((int)slotId)) {
                throw new RuntimeException("slotId " + (int)slotId + " mapped to multiple phoneIds");
            }
            slotIds.add((int)slotId);
        }
        BroadcastOptions options = BroadcastOptions.makeBasic();
        options.setBackgroundActivityStartsAllowed(true);
        Intent intent = new Intent("android.telephony.action.SIM_SLOT_STATUS_CHANGED");
        intent.addFlags(0x4000000);
        intent.addFlags(0x1000000);
        this.mContext.sendBroadcast(intent, "android.permission.READ_PRIVILEGED_PHONE_STATE", options.toBundle());
    }

    private boolean slotStatusChanged(ArrayList<IccSlotStatus> slotStatusList) {
        if (sLastSlotStatus == null || sLastSlotStatus.size() != slotStatusList.size()) {
            return true;
        }
        for (IccSlotStatus iccSlotStatus : slotStatusList) {
            if (sLastSlotStatus.contains(iccSlotStatus)) continue;
            return true;
        }
        return false;
    }

    private void logPhoneIdToSlotIdMapping() {
        this.log("mPhoneIdToSlotId mapping:");
        for (int i = 0; i < this.mPhoneIdToSlotId.length; ++i) {
            this.log("    phoneId " + i + " slotId " + this.mPhoneIdToSlotId[i]);
        }
    }

    private void onSimRefresh(AsyncResult ar, Integer index) {
        if (ar.exception != null) {
            Rlog.e(LOG_TAG, "onSimRefresh: Sim REFRESH with exception: " + ar.exception);
            return;
        }
        if (!this.isValidPhoneIndex(index)) {
            Rlog.e(LOG_TAG, "onSimRefresh: invalid index : " + index);
            return;
        }
        IccRefreshResponse resp = (IccRefreshResponse)ar.result;
        this.log("onSimRefresh: " + resp);
        sLocalLog.log("onSimRefresh: " + resp);
        if (resp == null) {
            Rlog.e(LOG_TAG, "onSimRefresh: received without input");
            return;
        }
        UiccCard uiccCard = this.getUiccCardForPhone(index);
        if (uiccCard == null) {
            Rlog.e(LOG_TAG, "onSimRefresh: refresh on null card : " + index);
            return;
        }
        boolean changed = false;
        switch (resp.refreshResult) {
            case 2: {
                changed = uiccCard.resetAppWithAid(resp.aid, true);
                break;
            }
            case 1: {
                changed = uiccCard.resetAppWithAid(resp.aid, false);
                break;
            }
            default: {
                return;
            }
        }
        if (changed && resp.refreshResult == 2) {
            CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
            configManager.updateConfigForPhoneId(index, "UNKNOWN");
            boolean requirePowerOffOnSimRefreshReset = this.mContext.getResources().getBoolean(17891499);
            if (requirePowerOffOnSimRefreshReset) {
                this.mCis[index].setRadioPower(false, null);
            }
        }
        this.mCis[index].getIccCardStatus(this.obtainMessage(3, index));
    }

    private void onEidReady(AsyncResult ar, Integer index) {
        if (ar.exception != null) {
            Rlog.e(LOG_TAG, "onEidReady: exception: " + ar.exception);
            return;
        }
        if (!this.isValidPhoneIndex(index)) {
            Rlog.e(LOG_TAG, "onEidReady: invalid index: " + index);
            return;
        }
        int slotId = this.mPhoneIdToSlotId[index];
        UiccCard card = this.mUiccSlots[slotId].getUiccCard();
        if (card == null) {
            Rlog.e(LOG_TAG, "onEidReady: UiccCard in slot " + slotId + " is null");
            return;
        }
        String eid = ((EuiccCard)card).getEid();
        this.addCardId(eid);
        if (this.mDefaultEuiccCardId == -2 || this.mDefaultEuiccCardId == -3) {
            this.mDefaultEuiccCardId = this.convertToPublicCardId(eid);
            this.log("onEidReady: eid=" + eid + " slot=" + slotId + " mDefaultEuiccCardId=" + this.mDefaultEuiccCardId);
        }
        ((EuiccCard)card).unregisterForEidReady(this);
    }

    public static boolean isCdmaSupported(Context context) {
        PackageManager packageManager = context.getPackageManager();
        boolean isCdmaSupported = packageManager.hasSystemFeature("android.hardware.telephony.cdma");
        return isCdmaSupported;
    }

    private boolean isValidPhoneIndex(int index) {
        return index >= 0 && index < TelephonyManager.getDefault().getPhoneCount();
    }

    private boolean isValidSlotIndex(int index) {
        return index >= 0 && index < this.mUiccSlots.length;
    }

    @UnsupportedAppUsage
    private void log(String string2) {
        Rlog.d(LOG_TAG, string2);
    }

    public void addCardLog(String data) {
        sLocalLog.log(data);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("UiccController: " + this);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mInstance=" + mInstance);
        pw.println(" mIccChangedRegistrants: size=" + this.mIccChangedRegistrants.size());
        for (i = 0; i < this.mIccChangedRegistrants.size(); ++i) {
            pw.println("  mIccChangedRegistrants[" + i + "]=" + ((Registrant)this.mIccChangedRegistrants.get(i)).getHandler());
        }
        pw.println();
        pw.flush();
        pw.println(" mIsCdmaSupported=" + UiccController.isCdmaSupported(this.mContext));
        pw.println(" mUiccSlots: size=" + this.mUiccSlots.length);
        pw.println(" mCardStrings=" + this.mCardStrings);
        pw.println(" mDefaultEuiccCardId=" + this.mDefaultEuiccCardId);
        for (i = 0; i < this.mUiccSlots.length; ++i) {
            if (this.mUiccSlots[i] == null) {
                pw.println("  mUiccSlots[" + i + "]=null");
                continue;
            }
            pw.println("  mUiccSlots[" + i + "]=" + this.mUiccSlots[i]);
            this.mUiccSlots[i].dump(fd, pw, args);
        }
        pw.println(" sLocalLog= ");
        sLocalLog.dump(fd, pw, args);
    }

    static {
        sLocalLog = new LocalLog(100);
    }
}

